<?php

namespace App\Http\Controllers\Site\StudentPanel;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use App\Traits\TransactionCheckApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Traits\Site\Fee\StudentFeeTrait;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Storage;
use Session;
use Response;
use File;
use Error;
use PDF;

class StudentController extends ProjectController
{
    use TransactionCheckApiTrait, PaymentGatewayTrait, StudentFeeTrait;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('siteStudentchecker');
        
    }

    public function testingpaymentpage()
    {
        $viewType = 'Student Payment';

        $student_id = Auth::user()->id;
        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',1)->pluck('id');
        $demanSlipDetails=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
            ->where('status',1)
            ->orderBy('id', 'desc')
            ->first();

           

        if(!$demanSlipDetails){
            return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }

        $data = $this->getDemandSlipDetails($demanSlipDetails);
      
        $slip_no=$data['slip_no'];
        $total_amount=$data['total_amount'];

        if ($data){
            return view('default.admin.students.bkash-payment', compact('viewType', 'slip_no', 'total_amount'));
        }else{
            throw new Error('There is no payable amount!');
        }

     
    }


    public function index()
    {

      //  dd('sfsf');
        $viewType = 'Student Payment';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function payment()
    {


       // dd( $this->getIndianCurrency(1150));


        /*
         partnercode/shortcode: comma
        UserName: comma
        password: comma@SureC@sh

        partnercode/shortcode: comia
        UserName: cgcommia
        password: cgcommia@SureC@sh

        partnercode/shortcode: comha
        username: cgcomha
        password: cgcomha&SureC@ash

       RB00422551103---comma
       RB00330328730---comia
       RB00330328730--comha

        $partner_code = 'comma';// "TRA";//"T300000199063, T300000198366";
        $transaction_id = 'RB00413751440';//"T300000199063";
        */
        $req_data = [
            "edu_user_name" => '8989898',//send a unique id if username not available
            "bearer_type" => 'site',//send a unique id if username not available
            "bearer_id" => 10,//send a unique id if username not available RB00501481124 RB00501741806 RB00501481512
            "partner_code" => 'comia',
            "transaction_id" => 'RB00501896075',
            "user_name" => 'cgcommia',
            "password" => 'cgcommia@SureC@sh'
        ];


        $responses = $this->verifyOnlineTransId($req_data);
//        dd($responses);
        $viewType = 'Student Payment';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function paymentMethodList()
    {
        $payment_method_keys = SitePaymentGateway::where('status',true)->pluck('academic_payment_method_key');
        $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)->get();
        return $payment_method_list;
    }

    public function paymentDemandSlipDetails()
    {
//        return 'ok';
        $student_id = Auth::user()->id;
        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',true)->pluck('id');
       
        $demanSlipDetails = SiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
                $query->whereIn('student_history_id', $studentHistoryIDList)
                    ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
                })
                ->where('status', 1)
                ->orderBy('id', 'desc')
                ->first();
     
          //  dd($demanSlipDetails);
        if(!$demanSlipDetails){
            return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }

        $site_id=$demanSlipDetails->id;

        $data = $this->getGatewayStudentFeeDetails($site_id,$demanSlipDetails);
     //   $data = $this->getDemandSlipDetails($demanSlipDetails);

      //  dd($data);

        if ($data){
            return $data;
        }else{
            throw new Error('There is no payable amount!');
        }
    }

    public function getPaymentMarchentDetails($name_key)
    {
//        return $name_key;
        $payment_gateway = '';
        if($name_key == 'nagad'){
            $payment_gateway = SitePaymentGateway::where('academic_payment_method_key', $name_key)
                ->whereHas('academicOnlinePaymentMarchentType', function($query){
                    $query->where('name_key', 'normal_marchent');
                })
                ->with('academicOnlinePaymentMarchentType')
                ->first();

        }
        return $payment_gateway;

    }

    public function getPaymentFeeDetails()
    {
        try{

            $auth= Auth::user();
            $student_id = $auth->id;
            $site_id = $auth->site_id;
            $siteInfo= GlobalSiteInfo::where('id',$site_id)->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')->first();
            $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->pluck('id');
            $demand_slip=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                ->where('status',1)
                ->orderBy('id', 'desc')
                ->first();
    
            $final_data = [];

            if($demand_slip){
                $final_data=$this->studentSlipDetails($demand_slip->id);
                return ['fee_data'=>$final_data['fee_data'],'siteInfo'=>$siteInfo];
            }

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }


    }

    public function getStudentBankSlipPdf()
    {
        $auth= Auth::user();
        $student_id = $auth->id;
        $site_id = $auth->site_id;

        $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',true)->pluck('id');
        // $demand_slip=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
        //     ->where('status',1)
        //     ->orderBy('id', 'desc')
        //     ->first();

        
        $demand_slip = SiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
            $query->whereIn('student_history_id', $studentHistoryIDList)
                ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
            })
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->first();

        if(!$demand_slip){
            return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }

        $studentSlip=$this->studentSlipDetails($demand_slip->id);
       
        $student_info = $studentSlip['student_info'];
        $fee_data = $studentSlip['fee_data'];
        $title_view = 'Demand Slip';
    //    $slip_quantity = [1,2,3];
        $slip_quantity = [1,2];
    
           $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf',
                    compact('title_view','slip_quantity','fee_data','student_info','siteInfo'));
        return $pdf->stream(time() . '-student-payment-bank-slip.pdf');


    }

    // public function getDemandSlipFeeDetails($demand_slip_id){


    //     $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $demand_slip_id)->first();

    //     $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
    //     $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

    //     $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
    //     $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

    //     //==================Fee List=========
    //     $fee_allocation_details_array = [];
    //     $fee_allocation_details_arr = Array();
    //     foreach ($fee_generate_list as $key => $value){

    //         $fee_allocation_detail= SiteStudentFeeFineAllocation::
    //         with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
    //             ->where('id',$value->site_student_fee_fine_allocation_id)->first();


    //         if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
    //             $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
    //             $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

    //         }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
    //             $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
    //             $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

    //         }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
    //             $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
    //             $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

    //         }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
    //             $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
    //             $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
    //         }

    //         $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
    //         $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;

    //         $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());

    //     }

    //     $fee_allocation_details=collect($fee_allocation_details_array);

    //     $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

    //     //==================Waiver List =========
    //     $waiver_allocation_details_array = [];
    //     $waiver_allocation_details_arr = Array();
    //     foreach ($waiver_generate_list as $key => $value){


    //         if($value->site_student_fee_fine_allocation_id){


    //             $waiver_allocation_detail= SiteStudentFeeFineAllocation::
    //             with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
    //                 ->where('id',$value->site_student_fee_fine_allocation_id)->first();


    //             if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
    //                 $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
    //                 $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

    //             }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
    //                 $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
    //                 $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

    //             }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
    //                 $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
    //                 $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

    //             }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
    //                 $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
    //                 $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
    //             }


    //             $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
    //             $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


    //             $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
    //         }

    //     }


    //     $waiver_allocation=collect($waiver_allocation_details_array);

    //     $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);


    //     $finalArray=compact('fee_allocation_details_list', 'waiver_allocation_details');

    //     return $finalArray;
    // }

//     private function feeHeadSubHeadTypeMultiStemArray($fee_allocation_details){

// //        return $fee_allocation_details;
//         $head_Id=$fee_allocation_details->pluck('academic_fee_head.id')->unique()->values();
//         $fee_head_list=AcademicFeeHead::get();


//         $fee_head_arr=Array();
//         $fee_head_array=[];
//         foreach ($head_Id as $key => $value){

//             $head_list=$fee_head_list->where('id',$value)->first();

//             $fee_head_arr['id']=$value;
//             $fee_head_arr['name']=$head_list->name;


//             $fee_head_pre_array=[];
//             foreach ($fee_allocation_details as $keys => $values){
//                 if($value==$values['academic_fee_head']['id']){

//                     $fee_head_pre_array[$keys]=$values;
//                 }
//             }

//             $fee_head_pre_array_collect=collect($fee_head_pre_array)->values();
//             $fee_head_pre_array_collect_id= $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();


//             $fee_head_type_arr=Array();
//             $fee_head_type_array=[];
//             $sub_head_full_count=[];
//             foreach ($fee_head_pre_array_collect_id as $keyt => $valuet){

//                 $fee_head_type_listt=$fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();
// //                return $fee_head_type_listt;

//                 $fee_head_type_arr['fee_type_id']=$valuet;
//                 $fee_head_type_arr['fee_type_name']=$fee_head_type_listt['fee_type_name'];


//                 $fee_head_type_pre_array=[];
                
//                 foreach ($fee_head_pre_array_collect as $keytt => $valuett){

//                     if($valuet==$valuett['fee_head_type_id']){
//                         $fee_head_type_pre_array[$keytt]=$valuett;
//                     }
//                 }

//                 $fee_head_type_arr['fee_sub_head_count']=count($fee_head_type_pre_array);
//                 $fee_head_type_arr['fee_sub_head']=$fee_head_type_pre_array;

//                 $sub_head_full_count[$keyt]=count($fee_head_type_pre_array);

//                 $fee_head_type_array[$keyt]=array_merge($fee_head_type_arr);

//             }

//             $fee_head_arr['head_type_base_sub_head_count']=array_sum($sub_head_full_count);
//             $fee_head_arr['head_type']=$fee_head_type_array;

//             $fee_head_array[$key]=array_merge($fee_head_arr);
//         }
//         $fee_allocation_details_list=collect($fee_head_array);

//         return $fee_allocation_details_list;
//     }




    function getIndianCurrency(float $number)
    {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $decimal_part = $decimal;
        $hundred = null;
        $hundreds = null;
        $digits_length = strlen($no);
        $decimal_length = strlen($decimal);
        $i = 0;
        $str = array();
        $str2 = array();
        $words = array(0 => '', 1 => 'one', 2 => 'two',
            3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
            7 => 'seven', 8 => 'eight', 9 => 'nine',
            10 => 'ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred','thousand','lakh', 'crore');

        while( $i < $digits_length ) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number].' '. $digits[$counter]. $plural.' '.$hundred:$words[floor($number / 10) * 10].' '.$words[$number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str[] = null;
        }

        $d = 0;
        while( $d < $decimal_length ) {
            $divider = ($d == 2) ? 10 : 100;
            $decimal_number = floor($decimal % $divider);
            $decimal = floor($decimal / $divider);
            $d += $divider == 10 ? 1 : 2;
            if ($decimal_number) {
                $plurals = (($counter = count($str2)) && $decimal_number > 9) ? 's' : null;
                $hundreds = ($counter == 1 && $str2[0]) ? ' and ' : null;
                @$str2 [] = ($decimal_number < 21) ? $words[$decimal_number].' '. $digits[$decimal_number]. $plural.' '.$hundred:$words[floor($decimal_number / 10) * 10].' '.$words[$decimal_number % 10]. ' '.$digits[$counter].$plural.' '.$hundred;
            } else $str2[] = null;
        }

        $Rupees = implode('', array_reverse($str));
        $paise = implode('', array_reverse($str2));
        $paise = ($decimal_part > 0) ? $paise . ' Paise' : '';
        return ($Rupees ? $Rupees . 'Rupees ' : '') . $paise;
    }


    public function getPaymentStatusMessage(){
        $viewType = 'Student Payment';
        return view('default.admin.layouts.master', compact('viewType'));
    }
}
