<?php

namespace App\Http\Controllers\Site\StudentAdmission;

use App\Imports\Site\SiteAdmissionRollImport;
use App\Models\Academic\AcademicBank;
use App\Models\Academic\AcademicBoard;
use App\Models\Site\SiteClassSessionSerialSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionBoardApproveExcel;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclare;
use App\Http\Controllers\ProjectController;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicVersion;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\SiteInfo;
use App\Models\Site\StudentAdmission\GlobalSiteStudentAdmissionBoardApprove;
use App\Models\Site\StudentAdmission\SiteAdmissionFeeSubHeadAllocation;
use App\Models\Site\StudentAdmission\GlobalSiteAdmissionPaymentHistory;
use App\Models\Site\StudentAdmission\SiteAdmissionPaymentHistory;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionDeclareOnlineApi;
use App\Models\Site\StudentAdmission\SiteStudentAdmissionFeeGenerate;
use App\Models\Student\StudentHistory;
use App\Traits\Site\Fee\AdmissionFeeTrait;
use App\Traits\Site\Fee\SonaliPayAdmissionFeeTrait;
use Illuminate\Http\JsonResponse;
use Exception;
use Illuminate\Validation\ValidationException;
use Maatwebsite\Excel\Facades\Excel;
use Session;
use Response;
use Carbon\Carbon;
use PDF;

class SiteBaseBoardSelectedStudentAdmissionController extends ProjectController
{

    use SonaliPayAdmissionFeeTrait, AdmissionFeeTrait;

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }


    public function index()
    {
        $viewType = 'Student Admission Declaration Page';
        return view('default.admin.layouts.master', compact('viewType'));

    }

    public function siteStudentAdmissionInsideForm(){
        $viewType = 'Student Admission Form';
        return view('default.admin.layouts.master', compact('viewType'));
    }


//    Roll Reg Validation


    /**
     * @param $group_id
     * @return \Illuminate\Database\Eloquent\Model|null|object|static
     */


     public function getBlankStudentListForQuickInsert1(Request $request){

        $valiedation=$this->classGroupSectionValidation($request);
        if($valiedation){
            return $valiedation;
        }

        $insert_number=2;

        for($i=1;$i<=$insert_number;$i++){

            $student_array[]=

                    [
                        'id'=>0,
                        'first_name'=>null,
                        'last_name'=>null,
                        'father_name'=>null,
                        'mother_name'=>null,
                        'date_of_birth'=>null,
                        'gender_id'=>0,
                        'religion_id'=>0,
                        'blood_group_id'=>0,
                        'student_roll_number'=>null,

                        'duplicate_value'=>false,

                        'first_name_required'=>false,
                        'father_name_required'=>false,
                        'mother_name_required'=>false,
                        'waiver_amount'=>false,
                      //  'total_fee_with_other'=>false,
                       // 'transection_number'=>false,

                    ];
                }




        return response()->json(
            [
                'student_list'=>$student_array,
            ]);
    }

    public function getAdmissionDeclareForm(){
        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->get();

        return response()->json($admission_declare_list);
    }


     public function getRollRegistrationEntryListForAdmission(Request $request){

        // $this->validate($request, [
        //     "academic_version_id" => "required",
        //     "academic_year_id" => "required",
        //     "academic_shift_id" => "required",
        //     "academic_class_id" => "required",
        //     "academic_class_group_id" => count($request->AcademicClassGroupList) > 0 ? "required" : "",
        //     "academic_session_id" => count($request->AcademicSessionList) > 0 ? "required" : "",
        // ]);


        $checked_value=$this->checkAdmissionDeclare($request);

      //  dd($checked_value);

        $admission_declare_list=SiteStudentAdmissionDeclare::where('id',$request->admission_declare_id)->where('status', true)->first();

        if($checked_value[0] && $checked_value[1] && $checked_value[2] && $checked_value[3]){

            $data=$request->all();

            $check_data_present=SiteStudentAdmissionBoardApprove::where('academic_version_id', $request->academic_version_id)
                   ->where('site_student_admission_declare_id', $admission_declare_list->id)
                    ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                        return $query->where('academic_year_id', $data['academic_year_id']);
                    })
                    ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                        return $query->where('academic_shift_id', $data['academic_shift_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when($data['payment_status']!=2, function ($query) use ($data) {
                        return $query->where('payment_status', $data['payment_status']);
                    })
                    ->when($data['admission_status']!=2, function ($query) use ($data) {
                        return $query->where('admission_status', $data['admission_status']);
                    })
                   ->when(!empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                        return $query->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
                    })
                    ->when(!empty($data['start_date']) && empty($data['end_date']), function ($query) use ($data) {
                        return $query->where('payment_date', '>=', $data['start_date']);
                    })
                    ->when(empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                        return $query->where('payment_date', '<=', $data['end_date']);
                    })

                    ->orderBy('id')
                    ->get();

                    $fee_subhead_array=[];
                    if(count($check_data_present)>0){

                        $admission_list_ids=$check_data_present->pluck('id')->unique()->filter();

                        $generated_sub_head_ids = SiteStudentAdmissionFeeGenerate::whereIn('site_student_admission_board_approve_id',$admission_list_ids)
                            //    ->where('status',true)
                                ->pluck('academic_fee_sub_head_id')
                                ->unique()
                                ->filter();

                    
                        $allocationList=SiteAdmissionFeeSubHeadAllocation::where('status',true)->get();

                        $academic_fee_sub_head_ids=$allocationList->pluck('academic_fee_sub_head_id')->unique()->filter();

                        $all_unique_ids = $academic_fee_sub_head_ids
                            ->merge($generated_sub_head_ids)
                            ->unique()
                            ->values(); 

                        $academic_fee_subhead=SiteAdmissionFeeSubHeadAllocation::whereIn('academic_fee_sub_head_id',$all_unique_ids)->get();

                        $fee_subhead_array=[];
                        foreach($academic_fee_subhead as $key=>$fee_subhead){
                            $fee_subhead_array[$key]['allocation_id']=$fee_subhead->id;
                            $fee_subhead_array[$key]['academic_fee_sub_head_id']=$fee_subhead->academic_fee_sub_head_id;
                            $fee_subhead_array[$key]['name']=$fee_subhead->academicFeeSubHead->name;
                            $fee_subhead_array[$key]['amount']=$fee_subhead->amount;
                        }

                      
                    
                      //  $fee_subhead_list=AcademicFeeSubHead::whereIn('id',$fee_subhead)->get();


                        $student_list=[];
                        foreach($check_data_present as $key=>$data){

                            $student_list[$key]['id']=$data->id;
                            $student_list[$key]['status']=$data->status;
                            $student_list[$key]['first_name']=$data->first_name;
                            $student_list[$key]['last_name']=$data->last_name;
                            $student_list[$key]['father_name']=$data->father_name;
                            $student_list[$key]['mother_name']=$data->mother_name;
                            $student_list[$key]['board_roll_number']=$data->board_roll_number;
                            $student_list[$key]['board_registration_number']=$data->board_registration_number;
                            $student_list[$key]['academic_board_id']=$data->academic_board_id;
                            $student_list[$key]['passing_year']=$data->passing_year;
                            $student_list[$key]['waiver_amount']=$data->waiver_amount;
                            $student_list[$key]['contact_number']=$data->contact_number;
                            $student_list[$key]['invoice_no']=$data->invoice_no;

                            $student_list[$key]['transaction_number']=$data->transaction_number;
                            $student_list[$key]['second_transaction_number']=$data->second_transaction_number;
                            $student_list[$key]['admission_status']=$data->admission_status;
                            $student_list[$key]['payment_status']=$data->payment_status;
                            $student_list[$key]['second_payment_status']=$data->second_payment_status;
                            $student_list[$key]['iid']=$data->iid;
                            $student_list[$key]['second_iid']=$data->second_iid;
                            $student_list[$key]['created_by']=$data->created_by;

                            $total_admission_fee = number_format($data->total_admission_fee, 2);

                            $student_list[$key]['admission_fee']=$data->admission_fee;
                            $student_list[$key]['other_fee']=$data->other_fee;
                            $student_list[$key]['total_admission_fee']=$total_admission_fee;

                            $fee_array=[];
                            $total_payable_amount=0;
                            $total_amount=0;
                            foreach($fee_subhead_array as $fee_key=>$fee_data){
                               

                                $chdckAdmissionFee = SiteStudentAdmissionFeeGenerate::where('site_student_admission_board_approve_id',$data->id)
                                    ->where('academic_fee_sub_head_id',$fee_data['academic_fee_sub_head_id'])
                                    ->first();

                                $fee_array[$fee_key]['academic_fee_sub_head_id']=$fee_data['academic_fee_sub_head_id'];
                                $fee_array[$fee_key]['name']=$fee_data['name'];

                              
                                if($chdckAdmissionFee){
                                    $fee_array[$fee_key]['select_academic_subhead_id']=$chdckAdmissionFee->status;
                                    $fee_array[$fee_key]['amount']=$chdckAdmissionFee->amount;
                                }else{
                                    $subheadAllocation=SiteAdmissionFeeSubHeadAllocation::where('status',true)
                                        ->where('academic_fee_sub_head_id',$fee_data['academic_fee_sub_head_id'])
                                        ->first();
                                    if($subheadAllocation){
                                        $fee_array[$fee_key]['amount']=$subheadAllocation->amount;
                                    }else{
                                        $fee_array[$fee_key]['amount']=0;
                                    }
                                    $fee_array[$fee_key]['select_academic_subhead_id']=false;
                                }

                                // $total_payable_amount+=$subheadAllocation->amount;
                                // $total_amount+=$subheadAllocation->amount;

                               
                            }

                            $total_amount_formate = number_format($total_payable_amount, 2);
                           

                            $student_list[$key]['fee_list']=$fee_array;
                            $student_list[$key]['total_payable_amount']=$total_amount_formate;
                            $student_list[$key]['total_amount']=$total_amount;


                        }

                     //   $student_list = $check_data_present;
                      
                    }
                    else{
                        $blank_files=[[
                            'id'=>0,
                            'status'=>1,
                            'first_name'=>null,
                            'last_name'=>null,
                            'father_name'=>null,
                            'mother_name'=>null,
                            'board_roll_number'=>null,
                            'board_registration_number'=>null,
                            'board_name'=>null,
                            'passing_year'=>null,
                            'waiver_amount'=>null,
                            'contact_number'=>null,
                            'fee_list'=>[],
                        ]];
        
                        $student_list = $blank_files;
                    }
           
           $board_list=AcademicBoard::get();

           if(count($student_list)<=0 || count($fee_subhead_array)<=0){
            return JsonResponse::create(['message' => 'Data Not Found!'], 412);

           }

            $students = $check_data_present;

            $student_count            = $students->count();
            $paid_student_count  = $students->where('payment_status', 1)->count();
            $admitted_student_count   = $students->where('admission_status', 1)->count();
            $admission_pending_student_count   = $paid_student_count-$admitted_student_count;
            $total_admission_fees     = $students->where('payment_status', 1)->sum('total_admission_fee');

           $total_report=[
            'student_count'=>$student_count,
            'paid_student_count'=>$paid_student_count,
            'admitted_student_count'=>$admitted_student_count,
            'admission_pending_student_count'=>$admission_pending_student_count,
            'total_admission_fee'=>$total_admission_fees,
           ];;


           return $datalist=[
                'student_list'=>$student_list,
                'fee_subhead_list'=>$fee_subhead_array,
                'board_list'=>$board_list,
                'total_report'=>$total_report
            ];

        }
        else{
            return JsonResponse::create(['message' => 'No Admission Declare Found!'], 412);
        }

    }


    public function getRollRegistrationEntryListForAdmissionPdf(Request $request){


        $checked_value=$this->checkAdmissionDeclare($request);

        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->first();

        if($checked_value[0] && $checked_value[1]
            && $checked_value[2] && $checked_value[3])
        {

            $data=$request->all();

            $data_list=SiteStudentAdmissionBoardApprove::where('academic_version_id', $data['academic_version_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->where('academic_year_id', $data['academic_year_id'])
                    ->where('status', true)
                    ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                        return $query->where('academic_class_id', $data['academic_class_id']);
                    })
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when(!empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                        return $query->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
                    })
                    ->when(!empty($data['start_date']) && empty($data['end_date']), function ($query) use ($data) {
                        return $query->where('payment_date', '>=', $data['start_date']);
                    })
                    ->when(empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                        return $query->where('payment_date', '<=', $data['end_date']);
                    })
                    ->orderBy('id')
                    ->get();


                $check_cellfin_geteway=SiteStudentAdmissionDeclareOnlineApi::where('site_student_admission_declare_id',$admission_declare_list->id)
                    ->where('academic_payment_type_key','online')
                    ->where('vendor','cellfin')
                    ->where('status',1)
                    ->first();
                //  dd($data_list);
                $site_id = (int)session()->get('SITE_ID');
                $site = SiteInfo::where('id', $site_id)->first();

                $class_details = AcademicClass::where('id', $request->academic_class_id)->select('class_name')->first();
                $class_group_details = AcademicClassGroup::where('id', $request->academic_class_group_id)->select('group_name')->first();
                $class_section_details = AcademicSection::where('id', $request->academic_section_id)->select('section_name')->first();
                $class_shift_details = AcademicShift::where('id', $request->academic_shift_id)->first();
                $from_date = date("d-m-Y", strtotime($request->start_date));
                $to_date = date("d-m-Y", strtotime($request->end_date));
        
                $title_view = 'Class Wise report';
        
                $print_date = Carbon::today();
                $print_date = $print_date->toDateString();
                $report_tittle = '<b>Student Admission Data list</b>';
                $report_tittle2  = '';

                $admission_list=[];
                $to_admission_fee=0;
                $total_other_fee=0;
                $total_waiver=0;
                $total_payable=0;
                $total_paid=0;
                $total_due=0;

            foreach($data_list as $key=>$data){
                $admission_list[$key]['student_name']=$data->first_name.' '.$data->last_name;
                // $dataadmission_list[$key]['board_name']=$data->board_name;
                $admission_list[$key]['board_roll_number']=$data->board_roll_number;
               


                if($check_cellfin_geteway){
                    $payable=($data->admission_fee+$data->other_fee);//-$data->waiver_amount;
              
                    $admission_list[$key]['payable']=$payable;
    
                   $admission_fee=0;
                   $total_admission_fee=0;
                   if($data->payment_status){
                    $admission_fee=$data->admission_fee;
                    $total_admission_fee=$data->total_admission_fee;
                   }
    
                   $other_fee=0;
                   if($data->payment_status){
                    $other_fee=$data->other_fee;
                   }
                   $paid=$admission_fee+$other_fee;
    
                   $t_paid=0;
                   if($paid){
                    $t_paid=$paid-$data->waiver_amount;
                   }
    
    
    
                   $admission_list[$key]['paid']=$t_paid;
                   $t_due=$payable-$paid;
                   $admission_list[$key]['due']=$t_due;
    
                   $to_admission_fee += $data->admission_fee;
                   $total_other_fee += $data->other_fee;
                   $total_waiver += $data->waiver_amount;
                   $total_payable += $payable;
                   $total_paid += $t_paid;
                   $total_due += $t_due;

                   $admission_list[$key]['admission_fee']=$data->admission_fee;
                   $admission_list[$key]['other_fee']=$data->other_fee;
                   $admission_list[$key]['waiver_amount']=$data->waiver_amount;
                   $admission_list[$key]['total_fee_with_other']=$data->total_fee_with_other;
                }else{
                    $admission_list[$key]['payable']=$data->total_admission_fee;
                    if($data->payment_status){
                       
                        $admission_list[$key]['paid']=$data->total_admission_fee;
                        $admission_list[$key]['due']=0;
                        $total_paid += $data->total_admission_fee;

                    }else{
                        $admission_list[$key]['paid']=0;
                        $admission_list[$key]['due']=$data->total_admission_fee;
                        $total_due += $data->total_admission_fee;

                    }

                    $admission_list[$key]['waiver_amount']=0;
                    $to_admission_fee += $data->total_admission_fee;
                    $total_other_fee += 0;
                    $total_waiver += 0;
                    $total_payable += $data->total_admission_fee;

                    $admission_list[$key]['admission_fee']=$data->total_admission_fee;
                    $admission_list[$key]['other_fee']=0;
                    $admission_list[$key]['waiver_amount']=0;
                    $admission_list[$key]['total_fee_with_other']=$data->total_admission_fee;
                  }
               
              
            }

            $footer_data=[
                'total_admission_fee'=>$to_admission_fee,
                'total_other_fee'=>$total_other_fee,
                'total_waiver'=>$total_waiver,
                'total_payable'=>$total_payable,
                'total_paid'=>$total_paid,
                'total_due'=>$total_due,
            ];



            if(count($admission_list)<=0){
               
                return JsonResponse::create(['message' => 'Data not found!'], 412);

            }else{
                $pdf = PDF::loadView('default.admin.site.admission.admission-list-data', 
                compact('admission_list','site','print_date','report_tittle','report_tittle2','title_view','class_details',
                'class_group_details','class_section_details','class_shift_details','from_date','to_date','footer_data'));

                $path = storage_path() . '/pdf';
                $time = \Auth::user()->id . '-' . Carbon::now()->unix();
                $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
                $name = $time . '.pdf';

             //   return $pdf->stream($name);

            
            
                return Response::json(['link' => route('open-pdf-file-storage', [$name]),
                    'message' => 'Successfully Created Card Report'], 200);

            }

          
        }
        else{
            return JsonResponse::create(['message' => 'No Admission Declare Found!'], 412);
        }

    }


    public function getAccountWiseAdmisssionFeeReportPdf(Request $request){
           $data=$request->all();
        // $data['academic_payment_method_key']=$data['payment_method']=='SonaliPay'?'sonali_pay':$data['payment_method'];

        $siteStudentIDs = SiteStudentAdmissionBoardApprove::where('academic_version_id', $data['academic_version_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('status', true)
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->when(!empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                return $query->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
            })
            ->when(!empty($data['start_date']) && empty($data['end_date']), function ($query) use ($data) {
                return $query->where('payment_date', '>=', $data['start_date']);
            })
            ->when(empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                return $query->where('payment_date', '<=', $data['end_date']);
            })

            ->pluck('id')
            ->unique();

        $paymentGatewayList =  SitePaymentGateway::with(['academicOnlinePaymentMethod','academicOnlinePaymentMarchentType',
            'academicFeeType'])
        //   ->when(!empty($data['academic_payment_method_key']), function ($query) use ($data) {
        //         return $query->where('academic_payment_method_key', $data['academic_payment_method_key']);
        //     })
            ->get();

        $payment_history_credit_info = GlobalSiteAdmissionPaymentHistory::where('site_id', Session::get('SITE_ID'))
        //    ->where('academic_group_id', $data['academic_group_id'])
        //    ->where('academic_payment_type_key', 'online')
        //    ->where('online_payment_status', 1)
            // ->when(isset($data['start_date']) && isset($data['end_date']), function ($q) use ($data) {
            //     $q->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
            // })
            // ->when(!empty($data['payment_method']), function ($q) use ($data) {
            //     $q->where('paid_by', $data['payment_method']);
            // })
            ->whereIn('site_student_admission_board_approve_id', $siteStudentIDs)
            ->whereNotNull('credit_info')
            ->where('credit_info', '!=', '[]')
            ->pluck('credit_info')
            ->filter() 
            ->flatMap(function ($item) {
                return json_decode($item, true) ?? [];
            })
            ->values();

      //   dd($payment_history_credit_info);

        $accont_amount_array=[];
        $total_amount=0;
        foreach($paymentGatewayList as $key=>$gateway){
            $account_amount=$payment_history_credit_info->where('account_no',$gateway->partner_number)->sum('amount');
            $formated_account_amount=number_format((float)$account_amount, 2, '.', '');

            $payment_method_name=$gateway->academic_payment_method_key=='sonali_pay'?'SonaliPay':$gateway->academic_payment_method_key;

            $accont_amount_array[$key]['account_no']=$gateway->partner_number;
            $accont_amount_array[$key]['pay_amount']=$formated_account_amount;
            $accont_amount_array[$key]['academic_payment_type_key']=$gateway->academic_payment_type_key;
            $accont_amount_array[$key]['academic_payment_method_key']=$gateway->academic_payment_method_key;
            $accont_amount_array[$key]['payment_method_name']=$payment_method_name;
            $accont_amount_array[$key]['user_name']=$gateway->user_name;

           $total_amount+=$account_amount;
        }

        $resp_data=[
            'total_amount'=>number_format((float)$total_amount, 2, '.', ''),
            'accont_amount_array'=>$accont_amount_array,
        ];

        $version= AcademicVersion::where('id',$data['academic_version_id'])->first();
        $shift= AcademicShift::where('id',$data['academic_shift_id'])->first();
        $year= AcademicYear::where('id',$data['academic_year_id'])->first();

        $report_tittle2  ='';
        $report_tittle2  .='Version: '.$version->version_name;
        $report_tittle2  .=', Year: '.$year->year_name;
        $report_tittle2  .=', Shift: '.$shift->shift_name;

        if($data['academic_class_id']){
            $class= AcademicClass::where('id',$data['academic_class_id'])->first();
            $report_tittle2  .=', Class: '.$class->class_name;
        }
        if(isset($data['academic_class_group_id'])){
            $classgroup= AcademicClassGroup::where('id',$data['academic_class_group_id'])->first();
            $report_tittle2  .=', Class Group: '.$classgroup->group_name;
        }
        $report_tittle2 .= ', Start Date: ' . date("d-m-Y", strtotime($data['start_date']));
        $report_tittle2 .= ', End Date: ' . date("d-m-Y", strtotime($data['end_date']));
        // if($data['academic_session_id']){
        //     $session= AcademicSession::where('id',$data['academic_session_id'])->first();
        //     $report_tittle2  .=', Class Group: '.$session->session_name;
        // }
        // if($data['payment_method']){
        //     $report_tittle2  .=', Payment Method: '.$data['payment_method'];
        // }
        // if($data['start_date']){
        //     $report_tittle2  .=', Date: '.$data['start_date'];
        //     $report_tittle2  .=' to '.$data['end_date'];
        // }

    //    $report_tittle2 ='Account Wise Fee Report';
        $report_tittle ='Account Wise Fee Report';
        $title_view='Account Wise Fee Report';

        $pdf = PDF::loadView('default.admin.site.admission.account-base-admission-fee-report-pdf',
            compact('resp_data','title_view','report_tittle','report_tittle2'));

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '-site-account-base-fee-report.pdf', 'UTF-8');
        $name = $time . '-site-account-base-fee-report.pdf';

         return Response::json([
            'link' => route('open-pdf-file-storage-for-public', [$name]),
            'message' => 'Successfully Created Card Report'
        ],200);

        
    }

    public function getSubheadWiseAdmisssionFeeReportPdf(Request $request){
           $data=$request->all();
        // $data['academic_payment_method_key']=$data['payment_method']=='SonaliPay'?'sonali_pay':$data['payment_method'];

        $siteStudentIDs = SiteStudentAdmissionBoardApprove::where('academic_version_id', $data['academic_version_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('status', true)
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->when(!empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                return $query->whereBetween('payment_date', [$data['start_date'], $data['end_date']]);
            })
            ->when(!empty($data['start_date']) && empty($data['end_date']), function ($query) use ($data) {
                return $query->where('payment_date', '>=', $data['start_date']);
            })
            ->when(empty($data['start_date']) && !empty($data['end_date']), function ($query) use ($data) {
                return $query->where('payment_date', '<=', $data['end_date']);
            })
            ->pluck('id')
            ->unique();

        $site_student_admission_board_approve_ids=SiteAdmissionPaymentHistory::whereIn('site_student_admission_board_approve_id',$siteStudentIDs)
            ->pluck('site_student_admission_board_approve_id')
            ->unique()
            ->values();

        $academic_fee_sub_head_list=SiteStudentAdmissionFeeGenerate::whereIn('site_student_admission_board_approve_id',$site_student_admission_board_approve_ids)
                ->where('status',true)
                ->get();
                
        $academic_fee_sub_head_ids=$academic_fee_sub_head_list->pluck('academic_fee_sub_head_id')->unique();

        $sub_head_array=[];
        $key=0;
        foreach($academic_fee_sub_head_ids as $sub_head_id){
            $sub_head=AcademicFeeSubHead::where('id',$sub_head_id)->first();
            $sub_head_array[$key]['academic_fee_sub_head_id']=$sub_head->id;
            $sub_head_array[$key]['name']=$sub_head->name;
            $sub_head_array[$key]['amount']=$academic_fee_sub_head_list->where('academic_fee_sub_head_id',$sub_head_id)->sum('amount');
            $key++;
        }

    
        $resp_data=[
            'total_amount'=>collect($sub_head_array)->sum('amount'),
            'subhead_amount_array'=>$sub_head_array,
        ];

        $version= AcademicVersion::where('id',$data['academic_version_id'])->first();
        $shift= AcademicShift::where('id',$data['academic_shift_id'])->first();
        $year= AcademicYear::where('id',$data['academic_year_id'])->first();

        $report_tittle2  ='';
        $report_tittle2  .='Version: '.$version->version_name;
        $report_tittle2  .=', Year: '.$year->year_name;
        $report_tittle2  .=', Shift: '.$shift->shift_name;

        if($data['academic_class_id']){
            $class= AcademicClass::where('id',$data['academic_class_id'])->first();
            $report_tittle2  .=', Class: '.$class->class_name;
        }
        if(isset($data['academic_class_group_id'])){
            $classgroup= AcademicClassGroup::where('id',$data['academic_class_group_id'])->first();
            $report_tittle2  .=', Class Group: '.$classgroup->group_name;
        }

        $report_tittle2 .= ', Start Date: ' . date("d-m-Y", strtotime($data['start_date']));
        $report_tittle2 .= ', End Date: ' . date("d-m-Y", strtotime($data['end_date']));
      
        $report_tittle ='Subhead Wise Fee Report';
        $title_view='Subhead Wise Fee Report';

        $pdf = PDF::loadView('default.admin.site.admission.subhead-base-admission-fee-report-pdf',
            compact('resp_data','title_view','report_tittle','report_tittle2'));

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '-site-subhead-base-fee-report.pdf', 'UTF-8');
        $name = $time . '-site-subhead-base-fee-report.pdf';

         return Response::json([
            'link' => route('open-pdf-file-storage-for-public', [$name]),
            'message' => 'Successfully Created Card Report'
        ],200);
        
    }

 
    private function checkAdmissionDeclare($request){

        $data=$request->all();
        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->first();

        $academic_year_ids= $admission_declare_list->academic_year_ids[1];
        $academic_year_id_selected[]= $request->academic_year_id;
        $common_year_id=collect(array_intersect($academic_year_ids ?? [], $academic_year_id_selected))->first();
        if($common_year_id){
            $academic_year_status=1;
        }else{
            $academic_year_status=0;
        }



        $academic_shift_ids= $admission_declare_list->academic_shift_ids[1];
        $academic_shift_id_selected[]= $request->academic_shift_id;
        $common_shift_id=collect(array_intersect($academic_shift_ids ?? [], $academic_shift_id_selected))->first();
        if($common_shift_id){
            $academic_shift_status=1;
        }else{
            $academic_shift_status=0;
        }


        $check_dept_present=SiteShiftClassGroupSectionSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->pluck('academic_department_id')
            ->unique()
            ->filter();

        if(count($check_dept_present)>0){
            $academic_department_ids= $admission_declare_list->academic_department_ids[1];
            $academic_department_id_selected[]= $request->academic_department_id;
            $common_department_id=collect(array_intersect($academic_department_ids ?? [], $academic_department_id_selected))->first();

            if($common_department_id){
                $academic_department_status=1;
            }else{
                $academic_department_status=0;
            }

        }
        else{
            $academic_department_status=1;
        }


        //===========Class

        $academic_class_ids= $admission_declare_list->academic_class_ids[1];
        $academic_class_id_selected[]= $request->academic_class_id;
        $common_class_id=collect(array_intersect($academic_class_ids ?? [], $academic_class_id_selected))->first();

        if($common_class_id){
            $academic_class_status=1;
        }else{
            $academic_class_status=0;
        }


        //===========Session

        $check_session_present=SiteClassSessionSerialSetting::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->where('session_ids', '!=',0)
            ->first();

         
        if($check_session_present){
            $academic_session_ids= $admission_declare_list->academic_session_ids[1];
            $academic_session_id_selected[]= $request->academic_session_id;
            $common_session_id=collect(array_intersect($academic_session_ids ?? [], $academic_session_id_selected))->first();
          //  dd($common_session_id);
            if($common_session_id){
                $academic_session_status=1;
            }else{
                $academic_session_status=0;
            }
        }
        else{
            $academic_session_status=1;
        }

        return [$academic_year_status, $academic_shift_status, $academic_department_status,
            $academic_class_status, $academic_session_status];

    }


    public function createStudentRollRegForAdmissionValidation(Request $request){

        $this->validate($request, [
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "admission_declare_id" => "required",
        ]);

      // return $request->all();

        $admission_declare_list=SiteStudentAdmissionDeclare::where('id',$request->admission_declare_id)->where('status', true)->orderBy('ID','DESC')->first();
       
        if(!$admission_declare_list){
            return Response::json(['message' => 'Admission Form Not Declare!',
            'mode' => 'Error'], 200);
        }
  
        $StudentList=collect($request->StudentList);

        // ==================Duplicate Other Board Roll No
        $student_student_board_roll_number=$StudentList->pluck('id')->filter();

        $OtherStudentList=SiteStudentAdmissionBoardApprove::where('payment_status',0)
            ->where('admission_status',0)
            ->when($admission_declare_list->check_with_second_online_transaction_id, function($q){
                $q->where('second_payment_status',0); 
            })
            ->where('site_student_admission_declare_id',$admission_declare_list->site_student_admission_declare_id)
            ->where('status',true)
            ->whereNotIn('id',$student_student_board_roll_number)
            ->get();

        $other_student_board_roll_array=$OtherStudentList->unique('board_roll_number')->pluck('board_roll_number')->filter();

        $other_duplicate_board_roll_number_array=[];
        foreach ($other_student_board_roll_array as $key => $value){
            $count_board_roll_number=$StudentList->where('board_roll_number', $value)->count();
            if($count_board_roll_number>=1){
                $other_duplicate_board_roll_number_array[]=$StudentList->where('board_roll_number', $value);
            }
        }

        $other_duplicate_board_roll_number=collect($other_duplicate_board_roll_number_array)->collapse()->values();


        if(count($other_duplicate_board_roll_number)>0){

            return Response::json(['message' => 'Duplicate Board Roll Number is present!',
                'duplicate_roll_array'=>null,
                'duplicate_registration_array'=>null,
                'duplicate_board_roll_array'=>$other_duplicate_board_roll_number,
                'duplicate_board_registration_array'=>null,
                'mode' => 'Error'], 200);
        }



        // // ==================Duplicate Board Roll No
        $student_student_board_roll_number=$StudentList->unique('board_roll_number')->pluck('board_roll_number')->filter();
        $duplicate_board_roll_number_array=[];
        foreach ($student_student_board_roll_number as $key => $value){
            $count_board_roll_number=$StudentList->where('board_roll_number', $value)->count();
            if($count_board_roll_number>1){
                $duplicate_board_roll_number_array[]=$StudentList->where('board_roll_number', $value);
            }
        }

        $duplicate_board_roll_number=collect($duplicate_board_roll_number_array)->collapse()->values();


        if(count($duplicate_board_roll_number)>0){

            return Response::json(['message' => 'Duplicate Board Roll Number is present!',
                'duplicate_roll_array'=>null,
                'duplicate_registration_array'=>null,
                'duplicate_board_roll_array'=>$duplicate_board_roll_number,
                'duplicate_board_registration_array'=>null,
                'mode' => 'Error'], 200);
        }



        // ==================Duplicate Board Registration No
        $student_student_board_registration_number=$StudentList->unique('board_registration_number')->pluck('board_registration_number')->filter();
        $duplicate_board_registration_number_array=[];
        foreach ($student_student_board_registration_number as $key => $value){
            $count_board_registration_number=$StudentList->where('board_registration_number', $value)->count();
            if($count_board_registration_number>1){
                $duplicate_board_registration_number_array[]=$StudentList->where('board_registration_number', $value);
            }
        }
        $duplicate_board_registration_number=collect($duplicate_board_registration_number_array)->collapse()->values();

        if(count($duplicate_board_registration_number)>0){

            return Response::json(['message' => 'Duplicate Board Registration Number is present!',
                'duplicate_roll_array'=>null,
                'duplicate_registration_array'=>null,
                'duplicate_board_roll_array'=>null,
                'duplicate_board_registration_array'=>$duplicate_board_registration_number,
                'mode' => 'Error'], 200);
        }

      
      
        $declare_payment_detail = ($admission_declare_list->siteStudentAdmissionDeclareOnlineApi)
              //  ->where('vendor', 'cellfin')
                ->where('status',1)
                ->first();
        if(!$declare_payment_detail){
            return Response::json(['message' => 'please select payment vandor in Admission declare form',
            'mode' => 'Error'], 200);

        }

        $site_duplicate=[];
              
        foreach ($StudentList as $key => $value){

           

                 $admission_fee  =   $request->admission_fee?$request->admission_fee:$value['admission_fee'];
                 $other_fee      =   $request->other_fee?$request->other_fee:$value['other_fee'];
                
                // $admission_fee  =   '';
                // $other_fee      =   '';

             //   dd($admission_fee,$other_fee);

                $waiver_amount  =   $request->waiver_amount?$request->waiver_amount:$value['waiver_amount'];
                $passing_year   =   $request->passing_year?$request->passing_year:$value['passing_year'];
                $academic_board_id= $request->academic_board_id?$request->academic_board_id:$value['academic_board_id'];
            //  $iid            =   $declare_payment_detail?$declare_payment_detail->partner_code:'';
             //   $second_iid     =   $request->second_iid?$request->second_iid:$value['second_iid'];

                $iid            =   '';
                $second_iid     =   '';

                if($request->status){
                    $status=$request->status=='yes'?1:0;
                }else{
                    $status=$value['status'];
                }

                
                $find_cadidate=SiteStudentAdmissionBoardApprove::where('id',$value['id'])
                    ->where('payment_status',0)
                    ->where('admission_status',0)
                    ->when($admission_declare_list->check_with_second_online_transaction_id, function($q){
                        $q->where('second_payment_status',0); 
                    })
                    ->first();


             
                if($find_cadidate){

              
                    $academic_year_id=$request->academic_year_id?$request->academic_year_id:$find_cadidate->academic_year_id;
                    $academic_version_id=$request->academic_version_id?$request->academic_version_id:$find_cadidate->academic_version_id;
                    $academic_class_id=$request->academic_class_id?$request->academic_class_id:$find_cadidate->academic_class_id;
                    $academic_shift_id=$request->academic_shift_id?$request->academic_shift_id:$find_cadidate->academic_shift_id;
                    $academic_class_group_id=$request->academic_class_group_id?$request->academic_class_group_id:$find_cadidate->academic_class_group_id;
                    $academic_department_id=$request->academic_department_id?$request->academic_department_id:$find_cadidate->academic_department_id;
                    $academic_session_id=$request->academic_session_id?$request->academic_session_id:$find_cadidate->academic_session_id;
                    //  $academic_year_id=$request->academic_year_id?$request->academic_year_id:$find_cadidate->academic_year_id;
                    $checkStudent=SiteStudentAdmissionBoardApprove::where('id', $value['id'])->first();

                    $checkStudent->academic_session_id=$academic_session_id;
                    $checkStudent->board_registration_number=$value['board_registration_number'];
                    $checkStudent->board_roll_number=$value['board_roll_number'];
                    $checkStudent->academic_board_id=$academic_board_id;
                    $checkStudent->passing_year=$passing_year;
                    $checkStudent->first_name=ucwords($value['first_name']);
                    $checkStudent->father_name=ucwords($value['father_name']);
                    $checkStudent->mother_name=ucwords($value['mother_name']);
                    $checkStudent->admission_fee=$admission_fee;
                    $checkStudent->other_fee=$other_fee;
                    $checkStudent->second_iid=$second_iid;
                    $checkStudent->waiver_amount=$waiver_amount;
                //    $checkStudent->total_fee_with_other=$admission_fee-$waiver_amount+$other_fee;
                    $checkStudent->total_fee_with_other='';
                    $checkStudent->iid=$iid;
                    $checkStudent->status=$status;
                //    $checkStudent->contact_number=$value['contact_number']??'';
                
                    $number = $checkStudent->id + 10000;
                    $checkStudent->invoice_no = 'A' . $number;
                  
                    if($checkStudent->save()){
                        $total_admission_fee=0;
                        foreach($value['fee_list'] as $key=>$fee){
                            if($fee['select_academic_subhead_id']){

                                $total_admission_fee+=$fee['amount'];

                                $chdckAdmissionFee = SiteStudentAdmissionFeeGenerate::where('site_student_admission_board_approve_id',$checkStudent->id)
                                    ->where('academic_fee_sub_head_id',$fee['academic_fee_sub_head_id'])
                                    ->first();

                                if($chdckAdmissionFee){
                                    $chdckAdmissionFee->amount = $fee['amount'];
                                    $chdckAdmissionFee->status = true;
                                    $chdckAdmissionFee->save();
                                }else{
                                    $admissionFeeGenerate = new SiteStudentAdmissionFeeGenerate();
                                    $admissionFeeGenerate->site_student_admission_board_approve_id = $checkStudent->id;
                                    $admissionFeeGenerate->academic_fee_sub_head_id = $fee['academic_fee_sub_head_id'];

                                    if(empty($fee['amount'])){
                                        $admissionFeeGenerate->amount = 0;
                                    }else{
                                        $admissionFeeGenerate->amount = $fee['amount'];
                                    }

                                    $admissionFeeGenerate->status = true;
                                    $admissionFeeGenerate->save();
                                }

                            }else{
                                $chdckAdmissionFee = SiteStudentAdmissionFeeGenerate::where('site_student_admission_board_approve_id',$checkStudent->id)
                                    ->where('academic_fee_sub_head_id',$fee['academic_fee_sub_head_id'])
                                    ->first();
                                if($chdckAdmissionFee){
                                    $chdckAdmissionFee->update([
                                        'status' => false
                                    ]);
                                }
                               
                            }
                        }

                         // update admission fee
                        $checkStudent->update([
                            'total_admission_fee' => $total_admission_fee,
                        ]);

                        
                    }

             
                }else{

                    $check_datae=SiteStudentAdmissionBoardApprove::where('board_roll_number', $value['board_roll_number'])
                                ->when(!empty($value['board_registration_number']), function ($query) use ($value) {
                                    return $query->where('board_registration_number', $value['board_registration_number']);
                                })
                                ->when($admission_declare_list->check_with_second_online_transaction_id, function($q){
                                    $q->where('second_payment_status',0); 
                                })
                                ->where('payment_status',0)
                                ->where('admission_status',0)
                                ->first();

                    //    dd($check_datae);

                        if(!$check_datae && ($value['id']=='0'|| $value['id']==null)){

                        $studentAdmission=new SiteStudentAdmissionBoardApprove;

                        $studentAdmission->site_student_admission_declare_id = $admission_declare_list->id;
                        $studentAdmission->academic_year_id = $request->academic_year_id;
                        $studentAdmission->academic_version_id = $request->academic_version_id;
                        $studentAdmission->academic_class_id = $request->academic_class_id;
                        $studentAdmission->academic_class_group_id = $request->academic_class_group_id;
                        $studentAdmission->academic_department_id = $request->academic_department_id;
                        $studentAdmission->academic_shift_id = $request->academic_shift_id;
                        $studentAdmission->academic_session_id = $request->academic_session_id;
                
                        $studentAdmission->board_roll_number=$value['board_roll_number'];
                        $studentAdmission->board_registration_number=$value['board_registration_number'];
                        $studentAdmission->academic_board_id=$academic_board_id;
                        $studentAdmission->passing_year=$passing_year;
                        $studentAdmission->first_name=ucwords($value['first_name']);
                        $studentAdmission->father_name=ucwords($value['father_name']);
                        $studentAdmission->mother_name=ucwords($value['mother_name']);
                        $studentAdmission->admission_fee=$admission_fee;
                        $studentAdmission->other_fee=$other_fee;
                        $studentAdmission->iid=$iid;
                        $studentAdmission->second_iid=$second_iid;

                        $studentAdmission->waiver_amount=$waiver_amount;
                    //    $studentAdmission->contact_number=$value['contact_number'];
                        $studentAdmission->total_fee_with_other = '';
                        $studentAdmission->created_date = date('Y-m-d');
                        $studentAdmission->status = $status;
                        $studentAdmission->save();

                    
                    }
                }
             
          

        }
        return JsonResponse::create(['message' => 'Successfuly Saved!'], 200);

    }

    
    public function uploadRollRegExcell(Request $request)

    {

        try {

            $this->validate($request, [
                "academic_version_id" => "required",
                "academic_year_id" => "required",
                "academic_shift_id" => "required",
                "academic_class_id" => "required",
                "admission_declare_id" => "required",
            ]);

            $admission_declare_list=SiteStudentAdmissionDeclare::where('id',$request->admission_declare_id)->where('status', true)->first();
            if($admission_declare_list){
                $exte=$request->file->getClientOriginalExtension();

                $fileName = time() . '.' . $request->file->getClientOriginalExtension();
                $request->file->move(storage_path('pdf'), $fileName);
               
                $request['file_ext']=$exte;

                $this->validate($request, [
                    'file_ext' => 'required|in:xls,xlsx,csv'
                ]);

                $import = new SiteAdmissionRollImport;
                Excel::import($import, storage_path('pdf') . '/' . $fileName);
                $row_count = $import->getRowCount();


                $checked_value=$this->checkAdmissionDeclare($request);


                if($checked_value[0] && $checked_value[1]
                    && $checked_value[2] && $checked_value[3]
                    && $checked_value[4])
                {
                    $get_excel_data=SiteStudentAdmissionBoardApproveExcel::get();

                    $data=$request->all();
                  
                    $get_present_data=SiteStudentAdmissionBoardApprove::
                        where('academic_version_id', $request->academic_version_id)
                        ->where('site_student_admission_declare_id', $admission_declare_list->id)
                        ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                            return $query->where('academic_year_id', $data['academic_year_id']);
                        })
                        ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                            return $query->where('academic_shift_id', $data['academic_shift_id']);
                        })
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                            return $query->where('academic_class_id', $data['academic_class_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->get();



                    $created=[];
                    foreach ($get_excel_data as $key => $value) {


                        $check_present_value=$get_present_data
                            ->when(!empty($value->board_roll_number), function ($query) use ($value) {
                                return $query->where('board_roll_number', $value->board_roll_number);
                            })
                            ->when(!empty($value->passing_year), function ($query) use ($value) {
                                return $query->where('passing_year', $value->passing_year);
                            })
                            ->first();


                        if(!$check_present_value){

                            $get_board_id=AcademicBoard::where('key_name', $value->board_name)->first();

                                        
                        $admission_declare_list=SiteStudentAdmissionDeclare::where('status', true)->first();
                        if(!$admission_declare_list){
                            return Response::json(['message' => 'Admission Form Not Declare!',
                            'mode' => 'Error'], 200);
                        }
                    
                        $declare_payment_detail = ($admission_declare_list->siteStudentAdmissionDeclareOnlineApi)
                            //  ->where('vendor', 'cellfin')
                                ->where('status',1)
                                ->first();
                        if(!$declare_payment_detail){
                            return Response::json(['message' => 'please select payment vandor in Admission declare form',
                            'mode' => 'Error'], 200);
                        }

                        $iid=$declare_payment_detail?$declare_payment_detail->partner_code:'';
             
                            $created[]=[
                                'site_student_admission_declare_id'=>$admission_declare_list->id,
                                'academic_year_id'=>$request->academic_year_id,
                                'academic_version_id'=>$request->academic_version_id,
                                'academic_class_id'=>$request->academic_class_id,
                                'academic_class_group_id'=>$request->academic_class_group_id,
                                'academic_department_id'=>$request->academic_department_id,
                                'academic_shift_id'=>$request->academic_shift_id,
                                'academic_session_id'=>$request->academic_session_id,
                                'site_id'=>Session::get('SITE_ID'),
                                'academic_group_id'=>Session::get('ACADEMIC_GROUP_ID'),
                                'first_name' => ucwords($value['student_name']),
                                'father_name' => ucwords($value['father_name']),
                                'mother_name' => ucwords($value['mother_name']),
                                'board_roll_number' => $value['board_roll_number'],
                                'board_registration_number' => $value['board_registration_number'],
                                'academic_board_id' => $get_board_id?$get_board_id->id:0,
                                'board_name' => $get_board_id?$get_board_id->key_name:0,
                                'passing_year' => $value['passing_year'],
                                'iid' => $iid,
                             //   'contact_number' => $value['contact_number'],
                                'created_date' => date('Y-m-d')
                            ];
                        }

                    }

                    if(count($created)>0){
                        SiteStudentAdmissionBoardApprove::insert($created);
                    }

                }
                else{
                    return JsonResponse::create(['message' => 'Your Admission Declare & your selected Data is not matched!'], 412);
                }

                if($get_excel_data->pluck('id')->count()>0){
                    SiteStudentAdmissionBoardApproveExcel::whereIn('id', $get_excel_data->pluck('id'))->delete();
                }

                return JsonResponse::create(['message' => 'Successfuly Saved!'], 200);
            }


       } catch (ValidationException $exception) {
           return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
       } catch (Exception $exception) {
           throw new Error($exception->getMessage());
       }
    }


    public function siteStudentPaymentSlipPdf($invoice_no,$tr_id){
            $site_id=Session::get('SITE_ID');

            $site_info= SiteInfo::where('id',$site_id)->select('id','admission_fee_collection_status','show_subhead_in_payment_slip')->first();


            $payment_history=GlobalSiteAdmissionPaymentHistory::with('siteStudentAdmissionBoardApprove')
                ->where('site_id',$site_id)
                ->where('transaction_id',$tr_id)
                ->where('invoice_id',$invoice_no)
                ->first();

            if(!$payment_history){
                return 'Data not found!';
            }

            $admissionFee=SiteStudentAdmissionFeeGenerate::where('site_student_admission_board_approve_id',$payment_history->site_student_admission_board_approve_id)
                ->where('status',1)
                ->get();

            $fee_list=[];
            foreach($admissionFee as $key=>$fee){
                $fee_list[$key]['academic_fee_sub_head']=$fee->academicFeeSubHead?$fee->academicFeeSubHead->name:'';
                $fee_list[$key]['amount']=$fee->amount;
            }

            $total_paid_amount_in_word = $this->convertNumberToWord($payment_history->total_paid_amount);


            $payment_details=[
                'candidate_name'=>$payment_history->siteStudentAdmissionBoardApprove->first_name,
                'father_name'=>$payment_history->siteStudentAdmissionBoardApprove->father_name,
                'mother_name'=>$payment_history->siteStudentAdmissionBoardApprove->mother_name,
                'year_name'=>$payment_history->siteStudentAdmissionBoardApprove->year?$payment_history->siteStudentAdmissionBoardApprove->year->year_name:'',
                'shift_name'=>$payment_history->siteStudentAdmissionBoardApprove->shift?$payment_history->siteStudentAdmissionBoardApprove->shift->shift_name:'',
                'session_name'=>$payment_history->siteStudentAdmissionBoardApprove->session?$payment_history->siteStudentAdmissionBoardApprove->session->session_name:'',
                'class_name'=>$payment_history->siteStudentAdmissionBoardApprove->stClass?$payment_history->siteStudentAdmissionBoardApprove->stClass->class_name:'',
                'group_name'=>$payment_history->siteStudentAdmissionBoardApprove->classGroup?$payment_history->siteStudentAdmissionBoardApprove->classGroup->group_name:'',
                'roll'=>$payment_history->siteStudentAdmissionBoardApprove->board_roll_number,
                'contact_number'=>$payment_history->siteStudentAdmissionBoardApprove->contact_number,
                'board'=>$payment_history->siteStudentAdmissionBoardApprove->academicBoard?$payment_history->siteStudentAdmissionBoardApprove->academicBoard->key_name:'',
                'passing_year'=>$payment_history->siteStudentAdmissionBoardApprove->passing_year,

                'invoice_date'=>$payment_history->siteStudentAdmissionBoardApprove->created_data?$payment_history->siteStudentAdmissionBoardApprove->created_data:'',

                'payment_date'=>$payment_history->transaction_date,
                'payment_by'=>$payment_history->paid_by,
                'payment_time'=>$payment_history->transaction_time,
                'transaction_gateway'=>$payment_history->transaction_gateway,
                'transaction_id'=>$payment_history->transaction_id,
                'total_paid_amount'=>$payment_history->total_paid_amount,
                'total_paid_amount_in_word'=>$total_paid_amount_in_word,
                'gateway_charge'=>$payment_history->gateway_charge,

                'extra_fine'=>'0.00',
                'waiver'=>'0.00',
                'special_waiver'=>'0.00',

                'transaction_amount'=>$payment_history->transaction_amount,
                'invoice_id'=>$payment_history->invoice_id,
                'fee_list'=>$fee_list,
            ];


           // dd($payment_details);

            $title_view='Admission Payment Voucher';
            $report_tittle='Admission Payment Voucher';
            $report_tittle2='';
            $slip_owner='admin';
            // $site_info=GlobalSiteInfo::where('id',$site_id)->first();

        
            $pdf = PDF::loadView('default.site.student_admission.admission-payment-slip', compact('title_view','report_tittle','report_tittle2','payment_details','site_info','slip_owner'));
            return $pdf->stream($payment_history->transection_token.'.pdf');
    }


}
