<?php

namespace App\Http\Controllers\Site\Student\Report;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Student\StudentHistory;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Auth;
use Illuminate\Support\Facades\Storage;
use Session;
use Response;
use File;
use Error;
use PDF;


class PaymentReportController extends ProjectController
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ="Student Payment Report";
        return view('default.admin.layouts.master',compact('viewType'));
    }

    public function master()
    {
        $viewType ="Student Payment Report";
        return view('default.admin.layouts.master',compact('viewType'));
    }

    public function getAcademicClassList()
    {
        $user_id = Auth::user()->id;
        $student_class_ids = StudentHistory::where('user_id',$user_id)->pluck('academic_class_id');
        $academic_class = AcademicClass::whereIn('id', $student_class_ids)->get();
        return $academic_class;
    }

    public function getGeneralPaymentList(Request $request)
    {
//        return $request;
        $date_start = $request->from_date;
        $date_end = $request->to_date;
        $academic_class_id = $request->academic_class_id ?? "";

        $user_role = request()->user()->roles()->where('key','student')->first();
        if($user_role){
            $user_id = Auth::user()->id;
            $user_history_id = StudentHistory::where('user_id',$user_id)->when($academic_class_id,function ($q) use($academic_class_id){
                $q->where('academic_class_id', $academic_class_id);
            })->pluck('id');
            $demand_slip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $user_history_id)
                ->with('siteStudentFeePaymentHistory')
                ->with('siteStudentFeeFine')
                ->when($date_start, function ($q) use ($date_start) {
                    return $q->whereDate('created_at', '>=', $date_start);
                })
                ->when($date_end, function ($qq) use ($date_end) {
                    return $qq->whereDate('created_at', '<=', $date_end);
                })
                ->orderBy('id','DESC')
                ->get();

            $final_data = [];
            $total_demand_slip_amount = 0;
            $total_fine_amount = 0;
            $total_waiver_amount = 0;
            $total_paid_amount = 0;

            if(count($demand_slip)>0){
                foreach ($demand_slip as $key => $value){
                    $final_data[$key]['demand_slip_id'] = $value->id;
                    $final_data[$key]['demand_slip_no'] = $value->id + 100000;
                    $final_data[$key]['demand_slip_create_date'] = $value->created_at->format('Y-m-d');
                    $final_data[$key]['demand_slip_amount'] = $value->fee_amount;
                    $final_data[$key]['head_base_waiver'] = $value->waiver_amount;
                    $final_data[$key]['special_waiver'] = $value->special_waiver_amount;
                    $final_data[$key]['waiver'] = $value->waiver_amount + $value->special_waiver_amount;



                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();


                    $fee_delay_fine = 0;

                    if($value->payment_from_date){
                        $start_date = $value->payment_from_date;
                        $end_date = $value->payment_to_date;

                        $period = CarbonPeriod::create($start_date, $end_date);

                        $delay_fine_test = 1;

                        foreach ($period as $date) {
                            $formated_date =  $date->format('Y-m-d');
                            if($formated_date == $today_date){
                                $delay_fine_test = 0;
                            }
                        }

                        if($delay_fine_test==1 && $value->status){
                            $delay_fine = $value->delay_fine;
                        }else{
                            $delay_fine = 0;
                        }

                        $fee_delay_fine = $delay_fine;
                    }



                    $total_fine = 0;
                    if(count($value->siteStudentFeeFine)>0){
                        foreach ($value->siteStudentFeeFine as $k => $v){
                            $total_fine+=$v->fine_amount;
                        }
                    }
                    $final_data[$key]['fine'] = $total_fine + $fee_delay_fine;
                    $previous_demand_slip_fee_fine_amount = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$value->previous_site_student_fee_demand_slip_detail_id)->sum('fine_amount');

                    $final_data[$key]['previous_demand_slip_fee_fine_amount'] = $previous_demand_slip_fee_fine_amount ?? 0;

                    $previous_due=0;
                    $prevSlip=SiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id',$value->student_history_id)
                        ->where('previous_academic_class_due_status',true)
                        ->first();

                    if($prevSlip){
                        $previous_due=$prevSlip->total_amount;
                    }


                  

                    $final_data[$key]['previous_due'] = $previous_due;// $value->previous_due + $final_data[$key]['previous_demand_slip_fee_fine_amount'];

                    $final_data[$key]['payable_amount'] = ($value->fee_amount + $total_fine + $fee_delay_fine + $final_data[$key]['previous_due']) - ( $value->waiver_amount + $value->special_waiver_amount);
                    $total_paid = 0;
                    if(count($value->siteStudentFeePaymentHistory)>0){
                        foreach ($value->siteStudentFeePaymentHistory as $kk => $vv){
                            $total_paid+= $vv->paid_amount;
                        }
                    }
                    $final_data[$key]['paid_amount'] = $total_paid;
                    $final_data[$key]['due_amount'] = $final_data[$key]['payable_amount'] - $total_paid;
                    $final_data[$key]['payment_list'] = $value->siteStudentFeePaymentHistory;

                   $fee_details =  $this->getDemandSlipFeeDetails($final_data[$key]['demand_slip_no']);
                    $final_data[$key]['fee_details_list'] = $fee_details;
//                    $final_data[$key]['fee_details_list'] = "";

                    $total_in_word = $this->convertNumberToWord($final_data[$key]['payable_amount']);
                    $final_data[$key]['total_in_word'] = $total_in_word;

                    $total_demand_slip_amount+=$value->fee_amount;
                    $total_fine_amount+=$total_fine;
                    $total_waiver_amount+=$final_data[$key]['waiver'];
                    $total_paid_amount+=$total_paid;


                }
            }
            $total_payable_amount = ($total_demand_slip_amount + $total_fine_amount) - $total_waiver_amount;
            $total_due_amount = $total_payable_amount - $total_paid_amount;
            return [$final_data,$total_payable_amount, $total_paid_amount, $total_due_amount];
        }else{
            throw new Error('Sorry! you are unauthorised!');
        }

    }

    public function getStudentFinancialStatement(Request $request)
    {
//        return $request;
        $date_start = $request->from_date;
        $date_end = $request->to_date;
        $academic_class_id = $request->academic_class_id ?? "";

        $user_role = request()->user()->roles()->where('key','student')->first();

        if($user_role){

            $user_id = Auth::user()->id;



            $user_history_id = StudentHistory::where('user_id',$user_id)->when($academic_class_id,function ($q) use($academic_class_id){
                $q->where('academic_class_id', $academic_class_id);
            })->pluck('id');

            //===============get initial balance=================
            $initial_balance = 0;

            if($date_start && $date_end){
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($date_start)));
                $demand_slip_details = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $user_history_id)
                    ->with('siteStudentFeePaymentHistory')
                    ->with('siteStudentFeeFine')
                    ->with('siteAccountsVoucherDetailsStudentPaymentHistoryRecord')
                    ->whereDate('created_at', '<', $date_start)
                    ->orderBy('id','ASC')
                    ->get();

                if(count($demand_slip_details)>0){
                    foreach ($demand_slip_details as $kky => $vvl){

                        if($vvl->siteAccountsVoucherDetailsStudentPaymentHistoryRecord){

                            $waiver = $vvl->waiver_amount + $vvl->special_waiver_amount;
                            $initial_balance+=$vvl->fee_amount - $waiver;

                            if(count($vvl->siteStudentFeeFine)>0){
                                foreach ($vvl->siteStudentFeeFine as $kk => $vv){
                                    $initial_balance+=$vv->fine_amount;
                                }
                            }

                            if(count($vvl->siteStudentFeePaymentHistory)>0){
                                foreach ($vvl->siteStudentFeePaymentHistory as $kkk => $vvv){
                                    $initial_balance-=$vvv->paid_amount;
                                }
                            }

                        }
                    }
                }
            }

            //===============get final data balance=================
            $demand_slip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $user_history_id)
                ->with(['siteStudentFeePaymentHistory'=>function($qr){
                    $qr->with('siteStudentOnlinePaymentDetails');
                    $qr->with(['siteAccountsVoucherDetailsStudentPaymentHistoryRecord'=>function($qrr){
                        $qrr->with(['accountsVoucherDetails'=>function($qrrr){
                            $qrrr->with(['accounts'=>function($qqr){
                                $qqr->with('ledger');
                                $qqr->whereHas('ledger', function ($qqrr){
                                    return $qqrr->where('entry', 'dr');
                                })->with('ledger');
                            }]);

                        }]);

                    }]);
                }])
                ->with('siteStudentFeeFine')
                ->with(['siteAccountsVoucherDetailsStudentPaymentHistoryRecord'=>function($qrr){
                    $qrr->with(['accountsVoucherDetails'=>function($qrrr){
                        $qrrr->with(['accounts'=>function($qqr){
                            $qqr->with('ledger');
                            $qqr->whereHas('ledger', function ($qqrr){
                                return $qqrr->where('entry', 'cr');
                            })->with('ledger');
                        }]);

                    }]);

                }])
                ->when($date_start, function ($q) use ($date_start) {
                    return $q->whereDate('created_at', '>=', $date_start);
                })
                ->when($date_end, function ($qq) use ($date_end) {
                    return $qq->whereDate('created_at', '<=', $date_end);
                })
                ->orderBy('id','ASC')
                ->get();


            $final_data = [];
            $balance = 0;

            $balance = $balance + $initial_balance;

            $srl=0;

            if(count($demand_slip)>0){
                foreach ($demand_slip as $key => $value){
//
                    if($value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord){


                        $final_data[$srl]['transaction_date'] = $value->created_at->format('Y-m-d');
                        $final_data[$srl]['transaction_type'] = 'Receivable';
                        $final_data[$srl]['transaction_id'] = "";
                        $final_data[$srl]['particular'] = $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord ?
                            $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord
                            ->accountsVoucherDetails->accounts[0]->ledger->name : "";

                        $final_data[$srl]['payment_slip_no'] = "";
                        $waiver = $value->waiver_amount + $value->special_waiver_amount;
                        $final_data[$srl]['debit_amount'] = $value->fee_amount - $waiver;
                        $final_data[$srl]['credit_amount'] = 0.00;
                        $balance+= $final_data[$srl]['debit_amount'];
                        $final_data[$srl]['balance'] =$balance;
                        $srl++;


                        if(count($value->siteStudentFeeFine)>0){

                            foreach ($value->siteStudentFeeFine as $kk => $vv){

                                $final_data[$srl]['transaction_date'] = $value->created_at->format('Y-m-d');
                                $final_data[$srl]['transaction_type'] = 'Receivable(Fine)';
                                $final_data[$srl]['transaction_id'] = "";
                                $final_data[$srl]['particular'] = $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord ?
                                    $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord
                                    ->accountsVoucherDetails->accounts[0]->ledger->name : "";

                                $final_data[$srl]['debit_amount'] = $vv->fine_amount;
                                $final_data[$srl]['payment_slip_no'] = "";
                                $final_data[$srl]['credit_amount'] = 0.00;

                                $balance+= $final_data[$srl]['debit_amount'];
                                $final_data[$srl]['balance'] =$balance;

                                $srl++;

                            }

                        }

                        if(count($value->siteStudentFeePaymentHistory)>0){

                            foreach ($value->siteStudentFeePaymentHistory as $kkk => $vvv){

                                $final_data[$srl]['transaction_date'] = $vvv->payment_date;
                                $final_data[$srl]['transaction_type'] = 'Received';
                                $final_data[$srl]['transaction_id'] = $vvv->siteStudentOnlinePaymentDetails ? $vvv->siteStudentOnlinePaymentDetails->transaction_id : "";
                                $final_data[$srl]['particular'] = $vvv->siteAccountsVoucherDetailsStudentPaymentHistoryRecord ? $vvv->siteAccountsVoucherDetailsStudentPaymentHistoryRecord
                                    ->accountsVoucherDetails->accounts[0]->ledger->name : "";
                                $final_data[$srl]['payment_slip_no'] =$vvv->voucher_no;
                                $final_data[$srl]['credit_amount'] = $vvv->paid_amount;
                                $final_data[$srl]['debit_amount'] = 0.00;

                                $balance-= $final_data[$srl]['credit_amount'];
                                $final_data[$srl]['balance'] =$balance;

                                $srl++;

                            }

                        }

                    }
//
                }
            }
            $upto_date = "";
            if($date_start && $date_end){
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($date_start)));

            }else{
                if(count($demand_slip)>0){
                    $dates = $demand_slip->pluck('created_at');
                    $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($dates[0])));
                }

            }
            return [$final_data,$balance, $initial_balance, $upto_date];
        }else{
            throw new Error('Sorry! you are unauthorised!');
        }

    }

    public function getStudentFinancialLedgerPDF($class_id, $start_date, $end_date)
    {
//        return $request;
        $date_start = $start_date == 0 ? "" : $start_date;
        $date_end = $end_date == 0 ?"" : $end_date;
        $academic_class_id = $class_id == 0 ? "" : $class_id;

        $user_role = request()->user()->roles()->where('key','student')->first();

        if($user_role){

            $user_id = Auth::user()->id;

            $user_history_id = StudentHistory::where('user_id',$user_id)->when($academic_class_id,function ($q) use($academic_class_id){
                $q->where('academic_class_id', $academic_class_id);
            })->pluck('id');

            //===============get initial balance=================
            $initial_balance = 0;

            if($date_start && $date_end){
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($date_start)));
                $demand_slip_details = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $user_history_id)
                    ->with('siteStudentFeePaymentHistory')
                    ->with('siteStudentFeeFine')
                    ->with('siteAccountsVoucherDetailsStudentPaymentHistoryRecord')
                    ->whereDate('created_at', '<', $date_start)
                    ->orderBy('id','ASC')
                    ->get();

                if(count($demand_slip_details)>0){
                    foreach ($demand_slip_details as $kky => $vvl){

                        if($vvl->siteAccountsVoucherDetailsStudentPaymentHistoryRecord){

                            $waiver = $vvl->waiver_amount + $vvl->special_waiver_amount;
                            $initial_balance+=$vvl->fee_amount - $waiver;

                            if(count($vvl->siteStudentFeeFine)>0){
                                foreach ($vvl->siteStudentFeeFine as $kk => $vv){
                                    $initial_balance+=$vv->fine_amount;
                                }
                            }

                            if(count($vvl->siteStudentFeePaymentHistory)>0){
                                foreach ($vvl->siteStudentFeePaymentHistory as $kkk => $vvv){
                                    $initial_balance-=$vvv->paid_amount;
                                }
                            }

                        }
                    }
                }
            }

            //===============get final data balance=================
            $demand_slip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $user_history_id)
                ->with(['siteStudentFeePaymentHistory'=>function($qr){
                    $qr->with('siteStudentOnlinePaymentDetails');
                    $qr->with(['siteAccountsVoucherDetailsStudentPaymentHistoryRecord'=>function($qrr){
                        $qrr->with(['accountsVoucherDetails'=>function($qrrr){
                            $qrrr->with(['accounts'=>function($qqr){
                                $qqr->with('ledger');
                                $qqr->whereHas('ledger', function ($qqrr){
                                    return $qqrr->where('entry', 'dr');
                                })->with('ledger');
                            }]);

                        }]);

                    }]);
                }])
                ->with('siteStudentFeeFine')
                ->with(['siteAccountsVoucherDetailsStudentPaymentHistoryRecord'=>function($qrr){
                    $qrr->with(['accountsVoucherDetails'=>function($qrrr){
                        $qrrr->with(['accounts'=>function($qqr){
                            $qqr->with('ledger');
                            $qqr->whereHas('ledger', function ($qqrr){
                                return $qqrr->where('entry', 'cr');
                            })->with('ledger');
                        }]);

                    }]);

                }])
                ->when($date_start, function ($q) use ($date_start) {
                    return $q->whereDate('created_at', '>=', $date_start);
                })
                ->when($date_end, function ($qq) use ($date_end) {
                    return $qq->whereDate('created_at', '<=', $date_end);
                })
                ->orderBy('id','ASC')
                ->get();


            $final_data = [];
            $balance = 0;

            $balance = $balance + $initial_balance;

            $srl=0;

            if(count($demand_slip)>0){
                foreach ($demand_slip as $key => $value){
//
                    if($value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord){


                        $final_data[$srl]['transaction_date'] = $value->created_at->format('Y-m-d');
                        $final_data[$srl]['transaction_type'] = 'Receivable';
                        $final_data[$srl]['transaction_id'] = "";
                        $final_data[$srl]['particular'] = $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord ?
                            $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord
                            ->accountsVoucherDetails->accounts[0]->ledger->name : "";

                        $final_data[$srl]['payment_slip_no'] = "";
                        $waiver = $value->waiver_amount + $value->special_waiver_amount;
                        $final_data[$srl]['debit_amount'] = $value->fee_amount - $waiver;
                        $final_data[$srl]['credit_amount'] = 0.00;
                        $balance+= $final_data[$srl]['debit_amount'];
                        $final_data[$srl]['balance'] =$balance;
                        $srl++;


                        if(count($value->siteStudentFeeFine)>0){

                            foreach ($value->siteStudentFeeFine as $kk => $vv){

                                $final_data[$srl]['transaction_date'] = $value->created_at->format('Y-m-d');
                                $final_data[$srl]['transaction_type'] = 'Receivable(Fine)';
                                $final_data[$srl]['transaction_id'] = "";
                                $final_data[$srl]['particular'] = $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord ?
                                    $value->siteAccountsVoucherDetailsStudentPaymentHistoryRecord
                                    ->accountsVoucherDetails->accounts[0]->ledger->name : "";

                                $final_data[$srl]['debit_amount'] = $vv->fine_amount;
                                $final_data[$srl]['payment_slip_no'] = "";
                                $final_data[$srl]['credit_amount'] = 0.00;

                                $balance+= $final_data[$srl]['debit_amount'];
                                $final_data[$srl]['balance'] =$balance;

                                $srl++;

                            }

                        }

                        if(count($value->siteStudentFeePaymentHistory)>0){

                            foreach ($value->siteStudentFeePaymentHistory as $kkk => $vvv){

                                $final_data[$srl]['transaction_date'] = $vvv->payment_date;
                                $final_data[$srl]['transaction_type'] = 'Received';
                                $final_data[$srl]['transaction_id'] = $vvv->siteStudentOnlinePaymentDetails ? $vvv->siteStudentOnlinePaymentDetails->transaction_id : "";
                                $final_data[$srl]['particular'] = $vvv->siteAccountsVoucherDetailsStudentPaymentHistoryRecord ?
                                $vvv->siteAccountsVoucherDetailsStudentPaymentHistoryRecord
                                    ->accountsVoucherDetails->accounts[0]->ledger->name : "";
                                $final_data[$srl]['payment_slip_no'] =$vvv->voucher_no;
                                $final_data[$srl]['credit_amount'] = $vvv->paid_amount;
                                $final_data[$srl]['debit_amount'] = 0.00;

                                $balance-= $final_data[$srl]['credit_amount'];
                                $final_data[$srl]['balance'] =$balance;

                                $srl++;

                            }

                        }

                    }
//
                }
            }
            $upto_date = "";
            if($date_start && $date_end){
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($date_start)));

            }else{
                if(count($demand_slip)>0){
                    $dates = $demand_slip->pluck('created_at');
                    $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($dates[0])));
                }

            }

//            return $upto_date;

            $title_view = 'Financial Statement(Ledger)';


            $report_tittle2 = "";

            if($date_start && $date_end){
                $report_tittle = '<b>Ledger Report</b><br>'.$date_start." To ".$date_end;
            }else{
                $report_tittle = '<b>Ledger Report</b>';

            }




            $pdf = PDF::loadView('default.admin.site.student-fee.financial-ledger-pdf',
                compact('title_view','final_data','balance','initial_balance','upto_date','report_tittle','report_tittle2'));


            return $pdf->stream(time() . '-student-payment.pdf');

//            return [$final_data,$balance, $initial_balance, $upto_date];
        }else{
            throw new Error('Sorry! you are unauthorised!');
        }

    }

    public function getDemandSlipFeeDetails($demand_slip_no){

        $slip_no = $demand_slip_no;
        $slip_id = $demand_slip_no - 100000;

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_id)->first();

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = Array();
        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_detail= SiteStudentFeeFineAllocation::
            with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                ->where('id',$value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());

        }

        $fee_allocation_details=collect($fee_allocation_details_array);

        $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){


            if($value->site_student_fee_fine_allocation_id){


                $waiver_allocation_detail= SiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }


        $waiver_allocation=collect($waiver_allocation_details_array);

        $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);


        $finalArray=compact('fee_allocation_details_list', 'waiver_allocation_details');

        return $finalArray;
    }

    private function feeHeadSubHeadTypeMultiStemArray($fee_allocation_details){

//        return $fee_allocation_details;
        $head_Id=$fee_allocation_details->pluck('academic_fee_head.id')->unique();
        $fee_head_list=AcademicFeeHead::get();


        $fee_head_arr=Array();
        $fee_head_array=[];
        foreach ($head_Id as $key => $value){

            $head_list=$fee_head_list->where('id',$value)->first();

            $fee_head_arr['id']=$value;
            $fee_head_arr['name']=$head_list->name;


            $fee_head_pre_array=[];
            foreach ($fee_allocation_details as $keys => $values){
                if($value==$values['academic_fee_head']['id']){

                    $fee_head_pre_array[$keys]=$values;
                }
            }

            $fee_head_pre_array_collect=collect($fee_head_pre_array);
            $fee_head_pre_array_collect_id= $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();


            $fee_head_type_arr=Array();
            $fee_head_type_array=[];
            $sub_head_full_count=[];
            foreach ($fee_head_pre_array_collect_id as $keyt => $valuet){

                $fee_head_type_listt=$fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();
//                return $fee_head_type_listt;

                $fee_head_type_arr['fee_type_id']=$valuet;
                $fee_head_type_arr['fee_type_name']=$fee_head_type_listt['fee_type_name'];


                $fee_head_type_pre_array=[];
                foreach ($fee_head_pre_array_collect as $keytt => $valuett){

                    if($valuet==$valuett['fee_head_type_id']){
                        $fee_head_type_pre_array[$keytt]=$valuett;
                    }
                }

                $fee_head_type_arr['fee_sub_head_count']=count($fee_head_type_pre_array);
                $fee_head_type_arr['fee_sub_head']=$fee_head_type_pre_array;

                $sub_head_full_count[$keyt]=count($fee_head_type_pre_array);

                $fee_head_type_array[$keyt]=array_merge($fee_head_type_arr);

            }

            $fee_head_arr['head_type_base_sub_head_count']=array_sum($sub_head_full_count);
            $fee_head_arr['head_type']=$fee_head_type_array;

            $fee_head_array[$key]=array_merge($fee_head_arr);
        }
        $fee_allocation_details_list=collect($fee_head_array);

        return $fee_allocation_details_list;
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
