<?php

namespace App\Http\Controllers\Site\Student\IDCard;

use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class RfIdCardController extends Controller
{

    private $carbon_now;
    private $student;

    public function __construct(Student $student)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();
        $this->student = $student;

    }


    public function getStudentListForRfIdCardCode(Request $request)
    {


        $data = [];
        $data['academic_version_id'] = $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id;


        $search_txt = $request->search_txt;
        $paginate = $request->paginate ?? 20;
        $status = $request->status;
        $txt = '%' . $search_txt . '%';

        $history_list=StudentHistory::
            when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', $status)
            ->pluck('user_id')
            ->unique()
            ->values();


            

        $student_list = $this->student
            ->select('id', 'username', 'present_id_card_code', 'ex_id_card_code', 'student_roll_number')
            ->whereIn('id', $history_list)
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('username', 'LIKE', $txt)
                        ->orWhere('email', 'LIKE', $txt)
                        ->orWhere('contact_number', 'LIKE', $txt)
                        ->orWhere('student_roll_number', 'LIKE', $txt)
                        ->orWhereTranslationLike('first_name', $txt)
                        ->orWhereTranslationLike('last_name', $txt);

                });
            })->where('status', $status)
            ->paginate($paginate);


        $student_list->getCollection()->transform(function ($student) {
            return [
                'id' => $student->id,
                'username' => $student->username,
                'full_name' => $student->full_name,
                'first_name' => $student->first_name,
                'last_name' => $student->last_name,
                'student_roll_number' => $student->studentSingleHistory->student_full_roll_number ?? null,
                'present_id_card_code' => $student->present_id_card_code,
                'ex_id_card_code' => $student->ex_id_card_code,
            ];
        });

        return response()->json($student_list, 200);

    }


    public function saveUpdateStudentRfIdCardCode(Request $request)
    {
        try {


            if (count($request->studentList)) {


                foreach ($request->studentList as $key => $value) {
                    $this->student->where('id', $value['id'])->update([
                        'present_id_card_code' => $value['present_id_card_code'],
                        'ex_id_card_code' => $value['ex_id_card_code'],
                    ]);
                }

                return Response::json(['message' => 'Card Numbers Updated Successfully!', 'mode' => 'success'], 200);
            }
            return Response::json(['message' => 'No Data Found To Update', 'mode' => 'warning'], 410);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage(), 'mode' => 'warning'], 410);
        }

    }


}
