<?php

namespace App\Http\Controllers\Site\Student\Attendance;


use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSubject;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Role\Role;
use App\Models\Setting\Setting;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\Attendance\StudentAbsentDetail;
use App\Traits\LiveStreamingApiTrait;
use App\Traits\SmsFunctionsTrait;
use App\Traits\TimeRelatedFunctionTrait;
use Auth;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicClass;
use Illuminate\Contracts\View\Factory;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\JsonResponse;
use Illuminate\View\View;
use Log;
use PDF;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use App\Models\Academic\AcademicShift;
use App\Models\Site\SiteInfo;
use Carbon\Carbon;
use App\Models\Site\SiteShiftDetails;
use Illuminate\Support\Facades\Session;
use Response;

class StudentAttendanceController extends ProjectController
{
    use  SmsFunctionsTrait, TimeRelatedFunctionTrait, LiveStreamingApiTrait;
    private $carbon_now;

    private $studentAttendance;
    private $absentDetail;
    private $setting;
    private $user;
    private $siteShiftDetails;
    private $academicClass;
    private $academicSection;
    private $periodTypeDuration;
    private $routineDetail;
    private $siteShiftClassGroupSectionSetting;
    private $routineAllocation;
    private $studentHistory;
    private $student;
    private $infoSetting;

    public function __construct(RoutineDetail $routineDetail, StudentAttendance $studentAttendance, Setting $setting, User $user, RoutineAllocation $routineAllocation,
                                SiteShiftDetails $siteShiftDetails, AcademicSection $academicSection, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting,
                                AcademicClass $academicClass, SitePeriodTypeDuration $periodTypeDuration, StudentHistory $studentHistory, Student $student,
                                StudentAbsentDetail $absentDetail, SiteInfoSetting $infoSetting
    )
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker', ['except' => ['getAbsentDetails']]);
        $this->carbon_now = Carbon::now();

        $this->studentAttendance = $studentAttendance;
        $this->absentDetail = $absentDetail;
        $this->setting = $setting;
        $this->user = $user;
        $this->studentHistory = $studentHistory;
        $this->student = $student;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->academicClass = $academicClass;
        $this->academicSection = $academicSection;
        $this->routineDetail = $routineDetail;
        $this->routineAllocation = $routineAllocation;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->absentDetail = $absentDetail;
        $this->infoSetting = $infoSetting;
    }


    public function manualAttendance()
    {
        $viewType = 'Period Wise Student Attendance';
        return view('default.admin.layouts.master', compact('viewType'));

    }

    /**
     * @return Factory|View
     */

    public function studentAttendance()
    {

        $viewType = 'Student Attendance Master View';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    function replace_callback($matches)
    {
        $replace = array(
            'title' => 'Hello World',
            'list' => '<li>Step 1</li><li>Step 2</li>', // an so on
        );

        if (array_key_exists($matches[1], $replace)) {
            return $replace[$matches[1]];
        } else {
            return '';
        }
    }

    public function studentAttendanceForStudent()
    {

        $viewType = 'Student Attendance Manual Admin';
        return view('default.admin.attendance.view-student-attendance', compact('viewType'));
    }


    public function reportMaster()
    {

        $viewType = 'Student Attendance Report';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    /**
     * @param $class_id
     * @param $section_id
     * @param $start_date
     * @param $end_date
     * @return StudentAttendance[]|Builder[]|Collection
     */
    public function getStudentAllAttendanceListBySection($class_id, $section_id, $start_date, $end_date)
    {
        $first_date = $start_date;
        $last_date = $end_date;
        $user_Attendance = $this->studentAttendance->with('user', 'academicClass', 'academicSection')->whereBetween('present_date', [$first_date, $last_date])->where('academic_class_id', $class_id)->where('academic_section_id', $section_id)->get();
        return $user_Attendance;

    }


     public function getStudentDeviceAttendanceListByDate(Request $request)
    {

      
        //  try {
        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            throw new Error('Please select version , year , shift , class');
        }
        $att_date = $request->att_date;
        $present = $request->present;
        $leave = $request->leave;
        $absent = $request->absent;
        $search_txt = $request->search_txt;
        $status = $request->status;
        $paginate = $request->paginate ?? 20;
        $txt = '%' . $search_txt . '%';
        if ($present && $leave && $absent) {
            $present = 0;
            $leave = 0;
            $absent = 0;
        }
        $advance_date = ($this->carbon_now->toDateString() < $att_date);
        if ($advance_date) {
            throw new Error('The date can"t be future date!');
        }
        if (!$att_date) {
            throw new Error('Select * Marked Fields!');
        }
        $day = date('D', strtotime($att_date));
        $get_period_type_duration = $this->periodTypeDuration
            ->where('start_date', '<=', $att_date)
            ->where('end_date', '>=', $att_date)
            ->first();
        if (!$get_period_type_duration) {
            throw new Error('No Period Found On ' . $att_date);
        }

        $st_list = null;
     //   dd($txt);
            $student_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhere('student_roll_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            //    $q->orderBy('in_time', 'ASC');
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->orderBy('student_roll_number')
            ->where('status', $status)
            ->paginate($paginate);
            // ->sortBy(function($query){
            //     $query->attendance;
            // });

            
        if($present && ($absent || $leave)){
            $st_att_list = $student_list;
        }elseif($absent || $leave){
        
            $student_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(($absent || $leave), function ($qu) use ($att_date) {
                return $qu->whereHas('attendance', function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                })->orWhereHas('leaveDetail', function ($q) use ($att_date) {
                    $q->leaveToday($att_date);
                });
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhere('student_roll_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->get();

        

        $present_student_id = $student_list->pluck('id')
        ->unique()
        ->filter();;
    
    
        $absent_student = $this->studentHistory
        ->when($data['academic_version_id'], function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })->when($data['academic_year_id'], function ($query) use ($data) {
            return $query->where('academic_year_id', $data['academic_year_id']);
        })->when($data['academic_shift_id'], function ($query) use ($data) {
            return $query->where('academic_shift_id', $data['academic_shift_id']);
        })->when($data['academic_class_id'], function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })->when($data['academic_department_id'], function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })->when($data['academic_section_id'], function ($query) use ($data) {
            return $query->where('academic_section_id', $data['academic_section_id']);
        })->when($data['academic_class_group_id'], function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })->when($data['academic_session_id'], function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })->whereNotIn('id',$present_student_id)
        ->with(['student'])
        ->with(['attendance' => function ($q) use ($att_date) {
            $q->where('present_date', $att_date);
        }, 'absent' => function ($q) use ($att_date) {
            $q->where('absent_date', $att_date);
        }, 'leaveDetail' => function ($q) use ($att_date) {
            $q->where('leave_date', $att_date);
        }
        ])
        ->where('status', $status)
        ->paginate($paginate);

        $st_att_list = $absent_student;
    
    }elseif($present){
            $student_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })->when($data['academic_session_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })

            ->when(($present), function ($qu) use ($att_date) {
                return $qu->whereHas('attendance', function ($q) use ($att_date) {
                    $q->where('present_date', $att_date);
                })->orWhereHas('leaveDetail', function ($q) use ($att_date) {
                    $q->leaveToday($att_date);
                });
            })
            ->when($search_txt, function ($qu) use ($txt) {
                $qu->whereHas('student', function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhere('student_roll_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                });
            })
            ->with(['student'])
            ->with(['attendance' => function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            }, 'absent' => function ($q) use ($att_date) {
                $q->where('absent_date', $att_date);
            }, 'leaveDetail' => function ($q) use ($att_date) {
                $q->where('leave_date', $att_date);
            }
            ])
            ->where('status', $status)
            ->paginate($paginate);

            $st_att_list = $student_list;

        }
      else{
        $st_att_list = $student_list; 
      }
    
            $st_shift_details = $this->siteShiftDetails->where('academic_shift_id', $data['academic_shift_id'])
            ->where('belongs_to', 'student')
            ->where('academic_period_type_id', $get_period_type_duration->academic_period_type_id)
            ->where('academic_group_id', $get_period_type_duration->academic_group_id)
            ->where('week_day', $day)
            ->where('status', true)
            ->first();
        if (!$st_shift_details) {
            throw new Error('Shift Setting not found!');
        }
        $class_present = $this->studentAttendance
            ->where('present_date', $att_date)
            ->whereIn('student_history_id', $st_att_list->pluck('id')->toArray())
            ->get();

        $present_count = $class_present->count();
        //  return $class_present->count();
        $st_att_list->getCollection()->transform(function ($value) use ($get_period_type_duration,  $day, $att_date, $st_shift_details, $st_att_list) {
            $late_status = $value->attendance->late_status ?? $this->checkStIsLate(($value->attendance->in_time ?? $st_shift_details->in_time ?? '00:00:00'), $st_shift_details);
            
           
           //========== select contact number for any condition ============
            if($value->student->sms_contact_field=="contact_number"){
                if($value->student->contact_number==""){
                    if($value->student->father_contact_number==""){
                        $number = $value->student->mother_contact_number;
                    }else{
                        $number = $value->student->father_contact_number;
                    }
                }else{
                    $number = $value->student->contact_number;
                }
            }
            if($value->student->sms_contact_field=="father_contact_number"){
                if($value->student->father_contact_number==""){
                    if($value->student->mother_contact_number==""){
                        $number = $value->student->contact_number;
                    }else{
                        $number = $value->student->mother_contact_number;
                    }
                }else{
                    $number = $value->student->father_contact_number;
                }
            }
            if($value->student->sms_contact_field=="mother_contact_number"){
                if($value->student->mother_contact_number==""){
                    if($value->student->father_contact_number==""){
                        $number = $value->student->contact_number;
                    }else{
                        $number = $value->student->father_contact_number;
                    }
                }else{
                    $number = $value->student->mother_contact_number;
                }
            }
           //====    
           // dd($value->student->gender);
           if($value->student->gender->head_key=='boys'){
            $default_image = '/uploads/student-boy.png';
           }elseif($value->student->gender->head_key=='girls'){
            $default_image = '/uploads/student-girl.png';
           }else{
            $default_image = '/uploads/student-boy.png';
           }


            return [
                'id' => $value->id ?? null,
                'date' => $att_date ?? null,
                'student_attendance_id' => $value->attendance->id ?? null,
                // 'attendance_existed' => $attendance_existed ?? 0,
                'present' => ($value->attendance ? 1 : 0),
                // ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : ($attendance_existed ? 0 : 1))
                'sms_sending' => false,
                'st_status' => ($value->leaveDetail) ? "In Leave" : (($value->attendance) ? "Present" : "Absent"),
                'st_status_int' => ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : 0),
                //Absent
                'absent' => $value->absent ?? null,
                'absent_sms_status' => $value->absent->sms_status ?? null,
                //Leave
                'in_leave' => $value->leaveDetail ? 1 : 0,
                'leave_id' => $value->leaveDetail->id ?? null,
                //other data
                'username' => $value->student->username ?? 'n/a',
               // 'latest_photo' => $value->student->latestPhoto->path ?? 'n/a',
                'latest_photo' => $value->student->latestPhoto?$value->student->latestPhoto->path : $default_image,

                'attendance_sms' => $value->student->attendance_sms ?? 'n/a',
                'student_roll_number' => $value->student_full_roll_number ?? 'n/a',
                'contact_number' => $number ?? 'n/a',
                'sms_contact_field' => $value->student->sms_contact_field ?? '',
                'name' => ($value->student->full_name ?? 'n/a'),
                'details' => ($value->department->name ?? '') . '-' . ($value->stClass->class_name ?? '') . '-' . ($value->section->section_name ?? '') . '-' . ($value->classGroup->group_name ?? ''),
                'year_name' => $value->year->year_name ?? 'n/a',
                'version_name' => $value->version->version_name ?? 'n/a',
                'shift_name' => $value->shift->shift_name ?? 'n/a',
                'dept_name' => $value->department->name ?? 'n/a',
                'class_name' => $value->stClass->class_name ?? 'n/a',
                'class_group' => $value->classGroup->group_name ?? 'n/a',
                'section_name' => $value->section->section_name ?? 'n/a',
                'session' => $value->session->session_name ?? 'n/a',
                'in_sms_id' => $value->attendance->in_sms_id ?? null,
                'in_sms_sending' => false,
                'out_sms_id' => $value->attendance->out_sms_id ?? null,
                'out_sms_sending' => false,
                'present_type' =>  $value->attendance->present_type ?? null,
                'site_shift_details_id' =>  null,
                'in_time' => $value->attendance->in_time ?? null,
                'out_time' => $value->attendance->out_time ?? null,
                'present_date' => $att_date,
                'in_time_grace' =>  '',
                'out_time_grace' =>  '',
                'late_status' => $late_status,
                'site_id' => $value->site_id ?? null,
                'updated_at' => $value->attendance->updated_at ?? null,
                'updated_by' => $value->attendance->updateBy->full_name ?? null,
            ];
        });
        if (count($st_att_list) < 1) {
            throw new Error('No Attendance Found For: ' . date('d M Y', strtotime($att_date)));
        }
        $total_present = $this->getDateAttendanceCount($data, $att_date);
        $present_date = date('Y-m-d', strtotime($att_date));
        return response()->json([$st_att_list, $total_present, $present_date, $present_count], 200);
        /* } catch (Exception $exception) {
             throw new Error($exception->getMessage());
         }*/
    }


    public function updateStudentDeviceAttendance(Request $request)
    {
        try {

          
            $data = $request->attData;
            $att_date = $request->present_date;
           

            if (count($data) <= 0) {
                return Response::json(['message' => 'No Date Found!'], 410);
            }

            $not_saved = [];
            $saved = 0;
            $updated = 0;
            $save_updated_ids = [];

           
            if (count($data) > 0) {
              //  $item=$data[0];
                    foreach($data as $item){
               
                    if ($item['site_shift_details_id'] || $item['st_status_int'] < 2) {//skipping leave student
                        $st_attendance = new StudentAttendance();
                        $student_attendance_id = $item['student_attendance_id'];
                        if ($student_attendance_id) {// previous att found

                            $existed = $st_attendance
                                ->whereId($student_attendance_id)->first();
                            if ($existed && !$item['present']) {
                                $existed->delete();
                            }

                            if ($existed && ($existed->in_time != $item['in_time'] || $existed->out_time != $item['out_time'] || $existed->late_status != $item['late_status'])) {

                                /*  Log::info($item);
                                  Log::info($item['username'].'= in:'.$existed->in_time . '-' . $item['in_time'] . '- out:' . $existed->out_time . '-' . $item['out_time'] . '-' . $existed->late_status . '-' . $item['late_status']);*/

                                $existed->in_time = $item['in_time'];
                                $existed->out_time = $item['out_time'];
                                $existed->late_status = $item['late_status'];
                                $existed->present_type = 'web';
                                $existed->updated_by = Auth::user()->id;
                                $existed->save();

                                $updated++;
                            }
                        } else {

                           

                            if ($item['present'] && $item['in_time'] != null) {

                                $existed = $st_attendance
                                    ->where('student_history_id', $item['id'])
                                    ->where('present_date', $item['present_date'])
                                    ->first();
                                   

                                if ($existed && ($existed->in_time != $item['in_time'] || $existed->out_time != $item['out_time'] || $existed->late_status != $item['late_status'])) {

                                    $existed->in_time = $item['in_time'];

                                    $existed->save();
                                    $updated++;
                                   

                                } else if (!$existed) {
                                   
                                    /////=====//////
                                    $date = $item['present_date'];
                                    $st_attendance->student_history_id = $item['id'];
                                    $st_attendance->site_shift_details_id = $item['site_shift_details_id'];
                                    $st_attendance->present_date = $date;
                                    $st_attendance->in_time = $item['in_time'];
                                    $st_attendance->out_time = $item['out_time'];
                                    $st_attendance->present_year = $item['year_name'];
                                    $st_attendance->present_month = date("m", strtotime($date) );
                                    $st_attendance->present_day =  date("d", strtotime($date) );
                                    $st_attendance->present_date_time =  date("Y-m-d h:i:sa");
                                    ///==========
                                  
                                    $st_attendance->present_type = 'web';
                                    $st_attendance->late_status = $item['late_status'];
                                    $st_attendance->created_by = Auth::user()->id;
                                    $st_attendance->updated_by = Auth::user()->id;
                                    $st_attendance->save();
                                    $saved++;
                                }
                            }
                        }
                    }
                    }


                $not_saved_msg = '';
                if (count($not_saved)) {
                    $not_saved_msg = ': No Shift Setting Found: ' . implode(',', $not_saved);
                }


                $st_att_list = $this->studentHistory

                    ->with(['attendance' => function ($q) use ($att_date) {
                        $q->where('present_date', $att_date);
                    }, 'absent' => function ($q) use ($att_date) {
                        $q->where('absent_date', $att_date);
                    }, 'leaveDetail' => function ($q) use ($att_date) {
                        $q->where('leave_date', $att_date);
                    }
                    ])
                    ->get()->map(function ($value) use ($att_date) {

                        return [
                            'id' => $value->id ?? null,
                            'student_attendance_id' => $value->attendance->id ?? null,
                            'present' => ($value->attendance ? 1 : 0),
                            'sms_sending' => false,
                            'st_status' => ($value->leaveDetail) ? "In Leave" : (($value->attendance) ? "Present" : "Absent"),
                            'st_status_int' => ($value->leaveDetail) ? 2 : (($value->attendance) ? 1 : 0),

                            //Absent
                            'absent' => $value->absent ?? null,
                            'absent_sms_status' => $value->absent->sms_status ?? null,

                            //Leave
                            'in_leave' =>  0,
                            'leave_id' =>  null,

                            //other data
                            'attendance_sms' => $value->student->attendance_sms ?? 'n/a',

                            'session' =>  'n/a',
                            'in_sms_id' =>  null,
                            'out_sms_id' =>  null,
                            'present_type' => 'web',
                            'site_shift_details_id' => $value->attendance->site_shift_details_id ?? null,
                            'updated_at' => $value->attendance->updated_at ?? null,
                            'updated_by' => $value->attendance->updateBy->full_name ?? null
                        ];

                    });

                   // dd($st_att_list);
                return response()->json(['message' => 'Student attendance Saved:' . $saved . ' Updated:' . $updated . $not_saved_msg, 'updated_st' => $st_att_list], 200, []);
            }

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    private function getDateAttendanceCount($data, $att_date)
    {
        $st_att_list = $this->studentHistory
            ->when($data['academic_version_id'], function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })->when($data['academic_year_id'], function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })->when($data['academic_class_id'], function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })->whereHas('attendance', function ($q) use ($att_date) {
                $q->where('present_date', $att_date);
            })->where('status', 1)
            ->count();

        return $st_att_list;
    }


    public function attendanceSms(Request $request)
    {
        try {
            $sms_type = $request->type;
            $att_data = $request->st_history;
            $site_id = $att_data['site_id'];
            $contact_number = $att_data['contact_number'];
           // dd($request->all());

            $att_existed = $this->studentAttendance
                ->where('student_history_id', $att_data['id'])
                ->where('present_date', $att_data['present_date'])
                ->first();

            $studentAttendance = new StudentAttendance();

            if ($att_existed) {//in_sms_his
                $att_existed->updated_by = Auth::user()->id;
                $att_existed->save();
            } else {
                $studentAttendance->student_history_id = $att_data['id'];
                $studentAttendance->present_type = 'web';
                $studentAttendance->site_shift_details_id = $att_data['site_shift_details_id'];
                $studentAttendance->in_time = $att_data['in_time'];
                $studentAttendance->late_status = $att_data['late_status'];
                $studentAttendance->created_by = Auth::user()->id;
                $studentAttendance->updated_by = Auth::user()->id;
                $studentAttendance->save();
            }

            $student_attendance_id = $att_existed->id ?? $studentAttendance->id;

            $att_data_for_queue = [];
            $att_data_for_queue['att_user_type'] = 'student';
            $att_data_for_queue['att_type'] = 'in';//in or out
            $att_data_for_queue['att_table_id'] = $student_attendance_id;


            $the_att = $att_existed ?? $studentAttendance;

            $site = SiteInfo::whereId($site_id)->first();
            $info_setting = $this->infoSetting
                ->where('status', 1)
                ->first();

            $lang = $info_setting->sms_lang ?? 'en';
            $site_name = $info_setting->site->translate($lang, 'en')->site_name ?? 'n/a';
            $site_short_name = $info_setting->site->translate($lang, 'en')->short_name ?? 'n/a';
            $formatted_date = $this->getDateInDifferentLanguage($att_data['present_date'], $lang);


            $st_history = $this->studentHistory
                ->where('id', $att_data['id'])
                ->first();


            if ($sms_type == 'in') {// in sms

                if (!$info_setting->st_in_sms) {
                    throw new Error('Student In SMS Option Off');
                }

                if (!$the_att->in_time) {
                    throw new Error('Save InTime First!');
                }

                $sms_text = $info_setting->present_in_sms_text ?? '[full_name]';


                $st_history1 = [];
                $st_history1['full_name'] = ($st_history->student->translate($lang, 'en')->first_name ?? '') . ' ' . ($st_history->student->translate($lang, 'en')->last_name ?? '');
                $st_history1['in_time'] = date('g:i A', strtotime($the_att->in_time));
                $st_history1['contact_number'] = $contact_number;
                $st_history1['date'] = date('Y-m-d', strtotime($the_att->present_date));
                $st_history1['present_date'] = $formatted_date;
                $st_history1['site_name'] = $site_name ?? '';
                $st_history1['site_short_name'] = $site_short_name ?? '';


                //Loop through the values replacing `[$key]` with $value
                foreach ($st_history1 as $key => $value) {
                    $sms_text = str_replace('[' . $key . ']', $value, $sms_text);
                }

                $att_data_for_queue = [];
                $att_data_for_queue['att_user_type'] = 'student';
                $att_data_for_queue['att_type'] = 'in';//in or out
                $att_data_for_queue['att_table_id'] = $the_att->id;


                $pre_sms_id = $the_att->in_sms_id;
                $the_att->in_sms_id = 1;
                $the_att->in_sms_his = $the_att->in_sms_his . ',' . $pre_sms_id;
                $the_att->save();

            }

            if ($site && $sms_type == 'out') {// out sms

                if (!$info_setting->st_out_sms) {
                    // throw new Error('Student Out SMS Option Off');
                }

                if (!$the_att->out_time) {
                    throw new Error('Save Out Time First!');
                }
                $sms_text = $info_setting->present_out_sms_text ?? '[full_name]';

                $st_history1 = [];
                $st_history1['full_name'] = ($st_history->student->translate($lang, 'en')->first_name ?? '') . ' ' . ($st_history->student->translate($lang, 'en')->last_name ?? '');
                $st_history1['out_time'] = date('g:i A', strtotime($the_att->out_time));

                $previous_out_id = $the_att->out_sms_id;
                $the_att->out_sms_his = $the_att->out_sms_his . ',' . $previous_out_id;
                $the_att->out_sms_id = 1;
                $the_att->save();

                //Loop through the values replacing `[$key]` with $value
                foreach ($st_history1 as $key => $value) {
                    $sms_text = str_replace('[' . $key . ']', $value, $sms_text);
                }
            }


            $this->sendAttendanceSms([$contact_number], $sms_text, $site_id, $att_data_for_queue);
            return response()->json(['message' => 'Congrats, User Will Receive SMS Soon', 'att_data' => $the_att], 200, []);

        } catch (Exception $exception) {
            return response()->json(['message' => $exception->getMessage()], 411, []);
        }
    }


    public function sendAbsentSms(Request $request)
    {

      //  dd($request->all());
        $students = $request->absent_students;
        $fetched_date = $request->fetched_date;
        $req_sms_text = $request->sms_text;

        if (count($students)) {
            $result = '';
            $total = 0;

            $info_setting = $this->infoSetting
                ->select('id', 'absent_sms_txt', 'absent_sms_lang', 'academic_group_id', 'site_id')
                ->where('status', 1)
                ->first();

            if (!$info_setting) {
                throw new Error('No Active Info Setting Found!');
            }
            $sms_text = $req_sms_text ?? $info_setting->absent_sms_txt ?? '[full_name]';
            $lang = $info_setting->absent_sms_lang ?? 'en';
            $site_name = $info_setting->site->translate($lang, 'en')->site_name ?? 'n/a';
            $site_short_name = $info_setting->site->translate($lang, 'en')->short_name ?? 'n/a';
            $formatted_date = $this->getDateInDifferentLanguage(null, $lang);


            foreach ($students as $k => $student) {

                $st_history = $this->studentHistory
                    ->where('id', $student['history_id'])
                    ->first();

                $site_id = $student['site_id'];
                $contact_number = $student['contact_number'];

               
                $history_id = $student['history_id'];


                $absent_existed = $this->absentDetail
                    ->where('student_history_id', $history_id)
                    ->where('absent_date', $student['date'])
                    ->first();

                    $student_absent = new  StudentAbsentDetail();

                if ($absent_existed) {
                    $absent_existed->sms_his = ($absent_existed->sms_his . ',' . $absent_existed->sms_followup_id);
                    $absent_existed->sms_status = false;
                    $absent_existed->created_by = Auth::user()->id;
                    $absent_existed->save();
                } else {
                    $student_absent->user_id = $student['id'];
                    $student_absent->student_history_id = $history_id;
                    $student_absent->sms_status = false;
                    $student_absent->absent_date = $student['date'];
                    $student_absent->created_by = Auth::user()->id;
                    $student_absent->save();
                }

                $the_absent = $absent_existed ?? $student_absent;


                $att_data_for_queue = [];
                $att_data_for_queue['table_id'] = $the_absent->id;
                $att_data_for_queue['site_id'] = $site_id;


                $student['full_name'] = ($st_history->student->translate($lang, 'en')->first_name ?? '') . ' ' . ($st_history->student->translate($lang, 'en')->last_name ?? '');
                $student['site_name'] = $site_name ?? '';
                $student['site_short_name'] = $site_short_name ?? '';
                $student['absent_date'] = $formatted_date ?? 'no date';
                $student['nl'] = ', ';


                $userMessage = $sms_text; //create a copy of the message template

                //Loop through the values replacing `[$key]` with $value
                foreach ($student as $key => $value) {
                    $userMessage = str_replace('[' . $key . ']', $value, $userMessage);
                }

             //   [full_name] আজ অনুপস্থিত[\n]তারিখ:[absent_date][nl]Regards:[site_name]


                $result .= $this->sendStudentAbsentSmsUsingQueue([$contact_number], $userMessage, $att_data_for_queue);
                $total++;


            }
            return Response::json(['message' => 'Total Numbers:' . $total], 200);

        }

    }

    public function sendPeriodicAttendanceCountSms(Request $request)
    {

        $students = $request->students;
        $date = $request->date;
      
        //  return $students;

        if (count($students)) {
            $result = '';
            $total = 0;

            /*   $info_setting = $this->infoSetting
                   ->select('id', 'absent_sms_txt', 'absent_sms_lang', 'academic_group_id', 'site_id')
                   ->where('status', 1)
                   ->first();

               if (!$info_setting) {
                   throw new Error('No Active Info Setting Found!');
               }
               $sms_text = $req_sms_text ?? $info_setting->absent_sms_txt ?? '[full_name]';
               $lang = $info_setting->absent_sms_lang ?? 'en';
               $site_name = $info_setting->site->translate($lang, 'en')->site_name ?? 'n/a';
               $site_short_name = $info_setting->site->translate($lang, 'en')->short_name ?? 'n/a';
               $formatted_date = $this->getDateInDifferentLanguage(null, $lang);*/

              // dd($students);

            foreach ($students as $k => $student) {
                $userMessage = $date . ' [nl]';
                $contact_number = [$student['contact_number']];
                foreach ($student['data'] as $k1 => $subDetail) {

                    $userMessage .= $subDetail['s_name'] . ' Total:' . $subDetail['total_period'] . ' Attended:' . $subDetail['attended'] . ' Absent: ' . $subDetail['absent'] . ' [nl]'; //create a copy of the message template                }
                }
                $result .= $this->sendSms(Session::get('SITE_ID'), $contact_number, $userMessage);
                $issue = new    IssueDetail();
                $issue->username = $student['username'];
                $issue->bearer_type = 'edu';
                $issue->issue_type = 'sms:periodic_all';
                $issue->issue_details = $student['contact_number'] . '@ ' . $userMessage;
                $issue->save();

                $total++;

            }
            return Response::json(['message' => 'Total Numbers: ' . $total], 200);
        }
        return Response::json(['message' => 'Please select at least one!'], 412);

    }

    public
    function deviceAttendanceReport($attendance_date, $attendance_type, $version = null, $year = null, $shift = null, $dept = null, $class = null, $class_group = null, $section = null, $session = null)
    {


        $report_tittle = 'Student Attendance Report';
        $site = SiteInfo::findOrFail(Session::get('SITE_ID'));


        $academic_version_id = $version;
        $academic_year_id = $year;
        $academic_shift_id = $shift;
        $academic_department_id = $dept;

        $academic_class_id = $class;
        $academic_class_group_id = $class_group;
        $academic_section_id = $section;
        $academic_session_id = $session;


        $att_date = $attendance_date;
        $att_type = $attendance_type;

        $att_data = null;
        if ($att_type == 1) {//only date wise
            $att_data = $this->studentAttendance
                ->where(function ($query) {
                    $query->where('present_type', 'device')
                        ->orWhere('present_type', 'web');
                })->with(['studentHistory.student' => function ($q) {
                    $q->select(['id', 'username']);
                }])
                ->with(['studentHistory.stClass', 'studentHistory.section'])
                ->where('present_date', $att_date)
                ->get();


        } elseif ($att_type == 2) {//class wise


            $data = [];
            $data['academic_version_id'] = $academic_version_id == 'null' ? null : $academic_version_id;
            $data['academic_year_id'] = $academic_year_id == 'null' ? null : $academic_year_id;
            $data['academic_shift_id'] = $academic_shift_id == 'null' ? null : $academic_shift_id;
            $data['academic_department_id'] = $academic_department_id == 'null' ? null : $academic_department_id;
            $data['academic_class_id'] = $academic_class_id == 'null' ? null : $academic_class_id;
            $data['academic_class_group_id'] = $academic_class_group_id == 'null' ? null : $academic_class_group_id;
            $data['academic_section_id'] = $academic_section_id == 'null' ? null : $academic_section_id;
            $data['academic_session_id'] = $academic_session_id;


            $this->checkClassSectionGroup($data['academic_version_id'], $data['academic_year_id'], $data['academic_shift_id'], $data['academic_department_id'],
                $data['academic_class_id'], $data['academic_class_group_id'], $data['academic_section_id'], $data['academic_session_id']);


            $att_data = $this->studentAttendance
                ->where(function ($query) {
                    $query->where('present_type', 'device')
                        ->orWhere('present_type', 'web');
                })
                ->with(['studentHistory.student', 'studentHistory.stClass', 'studentHistory.section'])
                ->where('present_date', $att_date)
                ->whereHas('studentHistory', function ($query) use ($data) {
                    $query->where('academic_version_id', $data['academic_version_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('academic_shift_id', $data['academic_shift_id'])
                        ->where('academic_class_id', $data['academic_class_id'])
                        ->when($data['academic_department_id'], function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })->when($data['academic_class_group_id'], function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })->when($data['academic_section_id'], function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        });
                })
                ->get();

            // dd($att_data);
        }

        /*elseif ($att_type == 3) {//student wise
            $attendance_data = $this->studentAttendance
                ->where('present_type', 'device')
                ->with(['studentHistory.student', 'studentHistory.stClass', 'studentHistory.section'])
                ->where('present_date', $att_date)
                ->whereHas('studentHistory.student', function ($query) use ($request) {
                    $query->where('username', $request->user_name);

                })
                ->get();
        }*/
        //  $this->calculateStudentAttendanceStatus();

        // return response()->json([$attendance_data], 200, [], JSON_NUMERIC_CHECK);

        // return view('default.admin.site.student.attendance.report.report', compact('att_date', 'report_tittle', 'att_data', 'site'));
        $pdf = PDF::loadView('default.admin.site.student.attendance.report.report', compact('att_date', 'att_type', 'report_tittle', 'att_data', 'site'));
        return $pdf->stream(time() . '-shift-details.pdf');


    }

    public
    function getStudentAllAttendanceListByClass($class_id, $start_date, $end_date)
    {
        $first_date = $start_date;
        $last_date = $end_date;
        $user_Attendance = $this->studentAttendance->with('user', 'academicClass', 'academicSection')->whereBetween('present_date', [$first_date, $last_date])->where('academic_class_id', $class_id)->get();
        return $user_Attendance;

    }

    public
    function getStudentAllAttendanceListByRollDate($year1, $month1, $day1, $year2, $month2, $day2, $roll)
    {
        $first_date = $year1 . '-' . $month1 . '-' . $day1;
        $last_date = $year2 . '-' . $month2 . '-' . $day2;
        $user_Attendance = $this->studentAttendance->with('user', 'academicClass', 'academicSection')->whereBetween('present_date', [$first_date, $last_date])->where('roll_no', $roll)->get();
        return $user_Attendance;


    }


    public
    function addStudentBiometricID(Request $request)
    {
        try {
            foreach ($request->studentDataList as $key => $value) {
                if ($value["biometric_id"]) {
                    $users = new Student();
                    $user = $users->where('id', $value["id"])->first();
                    $user->update([
                        'biometric_id' => $value["biometric_id"]
                    ]);
                }
            }
            return Response::json(['message' => 'Biometric ID Successfully Added'], 200);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }


    public
    function getSubjectByRoutineDetailsId($period_id)
    {
        try {

            $getRoutineDetails = $this->routineDetail->findOrFail($period_id);
            $subject_ids = $getRoutineDetails->routineAllocations->pluck('subject_id', 'id');

            $subjects = [];

            foreach ($subject_ids as $key => $subject_id) {
                $subjects[$key] = AcademicSubject::where('id', $subject_id)->first();
            }
            if (count($subjects) <= 0) {
                return Response::json(['message' => 'No Subject Assigned For ' . $getRoutineDetails->weekday . ' ' . $getRoutineDetails->name . ' Period'], 410);
            }
            return response()->json($subjects, 200, [], JSON_NUMERIC_CHECK);

        } catch (ModelNotFoundException $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);

        }
    }


    public
    function getAbsentStudents(Request $request)
    {

        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id;
            $data['academic_section_id'] = $request->academic_section_id;
            $data['academic_session_id'] = $request->academic_session_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id;
            $paginate = $request->paginate ?? 20;

            $search_txt = $request->search_txt;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';

            $today = $date = date('Y-m-d', strtotime($this->carbon_now));

            $absent_students = $this->studentHistory
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })->when($search_txt, function ($qu) use ($txt) {
                    $qu->whereHas('student', function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    });
                })
                ->where(function ($q) use ($today) {
                    $q->whereDoesntHave('attendance', function ($q1) use ($today) {
                        $q1->PresentByDate($today);
                    });
                })
                ->whereHas('student', function ($q) use ($today) {
                    $q->where('status', true)
                        ->where('attendance_sms', true);
                })
                ->with(['student' => function ($q) {
                    $q->select('user_type', 'id', 'username', 'attendance_sms', 'contact_number');
                }])->with(['absent' => function ($q) use ($today) {
                    $q->where('absent_date', $today);
                    $q->orderBy('id', 'DESC');
                }])
                ->orderBy('academic_class_id', 'ASC')
                ->orderBy('academic_section_id', 'ASC')
                ->orderBy('student_roll_number', 'ASC')
                ->where('status', $status)
                ->paginate($paginate);

            $absent_students->getCollection()->transform(function ($st_history) use ($today) {
               
                return [
                    'id' => $st_history->user_id,
                    'history_id' => $st_history->id,
                    'full_name' => $st_history->full_name,
                    'username' => $st_history->student->username,
                    'student_roll_number' => $st_history->student_full_roll_number,
                    'attendance_sms' => $st_history->student->attendance_sms,
                    'contact_number' => $st_history->student->contact_number,
                    'absent_sms_status' => $st_history->absent->sms_status ?? null,
                    'checked' => $st_history->absent ? 0 : 1,
                    'st_status_int' => ($st_history->leaveDetail) ? 2 : (($st_history->attendance) ? 1 : 0),
                    'date' => $today,
                    'absent_date' => date('d M Y', strtotime($today)),
                    'site_id' => $st_history->site_id ?? 0,
                ];
            });

            if (count($absent_students) < 1) {
                throw new Error('No Student Found!');
            }

            $info_setting = $this->infoSetting
                ->select('id', 'absent_sms_txt', 'absent_sms_lang')
                ->first();

            return response()->json([$absent_students, $info_setting], 200);
            //    return Response::json([$st_list, $id_array], 200);

        } catch (ModelNotFoundException $exception) {
            throw new Error($exception->getMessage());

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public
    function getAbsentDetails(Request $request)
    {

        try {

            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $absent_date = $request->date;
            $finger_taken = $request->finger_taken;
            $attendance_sms = $request->attendance_sms;

            /*if (!$user_type) {
                            throw new Exception('Check At Least One Type!' . $user_type);
                        }*/

            $txt = '%' . $search_txt . '%';

            $users = $this->absentDetail
                ->with(['student' => function ($q) use ($search_txt, $txt) {
                    $q->when($search_txt, function ($q) use ($txt) {
                        return $q->where(function ($query) use ($txt) {
                            $query->where('username', 'LIKE', $txt)
                                ->orWhere('email', 'LIKE', $txt)
                                ->orWhere('contact_number', 'LIKE', $txt)
                                ->orWhereTranslationLike('first_name', $txt)
                                ->orWhereTranslationLike('last_name', $txt);
                        });
                    })
                        ->select('id', 'username', 'user_type', 'email', 'contact_number', 'status', 'finger_taken', 'attendance_sms');
                }, 'follow'])->when($absent_date, function ($q) use ($absent_date) {
                    return $q->where('absent_date', $absent_date);
                })->orderBy('id', 'DESC')
                ->paginate($paginate);

            if (count($users) < 1) {
                throw new Exception('No Data Found!');
            }
            return response()->json($users, 200, []);

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getAttendanceSettingDetails(Request $request)
    {

        try {

            $data = null;


            $data = $this->infoSetting
                ->where('status', 1)
                ->select('id', 'sms_lang', 'present_in_sms_text', 'present_out_sms_text', 'st_out_sms', 'st_in_sms', 'auto_absent_sms', 'absent_sms_lang', 'absent_sms_txt')
                ->first();


            return response()->json($data, 200, []);


        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


    }

    public function updateAttendanceSettingDetails(Request $request)
    {

        try {

            $id = $request->id;
            $the_setting = $this->infoSetting->findOrFail($id);

            $the_setting->st_in_sms = $request->st_in_sms;
            $the_setting->st_out_sms = $request->st_out_sms;
            $the_setting->sms_lang = $request->sms_lang;
            $the_setting->present_in_sms_text = $request->present_in_sms_text;
            $the_setting->present_out_sms_text = $request->present_out_sms_text;
            $the_setting->absent_sms_lang = $request->absent_sms_lang;
            $the_setting->absent_sms_txt = $request->absent_sms_txt;
            $the_setting->auto_absent_sms = $request->auto_absent_sms;

            $the_setting->save();

            return response()->json(['data' => $the_setting, 'message' => 'Successfully Updated', 'mode' => 'update'], 200, []);


        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


    }


    /**
     * @param $sectionId
     * @param Role $role
     */
    public
    function getStudentListBySection($academic_version_id, $academic_year_id, $academic_shift_id, $academic_department_id, $academic_class_id, $academic_class_group_id, $academic_section_id, $academic_session_id, $attDate)
    {


        /* if (request()->ajax()) {
             return view('default.admin.students.student-list-for-attendance', compact('viewType', 'studentAttendanceExist', 'studentList', 'locale', 'attDate', 'studentClass', 'studentSection'));
         }
         return view('default.admin.students.student-list-for-attendance', compact('viewType', 'studentAttendanceExist', 'studentList', 'locale', 'attDate', 'studentClass', 'studentSection'));*/

    }


    public
    function getAccademicClassBySiteID()
    {


        dd('d');

        $site_accdemic_class_shift_ids_list = SiteInfo::select('academic_class_ids', 'shift_ids')->where('id', Session::get(SITE_ID))->first();
        $site_accdemic_class_ids_list_split = explode(',', $site_accdemic_class_shift_ids_list->academic_class_ids);
        $site_accademic_class_list = AcademicClass::whereIn('id', $site_accdemic_class_ids_list_split)->get();
        $site_accdemic_shift_ids_list_split = explode(',', $site_accdemic_class_shift_ids_list->shift_ids);
        $site_accademic_shift_list = AcademicShift::whereIn('id', $site_accdemic_shift_ids_list_split)->get();
        return array($site_accademic_class_list, $site_accademic_shift_list);

    }


    public
    function getAccademicClassGroupByClassIdAndShiftId($class_id, $shift_id, $year_id = null)
    {
        $siteShiftClassGroupSectionSetting = new  SiteShiftClassGroupSectionSetting();
        $site_accdemic_class_group_ids_list = $siteShiftClassGroupSectionSetting
            ->where('academic_class_id', $class_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)->pluck('academic_class_group_id');

        $academicClassGroup = new AcademicClassGroup();
        $academicClassGroupList = $academicClassGroup->whereIn('id', $site_accdemic_class_group_ids_list)->get();

//        $site_accdemic_class_group_ids_list = $siteShiftClassGroupSectionSetting
//            ->where('academic_class_id', $class_id)
//            ->where('academic_shift_id', $shift_id)->pluck('academic_session_id');
        return $academicClassGroupList;

    }

    public
    function getAccademicClassGroupSectionByClassIdAndShiftIdAndGroupId($class_id, $shift_id, $group_id, $year_id = null)
    {
        //dd($shift_id, $class_id, $group_id);

        $siteShiftClassGroupSectionSetting = new  SiteShiftClassGroupSectionSetting();
        $site_accdemic_class_group_section_ids_list = $siteShiftClassGroupSectionSetting
            ->where('academic_class_id', $class_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_class_group_id', $group_id)
            ->first();

        //dd($site_accdemic_class_group_section_ids_list);

        $site_accdemic_class_group_section_ids = explode(',', $site_accdemic_class_group_section_ids_list->academic_section_ids);
        $academicSection = new AcademicSection();
        $academicClassGroupSectionList = $academicSection->whereIn('id', $site_accdemic_class_group_section_ids)->get();
        return $academicClassGroupSectionList;

    }

    public
    function getAccademicClassGroupSectionByClassIdAndShiftId($class_id, $shift_id, $year_id = null)
    {
        //dd($shift_id, $class_id, $group_id);

        $siteShiftClassGroupSectionSetting = new  SiteShiftClassGroupSectionSetting();
        $site_accdemic_class_group_section_ids_list = $siteShiftClassGroupSectionSetting
            ->where('academic_class_id', $class_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_year_id', $year_id)
            ->first();

        // return $site_accdemic_class_group_section_ids_list;
        //dd($site_accdemic_class_group_section_ids_list);

        $site_accdemic_class_group_section_ids = explode(',', $site_accdemic_class_group_section_ids_list->academic_section_ids);
        $academicSection = new AcademicSection();
        $academicClassGroupSectionList = $academicSection->whereIn('id', $site_accdemic_class_group_section_ids)->get();
        return $academicClassGroupSectionList;

    }

    public
    function getStudentListForBiometricIdAttachment($yearid_id, $shift_id, $class_id, $section_id, $group_id = null)
    {

        if ($group_id == null) {
            $students = new User();

            $studentList = $students->where('academic_year_id', $yearid_id)
                ->where('academic_shift_id', $shift_id)->where('academic_class_id', $class_id)
                ->where('academic_section_id', $section_id)->get();
            return $studentList;

        } else {

            $students = new User();
            $studentList = $students->where('academic_year_id', $yearid_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                // ->where('academic_class_group_id', $group_id)
                ->where('academic_section_id', $section_id)->get();


            /*   $studentList = StudentHistory::
               where('academic_version_id', $academic_version_id)
                   ->where('academic_year_id', $academic_year_id)
                   ->where('academic_shift_id', $academic_shift_id)
                   ->where('academic_class_id', $academic_class_id)
                   ->when($academic_department_id, function ($query) use ($academic_department_id) {
                       return $query->where('academic_department_id', $academic_department_id);
                   })->when($academic_section_id, function ($query) use ($academic_section_id) {
                       return $query->where('academic_section_id', $academic_section_id);
                   })->when($academic_class_group_id, function ($query) use ($academic_class_group_id) {
                       return $query->where('academic_class_group_id', $academic_class_group_id);
                   })
                   ->with(['stClass', 'section', 'student'])
                   ->orderBy('student_roll_number', 'ASC')
                   // ->select('id', 'biometric_id', 'student_roll_number', 'phone', 'academic_class_id', 'academic_section_id')
                   ->get();*/


            //  dd($studentList);
            return $studentList;

        }


    }


    /**
     * @param Request $request
     * @param Routine $routine
     * @return string
     */
    public
    function addStudentAttendance(Request $request, Routine $routine)
    {

        $studentInfo = $request->stInfo;
        $attDate = $request->attDate;
        $class = $request->class;
        $sectionId = $request->section;
        $subject = $request->subject;


        if (isset($studentInfo) && count($studentInfo) > 0) {


            if ($subject) {//subject wise attendance

            } else {//section wise attendance

                /* $studentAttendanceExist = (new Student())
                     ->whereSectionId($sectionId)
                     ->wherePresentDate($attDate)
                     ->wherePresentType('section')
                     ->pluck('student_history_id')->toArray();*/


                $studentAttendanceExist = (new StudentAttendance())
                    ->whereSectionId($sectionId)
                    ->wherePresentDate($attDate)
                    ->wherePresentType('section')
                    ->get()->mapWithKeys(function ($item) {
                        return [$item['id'] => $item['student_history_id']];
                    })->all();


                $willBeGivenAbsentIds = $studentAttendanceExist;

                foreach ($studentInfo as $key => $stInfo) {

                    $stdAtt = json_decode($stInfo);

                    if (($studentKey = array_search($stdAtt->userId, $studentAttendanceExist)) !== false) {//attendance exist
                        unset($willBeGivenAbsentIds[$studentKey]);//collect ids for delete


                        $presentType = 'section';
                        $presentTypeId = null;
                        $intime = $stdAtt->inTime;
                        $outtime = $stdAtt->outTime;

                        StudentAttendance::findOrFail($studentKey)->update([
                            'roll_no' => $stdAtt->userRoll,
                            'section_id' => $stdAtt->sectionId,
                            'class_id' => $stdAtt->stClassId,
                            'present_type' => $presentType,
                            'present_type_id' => $presentTypeId,
                            'in_time' => $intime,
                            'out_time' => $outtime,
                            'present_date' => $stdAtt->attDate,
                            'present_date_time' => date('Y-m-d H:i:s', time()),
                            'present_year' => date('Y', time()),
                            'present_month' => date('m', time()),
                            'present_day' => date('d', time())

                        ]);

                    } else {// attendance not exists

                        $presentType = null;
                        $presentTypeId = null;
                        $intime = "12:01:00";
                        $outtime = "01:00:00";

                        $att = new StudentAttendance();

                        $att->student_history_id = $stdAtt->userId;
                        $att->roll_no = $stdAtt->userRoll;
                        $att->section_id = $stdAtt->sectionId;
                        $att->class_id = $stdAtt->stClassId;
                        $att->present_type = 'section';
                        $att->present_type_id = null;
                        $att->in_time = $intime;
                        $att->out_time = $outtime;
                        $att->present_date = $stdAtt->attDate;
                        $att->present_date_time = date('Y-m-d H:i:s', time());
                        $att->present_year = date('Y', time());
                        $att->present_month = date('m', time());
                        $att->present_day = date('d', time());
                        $att->save();

                    }
                }//end foreach

                if (count($willBeGivenAbsentIds) > 0) {
                    StudentAttendance::whereIn('id', array_keys($willBeGivenAbsentIds))->delete();
                }
                return ['message' => 'Student Given'];
            }


        }


    }


    public
    function calculateStudentAttendanceStatus()
    {

        $get_data = $this->studentAttendance->where('late_status', null)->get();
        if (count($get_data)) {
            $carbon = Carbon::now();
            $current_day = $carbon->format('l');
            $result = substr($current_day, 0, 3);
            foreach ($get_data as $k => $stdAttendance) {
                $shift_details = $this->siteShiftDetails->where(['academic_session_type_id' => 1, 'weeek_day' => $result, 'belongs_to' => 'student', 'academic_shift_id' => 1])->orderBy('id', 'DESC')->first();


                if ($stdAttendance->in_time <= $shift_details->in_time) {
                    $this->studentAttendance
                        ->where('id', $stdAttendance->id)
                        ->update(['late_status' => 1]);
                } else {
                    $this->studentAttendance
                        ->where('id', $stdAttendance->id)
                        ->update(['late_status' => 0]);
                }

            }
        }


    }

    public function route_site_get_attendance_setting_details()
    {
        $the_setting = SiteInfoSetting::first();

        $data = [
            'st_in_sms' => $the_setting->st_in_sms,
            'st_out_sms' => $the_setting->st_out_sms,
            'sms_lang' => $the_setting->sms_lang,
            'absent_sms_lang' => $the_setting->absent_sms_lang,
            'auto_absent_sms' => $the_setting->auto_absent_sms,
            'regards_title' => $the_setting->regards_title,
        ];

        return response()->json($data, 200);

    }

   public function route_site_update_attendance_setting_details(Request  $request)
   {



   //    return response()->json(['data' => $the_setting, 'message' => 'Successfully Updated', 'mode' => 'update'], 200, []);


       try {

      
        if($request->sms_lang=='en'){
            $present_in_sms_text= '[full_name][nl] In Time:[in_time] Attendance Date: [present_date][nl] Regards:[site_name]';
            $present_out_sms_text= '[full_name][nl] Out Time:[in_time] Attendance Date: [present_date][nl] Regards:[site_name]';
        }else{
            $present_in_sms_text= '[full_name] প্রবেশের সময়ঃ[in_time] উপস্থিত তারিখ:[absent_date][nl] শুভেচ্ছা:[site_name]';
            $present_out_sms_text= '[full_name] বাহিরের সময়ঃ[in_time] উপস্থিত তারিখ:[absent_date][nl] শুভেচ্ছা:[site_name]';
        }

        if($request->absent_sms_lang=='en'){
            $absent_sms_txt= '[full_name] is absent today[nl] Date:[absent_date][nl] Regards:[site_name]';
        }else{
            $absent_sms_txt= '[full_name] আজ অনুপস্থিত[nl] তারিখ:[absent_date][nl] শুভেচ্ছা:[site_name]';
        }


        $the_setting = SiteInfoSetting::first();
 
        $the_setting->st_in_sms = $request->st_in_sms;
        $the_setting->st_out_sms = $request->st_out_sms;
        $the_setting->sms_lang = $request->sms_lang;
        $the_setting->absent_sms_lang = $request->absent_sms_lang;
        $the_setting->auto_absent_sms = $request->auto_absent_sms;
        $the_setting->regards_title = $request->regards_title;

        $the_setting->present_in_sms_text = $present_in_sms_text;
        $the_setting->present_out_sms_text = $present_out_sms_text;
        $the_setting->absent_sms_txt = $absent_sms_txt;
       
        $the_setting->save();

        return response()->json(['data' => $the_setting, 'message' => 'Successfully Updated', 'mode' => 'update'], 200, []);


       } catch (ModelNotFoundException $exception) {
           return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);

       } catch (Exception $exception) {

           return JsonResponse::create(['message' => $exception->getMessage()], 410);
       }

   }

   public function route_user_list(Request $request)
   {

       try {

           $user_type = $request->types;
           $search_txt = $request->search_txt;
           $paginate = $request->paginate ?? 20;
           $status = $request->status;
           $finger_taken = $request->finger_taken;
           $attendance_sms = $request->attendance_sms;

           if (!$user_type) {
               throw new Exception('Check At Least One Type!' . $user_type);
           }

           $txt = '%' . $search_txt . '%';

           $users = $this->user
               ->with('siteRoles')
               ->select('id', 'username', 'user_type', 'email', 'contact_number', 'status', 'finger_taken', 'attendance_sms', 'no_of_weekly_class')
               ->whereIn('user_type', $user_type)
               ->where('status', $status)
               ->when($finger_taken, function ($q) use ($finger_taken) {
                   $finger_taken = $finger_taken == 1 ? $finger_taken : 0;
                   return $q->where('finger_taken', $finger_taken);
               })->when($attendance_sms, function ($q) use ($attendance_sms) {
                   $attendance_sms = $attendance_sms == 1 ? $attendance_sms : 0;
                   return $q->where('attendance_sms', $attendance_sms);
               })
               ->when($search_txt, function ($q) use ($txt) {
                   return $q->where(function ($query) use ($txt) {
                       $query->where('username', 'LIKE', $txt)
                           ->orWhere('email', 'LIKE', $txt)
                           ->orWhere('contact_number', 'LIKE', $txt)
                           ->orWhereTranslationLike('first_name', $txt)
                           ->orWhereTranslationLike('last_name', $txt);
                   });
               })
               ->orderByTranslation('first_name', 'ASC')
               ->paginate($paginate);

           if (count($users) < 1) {
               throw new Error('No Data Found!');
           }

           return response()->json($users, 200, []);


       } catch (ModelNotFoundException $exception) {
           return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);

       } catch (Exception $exception) {

           return JsonResponse::create(['message' => $exception->getMessage()], 410);
       }
   }

   public function route_student_update_attendance_sms(Request $request, $id)
   {
            try {


                $the_user = $this->user->findOrFail($id);


                /*    if (count($the_user->ownFields) > 0) {
                        foreach ($the_user->ownFields as $ownField) {
                            if ($request->{$ownField}) {
                                $the_user->{$ownField} = $request->{$ownField};
                            }
                        }
                    }*/

                $the_user->finger_taken = $request->finger_taken;



                if ($the_user->save()) {
                    return Response::json(['message' => 'Successfully Updated The Status!', 'mode' => 'Update'], 200);
                }
            } catch (Exception $exception) {
                return JsonResponse::create(['message' => $exception->getMessage()], 410);
            }

        }

   public function route_single_student_update_attendance_sms(Request $request, $id)
   {
    try {


        $the_user = $this->user->findOrFail($id);


        /*    if (count($the_user->ownFields) > 0) {
                foreach ($the_user->ownFields as $ownField) {
                    if ($request->{$ownField}) {
                        $the_user->{$ownField} = $request->{$ownField};
                    }
                }
            }*/
        $the_user->attendance_sms = $request->attendance_sms;




        if ($the_user->save()) {
            return Response::json(['message' => 'Successfully Updated The Status!', 'mode' => 'Update'], 200);
        }
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage()], 410);
    }
  }


}
