<?php

namespace App\Http\Controllers\Site\Sms;

use App\Http\Controllers\Controller;
use App\Models\Edu\SMS\SmsFollowUp;
use App\Models\Site\Sms\SiteSms;
use App\Traits\SmsFunctionsTrait;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Response;
use Session;


class SmsCampaignController extends Controller
{
    use SmsFunctionsTrait;

    private $sms;
    private $smsFollowUp;

    public function __construct(SiteSms $sms, SmsFollowUp $smsFollowUp)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->sms = $sms;
        $this->smsFollowUp = $smsFollowUp;
    }


    public function sendToNumbers(Request $request)
    {

        try {
            $this->validate($request, [
                'number_array' => 'required',
                'sms_id' => 'required',
            ]);

            $sms_id = $request->sms_id;
            $number_array = $request->number_array;
            $confirmed = $request->confirmed;

            $site_id = Session::get('SITE_ID');


            if (count($number_array) < 1) {
                throw new Error('No User Found!');
            }

            if (!$confirmed) {
                $the_sms = $this->sms->findOrFail($sms_id);
                $sms_count = $this->checkSmsCount($the_sms->sms_description);

                $sms_mem_data = $this->getSmsRelatedSiteMembershipData($site_id);
                $per_sms_cost = $sms_mem_data[1];

                $sms_balance_needed = ($sms_count * $per_sms_cost * count($number_array));

                return Response::json(['message' => 'You are going to send:' . count($number_array) . ' number(s) & sms count:' . $sms_count . ' & balance needed' . $sms_balance_needed], 412);

            } else {

                $the_sms = $this->sms->findOrFail($sms_id);
                $total_sms_cost_details = $this->sendSmsUsingQueue($number_array, $the_sms->sms_description);
                $this->logSmsSentDetails($the_sms, '<b>User: </b> ' . count($number_array) . ' Numbers');
                return Response::json(['mode' => 'Success', 'message' => $total_sms_cost_details], 200);
            }


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function sendUsingPhoneBook(Request $request)
    {

        try {

            $this->validate($request, [
                'number_array' => 'required',
                'sms_id' => 'required',
                // 'sms_send_time' => 'required',
            ]);

            $number_array = $request->number_array;
            $sms_id = $request->sms_id;
            $confirmed = $request->confirmed;
           
          
            // $current_time_string = strtotime(Carbon::now()->toDateTimeString());
            // return $number_array;


            if (!$confirmed) {
                $site_id = Session::get('SITE_ID');
                $the_sms = $this->sms->findOrFail($sms_id);
                $sms_count = $this->checkSmsCount($the_sms->sms_description);
                $sms_mem_data = $this->getSmsRelatedSiteMembershipData($site_id);
                $per_sms_cost = $sms_mem_data[1];

                $sms_balance_needed = ($sms_count * $per_sms_cost * count($number_array));


                return Response::json(['message' => 'You are going to send:' . count($number_array) . ' students & sms count:' . $sms_count . ' & balance needed:' . $sms_balance_needed], 412);

            } else {
             
                $the_sms = $this->sms->findOrFail($sms_id);
                $total_sms_cost_details = $this->sendSmsUsingQueue($number_array, $the_sms->sms_description);
                $this->logSmsSentDetails($the_sms, '<b>Phone Book: </b>: ' . count($number_array) . ' Numbers');
                return Response::json(['mode' => 'Success', 'message' => $total_sms_cost_details], 200);
            }

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function resendFailedSms(Request $request)
    {

        // try {

        $this->validate($request, [
            'id' => 'required',
        ]);

        $log_id = $request->id;
        $confirmed = $request->confirmed;

        $the_sms = $this->smsFollowUp->findOrFail($log_id);

        if ($the_sms->res_status==2) {
            return Response::json(['message' => 'Already resent!'], 410);
        }


        $sms_req = json_decode($the_sms->sms_request, true);

        $sms_text = $sms_req['sms_txt'] ?? '';
        $number_array = explode(',', $the_sms->msg_numbers) ?? '';


        if (!$confirmed) {
            $site_id = Session::get('SITE_ID');


            $sms_count = $this->checkSmsCount($sms_text);
            $sms_mem_data = $this->getSmsRelatedSiteMembershipData($site_id);
            $per_sms_cost = $sms_mem_data[1];

            $sms_balance_needed = ($sms_count * $per_sms_cost * count($number_array));


            return Response::json(['message' => 'You are going to send:' . count($number_array) . ' students & sms count:' . $sms_count . ' & balance needed:' . $sms_balance_needed], 412);

        } else {

            $total_sms_cost_details = $this->sendSmsUsingQueue($number_array, $sms_text);
            // $this->logSmsSentDetails($the_sms, '<b>Resend: </b>: ' . count($number_array) . ' Numbers');

            $the_sms->res_status = 2;
            $the_sms->save();
            return Response::json(['mode' => 'Success', 'message' => $total_sms_cost_details], 200);
        }

        /* } catch (ValidationException $exception) {
             return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
         } catch (Exception $exception) {
             throw new Error($exception->getMessage());
         }*/
    }


    private function logSmsSentDetails($the_sms, $sent_log)
    {

        $the_sms->sent_request = ('=>' . $the_sms->sent_request . ' <br/>' . $sent_log);
        $the_sms->save();

        return $the_sms;
    }


}
