<?php

namespace App\Http\Controllers\Site\Sms;

use App\Imports\Site\SitePhoneBookImport;
use App\Models\Site\Sms\SitePhoneBook;
use Auth;
use Error;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Maatwebsite\Excel\Facades\Excel;

class PhoneBookController extends Controller
{
    private $phoneBook;

    public function __construct(SitePhoneBook $phoneBook)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->phoneBook = $phoneBook;
    }

    public function phoneBookGroupNameList(){
        try {
            $data = DB::table('site_phone_book_groups_name')->get();
            if (count($data) < 1) {
                throw new Error('No Data Found!');
            }
            return response()->json($data, 200, []);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }
    public function getPhoneBookList(Request $request)
    {
        try {

            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $status = $request->status;
            $group_name = $request->group_name;
            $search_txt = $request->search_txt;
            $txt = $search_txt ? '%' . $search_txt . '%' : null;

            $data = $this->phoneBook
                ->where('status', $status)
                ->when($group_name, function ($q) use ($group_name) {
                    return $q->where('group_name', $group_name);
                })
                ->when($txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('name', 'LIKE', $txt)
                            ->orWhere('mobile_number', 'LIKE', $txt)
                            ->orWhere('group_name', 'LIKE', $txt);
                    });
                })
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            //dd(count($data)<1);


            if (count($data) < 1) {
                throw new Error('No Data Found!');
            }

            return response()->json($data, 200, []);
        } catch (Exception $exception) {

        }

    }


    public function create(Request $request)
    {


        try {


            $this->validate($request, [
                'mobile_number' => [
                    'required',
                    'regex:/^(?:\+8801|8801|01)[3-9]\d{8}$/',
                ],
                'group_name' => ['required'],
            ]);

            foreach ($this->phoneBook->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $this->phoneBook->{$ownField} = $request->{$ownField};
                }
            }

            $this->phoneBook->status = $request->status;
            $this->phoneBook->site_id = \Session::get('SITE_ID');
            $this->phoneBook->created_by = Auth::id();
            $this->phoneBook->save();
            return response()->json(['data' => $this->phoneBook, 'message' => ' Successfully Saved!', 'mode' => 'Save'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function update(Request $request)
    {

        try {

            $this->validate($request, [
                'mobile_number' => 'required'
            ]);

            $this->phoneBook = $this->phoneBook->findOrFail($request->id);


            foreach ($this->phoneBook->ownFields as $k => $ownField) {
                if ($request->{$ownField}) {
                    $this->phoneBook->{$ownField} = $request->{$ownField};
                }
            }

            $this->phoneBook->status = $request->status;
            $this->phoneBook->save();
            return response()->json(['data' => $this->phoneBook, 'message' => ' Successfully Updated!', 'mode' => 'Update'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function excelUpload(Request $request)

    {

        try {

            // \Log::info('ggg: '.$request->file->getRealPath());

            $fileName = time() . '.' . $request->file->getClientOriginalExtension();
            $request->file->move(storage_path('pdf'), $fileName);

            $this->validate($request, [
                //'select_file' => 'required|mimes:xls,xlsx'
            ]);
            $import = new SitePhoneBookImport;
            Excel::import($import, storage_path('pdf') . '/' . $fileName);
            $row_count = $import->getRowCount();

            if ($row_count) {
                return response()->json(['message' => 'You Have Successfully Uploaded . ' . $row_count . ' Rows', 'mode' => 'Upload'], 200);

            }
            return response()->json(['message' => 'No Unique Row Found!'], 410);


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function delete(Request $request)
    {

        try {

            $this->validate($request, [
                'id' => 'required'
            ]);

            $this->phoneBook = $this->phoneBook->findOrFail($request->id)->delete();


            return response()->json(['data' => $this->phoneBook, 'message' => ' Successfully Delete!', 'mode' => 'Delete'], 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


}
