<?php

namespace App\Http\Controllers\Site;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicSession;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\GlobalSiteFeeGenerate;
use App\Models\Site\Fee\SiteFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use Composer\Command\SearchCommand;
use PDF;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Carbon;
use JsonSchema\Exception\ValidationException;
use PhpParser\Error;
use Response;
use Session;

class SiteStudentFeeGenerateController extends ProjectController
{
    private $siteStudentFeeGenerate;

    public function __construct(SiteStudentFeeGenerate $siteStudentFeeGenerate)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $viewType = 'Fee Head List';
        return view('default.admin.sites.site-student-fee-generate.view', compact('viewType'));
    }

    public function getStudentFeeGenerateList($year_id, $shift_id, $class_id = null, $section_id = null, $session_id = null, $class_group_id = null, $department_id = null)
    {
        $std_fee_generate = new SiteStudentFeeGenerate();
        $std_fee_generate_list = $std_fee_generate->get();
        $final = [];
        foreach ($std_fee_generate_list as $key => $value) {
            $sub_head = new AcademicFeeSubHead();
            $sub_head_list = $sub_head->where('id', $value->academic_fee_sub_head_id)->first();
            $final[$key]['amount'] = $value->amount;
            $final[$key]['name'] = $sub_head_list->name;
        }
        return $final;
    }

    public function getSiteAcademicHeadList(Request $request)
    {


        $sitefeeHeadIDs = SiteStudentFeeSubHeadAllocation::distinct('academic_fee_head_id')
            ->pluck('academic_fee_head_id');

        $siteFeeHeadList = AcademicFeeHead::whereIn('id', $sitefeeHeadIDs)->get();


        $siteStudentIDs = $this->returnSiteStudentIDs($request);

        $std_number = $siteStudentIDs->count();

        return response()->json([$siteFeeHeadList, $siteStudentIDs, $std_number], 200, [], JSON_NUMERIC_CHECK);
    }

    public function getSiteFeeHeadBaseTypeList(Request $request)
    {
        //return 'ok';

        if ($request->checked_fee_head_id != null) {


            $feeheadlist = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
            $headBaseValue = null;
            $headBaseTypelist = array();
            if ($feeheadlist->head_key == 'monthly') {
                $headBaseTypelist = AcademicMonthName::get();
                $headBaseValue = 'monthly';
            } else if ($feeheadlist->head_key == 'examination') {

                $selectedSiteGroupList = SiteInfoSetting::first();
                $Examinationlist = Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                $headBaseTypelist = [];
                $headBaseTypelistArr = array();
                foreach ($Examinationlist as $key => $value) {

                    $headBaseTypelistArr['id'] = $value->id;
                    $headBaseTypelistArr['name'] = $value->examination_name;

                    $headBaseTypelist[$key] = array_merge($headBaseTypelistArr);
                }
                $headBaseValue = 'examination';
            } else if ($feeheadlist->head_key == 'admission') {
                $headBaseTypelist = AcademicAdmissionFeeType::get();
                $headBaseValue = 'admission';
            } else if ($feeheadlist->head_key == 'general') {
                $headBaseTypelist = AcademicGeneralFeeType::get();
                $headBaseValue = 'general';
            }
            ///// student list make


            $siteStudentIDs = $this->returnSiteStudentIDs($request);

            //   $siteStudentIDs=$siteStudentlist->where('status', $request->student_status);
            // dd($siteStudentIDs);

            $studentFeeList = [];
            foreach ($siteStudentIDs as $key => $value) {
                //      $student= User::where('id', $value->user_id)->first();
                $studentFeeList[$key]['full_name'] = $value->full_name;
                $studentFeeList[$key]['student_roll_number'] = $value->student_roll_number;
                $studentFeeList[$key]['roll_full_name_username'] = $value->student_roll_number . '. ' . $value->full_name . ' (' . $value->username . ')';
                $studentFeeList[$key]['id'] = $value->id;
                $studentFeeList[$key]['user_id'] = $value->user_id;
            }
        }

        return response()->json([$headBaseValue, $headBaseTypelist, $studentFeeList], 200, [], JSON_NUMERIC_CHECK);
    }

    public function getStudentFeeGenerateListBySubHeadId(Request $request)
    {
        //        return $request;

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;

        $month_change = $request->month_change;
        $site_fee_head_list = $request->site_fee_head_list;
        $student_id = $request->student_id;

        if ($month_change == false) {

            $admission = [];
            $monthly = [];
            $exam = [];
            foreach ($site_fee_head_list as $k => $v) {

                if ($v['status'] && $v['status'] == true) {

                    //=====================Collection For Admission=====================

                    if ($v['name'] == 'Admission') {

                        $std_fee_generate = new SiteStudentFeeGenerate();
                        $std_fee_details = $std_fee_generate
                            ->where('academic_version_id', $data['academic_version_id'])
                            ->where('academic_year_id', $data['academic_year_id'])
                            ->where('academic_shift_id', $data['academic_shift_id'])
                            ->where('academic_class_id', $data['academic_class_id'])
                            ->where('user_id', $student_id)
                            ->where('academic_fee_head_id', $v['id'])
                            ->when($data['academic_department_id'], function ($query) use ($data) {
                                return $query->where('academic_department_id', $data['academic_department_id']);
                            })->when($data['academic_section_id'], function ($query) use ($data) {
                                return $query->where('academic_section_id', $data['academic_section_id']);
                            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                            })->when($data['academic_session_id'], function ($query) use ($data) {
                                return $query->where('academic_session_id', $data['academic_session_id']);
                            })->get();

                        if (count($std_fee_details) > 0) {
                            foreach ($std_fee_details as $ke => $va) {

                                //===================== total of student payment  =================================

                                $std_waiver = new SiteStudentFeeWaiverOfferHistory();
                                $std_waiver_history = $std_waiver->where(
                                    [
                                        'user_id' => $student_id,
                                        'academic_fee_sub_head_id' => $va->academic_fee_sub_head_id,
                                    ]
                                )->first();

                                $fee_collection = new SiteStudentFeePaymentHistory();
                                $fee_collection_details = $fee_collection->where(
                                    [
                                        'user_id' => $student_id,
                                        'academic_fee_sub_head_id' => $va->academic_fee_sub_head_id,
                                        'academic_fee_head_id' => $v['id'],
                                    ]
                                )->first();

                                if ($fee_collection_details) {

                                    $paid_amount = $fee_collection_details->amount;

                                    if ($std_waiver_history) {
                                        $waiver_amount = $std_waiver_history->amount;
                                        $total_paid_amount = $waiver_amount + $paid_amount;
                                        $payable_amount = $va->amount - $total_paid_amount;
                                        $due = $va->amount - $total_paid_amount;
                                    } else {
                                        $waiver_amount = 0;
                                        $total_paid_amount = $waiver_amount + $paid_amount;
                                        $payable_amount = $va->amount - $total_paid_amount;
                                        $due = $va->amount - $total_paid_amount;
                                    }
                                } else {
                                    $paid_amount = 0;
                                    if ($std_waiver_history) {
                                        $waiver_amount = $std_waiver_history->amount;
                                        $total_paid_amount = $waiver_amount + $paid_amount;
                                        $payable_amount = $va->amount - $total_paid_amount;
                                        $due = $va->amount;
                                    } else {
                                        $waiver_amount = 0;
                                        $total_paid_amount = $waiver_amount + $paid_amount;
                                        $payable_amount = $va->amount - $total_paid_amount;
                                        $due = $va->amount;
                                    }
                                }

                                //=======================waiver amount===========================


                                $sub_head = new AcademicFeeSubHead();
                                $admission[$ke]['user_id'] = $va->user_id;
                                $admission[$ke]['head_id'] = $v['id'];
                                $admission[$ke]['academic_fee_sub_head_id'] = $sub_head->where('id', $va->academic_fee_sub_head_id)->first();
                                $admission[$ke]['amount'] = $va->amount < 0 ? 0 : $va->amount;
                                $admission[$ke]['status'] = true;
                                $admission[$ke]['waiver'] = $waiver_amount;
                                $admission[$ke]['payable_amount'] = $payable_amount;
                                $admission[$ke]['due'] = $due < 0 ? 0 :  $due;
                            }
                        } else {
                            return Response::json(['message' => 'admission fee not found!'], 411);
                        }


                        //=====================Collection For Month=====================

                    } elseif ($v['name'] == 'Monthly') {
                        //-------------------get fee detatils---------------------

                        $std_fee_generate = new SiteStudentFeePaymentHistory();
                        $std_fee_details = $std_fee_generate
                            ->where('academic_version_id', $data['academic_version_id'])
                            ->where('academic_year_id', $data['academic_year_id'])
                            ->where('academic_shift_id', $data['academic_shift_id'])
                            ->where('academic_class_id', $data['academic_class_id'])
                            ->where('user_id', $student_id)
                            ->where('academic_fee_head_id', $v['id'])
                            ->when($data['academic_department_id'], function ($query) use ($data) {
                                return $query->where('academic_department_id', $data['academic_department_id']);
                            })->when($data['academic_section_id'], function ($query) use ($data) {
                                return $query->where('academic_section_id', $data['academic_section_id']);
                            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                            })->when($data['academic_session_id'], function ($query) use ($data) {
                                return $query->where('academic_session_id', $data['academic_session_id']);
                            })->get();

                        if (count($std_fee_details) > 0) {
                            foreach ($std_fee_details as $ke => $va) {


                                //------------------monthly waiver details----------------

                                $fee_collection = new SiteStudentFeePaymentHistory();
                                $fee_collection_details = $fee_collection->where(
                                    [
                                        'user_id' => $student_id,
                                        'academic_fee_sub_head_id' => $va->academic_fee_sub_head_id,
                                        'academic_fee_head_id' => $v['id'],
                                    ]

                                )->get();


                                if (count($fee_collection_details) > 0) {

                                    $paid_amount = 0;
                                    $month_number = [];
                                    foreach ($fee_collection_details as $ky => $val) {
                                        $paid_amount += $val->amount;
                                        $month_number[$ky] = $val->month;
                                    }

                                    //=======================waiver amount===========================

                                    $waiver_amount_on_paid_amount = 0;
                                    $std_waiver = new SiteStudentFeeWaiverOfferHistory();
                                    foreach ($month_number as $kky => $vvl) {

                                        $std_waiver_history = $std_waiver->where(
                                            [
                                                'user_id' => $student_id,
                                                'academic_fee_sub_head_id' => $va->academic_fee_sub_head_id,
                                                'month' => $vvl,
                                            ]

                                        )->first();

                                        if ($std_waiver_history) {
                                            $waiver_amount_on_paid_amount += $std_waiver_history->amount;
                                        } else {
                                        }
                                    }
                                    $total_paid_amount = $paid_amount + $waiver_amount_on_paid_amount;

                                    //------------------get payment start month-------------------

                                    $academic_year = new AcademicYear();
                                    $academic_year_list = $academic_year->where('id', $data['academic_year_id'])->first();
                                    $start_date = $academic_year_list->start_date;
                                    $start_month = date('m', strtotime($start_date));

                                    //------------------get current month--------------------

                                    $now = Carbon::now();
                                    $current_month = $now->month;
                                    $month_number = $current_month - $start_month;
                                    $total_month_number = $month_number + 1;

                                    //------------------get total amount--------------------

                                    $total_due_amount = $va->amount * $total_month_number;

                                    //=======================waiver amount===========================


                                    $waiver_amount_on_total = 0;
                                    $std_waiver = new SiteStudentFeeWaiverOfferHistory();
                                    $std_waiver_list = $std_waiver->whereBetween('month', [$start_month, $current_month])->where(
                                        [
                                            'user_id' => $student_id,
                                            'academic_fee_sub_head_id' => $va->academic_fee_sub_head_id,
                                        ]
                                    )->get();
                                    if (count($std_waiver_list) > 0) {
                                        foreach ($std_waiver_list as $kky => $vvl) {
                                            $waiver_amount_on_total += $vvl->amount;
                                        }
                                    } else {

                                        $waiver_amount_on_total = $waiver_amount_on_total;
                                    }


                                    //============================final===========================
                                    $waiver_amount = $waiver_amount_on_total - $waiver_amount_on_paid_amount;

                                    $due_amount = $total_due_amount - $total_paid_amount;

                                    $total_payable_amount = $due_amount - $waiver_amount;
                                } else {

                                    //------------------get payment start month-------------------

                                    $academic_year = new AcademicYear();
                                    $academic_year_list = $academic_year->where('id',  $data['academic_year_id'])->first();
                                    $start_date = $academic_year_list->start_date;
                                    $start_month = date('m', strtotime($start_date));

                                    //------------------get current month--------------------

                                    $now = Carbon::now();
                                    $current_month = $now->month;
                                    $month_number = $current_month - $start_month;
                                    $total_month_number = $month_number + 1;

                                    //------------------get total amount--------------------

                                    $due_amount = $va->amount * $total_month_number;

                                    //=======================waiver amount===========================


                                    $waiver_amount = 0;
                                    $std_waiver = new SiteStudentFeeWaiverOfferHistory();
                                    $std_waiver_list = $std_waiver->whereBetween('month', [$start_month, $current_month])->where(
                                        [
                                            'user_id' => $request->student_id,
                                            'academic_fee_sub_head_id' => $va->academic_fee_sub_head_id,
                                        ]
                                    )->get();
                                    if (count($std_waiver_list) > 0) {
                                        foreach ($std_waiver_list as $kky => $vvl) {
                                            $waiver_amount += $vvl->amount;
                                        }
                                    } else {

                                        $waiver_amount = $waiver_amount;
                                    }

                                    $total_payable_amount = $due_amount - $waiver_amount;
                                }
                                //------------------get payment start month-------------------

                                $academic_year = new AcademicYear();
                                $academic_year_list = $academic_year->where('id', $request->academic_year_id)->first();
                                $start_date = $academic_year_list->start_date;
                                $start_month = date('m', strtotime($start_date));

                                //------------------get current month--------------------

                                $now = Carbon::now();
                                $current_month = $now->month;
                                //                                return $start_month;
                                $month_number = $current_month - $start_month;
                                $total_month_number = $month_number + 1;

                                $month = new AcademicMonthName();

                                //---------------total month-------------------


                                $month_list = $month->whereBetween('id', [$start_month, $total_month_number])->pluck('id')->toArray();


                                //---------------total month from payment history table-------------------

                                $month_array = $fee_collection_details->pluck('month')->toArray();

                                $month_in_payment = $month->whereIn('id', $month_array)->get();

                                $month_id_in_payment = $month_in_payment->pluck('id')->toArray();

                                $unmatch_month = array_diff($month_list, $month_id_in_payment);

                                if (count($unmatch_month) > 0) {
                                    $result = $month->whereIn('id', $unmatch_month)->get();
                                } else {
                                    $result = [];
                                }


                                $sub_head = new AcademicFeeSubHead();
                                $monthly[$ke]['user_id'] = $va->user_id;
                                $monthly[$ke]['head_id'] = $v['id'];
                                $monthly[$ke]['academic_fee_sub_head_id'] = $sub_head->where('id', $va->academic_fee_sub_head_id)->first();
                                $monthly[$ke]['amount'] = $va->amount;
                                $monthly[$ke]['month'] = $result;
                                $monthly[$ke]['months'] = $month->whereNotIn('id', $month_id_in_payment)->get();
                                $monthly[$ke]['waiver'] = $waiver_amount;
                                $monthly[$ke]['payable_amount'] = $total_payable_amount < 0 ? 0 : $total_payable_amount;
                                //                            $monthly[$ke]['due'] = number_format($due_amount, 2);
                                $monthly[$ke]['due'] = $due_amount < 0 ? 0 :  $due_amount;
                                $monthly[$ke]['status'] = true;
                            }
                        } else {
                            return Response::json(['message' => 'month fee not found!'], 411);
                        }





                        //==================Collection for Examination======================

                    } elseif ($v['name'] == 'Examination') {

                        $std_fee_generate = new SiteStudentFeeGenerate();
                        $std_fee_details = $std_fee_generate
                            ->where('academic_version_id', $data['academic_version_id'])
                            ->where('academic_year_id', $data['academic_year_id'])
                            ->where('academic_shift_id', $data['academic_shift_id'])
                            ->where('academic_class_id', $data['academic_class_id'])
                            ->where('user_id', $student_id)
                            ->where('academic_fee_head_id', $v['id'])
                            ->when($data['academic_department_id'], function ($query) use ($data) {
                                return $query->where('academic_department_id', $data['academic_department_id']);
                            })->when($data['academic_section_id'], function ($query) use ($data) {
                                return $query->where('academic_section_id', $data['academic_section_id']);
                            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                            })->when($data['academic_session_id'], function ($query) use ($data) {
                                return $query->where('academic_session_id', $data['academic_session_id']);
                            })->get();

                        if ($std_fee_details) {

                            foreach ($std_fee_details as $key => $value) {
                                $sub_head = new AcademicFeeSubHead();
                                $exam[$key]['head_id'] = $v['id'];
                                $exam[$key]['academic_fee_sub_head_id'] = $sub_head->where('id', $value->academic_fee_sub_head_id)->first();
                                $examination = new Examination();
                                $exam[$key]['exam_list'] = $examination->where('id', $value->examination_id)->first();
                                $exam[$key]['amount'] = $value->amount;
                                $exam[$key]['status'] = true;
                            }
                        } else {
                            return Response::json(['message' => 'examination fee not found!'], 411);
                        }
                    } else {
                    }
                } else {
                }
            }

            return array($admission, $monthly, $exam);
        } else {
            //====================refresh on month change======================

            //            return $request;
            foreach ($request->monthlyFeeList as $key => $value) {

                $fee_sub_head_id_array = $value['academic_fee_sub_head_id'];
                $total = 0;

                $academic_year = new AcademicYear();
                $academic_year_list = $academic_year->where('id', $data['academic_year_id'])->first();


                $start_date = $academic_year_list->start_date;
                $start_month = date('m', strtotime($start_date));

                //------------------get current month--------------------

                $now = Carbon::now();
                $month_number = $now->month - $start_month;
                $total_month_number = $month_number + 1;

                //------------------get total amount--------------------

                $due = $value['amount'] * $total_month_number;

                //==================month wise refresh payment======================

                foreach ($value['month'] as $ke => $val) {
                    $month_ids[$ke] = $val['id'];
                    $total += $value['amount'];
                }
                //=======================waiver amount===========================
                $waiver_amount = 0;
                foreach ($month_ids as $k => $v) {


                    $std_waiver = new SiteStudentFeeWaiverOfferHistory();
                    $std_waiver_history = $std_waiver
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('academic_shift_id', $data['academic_shift_id'])
                        ->where('academic_class_id', $data['academic_class_id'])
                        ->where('user_id', $student_id)
                        ->where('academic_fee_sub_head_id', $fee_sub_head_id_array['id'])
                        ->where('academic_fee_sub_head_id', $fee_sub_head_id_array['id'])
                        ->when($data['academic_department_id'], function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })->when($data['academic_section_id'], function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })->when($data['academic_class_group_id'], function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })->when($data['academic_session_id'], function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })->first();


                    if ($std_waiver_history) {
                        $waiver_amount += $std_waiver_history->amount;
                    } else {

                        $waiver_amount = $waiver_amount;
                    }
                }

                //=======================pyable amount===========================

                $pyable_amount = $total - $waiver_amount;

                //------------------get payment start month-------------------




                $monthly[$key]['user_id'] = $student_id;
                $monthly[$key]['head_id'] = $value['head_id'];
                $monthly[$key]['academic_fee_sub_head_id'] = $value['academic_fee_sub_head_id'];
                $monthly[$key]['amount'] = $value['amount'];
                $monthly[$key]['month'] = $value['month'];
                $monthly[$key]['months'] = AcademicMonthName::all();
                $monthly[$key]['waiver'] = $waiver_amount;
                $monthly[$key]['payable_amount'] = $pyable_amount < 0 ? 0 : $pyable_amount;
                $monthly[$key]['due'] = $due < 0 ? 0 : $due;
                $monthly[$key]['status'] = true;
            }

            return $monthly;
        }
    }

    public function getSubHeadDeetailsListByFeeHeadFeeGroupYearSessionShiftClassGroupSection(
        $siteYearId,
        $siteShiftId,
        $classId,
        $sectionId = null,
        $sessionId = null,
        $classGroupId = null,
        $departmentId = null
    ) {
        $academic_version_id = 1;

        $data = [];
        $data['academic_version_id'] = $academic_version_id == 'null' ? null : $academic_version_id;
        $data['academic_year_id'] = $siteYearId == 'null' ? null : $siteYearId;
        $data['academic_shift_id'] = $siteShiftId == 'null' ? null : $siteShiftId;
        $data['academic_department_id'] = $departmentId == 'null' ? null : $departmentId;
        $data['academic_class_id'] = $classId == 'null' ? null : $classId;
        $data['academic_section_id'] = $sectionId == 'null' ? null : $sectionId;
        $data['academic_class_group_id'] = $classGroupId == 'null' ? null : $classGroupId;
        $data['academic_session_id'] = $sessionId == 'null' ? 0 : $sessionId;

        $this->checkClassSectionGroup($data['academic_version_id'], $data['academic_year_id'], $data['academic_shift_id'], $data['academic_department_id'], $data['academic_class_id'], $data['academic_class_group_id'], $data['academic_section_id'], $data['academic_session_id']);

        $feeAllocationDetails = new SiteStudentFeeFineAllocation();
        $feeAllocationDetailsList = $feeAllocationDetails
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $siteShiftId)
            ->where('academic_class_id', $classId)
            ->when($departmentId != 'null', function ($query) use ($departmentId) {
                return $query->where('academic_department_id', $departmentId);
            })->when($classGroupId != 'null', function ($query) use ($classGroupId) {
                return $query->where('academic_class_group_id', $classGroupId);
            })->when($sectionId != 'null', function ($query) use ($sectionId) {
                return $query->where('academic_section_id', $sectionId);
            })->when($sessionId != 'null', function ($query) use ($sessionId) {
                return $query->where('academic_session_id', $sessionId);
            })->get();



        $head = new AcademicFeeHead();
        $headList = $head->get();

        $group = new AcademicFeeGroup();
        $groupList = $group->get();

        $subHead = new AcademicFeeSubHead();
        $subHeadList = $subHead->get();

        $final = [];

        foreach ($feeAllocationDetailsList as $key => $value) {

            $final[$key]['id'] = $value->id;

            $head_list = $headList->where('id', $value->academic_fee_head_id)->first();
            $final[$key]['head_name'] = $head_list->name;
            $final[$key]['head_id'] = $value->academic_fee_head_id;
            //return $name;
            $group_list = $groupList->where('id', $value->academic_fee_group_id)->first();
            $final[$key]['group_name'] = $group_list->name;
            $final[$key]['group_id'] = $value->academic_fee_group_id;

            $sub_head_list = $subHeadList->where('id', $value->academic_fee_sub_head_id)->first();
            $final[$key]['sub_head_name'] = $sub_head_list->name;
            $final[$key]['sub_head_id'] = $value->academic_fee_sub_head_id;

            $final[$key]['amount'] = $value->amount;
            $final[$key]['change_amount'] = ""; //extra field
            $final[$key]['status'] = $value->status;
        }
        return $final;
    }

    public function getStudentListByYearSessionShiftClassGroupSection(Request $request)
    {

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
        $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
        $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
        $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
        $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
        $data['academic_session_id'] = $request->academic_session_id == 'null' ? 0 : $request->academic_session_id;
        $data['routine_allocation_id'] = $request->routine_allocation_id;
        $attDate = $request->att_date;
        //        return $data;

        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            return Response::json(['message' => 'Select * marked Field!'], 411);
        }

        $this->checkClassSectionGroup(
            $request->academic_version_id,
            $request->academic_year_id,
            $request->academic_shift_id,
            $request->academic_department_id,
            $request->academic_class_id,
            $request->academic_class_group_id,
            $request->academic_section_id,
            $request->academic_session_id
        );
        // dd('ok');


        $students = new User();

        $studentList = $students->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })->when($data['academic_section_id'], function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })->when($data['academic_class_group_id'], function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->orderBy('student_roll_number', 'ASC')
            // ->select('id', 'biometric_id', 'student_roll_number', 'phone', 'academic_class_id', 'academic_section_id')
            ->get();
        //dd($userList);
        return $studentList;
    }

    public function getSiteAcademicSessionList($year_id, $shift_id, $class_id)
    {

        $siteShiftClassGroupSectionSetting = new  SiteShiftClassGroupSectionSetting();
        $site_accdemic_class_group_ids_list = $siteShiftClassGroupSectionSetting
            ->where('academic_class_id', $class_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)->pluck('academic_session_id');

        $academicSeesion = new AcademicSession();
        $academicClassGroupList = $academicSeesion->whereIn('id', $site_accdemic_class_group_ids_list)->get();

        return $academicClassGroupList;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    private function classGroupSectionValidation($request)
    {

        $academic_class_group_id = $request->academic_class_group_id;
        $academic_section_id = $request->academic_section_id;
        $academic_student_admission_type_id = $request->academic_student_admission_type_id;
        $academic_student_category_id = $request->academic_student_category_id;
        $academic_student_type_id = $request->academic_student_type_id;

        $data = $request->all();

        $find_list=SiteStudentFeeFineAllocation::where('academic_fee_head_id',$request->checked_fee_head_id)
            ->where('academic_version_id',$request->academic_version_id)
            ->where('academic_shift_id',$request->academic_shift_id)
            ->where('academic_year_id',$request->academic_year_id)
            ->where('academic_class_id',$request->academic_class_id)
            ->when($academic_class_group_id, function ($qr) use($academic_class_group_id){
                return $qr->where('academic_class_group_id', $academic_class_group_id);
            })
            ->when($academic_section_id, function ($qr) use($academic_section_id){
                return $qr->where('academic_section_id', $academic_section_id);
            })
            ->when($academic_student_admission_type_id, function ($qr) use ($academic_student_admission_type_id) {
                return $qr->where('academic_student_admission_type_id', $academic_student_admission_type_id);
            })
            ->when($academic_student_category_id, function ($qr) use ($academic_student_category_id) {
                return $qr->where('academic_student_category_id', $academic_student_category_id);
            })
            ->when($academic_student_type_id, function ($qr) use ($academic_student_type_id) {
                return $qr->where('academic_student_type_id', $academic_student_type_id);
            })
            ->when(empty($data['academic_department_id']), function ($query) {
                return $query->where('academic_department_id', null);
            })
            ->when(empty($data['academic_section_id']), function ($query) {
                return $query->where('academic_section_id', null);
            })
            ->when(empty($data['academic_class_group_id']), function ($query) {
                return $query->where('academic_class_group_id', null);
            })
            ->when(empty($data['academic_student_category_id']), function ($query) {
                return $query->where('academic_student_category_id', null);
            })
            ->when(empty($data['academic_student_type_id']), function ($query) {
                return $query->where('academic_student_type_id', null);
            })
            ->where('status', 1)
            ->get();


        if(count($find_list)==0){
            return Response::json(['message' => 'You have no allocation for this options!', 'mode' => 'Error'], 200);
        }

    }

    public function getSiteClassDeptfeeHeadBaseFeePdf(Request $request)
    {

        $getSiteClassDeptfeeHeadBaseFee =  $this->getSiteClassDeptfeeHeadBaseFee($request);
        // Check if it's a JsonResponse and decode it
        if ($getSiteClassDeptfeeHeadBaseFee instanceof \Illuminate\Http\JsonResponse) {
            $getSiteClassDeptfeeHeadBaseFee = json_decode($getSiteClassDeptfeeHeadBaseFee->getContent(), true);
        }

        // Ensure the response is an array
        if (!is_array($getSiteClassDeptfeeHeadBaseFee) || count($getSiteClassDeptfeeHeadBaseFee) < 2) {
            return response()->json([
                'message' => 'Error: Data not found or invalid response format.',
            ], 400);
        }

        // Access elements safely
        $siteBaseFeeList = $getSiteClassDeptfeeHeadBaseFee[0] ?? []; // Default to an empty array if not found
        $siteStudentFeeList = $getSiteClassDeptfeeHeadBaseFee[1] ?? [];

        $report_tittle = '<b>Head Base Fee</b><br>';
        $report_tittle2  = '';
        $title_view   = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.site-class-dept-fee-head-base-fee-pdf', compact('report_tittle2', 'title_view', 'report_tittle', 'siteStudentFeeList', 'siteBaseFeeList'));

        $path = storage_path() . '/pdf';

        $time = auth()->user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return response()->json([
            'link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'
        ], 200);
    }

    public function getSiteClassDeptfeeHeadBaseFee2(Request $request)
    {

        $startTime = microtime(true);
        \Log::info('Start getSiteClassDeptfeeHeadBaseFee', ['time' => now()]);

        $valiedation = $this->classGroupSectionValidation($request);


        $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);

        \Log::info('star returnSiteGroupFeeList', [
            'execution_time_seconds' => $executionTime,
        ]);
      
        if ($valiedation) {
            return $valiedation;
        }

        $siteGroupFeeList = $this->returnSiteGroupFeeList($request);

           $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);

        \Log::info('End returnSiteGroupFeeList', [
            'execution_time_seconds' => $executionTime,
        ]);
      


       // dd($valiedation);
        $siteAllocationFeeListIds = [];
        foreach ($siteGroupFeeList as $key => $value) {
            $siteAllocationFeeListIds[] = $value['id'];
        }
        $student_ids = isset($request->siteStudentList) ? $request->siteStudentList : [];

        if (count($student_ids) <= 0) {
            if ($request->student_histories_id) {
                $student_ids = array_push($student_ids, $request->student_histories_id);
            }
        }

        //   dd($student_ids);
        if ($request->student_histories_id) {
            $feeGeneratedLists = SiteStudentFeeGenerate::whereIn('site_student_fee_fine_allocation_id', $siteAllocationFeeListIds)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->where('student_history_id', $request->student_histories_id)
                ->where('status', true)
                ->get();
        } else {
            if (count($student_ids)) {
                $feeGeneratedLists = SiteStudentFeeGenerate::whereIn('site_student_fee_fine_allocation_id', $siteAllocationFeeListIds)
                    ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                    ->whereIn('student_history_id', $student_ids)
                    ->where('status', true)
                    ->get();
            } else {
                $section_id = $request->academic_section_id;
                $feeGeneratedLists = SiteStudentFeeGenerate::with('siteStudentFeeFineAllocation')
                    ->whereIn('site_student_fee_fine_allocation_id', $siteAllocationFeeListIds)
                    ->when($section_id, function ($query) use ($section_id) {
                        return $query->where('academic_section_id', $section_id);
                    })
                    ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                    ->where('status', true)
                    ->get();
            }
        }


        $siteGroupFeeFinalList = [];
        $siteGroupFeeFinalArr = array();
        $fee_key = 0;
        foreach ($siteGroupFeeList as $key => $value) {

            $checkIfPresent = $feeGeneratedLists->where('site_student_fee_fine_allocation_id', $value['id']);
            $gffg[$key] = $checkIfPresent;
            if (count($checkIfPresent) > 0) {

                foreach ($checkIfPresent as $k => $v) {
                    $siteGroupFeeFinalArr['generate_amount'] = $v->amount;
                }
                $siteGroupFeeFinalArr['select_fee_sub_head_id'] = true;
            } else {
                $siteGroupFeeFinalArr['select_fee_sub_head_id'] = false;
                $siteGroupFeeFinalArr['generate_amount'] = $value['amount'];
            }
            $siteGroupFeeFinalArr['select_sub_head'] = false;

            $siteGroupFeeFinalList[$fee_key] = array_merge($siteGroupFeeFinalArr, is_array($value) ? $value : $value->toArray());
            $fee_key++;
        }

        /////////////////
        $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);

        \Log::info('start returnSiteStudentIDs', [
            'execution_time_seconds' => $executionTime,
        ]);
      

        $siteStudentIDs = $this->returnSiteStudentIDs($request);

           $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);

        \Log::info('End returnSiteStudentIDs', [
            'execution_time_seconds' => $executionTime,
        ]);
      

        //   $siteStudentIDs=$siteStudentlist->where('status', $request->student_status);

        $studentFeeList = [];

        $feeGeneratedList = SiteStudentFeeGenerate::where('fee_head_type_id', $request->checked_admission_examination_general_id)
            ->where('academic_fee_head_id', $request->checked_fee_head_id)
            ->where('status', true)
            ->orderBy('id','DESC')
            ->get();

        \Log::info('End feeGeneratedList', [
            'execution_time_seconds' => $executionTime,
        ]);

        foreach ($siteStudentIDs as $stdkey => $studentHistory) {

            $siteGroupFeeFinalList2 = [];
            $siteGroupFeeFinalArr2 = array();
            $fee_key2 = 0;
            foreach ($siteGroupFeeList as $key2 => $value) {

                //check previous generated data
                $checkIfDuplicatePresent = $feeGeneratedList->where('site_student_fee_fine_allocation_id', '!=', $value['id'])
                    ->where('academic_fee_sub_head_id', $value['academic_fee_sub_head_id'])
                    ->where('student_history_id', $studentHistory->id)
                    ->where('demand_slip_create_status',true)
                    ->where('status', true)
                    ->first();

                    if(!$checkIfDuplicatePresent){
                        $checkIfDuplicatePresent=$feeGeneratedList->where('site_student_fee_fine_allocation_id','!=',$value['id'])
                        ->where('academic_fee_sub_head_id', $value['academic_fee_sub_head_id'])
                        ->where('student_history_id', $studentHistory->id)
                        ->where('status', true)
                        ->first();
                    }
            
                if($checkIfDuplicatePresent){
                    $siteGroupFeeFinalArr2['fee_sub_head_id'] = $checkIfDuplicatePresent->academic_fee_sub_head_id;


            

                    $siteGroupFeeFinalArr2['generate_amount'] = $checkIfDuplicatePresent->amount;

                    $siteGroupFeeFinalArr2['demand_slip_create_status'] = $checkIfDuplicatePresent->demand_slip_create_status;
                    if (!empty($checkIfDuplicatePresent->site_student_fee_demand_slip_detail_id)) {
                        $siteGroupFeeFinalArr2['demand_slip_create_status'] = true;
                    }


                    $siteGroupFeeFinalArr2['select_fee_sub_head_id'] = true;
                    $siteGroupFeeFinalArr2['select_subhead'] = true;
                    $siteGroupFeeFinalArr2['site_student_fee_fine_allocation_id'] = $checkIfDuplicatePresent['site_student_fee_fine_allocation_id'];

               
                    $anotherAllocation=SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                        ->where('id',$checkIfDuplicatePresent->site_student_fee_fine_allocation_id)
                        ->first();
                    
                      
                    $siteGroupFeeFinalArr2['duplicate_site_student_fee_fine_allocation_id'] = $value['id'];
                  
                    $mergedData = array_merge($siteGroupFeeFinalArr2, is_array($anotherAllocation) ? $anotherAllocation : $anotherAllocation->toArray());
                   
                    $siteGroupFeeFinalList2[$fee_key2] = $mergedData;

                }else{


                    // $checkIfPresent=$feeGeneratedLists->where('student_history_id', $studentHistory->id)
                    //     ->where('site_student_fee_fine_allocation_id',$value['id'])
                    //     ->first();

                    $checkIfPresent=$feeGeneratedList->where('site_student_fee_fine_allocation_id', $value['id'])
                        ->where('academic_fee_sub_head_id', $value['academic_fee_sub_head_id'])
                        ->where('student_history_id', $studentHistory->id)
                        ->where('demand_slip_create_status',true)
                        ->where('status', true)
                        ->first();

                       if(!$checkIfPresent){
                        $checkIfPresent=$feeGeneratedList->where('site_student_fee_fine_allocation_id', $value['id'])
                            ->where('academic_fee_sub_head_id', $value['academic_fee_sub_head_id'])
                            ->where('student_history_id', $studentHistory->id)
                            ->where('status', true)
                            ->first();
                    }

                    $checkIfPresent = $feeGeneratedList->where('site_student_fee_fine_allocation_id', $value['id'])
                        ->where('academic_fee_sub_head_id', $value['academic_fee_sub_head_id'])
                        ->where('student_history_id', $studentHistory->id)
                        ->where('status', true)
                        ->first();



                    if ($checkIfPresent) {

                        $siteGroupFeeFinalArr2['generate_amount'] = $checkIfPresent->amount;
                        $siteGroupFeeFinalArr2['demand_slip_create_status'] = $checkIfPresent->demand_slip_create_status;
                        if (!empty($checkIfPresent->site_student_fee_demand_slip_detail_id)) {
                            $siteGroupFeeFinalArr2['demand_slip_create_status'] = true;
                        }

                        $siteGroupFeeFinalArr2['select_fee_sub_head_id'] = true;
                        $siteGroupFeeFinalArr2['select_subhead'] = true;

                        }else{
                            $siteGroupFeeFinalArr2['generate_amount'] = $value['amount'];
                            $siteGroupFeeFinalArr2['select_fee_sub_head_id'] = false;
                            $siteGroupFeeFinalArr2['select_subhead'] = false;
                            $siteGroupFeeFinalArr2['demand_slip_create_status'] = false;
                        }
                        $siteGroupFeeFinalArr2['site_student_fee_fine_allocation_id'] = $value['id'];

                  
                          
                    $siteGroupFeeFinalArr2['duplicate_site_student_fee_fine_allocation_id'] = $value['id'];
                  
                    $mergedData = array_merge($siteGroupFeeFinalArr2, is_array($value) ? $value : $value->toArray());
                   
                    $siteGroupFeeFinalList2[$fee_key2] = $mergedData;
                    }

                    $fee_key2++;
            }


            $studentFeeList[$stdkey]['select_student'] = true;
            $studentFeeList[$stdkey]['student_history_id'] = $studentHistory->id;
            $studentFeeList[$stdkey]['user_id'] = $studentHistory->user_id;
            $studentFeeList[$stdkey]['full_name'] = $studentHistory->full_name;
            $studentFeeList[$stdkey]['student_roll_number'] = $studentHistory->student_roll_number;
            $studentFeeList[$stdkey]['username'] = $studentHistory->username;
            $studentFeeList[$stdkey]['feeFinalList'] = $siteGroupFeeFinalList2;
        }

        $endTime = microtime(true);
        $executionTime = round($endTime - $startTime, 4);

        \Log::info('End ', [
            'execution_time_seconds' => $executionTime,
        ]);
      


        return response()->json([$siteGroupFeeFinalList, $studentFeeList], 200, [], JSON_NUMERIC_CHECK);
    }


    public function getSiteClassDeptfeeHeadBaseFee(Request $request)
        {
            $startTime = microtime(true);
            \Log::info('Start getSiteClassDeptfeeHeadBaseFee', ['time' => now()]);

            // Step 1: Validate
            if ($validation = $this->classGroupSectionValidation($request)) {
                return $validation;
            }

            // Step 2: Get Fee Allocations
            $siteGroupFeeList = $this->returnSiteGroupFeeList($request);
            $siteAllocationFeeListIds = collect($siteGroupFeeList)->pluck('id')->all();

        

          //  dd($siteGroupFeeList);

           

            // Step 3: Determine student IDs
            $student_ids = $request->siteStudentList ?? [];
            if (empty($student_ids) && $request->student_histories_id) {
                $student_ids[] = $request->student_histories_id;
            }

            // Step 4: Get already generated fees
            $feeGeneratedLists = SiteStudentFeeGenerate::whereIn('site_student_fee_fine_allocation_id', $siteAllocationFeeListIds)
                ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->when($request->student_histories_id, fn($q) => $q->where('student_history_id', $request->student_histories_id))
                ->when(!$request->student_histories_id && count($student_ids), fn($q) => $q->whereIn('student_history_id', $student_ids))
                ->when(!$request->student_histories_id && empty($student_ids), function ($q) use ($request) {
                    return $q->when($request->academic_section_id, fn($q2) => $q2->where('academic_section_id', $request->academic_section_id));
                })
                ->where('status', true)
                ->get();

            // Step 5: Build lookup map for faster filtering
            $feeGeneratedMap = [];
            foreach ($feeGeneratedLists as $item) {
                $feeGeneratedMap[$item->student_history_id][$item->academic_fee_sub_head_id][$item->site_student_fee_fine_allocation_id] = $item;
            }

            // Step 6: First-level final list (allocation-wise)
            $siteGroupFeeFinalList = [];
            foreach ($siteGroupFeeList as $key => $value) {
                $hasGenerated = false;
                foreach ($feeGeneratedLists as $v) {
                    if ($v->site_student_fee_fine_allocation_id == $value['id']) {
                        $hasGenerated = true;
                        $generateAmount = $v->amount;
                        break;
                    }
                }

                $siteGroupFeeFinalList[$key] = array_merge(
                    [
                        'generate_amount' => $hasGenerated ? $generateAmount : $value['amount'],
                        'select_fee_sub_head_id' => $hasGenerated,
                        'select_subhead' => false,
                    ],
                    is_array($value) ? $value : $value->toArray()
                );
            }

          $siteGroupFeeFinalList = collect($siteGroupFeeFinalList)
            ->groupBy(function ($item) {
                return $item['academic_fee_head_id'] . '-' .
                    $item['academic_fee_group_id'] . '-' .
                    $item['academic_fee_sub_head_id'] . '-' .
                    $item['academic_student_type_id'];
            })
             ->map(function ($group) {
                return $group->first();
            })
            ->values();


          //  dd($siteGroupFeeFinalList);



            // Step 7: Fetch student list
            $siteStudentIDs = $this->returnSiteStudentIDs($request);

              \Log::info('End getSiteClassDeptfeeHeadBaseFee', [
                'execution_time_seconds' => round(microtime(true) - $startTime, 4),
            ]);

            // Step 8: Get all feeGeneratedList by fee_head_id and fee_head_type
            $feeGeneratedList = SiteStudentFeeGenerate::where('fee_head_type_id', $request->checked_admission_examination_general_id)
                ->where('academic_fee_head_id', $request->checked_fee_head_id)
                ->where('status', true)
                ->orderByDesc('id')
                ->get();

            // Step 9: Prepare allocation info for batch fetch
            $allocationIdsToFetch = $feeGeneratedList->pluck('site_student_fee_fine_allocation_id')->unique()->all();
            $allocationInfoMap = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                ->whereIn('id', $allocationIdsToFetch)
                ->get()
                ->keyBy('id');

                           


            // Step 10: Process student-wise fee list
            $studentFeeList = [];
            $feeGeneratedListMap = [];
            foreach ($feeGeneratedList as $item) {
                $feeGeneratedListMap[$item->student_history_id][$item->academic_fee_sub_head_id][$item->site_student_fee_fine_allocation_id] = $item;
            }

            foreach ($siteStudentIDs as $stdkey => $studentHistory) {
                $siteGroupFeeFinalList2 = [];
                foreach ($siteGroupFeeFinalList as $key2 => $value) {
                    $feeSubHeadId = $value['academic_fee_sub_head_id'];
                    $allocationId = $value['id'];
                    $studentId = $studentHistory->id;

                    $matched = null;

                    if (isset($feeGeneratedListMap[$studentId][$feeSubHeadId])) {
                        foreach ($feeGeneratedListMap[$studentId][$feeSubHeadId] as $fid => $record) {
                            if ($fid != $allocationId && $record->status) {
                                $matched = $record;
                                if ($record->demand_slip_create_status) break;
                            }
                        }
                    }

                    if ($matched) {
                        $feeArr = [
                            'fee_sub_head_id' => $matched->academic_fee_sub_head_id,
                            'generate_amount' => $matched->amount,
                            'demand_slip_create_status' => !empty($matched->site_student_fee_demand_slip_detail_id) ? true : $matched->demand_slip_create_status,
                            'select_fee_sub_head_id' => true,
                            'select_subhead' => true,
                            'site_student_fee_fine_allocation_id' => $matched->site_student_fee_fine_allocation_id,
                            'duplicate_site_student_fee_fine_allocation_id' => $allocationId,
                        ];

                        $extra = optional($allocationInfoMap[$matched->site_student_fee_fine_allocation_id] ?? [])->toArray();
                        $merged = array_merge($feeArr, $extra);
                    } else {
                        $record = $feeGeneratedListMap[$studentId][$feeSubHeadId][$allocationId] ?? null;
                        if ($record && $record->status) {
                            $feeArr = [
                                'generate_amount' => $record->amount,
                                'demand_slip_create_status' => !empty($record->site_student_fee_demand_slip_detail_id) ? true : $record->demand_slip_create_status,
                                'select_fee_sub_head_id' => true,
                                'select_subhead' => true,
                            ];
                        } else {
                            $feeArr = [
                                'generate_amount' => $value['amount'],
                                'demand_slip_create_status' => false,
                                'select_fee_sub_head_id' => false,
                                'select_subhead' => false,
                            ];
                        }

                        $feeArr['site_student_fee_fine_allocation_id'] = $allocationId;
                        $feeArr['duplicate_site_student_fee_fine_allocation_id'] = $allocationId;

                        $merged = array_merge(is_array($value) ? $value : $value->toArray(),$feeArr);
                    }

                
                    $siteGroupFeeFinalList2[] = $merged;
                }

                
                $studentFeeList[$stdkey] = [
                    'select_student' => true,
                    'student_history_id' => $studentHistory->id,
                    'user_id' => $studentHistory->user_id,
                    'full_name' => $studentHistory->full_name,
                    'student_roll_number' => $studentHistory->student_roll_number,
                    'username' => $studentHistory->username,
                    'feeFinalList' => $siteGroupFeeFinalList2,
                ];
            }

            $siteGroupFeeFinalList=collect($siteGroupFeeFinalList)->values();


            return response()->json([$siteGroupFeeFinalList, $studentFeeList], 200, [], JSON_NUMERIC_CHECK);
        }




    private function returnSiteGroupFeeList(Request $request)
    {
        //        return $request;
        $data = $request->all();

      //  $FeeGroupsGlobalID = AcademicFeeGroup::whereIn('head_key', ['global'])->pluck('id');

        $FeeGroupsClassIDs = AcademicFeeGroup::whereIn('head_key', ['classbase', 'studentbase'])->pluck('id');

        $siteGroupFeeList = array();
        if ($request->checked_fee_head_id != null && $request->academic_class_id != null) {

            $SiteGlobalFeeList_ids = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                ->where('academic_fee_head_id', $request->checked_fee_head_id)
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', null)
                ->where('academic_department_id', null)
                ->where('academic_section_id', null)
                ->where('academic_class_group_id', null)
                ->where('academic_session_id', null)
                ->where('status', true)
                ->pluck('id');

            $SiteOtherFeeList_ids = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                ->where('academic_fee_head_id', $request->checked_fee_head_id)
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('status', true)
                ->pluck('id');

            $marge_fee_list=array_merge($SiteGlobalFeeList_ids->toArray(), $SiteOtherFeeList_ids->toArray());
            $fee_unique_ids=collect($marge_fee_list)->unique()->values();

            $SiteFeeList=SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup','academicFeeSubHead' ])
                ->whereIn('id',$fee_unique_ids)
                ->get();

            $siteGlobalFeeList = $SiteFeeList->whereIn('id', $SiteGlobalFeeList_ids);

            $siteClassStudentFeeList = $SiteFeeList
                ->whereIn('academic_fee_group_id', $FeeGroupsClassIDs)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('academic_student_admission_type_id', $request->academic_student_admission_type_id ?? null)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                    return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                })
                ->when(empty($data['academic_department_id']), function ($query) {
                    return $query->where('academic_department_id', null);
                })
                ->when(empty($data['academic_section_id']), function ($query) {
                    return $query->where('academic_section_id', null);
                })
                ->when(empty($data['academic_class_group_id']), function ($query) {
                    return $query->where('academic_class_group_id', null);
                })
                ->when(empty($data['academic_student_category_id']), function ($query) {
                    return $query->where('academic_student_category_id', null);
                })
                ->when(empty($data['academic_student_type_id']), function ($query) {
                    return $query->where('academic_student_type_id', null);
                });
               // ->limit(1);




            if (
                $request->academic_student_category_id != null || $request->academic_student_type_id != null
                || $request->academic_student_admission_type_id != null
            ) {
                $siteGroupFeeList = $siteClassStudentFeeList;
            } else {
                $siteGroupFeeList = array_merge($siteGlobalFeeList->toArray(), $siteClassStudentFeeList->toArray());
            }
        }

        return $siteGroupFeeList;
    }

    private function returnSiteStudentIDs(Request $request)
    {

        //   dd($request->all());

        $data = $request->all();

        if ($request->academic_class_id) {

            if ($request->academic_class_group_present) {

                $siteStudentIDs = StudentHistory::with(['student' => function ($query) {
                    $query->select(['id', 'username', 'student_roll_number']);
                }])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', 1)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when(!empty($data['student_histories_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_histories_id']);
                    })
                    ->when(isset($data['student_status']), function ($query) use ($data) {
                        return $query->where('status', $data['student_status']);
                    })

                    //->where('student_history_id', $request->student_histories_id)
                    ->orderBy('student_roll_number')
                    ->orderBy('academic_section_id')
                    ->orderBy('academic_class_group_id')
                    ->orderBy('academic_class_id')
                    ->orderBy('academic_department_id')
                    ->get(['id', 'user_id', 'student_roll_number']);

                //  dd($siteStudentIDs);

            } else {

                $siteStudentIDs = StudentHistory::with(['student' => function ($query) {
                    $query->select(['id', 'username', 'student_roll_number']);
                }])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', 1)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->when(isset($data['student_status']), function ($query) use ($data) {
                        return $query->where('status', $data['student_status']);
                    })
                    ->when(!empty($data['student_histories_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_histories_id']);
                    })
                    ->orderBy('student_roll_number')
                    ->orderBy('academic_section_id')
                    ->orderBy('academic_class_group_id')
                    ->orderBy('academic_class_id')
                    ->orderBy('academic_department_id')
                    ->get(['id', 'user_id', 'student_roll_number']);

                // dd($siteStudentIDs);
            }
        }

       // dd($siteStudentIDs);
        return $siteStudentIDs;
    }

    //===========================create & update for fee generate====================================

    private function studentHistoryList($request)
    {

        $data = $request->all();
        //   $student_ids =  $request->siteStudentList;

        $siteStudent = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', true)
            //  ->whereIn('id', $student_ids)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->get([
                'id',
                'user_id',
                'academic_student_category_id',
                'academic_student_type_id',
                'academic_student_admission_type_id',
                'academic_residence_id',
                'academic_quata_id',
                'academic_transport_id'
            ]);

        return $siteStudent;
    }

    public function createUpdateSiteFeeGenerate(Request $request)
        {
            try {
              //  DB::beginTransaction();


                    $offset = $request->offset ?? 0;
                    $batchSize = 50; // প্রতি request এ কয়জন student process হবে

                    $checked_ids = $request->fee_head_name === 'monthly'
                        ? $request->select_month_ids
                        : [$request->checked_admission_examination_general_id];

                    $selectedStudents = collect($request->siteStudentFeeList)
                        ->where('select_student', true);

                    $total_students = count($selectedStudents);

                    if ($total_students === 0) {
                        return response()->json([
                            'message' => 'No students found.',
                            'next_offset' => 0,
                            'completed_percent' => 100,
                            'completed' => true,
                        ]);
                    }

                    // বর্তমান batch এর student slice করা
                    $studentsBatch = $selectedStudents->slice($offset, $batchSize);

                    // student_history_id গুলো পাওয়া
                    $studentHistoryIds = $studentsBatch
                        ->pluck('student_history_id')
                        ->unique()
                        ->values();

           
                $existingFees = SiteStudentFeeGenerate::whereIn('student_history_id', $studentHistoryIds)
                    ->whereIn('fee_head_type_id', $checked_ids)
                    ->where('academic_fee_head_id', $request->checked_fee_head_id)
                    ->get();

                foreach ($studentsBatch->values() as $student) {
                    foreach ($checked_ids as $fee_head_type_id) {
                        foreach ($student['feeFinalList'] as $fee) {
                            $studentId = $student['student_history_id'];
                            $headId = $fee['academic_fee_head_id'];
                            $subHeadId = $fee['academic_fee_sub_head_id'];
                            $allocationId = $fee['site_student_fee_fine_allocation_id'];
                            $duplicateId = $fee['duplicate_site_student_fee_fine_allocation_id'];

                            $matchFee = fn($q) =>
                                $q['student_history_id'] === $studentId &&
                                $q['fee_head_type_id'] === $fee_head_type_id &&
                                $q['academic_fee_head_id'] === $headId &&
                                $q['academic_fee_sub_head_id'] === $subHeadId;

                            if ($fee['select_fee_sub_head_id']) {
                                // Deactivate duplicate record if exists
                                $duplicate = $existingFees
                                    ->filter($matchFee)
                                    ->firstWhere('site_student_fee_fine_allocation_id', '!=', $duplicateId);

                                  

                                if ($duplicate && !$duplicate->demand_slip_create_status && empty($duplicate->site_student_fee_demand_slip_detail_id)) {
                                    $duplicate->status = false;
                                    $duplicate->save();
                                }

                                // Find or create new fee record
                                $feeRecord = $existingFees
                                    ->filter($matchFee)
                                    ->firstWhere('site_student_fee_fine_allocation_id', $allocationId);

                                if ($feeRecord) {
                                    if (!$feeRecord->demand_slip_create_status && empty($feeRecord->site_student_fee_demand_slip_detail_id)) {
                                        $feeRecord->amount = $fee['generate_amount'];
                                        $feeRecord->status = true;
                                        $feeRecord->save();
                                    }
                                } elseif ($fee['generate_amount'] > 0) {
                                     
                                    SiteStudentFeeGenerate::create([
                                        'site_id' => Session::get('SITE_ID'),
                                        'site_student_fee_fine_allocation_id' => $allocationId,
                                        'student_history_id' => $studentId,
                                        'fee_head_type_id' => $fee_head_type_id,
                                        'academic_fee_head_id' => $headId,
                                        'academic_fee_sub_head_id' => $subHeadId,
                                        'amount' => $fee['generate_amount'],
                                        'status' => true,
                                    ]);
                                }
                            } else {
                                // Mark unwanted fee record as inactive
                                $extra = $existingFees
                                    ->filter($matchFee)
                                    ->firstWhere('site_student_fee_fine_allocation_id', $duplicateId);

                                if ($extra && !$extra->demand_slip_create_status && empty($extra->site_student_fee_demand_slip_detail_id)) {
                                    $extra->status = false;
                                    $extra->save();
                                }
                            }

                            // Remove other mismatched allocations for the same head/subhead
                            $otherExtra = $existingFees
                                ->filter($matchFee)
                                ->first(function ($item) use ($allocationId) {
                                    return $item->site_student_fee_fine_allocation_id != $allocationId;
                                });

                            if ($otherExtra && !$otherExtra->demand_slip_create_status && empty($otherExtra->site_student_fee_demand_slip_detail_id)) {
                                $otherExtra->status = false;
                                $otherExtra->save();
                            }
                        }
                    }
                }


                // পরবর্তী offset এবং progress হিসাব
                $nextOffset = $offset + $batchSize;
                $completedPercent = round(($nextOffset / $total_students) * 100, 2);
                $isCompleted = $nextOffset >= $total_students;

                return response()->json([
                    'message' => $isCompleted ? 'All students processed successfully!' : 'Batch processed successfully!',
                    'next_offset' => $nextOffset,
                    'completed_percent' => min($completedPercent, 100),
                    'completed' => $isCompleted,
                    'total_student_count' => $total_students,
                    'studentsBatch' => $studentsBatch,
                ]);


            } catch (ValidationException $exception) {
               // DB::rollBack();
                return JsonResponse::create([
                    'message' => $exception->getMessage(),
                    'errors' => $exception->validator->getMessageBag()->toArray()
                ], 422);

            } catch (Exception $exception) {
               // DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }
        }


    public function createUpdateSiteFeeGenerate_last(Request $request)
        {
            try {
                DB::beginTransaction();

                $checked_ids = $request->fee_head_name === 'monthly'
                    ? $request->select_month_ids
                    : [$request->checked_admission_examination_general_id];

                $selectedStudents = collect($request->siteStudentFeeList)
                    ->where('select_student', true);

                $studentHistoryIds = $selectedStudents
                    ->pluck('student_history_id')
                    ->unique()
                    ->values();

                // Preload all relevant fee records
                $existingFees = SiteStudentFeeGenerate::whereIn('student_history_id', $studentHistoryIds)
                    ->whereIn('fee_head_type_id', $checked_ids)
                    ->where('academic_fee_head_id', $request->checked_fee_head_id)
                    ->get();

                foreach ($selectedStudents as $student) {
                    foreach ($checked_ids as $fee_head_type_id) {
                        foreach ($student['feeFinalList'] as $fee) {
                            $studentId = $student['student_history_id'];
                            $headId = $fee['academic_fee_head_id'];
                            $subHeadId = $fee['academic_fee_sub_head_id'];
                            $allocationId = $fee['site_student_fee_fine_allocation_id'];
                            $duplicateId = $fee['duplicate_site_student_fee_fine_allocation_id'];

                            $matchFee = fn($q) =>
                                $q['student_history_id'] === $studentId &&
                                $q['fee_head_type_id'] === $fee_head_type_id &&
                                $q['academic_fee_head_id'] === $headId &&
                                $q['academic_fee_sub_head_id'] === $subHeadId;

                            if ($fee['select_fee_sub_head_id']) {
                                // Deactivate duplicate record if exists
                                $duplicate = $existingFees
                                    ->filter($matchFee)
                                    ->firstWhere('site_student_fee_fine_allocation_id', '!=', $duplicateId);

                                if ($duplicate && !$duplicate->demand_slip_create_status && empty($duplicate->site_student_fee_demand_slip_detail_id)) {
                                    $duplicate->status = false;
                                    $duplicate->save();
                                }

                                // Find or create new fee record
                                $feeRecord = $existingFees
                                    ->filter($matchFee)
                                    ->firstWhere('site_student_fee_fine_allocation_id', $allocationId);

                                if ($feeRecord) {
                                    if (!$feeRecord->demand_slip_create_status && empty($feeRecord->site_student_fee_demand_slip_detail_id)) {
                                        $feeRecord->amount = $fee['generate_amount'];
                                        $feeRecord->status = true;
                                        $feeRecord->save();
                                    }
                                } elseif ($fee['generate_amount'] > 0) {
                                    SiteStudentFeeGenerate::create([
                                        'site_id' => Session::get('SITE_ID'),
                                        'site_student_fee_fine_allocation_id' => $allocationId,
                                        'student_history_id' => $studentId,
                                        'fee_head_type_id' => $fee_head_type_id,
                                        'academic_fee_head_id' => $headId,
                                        'academic_fee_sub_head_id' => $subHeadId,
                                        'amount' => $fee['generate_amount'],
                                        'status' => true,
                                    ]);
                                }
                            } else {
                                // Mark unwanted fee record as inactive
                                $extra = $existingFees
                                    ->filter($matchFee)
                                    ->firstWhere('site_student_fee_fine_allocation_id', $duplicateId);

                                if ($extra && !$extra->demand_slip_create_status && empty($extra->site_student_fee_demand_slip_detail_id)) {
                                    $extra->status = false;
                                    $extra->save();
                                }
                            }

                            // Remove other mismatched allocations for the same head/subhead
                            $otherExtra = $existingFees
                                ->filter($matchFee)
                                ->first(function ($item) use ($allocationId) {
                                    return $item->site_student_fee_fine_allocation_id != $allocationId;
                                });

                            if ($otherExtra && !$otherExtra->demand_slip_create_status && empty($otherExtra->site_student_fee_demand_slip_detail_id)) {
                                $otherExtra->status = false;
                                $otherExtra->save();
                            }
                        }
                    }
                }

                DB::commit();
                return Response::json(['message' => 'Information Saved Successfully!', 'mode' => 'Saved!'], 200);

            } catch (ValidationException $exception) {
                DB::rollBack();
                return JsonResponse::create([
                    'message' => $exception->getMessage(),
                    'errors' => $exception->validator->getMessageBag()->toArray()
                ], 422);

            } catch (Exception $exception) {
                DB::rollBack();
                return Response::json(['message' => $exception->getMessage()], 410);
            }
        }

    public function createUpdateSiteFeeGenerate2(Request $request)
    {


        try {
            DB::beginTransaction();


            if ($request->fee_head_name == 'monthly') {
                $checked_admission_examination_general_ids = $request->select_month_ids;
            } else {
                $checked_admission_examination_general_ids[] = $request->checked_admission_examination_general_id;
            }

            $studen_history_ids=collect($request->siteStudentFeeList)
                ->where('select_student',true)
                ->pluck('student_history_id')
                ->unique()
                ->values();

            $siteStudentFeeGenerate = SiteStudentFeeGenerate::whereIn('student_history_id',$studen_history_ids)
                ->whereIn('fee_head_type_id',$checked_admission_examination_general_ids)
                ->where('academic_fee_head_id',$request->checked_fee_head_id)
                ->get();
           
            //dd($siteStudentFeeGenerate);


            foreach ($request->siteStudentFeeList as $key => $value) {
                if ($value['select_student']) {

                    //  return $value['feeFinalList'];
                    foreach ($checked_admission_examination_general_ids as $checked_admission_examination_general_id) {

                        foreach ($value['feeFinalList'] as $key2 => $value2) {


                            if ($value2['select_fee_sub_head_id']) {

                                // $checkFee=SiteStudentFeeGenerate::where('site_student_fee_fine_allocation_id',$value2['site_student_fee_fine_allocation_id'])
                                //     ->where('student_history_id',$value['student_history_id'])
                                //     ->where('fee_head_type_id',$checked_admission_examination_general_id)
                                //     ->where('academic_fee_head_id',$value2['academic_fee_head_id'])
                                //     ->where('academic_fee_sub_head_id',$value2['academic_fee_sub_head_id'])
                                //     ->first();


                                $checkDuplicate = $siteStudentFeeGenerate->where('site_student_fee_fine_allocation_id', '!=', $value2['duplicate_site_student_fee_fine_allocation_id'])
                                    ->where('student_history_id', $value['student_history_id'])
                                    ->where('fee_head_type_id', $checked_admission_examination_general_id)
                                    ->where('academic_fee_head_id', $value2['academic_fee_head_id'])
                                    ->where('academic_fee_sub_head_id', $value2['academic_fee_sub_head_id'])
                                    ->where('status', true)
                                    ->first();

                                if ($checkDuplicate) {
                                    if ($checkDuplicate->demand_slip_create_status == false && empty($checkDuplicate->site_student_fee_demand_slip_detail_id)) {
                                        $checkDuplicate->status = false;
                                        $checkDuplicate->save();

                                        $checkFee = $siteStudentFeeGenerate->where('site_student_fee_fine_allocation_id', $value2['site_student_fee_fine_allocation_id'])
                                            ->where('student_history_id', $value['student_history_id'])
                                            ->where('fee_head_type_id', $checked_admission_examination_general_id)
                                            ->where('academic_fee_head_id', $value2['academic_fee_head_id'])
                                            ->where('academic_fee_sub_head_id', $value2['academic_fee_sub_head_id'])
                                            ->first();
                                    } else {
                                        $checkFee = $siteStudentFeeGenerate->where('site_student_fee_fine_allocation_id', $value2['site_student_fee_fine_allocation_id'])
                                            ->where('student_history_id', $value['student_history_id'])
                                            ->where('fee_head_type_id', $checked_admission_examination_general_id)
                                            ->where('academic_fee_head_id', $value2['academic_fee_head_id'])
                                            ->where('academic_fee_sub_head_id', $value2['academic_fee_sub_head_id'])
                                            ->first();
                                    }
                                } else {
                                    $checkFee = $siteStudentFeeGenerate->where('site_student_fee_fine_allocation_id', $value2['site_student_fee_fine_allocation_id'])
                                        ->where('student_history_id', $value['student_history_id'])
                                        ->where('fee_head_type_id', $checked_admission_examination_general_id)
                                        ->where('academic_fee_head_id', $value2['academic_fee_head_id'])
                                        ->where('academic_fee_sub_head_id', $value2['academic_fee_sub_head_id'])
                                        ->first();
                                }


                                //  dd($checkFee);

                                if ($checkFee) {

                                    if ($checkFee->demand_slip_create_status == false && empty($checkFee->site_student_fee_demand_slip_detail_id)) {

                                        $checkFee->amount = $value2['generate_amount'];
                                        $checkFee->status = true;
                                        $checkFee->save();
                                    }
                                } else {
                                    if ($value2['generate_amount'] > 0) {
                                        $siteStudentFeeGenerate = new SiteStudentFeeGenerate();
                                        $siteStudentFeeGenerate->site_student_fee_fine_allocation_id = $value2['site_student_fee_fine_allocation_id'];
                                        $siteStudentFeeGenerate->student_history_id = $value['student_history_id'];
                                        $siteStudentFeeGenerate->fee_head_type_id = $checked_admission_examination_general_id;
                                        $siteStudentFeeGenerate->academic_fee_head_id = $value2['academic_fee_head_id'];
                                        $siteStudentFeeGenerate->academic_fee_sub_head_id = $value2['academic_fee_sub_head_id'];
                                        $siteStudentFeeGenerate->amount = $value2['generate_amount'];
                                        $siteStudentFeeGenerate->status = true;
                                        $siteStudentFeeGenerate->save();
                                    }
                                }
                            } else {
                                $checkExtraFee = $siteStudentFeeGenerate->where('student_history_id', $value['student_history_id'])
                                    //    ->where('site_student_fee_fine_allocation_id',$value2['site_student_fee_fine_allocation_id'])
                                    ->where('site_student_fee_fine_allocation_id', $value2['duplicate_site_student_fee_fine_allocation_id'])
                                    ->where('fee_head_type_id', $checked_admission_examination_general_id)
                                    ->where('academic_fee_head_id', $value2['academic_fee_head_id'])
                                    ->where('academic_fee_sub_head_id', $value2['academic_fee_sub_head_id'])
                                    ->where('status', true)
                                    ->first();

                                // dd($checkExtraFee);

                                if ($checkExtraFee) {
                                    if ($checkExtraFee->demand_slip_create_status == false && empty($checkExtraFee->site_student_fee_demand_slip_detail_id)) {
                                        $checkExtraFee->status = false;
                                        $checkExtraFee->save();
                                    }
                                }
                                // continue;
                            }

                            // extra fee delete 

                            $checkExtraFee2=$siteStudentFeeGenerate->where('student_history_id',$value['student_history_id'])
                                ->where('site_student_fee_fine_allocation_id','!=',$value2['site_student_fee_fine_allocation_id'])
                                ->where('fee_head_type_id',$checked_admission_examination_general_id)
                                ->where('academic_fee_head_id',$value2['academic_fee_head_id'])
                                ->where('academic_fee_sub_head_id',$value2['academic_fee_sub_head_id'])
                                ->where('status',true)
                                ->first();

                            if($checkExtraFee2){
                                if($checkExtraFee2->demand_slip_create_status==false && empty($checkExtraFee2->site_student_fee_demand_slip_detail_id)){
                                    $checkExtraFee2->status=false;
                                    $checkExtraFee2->save();
                                }
                            }
                        }
                    }
                }
            }

            DB::commit();
            return Response::json(['message' => 'Information Save Successfully!', 'mode' => 'Saved!'], 200);
        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data = $request->all();

        $accFeeDetails = $request->student_fee_details;

        if ($request->user_id) {

            //==================for single student================

            foreach ($accFeeDetails as $key => $value) {

                if ($value['status'] == true) {

                    $fee_generate = new SiteStudentFeeGenerate();
                    $fee_generate_list = $fee_generate->where('academic_version_id', $data['academic_version_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('academic_shift_id', $data['academic_shift_id'])
                        ->where('academic_class_id', $data['academic_class_id'])
                        ->when($data['academic_department_id'], function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })->when($data['academic_section_id'], function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })->when($data['academic_class_group_id'], function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->first();

                    if ($fee_generate_list) {
                        $fee_generate_list->update([
                            'amount' => $value['amount'],
                            'academic_year_id' => $data['academic_year_id'],
                        ]);
                    } else {
                        $fee_generate = new SiteStudentFeeGenerate();
                        $fee_generate->academic_fee_head_id = $value['head_id'];
                        $fee_generate->user_id = $request->user_id;
                        $fee_generate->academic_version_id = $data['academic_version_id'];
                        $fee_generate->academic_shift_id = $data['academic_shift_id'];
                        $fee_generate->academic_fee_head_id = $value['head_id'];
                        $fee_generate->academic_fee_sub_head_id = $value['sub_head_id'];
                        $fee_generate->academic_fee_group_id = $value['group_id'];
                        $fee_generate->academic_year_id = $data['academic_year_id'];
                        $fee_generate->academic_section_id = $data['academic_section_id'];
                        $fee_generate->academic_class_id =  $data['academic_class_id'];
                        $fee_generate->academic_department_id = $data['academic_department_id'];
                        $fee_generate->academic_class_group_id = $data['academic_class_group_id'];
                        $fee_generate->academic_session_id = $data['academic_session_id'];
                        $fee_generate->amount = $value['amount'];
                        $fee_generate->status = $value["status"];
                        $fee_generate->save();
                    }
                } else {
                }
            }
        } else {

            //==================for all student================
            $students = new User();
            $studentList = $students->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->orderBy('student_roll_number', 'ASC')
                ->get();

            if (count($studentList) > 0) {
                foreach ($studentList as $k => $v) {
                    foreach ($accFeeDetails as $key => $value) {
                        if ($value['status'] == true) {
                            $fee_generate = new SiteStudentFeeGenerate();
                            $fee_exist = $fee_generate->where('academic_version_id', $data['academic_version_id'])
                                ->where('academic_year_id', $data['academic_year_id'])
                                ->where('academic_shift_id', $data['academic_shift_id'])
                                ->where('academic_class_id', $data['academic_class_id'])
                                ->where('academic_fee_head_id', $value['head_id'])
                                ->where('academic_fee_sub_head_id', $value['sub_head_id'])
                                ->where('academic_fee_group_id', $value['group_id'])
                                ->where('user_id', $v->id)
                                ->when($data['academic_department_id'], function ($query) use ($data) {
                                    return $query->where('academic_department_id', $data['academic_department_id']);
                                })->when($data['academic_section_id'], function ($query) use ($data) {
                                    return $query->where('academic_section_id', $data['academic_section_id']);
                                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                                })
                                ->first();
                            //
                            if ($fee_exist) {
                                $fee_exist->update([
                                    'amount' => $value['amount'],
                                    'academic_year_id' => $data['academic_year_id'],
                                ]);
                            } else {
                                $fee_generate_insert = new SiteStudentFeeGenerate();
                                $fee_generate_insert->user_id = $v->id;
                                $fee_generate_insert->academic_version_id = $data['academic_version_id'];
                                $fee_generate_insert->academic_shift_id = $data['academic_shift_id'];
                                $fee_generate_insert->academic_fee_head_id = $value['head_id'];
                                $fee_generate_insert->academic_fee_sub_head_id = $value['sub_head_id'];
                                $fee_generate_insert->academic_fee_group_id = $value['group_id'];
                                $fee_generate_insert->academic_year_id = $data['academic_year_id'];
                                $fee_generate_insert->academic_section_id = $data['academic_section_id'];
                                $fee_generate_insert->academic_class_id =  $data['academic_class_id'];
                                $fee_generate_insert->academic_department_id = $data['academic_department_id'];
                                $fee_generate_insert->academic_class_group_id = $data['academic_class_group_id'];
                                $fee_generate_insert->academic_session_id = $data['academic_session_id'];
                                $fee_generate_insert->amount = $value['amount'];
                                $fee_generate_insert->status = $value["status"];
                                $fee_generate_insert->save();
                            }
                        } else {
                        }
                    }
                }
            } else {
                return Response::json(['message' => 'sorry! student not available!'], 411);
            }
        }
        return ['message' => 'Successfully Saved'];
    }
}
