<?php

namespace App\Http\Controllers\Site;

use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSessionType;
use App\Models\Academic\AcademicShift;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Academic\SitePeriodTypeDuration;
use App\Models\Site\Employee\EmployeeAttendance;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\Attendance\GlobalStudentAbsent;
use App\Models\Site\Student\GlobalStudentHistory;

use App\Models\Student\StudentHistory;
use App\Traits\Site\Leave\Employee\LeaveFunction;
use App\Traits\SmsFunctionsTrait;
use Carbon\Carbon;
use DateTime;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteShiftDetails;
use Illuminate\Support\Facades\Session;
use Response;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;


class SiteShiftDetailsController extends Controller
{

    use SmsFunctionsTrait, LeaveFunction;

    private $siteShiftDetails;
    private $academicShift;
    private $siteInfo;
    private $sitePeriodTypeDuration;

    public function __construct(SiteShiftDetails $siteShiftDetails, AcademicShift $academicShift, SiteInfo $siteInfo,
                                SitePeriodTypeDuration $sitePeriodTypeDuration)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteShiftDetails = $siteShiftDetails;
        $this->academicShift = $academicShift;
        $this->siteInfo = $siteInfo;
        $this->sitePeriodTypeDuration = $sitePeriodTypeDuration;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Shift Details';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function shiftList()
    {

        $siteId = session()->get('SITE_ID');
        $siteInfo = $this->siteInfo->where('id', $siteId)->first();
        $siftIds = $siteInfo->shift_ids;
        $shiftId = explode(',', $siftIds) ?? [];
        $shifts = $this->academicShift->whereIn('id', $shiftId)->get();
        return $shifts;
    }


//get day list and form
    public function getDayListData(Request $request)
    {

        try {

            $belongs_to = $request->belongs_to ?? null;
            $academic_shift_id = $request->academic_shift_id ?? null;
            $academic_period_type_id = $request->academic_period_type_id ?? null;
            $site_batch_detail_id = $request->site_batch_detail_id ?? null;


            if (!$belongs_to || !$academic_shift_id || !$academic_period_type_id) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $edit_mode = false;
            $day_list = array("sat" => 'Saturday', "sun" => 'Sunday', "mon" => 'Monday', "tue" => 'Tuesday', "wed" => 'Wednesday', "thu" => 'Thursday', "fri" => 'Friday');

            if ($belongs_to == 'student') {

                $get_time_list = $this->siteShiftDetails
                    ->where('belongs_to', $belongs_to)
                    ->where('academic_shift_id', $academic_shift_id)
                    ->where('academic_period_type_id', $academic_period_type_id)
                    ->where('status', true)
                    ->when($site_batch_detail_id, function ($q) use ($site_batch_detail_id) {
                        $q->where('site_batch_detail_id', $site_batch_detail_id);
                    })
                    ->get();

              //    dd($get_time_list);

                $final = Array();
                if (count($get_time_list)) {//data exists

                    $edit_mode = true;

                    foreach ($day_list as $key => $value) {
                        $week_day_data = $get_time_list
                            ->where('belongs_to', $belongs_to)
                            ->where('academic_shift_id', $academic_shift_id)
                            ->where('academic_period_type_id', $academic_period_type_id)
                            ->where('week_day', $key)
                            /*->when($site_batch_detail_id, function ($q) use ($site_batch_detail_id) {
                                $q->where('site_batch_detail_id', $site_batch_detail_id);
                            })*/
                            ->where('status', true)
                            ->first();

                        // dd($key, $get_time_list, $week_day_data);


                        $final[$key]['day'] = $value;
                        $final[$key]['id'] = $week_day_data->id ?? 0;
                        $final[$key]['in_time_allowed_min'] = $week_day_data->in_time_allowed_min ?? 0;
                        $final[$key]['in_time'] = $week_day_data->in_time ?? Carbon::now()->format('H:i:s');
                        $final[$key]['out_time'] = $week_day_data->out_time ?? Carbon::now()->format('H:i:s');
                        $final[$key]['in_time_grace'] = $week_day_data->in_time_grace ?? '';
                        $final[$key]['out_time_grace'] = $week_day_data['out_time_grace'] ?? '';
                        $final[$key]['day_on'] = $week_day_data['day_on'] ?? false;
                        $final[$key]['att_allowed'] = $week_day_data['att_allowed'] ?? false;
                        $final[$key]['send_absent_sms'] = $week_day_data['send_absent_sms'] ?? null;
                        $final[$key]['status'] = $week_day_data['status'] ?? true;

                        /*   } else {// sat data not found
                               $final[$key]['day'] = $value;
                               $final[$key]['in_time_allowed_min'] = 0;
                               $final[$key]['in_time'] = Carbon::now()->format('H:i:s');
                               $final[$key]['out_time'] = Carbon::now()->format('H:i:s');
                               $final[$key]['in_time_grace'] = '';
                               $final[$key]['out_time_grace'] = '';
                               $final[$key]['day_on'] = false;
                               $final[$key]['att_allowed'] = false;
                               $final[$key]['send_absent_sms'] = null;
                               $final[$key]['status'] = true;
                           }*/
                    }

                } else {//not exist

                    foreach ($day_list as $key => $value) {
                        $final[$key]['day'] = $value;
                        $final[$key]['in_time_allowed_min'] = 0;
                        $final[$key]['in_time'] = '10:00';
                        $final[$key]['out_time'] = '14:00';
                        $final[$key]['in_time_grace'] = '';
                        $final[$key]['out_time_grace'] = '';
                        $final[$key]['day_on'] = true;
                        $final[$key]['att_allowed'] = false;
                        $final[$key]['send_absent_sms'] = null;
                        $final[$key]['status'] = true;
                    }
                }
            } else {//employee

                $get_time_list = $this->siteShiftDetails->where(
                    [
                        'belongs_to' => $belongs_to,
                        'academic_shift_id' => $academic_shift_id,
                        'academic_period_type_id' => $academic_period_type_id,
                        'status' => true
                    ])
                    ->get();

                $final = Array();
                if (count($get_time_list)) {//data exists

                    $edit_mode = true;

                    foreach ($day_list as $key => $value) {

                        $week_day_data = $this->siteShiftDetails
                            ->where('belongs_to', $belongs_to)
                            ->where('academic_shift_id', $academic_shift_id)
                            ->where('academic_period_type_id', $academic_period_type_id)
                            ->where('week_day', $key)
                            ->where('status', true)
                            ->first();


                        if ($week_day_data) {//sat data found
                            $final[$key]['id'] = $week_day_data->id;
                            $final[$key]['day'] = $value;
                            $final[$key]['in_time_allowed_min'] = $week_day_data->in_time_allowed_min;
                            $final[$key]['in_time'] = $week_day_data->in_time;
                            $final[$key]['out_time'] = $week_day_data->out_time;
                            $final[$key]['in_time_grace'] = $week_day_data->in_time_grace;
                            $final[$key]['out_time_grace'] = $week_day_data['out_time_grace'];
                            $final[$key]['day_on'] = $week_day_data['day_on'];
                            $final[$key]['att_allowed'] = $week_day_data['att_allowed'];
                            $final[$key]['send_absent_sms'] = $week_day_data['send_absent_sms'];

                            $final[$key]['status'] = $week_day_data['status'];

                        } else {// sat data not found
                            $final[$key]['day'] = $value;
                            $final[$key]['in_time_allowed_min'] = 0;
                            $final[$key]['in_time'] = Carbon::now()->format('H:i:s');
                            $final[$key]['out_time'] = Carbon::now()->format('H:i:s');
                            $final[$key]['in_time_grace'] = '';
                            $final[$key]['out_time_grace'] = '';
                            $final[$key]['day_on'] = false;
                            $final[$key]['att_allowed'] = false;
                            $final[$key]['send_absent_sms'] = null;

                            $final[$key]['status'] = true;
                        }
                    }

                } else {//not exist

                    foreach ($day_list as $key => $value) {
                        $final[$key]['day'] = $value;
                        $final[$key]['in_time_allowed_min'] = 0;
                        $final[$key]['in_time'] = '10:00';
                        $final[$key]['out_time'] = '14:00';
                        $final[$key]['in_time_grace'] = '';
                        $final[$key]['out_time_grace'] = '';
                        $final[$key]['day_on'] = true;
                        $final[$key]['att_allowed'] = true;
                        $final[$key]['send_absent_sms'] = null;

                        $final[$key]['status'] = true;
                    }
                }
            }


            return response()->json([$final, $edit_mode], 200, [], JSON_NUMERIC_CHECK);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);

        }
    }


    private function checkDetails($day_list)
    {
        $missing_found = false;
        foreach ($day_list as $key => $value) {

            if (!$value["in_time"] || !$value["out_time"]) {
                $missing_found = true;
                break;
            }
        }
        if ($missing_found) {
            throw  new Error('In time or Out time missing!');
        }
    }
    
    public function store(Request $request)
    {

        $this->validate($request, [
            'academic_shift_id' => 'required',
            'academic_period_type_id' => 'required',
            'belongs_to' => 'required',
        ]);

        $shift_id = $request->academic_shift_id;
        $academic_period_type_id = $request->academic_period_type_id;
        $belongs_to = $request->belongs_to;
        $day_list = $request->dayList;
        $site_batch_detail_id = $request->site_batch_detail_id;

        if (count($day_list) < 1) {
            return Response::json(['message' => 'Please get data first!'], 410);
        }

        $update_skip = [];
        $shift_not_found = [];
        $mode = '';

        if ($belongs_to == 'student') {

            $site_shift_details = $this->siteShiftDetails
                ->where('belongs_to', $belongs_to)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_period_type_id', $academic_period_type_id)
                ->where('status', true)
                ->when($site_batch_detail_id, function ($q) use ($site_batch_detail_id) {
                    $q->where('site_batch_detail_id', $site_batch_detail_id);
                })
                ->orderBy('id', 'DESC')
                ->get();

            $this->checkDetails($day_list);

            if (count($site_shift_details)) {
                foreach ($day_list as $key => $value) {
                    $siteShDet = $site_shift_details
                        ->where('belongs_to', $belongs_to)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_period_type_id', $academic_period_type_id)
                        ->where('week_day', $key)
                        ->where('status', true)
                        ->first();


                    if (!$siteShDet) {
                        $shift_not_found [] = $key;
                        continue;
                    }


                    if ($siteShDet->week_day == $key && $siteShDet->in_time != $value["in_time"]
                        || $siteShDet->out_time != $value["out_time"] || $siteShDet->in_time_grace != $value["in_time_grace"]
                        || $siteShDet->out_time_grace != $value["out_time_grace"] || $siteShDet->day_on != $value["day_on"]
                        || $siteShDet->in_time_allowed_min != $value["in_time_allowed_min"] || $siteShDet->send_absent_sms != $value["send_absent_sms"]
                    ) {

                        $siteShDet->status = false;
                        $siteShDet->save();

                        $this->siteShiftDetails = new SiteShiftDetails();
                        $this->siteShiftDetails->academic_shift_id = $shift_id;
                        $this->siteShiftDetails->academic_period_type_id = $academic_period_type_id;
                        $this->siteShiftDetails->site_batch_detail_id = $site_batch_detail_id;
                        $this->siteShiftDetails->belongs_to = $belongs_to;
                        $this->siteShiftDetails->week_day = $key;
                        $this->siteShiftDetails->in_time_allowed_min = $value["in_time_allowed_min"] ?? 0;
                        $this->siteShiftDetails->in_time = $value["in_time"];
                        $this->siteShiftDetails->out_time = $value["out_time"];
                        $this->siteShiftDetails->in_time_grace = $value["in_time_grace"];
                        $this->siteShiftDetails->out_time_grace = $value["out_time_grace"];
                        $this->siteShiftDetails->day_on = $value["day_on"];
                        $this->siteShiftDetails->att_allowed = $value["att_allowed"];
                        $this->siteShiftDetails->send_absent_sms = $value["send_absent_sms"];
                        $this->siteShiftDetails->status = $value["status"];
                        $this->siteShiftDetails->save();
                    }
                }
                $mode = 'Updated';

            } else {
                foreach ($day_list as $key => $value) {

                    $this->siteShiftDetails = new SiteShiftDetails();
                    $this->siteShiftDetails->academic_shift_id = $shift_id;
                    $this->siteShiftDetails->academic_period_type_id = $academic_period_type_id;
                    $this->siteShiftDetails->site_batch_detail_id = $site_batch_detail_id;
                    $this->siteShiftDetails->belongs_to = $belongs_to;
                    $this->siteShiftDetails->week_day = $key;
                    $this->siteShiftDetails->in_time_allowed_min = $value["in_time_allowed_min"] ?? 0;
                    $this->siteShiftDetails->in_time = $value["in_time"];
                    $this->siteShiftDetails->out_time = $value["out_time"];
                    $this->siteShiftDetails->in_time_grace = $value["in_time_grace"];
                    $this->siteShiftDetails->out_time_grace = $value["out_time_grace"];
                    $this->siteShiftDetails->day_on = $value["day_on"];
                    $this->siteShiftDetails->att_allowed = $value["att_allowed"];
                    $this->siteShiftDetails->send_absent_sms = $value["send_absent_sms"];
                    $this->siteShiftDetails->status = $value["status"];

                    $this->siteShiftDetails->save();
                }
                $mode = 'Saved';

            }

        } else {//emp

            $site_shift_details = $this->siteShiftDetails->where(
                [
                    'belongs_to' => $belongs_to,
                    'academic_shift_id' => $shift_id,
                    'academic_period_type_id' => $academic_period_type_id,
                    'status' => true
                ])->first();

            if ($site_shift_details) {
                foreach ($day_list as $key => $value) {

                    $siteShDet = $this->siteShiftDetails
                        ->where('belongs_to', $belongs_to)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_period_type_id', $academic_period_type_id)
                        ->where('week_day', $key)
                        ->where('status', true)
                        ->first();

                    if ($siteShDet->week_day == $key && $siteShDet->in_time != $value["in_time"]
                        || $siteShDet->out_time != $value["out_time"] || $siteShDet->in_time_grace != $value["in_time_grace"]
                        || $siteShDet->out_time_grace != $value["out_time_grace"] || $siteShDet->day_on != $value["day_on"]
                        || $siteShDet->in_time_allowed_min != $value["in_time_allowed_min"] || $siteShDet->send_absent_sms != $value["send_absent_sms"]
                    ) {

                        $siteShDet->status = false;
                        $siteShDet->save();

                        $this->siteShiftDetails = new SiteShiftDetails();
                        $this->siteShiftDetails->academic_shift_id = $shift_id;
                        $this->siteShiftDetails->academic_period_type_id = $academic_period_type_id;
                        $this->siteShiftDetails->belongs_to = $belongs_to;
                        $this->siteShiftDetails->week_day = $key;
                        $this->siteShiftDetails->in_time_allowed_min = $value["in_time_allowed_min"] ?? 0;
                        $this->siteShiftDetails->in_time = $value["in_time"];
                        $this->siteShiftDetails->out_time = $value["out_time"];
                        $this->siteShiftDetails->in_time_grace = $value["in_time_grace"];
                        $this->siteShiftDetails->out_time_grace = $value["out_time_grace"];
                        $this->siteShiftDetails->day_on = $value["day_on"];
                        $this->siteShiftDetails->att_allowed = $value["att_allowed"];
                        $this->siteShiftDetails->send_absent_sms = $value["send_absent_sms"];
                        $this->siteShiftDetails->status = $value["status"];
                        $this->siteShiftDetails->save();


                    } else {

                    }

                }
            } else {
                foreach ($day_list as $key => $value) {

                    $this->siteShiftDetails = new SiteShiftDetails();
                    $this->siteShiftDetails->academic_shift_id = $shift_id;
                    $this->siteShiftDetails->academic_period_type_id = $academic_period_type_id;
                    $this->siteShiftDetails->belongs_to = $belongs_to;
                    $this->siteShiftDetails->week_day = $key;
                    $this->siteShiftDetails->in_time_allowed_min = $value["in_time_allowed_min"] ?? 0;
                    $this->siteShiftDetails->in_time = $value["in_time"];
                    $this->siteShiftDetails->out_time = $value["out_time"];
                    $this->siteShiftDetails->in_time_grace = $value["in_time_grace"];
                    $this->siteShiftDetails->out_time_grace = $value["out_time_grace"];
                    $this->siteShiftDetails->day_on = $value["day_on"];
                    $this->siteShiftDetails->att_allowed = $value["att_allowed"];
                    $this->siteShiftDetails->send_absent_sms = $value["send_absent_sms"];
                    $this->siteShiftDetails->status = $value["status"];

                    $this->siteShiftDetails->save();
                }
            }
        }


        $msg = '<br/> <p style="font-size: 12px">';

        if (count($shift_not_found) > 0) {
            $msg .= 'Shift Details Not Found For ' . implode(',', $shift_not_found);
        }
        if (count($update_skip) > 0) {
            $msg .= '( Update Skipped For: ' . implode(',', $update_skip);
        }

        $msg .= '</p>';
        /*   if ($prev_att_found) {
               return Response::json(['message' => 'Successfully Updated Skipping ' . json_encode($prev_att_day)]);
           }*/
        return Response::json(['mode' => $mode, 'message' => 'Successfully ' . $mode . ' ' . $msg]);

        // return Response::json(['message' => 'Newly Saved Successfully!']);

    }


    public function update(Request $request)
    {

        $shift_id = $request->academic_shift_id;
        $academic_period_type_id = $request->academic_period_type_id;
        $site_batch_detail_id = $request->site_batch_detail_id;
        $belongs_to = $request->belongs_to;
        $day_list = $request->dayList;


        if (!$belongs_to || !$shift_id || !$academic_period_type_id) {
            return Response::json(['message' => 'Select * Marked Field!'], 410);
        }

        if (count($day_list) < 1) {
            return Response::json(['message' => 'Day list Empty!'], 410);
        }

        if ($belongs_to == 'student') {

            $site_shift = $this->siteShiftDetails
                ->where('belongs_to', $belongs_to)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_period_type_id', $academic_period_type_id)
                ->where('status', true)
                ->when($site_batch_detail_id, function ($q) use ($site_batch_detail_id) {
                    $q->where('site_batch_detail_id', $site_batch_detail_id);
                })
                ->orderBy('id', 'DESC')
                ->get();


            $update_skip = [];
            $shift_not_found = [];

            if (count($site_shift)) {
                foreach ($day_list as $key => $value) {

                    $the_site_shift = $site_shift
                        ->where('belongs_to', $belongs_to)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_period_type_id', $academic_period_type_id)
                        ->when($site_batch_detail_id, function ($q) use ($site_batch_detail_id) {
                            $q->where('site_batch_detail_id', $site_batch_detail_id);
                        })
                        ->where('week_day', $key)
                        ->where('status', true)
                        ->first();

                    if (!$the_site_shift) {
                        $shift_not_found [] = $key;
                        continue;
                    }


                    $the_site_shift->update([
                        'week_day' => $key,
                        'in_time_allowed_min' => $value["in_time_allowed_min"] ?? 0,
                        'in_time' => $value["in_time"],
                        'out_time' => $value["out_time"],
                        'in_time_grace' => $value["in_time_grace"],
                        'out_time_grace' => $value["out_time_grace"],
                        'day_on' => $value["day_on"],
                        'att_allowed' => $value["att_allowed"],
                        'send_absent_sms' => $value["send_absent_sms"],
                        'status' => $value["status"]

                    ]);


                }

                $msg = '<br/> <p style="font-size: 12px">';

                if (count($shift_not_found) > 0) {
                    $msg .= 'Shift Details Not Found For ' . implode(',', $shift_not_found);
                }
                if (count($update_skip) > 0) {
                    $msg .= '( Update Skipped For: ' . implode(',', $update_skip);
                }

                $msg .= ')</p>';
                /*   if ($prev_att_found) {
                       return Response::json(['message' => 'Successfully Updated Skipping ' . json_encode($prev_att_day)]);
                   }*/
                return Response::json(['message' => 'Successfully Updated ' . $msg]);

            } else {
                return Response::json(['message' => 'Data is not exist for this Details!'], 410);
            }

        } else {//emp

            $check_shift_detail = $this->siteShiftDetails->where(
                [
                    'belongs_to' => $belongs_to,
                    'academic_shift_id' => $shift_id,
                    'academic_period_type_id' => $academic_period_type_id
                ])
                ->first();


            if ($check_shift_detail) {

                $update_skip = [];
                $shift_not_found = [];

                foreach ($day_list as $key => $value) {

                    $siteShDet = $this->siteShiftDetails->where(
                        [
                            'belongs_to' => $belongs_to,
                            'academic_shift_id' => $shift_id,
                            'academic_period_type_id' => $academic_period_type_id,
                            'week_day' => $key,
                            'status' => true,
                        ])->orderBy('id', 'DESC')->first();


                    if (!$siteShDet) {
                        $shift_not_found [] = $key;
                        continue;
                    }

                    $emp_att = EmployeeAttendance::where('site_shift_details_id', $siteShDet->id)->first();
                    if ($emp_att) {
                        $update_skip[] = $key;
                        continue;
                    }

                    $siteShDet->update([
                        'academic_shift_id' => $shift_id,
                        'academic_period_type_id' => $academic_period_type_id,
                        'belongs_to' => $belongs_to,
                        'week_day' => $key,
                        'in_time_allowed_min' => $value["in_time_allowed_min"] ?? 0,
                        'in_time' => $value["in_time"],
                        'out_time' => $value["out_time"],
                        'in_time_grace' => $value["in_time_grace"],
                        'out_time_grace' => $value["out_time_grace"],
                        'day_on' => $value["day_on"],
                        'att_allowed' => $value["att_allowed"],
                        'send_absent_sms' => $value["send_absent_sms"],
                        'status' => $value["status"]

                    ]);
                }

                $msg = '<br/> <p style="font-size: 12px">';

                if (count($shift_not_found) > 0) {
                    $msg .= 'Shift Details Not Found For ' . implode(',', $shift_not_found);
                }
                if (count($update_skip) > 0) {
                    $msg .= '( Update Skipped For: ' . implode(',', $update_skip);
                }

                $msg .= ')</p>';

                return Response::json(['message' => 'Successfully Updated ' . $msg]);

            } else {

                return Response::json(['message' => 'No Data exist for this Details!'], 410);
            }

        }


    }


//report=============================report-----------

    public function getShiftDetailsReport($belongs_to, $academic_shift_id, $academic_period_type_id)
    {

        $day_list = array("sat" => 'Saturday', "sun" => 'Sunday', "mon" => 'Monday', "tue" => 'Tuesday', "wed" => 'Wednesday', "thu" => 'Thursday', "fri" => 'Friday');


        $report_tittle = 'Shift Details Report';
        $data = $this->siteShiftDetails->where(
            [
                'belongs_to' => $belongs_to,
                'academic_shift_id' => $academic_shift_id,
                'academic_period_type_id' => $academic_period_type_id,
                'status' => true
            ])->orderBy('id', 'ASC')
            ->get();

        $period_type = AcademicPeriodType::findOrFail($academic_period_type_id);


        $site = SiteInfo::findOrFail(Session::get('SITE_ID'));
        $belongs_to = $data[0]->belongs_to ?? 'N/A';
        $period_type_name = $period_type->type_name ?? 'N/A';

        //  view('default.admin.site.shift.shift-report', compact('report_tittle', 'data'));
        $pdf = \PDF::loadView('default.admin.site.shift.shift-report', compact('report_tittle', 'day_list', 'data', 'site', 'belongs_to', 'period_type_name'));
        return $pdf->stream(time() . '-shift-details.pdf');


    }
}
