<?php

namespace App\Http\Controllers\Site\Routine;

use App\Models\Academic\AcademicSubject;
use App\Models\Employee\SiteEmployeeDepartmentClassSubject;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Routine\SubjectWeeklyClass;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Log;
use Response;

class SubjectWeeklyClassController extends Controller
{


    private $weeklyClass;
    private $subGroupCondSetting;
    private $academicSubject;

    /**
     * @param Routine $routine
     */
    public function __construct(SubjectWeeklyClass $weeklyClass, SubjectGroupConditionSetting $subGroupCondSetting, AcademicSubject $academicSubject)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->weeklyClass = $weeklyClass;
        $this->subGroupCondSetting = $subGroupCondSetting;
        $this->academicSubject = $academicSubject;
    }


    public function getSubjectWeeklyList(Request $request)
    {
        try {

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;


            //    dd($data);


            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            $subjects = $this->academicSubject
                ->with(['subGrCondSettings' => function ($query) {
                    $query->orderBy('subject_position', 'ASC');
                }])
                ->whereHas('subGrCondSettings', function ($q) use ($data) {
                    $q->where('academic_class_id', $data['academic_class_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->when($data['academic_department_id'], function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->whereHas('academicSubjectClassExamCondition', function ($q) {
                            $q->where('name_key', 'onlyforclass')
                                ->orWhere('name_key', 'forclassandexam');
                        });
                })
                ->get()
                ->sortBy('subGrCondSettings.subject_position');

            // dd($subjects);

            $final_list = [];
            $total = 0;

            foreach ($subjects as $k => $subject) {

                $existed = $this->weeklyClass
                    ->where('academic_version_id', $data['academic_version_id'])
                    ->where('academic_shift_id', $data['academic_shift_id'])
                    ->where('academic_class_id', $data['academic_class_id'])
                    ->where('academic_department_id', $data['academic_department_id'])
                    ->where('academic_subject_id', $subject->id)
                    ->first();

                // dd($existed);

                if ($existed) {
                    $final_list[$k]['existed'] = true;
                    $final_list[$k]['id'] = $existed->id;
                    $final_list[$k]['academic_subject_id'] = $subject->id;
                    $final_list[$k]['status'] = $existed->status;
                    $final_list[$k]['subject_name'] = $subject->subject_name;
                    $final_list[$k]['no_of_weekly_class'] = $existed->no_of_weekly_class;

                    $total = ($total + $existed->no_of_weekly_class);

                } else {

                    $final_list[$k]['id'] = null;
                    $final_list[$k]['academic_subject_id'] = $subject->id;
                    $final_list[$k]['existed'] = false;
                    $final_list[$k]['status'] = true;
                    $final_list[$k]['subject_name'] = $subject->subject_name;
                    $final_list[$k]['no_of_weekly_class'] = 0;
                }
            }

            if (count($final_list) < 1) {
                throw new Error("No Subject Found! <a href='" . route('subject-group-condition-setting-view') . "' target='_blank'>Click</a>");
            }

            return response()->json([$final_list, $total], 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }


    }


    public function saveSubjectWeeklyList(Request $request)
    {

        try {


            // dd($request->academic_department_id );

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;


            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }


            $subjects = $request->subjectList;

            if (count($subjects) < 1) {
                throw new Error('Subject Not Found');
            }

            foreach ($subjects as $k => $subject) {

                if ($subject['id']) {

                    $the_weekly_class = $this->weeklyClass
                        ->where('id', $subject['id'])
                        ->first();
                    $the_weekly_class->no_of_weekly_class = $subject['no_of_weekly_class'];
                    $the_weekly_class->status = $subject['status'];
                    $the_weekly_class->save();


                } else {

                    $this->weeklyClass = new SubjectWeeklyClass();
                    $this->weeklyClass->academic_version_id = $data['academic_version_id'];
                    $this->weeklyClass->academic_shift_id = $data['academic_shift_id'];
                    $this->weeklyClass->academic_department_id = $data['academic_department_id'];
                    $this->weeklyClass->academic_class_id = $data['academic_class_id'];
                    $this->weeklyClass->no_of_weekly_class = $subject['no_of_weekly_class'];
                    $this->weeklyClass->academic_subject_id = $subject['academic_subject_id'];
                    $this->weeklyClass->status = $subject['status'];
                    $this->weeklyClass->save();
                }

            }


            return response()->json(['message' => 'Successfully Saved'], 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


    public function getSubjectWiseAssignedTeacher(Request $request)
    {

        try {

            // dd($request->academic_department_id );

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_subject_id'] = $request->academic_subject_id == 'null' ? null : $request->academic_subject_id;

            if (!$data['academic_subject_id'] || !$data['academic_class_id']) {
                return Response::json(['message' => 'Select * Marked Fields!'], 410);
            }

            $the_subject_assigned_teachers = SiteEmployeeDepartmentClassSubject::
            when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_subject_id', $data['academic_subject_id'])
                ->whereNull('release_date')
                ->pluck('user_id');

            $teacher_list = Employee::whereIn('id', $the_subject_assigned_teachers)
                ->whereHas('activeHistory')
                ->whereHas('empShifts', function ($query) use ($data) {
                    $query->where('academic_shift_id', $data['academic_shift_id']);
                    $query->whereNull('release_date');
                })
                ->with(['designation', 'latestPhoto'])
                ->select('id', 'username', 'employee_id', 'designation_id')
                ->get();
            //  dd($teacher_list);

            return response()->json([$teacher_list], 200);

        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }

    }


}
