<?php

namespace App\Http\Controllers\Site\Routine;


use App\Forms\DataHelper;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use PDF;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class RoutineReportController extends Controller
{
    use DataHelper;

    private $siteShiftClassGroupSectionSetting;
    private $routineDetail;
    private $routineAllocation;
    private $employee;


    public function __construct(Employee $employee, RoutineDetail $routineDetail, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting, RoutineAllocation $routineAllocation)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->routineDetail = $routineDetail;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->routineAllocation = $routineAllocation;
        $this->employee = $employee;
    }

    public function routineReport(Request $request)
    {

        try {

            $report_tittle = '<b>Routine Report </b><br>';

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? null : $request->academic_session_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? null : $request->academic_period_type_id;
            $data['site_batch_detail_id'] = $request->site_batch_detail_id == 'null' ? null : $request->site_batch_detail_id;


            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_class_id'] || !$data['academic_shift_id'] || !$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select * Marked Field!'], 410);
            }

            //  dd($data);

            $headingList = [];

            $getRoutineDetails = $this->routineDetail
                ->with(['routineAllocations' => function ($q) {
                    $q->where('status', 1);
                }, 'batch'])
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->where('academic_section_id', $data['academic_section_id'])
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->orderBy('start_time', 'ASC')
                ->get();


            if (count($getRoutineDetails) < 1) {
                return "No Routine Found!";
            }

            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {

                $week_array[$weekDay->weekday_name] = $getRoutineDetails->where('weekday', $weekDay->weekday_key) ?? [];

                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }

            $site = SiteInfo::findOrFail(Session::get('SITE_ID'));
            $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week


            $report_tittle2 = "";


            $report_tittle .= "<b>Year: </b>" . ($headingList[0]->academicYear->year_name ?? '');
            $report_tittle .= " <b>Shift: </b>" . ($headingList[0]->academicShift->shift_name ?? '');
            $report_tittle .= "  <b> Period Type: </b>" . ($headingList[0]->academicPeriodType->type_name ?? '');

            // $report_tittle .= "<br>";
            if ($headingList[0]->dept) {
                $report_tittle .= "<b> Dept: </b>" . $headingList[0]->dept->name;
            }

            if ($headingList[0]->academicClass) {
                $report_tittle .= "  <b> Class: </b>" . ($headingList[0]->academicClass->class_name ?? '');
            }

            if ($headingList[0]->classGroup) {
                $report_tittle .= "<b> Group: </b>" . ($headingList[0]->classGroup->group_name ?? '');
            }

            if ($headingList[0]->academicSection) {
                $report_tittle .= "<b> Section: </b>" . ($headingList[0]->academicSection->section_name ?? '');
            }

            if ($headingList[0]->academicSession) {
                $report_tittle .= "<b> Session: </b>" . ($headingList[0]->academicSession->session_name ?? '');
            }
            if ($headingList[0]->batch) {
                $report_tittle .= "<b> Batch: </b>" . ($headingList[0]->batch->batch_name ?? '');
            }


            $br_col[] = -1;


            //   dd($max_col_count);


            //return view('default.site.routine.report.routine-report', compact('week_array', 'headingList', 'max_col_count', 'site', 'report_tittle','br_col'));
            $pdf = PDF::loadView('default.site.routine.report.routine-report', compact('week_array', 'headingList', 'max_col_count', 'site', 'report_tittle', 'br_col', 'report_tittle2'));

            return $pdf->stream(time() . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


    public function shiftWiseWeekdayReport(Request $request)
    {

        try {
            ini_set('memory_limit', '-1');

            $report_tittle = '<b>Shift Wise Routine Report</b><br>';

            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id == 'null' ? 0 : $request->academic_period_type_id;

            if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_period_type_id']) {
                return Response::json(['message' => 'Select Version || Year || Shift || Period Type!'], 410);
            }


            $get_routine_details = $this->routineDetail
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->where('is_break', 0)
                ->where('status', true)
                ->orderBy('id', 'ASC')
                ->get();

            if (count($get_routine_details) < 1) {
                return "No Routine Found!";
            }


            $employees = $this->employee
                ->whereHas('empShifts', function ($q) use ($data) {
                    $q->where('academic_shift_id', $data['academic_shift_id']);

                })->select('id', 'username', 'employee_serial')
                ->orderBy('employee_serial', 'ASC')
                // ->where('username', 'e190090006')
                ->select('id')
                ->get();


            $lists = [];

            foreach ($employees as $k => $employee) {

                $lists[$k]['emp'] = $employee;
                $sl = 0;
                $total = 0;

                foreach ($this->getWeekDay() as $k1 => $weekDay) {

                    $emp_routine = $this->routineDetail
                        ->where('academic_version_id', $data['academic_version_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('academic_shift_id', $data['academic_shift_id'])
                        ->where('academic_period_type_id', $data['academic_period_type_id'])
                        ->where('weekday', $weekDay->weekday_key)
                        ->where('is_break', 0)
                        ->whereHas('routineAllocations', function ($q) use ($employee) {
                            $q->where('employee_id', $employee->id)
                                ->where('status', 1);
                        })
                        ->with(['routineAllocations' => function ($q) use ($employee) {
                            $q->where('employee_id', $employee->id)
                                ->where('status', 1);
                        }])
                        ->orderBy('start_time', 'ASC')
                        ->where('status', true)
                        ->get();

                    $emp_routine1 = (new RoutineDetail())
                        ->where('academic_version_id', $data['academic_version_id'])
                        ->where('academic_year_id', $data['academic_year_id'])
                        ->where('academic_shift_id', $data['academic_shift_id'])
                        ->where('academic_period_type_id', $data['academic_period_type_id'])
                        ->where('weekday', $weekDay->weekday_key)
                        ->where('is_break', 0)
                        ->whereHas('routineAllocations', function ($q) use ($employee) {
                            $q->where('employee_id', $employee->id)
                                ->where('status', 1);
                        })
                        ->with(['routineAllocations' => function ($q) use ($employee) {
                            $q->where('employee_id', $employee->id)
                                ->where('status', 1);
                        }])
                        ->orderBy('start_time', 'ASC')
                        ->where('status', true)
                        ->groupBy(['start_time', 'end_time'])
                        ->get();


                    $total = ($total + count($emp_routine1));
                    $lists[$k][$weekDay->weekday_key]['slot'] = $emp_routine;
                    $sl++;
                }
                $lists[$k]['total'] = $total;
            }

            // dd($lists);

            $headingList = [];

            foreach ($this->getWeekDay() as $k1 => $weekDay) {
                $headingList[$weekDay->weekday_key] = $weekDay->weekday_name;
            }

            $report_tittle2 = "";
            $report_tittle .= "<b>Version: </b>" . ($get_routine_details[0]->version->version_name ?? '');
            $report_tittle .= "<b>Year: </b>" . ($get_routine_details[0]->year->year_name ?? '');
            $report_tittle .= " <b>Shift: </b>" . ($get_routine_details[0]->academicShift->shift_name ?? '');
            $report_tittle .= "  <b> Period Type: </b>" . ($get_routine_details[0]->academicPeriodType->type_name ?? '');


            // $report_tittle .= "<br>";
            //  dd('dddd');
            //   dd($max_col_count);


            //  return view('default.site.routine.report.shift-and-teacher-wise-routine-report', compact('week_array', 'headingList', 'max_col_count', 'site', 'report_tittle','br_col'));
            $pdf = PDF::loadView('default.site.routine.report.shift-and-teacher-wise-routine-report', compact('headingList', 'lists', 'report_tittle', 'report_tittle2'));
            return $pdf->stream(time() . '-routine.pdf');


        } catch (Exception $exception) {
            return $exception->getMessage();
        }
    }


}
