<?php

namespace App\Http\Controllers\Site\Routine;


use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\RoutineDetail;
use App\Models\Site\Routine\RoutineSwapCancel;
use App\Models\Site\Routine\SiteRoutineDetail;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use App\Traits\Site\Routine\RoutineFunction;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Log;
use Response;
use Session;

class RoutineAllocationController extends Controller
{
    use RoutineFunction;

    private $routineDetail;
    private $siteRoutineDetail;
    private $routineAllocation;
    private $siteShiftClassGroupSectionSetting;
    private $swapCancel;


    public function __construct(RoutineDetail $routineDetail, SiteRoutineDetail $siteRoutineDetail, RoutineAllocation $routineAllocation, SiteShiftClassGroupSectionSetting $siteShiftClassGroupSectionSetting, RoutineSwapCancel $swapCancel)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->routineDetail = $routineDetail;
        $this->siteRoutineDetail = $siteRoutineDetail;
        $this->routineAllocation = $routineAllocation;
        $this->siteShiftClassGroupSectionSetting = $siteShiftClassGroupSectionSetting;
        $this->swapCancel = $swapCancel;

    }

    public function allocateEmployeeSubjectRoom(Request $request)
    {

        try {


            $data = [];
            $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
            $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
            $data['academic_department_id'] = $request->academic_department_id == 'null' ? null : $request->academic_department_id;
            $data['academic_class_id'] = $request->academic_class_id == 'null' ? null : $request->academic_class_id;
            $data['academic_section_id'] = $request->academic_section_id == 'null' ? null : $request->academic_section_id;
            $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;
            $data['academic_class_group_id'] = $request->academic_class_group_id == 'null' ? null : $request->academic_class_group_id;
            $data['academic_period_type_id'] = $request->academic_period_type_id;
            $data['academic_session_id'] = $request->academic_session_id == 'null' ? 0 : $request->academic_session_id;


            $slot_ids = $request->slotIds ?? [];
            $subject_id = $request->subject_id;
            $room_id = $request->room_id;
            $employee_id = $request->employee_id;

            //dd($data);

            if (count($slot_ids) <= 0) {
                return Response::json(['message' => 'Please Select At Least One Slot!'], 422);
            }
            if (!$subject_id) {
                return Response::json(['message' => 'Please Select Subject!'], 422);
            }
            $unique_slot_ids = array_unique($slot_ids);
            $total = 0;
            $duplicate_details = [];
            $inserted_slot_ids = [];

            //slot loop starts------------------


            foreach ($unique_slot_ids as $s_k => $slot_id) {
                $the_routine_detail = $this->routineDetail->where('id', $slot_id)->first();

                //dd($the_routine_detail);

                if ($the_routine_detail) {

                    $will_insert = true;
                    $start_time = $the_routine_detail->start_time;
                    $end_time = $the_routine_detail->end_time;
                    $week_day = $the_routine_detail->weekday;
                    $week_day_name = $the_routine_detail->weekDay->weekday_name;
                    $start_time_plus = date('H:i:s', strtotime('+1 minutes', strtotime($start_time)));
                    $end_time_less = date('H:i:s', strtotime('-1 minutes', strtotime($end_time)));


                    $time_matched_list = $this->siteRoutineDetail
                        ->with(['routineAllocations' => function ($q) {
                            $q->where('status', 1);
                        }])
                        ->where('status', true)
                        ->where('is_break', false)
                        ->where('weekday', $week_day)
                        ->where(function ($query) use ($start_time_plus, $end_time_less) {
                            $query->where('start_time', '<=', $start_time_plus)
                                ->where('end_time', '>=', $start_time_plus)
                                ->orWhere(function ($query1) use ($end_time_less) {
                                    $query1->where('start_time', '<=', $end_time_less);
                                    $query1->where('end_time', '>=', $end_time_less);
                                });
                        })
                        ->get();

                    if (count($time_matched_list) > 0) {
                        foreach ($time_matched_list as $detail_k => $detail_val) {
                            $allocations = $detail_val->routineAllocations;

                            foreach ($allocations as $all_k => $allocation) {

                                $the_allocation = $this->routineAllocation->where('id', $allocation->id)->first();

                                if ($employee_id && $allocation->employee_id == $employee_id) {//check emp

                                    $weekly_class = ($the_allocation->employee->weekly_class ?? 0);
                                    $data = [];
                                    $data['employee_id'] = $employee_id;
                                    $allocated_class = $this->getTotalUniqueAllocatedPeriodToTheTeacher($data);

                                    $duplicate_details[$s_k]['img'] = false;
                                    $duplicate_details[$s_k]['slot_id'] = $slot_id;
                                    $duplicate_details[$s_k]['weekday'] = $week_day_name;
                                    $duplicate_details[$s_k]['start_time'] = $start_time;
                                    $duplicate_details[$s_k]['end_time'] = $end_time;
                                    $duplicate_details[$s_k]['emp_duplicates'][] = '<b>' . ($the_allocation->employee->full_name ?? '') . "(" . ($the_allocation->employee->username ?? "") . ')</b>' .
                                        ' has another schedule with <b>' . ($the_allocation->siteRoutineDetail->academicYear->year_name ?? "") . '</b> ' .
                                        ($the_allocation->siteRoutineDetail->academicShift->shift_name ?? "") .

                                        ' </b>' . ($the_allocation->siteRoutineDetail->academicClass->class_name ?? "") .
                                        '<b> ' . ($the_allocation->siteRoutineDetail->academicSection->section_name ?? "") . ' </b>' . ' for ' .
                                        '<b> ' . ($the_allocation->siteRoutineDetail->classGroup->group_name ?? "") . ' </b>' . ' for '
                                        . ($the_allocation->subject->subject_name ?? "") .
                                        '<b> (' . ($the_allocation->siteRoutineDetail->start_time ?? "") . " - " . ($the_allocation->siteRoutineDetail->end_time ?? "") . ') </b>)' . ' on ' . $the_allocation->siteRoutineDetail->weekday . '.' .
                                        '<br> <b>Weekly Class:</b> ' . $weekly_class . " <b>Allocated: </b>" . $allocated_class;

                                    $duplicate_details[$s_k]['dup_allocation_ids'][] = $the_allocation->id;

                                    $will_insert = false;
                                    // break;
                                }

                                if ($room_id && $allocation->room_id == $room_id) {
                                    $duplicate_details[$s_k]['img'] = false;
                                    $duplicate_details[$s_k]['slot_id'] = $slot_id;
                                    $duplicate_details[$s_k]['weekday'] = $week_day_name;
                                    $duplicate_details[$s_k]['start_time'] = $start_time;
                                    $duplicate_details[$s_k]['end_time'] = $end_time;

                                    $duplicate_details[$s_k]['room_duplicates'][] = '<b>' . $the_allocation->room->room_name_ex . '</b>' .
                                        ' has another schedule with Class:-' . $the_allocation->siteRoutineDetail->academicClass->class_name .
                                        ' (' . ($the_allocation->siteRoutineDetail->academicSection->section_name ?? "") . ' )' .
                                        ' for Subject:- ' . $the_allocation->subject->subject_name .
                                        '<b> (' . ($the_allocation->siteRoutineDetail->classTimingDetail->start_time ?? "") . " - " . ($the_allocation->siteRoutineDetail->classTimingDetail->end_time ?? "") . ') </b>)';
                                    $duplicate_details[$s_k]['dup_allocation_ids'][] = $the_allocation->id;

                                    $will_insert = false;

                                }
                            }
                        }

                        if ($will_insert) {
                            $inserted_slot_ids[] = $slot_id;
                            $r_allocation = new RoutineAllocation();
                            $r_allocation->routine_details_id = $slot_id;
                            $r_allocation->subject_id = $subject_id;
                            $r_allocation->employee_id = $employee_id;
                            $r_allocation->room_id = $room_id;
                            $r_allocation->save();
                            $total += 1;
                        }
                    }
                } else {

                    $issue = new  IssueDetail();
                    $issue->issue_type = 'routine';
                    $issue->issuer_type = 'site';
                    $issue->issue_details = $slot_id . " not existed (Allocation Routine Manually)!";
                    $issue->site_id = Session::get('SITE_ID');
                    $issue->save();
                }
            }

            if (count($duplicate_details) > 0) {
                return JsonResponse::create(['message' => $total . ' details allocated ', 'total' => count($duplicate_details), 'duplicate_details' => $duplicate_details], 413);
            }
            return JsonResponse::create(['message' => $total . ' Details Allocated Successfully'], 200);
        } catch (Exception $exception) {
            throw  new Error($exception->getMessage());
        }
    }

    public function updateAllocations(Request $request)
    {
        try {
            Log::info($request);

            $allocation_id = $request->allocation_id;
            $subject_id = $request->subject_id;
            $room_id = $request->room_id;
            $employee_id = $request->employee_id;
            $status = $request->status;

            if (!$allocation_id) {
                return Response::json(['message' => 'Please Select slot!'], 422);
            }
            if (!$subject_id) {
                return Response::json(['message' => 'Please Select Subject!'], 422);
            }

            $the_allocation1 = $this->routineAllocation->findOrFail($allocation_id);

            $message = '';

            if ($the_allocation1->status != $status) {
                $the_allocation1->status = $status;
                $the_allocation1->save();
                $message = ' But status changed';

            }


            $total_class_existed = $the_allocation1->attendances()->count();

            if ($total_class_existed) {
                return Response::json(['message' => 'Sorry, the routine has ' . $total_class_existed . ' periodic attendance existed. '.$message], 412);
            }


            $will_insert = true;
            $start_time = $the_allocation1->routineDetail->start_time;
            $end_time = $the_allocation1->routineDetail->end_time;
            $week_day = $the_allocation1->routineDetail->weekday;
            $week_day_name = $the_allocation1->routineDetail->weekDay->weekday_name;
            $start_time_plus = date('H:i:s', strtotime('+1 minutes', strtotime($start_time)));
            $end_time_less = date('H:i:s', strtotime('-1 minutes', strtotime($end_time)));
            $slot_id = $the_allocation1->routineDetail->id;

            $time_matched_list = $this->siteRoutineDetail
                ->with(['routineAllocations' => function ($q) {
                    $q->where('status', 1);
                }])
                ->where('status', true)
                ->where('id', '!=', $slot_id)
                ->where('is_break', false)
                ->where('weekday', $week_day)
                ->where(function ($query) use ($start_time_plus, $end_time_less) {
                    $query->where('start_time', '<=', $start_time_plus)
                        ->where('end_time', '>=', $start_time_plus)
                        ->orWhere(function ($query1) use ($end_time_less) {
                            $query1->where('start_time', '<=', $end_time_less);
                            $query1->where('end_time', '>=', $end_time_less);
                        });
                })
                ->get();

            $s_k = 0;
            $duplicate_details = [];

            if (count($time_matched_list) > 0) {
                foreach ($time_matched_list as $detail_k => $detail_val) {
                    $allocations = $detail_val->routineAllocations;

                    foreach ($allocations as $all_k => $allocation) {

                        $the_allocation = $this->routineAllocation->where('id', $allocation->id)->first();

                        if ($employee_id && $allocation->employee_id == $employee_id) {//check emp

                            $weekly_class = ($the_allocation->employee->weekly_class ?? 0);
                            $data = [];
                            $data['employee_id'] = $employee_id;
                            $allocated_class = $this->getTotalUniqueAllocatedPeriodToTheTeacher($data);

                            $duplicate_details[$s_k]['img'] = false;
                            $duplicate_details[$s_k]['slot_id'] = $slot_id;
                            $duplicate_details[$s_k]['weekday'] = $week_day_name;
                            $duplicate_details[$s_k]['start_time'] = $start_time;
                            $duplicate_details[$s_k]['end_time'] = $end_time;
                            $duplicate_details[$s_k]['emp_duplicates'][] = '<b>' . ($the_allocation->employee->full_name ?? '') . "(" . ($the_allocation->employee->username ?? "") . ')</b>' .
                                ' has another schedule with <b>' . ($the_allocation->siteRoutineDetail->academicYear->year_name ?? "") . '</b> ' .
                                ($the_allocation->siteRoutineDetail->academicShift->shift_name ?? "") .

                                ' </b>' . ($the_allocation->siteRoutineDetail->academicClass->class_name ?? "") .
                                '<b> ' . ($the_allocation->siteRoutineDetail->academicSection->section_name ?? "") . ' </b>' . ' for ' .
                                '<b> ' . ($the_allocation->siteRoutineDetail->classGroup->group_name ?? "") . ' </b>' . ' for '
                                . ($the_allocation->subject->subject_name ?? "") .
                                '<b> (' . ($the_allocation->siteRoutineDetail->start_time ?? "") . " - " . ($the_allocation->siteRoutineDetail->end_time ?? "") . ') </b>)' . ' on ' . $the_allocation->siteRoutineDetail->weekday . '.' .
                                '<br> <b>Weekly Class:</b> ' . $weekly_class . " <b>Allocated: </b>" . $allocated_class;

                            $duplicate_details[$s_k]['dup_allocation_ids'][] = $the_allocation->id;

                            $will_insert = false;
                            // break;
                        }

                        if ($room_id && $allocation->room_id == $room_id) {
                            $duplicate_details[$s_k]['img'] = false;
                            $duplicate_details[$s_k]['slot_id'] = $slot_id;
                            $duplicate_details[$s_k]['weekday'] = $week_day_name;
                            $duplicate_details[$s_k]['start_time'] = $start_time;
                            $duplicate_details[$s_k]['end_time'] = $end_time;

                            $duplicate_details[$s_k]['room_duplicates'][] = '<b>' . $the_allocation->room->room_name_ex . '</b>' .
                                ' has another schedule with Class:-' . $the_allocation->siteRoutineDetail->academicClass->class_name .
                                ' (' . ($the_allocation->siteRoutineDetail->academicSection->section_name ?? "") . ' )' .
                                ' for Subject:- ' . $the_allocation->subject->subject_name .
                                '<b> (' . ($the_allocation->siteRoutineDetail->classTimingDetail->start_time ?? "") . " - " . ($the_allocation->siteRoutineDetail->classTimingDetail->end_time ?? "") . ') </b>)';
                            $duplicate_details[$s_k]['dup_allocation_ids'][] = $the_allocation->id;

                            $will_insert = false;

                        }
                    }
                }
            }

            if ($will_insert) {
                $the_allocation1->subject_id = $subject_id;
                $the_allocation1->employee_id = $employee_id;
                $the_allocation1->room_id = $room_id;
                $the_allocation1->save();
            }

            if (count($duplicate_details) > 0) {
                return JsonResponse::create(['message' => 'The teacher has ' . count($duplicate_details) . ' duplicate class', 'duplicate_details' => $duplicate_details], 413);
            }


            return Response::json(['mode' => 'Updated', 'message' => 'Allocation updated successfully!'], 200);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);
        }

    }


    public function assignAndRemove(Request $request)
    {
        try {


            $slot_id = $request->slot_id;
            $dup_allocation_ids = $request->dup_allocation_ids;
            $subject_id = $request->subject_id;
            $room_id = $request->room_id;
            $employee_id = $request->employee_id;


            if (!$subject_id) {
                return Response::json(['message' => 'Please Select Subject!'], 422);
            }


            if (count($dup_allocation_ids) > 0) {

                $total_class_existed = $this->routineAllocation->whereIn('id', $dup_allocation_ids)
                    ->has('attendances')
                    ->count();
                if ($total_class_existed) {
                    return Response::json(['message' => 'Can"t remove, the routine has ' . $total_class_existed . ' periodic attendance existed!'], 412);
                }


                $this->routineAllocation->whereIn('id', $dup_allocation_ids)->delete();

                $r_allocation = new RoutineAllocation();
                $r_allocation->routine_details_id = $slot_id;
                $r_allocation->subject_id = $subject_id;
                $r_allocation->employee_id = $employee_id;
                $r_allocation->room_id = $room_id;
                $r_allocation->save();

                return Response::json(['message' => 'Removed Duplicate And Allocated Successfully!'], 200);

            }

            return Response::json(['message' => 'Something went wrong!'], 410);


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);
        }

    }


    public function assignAndRetain(Request $request)
    {
        try {

            $slot_id = $request->slot_id;
            $subject_id = $request->subject_id;
            $room_id = $request->room_id;
            $employee_id = $request->employee_id;


            if (!$subject_id) {
                return Response::json(['message' => 'Please Select Subject!'], 422);
            }
            if (!$employee_id) {
                return Response::json(['message' => 'Please Select Subject!'], 422);
            }

            //    throw new Error($slot_id);

            if ($slot_id) {

                $r_allocation = new RoutineAllocation();
                $r_allocation->routine_details_id = $slot_id;
                $r_allocation->subject_id = $subject_id;
                $r_allocation->employee_id = $employee_id;
                $r_allocation->room_id = $room_id;
                $r_allocation->save();


                return Response::json(['message' => 'Assigned And Retain Successfully!'], 200);

            }


        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);
        }

    }


    public function deleteAllocation($allocation_id)
    {
        try {

            $the_allocation = $this->routineAllocation->find($allocation_id);


            $total_class_existed = $the_allocation->attendances()->count();
            if ($total_class_existed) {
                return Response::json(['message' => 'Sorry, the routine has ' . $total_class_existed . ' periodic attendance existed!'], 412);
            }


            $this->swapCancel->where('allocation_id', $allocation_id)->delete();

            $the_allocation->delete();

            return Response::json(['message' => ' Details Deleted Successfully'], 200);
        } catch (ModelNotFoundException $exception) {
            return Response::json(['message' => 'The Allocation Not Exists'], 411);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 411);

        }

    }


}





















