<?php

namespace App\Http\Controllers\Site\Retirement;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Employee\Employee;
use Carbon\Carbon;
use Exception;

class SiteEmployeeRetirementController extends Controller
{

    private $Employees;
    public function __construct(Employee $Employee)
    {
        $this->Employees = $Employee;
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }
    public function index()
    {
        $viewType = 'Employee Retirement List';
        return view('default.admin.layouts.master', compact('viewType'));
    }
    public function siteGetYearMonthlist()
    {
        $SiteInfoTableData = SiteInfoSetting::first();
        $academicYear = explode(',', $SiteInfoTableData->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('id', 'desc')->get();


        $months = [
            1 => 'January',
            2 => 'February',
            3 => 'March', 4 => 'April', 5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August', 9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
        ];


        return response()->json([
            'siteGroupYear' => $academicYearList,
            'months' => $months,
        ], 200);
    }

    public function siteGetEmployeeRetirementList(Request $request)
    {

        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $month = $request->selectedMonthIndex;
        $year = $request->academic_year;

        $txt = '%' . $search_txt . '%';

        // Create a new array with employees and the date they turn 60 years old
        $employeesTurningSixty = [];
        $DateOfBirthNotFound   = 0;
        $key = 0;



        $Employees = $this->Employees
            ->select('id', 'username', 'designation_id', 'contact_number', 'date_of_birth')
            ->with(['designation'])
            ->where('status', true)
            ->orderBy('employee_serial', 'ASC')
            ->get();




        foreach ($Employees as $index => $employee) {

            if (!empty($employee['date_of_birth'])) {
                $dateOfBirth = Carbon::parse($employee['date_of_birth']);
                $dateWhenSixty = $dateOfBirth->copy()->addYears(60);

                $employeesTurningSixty[$key]['full_name']        = $employee->full_name;
                $employeesTurningSixty[$key]['contact_number']   = $employee->contact_number;
                $employeesTurningSixty[$key]['designation_name'] = isset($employee['designation'])  ? $employee['designation']['name'] : null;
                $employeesTurningSixty[$key]['date_when_sixty']  = $dateWhenSixty->format('d F Y');
                $employeesTurningSixty[$key]['date_of_birth']    =  $dateOfBirth->format('d F Y');

                $key++;
            } else {
                $DateOfBirthNotFound++;
            }
        }


        $filteredEmployees = array_filter($employeesTurningSixty, function ($employee) use ($year, $month) {
            $dateWhenSixty = Carbon::parse($employee['date_when_sixty']);
            if ($year && $month) {
                return $dateWhenSixty->year == $year && $dateWhenSixty->month == $month;
            } elseif ($year) {
                return $dateWhenSixty->year == $year;
            } else {
                return $employee;
            }
        });

        return response()->json([
            'filteredEmployees'   => $filteredEmployees,
            'DateOfBirthNotFound' => $DateOfBirthNotFound != 0 ? $DateOfBirthNotFound : null,
        ],200);
    }

}
