<?php

namespace App\Http\Controllers\Site\Result;


use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;

use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteIndividualSubjectResultStore;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use Response;
use Session;
use App\Models\Academic\AcademicSubjectClassExamCondition;

class SiteBaseResultGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Site Result Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.result.site-base-result-generate', compact('viewType'));
    }



    public function getSiteBaseResultTypeListForResultGenerate(Request $request){

        $data = $request->all();
       
        $resultSettingList = SiteResultPrimarySetting::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();
//            ->distinct('academic_result_primary_type_id')
//            ->pluck('academic_result_primary_type_id');

        
        $resultSettingListIds=$resultSettingList->pluck('academic_result_primary_type_id')->unique()->filter();

        $siteExamDeclares=SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

         //  return $resultSettingListIds; 

        $academic_result_primary_type_id_array=[];
        foreach ($resultSettingListIds as $key => $value){

            $ExaminationFromSetting=$resultSettingList->where('academic_result_primary_type_id', $value);
            $ExaminationIDsFromSetting=$ExaminationFromSetting->pluck('examination_id')->unique();
            $countExaminationFromSetting=count($ExaminationIDsFromSetting);

            $ExaminationFromExamDeclare=$siteExamDeclares->whereIn('examination_id', $ExaminationIDsFromSetting);
            $ExaminationIDsFromExamDeclare=$ExaminationFromExamDeclare->pluck('examination_id')->unique();
            $countExaminationFromExamDeclare=count($ExaminationIDsFromExamDeclare);

            if($countExaminationFromSetting==$countExaminationFromExamDeclare){
                $academic_result_primary_type_id_array[]=$value;
            }

        }

        $resultlist_test=AcademicResultPrimaryType::whereIn('id', $academic_result_primary_type_id_array)->get();

        $test_arr=Array();
        $resultlist=[];
        foreach ($resultlist_test as $key => $value){

            $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
//                ->where('status', true)
                ->pluck('id');


            $check_result_present=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->pluck('id');



            if(count($check_result_present)>0){
                $test_arr['result_generate_status']=true;
            }
            else{
                $test_arr['result_generate_status']=false;
            }


            $check_result__publish_emp_panel=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_employee_publish_status', true)
                ->first();

            $check_result_publish_std_panel=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_student_publish_status', true)
                ->first();

            if($check_result__publish_emp_panel){
                $test_arr['result_employee_publish_status']=true;
            }else{
                $test_arr['result_employee_publish_status']=false;
            }


            if($check_result_publish_std_panel){
                $test_arr['result_student_publish_status']=true;
            }else{
                $test_arr['result_student_publish_status']=false;
            }



            $test_arr['loading_result_generate_image']=false;

            $resultlist[$key]=array_merge($test_arr, $value->toArray());
        }
        return $resultlist;

    }



    public function createUpdateResultListForResultGenerate(Request $request){


        $data = $request->all();

        $resultSettingList = SiteResultPrimarySetting::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->orderBy('show_position', 'asc')
            ->get(['id', 'academic_result_primary_type_id', 'examination_id', 'marks_percentage', 'show_position']);


          //  dd($resultSettingList);

        $resultSettingListIds=$resultSettingList
            ->pluck('examination_id');


        $examDeclareList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('examination_id', $resultSettingListIds)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();




        $subject_condition_setting=SubjectGroupConditionSetting::with(['academicSubjectClassExamCondition',
            'examDependentAcademicSubject', 'siteSubjectExaminationMark'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $showTableBellowSubjectIDs=$subject_condition_setting->where('result_show_in_table_bellow', true)
            ->pluck('id')->unique();
        $OtherSubjectIDs=$subject_condition_setting->where('result_show_in_table_bellow', false)
            ->pluck('id')->unique();

//        $examinationlist=Examination::whereIn('id', $resultSettingList)->get();

        $examDeclareListIDs=$examDeclareList->pluck('id');

        $studentMarksListAll=SiteExamDeclareStudentSubject::with(['examination'=>function($query){
            $query->get(['id', 'examination_name']);

        }, 'academicExamType'=>function($query){
            $query->get(['id', 'marks_type']);
        }])
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
//            ->where('student_history_id', 870)
            ->get(['id', 'site_exam_declare_id', 'site_exam_declare_student_id', 'student_history_id',
                'examination_id', 'academic_exam_type_id', 'site_subject_group_condition_setting_id',
            'obtaine_marks', 'pass_mark', 'subject_exam_type_mark', 'exam_held_status', 'exam_attendance_status']);


        $studentIdsList=$studentMarksListAll->pluck('student_history_id')->unique()->filter()->values();

//        Log::info($request->select_student_history_ids);

        $generateStudentRest=array_diff($studentIdsList->toArray(), $request->select_student_history_ids);

        if(count($generateStudentRest)>0){
            $tenStudentIDs=collect($generateStudentRest)->take(20);
        }else{
            $tenStudentIDs=[];
        }

        $generatedStudentIDs=array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);

        $studentMarksList=$studentMarksListAll->whereIn('student_history_id', $tenStudentIDs);

        $classAllStudentlist=StudentHistory::whereIn('id', $studentIdsList)
            ->pluck('id');

//        $generatedStudentlist=StudentHistory::with(['student'=>function($query){
//            $query->select('id');
//        }])
//            ->whereIn('id', $generatedStudentIDs)
//            ->orderBy('student_roll_number', 'desc')
//            ->get(['id', 'user_id']);

//        return $generatedStudentlist;


        $showTableBellowSubjectExamList=SiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
            ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->get(['examination_id', 'academic_exam_type_id']);


        $OtherSubjectExamList=SiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
            ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->get(['examination_id', 'academic_exam_type_id']);

        $filter_for_examination_ids=Examination::whereIn('id', $studentMarksList->pluck('examination_id')
            ->unique()
            ->filter())
            ->get(['id', 'examination_name', 'name_key']);

        $exam_type_arr=Array();
        $exam_type_array=[];
        foreach ($filter_for_examination_ids as $key => $value) {

//            $resultSettingPercentage=$resultSettingList->where('examination_id', $value->id)->first();
//            if($resultSettingPercentage){
//
//            }

            $get_postions=$resultSettingList->where('examination_id', $value->id)->first();

//return $get_postions->marks_percentage;

            $exam_type_ids=$studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();
            $exam_type_ids_for_table_bellow=$studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();


            $exam_type_list=AcademicExamType::whereIn('id', $exam_type_ids)->get(['id', 'marks_type','head_key']);
            $exam_type_list_for_table_bellow=AcademicExamType::whereIn('id', $exam_type_ids_for_table_bellow)->get(['id', 'marks_type']);

            $exam_type_arr['academic_exam_type_list']=$exam_type_list;
            $exam_type_arr['academic_exam_type_list_for_table_bellow']=$exam_type_list_for_table_bellow;
            $exam_type_arr['table_bellow_status']=count($exam_type_list_for_table_bellow)>0?1:0;
            $exam_type_arr['obtain_marks']='Obt';
            $exam_type_arr['academic_exam_type_count']=count($exam_type_list);
            $exam_type_arr['exam_type_list_for_table_bellow_count']=count($exam_type_list_for_table_bellow);
            $exam_type_arr['show_position']=$get_postions->show_position;
            $exam_type_arr['marks_percentage']=$get_postions->marks_percentage ?? 0;

            $exam_type_array[$key]=array_merge($exam_type_arr, $value->toArray());

        }


        $exam_type_array_with_sort=array_values(array_sort(collect($exam_type_array), function ($value) {
            return $value['show_position'];
        }));


        $grade_list=SiteResultSystemSetting::with(['academicResultSystem'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
//            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();



        $getStudentOptionalSubject=StudentHistory::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
//            ->where('status', true)
            ->where('transfer_status', false)
            ->get(['id', 'user_id', 'optional_subject_ids']);

        $academic_result_primary_type_id=$request->academic_result_primary_type_id;


        $student_indivisual_subject_list= $this->studentMarkslist($studentMarksList,
            $grade_list, $subject_condition_setting, $resultSettingList, $getStudentOptionalSubject,
            $academic_result_primary_type_id, $showTableBellowSubjectExamList, $OtherSubjectExamList);


        $student_ids=collect($student_indivisual_subject_list)->pluck('student_history_id');

       $getSiteStudentPrimaryResultDetail= SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->where('status', true)
            ->get();

        foreach ($student_indivisual_subject_list as $key => $value){
           
            $checkStudentResult=$getSiteStudentPrimaryResultDetail->where('student_history_id', $value['student_history_id'])
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)->first();
  
                if($checkStudentResult){
                $checkStudentResult->update([

                    'gpa'=>$value['final_point'],
                    'grade'=>$value['final_grade'],
                    'fail_subject_count'=>$value['fail_subject_count'],


                    'optional_subject_ids'=>$value['optional_subject_ids'],
                    'final_point_without_optional'=>$value['final_point_without_optional'],
                    'final_grade_without_optional'=>$value['final_grade_without_optional'],
                    'combine_subject_present'=>$value['combine_subject_present'],
                    'classtest_is_present'=>$value['classtest_is_present'],
                    'exam_attendance_status'=>$value['exam_attendance_status'],


                    'sum_of_obtain_raw_total_marks'=>ceil($value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks'=>ceil($value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks'=>ceil($value['sum_of_raw_total_marks']),
                    'raw_obtain_marks_percentage'=>$value['sum_of_obtain_raw_total_marks']*100/
                        ($value['sum_of_raw_total_marks']?$value['sum_of_raw_total_marks']:1),



                    'sum_of_obtain_raw_total_marks_only_passed_subject'=>ceil($value['sum_of_obtain_raw_total_marks_only_passed_subject']),
                    'pass_subject_base_marks_percentage'=>$value['pass_subject_base_marks_percentage'],
                    'total_marks_base_percentage'=>$value['total_marks_base_percentage'],
                    'pass_subject_base_marks_grade'=>$value['pass_subject_base_marks_grade'],
                    'total_marks_base_grade'=>$value['total_marks_base_grade'],
                    'pass_subject_base_marks_point'=>$value['pass_subject_base_marks_point'],
                    'total_marks_base_point'=>$value['total_marks_base_point'],

                    'sum_of_obtain_total_marks_for_show'=>$value['sum_of_obtain_total_marks_for_show'],
                    'sum_of_obtain_total_percent_for_show'=>$value['sum_of_obtain_total_percent_for_show'],


                    'table_header'=>json_encode($exam_type_array_with_sort),
                    'site_individual_combine_subject_result_store_ids'=>implode(',', $value['site_individual_combine_subject_result_store_ids']),
                    'site_id'=>Session::get('SITE_ID'),
                ]);
            }
            else{

                SiteStudentPrimaryResultDetail::create([

                    'academic_result_primary_type_id'=>$request->academic_result_primary_type_id,
                    'student_history_id'=>$value['student_history_id'],
                    'gpa'=>$value['final_point'],
                    'grade'=>$value['final_grade'],
                    'fail_subject_count'=>$value['fail_subject_count'],
                    'exam_attendance_status'=>$value['exam_attendance_status'],


                    'optional_subject_ids'=>$value['optional_subject_ids'],
                    'final_point_without_optional'=>$value['final_point_without_optional'],
                    'final_grade_without_optional'=>$value['final_grade_without_optional'],
                    'combine_subject_present'=>$value['combine_subject_present'],
                    'classtest_is_present'=>$value['classtest_is_present'],


                    'sum_of_obtain_raw_total_marks'=>ceil($value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks'=>ceil($value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks'=>ceil($value['sum_of_raw_total_marks']),
                    'raw_obtain_marks_percentage'=>$value['sum_of_obtain_raw_total_marks']*100/$value['sum_of_raw_total_marks'],

                    'sum_of_obtain_raw_total_marks_only_passed_subject'=>ceil($value['sum_of_obtain_raw_total_marks_only_passed_subject']),
                    'pass_subject_base_marks_percentage'=>$value['pass_subject_base_marks_percentage'],
                    'total_marks_base_percentage'=>$value['total_marks_base_percentage'],
                    'pass_subject_base_marks_grade'=>$value['pass_subject_base_marks_grade'],
                    'total_marks_base_grade'=>$value['total_marks_base_grade'],
                    'pass_subject_base_marks_point'=>$value['pass_subject_base_marks_point'],
                    'total_marks_base_point'=>$value['total_marks_base_point'],

                    'sum_of_obtain_total_marks_for_show'=>ceil($value['sum_of_obtain_total_marks_for_show']),
                    'sum_of_obtain_total_percent_for_show'=>$value['sum_of_obtain_total_percent_for_show'],
                    
//                'result_detail'=>json_encode($value['subject_list']),
                    'table_header'=>json_encode($exam_type_array_with_sort),
                    'site_individual_combine_subject_result_store_ids'=>implode(',', $value['site_individual_combine_subject_result_store_ids']),
                    'site_id'=>Session::get('SITE_ID'),
                ]);

            }

        }


//        $getUpdatedSiteStudentPrimaryResultDetail= SiteStudentPrimaryResultDetail::whereIn('student_history_id', $studentIdsList)
//            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
//            ->orderBy('gpa', 'desc')
//            ->orderBy('sum_of_obtain_raw_total_marks', 'desc')
//            ->get();
//
//
//        $previous_gpa=0;
//        $previous_marks=0;
//        $count=1;
//
//        foreach ($getUpdatedSiteStudentPrimaryResultDetail as $key => $value){
//
//            if($key==0){
//                $previous_gpa=$value->gpa;
//
//                $previous_marks=$value->sum_of_obtain_raw_total_marks;
//            }
//
//
//            if($previous_gpa==$value->gpa){
//                if($previous_marks==$value->sum_of_obtain_raw_total_marks){
//
//                    SiteStudentPrimaryResultDetail::where('id', $value->id)
//                    ->update([
//                        'student_rank'=>$count,
//                    ]);
//
//
//                }else{
//                    SiteStudentPrimaryResultDetail::where('id', $value->id)
//                        ->update([
//                            'student_rank'=>$count+1,
//                        ]);
//                    $count++;
//                }
//
//            }else{
//                SiteStudentPrimaryResultDetail::where('id', $value->id)
//                    ->update([
//                        'student_rank'=>$count+1,
//                    ]);
//                $count++;
//            }
//
//            $previous_gpa=$value->gpa;
//            $previous_marks=$value->sum_of_obtain_raw_total_marks;
//
//
//        }


        $count_student=count($classAllStudentlist);
        $completed_percent=ceil(count($generatedStudentIDs)*100/$count_student);


        if(count($tenStudentIDs)>0){

            return response()->json(
                [
                    'generatedStudentIDs'=>$generatedStudentIDs,
                    'count_student'=>$count_student,
                    'completed_percent'=>$completed_percent,
                ]);

//            return compact('generatedStudentlist', 'classAllStudentlist', 'generatedStudentIDs', 'tenStudentIDs');
        }else{
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }

    }

    private function studentMarkslist($studentMarksList, $grade_list, $subject_condition_setting,
                                      $resultSettingList, $getStudentOptionalSubject,$academic_result_primary_type_id,
                                      $showTableBellowSubjectExamList, $OtherSubjectExamList){

        $academicExamType=AcademicExamType::get();

        $student_array= $this->examTypePassFailStatus($studentMarksList);

        $class_test_present_list=$resultSettingList->where('examination.name_key', 'classtest');
        if(count($class_test_present_list)>0){
            $classtest_is_present=1;
        }else{
            $classtest_is_present=0;
        }

        $exam_percentage_sum=$resultSettingList->sum('marks_percentage');


        $student_history_all_ids=collect($student_array)->pluck('student_history_id');
        $student_history_ids=$student_history_all_ids->unique()->filter();
//        $student_history_ids=[565, 566, 567, 568, 569, 570, 571, 572, 573, 574];
//        $student_history_ids=[870];

        $site_subject_examination_marks_all_ids=collect($student_array)->pluck('site_subject_group_condition_setting_id');
        $site_subject_examination_marks_ids=$site_subject_examination_marks_all_ids->unique()->filter();

        $site_subject_examination_marks_list=SiteSubjectExaminationMark::whereIn('site_subject_group_condition_setting_id', $site_subject_examination_marks_ids)
            ->where('status', true)
            ->get(['id', 'site_subject_group_condition_setting_id', 'examination_id', 'marks', 'pass_marks']);
      
           // dd($site_subject_examination_marks_list);
      
        $siteIndividualCombineSubjectStudentList=SiteIndividualCombineSubjectResultStore::
            where('academic_result_primary_type_id', $academic_result_primary_type_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->get();


        $student_list_arr=Array();
        $student_list_array=[];
        $studentr_count=0;
        foreach ($student_history_ids as $key => $value) {


            $student_optional_present_check=collect($getStudentOptionalSubject)->where('id', $value)->first();


            $student_exam_number_list=collect($student_array)->where('student_history_id', $value);
            $site_subject_group_condition_setting_all_id=collect($student_array)->where('student_history_id', $value)
                ->pluck('site_subject_group_condition_setting_id');
            $site_subject_group_condition_setting_ids=$site_subject_group_condition_setting_all_id->unique()->filter();


            $examination_ids=$student_exam_number_list
                ->pluck('examination_id')->unique()->filter();

            $individual_subject_entry=[];
            $subject_arr=Array();
            $subject_array=[];
            $keye_count=0;

            foreach ($site_subject_group_condition_setting_ids as $keye => $valuee) {


                $examination_List=$student_exam_number_list
                    ->where('site_subject_group_condition_setting_id', $valuee);

                $student_exam_subject_attendance=$examination_List
                    ->where('exam_attendance_status', true)
                    ->first();

                if($student_exam_subject_attendance){
                    $student_exam_subject_attendance_status=true;
                }
                else{
                    $student_exam_subject_attendance_status=false;
                }

                $subject_base_pass_fail_list=$site_subject_examination_marks_list
                    ->where('site_subject_group_condition_setting_id', $valuee);
                //$selected_subject_list=$subject_condition_setting->where('id', $valuee)->first();
                $selected_subject_list=SubjectGroupConditionSetting::where('id', $valuee)->first();
               
               

                $exam_type_arr=Array();
                $exam_type_array=[];

                foreach ($examination_ids as $keys => $values) {
 
                    if($selected_subject_list->result_show_in_table_bellow==0){

                        $used_academic_exam_type_ids= $OtherSubjectExamList
                           // ->where('examination_id', $values)
                            ->pluck('academic_exam_type_id')->unique()->filter();
                     //   dd($used_academic_exam_type_ids);
                        $used_academic_exam_type_list=$academicExamType->whereIn('id', $used_academic_exam_type_ids);


                        $all_exam_type_arr=Array();
                        $all_exam_type_array=[];
                        foreach ($used_academic_exam_type_list as $keystt => $valuestt) {

                            $check_exam_type=$examination_List
                                ->where('examination_id', $values)
                                ->where('academic_exam_type_id', $valuestt->id)->first();

                            if($check_exam_type){
                                $all_exam_type_arr['academic_exam_type_id']= $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name']= $valuestt->marks_type;
                                $all_exam_type_arr['examination_id']= $values;
                                $all_exam_type_arr['id']= $check_exam_type['id'];
                                $all_exam_type_arr['obtaine_marks']= ceil($check_exam_type['obtaine_marks']);
                                $all_exam_type_arr['pass_mark']= $check_exam_type['pass_mark'];
                                $all_exam_type_arr['primary_pass_fail_status']= $check_exam_type['primary_pass_fail_status'];

                                $all_exam_type_arr['site_subject_group_condition_setting_id']= $check_exam_type['site_subject_group_condition_setting_id'];
                                $all_exam_type_arr['student_history_id']= $check_exam_type['student_history_id'];
                                $all_exam_type_arr['subject_exam_type_mark']= $check_exam_type['subject_exam_type_mark'];


                                $all_exam_type_arr['exam_held_status']= $check_exam_type['exam_held_status'];
                                $all_exam_type_arr['exam_attendance_status']= $check_exam_type['exam_attendance_status'];

                            }
                            else{
                                $all_exam_type_arr['academic_exam_type_id']= $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name']= $valuestt->marks_type;


                                $all_exam_type_arr['examination_id']= $values;
                                $all_exam_type_arr['id']= 0;
                                $all_exam_type_arr['obtaine_marks']= 0;
                                $all_exam_type_arr['pass_mark']= 0;
                                $all_exam_type_arr['primary_pass_fail_status']= 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id']= 0;
                                $all_exam_type_arr['student_history_id']= 0;
                                $all_exam_type_arr['subject_exam_type_mark']= 0;
                                $all_exam_type_arr['exam_held_status']= false;
                                $all_exam_type_arr['exam_attendance_status']=false;
                            }

                            $all_exam_type_array[$keystt]=array_merge($all_exam_type_arr);


                        }
                    }
                    else{
                        $used_academic_exam_type_ids= $showTableBellowSubjectExamList-> where('examination_id', $values)
                            ->pluck('academic_exam_type_id')->unique()->filter();
                        $used_academic_exam_type_list=$academicExamType->whereIn('id', $used_academic_exam_type_ids);



                        $all_exam_type_arr=Array();
                        $all_exam_type_array=[];
                        foreach ($used_academic_exam_type_list as $keystt => $valuestt) {

                            $check_exam_type=$examination_List
                                ->where('examination_id', $values)
                                ->where('academic_exam_type_id', $valuestt->id)->first();

                            if($check_exam_type){
                                $all_exam_type_arr['academic_exam_type_id']= $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name']= $valuestt->marks_type;
                                $all_exam_type_arr['examination_id']= $values;
                                $all_exam_type_arr['id']= $check_exam_type['id'];
                                $all_exam_type_arr['obtaine_marks']= ceil($check_exam_type['obtaine_marks']);
                                $all_exam_type_arr['pass_mark']= $check_exam_type['pass_mark'];
                                $all_exam_type_arr['primary_pass_fail_status']= $check_exam_type['primary_pass_fail_status'];

                                $all_exam_type_arr['site_subject_group_condition_setting_id']= $check_exam_type['site_subject_group_condition_setting_id'];
                                $all_exam_type_arr['student_history_id']= $check_exam_type['student_history_id'];
                                $all_exam_type_arr['subject_exam_type_mark']= $check_exam_type['subject_exam_type_mark'];

                            }
                            else{
                                $all_exam_type_arr['academic_exam_type_id']= $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name']= $valuestt->marks_type;


                                $all_exam_type_arr['examination_id']= $values;
                                $all_exam_type_arr['id']= 0;
                                $all_exam_type_arr['obtaine_marks']= 0;
                                $all_exam_type_arr['pass_mark']= 0;
                                $all_exam_type_arr['primary_pass_fail_status']= 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id']= 0;
                                $all_exam_type_arr['student_history_id']= 0;
                                $all_exam_type_arr['subject_exam_type_mark']= 0;
                            }

                            $all_exam_type_array[$keystt]=array_merge($all_exam_type_arr);

                        }
                    }

                    $exam_setting_list=$resultSettingList->where('examination_id', $values)->first();

                    $examination_base_pass_fail=$subject_base_pass_fail_list->where('examination_id', $values)
                        ->first();

                    $exam_type_all_ids=$examination_List
                        ->where('examination_id', $values)
                        ->pluck('academic_exam_type_id')->unique()->filter();
//                    $exam_type_ids=$student_history_all_ids->unique()->filter();
                //    dd($exam_type_all_ids);

                    $exam_type_sum=$examination_List
                        ->where('examination_id', $values)
                        ->sum('obtaine_marks');

                    $find_term_exam_unheld_list=$examination_List
                        ->where('examination.name_key', 'termexam')
                        ->first();

                    $find_class_test_unheld_list=$examination_List
                        ->where('examination.name_key', 'classtest')
                        ->where('exam_held_status', true)
                        ->pluck('examination_id')
                        ->unique();


                    $find_class_test_unheld_percentage=$resultSettingList
                        ->where('examination.name_key', 'classtest')
                        ->whereNotIn('examination_id', $find_class_test_unheld_list)
                        ->sum('marks_percentage');

                    if($find_class_test_unheld_percentage>0 &&
                        $find_term_exam_unheld_list['examination_id']==$exam_setting_list->examination_id){

                        $class_test_percentage_with_term_exam=$exam_setting_list->marks_percentage +
                            $find_class_test_unheld_percentage;
                    }
                    else{
                        $class_test_percentage_with_term_exam=$exam_setting_list->marks_percentage;
                    }

                    if($exam_setting_list->marks_percentage && $examination_base_pass_fail){

                        // if($examination_base_pass_fail){

                        if($exam_setting_list->marks_percentage>$examination_base_pass_fail->marks){

                            $marksPercent=$class_test_percentage_with_term_exam*
                                ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1)/100;

                            $countable_dependent_obtain_exam_type_marks_for_show= $exam_type_sum *
                                $marksPercent/
                                ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);
                              
                        }else{
                            $countable_dependent_obtain_exam_type_marks_for_show= $exam_type_sum *
                                $class_test_percentage_with_term_exam/
                                ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);
                        }

                      
                        ///////////
                        // if($exam_setting_list->marks_percentage>$examination_base_pass_fail->marks){

                        //     $marksPercent=$class_test_percentage_with_term_exam*
                        //         ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1)/100;

                        //     $countable_dependent_obtain_exam_type_marks= $exam_type_sum *
                        //         $marksPercent/
                        //         ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);

                        // }else{
                        //     $countable_dependent_obtain_exam_type_marks= $exam_type_sum *
                        //         $exam_setting_list->marks_percentage/
                        //         ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);
                        // }

                        ////////
                   
                        $countable_dependent_obtain_exam_type_marks= $exam_type_sum *
                            $exam_setting_list->marks_percentage/
                            ($examination_base_pass_fail->marks?$examination_base_pass_fail->marks:1);
                  
                  //   }
                    }
                    else{

                        $countable_dependent_obtain_exam_type_marks=$exam_type_sum;
                        $countable_dependent_obtain_exam_type_marks_for_show= $exam_type_sum;

                       
                    }
                  //  dd('$exam_type_sum');
//                    Log::info($countable_dependent_obtain_exam_type_marks);

                    $exam_type_indivisula_pass_count=$examination_List
                        ->where('examination_id', $values)
                        ->sum('primary_pass_fail_status');

                    $exam_type=collect($all_exam_type_array)
                        ->where('examination_id', $values);


                    if(count($exam_type_all_ids)==$exam_type_indivisula_pass_count){
                        $subject_indivisual_pass_fail_status= 1;
                    }else{
                        $subject_indivisual_pass_fail_status= 0;
                    }


//                    $exam_type_grade_find=$grade_list
//                        ->where('number_from', '<=', $exam_type_sum)
//                        ->Where('number_to', '>=', $exam_type_sum)
//                        ->first();

//                    Log::info($valuee);
//                    Log::info($values);
//                    Log::info($examination_base_pass_fail?$examination_base_pass_fail->marks:0);

                    $check_exam_held=$examination_List
                        ->where('examination_id', $values)
                        ->where('exam_held', 1)
                        ->first();
                    if($check_exam_held){
                        $exam_held_status=$check_exam_held['exam_held'];
                    }
                    else{
                        $exam_held_status=0;
                    }

                    $exam_type_arr['examination_id']=$values;
                    $exam_type_arr['id']=$exam_setting_list->show_position;

                    $exam_type_arr['examination_marks']=$examination_base_pass_fail?$examination_base_pass_fail->marks:0;
                    $exam_type_arr['examination_pass_marks']=$examination_base_pass_fail?$examination_base_pass_fail->pass_marks:0;

                    $exam_type_arr['subject_indivisual_pass_fail_status']=$subject_indivisual_pass_fail_status;
                    $exam_type_arr['exam_type_list']=collect($exam_type)->values();
                    $exam_type_arr['obtaine_total_marks']=ceil($exam_type_sum);
                    $exam_type_arr['exam_held_status']=$exam_held_status;

                    $exam_type_arr['examination_name']=$exam_setting_list->examination->examination_name;
                    $exam_type_arr['examination_name_key']=$exam_setting_list->examination->name_key;
                    $exam_type_arr['marks_percentage']=$exam_setting_list->marks_percentage;

                    $exam_type_arr['show_position']=$exam_setting_list->show_position;

                    $exam_type_arr['countable_dependent_obtain_exam_type_marks']=$countable_dependent_obtain_exam_type_marks;
                    $exam_type_arr['countable_dependent_obtain_exam_type_marks_for_show']=ceil($countable_dependent_obtain_exam_type_marks_for_show);

                    $exam_type_array[$keye_count]=array_merge($exam_type_arr);
                    $keye_count++;

                }

//return $exam_type_array;


                $term_exam_marks_percentage_sum=collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('marks_percentage');

                $term_exam_obtaine_total_marks_sum=collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('obtaine_total_marks');


                $term_exam_obtaine_total_marks_sum_for_show=collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');

//                $term_exam_countable_dependent_obtain_exam_type_marks_sum=collect($exam_type_array)->where('examination_name_key', 'termexam')
//                    ->sum('countable_dependent_obtain_exam_type_marks');

                $termexam_exam_held=collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->where('exam_held_status', 1)->first();
                if($termexam_exam_held){
                    $termexam_exam_held_status=$termexam_exam_held['exam_held_status'];
                }
                else{
                    $termexam_exam_held_status=0;
                }

                $term_examination_marks_sum=collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_marks');

                $term_examination_pass_marks_sum=collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_pass_marks');


                $term_pass_fail_primary_status=$term_exam_obtaine_total_marks_sum>=$term_examination_pass_marks_sum?1:0;

                $classtest_marks_percentage_sum=collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('marks_percentage');

                $classtest_obtaine_total_marks_sum=collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('obtaine_total_marks');

                $classtest_obtaine_total_marks_sum_for_show=collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');



                $classtest_exam_held=collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->where('exam_held_status', 1)->first();
                if($classtest_exam_held){
                    $classtest_exam_held_status=$classtest_exam_held['exam_held_status'];
                }
                else{
                    $classtest_exam_held_status=0;
                }


                $classtest_examination_marks_sum=collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('examination_marks');

//                $classtest_examination_pass_marks_sum=collect($exam_type_array)->where('examination_name_key', 'classtest')
//                    ->sum('examination_pass_marks');


//                $classtest_fail_primary_status=$classtest_obtaine_total_marks_sum>=$classtest_examination_pass_marks_sum?1:0;


                $indivisual_pass_fail_check_depend_on_exam_type=collect($exam_type_array)
                    ->pluck('subject_indivisual_pass_fail_status')->unique();



                if($term_pass_fail_primary_status){
                    if(count($indivisual_pass_fail_check_depend_on_exam_type)==1){
                        $subject_base_pass_fail_status=1;
                    }
                    else if(count($indivisual_pass_fail_check_depend_on_exam_type)==2){
                        $subject_base_pass_fail_status=0;
                    }
                }else{
                    $subject_base_pass_fail_status=0;
                }

                if($classtest_obtaine_total_marks_sum<=0 && !$classtest_exam_held_status){

                    if($term_exam_marks_percentage_sum<=0){
                        $obtain_total_marks_in_term_exam=$term_exam_obtaine_total_marks_sum;
                    }else{
                        $obtain_total_marks_in_term_exam=($term_exam_obtaine_total_marks_sum*100)/$term_examination_marks_sum;
                    }

                    $obtain_total_marks_in_class_test=0;

                    $subject_arr['total_marks_in_term_exam']=$term_examination_marks_sum;
                    $subject_arr['total_marks_in_class_test']=0;
                    $subject_arr['obtain_raw_total_marks_in_term_exam']=$term_exam_obtaine_total_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_class_test']=0;



                    $subject_arr['obtain_total_marks_in_term_exam']=ceil($obtain_total_marks_in_term_exam);
                    $subject_arr['obtain_total_marks_in_class_test']=$obtain_total_marks_in_class_test;

                }
                else{

                    if($term_exam_marks_percentage_sum<=0){
                        $obtain_total_marks_in_term_exam=$term_exam_obtaine_total_marks_sum;
                        $obtain_total_marks_in_class_test=$classtest_obtaine_total_marks_sum;
                    }else{
                        $obtain_total_marks_in_term_exam=($term_exam_obtaine_total_marks_sum*$term_exam_marks_percentage_sum)/$term_examination_marks_sum;
                        $obtain_total_marks_in_class_test=($classtest_obtaine_total_marks_sum*$classtest_marks_percentage_sum)/$classtest_examination_marks_sum;
                    }


                    $subject_arr['total_marks_in_term_exam']=$term_examination_marks_sum;
                    $subject_arr['total_marks_in_class_test']=$classtest_examination_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_term_exam']=$term_exam_obtaine_total_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_class_test']=$classtest_obtaine_total_marks_sum;



                    $subject_arr['obtain_total_marks_in_term_exam']=ceil($obtain_total_marks_in_term_exam);
                    $subject_arr['obtain_total_marks_in_class_test']=$obtain_total_marks_in_class_test;
                }


                $subject_total_number=$obtain_total_marks_in_term_exam+$obtain_total_marks_in_class_test;



//                $subject_grade_find=$grade_list
//                    ->where('number_from', '<=', ceil($subject_total_number))
//                    ->Where('number_to', '>=', ceil($subject_total_number))
//                    ->first();


              //  dd(ceil($term_exam_obtaine_total_marks_sum_for_show));
              //  dd(collect($exam_type_array)->sum('countable_dependent_obtain_exam_type_marks_for_show'));

                $subject_arr['obtain_total_marks_in_term_exam_for_show']=ceil($term_exam_obtaine_total_marks_sum_for_show);
                $subject_arr['obtain_total_marks_in_class_test_for_show']=ceil($classtest_obtaine_total_marks_sum_for_show);



                $subject_arr['termexam_exam_held_status']=$termexam_exam_held_status;
                $subject_arr['classtest_exam_held_status']=$classtest_exam_held_status;

                $subject_arr['student_exam_subject_attendance_status']=$student_exam_subject_attendance_status;


                $subject_arr['subject_base_pass_fail_status']=$subject_base_pass_fail_status;
                $subject_arr['result_show_in_table_bellow']=$selected_subject_list->result_show_in_table_bellow;



                $subject_arr['obtain_subject_total_marks']=ceil($subject_total_number);

                $subject_arr['subject_code']=$selected_subject_list->subject_code;

                $subject_arr['subject_name']=$selected_subject_list->subject_name;
                $subject_arr['exam_dependent_academic_subject']=$selected_subject_list->examDependentAcademicSubject->subject_name;
                $subject_arr['subject_exam_name_key']=$selected_subject_list->academicSubjectClassExamCondition->name_key;
                $subject_arr['subject_exam_name']=$selected_subject_list->academicSubjectClassExamCondition->name;
                $subject_arr['exam_dependent_academic_subject_id']=$selected_subject_list->exam_dependent_academic_subject_id;


                $subject_arr['academic_subject_id']=$selected_subject_list->academic_subject_id;
                $subject_arr['subject_position']=$selected_subject_list->subject_position;

                $subject_arr['site_subject_group_condition_setting_id']=$valuee;
                $subject_arr['examination_list']=array_values(array_sort(collect($exam_type_array), function ($value) {
                    return $value['show_position'];
                }));
                $subject_arr['countable_subject_total']=collect($exam_type_array)->sum('countable_dependent_obtain_exam_type_marks_for_show');

           
            if($student_optional_present_check){
              $checkOptionalSubject= collect($student_optional_present_check->optional_subject_ids[0])
             // $checkOptionalSubject= collect($student_optional_present_check)
              ->where('id', $selected_subject_list->academic_subject_id)->first();

                if($checkOptionalSubject){

                    $subject_arr['optional_academic_subject_status']=1;

                }else{
                    $subject_arr['optional_academic_subject_status']=0;
                }
                        $subject_array[$keye]=array_merge($subject_arr);

            }
        }

            $getPreviousAllSubjectStoreCombineListIds=SiteIndividualCombineSubjectResultStore::
                 where('academic_result_primary_type_id', $academic_result_primary_type_id)
                ->where('student_history_id', $value)
                ->where('status', true)
                ->pluck('id')
                ->toArray();

            $subject_group_by_array= collect($subject_array)
                ->groupBy('exam_dependent_academic_subject_id')->values();



            $dependent_single_subject_arr=Array();
            $dependent_single_subject_array=[];
            $count=0;
            $individual_combine_subject_entry=[];
            $combine_subject_present=[];
            $stable_ids=[];
            foreach ($subject_group_by_array as $keyo => $valueo) {

                if(count($valueo)>1){
                    $combine_subject_present[]=1;
                }else{
                    $combine_subject_present[]=0;
                }

                $subject_condition_setting_ids= collect($valueo)->pluck('site_subject_group_condition_setting_id');

                $examination_list_array=[];
                foreach ($valueo as $examinationValue) {

                    foreach ($examinationValue['examination_list'] as $examinationKeyt => $examinationValuet) {
                        $examination_list_array[]=$examinationValuet;
                    }

                }

                $dependent_subject_array=[];
                if(count($valueo)>1){

                    $dependent_subject_examination_ids=collect($examination_list_array)
                        ->pluck('examination_id')->unique()->filter();

                    $dependent_subject_arr=Array();
                    $marks_percent_present_absent=[];
                    foreach ($dependent_subject_examination_ids as $keyExamination => $valueExamination) {

                        $exam_setting_lists=$resultSettingList->where('examination_id', $valueExamination)->first();

                        $get_only_dependent_subject_lists=collect($examination_list_array)
                            ->where('examination_id', $valueExamination);

                        $exam_type_list_array=[];
                        foreach ($get_only_dependent_subject_lists as $examValue) {

                            foreach ($examValue['exam_type_list'] as $examValuet) {
                                $exam_type_list_array[]=$examValuet;

                            }
                        }

                        $only_dependent_subject_exam_type_ids= collect($exam_type_list_array)
                            -> where('examination_id', $valueExamination)
                            ->pluck('academic_exam_type_id')->unique()->filter();


                        $examtype_arr=Array();
                        $examtype_array=[];
                        foreach ($only_dependent_subject_exam_type_ids as $keyExamtype => $valueExamtype) {

                            $only_dependent_exam_type_lists=collect($exam_type_list_array)
                                ->where('academic_exam_type_id', $valueExamtype);

                            $only_dependent_exam_type_marks_sum=collect($exam_type_list_array)
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->sum('subject_exam_type_mark');
                            $only_dependent_exam_pass_mark_sum=collect($exam_type_list_array)
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->sum('pass_mark');
                            $only_dependent_exam_type_obtaine_marks_sum=collect($exam_type_list_array)
                                ->where('academic_exam_type_id', $valueExamtype)
                                ->sum('obtaine_marks');

                            $get_academic_exam_type_name_list=collect($exam_type_list_array)->where('academic_exam_type_id', $valueExamtype)->first();

                            $dependent_exam_pass_fail_status=$only_dependent_exam_type_obtaine_marks_sum>=$only_dependent_exam_pass_mark_sum?1:0;

                            $examtype_arr['examination_id']=$valueExamination;
                            $examtype_arr['academic_exam_type_id']=$valueExamtype;
                            $examtype_arr['academic_exam_type_name']=$get_academic_exam_type_name_list['academic_exam_type_name'];
                            $examtype_arr['pass_mark']=$only_dependent_exam_pass_mark_sum;
                            $examtype_arr['subject_exam_type_mark']=$only_dependent_exam_type_marks_sum;
                            $examtype_arr['obtaine_marks']=ceil($only_dependent_exam_type_obtaine_marks_sum);
                            $examtype_arr['primary_pass_fail_status']=$dependent_exam_pass_fail_status;

                            $examtype_array[$keyExamtype]=array_merge($examtype_arr);
                        }


                        $dependent_exam_type_marks_sum=collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('subject_exam_type_mark');
                        $dependent_exam_pass_mark_sum=collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('pass_mark');
                        $dependent_exam_type_obtaine_marks_sum=collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('obtaine_marks');
                        $dependent_exam_pass_fail_status_sum=collect($examtype_array)->where('examination_id', $valueExamination)
                            ->sum('primary_pass_fail_status');


                        $dependent_exam_type_obtaine_marks_sum_for_show_arr=[];
                        foreach ($valueo as $keyObtMarks => $valueObtMarks) {
                            $dependent_exam_type_obtaine_marks_sum_for_show_arr[$keyObtMarks] = collect($valueObtMarks['examination_list'])
                                ->where('examination_id', $valueExamination)
                                ->sum('countable_dependent_obtain_exam_type_marks_for_show');

                        }
                        $dependent_exam_type_obtaine_marks_sum_for_show=array_sum($dependent_exam_type_obtaine_marks_sum_for_show_arr);

                        if($exam_setting_lists->marks_percentage){
                            $countable_dependent_obtain_exam_type_marks= $dependent_exam_type_obtaine_marks_sum *
                                ($exam_setting_lists->marks_percentage/100)
                                ($dependent_exam_type_marks_sum?$dependent_exam_type_marks_sum:1);
                        }
                        else{
                            $countable_dependent_obtain_exam_type_marks= $dependent_exam_type_obtaine_marks_sum;
                          //  $countable_dependent_obtain_exam_type_marks= 0;
                        }

                        $check_combine_exam_held=collect($examination_list_array)
                            ->where('examination_id', $valueExamination)
                            ->where('exam_held', 1)
                            ->first();
                        if($check_combine_exam_held){
                            $exam_held_status=$check_exam_held['exam_held'];
                        }
                        else{
                            $exam_held_status=0;
                        }

                        $dependent_exam_setting_list=$resultSettingList->where('examination_id', $valueExamination)->first();

                        if(count($examtype_array)==$dependent_exam_pass_fail_status_sum){
                            $status_dependent_exam_pass_fail = 1;
                        }else{
                            $status_dependent_exam_pass_fail = 0;
                        }

                        $get_dependent_single_subject_list= $get_only_dependent_subject_lists->first();

//Log::info([count($examtype_array), $dependent_exam_pass_fail_status_sum]);

                        $dependent_subject_arr['exam_held_status']=$exam_held_status;

                        $dependent_subject_arr['exam_type_list']=collect($examtype_array);
                        $dependent_subject_arr['examination_id']=$valueExamination;
                        $dependent_subject_arr['examination_name']=$dependent_exam_setting_list->examination->examination_name;
                        $dependent_subject_arr['examination_marks']=$dependent_exam_type_marks_sum;
                        $dependent_subject_arr['examination_name_key']=$get_dependent_single_subject_list['examination_name_key'];
                        $dependent_subject_arr['examination_pass_marks']=$dependent_exam_pass_mark_sum;
                        $dependent_subject_arr['marks_percentage']=$dependent_exam_setting_list->marks_percentage;
                        $dependent_subject_arr['show_position']=$dependent_exam_setting_list->show_position;
                        $dependent_subject_arr['obtaine_total_marks']=ceil($dependent_exam_type_obtaine_marks_sum);
                        $dependent_subject_arr['subject_indivisual_pass_fail_status']=$status_dependent_exam_pass_fail;
                        $dependent_subject_arr['countable_dependent_obtain_exam_type_marks']=ceil($countable_dependent_obtain_exam_type_marks);
                        $dependent_subject_arr['countable_dependent_obtain_exam_type_marks_for_show']=ceil($dependent_exam_type_obtaine_marks_sum_for_show);

                        $dependent_subject_array[$keyExamination]=array_merge($dependent_subject_arr);

                    }


                }
                else{
                    $dependent_subject_array= $valueo[0]['examination_list'];

                }


                $result_show_in_table_bellow_sum=$valueo->sum('result_show_in_table_bellow');
                $result_show_in_table_bellows=$result_show_in_table_bellow_sum/count($valueo);
                if($result_show_in_table_bellows>0){
                    $result_show_in_table_bellow_status=1;
                }else{
                    $result_show_in_table_bellow_status=0;
                }



                if(count($valueo)>1){
                    $subject_code_array=collect($dependent_subject_array)->pluck('subject_code')->unique()->filter();


                    $subject_code= count($subject_code_array)>0? implode(', ', $subject_code_array):'';
                }else{
                    $subject_code= $valueo[0]['subject_code'];
                }



                $countable_dependent_obtain_termexam_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks');



//                $dependent_termexam_exam_held=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
//                    ->where('exam_held_status', 1)->first();
//                if($dependent_termexam_exam_held){
//                    $dependent_termexam_exam_held_status=$dependent_termexam_exam_held['exam_held_status'];
//                }
//                else{
//                    $dependent_termexam_exam_held_status=0;
//                }

//                $count_term_exam=collect($dependent_subject_array)->where('examination_name_key', 'termexam')->count();


                $dependent_term_exam_marks_percentage_sum=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('marks_percentage');

                $dependent_term_exam_obtaine_total_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('obtaine_total_marks');


                $dependent_term_exam_obtaine_total_marks_sum_for_show=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');

             //   dd($dependent_term_exam_obtaine_total_marks_sum_for_show);

                $dependent_term_examination_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_marks');

                $dependent_term_examination_pass_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_pass_marks');

                $dependent_term_pass_fail_primary_status=$dependent_term_exam_obtaine_total_marks_sum>=$dependent_term_examination_pass_marks_sum?1:0;

                $countable_dependent_obtain_classtest_marks_sum=collect($dependent_subject_array)
                    ->where('examination_name_key', 'classtest')
                    ->sum('countable_dependent_obtain_exam_type_marks');

                $dependent_classtest_marks_percentage_sum=collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                  //  ->where('countable_dependent_obtain_exam_type_marks', '!=', 0)
                    ->where('countable_dependent_obtain_exam_type_marks', '>=', 0)
                    ->sum('marks_percentage');



                $dependent_classtest_exam_held=collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->where('exam_held_status', 1)->first();
                if($dependent_classtest_exam_held){
                    $dependent_classtest_exam_held_status=$dependent_classtest_exam_held['exam_held_status'];
                }
                else{
                    $dependent_classtest_exam_held_status=0;
                }


                $dependent_classtest_obtaine_total_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('obtaine_total_marks');

//                $count_class_test=collect($dependent_subject_array)->where('examination_name_key', 'classtest')->count();


                $dependent_classtest_obtaine_total_marks_sum_for_show=collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');



                $dependent_classtest_examination_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('examination_marks');

                $dependent_classtest_examination_pass_marks_sum=collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('examination_pass_marks');


                $dependent_classtest_fail_primary_status=$dependent_classtest_obtaine_total_marks_sum>=$dependent_classtest_examination_pass_marks_sum?1:0;



                $exam_count=count(collect($dependent_subject_array)->pluck('examination_id'));

                $dependent_indivisual_pass_fail_check_depend_on_exam_type=collect($dependent_subject_array)
                    ->sum('subject_indivisual_pass_fail_status');

//                Log::info($dependent_indivisual_pass_fail_check_depend_on_exam_type);



                $obtain_total_marks_for_show=collect($dependent_subject_array)
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');


                //    $obtain_total_marks_for_show2=collect($dependent_subject_array);
                    //->sum('countable_dependent_obtain_exam_type_marks_for_show');
             //   dd($obtain_total_marks_for_show2);
//                $dependent_single_subject_arr['count_term_exam']=$count_term_exam;
//                $dependent_single_subject_arr['count_class_test']=$count_class_test;


                // $dependent_single_subject_arr['obtain_total_marks_in_term_exam_for_show']=ceil(number_format((float)$dependent_term_exam_obtaine_total_marks_sum_for_show, 2, '.', ''));
                // $dependent_single_subject_arr['obtain_total_marks_in_class_test_for_show']=ceil(number_format((float)$dependent_classtest_obtaine_total_marks_sum_for_show, 2, '.', ''));
                // $dependent_single_subject_arr['obtain_total_marks_for_show']=ceil(number_format((float)$obtain_total_marks_for_show, 2, '.', ''));
               
                $dependent_single_subject_arr['obtain_total_marks_in_term_exam_for_show']=ceil($dependent_term_exam_obtaine_total_marks_sum_for_show);
                $dependent_single_subject_arr['obtain_total_marks_in_class_test_for_show']=ceil($dependent_classtest_obtaine_total_marks_sum_for_show);
                $dependent_single_subject_arr['obtain_total_marks_for_show']=ceil($obtain_total_marks_for_show);




                if($dependent_term_pass_fail_primary_status){
                    if($exam_count==$dependent_indivisual_pass_fail_check_depend_on_exam_type){
                        $dependent_subject_base_pass_fail_status=1;
                    }
                    else{
                        $dependent_subject_base_pass_fail_status=0;
                    }
                }else{
                    $dependent_subject_base_pass_fail_status=0;
                }



                $rest_percentage=100-($dependent_term_exam_marks_percentage_sum+$dependent_classtest_marks_percentage_sum);


                if($dependent_classtest_obtaine_total_marks_sum<=0 && $dependent_classtest_exam_held_status==0){


                    if($dependent_term_examination_marks_sum>0){

                        if($dependent_term_exam_marks_percentage_sum>0){
                            $dependent_obtain_total_marks_in_term_exam=($countable_dependent_obtain_termexam_marks_sum*
                                    100)/$dependent_term_exam_marks_percentage_sum;
                        }else{
                            $dependent_obtain_total_marks_in_term_exam=$countable_dependent_obtain_termexam_marks_sum;
                        }



                    }else{
                        $dependent_obtain_total_marks_in_term_exam=0;
                    }

                    $dependent_obtain_total_marks_in_class_test=0;




                    $total_marks_in_term_exam=$dependent_term_examination_marks_sum;
                    $total_marks_in_class_test=0;
                    $obtain_raw_total_marks_in_term_exam=$dependent_term_exam_obtaine_total_marks_sum;
                    $obtain_raw_total_marks_in_class_test=0;
//                    $obtain_total_marks_in_term_exam=$dependent_obtain_total_marks_in_term_exam;
//                    $obtain_total_marks_in_class_test=$dependent_obtain_total_marks_in_class_test;



                    $dependent_single_subject_arr['total_marks_in_term_exam']=$dependent_term_examination_marks_sum;
                    $dependent_single_subject_arr['total_marks_in_class_test']=0;
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_term_exam']=ceil($dependent_term_exam_obtaine_total_marks_sum);
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_class_test']=0;



                    $dependent_single_subject_arr['obtain_total_marks_in_term_exam']=ceil(number_format((float)$dependent_obtain_total_marks_in_term_exam, 2, '.', ''));
                    $dependent_single_subject_arr['obtain_total_marks_in_class_test']=ceil(number_format((float)$dependent_obtain_total_marks_in_class_test, 2, '.', ''));

                }
                else{

                    if($dependent_term_examination_marks_sum>0){

                        if($dependent_term_exam_marks_percentage_sum>0){
                            $dependent_obtain_total_marks_in_term_exam=($countable_dependent_obtain_termexam_marks_sum*
                                    ($rest_percentage+$dependent_term_exam_marks_percentage_sum))/
                                $dependent_term_exam_marks_percentage_sum;

                        }
                        else{
                            $dependent_obtain_total_marks_in_term_exam=$countable_dependent_obtain_termexam_marks_sum;
                        }


                    }else{
                        $dependent_obtain_total_marks_in_term_exam=0;
                    }

                    $dependent_obtain_total_marks_in_class_test=$countable_dependent_obtain_classtest_marks_sum;


                    $total_marks_in_term_exam=$dependent_term_examination_marks_sum;
                    $total_marks_in_class_test=$dependent_classtest_examination_marks_sum;
                    $obtain_raw_total_marks_in_term_exam=ceil($dependent_term_exam_obtaine_total_marks_sum);
                    $obtain_raw_total_marks_in_class_test=ceil($dependent_classtest_obtaine_total_marks_sum);
//                    $obtain_total_marks_in_term_exam=$dependent_obtain_total_marks_in_term_exam;
//                    $obtain_total_marks_in_class_test=$dependent_obtain_total_marks_in_class_test;

                    $dependent_single_subject_arr['total_marks_in_term_exam']=$dependent_term_examination_marks_sum;
                    $dependent_single_subject_arr['total_marks_in_class_test']=$dependent_classtest_examination_marks_sum;
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_term_exam']=ceil($dependent_term_exam_obtaine_total_marks_sum);
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_class_test']=ceil($dependent_classtest_obtaine_total_marks_sum);

                    $dependent_single_subject_arr['obtain_total_marks_in_term_exam']= ceil(number_format((float)$dependent_obtain_total_marks_in_term_exam, 2, '.', ''));
                    $dependent_single_subject_arr['obtain_total_marks_in_class_test']= ceil(number_format((float)$dependent_obtain_total_marks_in_class_test, 2, '.', ''));
                }

//                return $dependent_obtain_total_marks_in_term_exam;

//                Log::info($countable_dependent_obtain_classtest_marks_sum);
              //  dd($obtain_total_marks_in_term_exam);

                $dependent_single_subject_arr['obtain_raw_total_marks']=$obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test;
                $dependent_single_subject_arr['obtain_percent_total_marks']=ceil($obtain_total_marks_in_term_exam+$obtain_total_marks_in_class_test);
               // $dependent_single_subject_arr['obtain_percent_total_marks']=$obtain_total_marks_for_show;
                $dependent_single_subject_arr['raw_total_marks']=$total_marks_in_term_exam+$total_marks_in_class_test;
               // dd($dependent_single_subject_arr);
                if($exam_percentage_sum>0){
                    $dependent_subject_total_number=$dependent_obtain_total_marks_in_term_exam+
                        $dependent_obtain_total_marks_in_class_test;

                }else{
                    $dependent_subject_total_number=$dependent_single_subject_arr['obtain_raw_total_marks']*100/
                        $dependent_single_subject_arr['raw_total_marks'];

                }

                if($dependent_subject_base_pass_fail_status==1){
                    $subject_grade_find=$grade_list
                        ->where('number_from', '<=', ceil($dependent_subject_total_number) )
                        ->Where('number_to', '>=', ceil($dependent_subject_total_number))
                        ->first();
                }else{
                    $subject_grade_find=$grade_list
                        ->where('number_from', '<=', ceil(0) )
                        ->Where('number_to', '>=', ceil(0))
                        ->first();
                }

//                $subject_grade_find=$grade_list
//                    ->where('number_from', '<=', ceil($dependent_subject_total_number) )
//                    ->Where('number_to', '>=', ceil($dependent_subject_total_number))
//                    ->first();

                $find_first_data= collect($valueo)->first();

                $dependent_single_subject_arr['exam_dependent_academic_subject_id']=$find_first_data['exam_dependent_academic_subject_id'];
                $dependent_single_subject_arr['subject_position']=$find_first_data['subject_position'];
                $dependent_single_subject_arr['exam_dependent_academic_subject']=$find_first_data['exam_dependent_academic_subject'];

                $dependent_single_subject_arr['subject_code']=$subject_code;

                $optional_sub_check= collect($valueo)->pluck('optional_academic_subject_status')->unique()->filter();

//                return $subject_grade_find->point-2;
//Log::info($subject_grade_find->point);


                if(count($optional_sub_check)>0){

                    $dependent_single_subject_arr['dependent_optional_academic_subject_status']=1;

                    $dependent_single_subject_arr['subject_countable_point']=$subject_grade_find?$subject_grade_find->point>2?($subject_grade_find->point-2):0:0;

                }else{
                    $dependent_single_subject_arr['dependent_optional_academic_subject_status']=0;

                    $dependent_single_subject_arr['subject_countable_point']=$subject_grade_find?$subject_grade_find->point:0;
                }


//                Log::info([$value, $dependent_subject_base_pass_fail_status]);


                $dependent_single_subject_arr['result_show_in_table_bellow_status']=$result_show_in_table_bellow_status;
                $dependent_single_subject_arr['subject_base_pass_fail_status']=$dependent_subject_base_pass_fail_status;

                $dependent_single_subject_arr['obtain_subject_total_marks']=ceil($dependent_single_subject_arr['obtain_raw_total_marks']);

                $dependent_single_subject_arr['subject_marks_percentage']=ceil($dependent_subject_total_number);

                $dependent_single_subject_arr['subject_point']=$subject_grade_find?$subject_grade_find->point:0;
                $dependent_single_subject_arr['subject_grade']=$subject_grade_find?$subject_grade_find->academicResultSystem->name:0;
                $dependent_single_subject_arr['indivisual_student_subject_list']=$valueo;
                $dependent_single_subject_arr['subject_count']=count($valueo);
                $dependent_single_subject_arr['dependent_subject_list']=array_values(array_sort(collect($dependent_subject_array), function ($value) {
                    return $value['show_position'];
                }));


                $tab_arr=Array();
                $tab_array=[];
                foreach ($valueo as $keytp => $valuetp) {

          //   dd($valuetp);

                    $tab_exam_arr=Array();
                    $tab_exam_array=[];
                    
               
                    foreach ($valuetp['examination_list'] as $keytpt => $valuetpt) {

                        $tab_exam_arr['exam_type_list']=$valuetpt['exam_type_list'];
                        $tab_exam_arr['examination_id']=$valuetpt['examination_id'];
                        $tab_exam_arr['examination_name']=$valuetpt['examination_name'];
                        $tab_exam_arr['obtaine_total_marks']=ceil($valuetpt['obtaine_total_marks']);
                        $tab_exam_arr['examination_marks']=$valuetpt['examination_marks'];
                        $tab_exam_arr['countable_dependent_obtain_exam_type_marks']=$valuetpt['countable_dependent_obtain_exam_type_marks'];
                       // $tab_exam_arr['countable_dependent_obtain_exam_type_marks']=ceil($valuetpt['obtaine_total_marks']*($valuetpt['marks_percentage']/100));

                   
                        $tab_exam_array[$keytpt]=array_merge($tab_exam_arr);

                    }
                    // ==extra add for percentage==
                    $countable_mark = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');
                    $tab_arr['countable_obtain_marks']=ceil($countable_mark);

                    //===
                     $tab_arr['obtain_marks']=ceil( $valuetp['obtain_total_marks_in_term_exam']+$valuetp['obtain_total_marks_in_class_test']);

                    $tab_arr['subject_name']=$valuetp['subject_name'];
                    $tab_arr['academic_subject_id']=$valuetp['academic_subject_id'];
                    $tab_arr['examination_list']=$tab_exam_array;

                    $tab_array[$keytp]=array_merge($tab_arr);
                }

          //  dd($tab_array);

                $dependent_single_subject_array[$count]=array_merge($dependent_single_subject_arr);
                $count++;

                $checkCombineSubjectIntable=$siteIndividualCombineSubjectStudentList->where('student_history_id', $value)
                    ->where('academic_result_primary_type_id', $academic_result_primary_type_id)
                    ->where('exam_dependent_academic_subject_id', $dependent_single_subject_arr['exam_dependent_academic_subject_id'])
                    ->first();

                $student_exam_combine_subject_attendance=collect($valueo)
                    ->where('student_exam_subject_attendance_status', true)
                    ->first();

                if($student_exam_combine_subject_attendance){
                    $student_exam_combine_subject_attendance_status=true;
                }else{
                    $student_exam_combine_subject_attendance_status=false;
                }


                if($checkCombineSubjectIntable){

                    $stable_ids[]=$checkCombineSubjectIntable->id;

//                    $fdates = $checkCombineSubjectIntable->created_at;
//                    $tdates = Carbon::today();
//                    $datetime1s = new DateTime($fdates);
//                    $datetime2s = new DateTime($tdates);
//                    $intervals = $datetime1s->diff($datetime2s);
//                    $dayss = $intervals->format('%a');



//                    if($dayss>15){
//                        $checkCombineSubjectIntable->update(['status'=>false]);
//
//                        $individual_combine_subject_entry[]=[
//
//
//                            'student_history_id'=>$value,
//                            'academic_result_primary_type_id'=>$academic_result_primary_type_id,
//                            'exam_dependent_academic_subject_id'=> $dependent_single_subject_arr['exam_dependent_academic_subject_id'],
//                            'optional_academic_subject_status'=>$dependent_single_subject_arr['dependent_optional_academic_subject_status'],
//                            'subject_base_pass_fail_status'=>$dependent_subject_base_pass_fail_status,
//
//                            'raw_total_marks'=>$dependent_single_subject_arr['raw_total_marks'],
//
//                            'obtain_subject_total_marks'=>$dependent_single_subject_arr['obtain_subject_total_marks'],
//                            'subject_marks_percentage'=>$dependent_single_subject_arr['subject_marks_percentage'],
//                            'subject_grade'=>$dependent_single_subject_arr['subject_grade'],
//                            'subject_point'=>$dependent_single_subject_arr['subject_point'],
//                            'subject_position'=>$dependent_single_subject_arr['subject_position'],
//
//                            'result_show_in_table_bellow_status'=>$dependent_single_subject_arr['result_show_in_table_bellow_status'],
//
//                            'subject_count'=>count($valueo),
//                            'subject_detail'=>json_encode($dependent_single_subject_arr),
//
//                            'list_for_tabulation'=>json_encode($tab_array),
//
//                            'status'=>true,
//                            'site_id'=>Session::get('SITE_ID'),
//                            'created_at'=>Carbon::today(),
//
//
//                            'obtain_raw_total_marks'=> $obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test,
//                            'obtain_percent_total_marks'=> $obtain_total_marks_in_term_exam+$obtain_total_marks_in_class_test,
//
//
//                        ];
//
//                    }else{


                        $obtain = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');
                    
                     //   dd($tab_array[0]['countable_obtain_marks']);
                    // dd($obtain_total_marks_for_show);
                        $checkCombineSubjectIntable
                            ->update([
                                'subject_base_pass_fail_status'=>$dependent_subject_base_pass_fail_status,
                                'obtain_subject_total_marks'=>ceil($dependent_single_subject_arr['obtain_subject_total_marks']),
                                'subject_marks_percentage'=>$dependent_single_subject_arr['subject_marks_percentage'],
                                'subject_grade'=>$dependent_single_subject_arr['subject_grade'],
                                'subject_point'=>$dependent_single_subject_arr['subject_point'],
                                'exam_attendance_status'=>$student_exam_combine_subject_attendance_status,
                                'subject_position'=>$dependent_single_subject_arr['subject_position'],
                                'subject_count'=>count($valueo),
                                'subject_detail'=>json_encode($dependent_single_subject_arr),
                                'list_for_tabulation'=>json_encode($tab_array),

                                'result_show_in_table_bellow_status'=>$dependent_single_subject_arr['result_show_in_table_bellow_status'],
                                'updated_at'=>Carbon::today(),
                                'obtain_raw_total_marks'=> ceil($obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test),

                                'raw_total_marks'=>ceil($dependent_single_subject_arr['raw_total_marks']),
                                'obtain_total_marks_for_show'=>$obtain_total_marks_for_show,
                                
                                'obtain_percent_total_marks'=> ceil($obtain_total_marks_in_term_exam+$obtain_total_marks_in_class_test),
                                // 'obtain_percent_total_marks'=> $tab_array[0]['countable_obtain_marks'],
                              //  'obtain_percent_total_marks'=> ceil($obtain),
                            ]);
//                    }

//                    }


                }
                else{
                    $obtain = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');

                    $individual_combine_subject_entry[]=[
                        'student_history_id'=>$value,
                        'academic_result_primary_type_id'=>$academic_result_primary_type_id,
                        'exam_dependent_academic_subject_id'=> $dependent_single_subject_arr['exam_dependent_academic_subject_id'],
                        'optional_academic_subject_status'=>$dependent_single_subject_arr['dependent_optional_academic_subject_status'],
                        'subject_base_pass_fail_status'=>$dependent_subject_base_pass_fail_status,

                        'raw_total_marks'=>ceil($dependent_single_subject_arr['raw_total_marks']),

                        'obtain_subject_total_marks'=>ceil($dependent_single_subject_arr['obtain_subject_total_marks']),
                        'subject_marks_percentage'=>$dependent_single_subject_arr['subject_marks_percentage'],
                        'subject_grade'=>$dependent_single_subject_arr['subject_grade'],
                        'subject_position'=>$dependent_single_subject_arr['subject_position'],
                        'exam_attendance_status'=>$student_exam_combine_subject_attendance_status,

                        'result_show_in_table_bellow_status'=>$dependent_single_subject_arr['result_show_in_table_bellow_status'],

                        'subject_point'=>$dependent_single_subject_arr['subject_point'],
                        'subject_count'=>count($valueo),
                        'Subject_detail'=>json_encode($dependent_single_subject_arr),

                        'list_for_tabulation'=>json_encode($tab_array),

                        'status'=>true,
                        'site_id'=>Session::get('SITE_ID'),
                        'created_at'=>Carbon::today(),

                        'obtain_total_marks_for_show'=>$obtain_total_marks_for_show,

                        'obtain_raw_total_marks'=> ceil($obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test),
                        'obtain_percent_total_marks'=> ceil($obtain_total_marks_in_term_exam+$obtain_total_marks_in_class_test),
                       
                        // 'obtain_percent_total_marks'=> $tab_array[0]['countable_obtain_marks'],
                      //  'countable_obtain_marks'=> $tab_array[0]['countable_obtain_marks'],

                        //'obtain_percent_total_marks'=> ceil($obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test),
                        //'total_exam_marks'=>$dependent_single_subject_arr['total_exam_marks'],
                        //'obtain_percent_total_marks'=> ceil($obtain),
                    ];
                }
            }
           

            if(count($getPreviousAllSubjectStoreCombineListIds)>0){
                if(count($stable_ids)>0){
                    $ids_for_delete=array_diff($getPreviousAllSubjectStoreCombineListIds, $stable_ids);
                    SiteIndividualCombineSubjectResultStore::whereIn('id', $ids_for_delete)->delete();
                }

            }

            if(count($individual_combine_subject_entry)>0){
                SiteIndividualCombineSubjectResultStore::insert($individual_combine_subject_entry);
            }

            $getlatestSubjectStoreCombineList=SiteIndividualCombineSubjectResultStore::
            where('academic_result_primary_type_id', $academic_result_primary_type_id)
                ->where('student_history_id', $value)
                ->where('status', true)
                ->orderBy('subject_position')
                ->get();

           //     dd($getlatestSubjectStoreCombineList);

//            if($value==7940){
//                return $getlatestSubjectStoreCombineList;
//            }

            $full_exam_attendance_list=$getlatestSubjectStoreCombineList->where('exam_attendance_status', true)->first();


            if($full_exam_attendance_list){
                $full_exam_attendance_list_status=true;
            }
            else{
                $full_exam_attendance_list_status=false;
            }

            $getlatestSubjectStoreCombineIDs=$getlatestSubjectStoreCombineList->pluck('id');

            $subject_detail=[];
            $optional_subject_list=[];
            foreach ($getlatestSubjectStoreCombineList as $keyt => $valuet) {

              //  dd($valuet);
                $subject_detail[]=$valuet->subject_detail;
                if($valuet->optional_academic_subject_status==1){
                    $optional_subject_list[]=$valuet->exam_dependent_academic_subject_id;
                }
            }

    
          //  dd(collect($subject_detail));

            $sum_of_obtain_total_marks_for_show= collect($subject_detail)
                ->sum('obtain_total_marks_for_show');

            $sum_of_obtain_total_percent_for_show= collect($subject_detail)
                ->avg('subject_marks_percentage');
                
           // dd($sum_of_obtain_total_percent_for_show);
            $sum_of_obtain_raw_total_marks= collect($subject_detail)
                ->sum('obtain_raw_total_marks');
            $sum_of_obtain_percent_total_marks= collect($subject_detail)
                ->sum('obtain_percent_total_marks');
            $sum_of_raw_total_marks= collect($subject_detail)
                ->sum('raw_total_marks');
          //obtain_percent_total_marks
          
            $sum_of_total_point_with_optional= collect($subject_detail)
                ->sum('subject_countable_point');
            $sum_of_total_point_without_optional= collect($subject_detail)
                ->where('dependent_optional_academic_subject_status', 0)
                ->sum('subject_countable_point');
            $sum_of_total_countable_subject= collect($subject_detail)
                ->where('dependent_optional_academic_subject_status', 0)
                ->count('exam_dependent_academic_subject_id');
            $sum_of_subject_base_pass_fail_status= collect($subject_detail)
                ->where('dependent_optional_academic_subject_status', 0)
                ->sum('subject_base_pass_fail_status');

//Log::info([$sum_of_total_countable_subject, $sum_of_subject_base_pass_fail_status]);

            if($sum_of_total_countable_subject==$sum_of_subject_base_pass_fail_status){

                $student_final_point_with_optional=($sum_of_total_point_with_optional/$sum_of_total_countable_subject)>5?5:
                    ($sum_of_total_point_with_optional/$sum_of_total_countable_subject);

                $student_final_point_without_optional=$sum_of_total_point_without_optional/$sum_of_total_countable_subject;

            }else{

                $student_final_point_with_optional=0;
                $student_final_point_without_optional=0;
            }

//Log::info($student_final_point_with_optional);


            // $total_grade_find=$grade_list
            //     ->where('point_from', '<=', number_format((float)$student_final_point_with_optional, 2, '.', ''))
            //     ->Where('point_to', '>=', number_format((float)$student_final_point_with_optional, 2, '.', ''))
            //     ->first();
                $total_grade_find=collect($grade_list)
                ->where('point_from', '<=', $student_final_point_with_optional)
                ->Where('point_to', '>=', $student_final_point_with_optional)
                ->first();


            $total_grade_find_without_optional=$grade_list
                ->where('point_from', '<=', $student_final_point_without_optional)
                ->Where('point_to', '>=', $student_final_point_without_optional)
                ->first();

            $academic_primary_id_get=collect($resultSettingList)->first();

            $multiple_subject_present=collect($combine_subject_present)->unique()->filter();

            //=======================এইগুলো টেবিলে দিতে হবে।===================

            $sum_of_obtain_raw_total_marks_only_passed_subject= collect($subject_detail)
                ->where('subject_base_pass_fail_status', 1)
                ->sum('obtain_raw_total_marks');
            $pass_subject_base_marks_percentage=$sum_of_obtain_raw_total_marks_only_passed_subject*100/
                $sum_of_raw_total_marks;


            $total_marks_base_percentage=$sum_of_obtain_raw_total_marks*100/
                $sum_of_raw_total_marks;
           //     dd($total_marks_base_percentage);

            $pass_subject_base_marks_grade=$grade_list
                ->where('number_from', '<=', ceil($pass_subject_base_marks_percentage) )
                ->Where('number_to', '>=', ceil($pass_subject_base_marks_percentage))
                ->first();

            $total_marks_base_grade=$grade_list
                ->where('number_from', '<=', ceil($total_marks_base_percentage) )
                ->Where('number_to', '>=', ceil($total_marks_base_percentage))
                ->first();

            $pass_subject_base_marks_point=$pass_subject_base_marks_grade->point;

            $total_marks_base_point=$total_marks_base_grade->point;

           // dd($getlatestSubjectStoreCombineIDs->toArray());

            $student_list_arr['sum_of_obtain_raw_total_marks_only_passed_subject']=ceil($sum_of_obtain_raw_total_marks_only_passed_subject);
            $student_list_arr['pass_subject_base_marks_percentage']=$pass_subject_base_marks_percentage;
            $student_list_arr['total_marks_base_percentage']=$total_marks_base_percentage;
            $student_list_arr['pass_subject_base_marks_grade']=$pass_subject_base_marks_grade->academicResultSystem->name;
            $student_list_arr['total_marks_base_grade']=$total_marks_base_grade->academicResultSystem->name;
            $student_list_arr['pass_subject_base_marks_point']=$pass_subject_base_marks_point;
            $student_list_arr['total_marks_base_point']=$total_marks_base_point;

            $student_list_arr['exam_attendance_status']=$full_exam_attendance_list_status;

            $student_list_arr['fail_subject_count']=$sum_of_total_countable_subject-$sum_of_subject_base_pass_fail_status;
            $student_list_arr['academic_result_primary_type_id']=$academic_primary_id_get->academicResultPrimaryType->id;
            $student_list_arr['final_grade']=$total_grade_find->academicResultSystem->name??null;

            $student_list_arr['final_point']= number_format((float)$student_final_point_with_optional, 2, '.', '');

            $student_list_arr['student_history_id']=$value;
            $student_list_arr['subject_list']=$subject_detail;
            $student_list_arr['site_individual_combine_subject_result_store_ids']=$getlatestSubjectStoreCombineIDs->toArray();


            $student_list_arr['final_grade_without_optional']=$total_grade_find_without_optional->academicResultSystem->name??null;
            $student_list_arr['final_point_without_optional']= number_format((float)$student_final_point_without_optional, 2, '.', '');
            $student_list_arr['optional_subject_ids']=implode(',', $optional_subject_list);
            $student_list_arr['combine_subject_present']=count($multiple_subject_present)>=1?1:0;
            $student_list_arr['classtest_is_present']=$classtest_is_present;

            $student_list_arr['sum_of_obtain_total_marks_for_show']=ceil($sum_of_obtain_total_marks_for_show);
            $student_list_arr['sum_of_obtain_total_percent_for_show']=number_format((float)$sum_of_obtain_total_percent_for_show, 2, '.', '');
           
            $student_list_arr['sum_of_obtain_raw_total_marks']=ceil($sum_of_obtain_raw_total_marks);
            $student_list_arr['sum_of_obtain_percent_total_marks']=$sum_of_obtain_percent_total_marks;
            $student_list_arr['sum_of_raw_total_marks']=$sum_of_raw_total_marks;

            $student_list_array[$studentr_count]=array_merge($student_list_arr);
            $studentr_count++;

        }
       // dd($student_list_array);
        return $student_list_array;

    }

    private function examTypePassFailStatus($studentMarksList){

        $student_arr=Array();
        $student_array=[];
        foreach ($studentMarksList as $key => $value) {


            if($value->exam_held_status){

                if($value->exam_attendance_status){

                    if($value->obtaine_marks >= $value->pass_mark){

                        $student_arr['primary_pass_fail_status']=1;
                        $student_arr['exam_held']=1;
                    }
                    else{
                        $student_arr['primary_pass_fail_status']=0;
                        $student_arr['exam_held']=1;
                    }

                }
                else{
                    $student_arr['primary_pass_fail_status']=0;
                    $student_arr['exam_held']=1;
                }

            }
            else{
                $student_arr['primary_pass_fail_status']=1;
                $student_arr['exam_held']=0;
            }



            $student_array[$key]=array_merge($student_arr, $value->toArray());
        }

        return $student_array;

    }


    public function publishPauseResultToEmployeeStudentPanel(Request $request){

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');



        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->update([
                'result_employee_publish_status'=>$request->result_employee_publish_status,
                'result_student_publish_status'=>$request->result_student_publish_status,
            ]);


        if($request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Published to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Pause to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }

    }


    public function deleteResultToEmployeeStudentPanel(Request $request){

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');



        SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->delete();




        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->delete();
        return Response::json(['message' => 'Result Deleted Successfully!', 'mode' => 'delete!'], 200);

    }


    //============================Combine Result Generate====================================


    public function getSiteBaseCombineResultTypeListForResultGenerate(Request $request){

        $data = $request->all();

        $getStudentIDs=StudentHistory::where('academic_year_id', $request->academic_year_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
//            ->where('status', true)
        ->pluck('id');

        $resultSettingList = SiteResultCombineSetting::with(['academicResultCombineType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $academic_result_combine_type_Ids=$resultSettingList->pluck('academic_result_combine_type_id')->unique()->filter();

        $combine_array=[];
        foreach ($academic_result_combine_type_Ids as $key => $value){

            $check_primary_type_Ids=$resultSettingList->where('academic_result_combine_type_id', $value)
                ->pluck('academic_result_primary_type_id')->unique();
               
            $siteExamDeclares_primary_type_ids=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentIDs)
                ->whereIn('academic_result_primary_type_id', $check_primary_type_Ids)
                ->pluck('academic_result_primary_type_id')->unique();
              //  dd($siteExamDeclares_primary_type_ids);
            if(count($check_primary_type_Ids)==count($siteExamDeclares_primary_type_ids)){
                $combine_list=$resultSettingList->where('academic_result_combine_type_id', $value)->first();
               
                $combine_array[]=$combine_list->academic_result_combine_type_id;
            }
        }
       
        $academic_result_combine_type=AcademicResultCombineType::whereIn('id', $combine_array)->get();

        $test_arr=Array();
        $resultlist=[];
        foreach ($academic_result_combine_type as $key => $value){

            $test_arr['loading_result_generate_image']=false;
            $resultlist[$key]=array_merge($test_arr, $value->toArray());
        }
        return $resultlist;
    }

    public function createUpdateCombineTypeResultListForResultGenerate(Request $request){

        $data = $request->all();

        $getStudentIDs=StudentHistory::where('academic_year_id', $request->academic_year_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
//            ->where('status', true)
      //  ->take(20)
        ->pluck('id');

        $CombineResultSettingList = SiteResultCombineSetting::with(['academicResultCombineType'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('academic_result_combine_type_id', $request->academic_result_combine_type_id)
            ->where('status', true)
            ->get();

        $primary_result_ids=$CombineResultSettingList->pluck('academic_result_primary_type_id')->unique();
        $marks_percentage_status=$CombineResultSettingList->first();

        $primary_result_list=SiteStudentPrimaryResultDetailForTabulation::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id',
                'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number');

            $query->with(['student' => function ($q) {
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }, 'academicResultPrimaryType'])

        ->whereIn('student_history_id', $getStudentIDs)
            ->whereIn('academic_result_primary_type_id', $primary_result_ids)
            ->get();
            
           // return $primary_result_list;
        $attendant_student_ids=$primary_result_list->pluck('student_history_id')->unique()->filter();

        $student_array=[];
        $student_array2=[];

        foreach ($attendant_student_ids as $key => $value){

            ///////////

            $getStudent=StudentHistory::with('student')
            ->where('id', $value)
            ->first();
            
            $single_student_primary_result_list=$primary_result_list->where('student_history_id', $value);
            $site_individual_combine_subject_result_store_array=[];
            foreach ($CombineResultSettingList as $keys => $values){

                    $check_primary_result=$single_student_primary_result_list
                        ->where('academic_result_primary_type_id', $values->academic_result_primary_type_id)
                        ->first();
                        
                    if($check_primary_result){
                        foreach ($check_primary_result->site_individual_combine_subject_result_store_ids as $keyst => $valuest){
                           
                            $site_individual_combine_subject_result_store_array[]=$valuest;
                        }
                    }
            }

            $site_individual_combine_subject_result_store_groupby=collect($site_individual_combine_subject_result_store_array)
                ->groupBy('exam_dependent_academic_subject_id');

            $subject_arr=Array();
            $sudent_subject_info=[];
            $subject_array=[];
            $total_marks = [];
           
            foreach ($site_individual_combine_subject_result_store_groupby as $keysr => $valuesr){

                if(count($valuesr)==1){
                  //  dd($valuesr);
                    $subject_arr['raw_average_total_marks']=$valuesr[0]->raw_total_marks;
                    $subject_arr['obtain_average_subject_total_marks']=$valuesr[0]->obtain_subject_total_marks;
                    $subject_arr['subject_average_marks_percentage']=$valuesr[0]->subject_marks_percentage;
                    $subject_arr['obtain_average_raw_total_marks']=$valuesr[0]->obtain_raw_total_marks;
                    $subject_arr['obtain_average_percent_total_marks']=$valuesr[0]->obtain_percent_total_marks;
                    $subject_arr['subject_position']=$valuesr[0]->subject_position;
                    
                    $subject_array[$keysr]=array_merge($subject_arr, $valuesr->toArray());
                    $raw_total_marksee=collect($subject_array)->sum('subject_marks_percentage');
                }
                else{

                    $student_subject_exam_arr=Array();
                    $student_subject_exam_array=[];


                    foreach ($CombineResultSettingList as $keys => $values){

                        $check_primary_result_list=$valuesr
                            ->where('academic_result_primary_type_id', $values->academic_result_primary_type_id)
                            ->first();
                           
                        if($check_primary_result_list){

                            if($marks_percentage_status->marks_percentage){
                                $student_subject_exam_arr['academic_result_primary_type_id']=$check_primary_result_list->academic_result_primary_type_id;
                                $student_subject_exam_arr['exam_dependent_academic_subject_id']=$check_primary_result_list->exam_dependent_academic_subject_id;
                                $student_subject_exam_arr['optional_academic_subject_status']=$check_primary_result_list->optional_academic_subject_status;
                                $student_subject_exam_arr['subject_base_pass_fail_status']=$check_primary_result_list->subject_base_pass_fail_status;
                                $student_subject_exam_arr['result_show_in_table_bellow_status']=$check_primary_result_list->result_show_in_table_bellow_status;
                                $student_subject_exam_arr['subject_position']=$check_primary_result_list->subject_position;
                                $student_subject_exam_arr['raw_total_marks']=$check_primary_result_list->raw_total_marks*$values->marks_percentage/100;
                                $student_subject_exam_arr['obtain_subject_total_marks']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                                    *$check_primary_result_list->obtain_subject_total_marks/$check_primary_result_list->raw_total_marks;
                                $student_subject_exam_arr['subject_marks_percentage']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                    *$check_primary_result_list->subject_marks_percentage/$check_primary_result_list->raw_total_marks;
                                $student_subject_exam_arr['obtain_raw_total_marks']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                    *$check_primary_result_list->obtain_raw_total_marks/$check_primary_result_list->raw_total_marks;
                                $student_subject_exam_arr['obtain_percent_total_marks']=($check_primary_result_list->raw_total_marks*$values->marks_percentage/100)
                                    *$check_primary_result_list->obtain_percent_total_marks/$check_primary_result_list->raw_total_marks;


                                $student_subject_exam_array[$keys]=array_merge($student_subject_exam_arr);

                            }else{
                                $student_subject_exam_array[$keys]=$check_primary_result_list;
                            }
                          
                        }
                       
                    }
                    $first_value_of_data=collect($student_subject_exam_array)->first();

                    $subject_arr['academic_result_primary_type_id']=$first_value_of_data['academic_result_primary_type_id'];
                    $subject_arr['exam_dependent_academic_subject_id']=$first_value_of_data['exam_dependent_academic_subject_id'];
                    $subject_arr['result_show_in_table_bellow_status']=$first_value_of_data['result_show_in_table_bellow_status'];
                    $subject_arr['subject_position']=$first_value_of_data['subject_position'];

                    
                    $optional_subject_present=collect($student_subject_exam_array)
                        ->pluck('optional_academic_subject_status')
                        ->unique()
                        ->filter();
                    $subject_arr['optional_academic_subject_status']=count($optional_subject_present)>0?1:0;

                    $subject_base_pass_fail_count=collect($student_subject_exam_array)
                        ->sum('subject_base_pass_fail_status');
                    $subject_arr['subject_base_pass_fail_status']=$subject_base_pass_fail_count/count(collect($student_subject_exam_array))==1?1:0;

                    $raw_total_marks=collect($student_subject_exam_array)
                        ->sum('raw_total_marks');
                    $subject_arr['raw_total_marks']=$raw_total_marks;


                    $obtain_subject_total_marks=collect($student_subject_exam_array)
                        ->sum('obtain_subject_total_marks');
                    $subject_arr['obtain_subject_total_marks']=$obtain_subject_total_marks;


                    $subject_marks_percentage=collect($student_subject_exam_array)
                        ->sum('subject_marks_percentage');
                    $subject_arr['subject_marks_percentage']= number_format((float)$subject_marks_percentage, 2, '.', '');


                    $obtain_raw_total_marks=collect($student_subject_exam_array)
                        ->sum('obtain_raw_total_marks');
                    $subject_arr['obtain_raw_total_marks']=$obtain_raw_total_marks;


                    $obtain_percent_total_marks=collect($student_subject_exam_array)
                        ->sum('obtain_percent_total_marks');
                    $subject_arr['obtain_percent_total_marks']=$obtain_percent_total_marks;

                    if($marks_percentage_status->marks_percentage){

                        $subject_arr['raw_average_total_marks']=$raw_total_marks;
                        $subject_arr['obtain_average_subject_total_marks']=$obtain_subject_total_marks;
                        $subject_arr['subject_average_marks_percentage']=$subject_marks_percentage;
                        $subject_arr['obtain_average_raw_total_marks']=$obtain_raw_total_marks;
                        $subject_arr['obtain_average_percent_total_marks']=$obtain_percent_total_marks;

                    }else{
                        $subject_arr['raw_average_total_marks']=$raw_total_marks/count(collect($student_subject_exam_array));
                        $subject_arr['obtain_average_subject_total_marks']=$obtain_subject_total_marks/count(collect($student_subject_exam_array));
                        $subject_arr['subject_average_marks_percentage']=$subject_marks_percentage/count(collect($student_subject_exam_array));
                        $subject_arr['obtain_average_raw_total_marks']=$obtain_raw_total_marks/count(collect($student_subject_exam_array));
                        $subject_arr['obtain_average_percent_total_marks']=$obtain_percent_total_marks/count(collect($student_subject_exam_array));
                    }
                    
                    $subject_array[$keysr]=array_merge($subject_arr, $valuesr->toArray());
                   
                  //  $total_marks[$keysr]= $subject_array;
                  $raw_total_marksee=collect($subject_array)->sum('subject_marks_percentage');
                 
                }
              
            }


         
            usort($subject_array, function($a, $b) {
                return $a['subject_position'] > $b['subject_position'] ? 1 : -1;
            });

            $grade_list=SiteResultSystemSetting::with(['academicResultSystem'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
//            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            // ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            //     return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            // })
            ->where('status', true)
            ->get();

            $average_marks = $raw_total_marksee/count(collect($subject_array));

            $total_grade=$grade_list
            ->where('number_from', '<=', $average_marks)
            ->Where('number_to', '>=', $average_marks)
            ->first();

            $sudent_subject_info['subjects'] = $subject_array;
            $sudent_subject_info['student_name']=$getStudent->full_name;
            $sudent_subject_info['combine_total_percent_marks']= number_format((float)$raw_total_marksee, 2, '.', '');
            $sudent_subject_info['combine_total_average_percent_marks'] = number_format((float)$average_marks, 2, '.', '');
           
            $sudent_subject_info['combine_grade_point']=$total_grade->point;
            $sudent_subject_info['combine_grade']=$total_grade->academicResultSystem->name;

            $student_array[$key]=$sudent_subject_info;
      
        
        }
         //// all academic subject list 
          
        //  $placeholders = implode(',',array_fill(0, count($getStudentIDs), '?'));
        //  $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
        //      $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
        //          'academic_session_id', 'academic_student_category_id', 'board_registration_number',
        //          'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
        //          'registration_no');
        //      $query->with(['student' => function ($q) {
        //          $q->with('latestPhoto');
        //          $q->select('id');
        //          $q->where('user_type', 'student');
        //      },
        //          'year', 'shift','department','stClass','classGroup','session','section'
        //      ]);
        //  }, 'academicResultPrimaryType'])
        //      ->whereIn('student_history_id', $getStudentIDs)
        //     /// ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        //      ->where('status', true)
        //      ->orderByRaw("field(student_history_id,{$placeholders})", $getStudentIDs)
        //      ->get();
             
        //  $subject_id_array=[];
        //  foreach ($dataaa as $key => $value){
 
        //      $subject_id_array[]=$value['site_individual_combine_subject_result_store_ids']
        //          ->pluck('exam_dependent_academic_subject_id');
 
        //  }
 
        //  $selected_subject_ids=collect($subject_id_array)->collapse()->unique()->filter()->values();
        //  //dd($selected_subject_ids);
        //  $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam','onlyresultshow'])
        //      ->pluck('id');
 
         
        //     $independent_subject_list=SubjectGroupConditionSetting::with(['academicSubjectClassExamCondition'])
        //     ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
        //         return $query->where('academic_year_id', $data['academic_year_id']);
        //     })
        //     ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
        //         return $query->where('academic_department_id', $data['academic_department_id']);
        //     })
        //     ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
        //         return $query->where('academic_class_id', $data['academic_class_id']);
        //     })
        //     ->whereIn('academic_subject_id', $selected_subject_ids)
        //     ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
        //     ->orderBy('subject_position')
        //     ->select('id', 'academic_subject_id', 'subject_position', 'academic_subject_condition_ids')
        //     ->get();

        // $subject_serial=SubjectGroupConditionSetting::with(['academicSubjectClassExamCondition'])
        //     ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
        //         return $query->where('academic_year_id', $data['academic_year_id']);
        //     })
        //     ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
        //         return $query->where('academic_department_id', $data['academic_department_id']);
        //     })
        //     ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
        //         return $query->where('academic_class_id', $data['academic_class_id']);
        //     })
        //     ->whereIn('exam_dependent_academic_subject_id', $selected_subject_ids)
        //     ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
        //     ->orderBy('subject_position')
        //     ->select('id', 'academic_subject_id', 'academic_subject_condition_ids', 'subject_position', 'exam_dependent_academic_subject_id')
        //     ->get();


        //         $dependent_subject=[];
        //         foreach ($subject_serial as $key => $value){

        //             if($value->academic_subject_id!=$value->exam_dependent_academic_subject_id){
        //                 foreach ($value->academicSubjectConditions as $keys => $values){

        //                     if($values->condition_key!="religion"){
        //                         $dependent_subject[]=$value;
        //                     }
        //                 }
        //             }
        //         }

        //         $final_subject_arr=Array();
        //         $final_subject_array=[];
        //         foreach ($independent_subject_list as $key => $value){

        //             $check_value=collect($dependent_subject)->where('exam_dependent_academic_subject_id', $value->academic_subject_id);

        //             if(count($check_value)>0){
        //                 $final_subject_arr['dependent_subject_list']=$check_value;
        //                 $final_subject_arr['count_dependent_subject']=count($check_value);
        //             }
        //             else{
        //                 $final_subject_arr['dependent_subject_list']=[];
        //                 $final_subject_arr['count_dependent_subject']=0;
        //             }

        //             $final_subject_array[$key]=array_merge($final_subject_arr, $value->toArray());
        //         }
                    return $student_array;
                    //    return [$student_array, $final_subject_array];
            }

}
