<?php

namespace App\Http\Controllers\Site\Result\Report;

use App\Forms\DataHelper;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicResultSystem;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicVersion;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Traits\Site\GlobalFunctionsTrait;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\AcademicYear\AcademicYear;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicResultCombineType;
use PDF;
use Response;
use App\Models\Site\SiteInfo;
use Session;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Result\SiteStudentCombineResultDetail;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;

class SiteCombineResultStatisticsController extends ProjectController
{

    use DataHelper, GlobalFunctionsTrait;

    private $carbon_now;

    private $studentHistory;
    private $student;

    public function __construct(Student $student, StudentHistory $studentHistory)
    {

        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->carbon_now = Carbon::now();

        $this->studentHistory = $studentHistory;
        $this->student = $student;
    }

    public function index()
    {
        $viewType = 'Site Result Report';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.result.site-base-result-report', compact('viewType'));

    }


    public function getSiteBaseCombineResultList(Request $request){

        $data = $request->all();

        $studentList=$this->getStudenthistoryList($request);
       // dd($studentList);
        $student_ids=$studentList->pluck('id');
        $primary_exam_type_ids=SiteStudentCombineResultDetail::whereIn('student_history_id', $student_ids)
            ->pluck('academic_result_combine_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list=AcademicResultCombineType::whereIn('id', $primary_exam_type_ids)->get(['id', 'name']);

        return $result_primary_type_list;
        
    }

    public function getSiteExamCombineResultShortList(Request $request){
        //$data = $request->all();
        if(!$this->checkSiteGroupResultPermission($request)){
          return Response::json(['message'=>'You have no permission!'],401);
      }
         $studentList=$this->getStudentList($request);
  
        $student_ids=$studentList->pluck('id');

        $placeholders = implode(',',array_fill(0, count($student_ids), '?'));

        $studentResultList=SiteStudentCombineResultDetail::with('studentHistory')
            ->whereIn('student_history_id', $student_ids)
            ->where('academic_result_combine_type_id', $request->academic_result_combine_type_id)
            ->select('student_history_id','grade','gpa','student_rank','total_marks')
            ->orderByRaw("field(student_history_id,{$placeholders})", $student_ids)
            ->get();

            $resultArray=[];
            $key=0;

            foreach($studentResultList as $result){
                $resultArray[$key]['student_roll_number']=$result->studentHistory->student_roll_number;
                $resultArray[$key]['student_full_name']=$result->studentHistory->full_name;
                $resultArray[$key]['total_marks']=$result->total_marks;
                $resultArray[$key]['grade']=$result->grade;
                $resultArray[$key]['gpa']=$result->gpa;
                $resultArray[$key]['student_rank']=$result->student_rank;
                $key++;
            }


        $primaryResult = $this->getSiteCombineResultTwoTotalStatistics($request);
        
        return [collect($resultArray),$primaryResult];
  
      }



    
    public function getSiteCombineResultTwoTotalStatistics(Request $request){

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }
      

        $getStudentList=$this->getStudentList($request);

      //  $getStudentList=$getStudents->where('status',true);
        //->where('status', true)
       // dd($getStudentList);

        $primary_result_all_student_list=SiteStudentCombineResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_combine_type_id', $request->academic_result_combine_type_id)
            ->select('id', 'student_history_id', 'fail_subject_count', 'grade')
            ->get();
        
           // dd(count($primary_result_all_student_list));

        $totalPerticepentStudent = count($primary_result_all_student_list);
        $totalStudent = count($getStudentList);

        /////////////////////

        /// passed student 
        $student_grade_list=$primary_result_all_student_list;//->where('exam_attendance_status', true);

        $passed_student_roll_list=$student_grade_list->where('fail_subject_count', '=', 0)
            ->pluck('student_history_id')
            ->unique();
        $passed_student_count=count($passed_student_roll_list);
        
        /// fail student 

        $failed_student_roll_list=$student_grade_list->where('fail_subject_count', '>', 0)
        ->pluck('student_history_id')
        ->unique();

        // absent student

           //===========All Absent Student
           $absent_student_list=SiteStudentCombineResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
           ->where('academic_result_combine_type_id', $request->academic_result_combine_type_id)
        //   ->where('exam_attendance_status', false)
           ->select('id', 'student_history_id')
           ->get();


       $absent_student_roll_list=$absent_student_list
           ->pluck('student_history_id')
           ->unique();

       $absent_student_count=count($absent_student_roll_list);

        // check section
        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
       
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }

        $failed_student_count=count($failed_student_roll_list);
       
        $classList = AcademicClass::where('id', $request->academic_class_id)->get();

        $class_group_ids = $getStudentList->pluck('academic_class_group_id')
        ->unique()
        ->filter();

      //  dd($class_group_ids);


    if (count($class_group_ids) > 0) {

        $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


        $class_group_arr = Array();
        $class_group_array = [];
        foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

            $filtered_class_group_list = $getStudentList
                ->where('academic_class_group_id', $valueClassGroup->id);


            $group_base_student_result=$primary_result_all_student_list
                ->whereIn('student_history_id', $filtered_class_group_list->pluck('id'));

            $group_base_pass_student_count=$group_base_student_result
                ->where('fail_subject_count', 0)
            //    ->where('exam_attendance_status', true)
                ->count();
            $group_base_fail_student_count=$group_base_student_result
                ->where('fail_subject_count', '>' , 0)
            //    ->where('exam_attendance_status', true)
                ->count();


            $group_base_attend_student_count=$group_base_student_result
            //    ->where('exam_attendance_status', true)
                ->count();
            $group_base_absent_student_count=$group_base_student_result
            //    ->where('exam_attendance_status', false)
                ->count();

            $group_passed_percentage=($group_base_pass_student_count*100)/count($filtered_class_group_list);

            $class_group_arr['group_name'] = $valueClassGroup->group_name;
            $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);
            $class_group_arr['class_group_perticepent_student_count'] = count($group_base_student_result);
            $class_group_arr['class_group_passed_student_count'] = $group_base_pass_student_count;
            $class_group_arr['class_group_failed_student_count'] = $group_base_fail_student_count;

            $class_group_arr['class_group_present_student_count'] = $group_base_attend_student_count;
            $class_group_arr['class_group_absent_student_count'] = $group_base_absent_student_count;
            $class_group_arr['group_passed_percentage'] = number_format((float)$group_passed_percentage, 2, '.', '');


            $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                ->unique()
                ->filter();

            $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

            $class_group_arr['count_class_group_row'] = count($sectionList);


            $section_arr = Array();
            $section_array = [];
            foreach ($sectionList as $keySection => $valueSection) {

                $filtered_section_list = $filtered_class_group_list
                    ->where('academic_section_id', $valueSection->id);


                $section_base_student_result=$group_base_student_result
                    ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                $section_base_pass_student_count=$section_base_student_result
                    ->where('fail_subject_count', 0)
                 //   ->where('exam_attendance_status', true)
                    ->count();
                $section_base_fail_student_count=$section_base_student_result
                    ->where('fail_subject_count', '>' , 0)
                //    ->where('exam_attendance_status', true)
                    ->count();

                $section_base_attend_student_count=$section_base_student_result
                //    ->where('exam_attendance_status', true)
                    ->count();
                $section_base_absent_student_count=$section_base_student_result
                //    ->where('exam_attendance_status', false)
                    ->count();

                $section_passed_percentage=($section_base_pass_student_count*100)/count($filtered_section_list);

                $section_arr['section_name'] = $valueSection->section_name;
                $section_arr['class_section_count'] = count($filtered_section_list);
                $section_arr['class_section_perticepent_student_count'] = count($section_base_student_result);
                $section_arr['class_section_passed_count'] = '';
                $section_arr['class_section_failed_count'] = '';


                $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                $section_arr['class_section_absent_count'] = '';
                $section_arr['section_passed_percentage'] ='';


                $section_array[$keySection] = $section_arr;
            }

            $class_group_arr['section_array'] = $section_array;

            $class_group_array[$keyClassGroup] = $class_group_arr;

        }


    }
    else {

        $section_ids = $getStudentList->pluck('academic_section_id')
            ->unique()
            ->filter();

        $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

        $section_arr = Array();
        $section_array = [];
        foreach ($sectionList as $keySection => $valueSection) {

            $filtered_section_list = $getStudentList
                ->where('academic_section_id', $valueSection->id);

            $section_base_student_result=$primary_result_all_student_list
                ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

            $section_base_pass_student_count=$section_base_student_result
                ->where('fail_subject_count', 0)
            //    ->where('exam_attendance_status', true)
                ->count();
            $section_base_fail_student_count=$section_base_student_result
                ->where('fail_subject_count', '>' , 0)
          //      ->where('exam_attendance_status', true)
                ->count();


            $section_base_attend_student_count=$section_base_student_result
              //  ->where('exam_attendance_status', true)
                ->count();
            $section_base_absent_student_count=$section_base_student_result
            //    ->where('exam_attendance_status', false)
                ->count();




            $section_arr['section_name'] = $valueSection->section_name;
            $section_arr['class_section_count'] = count($filtered_section_list);
            $section_arr['class_section_passed_count'] = '';
            $section_arr['class_section_failed_count'] = '';

            $section_arr['class_section_present_count'] = $section_base_attend_student_count;
            $section_arr['class_section_absent_count'] = '';

            $section_array[$keySection] = $section_arr;

        }


    }
        // student merit list
        $student_history_ids=$getStudentList->pluck('id');
        $merit_list=$this->studentMeritList($request,$student_history_ids);

   
       
        $class_passed_percentage=($passed_student_count*100)/$totalStudent;

        $student_array=[];

        $student_array['total_student']=$totalStudent;
        $student_array['total_perticepent_student']=$totalPerticepentStudent;
        $student_array['passed_student_count']=$passed_student_count;
        $student_array['failed_student_count']=$failed_student_count;
        $student_array['absent_student_count']=$absent_student_count;
        $student_array['department_present']=$department_present;
        $student_array['class_group_present']=$class_group_present;
        $student_array['section_present']=$section_present;

        $student_array['class_passed_percentage']=number_format((float)$class_passed_percentage, 2, '.', '');
        $student_array['group_section_array']=[];
        $student_array['merit_list']=$merit_list;
        
       // dd($class_group_array);

          return $student_array;  // this function use in another function


        }

        private function getStudenthistoryList(Request $request){
      
        
            $data = $request->all();
            $studentList = StudentHistory::select('id', 'user_id','student_roll_number','site_batch_detail_id')
                ->with(['student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id');
                    $q->where('user_type', 'student');
                },
                    'year', 'shift','department','batch','stClass','classGroup','session','section'
                ])
                ->where('academic_version_id', $request->academic_version_id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                // ->when(!empty($data['status']), function ($query) use ($data) {
                //     return $query->where('status', $data['status']);
                // })
                //->where('status',true)
                ->orderBy('student_roll_number')
                ->orderBy('academic_section_id')
                ->orderBy('academic_class_id')
                ->orderBy('academic_department_id')
                ->orderBy('site_batch_detail_id')
                ->orderBy('academic_class_group_id')
                ->get();
    
        //    dd($studentList);
            return $studentList;
        
        }


    public function getSitePrimaryResultTotalStatistics(Request $request){

        $data = $request->all();

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }
      
        $getStudentList=$this->getStudentList($request);



        $primary_result_all_student_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade')
            ->get();

        $totalStudent = count($getStudentList);

        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }


        $version_arr = Array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $verstion_base_student_result=$primary_result_all_student_list
                ->whereIn('student_history_id', $filtered_version_list->pluck('id'));

            $version_base_attend_student_count=$verstion_base_student_result
                ->where('exam_attendance_status', true)
                ->count();
            $version_base_absent_student_count=$verstion_base_student_result
                ->where('exam_attendance_status', false)
                ->count();

            $version_base_pass_student_count=$verstion_base_student_result
                ->where('fail_subject_count', 0)
                ->where('exam_attendance_status', true)
                ->count();
            $version_base_fail_student_count=$verstion_base_student_result
                ->where('fail_subject_count', '>' , 0)
                ->where('exam_attendance_status', true)
                ->count();

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);
            $version_arr['version_passed_student_count'] = $version_base_pass_student_count;
            $version_arr['version_failed_student_count'] = $version_base_fail_student_count;
            $version_arr['version_present_student_count'] = $version_base_attend_student_count;
            $version_arr['version_absent_student_count'] = $version_base_absent_student_count;


            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();


            $shift_arr = Array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {


                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);


                $shift_base_student_result=$verstion_base_student_result
                    ->whereIn('student_history_id', $filtered_shift_list->pluck('id'));


                $shift_base_attend_student_count=$shift_base_student_result
                    ->where('exam_attendance_status', true)
                    ->count();
                $shift_base_absent_student_count=$shift_base_student_result
                    ->where('exam_attendance_status', false)
                    ->count();

                $shift_base_pass_student_count=$shift_base_student_result
                    ->where('fail_subject_count', 0)
                    ->where('exam_attendance_status', true)
                    ->count();
                $shift_base_fail_student_count=$shift_base_student_result
                    ->where('fail_subject_count', '>' , 0)
                    ->where('exam_attendance_status', true)
                    ->count();

                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);
                $shift_arr['shift_passed_student_count'] = $shift_base_pass_student_count;
                $shift_arr['shift_failed_student_count'] = $shift_base_fail_student_count;

                $shift_arr['shift_present_student_count'] = $shift_base_attend_student_count;
                $shift_arr['shift_absent_student_count'] = $shift_base_absent_student_count;


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();


                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = Array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);


                        $department_base_student_result=$shift_base_student_result
                            ->whereIn('student_history_id', $filtered_department_list->pluck('id'));

                        $department_base_pass_student_count=$department_base_student_result
                            ->where('fail_subject_count', 0)
                            ->where('exam_attendance_status', true)
                            ->count();
                        $department_base_fail_student_count=$department_base_student_result
                            ->where('fail_subject_count', '>' , 0)
                            ->where('exam_attendance_status', true)
                            ->count();


                        $department_base_attend_student_count=$department_base_student_result
                            ->where('exam_attendance_status', true)
                            ->count();
                        $department_base_absent_student_count=$department_base_student_result
                            ->where('exam_attendance_status', false)
                            ->count();

                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);
                        $department_arr['department_passed_student_count'] = $department_base_pass_student_count;
                        $department_arr['department_failed_student_count'] = $department_base_fail_student_count;

                        $department_arr['department_attend_student_count'] = $department_base_attend_student_count;
                        $department_arr['department_absent_student_count'] = $department_base_absent_student_count;


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount($classList,
                            $filtered_department_list, $class_group_present, $department_base_student_result);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;

                    }


                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();

                    $class_array = $this->getClassGroupSectionCount($classList,
                        $filtered_shift_list, $class_group_present, $shift_base_student_result);


                }


                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);

                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }

                $shift_array[$keyShift] = $shift_arr;
            }

            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;

        }
     
        $student_grade_list=$primary_result_all_student_list->where('exam_attendance_status', true);

        $site_result_system_setting=SiteResultSystemSetting::where('academic_year_id', $data['academic_year_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_class_id', $data['academic_class_id'])
            ->when($data['academic_department_id'], function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->get();

        $academic_result_system_list=AcademicResultSystem::
            whereIn('id', $site_result_system_setting->pluck('academic_result_system_id')->unique())
            ->get();



        $result_arr=Array();
        $result_array=[];
        foreach ($academic_result_system_list as $key => $value) {

            $student_history_number_list=$student_grade_list
                ->where('grade', $value->name)
                ->pluck('student_history_id')
                ->unique();

            $student_list_grade=$getStudentList->whereIn('id', $student_history_number_list)->pluck('id');
                
            $check_grade_list=$student_grade_list->where('grade', $value->name)->count();

            $check_grade_setting=$site_result_system_setting->where('academic_result_system_id', $value->id)->first();

            $result_arr['id']=$value->id;
            $result_arr['grade']=$value->name;
            $result_arr['student_count']=$check_grade_list;
            $result_arr['point']=$check_grade_setting->point;
            $result_arr['number_from']=$check_grade_setting->number_from;
            $result_arr['number_to']=$check_grade_setting->number_to;
            $result_arr['grade_student_ids']=$student_list_grade->values();

            $result_array[$key]=$result_arr;
        }


        $student_grade_count=collect($result_array)->values();

       

        //===============All Passed Student

        $passed_student_roll_list=$student_grade_list->where('fail_subject_count', '=', 0)
            ->pluck('student_history_id')
            ->unique();

        $passed_student_count=count($passed_student_roll_list);

       // $assending_passed_roll_number= $getStudentList->whereIn('id', $passed_student_roll_list);
        $assending_passed_roll_number= StudentHistory::whereIn('id', $passed_student_roll_list)
                                ->orderBy('student_roll_number')
                                ->get();

        $passed_student_rolls=$assending_passed_roll_number->values();
     
        //==============All Failed Student
        $failed_student_roll_list=$student_grade_list->where('fail_subject_count', '>', 0)
            ->pluck('student_history_id')
            ->unique();

       // dd($failed_student_roll_list);

        $failed_student_count=count($failed_student_roll_list);
     //   $assending_failed_roll_number=$getStudentList->whereIn('id', $failed_student_roll_list);
        $assending_failed_roll_number= StudentHistory::whereIn('id', $failed_student_roll_list)
                                ->orderBy('student_roll_number')
                                ->get();

        $failed_student_rolls=$assending_failed_roll_number->values();
    
    
        //===========All Absent Student
        $absent_student_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('exam_attendance_status', false)
            ->select('id', 'student_history_id')
            ->get();


        $absent_student_roll_list=$absent_student_list
            ->pluck('student_history_id')
            ->unique();

        $absent_student_count=count($absent_student_roll_list);

       // $assending_absent_roll_number=$getStudentList->whereIn('id', $absent_student_roll_list);
        $assending_absent_roll_number= StudentHistory::whereIn('id', $absent_student_roll_list)
                                ->orderBy('student_roll_number')
                                ->get();

        $absent_student_rolls=$assending_absent_roll_number->values();

        return response()->json(
            [
                 'student_count_array'=>$student_count_array,
                 'department_present'=>$department_present,
                 'class_group_present'=>$class_group_present,
                 'section_present'=>$section_present,
                 'totalStudent'=>$totalStudent,
                 'student_grade_count'=>$student_grade_count,
                 'passed_student_rolls'=>$passed_student_rolls,
                 'failed_student_rolls'=>$failed_student_rolls,
                 'absent_student_rolls'=>0,

                 'passed_student_count'=>$passed_student_count,
                 'failed_student_count'=>$failed_student_count,
                 'absent_student_count'=>$absent_student_count,
            ]);
//        return compact('student_count_array', 'department_present', 'class_group_present', 'section_present', 'totalStudent');
    }

    public function getSiteExamCombineResultShortListPdf(Request $request){
        ini_set('memory_limit', '-1');

        $getData = $this->getSiteExamCombineResultShortList($request);
        
        $resultList=$getData[0];
        $primaryResult=$getData[1];
       
      
        $data = $request->all();
        $head_signature_status ='';
 
       
        $report_tittle2='';
 
        // institute head
 
        $institute_head = Employee::where('institute_head', 1)->first();
 
        $get_institute_head_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $get_institute_head_designation = $institute_head->designation->name ?? 'Institution Head';
    
       // result name and year
 
       $result = AcademicResultCombineType::findOrFail($request->academic_result_combine_type_id);
 
       $result_name=$result->name;
       $year=AcademicYear::findOrFail($request->academic_year_id);
       $year_name=$year->year_name;
        
       $result_name .=', '.$year_name;
       $report_tittle ='';
 
        //============ domain name =============
        $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
        $alias = $site_info->site_alias;

        if($site_info->domain_name==null){
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
 
            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }

        $report_tittle .=$result_name;
        $report_tittle .= '<br/>';
        $report_tittle .= 'Exam Short Result';

        $class_group=AcademicClassGroup::find($request->academic_class_group_id);
        $class=AcademicClass::find($request->academic_class_id);
        $section=AcademicSection::find($request->academic_section_id);
    
        $report_tittle2 .= 'Year : '.$year_name;
       
 
        if($class){
         $academic_class=$class?$class->class_name:'';
         $report_tittle2 .= ', Class : '.$academic_class;
  
        }
 
        if($class_group){
         $academic_class_group=$class_group?$class_group->group_name:'';
         $report_tittle2 .= ', Group : '.$academic_class_group;
  
        }
 
        if($section){
         $academic_section=$section?$section->section_name:'';
         $report_tittle2 .= ', Section : '.$academic_section;
  
        }

        $column_number=4;
 
         //===========
        
       // if($request->page_orientaion=='portrate'){
            $pdf = PDF::loadView('default.admin.site.result.result_report.combine.site-base-student-exam-combine-result-short-result-report',
                compact('resultList','primaryResult','column_number', 'data','report_tittle', 'report_tittle2', 'domain','result_name','get_institute_head_signature','get_institute_head_designation'))
                ->setWarnings(false);
       // }
   
 
        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id.'-'.$alias.'-'.$result_name.'-'.Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';
 
 
        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);
    }

    public function getSitePrimaryResultTwoTotalStatistics(Request $request){

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }
      

        $getStudentList=$this->getStudentList($request);

      //  $getStudentList=$getStudents->where('status',true);
        //->where('status', true)
       // dd($getStudentList);

        $primary_result_all_student_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade')
            ->get();
        
           // dd(count($primary_result_all_student_list));

        $totalPerticepentStudent = count($primary_result_all_student_list);
        $totalStudent = count($getStudentList);

        /////////////////////

        /// passed student 
        $student_grade_list=$primary_result_all_student_list->where('exam_attendance_status', true);

        $passed_student_roll_list=$student_grade_list->where('fail_subject_count', '=', 0)
            ->pluck('student_history_id')
            ->unique();
        $passed_student_count=count($passed_student_roll_list);
        
        /// fail student 

        $failed_student_roll_list=$student_grade_list->where('fail_subject_count', '>', 0)
        ->pluck('student_history_id')
        ->unique();

        // absent student

           //===========All Absent Student
           $absent_student_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
           ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
           ->where('exam_attendance_status', false)
           ->select('id', 'student_history_id')
           ->get();


       $absent_student_roll_list=$absent_student_list
           ->pluck('student_history_id')
           ->unique();

       $absent_student_count=count($absent_student_roll_list);

        // check section
        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();
       
        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }

        $failed_student_count=count($failed_student_roll_list);
       
        $classList = AcademicClass::where('id', $request->academic_class_id)->get();

        $class_group_ids = $getStudentList->pluck('academic_class_group_id')
        ->unique()
        ->filter();

      //  dd($class_group_ids);


    if (count($class_group_ids) > 0) {

        $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


        $class_group_arr = Array();
        $class_group_array = [];
        foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

            $filtered_class_group_list = $getStudentList
                ->where('academic_class_group_id', $valueClassGroup->id);


            $group_base_student_result=$primary_result_all_student_list
                ->whereIn('student_history_id', $filtered_class_group_list->pluck('id'));

            $group_base_pass_student_count=$group_base_student_result
                ->where('fail_subject_count', 0)
                ->where('exam_attendance_status', true)
                ->count();
            $group_base_fail_student_count=$group_base_student_result
                ->where('fail_subject_count', '>' , 0)
                ->where('exam_attendance_status', true)
                ->count();


            $group_base_attend_student_count=$group_base_student_result
                ->where('exam_attendance_status', true)
                ->count();
            $group_base_absent_student_count=$group_base_student_result
                ->where('exam_attendance_status', false)
                ->count();

            $group_passed_percentage=($group_base_pass_student_count*100)/count($filtered_class_group_list);

            $class_group_arr['group_name'] = $valueClassGroup->group_name;
            $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);
            $class_group_arr['class_group_perticepent_student_count'] = count($group_base_student_result);
            $class_group_arr['class_group_passed_student_count'] = $group_base_pass_student_count;
            $class_group_arr['class_group_failed_student_count'] = $group_base_fail_student_count;

            $class_group_arr['class_group_present_student_count'] = $group_base_attend_student_count;
            $class_group_arr['class_group_absent_student_count'] = $group_base_absent_student_count;
            $class_group_arr['group_passed_percentage'] = number_format((float)$group_passed_percentage, 2, '.', '');


            $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                ->unique()
                ->filter();

            $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

            $class_group_arr['count_class_group_row'] = count($sectionList);


            $section_arr = Array();
            $section_array = [];
            foreach ($sectionList as $keySection => $valueSection) {

                $filtered_section_list = $filtered_class_group_list
                    ->where('academic_section_id', $valueSection->id);


                $section_base_student_result=$group_base_student_result
                    ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                $section_base_pass_student_count=$section_base_student_result
                    ->where('fail_subject_count', 0)
                    ->where('exam_attendance_status', true)
                    ->count();
                $section_base_fail_student_count=$section_base_student_result
                    ->where('fail_subject_count', '>' , 0)
                    ->where('exam_attendance_status', true)
                    ->count();

                $section_base_attend_student_count=$section_base_student_result
                    ->where('exam_attendance_status', true)
                    ->count();
                $section_base_absent_student_count=$section_base_student_result
                    ->where('exam_attendance_status', false)
                    ->count();

                $section_passed_percentage=($section_base_pass_student_count*100)/count($filtered_section_list);

                $section_arr['section_name'] = $valueSection->section_name;
                $section_arr['class_section_count'] = count($filtered_section_list);
                $section_arr['class_section_perticepent_student_count'] = count($section_base_student_result);
                $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                $section_arr['class_section_failed_count'] = $section_base_fail_student_count;


                $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                $section_arr['class_section_absent_count'] = $section_base_absent_student_count;
                $section_arr['section_passed_percentage'] = $section_passed_percentage;


                $section_array[$keySection] = $section_arr;
            }

            $class_group_arr['section_array'] = $section_array;

            $class_group_array[$keyClassGroup] = $class_group_arr;

        }


    }
    else {

        $section_ids = $getStudentList->pluck('academic_section_id')
            ->unique()
            ->filter();

        $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

        $section_arr = Array();
        $section_array = [];
        foreach ($sectionList as $keySection => $valueSection) {

            $filtered_section_list = $getStudentList
                ->where('academic_section_id', $valueSection->id);

            $section_base_student_result=$primary_result_all_student_list
                ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

            $section_base_pass_student_count=$section_base_student_result
                ->where('fail_subject_count', 0)
                ->where('exam_attendance_status', true)
                ->count();
            $section_base_fail_student_count=$section_base_student_result
                ->where('fail_subject_count', '>' , 0)
                ->where('exam_attendance_status', true)
                ->count();


            $section_base_attend_student_count=$section_base_student_result
                ->where('exam_attendance_status', true)
                ->count();
            $section_base_absent_student_count=$section_base_student_result
                ->where('exam_attendance_status', false)
                ->count();




            $section_arr['section_name'] = $valueSection->section_name;
            $section_arr['class_section_count'] = count($filtered_section_list);
            $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
            $section_arr['class_section_failed_count'] = $section_base_fail_student_count;

            $section_arr['class_section_present_count'] = $section_base_attend_student_count;
            $section_arr['class_section_absent_count'] = $section_base_absent_student_count;

            $section_array[$keySection] = $section_arr;

        }


    }
        // student merit list
        $student_history_ids=$getStudentList->pluck('id');
        $merit_list=$this->studentMeritList($request,$student_history_ids);

   
       
        $class_passed_percentage=($passed_student_count*100)/$totalStudent;

        $student_array=[];

        $student_array['total_student']=$totalStudent;
        $student_array['total_perticepent_student']=$totalPerticepentStudent;
        $student_array['passed_student_count']=$passed_student_count;
        $student_array['failed_student_count']=$failed_student_count;
        $student_array['absent_student_count']=$absent_student_count;
        $student_array['department_present']=$department_present;
        $student_array['class_group_present']=$class_group_present;
        $student_array['section_present']=$section_present;

        $student_array['class_passed_percentage']=number_format((float)$class_passed_percentage, 2, '.', '');
        $student_array['group_section_array']=[];
        $student_array['merit_list']=$merit_list;
        
       // dd($class_group_array);

          return $student_array;  // this function use in another function


        }


        public function getSitePrimaryResultReportTwoPdf(Request $request){
        
        ini_set('memory_limit', '-1');

        $result_list_array = $this->getSitePrimaryResultTwoTotalStatistics($request);
       
        $data = $request->all();
        $head_signature_status ='';

        $report_tittle='';
        $report_tittle2='';

        // institute head

        $institute_head = Employee::where('institute_head', 1)->first();
 
        $get_institute_head_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $get_institute_head_designation = $institute_head->designation->name ?? 'Institution Head';
    
       // result name and year

       $result = AcademicResultPrimaryType::findOrFail($request->academic_result_primary_type_id);

       $result_name=$result->name;
       $year=AcademicYear::findOrFail($request->academic_year_id);
       $year_name=$year->year_name;
        
       $result_name .=', '.$year_name;

        //============ domain name =============
        $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
       $alias = $site_info->site_alias;

        if($site_info->domain_name==null){
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }
        $report_tittle .=$result_name;
        $report_tittle .= '<br/>';
        $report_tittle .= 'Total Result Summary';

        $class_group=AcademicClassGroup::find($request->academic_class_group_id);
        $class=AcademicClass::find($request->academic_class_id);
        $section=AcademicSection::find($request->academic_section_id);
    
        $report_tittle2 .= 'Year : '.$year_name;
       
 
        if($class){
         $academic_class=$class?$class->class_name:'';
         $report_tittle2 .= ', Class : '.$academic_class;
  
        }
 
        if($class_group){
         $academic_class_group=$class_group?$class_group->group_name:'';
         $report_tittle2 .= ', Group : '.$academic_class_group;
  
        }
 
        if($section){
         $academic_section=$section?$section->section_name:'';
         $report_tittle2 .= ', Section : '.$academic_section;
  
        }

         //===========
        
       // if($request->page_orientaion=='portrate'){
            $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-exam-result-detail-report-two',
                compact('result_list_array', 'report_tittle', 'report_tittle2', 'domain','result_name','get_institute_head_signature','get_institute_head_designation'))
                ->setWarnings(false);
       // }
   

        $path = storage_path() . '/pdf';
        $time = \Auth::user()->id.'-'.$alias.'-'.$result_name.'-'.Carbon::now()->unix();
        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        $name = $time . '.pdf';


        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);

        }


    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present, $result_list)
    {
        $class_arr = Array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_base_student_result=$result_list
                ->whereIn('student_history_id', $filtered_class_list->pluck('id'));

            $class_base_pass_student_count=$class_base_student_result
                ->where('fail_subject_count', 0)
                ->where('exam_attendance_status', true)
                ->count();
            $class_base_fail_student_count=$class_base_student_result
                ->where('fail_subject_count', '>' , 0)
                ->where('exam_attendance_status', true)
                ->count();

            $class_base_attend_student_count=$class_base_student_result
                ->where('exam_attendance_status', true)
                ->count();
            $class_base_absent_student_count=$class_base_student_result
                ->where('exam_attendance_status', false)
                ->count();




            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);
            $class_arr['class_passed_student_count'] = $class_base_pass_student_count;
            $class_arr['class_failed_student_count'] = $class_base_fail_student_count;

            $class_arr['class_present_student_count'] = $class_base_attend_student_count;
            $class_arr['class_absent_student_count'] = $class_base_absent_student_count;

            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = Array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $group_base_student_result=$class_base_student_result
                        ->whereIn('student_history_id', $filtered_class_group_list->pluck('id'));

                    $group_base_pass_student_count=$group_base_student_result
                        ->where('fail_subject_count', 0)
                        ->where('exam_attendance_status', true)
                        ->count();
                    $group_base_fail_student_count=$group_base_student_result
                        ->where('fail_subject_count', '>' , 0)
                        ->where('exam_attendance_status', true)
                        ->count();


                    $group_base_attend_student_count=$group_base_student_result
                        ->where('exam_attendance_status', true)
                        ->count();
                    $group_base_absent_student_count=$group_base_student_result
                        ->where('exam_attendance_status', false)
                        ->count();



                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);
                    $class_group_arr['class_group_passed_student_count'] = $group_base_pass_student_count;
                    $class_group_arr['class_group_failed_student_count'] = $group_base_fail_student_count;

                    $class_group_arr['class_group_present_student_count'] = $group_base_attend_student_count;
                    $class_group_arr['class_group_absent_student_count'] = $group_base_absent_student_count;


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = Array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_base_student_result=$group_base_student_result
                            ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                        $section_base_pass_student_count=$section_base_student_result
                            ->where('fail_subject_count', 0)
                            ->where('exam_attendance_status', true)
                            ->count();
                        $section_base_fail_student_count=$section_base_student_result
                            ->where('fail_subject_count', '>' , 0)
                            ->where('exam_attendance_status', true)
                            ->count();

                        $section_base_attend_student_count=$section_base_student_result
                            ->where('exam_attendance_status', true)
                            ->count();
                        $section_base_absent_student_count=$section_base_student_result
                            ->where('exam_attendance_status', false)
                            ->count();



                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);
                        $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                        $section_arr['class_section_failed_count'] = $section_base_fail_student_count;


                        $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                        $section_arr['class_section_absent_count'] = $section_base_absent_student_count;


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;


                }


            }
            else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = Array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);



                    $section_base_student_result=$class_base_student_result
                        ->whereIn('student_history_id', $filtered_section_list->pluck('id'));

                    $section_base_pass_student_count=$section_base_student_result
                        ->where('fail_subject_count', 0)
                        ->where('exam_attendance_status', true)
                        ->count();
                    $section_base_fail_student_count=$section_base_student_result
                        ->where('fail_subject_count', '>' , 0)
                        ->where('exam_attendance_status', true)
                        ->count();


                    $section_base_attend_student_count=$section_base_student_result
                        ->where('exam_attendance_status', true)
                        ->count();
                    $section_base_absent_student_count=$section_base_student_result
                        ->where('exam_attendance_status', false)
                        ->count();




                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);
                    $section_arr['class_section_passed_count'] = $section_base_pass_student_count;
                    $section_arr['class_section_failed_count'] = $section_base_fail_student_count;

                    $section_arr['class_section_present_count'] = $section_base_attend_student_count;
                    $section_arr['class_section_absent_count'] = $section_base_absent_student_count;

                    $section_array[$keySection] = $section_arr;

                }

//                            $class_group_arr['section_array']=$section_array;
//                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

//                if($class_group_present){
//                    $class_arr['count_class_row']=count($section_array)*2;
//                }else{
                $class_arr['count_class_row'] = count($section_array);
//                }


            }


            $class_array[$keyClass] = $class_arr;

        }

        return $class_array;
    }

  

    public function getSitePrimaryResultSubjectPassFailStatistics(Request $request){

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }
      
    
        $getStudentList=$this->getStudentList($request);

        $individual_result_list=SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('subject_result_count_status', true)
            ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'exam_dependent_academic_subject_id',
                'subject_base_pass_fail_status', 'exam_attendance_status')
            ->get();

           

        $totalStudent = count($individual_result_list->pluck('student_history_id')->unique()->values());

        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();

        //==========will chnage


        $class_group_base_subject_list=$individual_result_list
            ->pluck('exam_dependent_academic_subject_id')
            ->unique()
            ->values();

            
        $academic_subject_list=AcademicSubject::whereIn('id', $class_group_base_subject_list)->get();

        

        $subject_result_array=[];
        $subject_arr=Array();
        foreach ($academic_subject_list as $keyGroupSub => $valueGroupSub) {


            $student_list=$individual_result_list->where('exam_dependent_academic_subject_id', $valueGroupSub->id);

            $total_student_count=count($student_list);

            $attended_student_count=$student_list->where('exam_attendance_status', true)
                ->count();

            $absent_student_count=$student_list->where('exam_attendance_status', false)
                ->count();

            $passed_student_count=$student_list->where('exam_attendance_status', true)
                ->where('subject_base_pass_fail_status', true)
                ->count();

            $failed_student_count=$student_list->where('exam_attendance_status', true)
                ->where('subject_base_pass_fail_status', false)
                ->count();





            $subject_arr['id']=$valueGroupSub->id;
            $subject_arr['subject_name']=$valueGroupSub->subject_name;
            $subject_arr['total_student_count']=$total_student_count;
            $subject_arr['attended_student_count']=$attended_student_count;
            $subject_arr['absent_student_count']=$absent_student_count;
            $subject_arr['passed_student_count']=$passed_student_count;
            $subject_arr['failed_student_count']=$failed_student_count;


            $subject_result_array[$keyGroupSub]=$subject_arr;
        }

        $faill_subject_count=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('fail_subject_count', '>', 0)
            ->where('exam_attendance_status', true)
//            ->where('subject_base_pass_fail_status', false)
            ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'fail_subject_count')
            ->get();

            

        $failed_count=$faill_subject_count
            ->pluck('fail_subject_count')
            ->unique()
            ->filter();

           

        $failed_subject_arr=Array();
        $failed_subject_list_array=[];
        foreach ($failed_count as $key => $value) {

            $roll_number_list=$faill_subject_count
                ->where('fail_subject_count', $value)
                ->pluck('student_history_id')
                ->unique();

           // $failed_student_ids=$getStudentList->whereIn('id', $roll_number_list)->pluck('id');
            $failed_student_ids= StudentHistory::whereIn('id', $roll_number_list)->get();

            $failed_subject_arr['failed_subject_count']=$value;
            $failed_subject_arr['failed_student_ids']=$failed_student_ids->values();
            $failed_subject_arr['failed_subject_student']=$faill_subject_count
                ->where('fail_subject_count', $value)
                ->count();

            $failed_subject_list_array[$key]=$failed_subject_arr;

        }

        // $failed_subject_list=array_values(array_sort(collect($failed_subject_list_array), function ($value) {
        //     return $value['failed_subject_count'];
        // }));

        
        $failed_subject_list=array_values(array_sort(collect($failed_subject_list_array), function ($value) {
            return $value['failed_subject_count'];
        }));

        return response()->json(
            [
                'subject_result_array'=>$subject_result_array,
                'failed_subject_list'=>collect($failed_subject_list)->values()
            ]);
    }

    public function getSitePrimaryResultTwoSubjectPassFailStatistics(Request $request){

        $data = $request->all();

        if(!$this->checkSiteGroupResultPermission($request)){
            return Response::json(['message'=>'You have no permission!'],401);
        }
    
        $getStudentList=$this->getStudentList($request);

        $individual_result_list=SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('optional_academic_subject_status',false)
            // ->where('exam_dependent_academic_subject_id',1)
             ->where('subject_result_count_status',true)
            // ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'exam_dependent_academic_subject_id',
            //     'subject_base_pass_fail_status', 'exam_attendance_status','subject_grade','subject_point')
            ->orderBy('subject_point','DESC')
            ->get();

          //  return $individual_result_list;
           

       // $gradeCount= count($individual_result_list->pluck('subject_grade')->unique()->values());
        $gradeList= $individual_result_list->pluck('subject_grade')->unique()->values();

      //  dd($gradeList);
        
        // $totalStudent = count($individual_result_list->pluck('student_history_id')->unique()->values());

        // $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        // $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();

        //==========will chnage


        $class_group_base_subject_list=$individual_result_list
            ->pluck('exam_dependent_academic_subject_id')
            ->unique()
            ->values();

        $academic_subject_list=AcademicSubject::whereIn('id', $class_group_base_subject_list)->get();
       
        $subject_result_array=[];
        $subject_arr=Array();
        foreach ($academic_subject_list as $keyGroupSub => $valueGroupSub) {


            $student_list=$individual_result_list->where('exam_dependent_academic_subject_id', $valueGroupSub->id);

          

            $total_student_count=count($student_list);

            $attended_student_count=$student_list->where('exam_attendance_status', true)
                ->count();

            $absent_student_count=$student_list->where('exam_attendance_status', false)
                ->count();

            $passed_student_count=$student_list->where('exam_attendance_status', true)
            //    ->where('subject_base_pass_fail_status', true)
                ->where('subject_point', '>', 0)
                ->count();

            $failed_student_count=$student_list->where('exam_attendance_status', true)
               // ->where('subject_base_pass_fail_status', false)
                ->where('subject_point', 0)
                ->count();

             //   dd($failed_student_count);

                $subjectGradeList=[];

                foreach($gradeList as $keys=>$grade){
                    $grade_student_count=$student_list->where('subject_grade', $grade)
                    ->where('exam_attendance_status',true)
                    ->count();
                    $subjectGradeList[$keys]['subject_grade']=$grade;
                    $subjectGradeList[$keys]['grade_student_count']=$grade_student_count;
                }

            $percentage_passed_student=($passed_student_count*100)/$total_student_count;

            $subject_arr['id']=$valueGroupSub->id;
            $subject_arr['subject_name']=$valueGroupSub->subject_name;
            $subject_arr['total_student_count']=$total_student_count;
            $subject_arr['attended_student_count']=$attended_student_count;
            $subject_arr['absent_student_count']=$absent_student_count;
            $subject_arr['passed_student_count']=$passed_student_count;
            $subject_arr['failed_student_count']=$failed_student_count;
            $subject_arr['subject_grade_list']=$subjectGradeList;
            $subject_arr['percentage_passed_student']=number_format((float)$percentage_passed_student, 2, '.', '');
            $subject_result_array[$keyGroupSub]=$subject_arr;
        }

        $failedPrimaryResultDetailList=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('fail_subject_count', '>', 0)
   //         ->where('exam_attendance_status', true)
//            ->where('subject_base_pass_fail_status', false)
            ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'fail_subject_count')
            ->get();

            

        $failed_count=$failedPrimaryResultDetailList
            ->pluck('fail_subject_count')
            ->unique()
            ->filter();

            ///

           

        $failed_subject_arr=Array();
        $failed_subject_list_array=[];
        foreach ($failed_count as $key => $value) {

        //    dd($value);

            $student_history_ids=$failedPrimaryResultDetailList
                ->where('fail_subject_count', $value)
                ->pluck('student_history_id')
                ->unique();

        
            $value_wise_individual_result_list=$individual_result_list->whereIn('student_history_id',$student_history_ids)
                ->where('subject_point',0);

            $exam_dependent_academic_subject_ids=$value_wise_individual_result_list
                 ->pluck('exam_dependent_academic_subject_id')
                  ->unique()
                 ->values();
          

            $subject_list_array=[];
            foreach($exam_dependent_academic_subject_ids as $keyss=>$dependent_academic_subject_id){
        
                $student_history_idss= $value_wise_individual_result_list
                    ->where('exam_dependent_academic_subject_id',$dependent_academic_subject_id)
                    ->pluck('student_history_id')
                    ->unique()
                    ->values();

                $student_history_list=StudentHistory::whereIn('id',$student_history_idss)->get();

                $academic_subject=AcademicSubject::where('id', $dependent_academic_subject_id)->first();

                $subject_list_array[$keyss]['dependent_academic_subject_id']=$dependent_academic_subject_id;
                $subject_list_array[$keyss]['academic_subject']=$academic_subject;
                $subject_list_array[$keyss]['student_history_list']=$student_history_list;
                $subject_list_array[$keyss]['failed_student_count']=count($student_history_list);
                
            }

            $failed_subject_arr['academic_subject_list']=$subject_list_array;
            $failed_subject_arr['failed_subject_count']=$value;
            $failed_subject_arr['failed_subject_student']=$failedPrimaryResultDetailList
                ->where('fail_subject_count', $value)
                ->count();

            $failed_subject_list_array[$key]=$failed_subject_arr;

        }

     
        $failed_subject_list=array_values(array_sort(collect($failed_subject_list_array), function ($value) {
            return $value['failed_subject_count'];
        }));


            ///

        /// student merit list
        $student_history_ids=$getStudentList->pluck('id');
        $merit_list=$this->studentMeritList($request,$student_history_ids);

      
        return [$subject_result_array,$failed_subject_list,$gradeList,$merit_list];

    }



    public function getSitePrimaryResultTwoSubjectPassFailStatisticsPdf(Request $request){
       
       ini_set('memory_limit', '-1');

       $getData = $this->getSitePrimaryResultTwoSubjectPassFailStatistics($request);
      
      
        $subject_result_array=$getData[0];
        $failed_subject_list=$getData[1];
        $grade_list=$getData[2];
        $merit_list=$getData[3];
   // dd($gradeList);
       $data = $request->all();
       $head_signature_status ='';

      
       $report_tittle2='';

       // institute head

       $institute_head = Employee::where('institute_head', 1)->first();

       $get_institute_head_signature = $institute_head->signature ?? '/img/signature/signature.png';
       $get_institute_head_designation = $institute_head->designation->name ?? 'Institution Head';
   
      // result name and year

      $result = AcademicResultPrimaryType::findOrFail($request->academic_result_primary_type_id);

      $result_name=$result->name;
      $year=AcademicYear::findOrFail($request->academic_year_id);
      $year_name=$year->year_name;
       
      $result_name .=', '.$year_name;

      $report_tittle='';
      $report_tittle2='';

       
     

       //============ domain name =============
       $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
       $alias = $site_info->site_alias;

       if($site_info->domain_name==null){
           $url = config('app.url');
           $parsedUrl = parse_url($url);
           $host = $parsedUrl['host'];
           $host_names = explode(".", $host);
           $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

           if ($host_names[count($host_names) - 1] == 'bd') {
               $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
           }
           if (count($host_names) == 2) {
               $bottom_host_name = $host_names[count($host_names) - 1];
           }
           $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
     
       }else{
           $domain = $site_info->domain_name;
       }

       $report_tittle .=$result_name;
       $report_tittle .= '<br/>';
       $report_tittle .= 'Total Subject Base Result';

       $class_group=AcademicClassGroup::find($request->academic_class_group_id);
       $class=AcademicClass::find($request->academic_class_id);
       $section=AcademicSection::find($request->academic_section_id);
   
       $report_tittle2 .= 'Year : '.$year_name;
      
       if($class){
        $academic_class=$class?$class->class_name:'';
        $report_tittle2 .= ', Class : '.$academic_class;
       }

       if($class_group){
        $academic_class_group=$class_group?$class_group->group_name:'';
        $report_tittle2 .= ', Group : '.$academic_class_group;
       }

       if($section){
        $academic_section=$section?$section->section_name:'';
        $report_tittle2 .= ', Section : '.$academic_section;
       }
      

      
        //===========
       
      // if($request->page_orientaion=='portrate'){
           $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-student-exam-result-passed-failed-detail-report-two',
               compact('subject_result_array','failed_subject_list','grade_list', 'merit_list', 'report_tittle', 'report_tittle2', 'domain','result_name','get_institute_head_signature','get_institute_head_designation'))
               ->setWarnings(false);
      // }
  

       $path = storage_path() . '/pdf';
       $time = \Auth::user()->id.'-'.$alias.'-'.$result_name.'-'.Carbon::now()->unix();
       $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
       $name = $time . '.pdf';


       return Response::json(['link' => route('open-pdf-file-storage', [$name]),
           'message' => 'Successfully Created Card Report'], 200);

      // return $result->grade_list;
    }
    
    
    public function getExamSubjectAbsentPassFailStudentList(Request $request){

        $getStudentList=$this->getStudentList($request);

        if($request->list_type=='absent'){
            $individual_result_list=SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_dependent_academic_subject_id', $request->academic_subject_id)
                ->where('exam_attendance_status', false)
//                ->where('subject_base_pass_fail_status', false)
                ->pluck('student_history_id')
                ->unique();

         //   $student_final_list=$getStudentList->whereIn('id', $individual_result_list);
            $student_final_list= StudentHistory::whereIn('id', $individual_result_list)->get();

        }
        else if($request->list_type=='pass'){

            $individual_result_list=SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_dependent_academic_subject_id', $request->academic_subject_id)
                ->where('exam_attendance_status', true)
                ->where('subject_base_pass_fail_status', true)
                ->pluck('student_history_id')
                ->unique();

           // $student_final_list=$getStudentList->whereIn('id', $individual_result_list);
            $student_final_list= StudentHistory::whereIn('id', $individual_result_list)->get();


        }
        else if($request->list_type=='fail'){

            $individual_result_list=SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $getStudentList->pluck('id'))
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->where('exam_dependent_academic_subject_id', $request->academic_subject_id)
                ->where('exam_attendance_status', true)
                ->where('subject_base_pass_fail_status', false)
                ->pluck('student_history_id')
                ->unique();

         //   $student_final_list=$getStudentList->whereIn('id', $individual_result_list);
            $student_final_list= StudentHistory::whereIn('id', $individual_result_list)->get();
        }

        return response()->json(
            [
                'student_list'=>$student_final_list->values(),
            ]);

    }

    public function getFixedCountFailedStudentList(Request $request){

        $getStudentList=$this->getStudentList($request);

        $faill_subject_student_ids=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $getStudentList->pluck('id'))
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('fail_subject_count', $request->failed_subject_count)
            ->where('exam_attendance_status', true)
//            ->select('fail_subject_count')->get();
            ->pluck('student_history_id')
            ->unique()
            ->filter();

        $individual_result_list=SiteIndividualCombineSubjectResultStore::with(['academicSubject'])
            ->whereIn('student_history_id', $faill_subject_student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->select('id', 'student_history_id', 'academic_result_primary_type_id', 'exam_dependent_academic_subject_id',
                'subject_base_pass_fail_status', 'exam_attendance_status')
            ->where('subject_base_pass_fail_status', false)
//            ->where('exam_attendance_status', true)
            ->get();


     //   $failed_student_list=$getStudentList->whereIn('id', $faill_subject_student_ids);
        $failed_student_list= StudentHistory::whereIn('id', $faill_subject_student_ids)->get();


        $failed_student_subject_arr=Array();
        $failed_student_subject_array=[];
        foreach ($failed_student_list as $key => $value) {

            $check_student_subject=$individual_result_list->where('student_history_id', $value->id);

            if(count($check_student_subject)>0){
                $failed_student_subject_arr['id']=$value->id;
                $failed_student_subject_arr['full_name']=$value->full_name;
                $failed_student_subject_arr['student_roll_number']=$value->student_roll_number;


                $subject_arr=Array();
                $subject_array=[];
                foreach ($check_student_subject as $keys => $values) {
                    $subject_arr['id']=$values->academicSubject->id;
                    $subject_arr['subject_name']=$values->academicSubject->subject_name;
                    $subject_arr['exam_attendance']=$values->exam_attendance_status;

                    $subject_array[$keys]=$subject_arr;
                }

                $failed_student_subject_arr['subject_list']=collect($subject_array)->values();

                $failed_student_subject_array[$key]=$failed_student_subject_arr;

            }

        }


        $failed_student_subject_list=array_values(array_sort(collect($failed_student_subject_array), function ($value) {
            return $value['student_roll_number'];
        }));

        return response()->json(
            [
                'failedStudentList'=>collect($failed_student_subject_list)->values()
            ]);

    }

    private function studentMeritList($request, $student_history_ids){

        $student_merit_list=SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
        ->with(['studentHistory'=>function($query){
                $query->select('id','user_id');
        }])
        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        ->where('exam_attendance_status',1)
        ->where('gpa','>','0')
        ->select('id', 'student_history_id', 'fail_subject_count', 'exam_attendance_status', 'grade','gpa','sum_of_obtain_total_marks_for_show',
        'sum_of_obtain_total_percent_for_show','student_rank')
        ->orderBy('student_rank','ASC')
        ->limit(10)
        ->get();

        $merit_list_array=[];
        $key=0;
       foreach($student_merit_list as $item){
            $merit_list_array[$key]['student_name']=$item->studentHistory->full_name;
            $merit_list_array[$key]['roll']=$item->studentHistory->student?$item->studentHistory->student->student_roll_number:'';
            $merit_list_array[$key]['total_mark']=$item->sum_of_obtain_total_marks_for_show;
            $merit_list_array[$key]['mark_percentage']=$item->sum_of_obtain_total_percent_for_show;
            $merit_list_array[$key]['grade']=$item->grade;
            $merit_list_array[$key]['gpa']=$item->gpa;
            $merit_list_array[$key]['rank']=$item->student_rank;
            $key++;
       }

       return $merit_list_array;


    }

    private function getStudentList($request){

        $data=$request->all();

        $studentList = StudentHistory::with(['department', 'stClass', 'classGroup', 'section'])
                ->select('id','academic_year_id', 'academic_version_id', 'academic_shift_id',
                    'academic_class_id', 'academic_department_id', 'academic_section_id', 'academic_class_group_id', 'student_roll_number')
                ->where('academic_year_id', $data['academic_year_id'])
                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when($data['academic_class_id'], function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->where('transfer_status', 0)
                ->where('status', true)
                ->orderBy('student_roll_number')
                ->orderBy('academic_department_id')
                ->orderBy('academic_class_id')
                ->orderBy('academic_class_group_id')
                ->orderBy('academic_section_id')
                ->get();

            return $studentList;
    }

 

   

}
