<?php

namespace App\Http\Controllers\Site\Fee;

use App\Models\Academic\AcademicStudentOfferType;
use App\Models\Site\SiteStudentFeeOfferDetail;
use App\Models\Site\SiteStudentOfferType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SiteStudentFeeOfferDetailController extends Controller
{
    private $siteStudentFeeOfferDetail;

    public function __construct(SiteStudentFeeOfferDetail $siteStudentFeeOfferDetail)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->siteStudentFeeOfferDetail = $siteStudentFeeOfferDetail;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.sites.fee.studnent_fee_offer_detail.view', compact('viewType'));
    }

    public function getStudentOfferList()
    {
        $student_offer = new AcademicStudentOfferType();
        $student_offer_list = $student_offer->get();
        return $student_offer_list;
    }

    public function getStudentFeeOfferList()
    {
        $student_offer_detail = new SiteStudentFeeOfferDetail();
        $student_offer_detail_list = $student_offer_detail->get();
        $final = [];
        foreach ($student_offer_detail_list as $k => $v){

            $final[$k]['id'] = $v->id;
            $student_offer = new AcademicStudentOfferType();
            $final[$k]['student_offer_type'] = $student_offer->where('id', $v->site_student_fee_offer_type_id)->first();
            $final[$k]['validation_start_date'] = $v->validation_start_date;
            $final[$k]['validation_end_date'] = $v->validation_end_date;
            $final[$k]['amount'] = $v->amount;

        }

        return $final;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        foreach ($request->site_sub_head_list as $k => $v){
            //return $v;
            if($v['status'] == true) {
                //return $v['id'];
                $feeSubHeadId[$k] = $v['id'];

            }else{}

        }

        foreach ($feeSubHeadId as $key => $value){
            //return $value;
            if($value != ""){
                $idArray[$key] = $value;
            }else{}
        }

        $ids = implode(',', $idArray);

        //return $ids;

        $stud_fee_offer = new SiteStudentFeeOfferDetail();

        $stud_fee_offer->site_student_fee_offer_type_id = $request->offer_type_id;
        $stud_fee_offer->academic_version_id = $request->site_version_id;
        $stud_fee_offer->academic_year_id = $request->academic_year_id;
        $stud_fee_offer->academic_shift_id = $request->academic_shift_id;
        $stud_fee_offer->academic_class_id =  $request->academic_class_id ?? null;
        $stud_fee_offer->academic_department_id =  $request->academic_department_id ?? null;
        $stud_fee_offer->month = $request->month;
        $stud_fee_offer->validation_start_date = $request->start_date;
        $stud_fee_offer->validation_end_date = $request->end_date;
        $stud_fee_offer->amount = $request->amount;
        $stud_fee_offer->academic_fee_sub_head_ids = $ids;
        $stud_fee_offer->status = true;
        $stud_fee_offer->save();


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $siteStudentFeeOfferDetailsDelete = $this->siteStudentFeeOfferDetail->findOrFail($id);

        $siteStudentFeeOfferDetailsDelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
