<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicClassGroup;

use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use App\Models\AcademicYear\AcademicYear;

use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicSection;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\SiteInfo;
use Illuminate\Support\Facades\Log;
use Response;
use Session;


class SiteBaseExamMarksEntryController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Site Exam Marks Entry Page';

        return view('default.admin.layouts.master', compact('viewType'));
     //   return view('default.admin.site.exam.site-base-exam-marks-entry', compact('viewType'));

    }

    public function getSiteDepartmentClassBaseExamination(Request $request){

        $data = $request->all();

        $examinationAll = SiteExamDeclares::
            where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
        //    ->where('exam_declared_by','site')
            ->pluck('examination_id')
            ->unique();

        //    dd('sf');

        $examination_list=Examination::whereIn('id', $examinationAll)
           // ->where('use_key','site')
            ->get();


        return $examination_list;
    }



    public function getSiteExaminationBaseSubjectList(Request $request){

        $data = $request->all();

      
        $declareListIds = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
          //  ->where('exam_declared_by','site')
            ->pluck('id');


        $studentHistoryIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


        $site_subject_group_condition_setting_ids=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $declareListIds)
            ->whereIn('student_history_id', $studentHistoryIds)
            ->pluck('site_subject_group_condition_setting_id');
           // ->get();



        $subjectIDs_array=SubjectGroupConditionSetting::whereIn('id', $site_subject_group_condition_setting_ids)->get();

        return $subjectIDs_array;

    }


    public function getSubjectBaseExamTypeListForExamMarksEntry(Request $request){


        $data = $request->all();

        $subjectList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
          //  ->where('exam_declared_by','site')
            ->get();



        $examDeclareIDs=$subjectList->pluck('id');
        $examType_array=SiteExamRoutine::
            where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->whereIn('site_exam_declare_id', $examDeclareIDs)
            ->pluck('academic_exam_type_id');

        $unique_examType=array_unique($examType_array->toArray());
        $examTypeList=AcademicExamType::whereIn('id', $unique_examType)->get();


        return $examTypeList;
    }

    public function getSiteBaseStudentListForMarksEntry(Request $request){

        $data = $request->all();

        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
         //   ->where('exam_declared_by','site')
            ->pluck('id');



        $studentIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
            ->where('status', true)
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');




        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($request){
            $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);
            $query->with(['academicExamType']);
            $query->with(['marksInputBy'=>function($q) use ($request){
                $q->select('id');
            }]);
//            $query->select('id', 'site_exam_declare_id', 'student_history_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
//                'exam_held_status', 'obtaine_marks', 'grace_marks', 'pass_mark', 'subject_exam_type_mark');

        },
            'studentHistory'=>function($querys) use ($data){

                $querys->select('id', 'user_id', 'student_roll_number_prefix','student_roll_number');
                  $querys->with('siteGroupStudentExamRoll');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->orderBy('student_roll_number', 'asc');

            }])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->get();

        $declaredStudentList->transform(function ($item) {
            $item->student_exam_roll_number = $item->studentHistory->siteGroupStudentExamRoll->roll ?? '';
            return $item;
        });


        $student_list=[];
        foreach ($declaredStudentList as $key => $value) {

            if(count($value->siteExamDeclareStudentSubject)>0){
                $student_list[]=$value;
            }

        }

        $student_asc_list=array_values(array_sort(collect($student_list), function ($value) {
            return $value['student_roll_number'];
        }));

          /////

        $examinationIDs=SiteSubjectExaminationMark::where('examination_id', $request->examination_id)
          ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
          ->pluck('id')
          ->unique()
          ->filter();


      $examTypeIDs=SiteSubjectExaminationExamTypeMark::whereIn('site_subject_examination_mark_id', $examinationIDs)
          ->pluck('academic_exam_type_id')
          ->unique()
          ->filter();

          ////


        $get_type_ids=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->whereIn('academic_exam_type_id', $examTypeIDs)
            ->pluck('academic_exam_type_id')
            ->unique()
            ->values();

        $getExamType=SiteExaminationExamTypeSetting::with(['academicExamType', 'examination'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->whereIn('academic_exam_type_id', $get_type_ids)
            ->select('academic_exam_type_id', 'examination_id', 'id')
            ->orderBy('position_show')
            ->get();


        $exam_type_arr=Array();
        $exam_type_array=[];
        foreach ($getExamType as $key => $value) {

            $selected_student_count=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->count();

            $passed_student_count=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->whereRaw('obtaine_marks >= pass_mark')
                ->count();

            $failed_student_count=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('academic_exam_type_id', $value->academic_exam_type_id)
                ->where('exam_attendance_status', true)
                ->whereRaw('obtaine_marks < pass_mark')
                ->count();

            $exam_type_arr['selected_student_count']=$selected_student_count;
            $exam_type_arr['passed_student_count']=$passed_student_count;
            $exam_type_arr['failed_student_count']=$failed_student_count;
            $exam_type_arr['select_all']=false;


            $exam_type_array[$key]=array_merge($exam_type_arr, $value->toArray());
        }



        return [$student_asc_list, $exam_type_array];


    }
    public function getSiteBaseStudentMarkList(Request $request){

        $data = $request->all();

        //// header data
        $examination = Examination::where('id',$data['examination_id'])->first();
        $academic_class_group = AcademicClassGroup::find($data['academic_class_group_id']);
        $academic_group_condition = SubjectGroupConditionSetting::with('academicYear','academicClass','academicDepartment')->where('id',$data['site_subject_group_condition_setting_id'])->first();
        $site_info = SiteInfo::find(Session::get('SITE_ID'));
        $section = AcademicSection::find($data['academic_section_id']);

        $header_data=[
            'examination_name'=>$examination?$examination->examination_name:'',
            'year_name'=>$academic_group_condition->academicYear?$academic_group_condition->academicYear->year_name:'',
            'subject_name'=>$academic_group_condition?$academic_group_condition->subject_name:'',
            'class_name'=>$academic_group_condition->academicClass?$academic_group_condition->academicClass->class_name:'',
            'department_name'=>$academic_group_condition->academicDepartment?$academic_group_condition->academicDepartment->name:'',
            'group_name'=>$academic_class_group?$academic_class_group->group_name:'',
            'section_name'=>$section?$section->section_name:'',
            'site_name'=>$site_info->site_name,
            'site_address'=>$site_info->address,
        ];

       // return $header_data;

        //======


        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
          //  ->where('exam_declared_by','site')
            ->pluck('id');

        $studentIds=StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->where('status', true)
            ->orderBy('student_roll_number', 'asc')
            ->pluck('id');


        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($request){
            $query->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id);
            $query->with(['academicExamType']);
            $query->with(['marksInputBy'=>function($q) use ($request){
                $q->select('id');
            }]);
//            $query->select('id', 'site_exam_declare_id', 'student_history_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
//                'exam_held_status', 'obtaine_marks', 'grace_marks', 'pass_mark', 'subject_exam_type_mark');

        },
            'studentHistory'=>function($querys) use ($data){

                $querys->select('id', 'user_id', 'student_roll_number');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                });

            }])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->get()
            ->sortBy('studentHistory.student_roll_number');
          //  dd($declaredStudentList);
        $student_list=[];

        foreach ($declaredStudentList as $key => $value) {
        //   dd($value->siteExamDeclareStudentSubject);
            if(count($value->siteExamDeclareStudentSubject)>0){
                $total_mark=$value->siteExamDeclareStudentSubject->sum('obtaine_marks');
                $value['total_mark'] = $total_mark<=0?'':$total_mark;
                $student_list[]=$value;
            }

        }


        $getExamTypeList=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $studentIds)
            ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
            ->distinct('academic_exam_type_id')
            ->select('academic_exam_type_id')
            ->get();

        $get_type_ids=$getExamTypeList->pluck('academic_exam_type_id')->unique();


        $getExamType=SiteExaminationExamTypeSetting::with(['academicExamType', 'examination'])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->whereIn('academic_exam_type_id', $get_type_ids)
            ->select('academic_exam_type_id', 'examination_id', 'id')
            ->orderBy('position_show')
            ->get();

            $student_subjects=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->where('exam_attendance_status', true)
                ->get();

              $passed_student=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->whereRaw('obtaine_marks >= pass_mark')
                ->where('exam_attendance_status', true)
                ->get();

              $failed_student=SiteExamDeclareStudentSubject::
                whereIn('site_exam_declare_id', $examDeclaredList)
                ->whereIn('student_history_id', $studentIds)
                ->where('site_subject_group_condition_setting_id', $request->site_subject_group_condition_setting_id)
                ->whereRaw('obtaine_marks < pass_mark')
                ->where('exam_attendance_status', true)
                ->get();


        $exam_type_arr=Array();
        $exam_type_array=[];
        foreach ($getExamType as $key => $value) {

                $selected_student_count=$student_subjects
                    ->where('academic_exam_type_id', $value->academic_exam_type_id)
                    ->count();

                $passed_student_count=$passed_student
                    ->where('academic_exam_type_id', $value->academic_exam_type_id)
                    ->count();

                $failed_student_count=$failed_student
                    ->where('academic_exam_type_id', $value->academic_exam_type_id)
                    ->count();

            $exam_type_arr['selected_student_count']=$selected_student_count;
            $exam_type_arr['passed_student_count']=$passed_student_count;
            $exam_type_arr['failed_student_count']=$failed_student_count;
            $exam_type_arr['select_all']=false;


            $exam_type_array[$key]=array_merge($exam_type_arr, $value->toArray());
        }

        return [$student_list, $exam_type_array, $header_data];
    }

    public function indivisualExamTypeStudentNumberEntry(Request $request){


        $number_entry=SiteExamDeclareStudentSubject::where('id', $request->number_entry['id'])->first();

        $number_entry->obtaine_marks = $request->number_entry['obtaine_marks'];
        $number_entry->grace_marks = $request->number_entry['grace_marks'];
        $number_entry->pass_mark = $request->number_entry['pass_mark'];
        $number_entry->subject_exam_type_mark = $request->number_entry['required_max_mark'];
        $number_entry->site_subject_examination_mark_id = $request->number_entry['site_subject_examination_mark_id'];
        $number_entry->site_subject_examination_exam_type_mark_id = $request->number_entry['site_subject_examination_exam_type_mark_id'];

        $number_entry->save();
        return Response::json(['message' => 'Number Entry Successfully!', 'mode' => 'Create!'], 200);
    }



    public function combinelyExamTypeStudentNumberEntry(Request $request){

        $data=$request->all();
        $examination=Examination::where('id',$request->examination_id)
        // ->where('use_key','site')
        ->first();
        if(!$examination){
            return Response::json(['message'=>'You have no permission'],401);
        }

       
        ///===== check permission

        $checkPermission=$this->checkExamMarkEntryPermission($data,$examination);
        if($checkPermission['status']!='200'){
            return Response::json(['message' => $checkPermission['message'], 'status' => $checkPermission['status']], $checkPermission['status']);
        }
      

        foreach ($request->StudentListForMarksEntry as $key => $value) {

            $count=0;
            foreach ($value['site_exam_declare_student_subject'] as $keys => $values) {

                if($values['obtaine_marks']>$values['subject_exam_type_mark'] || $values['obtaine_marks']<0){
                    $count++;
                }else{

                    $checkCreated=SiteExamDeclareStudentSubject::where('id', $values['id'])->first();

                    if($checkCreated->obtaine_marks!=$values['obtaine_marks']){

                        //==== this condition add for exam type countable mark
                        if($values['exam_type_countable_marks_status']){
                           $countable_obtaine_marks = ($values['exam_type_countable_persent_of_obtain_marks'] * $values['obtaine_marks'])/100;
                        }else{
                           $countable_obtaine_marks = $values['obtaine_marks'];
                        }
                        //===

                        if(!($checkCreated->marks_input_by)){
                            SiteExamDeclareStudentSubject::where('id', $values['id'])
                                ->update([
                                    'countable_obtaine_marks'=>$countable_obtaine_marks,
                                    'obtaine_marks'=>$values['obtaine_marks'],
                                    'grace_marks'=>$values['grace_marks'],
                                    'marks_input_by'=>$values['obtaine_marks']?Auth::id():null,
                                    'created_at'=>Carbon::now(),
                                ]);
                        }
                        else{
                            SiteExamDeclareStudentSubject::where('id', $values['id'])
                                ->update([
                                    'countable_obtaine_marks'=>$countable_obtaine_marks,
                                    'obtaine_marks'=>$values['obtaine_marks'],
                                    'grace_marks'=>$values['grace_marks'],
                                    'marks_last_update_by'=>Auth::id(),
                                    'updated_at'=>Carbon::now(),
                                ]);
                        }
                    }

                }

            }

        }

        return Response::json(['message' => 'Number Entry Successfully!', 'mode' => 'Create!'], 200);

    }


    //===============================Student Base Marks Entry Start====================


    public function getStudentListForSingleStudentMarksEntry(Request $requests){

        $data = $requests->all();

        if($requests->examination_id) {
            $studentList = StudentHistory::select('id', 'user_id','student_roll_number_prefix','student_roll_number')
                ->with(['student' => function ($query) {
                    $query->select('id');
                    $query->where('user_type', 'student');
                }])
                ->where('academic_version_id', $requests->academic_version_id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                //     return $query->where('academic_session_id', $data['academic_session_id']);
                // })
                ->where('status', true)
                ->orderBy('student_roll_number', 'asc')
                ->get();

        }else{
            $studentList=[];
        }
        return $studentList;

    }


    public function getStudentExaminationBaseAllSubjectMarksEntryList(Request $request){

        $data = $request->all();

        $examDeclaredList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
//            ->where('site_subject_group_condition_setting_ids', $request->site_subject_group_condition_setting_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
//            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
//                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
//            })
//            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
//                return $query->where('academic_section_id', $data['academic_section_id']);
//            })
            // ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            //     return $query->where('academic_session_id', $data['academic_session_id']);
            // })
        //    ->where('exam_declared_by','site')
            ->pluck('id');


        $subject_condition_ids=SiteExamDeclareStudentSubject::whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $request->select_student_user_id)
            ->pluck('site_subject_group_condition_setting_id')
            ->unique()
            ->filter();

        $subject_ids=SubjectGroupConditionSetting::whereIn('id', $subject_condition_ids)
            ->pluck('academic_subject_id')
            ->unique()
            ->filter();

        $subject_list=AcademicSubject::whereIn('id', $subject_ids)
            ->get();

        $declaredStudentList=SiteExamDeclareStudent::with(['siteExamDeclareStudentSubject'=>function($query) use ($request){
            $query->with(['academicExamType',
                'subjectGroupConditionSetting'=>function($queryst){
                    $queryst->with(['academicSubject']);
                    $queryst->select('id', 'academic_subject_id', 'subject_position');
                    $queryst->orderBy('subject_position');

                }]);

        },
            'studentHistory'=>function($querys) use ($data){

                $querys->select('id', 'user_id', 'student_roll_number');
                $querys->when(!empty($data['academic_class_group_id']), function ($q) use ($data) {
                    return $q->where('academic_class_group_id', $data['academic_class_group_id']);
                });

            }])
            ->whereIn('site_exam_declare_id', $examDeclaredList)
            ->whereIn('student_history_id', $request->select_student_user_id)
            ->get();

        $student_arr=Array();
        $student_array=[];
        foreach ($declaredStudentList as $key => $value) {

            $subject_condition_setting_ids=$value->siteExamDeclareStudentSubject->pluck('site_subject_group_condition_setting_id')
                ->unique()
                ->filter();

            $subject_arr=Array();
            $subject_array=[];
            $counts=0;
            foreach ($subject_condition_setting_ids as $keys => $values) {

                $subject_arr['exam_type']=$value->siteExamDeclareStudentSubject
                    ->where('site_subject_group_condition_setting_id', $values);

                $subject_nmae_find=$value->siteExamDeclareStudentSubject
                    ->where('site_subject_group_condition_setting_id', $values)->first();

                $subject_arr['subject_name']=$subject_nmae_find->subjectGroupConditionSetting->subject_name;
                $subject_arr['subject_position']=$subject_nmae_find->subjectGroupConditionSetting->subject_position;
                $subject_arr['id']=$subject_nmae_find->subjectGroupConditionSetting->id;

                $subject_array[$counts]=$subject_arr;
                $counts++;

            }

            $orderd_subject_array=array_values(array_sort(collect($subject_array), function ($value) {
                return $value['subject_position'];
            }));


//                collect($subject_array)
//                ->orderBy('subject_position')
//                ->orderBy('subject_name');


            $student_arr['subject_list']=$orderd_subject_array;
            $student_arr['student_history_id']=$value->studentHistory->id;
            $student_arr['id']=$value->studentHistory->id;
            $student_arr['student_roll_number']=$value->studentHistory->student_roll_number;
            $student_arr['full_name']=$value->studentHistory->full_name;

            $student_array[$key]=array_merge($student_arr);

        }

        return $student_array;

    }


    public function siteBaseSingleStudentAllMarksEntry(Request $request){

        $data=$request->all();
        $examination=Examination::where('id',$request->examination_id)
       // ->where('use_key','site')
        ->first();
        if(!$examination){
           return Response::json(['message'=>'You have no permission'],401);
        }
          ///===== check permission

        $checkPermission=$this->checkExamMarkEntryPermission($data,$examination);
        if($checkPermission['status']!='200'){
            return Response::json(['message' => $checkPermission['message'], 'status' => $checkPermission['status']], $checkPermission['status']);
        }
      

        foreach ($request->SingleStudentMarks as $key => $value) {

                $count=0;
                foreach ($value['exam_type'] as $keyst => $valuest) {

                    if($valuest['obtaine_marks']>$valuest['subject_exam_type_mark'] || $valuest['obtaine_marks']<0){
                        $count++;
                    }else{

                        //==== this condition add for exam type countable mark
                        if($valuest['exam_type_countable_marks_status']){
                            $countable_obtaine_marks = ($valuest['exam_type_countable_persent_of_obtain_marks'] * $valuest['obtaine_marks'])/100;
                         }else{
                            $countable_obtaine_marks = $valuest['obtaine_marks'];
                         }
                         //===
                        SiteExamDeclareStudentSubject::where('id', $valuest['id'])
                            ->update([
                                'obtaine_marks'=>$valuest['obtaine_marks'],
                                'grace_marks'=>$valuest['grace_marks'],
                                'countable_obtaine_marks'=>ceil($countable_obtaine_marks),
                                'marks_last_update_by'=>Auth::id(),
                                'updated_at'=>Carbon::now(),
                            ]);
                    }


                }

        }

        return Response::json(['message' => 'Number Entry Successfully!', 'mode' => 'Create!'], 200);

    }


    public function checkExamMarkEntryPermission($data, $examination)
        {

            if($examination->use_key=='site_group'){ // only group exam

            $checkSetting = SiteExaminationExamTypeSetting::with(['academicExamType'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('examination_id', $data['examination_id'])
                ->orderBy('position_show')
                ->first();


                if($checkSetting){
                    if($checkSetting->site_exam_mark_entry_permission==false){
                        return ['status'=>'403','message' => 'You have no permission!'];
                    }
                    $deadlineInput = $checkSetting->exam_mark_entry_deadline ?? null;

                    $now = Carbon::now('Asia/Dhaka');
                    $deadline = Carbon::parse($deadlineInput, 'Asia/Dhaka');

                    if ($now->greaterThanOrEqualTo($deadline)) {
                        return ['status'=>'403','message' => 'Time is over!'];
                    }
                }

            }

            return ['status'=>'200','message' => 'pass successfully!'];

        }


}
