<?php

namespace App\Http\Controllers\Site\EmployeePanel\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Attendance\StudentAttendance;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Room\Room;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Exam\Question\SiteExamStudentQuestion;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExamInvigilatorRoomSetup;
use App\Models\Site\Exam\SiteExamQuestion;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Room\SiteBaseExamRoomSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Auth;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Log;
use Response;

class EmployeeExamSeatPlanAttendanceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }

    public function index()
    {
        $viewType = 'Employee Exam Seat Plan & Attendance Page';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.site.employeepanel.exam.employee-exam-seat-plan-attendance', compact('viewType'));

    }



    public function getEmpExamDutyRoster(Request $request){

        $data = $request->all();

        $invigilator_room_list = SiteExamInvigilatorRoomSetup::with(['rooms'=>function($query){
            $query->select('id', 'building_id', 'floor_id', 'room_name');
        }])
            ->where('academic_year_id', $request->academic_year_id)
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_version_id']), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->where('examination_id', $request->examination_id)
            ->where('user_id', Auth::user()->id)
            ->where('status', true)
            ->orderBy('exam_start_date', 'asc')
            ->get();

        //    dd($invigilator_room_list);

        $exam_date_list=$invigilator_room_list->pluck('exam_start_date')->unique()->values();


        $duty_roster_arr=Array();
        $duty_roster_array=[];
        foreach ($exam_date_list as $key => $value) {

            $exam_time_room_list=$invigilator_room_list->where('exam_start_date', $value)->values();

            $duty_roster_arr['exam_time_room_list']=$exam_time_room_list;
            $duty_roster_arr['exam_date']=$value;

            $duty_roster_array[$key]=$duty_roster_arr;


        }

        return $duty_roster_array;
    }






    public function getExamDateBaseExamTimeFormEmp(Request $request){


        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_list=SiteExamInvigilatorRoomSetup::where('exam_start_date', $exam_date)
            ->where('status', true)
            ->pluck('exam_start_time')
            ->unique()
            ->values();



        $exam_date_array=[];
        $exam_date_arr=Array();
        foreach ($exam_time_list as $key => $value) {

            $exam_date_arr['exam_start_time']=$value;
            $exam_date_array[$key]=$exam_date_arr;
        }

        return $exam_date_array;

    }


    /**
     * @param Request $request
     * @return array
     */
    public function getExamDateTimeBaseSeatPlanForAttendance(Request $request){


        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');



        $examDateTime = Carbon::createFromFormat('Y-m-d H:i:s', "$exam_date $request->examination_time");
        $today=Carbon::now();
        $timeDuration = $today->diffInHours($examDateTime);



        if($today>$examDateTime){
            $detail_show=true;
        }
        else{
            if($timeDuration>11){
                $detail_show=false;
            }else{
                $detail_show=true;
            }
        }






        if($today>$examDateTime){
            $timeDuration = $examDateTime ->diffInHours($today);
            if($timeDuration>1){
                $save_button_show_status=false;
            }else{
                $save_button_show_status=true;
            }
        }
        else{
            $save_button_show_status=false;
        }





//        if($detail_show){



            $exam_time_base_declare_routine_list=SiteExamRoutine::
                where('exam_start_date', $exam_date)
                ->where('exam_start_time', $request->examination_time)
                ->where('seat_plan_publish_for_employee', true)
                ->get();



            $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();
            $routine_exam_end_time=$exam_time_base_declare_routine_list->pluck('exam_end_time')->first();


            $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
                ->where('exam_start_date', $exam_date)
                ->where('exam_start_time', $request->examination_time)
                ->where('status', true)
                ->pluck('room_id')->unique();



            $this->getMachineDataAndUpdate($routine_ids, $selected_room_ids, $exam_date, $routine_exam_end_time);



//        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)->update([
//            'exam_held_status'=>false,
//            'attendance_submit_by_machine'=>false,
//            'attendance_update_at'=>null,
//            'attendance_submit_by'=>null,
//            'exam_attendance_status'=>false,
//        ]);



            $routine_base_student=SiteExamDeclareStudentSubject::with(['academicExamType'])
                ->whereIn('site_exam_routine_id', $routine_ids)
                ->whereIn('room_id', $selected_room_ids)
                ->select('id', 'room_id', 'column_position', 'student_history_id', 'site_exam_routine_id',
                    'seat_number', 'academic_exam_type_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
                    'exam_held_status', 'attendance_submit_by', 'attendance_submit_by_machine',
                    'online_exam_status', 'online_exam_present_by_student', 'online_exam_start_by_teacher', 'online_exam_start',
                    'online_exam_end', 'online_exam_end_time', 'online_exam_pause', 'online_exam_pause_time', 'online_exam_apply_for_restart',
                    'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve', 'obtaine_marks')
                ->get();

            $exam_type_ids=$routine_base_student->pluck('academic_exam_type_id')->unique()->values();

            $exam_type_array=AcademicExamType::whereIn('id', $exam_type_ids)->get();


            $exam_type_arr=Array();
            $exam_type_list=[];
            foreach ($exam_type_array as $key => $value) {

                $exam_type_base_student=$routine_base_student->where('academic_exam_type_id', $value->id);
                $online_exam_check=$exam_type_base_student->where('online_exam_status', true)->first();

                $online_exam_present_by_student=$exam_type_base_student
                    ->where('online_exam_present_by_student', true)
                    ->where('online_exam_start_by_teacher', false)
                    ->count();

                $online_exam_restart_by_student=$exam_type_base_student
                    ->where('online_exam_present_by_student', true)
                    ->where('online_exam_start_by_teacher', true)
                    ->where('online_exam_apply_for_restart', true)
                    ->where('online_exam_restart_approve', false)
                    ->where('online_exam_end', false)
                    ->count();

                $online_exam_end=$exam_type_base_student
                    ->where('online_exam_present_by_student', true)
                    ->where('online_exam_start_by_teacher', true)
                    ->where('online_exam_end', false)
                    ->count();


                $exam_type_arr['id']=$value->id;
                $exam_type_arr['marks_type']=$value->marks_type;
                $exam_type_arr['online_exam_status']=$online_exam_check?true:false;
                $exam_type_arr['online_exam_present_by_student']=$online_exam_present_by_student;
                $exam_type_arr['online_exam_restart_by_student']=$online_exam_restart_by_student;
                $exam_type_arr['online_exam_end']=$online_exam_end;

                $exam_type_list[$key]=$exam_type_arr;

            }



            $room_arr=Array();
            $seat_plan_array=[];
            $time_base_student_subject_array=[];
            foreach ($selected_room_ids as $keyRoomId => $valueRoomId) {




                $room_student_detail=$routine_base_student
                    ->where('room_id', $valueRoomId);
                $room_student_ids=$room_student_detail->pluck('student_history_id')->unique();




                $student_details=StudentHistory::with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                    ->whereIn('id', $room_student_ids)
                    ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                        'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                    ->get();

                $room=Room::where('id', $valueRoomId)->first();

//                \Log::info($room);

                $room_detail=SiteBaseExamRoomSetting::with(['room'])
                    ->where('room_id', $valueRoomId)
                    ->where('status', true)
                    ->get();

                $column_id_pluck=$room_detail->pluck('column_position')->unique();

                $column_count=count($column_id_pluck);

                $column_arr=Array();
                $column_array=[];
                $count=1;
                foreach ($column_id_pluck as $keyRoomSeat => $valueRoomSeat) {

                    $row_span=$column_count-$count;
                    $count++;

                    $column_seat_list=$room_detail->where('column_position', $valueRoomSeat);

                    $column_student_detail=$room_student_detail
                        ->where('column_position', $valueRoomSeat);
                    $column_student_ids=$column_student_detail->pluck('student_history_id')->unique();

    //                $column_student_details=$student_details->whereIn('id', $column_student_ids);



                    $seat_arr=Array();
                    $seat_array=[];
                    foreach ($column_seat_list as $keySeat => $valueSeat) {



                        $seat_student_detail=$column_student_detail
                            ->where('seat_number', $valueSeat->seat_number);

                        $seat_student_ids=$seat_student_detail->pluck('student_history_id')->unique();

                        $std_arr=Array();
                        $std_array=[];
                        foreach ($seat_student_ids as $keyStdSeat => $valueStdSeat) {

                            $seat_student_details=$student_details->where('id', $valueStdSeat)->first();

                            $student_exam_type_lists=$seat_student_detail->where('student_history_id', $valueStdSeat)->values();



                            $time_base_student_subject_array[]=$student_exam_type_lists;


                            $type_array=[];
                            if(count($student_exam_type_lists)>0){
                                $type_arr=Array();
                                foreach ($student_exam_type_lists as $tkey => $tvalue) {
                                    $type_arr['exam_type_loading']=false;

                                    $type_array[$tkey]=array_merge($tvalue->toArray(), $type_arr);
                                }
                            }



                            $std_arr['student_exam_type_list']=collect($type_array)->values();


                            $std_array[$keyStdSeat]=array_merge($seat_student_details->toArray(), $std_arr);
                        }



                        $seat_arr['seat_number']=$valueSeat->seat_number;
                        $seat_arr['seat_position']=$valueSeat->seat_position;
                        $seat_arr['row_span']=$row_span;
                        $seat_arr['student_detail']=collect($std_array)->values();

                        $seat_array[$valueSeat->seat_number]=$seat_arr;



                    }


                    $column_arr['column_position']=$valueRoomSeat['column_position'];
                    $column_arr['column_student_count']=count($column_student_ids);
                    $column_arr['column_seat_list']=collect($seat_array)->values();

                    $column_array[$keyRoomSeat]=$column_arr;

                }



                $room_arr['column_list']=collect($column_array)->values();
                $room_arr['room_student_count']=count($room_student_ids);
                $room_arr['romm_id']=$valueRoomId;

                $seat_plan_array[$keyRoomId]=array_merge($room->toArray(), $room_arr);


            }






            //=============Invigilarot List====================

            $time_base_student_subject=collect($time_base_student_subject_array)->collapse()->values();

            $subject_list=SubjectGroupConditionSetting::with(['academicClass'])
                ->whereIn('id', $time_base_student_subject->pluck('site_subject_group_condition_setting_id')->unique()->values())
                ->get();



            $invigilator_arr=Array();
            $invigilator_array=[];
            foreach ($selected_room_ids as $keyRoom => $valueRoom) {

                $invigilator_list=SiteExamInvigilatorRoomSetup::with(['activeEmployee'])
                    ->where('room_id', $valueRoom)
                    ->where('exam_start_date', $exam_date)
                    ->where('exam_start_time', $request->examination_time)
                    ->where('status', true)
                    ->select('user_id')
                    ->get();


                $room_base_student_subject=$time_base_student_subject
                    ->where('room_id', $valueRoom)->values();



                $room_base_student_subject_condition_ids=$time_base_student_subject
                    ->where('room_id', $valueRoom)
                    ->pluck('site_subject_group_condition_setting_id')
                    ->unique()
                    ->values();

                $subject_arr=Array();
                $subject_array=[];
                foreach ($room_base_student_subject_condition_ids as $keySubject => $valueSubject) {

                    $subject_detail=$subject_list->where('id', $valueSubject)->first();

                    $subject_base_student_count=$room_base_student_subject
                        ->where('site_subject_group_condition_setting_id', $valueSubject)
                        ->pluck('student_history_id')
                        ->unique()
                        ->count();

                    $attend_student_count=$room_base_student_subject
                        ->where('site_subject_group_condition_setting_id', $valueSubject)
                        ->where('exam_attendance_status', true)
                        ->pluck('student_history_id')
                        ->unique()
                        ->count();



                    $subject_arr['subject_condition_id']=$valueSubject;
                    $subject_arr['subject_name']= $subject_detail->subject_name;
                    $subject_arr['class_name']= $subject_detail->academicClass->class_name;
                    $subject_arr['student_count']= $subject_base_student_count;
                    $subject_arr['attend_student_count']= $attend_student_count;

                    $subject_array[$keySubject]=$subject_arr;
                }


                $room_detail=Room::where('id', $valueRoom)->first();

                $invigilator_arr['room_name']= $room_detail->room_name_ex;
                $invigilator_arr['room_id']= $valueRoom;
                $invigilator_arr['class_subject_list']= collect($subject_array)->values();
                $invigilator_arr['invigilator_list']= $invigilator_list;

                $invigilator_array[$keyRoom]=$invigilator_arr;

            }


//        }
//        else{
//
//            return Response::json(['message' => 'Exam seat plan will be visible in you panel before 2 hours of exam.',
//                'mode' => 'Error!'], 200);
//
//        }

        return compact('seat_plan_array', 'invigilator_array', 'save_button_show_status', 'exam_type_list');




    }


    private function getMachineDataAndUpdate($routine_ids, $selected_room_ids, $exam_date, $routine_exam_end_time){


        $routine_base_student_ids=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->pluck('student_history_id')
            ->unique()
            ->values();


        $check_student_punch_status=StudentAttendance::where('present_date', $exam_date)
            ->where('present_date', Carbon::today())
            ->whereIn('student_history_id', $routine_base_student_ids)
            ->select('id', 'student_history_id', 'late_status')
            ->first();


        if($check_student_punch_status){


            $check_exam_held_status_all_student=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                ->where('exam_attendance_status', true)
                ->first();

            if(!$check_exam_held_status_all_student){

                SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)->update([
                    'exam_held_status'=>true,
                ]);

            }



            $machin_student_ids=StudentAttendance::where('present_date', $exam_date)
                ->where('present_date', Carbon::today())
//                ->where('in_time', '<' , $routine_exam_end_time)
                ->whereIn('student_history_id', $routine_base_student_ids)
                ->pluck('student_history_id')
                ->unique()
                ->filter();



            SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
                ->whereIn('room_id', $selected_room_ids)
                ->whereIn('student_history_id', $machin_student_ids)
                ->where('exam_attendance_status', false)
                ->where('attendance_submit_by', null)
                ->update([
                    'exam_held_status'=>true,
                    'exam_attendance_status'=>true,
                    'attendance_submit_by_machine'=>true,
                    'attendance_update_at'=>Carbon::now(),
                ]);


        }



    }



    public function getExamTypeListForAttendanceRefresh(Request $request){

        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');


        $exam_time_base_declare_routine_list=SiteExamRoutine::
        where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('seat_plan_publish_for_employee', true)
            ->get();



        $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();


        $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
            ->where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('status', true)
            ->pluck('room_id')->unique();


        $routine_base_student=SiteExamDeclareStudentSubject::with(['academicExamType'])
            ->whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->get();

        $exam_type_ids=$routine_base_student->pluck('academic_exam_type_id')->unique()->values();

        $exam_type_array=AcademicExamType::whereIn('id', $exam_type_ids)->get();


        $exam_type_arr=Array();
        $exam_type_list=[];
        foreach ($exam_type_array as $key => $value) {

            $exam_type_base_student=$routine_base_student->where('academic_exam_type_id', $value->id);
            $online_exam_check=$exam_type_base_student->where('online_exam_status', true)->first();

            $online_exam_present_by_student=$exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', false)
                ->count();

            $online_exam_restart_by_student=$exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', true)
                ->where('online_exam_apply_for_restart', true)
                ->where('online_exam_restart_approve', false)
                ->count();

            $online_exam_end=$exam_type_base_student
                ->where('online_exam_present_by_student', true)
                ->where('online_exam_start_by_teacher', true)
                ->where('online_exam_end', false)
                ->count();


            $exam_type_arr['id']=$value->id;
            $exam_type_arr['marks_type']=$value->marks_type;
            $exam_type_arr['online_exam_status']=$online_exam_check?true:false;
            $exam_type_arr['online_exam_present_by_student']=$online_exam_present_by_student;
            $exam_type_arr['online_exam_restart_by_student']=$online_exam_restart_by_student;
            $exam_type_arr['online_exam_end']=$online_exam_end;

            $exam_type_list[$key]=$exam_type_arr;

        }

        return response()->json(
            [
                'exam_type_list'=>$exam_type_list,

            ]);

    }



    public function saveSeatPlanInvigilatorBaseExamAttendance(Request $request){



        $student_attendance_array=[];
        foreach ($request->SeatPlanList as $key => $value) {

            foreach ($value['column_list'] as $keys => $values) {

                foreach ($values['column_seat_list'] as $keyst => $valuest) {

                    foreach ($valuest['student_detail'] as $keyw => $valuew) {

                        $student_attendance_array[]= $valuew['student_exam_type_list'];
                    }
                }
            }
        }


        $student_subject_attendance_list=collect($student_attendance_array)->collapse()->values();

        $student_subject_attendance_array=[];
        $student_subject_attendance_arr=Array();
        foreach ($student_subject_attendance_list as $key => $value) {

            if($value['online_exam_status']){

                if($value['online_exam_present_by_student']){
                    $student_subject_attendance_array[$key]=$value;
                }
            }
            else{
                $student_subject_attendance_array[$key]=$value;
            }
        }
        $student_subject_attendance=collect($student_subject_attendance_array)->values();



        $attendance_ids=$student_subject_attendance->pluck('id');





        $site_exam_routine_ids=$student_subject_attendance->pluck('site_exam_routine_id')->unique()->values();


        $check_exam_held_status_all_student=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $site_exam_routine_ids)
            ->where('exam_attendance_status', true)
            ->first();

        $check_exam_held=$student_subject_attendance->where('exam_attendance_status', true)->first();

        if($check_exam_held_status_all_student && $check_exam_held){

            foreach ($student_subject_attendance as $key => $value) {
                $check_data=SiteExamDeclareStudentSubject::where('id', $value['id'])->first();
                if($check_data->exam_attendance_status!=$value['exam_attendance_status']){
                    $check_data->update([
                        'exam_attendance_status'=>$value['online_exam_status'] && $value['online_exam_present_by_student']? true: $value['exam_attendance_status'],
                        'attendance_submit_by'=> Auth::user()->id,
                        'attendance_update_at'=>Carbon::now(),
                    ]);
                }
            }

        }
        else if(!$check_exam_held_status_all_student && $check_exam_held){

            SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $site_exam_routine_ids)->update([
                'exam_held_status'=>true,
            ]);


            foreach ($student_subject_attendance as $key => $value) {
                $check_data=SiteExamDeclareStudentSubject::where('id', $value['id'])->first();
                if($check_data->exam_attendance_status!=$value['exam_attendance_status']){
                    $check_data->update([
                        'exam_attendance_status'=>$value['exam_attendance_status'],
                        'attendance_submit_by'=> Auth::user()->id,
                        'attendance_update_at'=>Carbon::now(),
                    ]);
                }
            }

        }


        return Response::json(['message' => 'Attendance Entry Successfully!', 'mode' => 'Create!'], 200);


    }



    public function startOnlineExamForStudentByEmployee(Request $request){

        SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', false)
            ->update([
                'online_exam_start_by_teacher'=>true,
                'exam_attendance_status'=>true,
                'attendance_submit_by'=> Auth::user()->id,
                'attendance_update_at'=>Carbon::now(),
            ]);

        $student_detail=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->first();

        return $student_detail;

    }


    public function refreshOnlineExamForStudentByEmployee(Request $request){
        $student_detail=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->select('id', 'room_id', 'column_position', 'student_history_id', 'site_exam_routine_id',
                'seat_number', 'academic_exam_type_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
                'exam_held_status', 'attendance_submit_by', 'attendance_submit_by_machine',
                'online_exam_status', 'online_exam_present_by_student', 'online_exam_start_by_teacher', 'online_exam_start',
                'online_exam_end', 'online_exam_end_time', 'online_exam_pause', 'online_exam_pause_time', 'online_exam_apply_for_restart',
                'online_exam_restart_apply_time', 'online_exam_restart_apply_amount', 'online_exam_restart_approve', 'obtaine_marks')
            ->first();

        return $student_detail;
    }

    public function reStartOnlineExamForStudentByEmployee(Request $request){

        SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->where('online_exam_restart_approve', false)
            ->update([
                'online_exam_restart_approve'=>true,
            ]);

        $student_detail=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->first();

        return $student_detail;
    }



    public function endOnlineExamForStudentByEmployee(Request $request){


        $current_time=Carbon::now();


        $exam_detail=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->first();



        $question_list_detail=SiteExamStudentQuestion::where('site_exam_declare_student_subject_id', $request->site_exam_declare_student_subject_id)
            ->get();

        $question_ids=$question_list_detail->pluck('site_exam_question_id')->unique();


        $exam_question_all_list=SiteExamQuestion::whereIn('id', $question_ids)->get();

        $exam_question_total_number= $exam_question_all_list->sum('mark');



        $exam_obtain_mark=[];
        foreach ($question_list_detail as $key => $value) {


            $answer_check=array_diff(explode(',', $value->answer_ids), explode(',',$value->student_answer_ids));



            if(count($answer_check)==0){
                $right_answere_marks=SiteExamQuestion::where('id', $value->site_exam_question_id)->first();
                $exam_obtain_mark[]=$right_answere_marks->mark;
            }

        }

        $obtain_exam_marks_total=array_sum($exam_obtain_mark);



        $obtain_final_marks=($obtain_exam_marks_total * $exam_detail->subject_exam_type_mark) / $exam_question_total_number;



        SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->update([
                'online_exam_end'=>true,
                'online_exam_end_time'=>$current_time->toTimeString(),
                'obtaine_marks'=>$obtain_final_marks,
            ]);


        $student_detail=SiteExamDeclareStudentSubject::where('id', $request->site_exam_declare_student_subject_id)
            ->first();

        return $student_detail;
    }



    //==================Online all student attendance

    public function startOnlineExamForAllStudentByEmployee(Request $request){


        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_base_declare_routine_list=SiteExamRoutine::
        where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('seat_plan_publish_for_employee', true)
            ->get();



        $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();


        $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
            ->where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('status', true)
            ->pluck('room_id')->unique();


        $routine_base_student=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', false)
            ->where('online_exam_end', false)
            ->get();


        $user_name=Employee::where('id', \Auth::user()->id)->first();
        //=====Log Start
        $issue = new    IssueDetail();
        $issue->issue_type = 'exam:employee-start';
        $issue->issue_details = "Employee Start the exam. ". count($routine_base_student) . " student.";
        $issue->bearer_type = 'site';
        $issue->bearer_id = \Session::get('SITE_ID');
        $issue->username = $user_name->username;
        $issue->ip_address = request()->ip();
        $issue->save();

        //=====Log End




        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', false)
            ->where('online_exam_end', false)
            ->update([
                'online_exam_start_by_teacher'=>true,
                'exam_attendance_status'=>true,
                'attendance_submit_by'=> Auth::user()->id,
                'attendance_update_at'=>Carbon::now(),

            ]);








        return Response::json(['message' => 'Exam Start Successfully!', 'mode' => 'Create!'], 200);


    }


    public function reStartOnlineExamForAllStudentByEmployee(Request $request){

        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');

        $exam_time_base_declare_routine_list=SiteExamRoutine::
        where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('seat_plan_publish_for_employee', true)
            ->get();



        $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();


        $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
            ->where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('status', true)
            ->pluck('room_id')->unique();


        SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', true)
            ->where('online_exam_apply_for_restart', true)
            ->where('online_exam_end', false)
            ->where('online_exam_restart_approve', false)
            ->update([
                'online_exam_restart_approve'=>true,

            ]);



        return Response::json(['message' => 'Exam Start Successfully!', 'mode' => 'Create!'], 200);

    }


    public function endOnlineExamForAllStudentByEmployee(Request $request){

        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');
        $current_time=Carbon::now();

        $exam_time_base_declare_routine_list=SiteExamRoutine::
            where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('seat_plan_publish_for_employee', true)
            ->get();



        $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();


        $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
            ->where('exam_start_date', $exam_date)
            ->where('exam_start_time', $request->examination_time)
            ->where('status', true)
            ->pluck('room_id')->unique();


        $student_list_for_end=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $routine_ids)
            ->whereIn('room_id', $selected_room_ids)
            ->where('online_exam_status', true)
            ->where('online_exam_present_by_student', true)
            ->where('online_exam_start_by_teacher', true)
            ->where('online_exam_end', false)
            ->get();


        if(count($student_list_for_end)>0){
            foreach ($student_list_for_end as $keys => $values) {



                $question_list_detail=SiteExamStudentQuestion::where('site_exam_declare_student_subject_id', $values->id)
                    ->get();

                $question_ids=$question_list_detail->pluck('site_exam_question_id')->unique();


                $exam_question_all_list=SiteExamQuestion::whereIn('id', $question_ids)->get();

                $exam_question_total_number= $exam_question_all_list->sum('mark');



                $exam_obtain_mark=[];
                foreach ($question_list_detail as $key => $value) {


                    $answer_check=array_diff(explode(',', $value->answer_ids), explode(',',$value->student_answer_ids));



                    if(count($answer_check)==0){
                        $right_answere_marks=SiteExamQuestion::where('id', $value->site_exam_question_id)->first();
                        $exam_obtain_mark[]=$right_answere_marks->mark;
                    }

                }

                $obtain_exam_marks_total=array_sum($exam_obtain_mark);



                $obtain_final_marks=($obtain_exam_marks_total * $values->subject_exam_type_mark) / $exam_question_total_number;





                SiteExamDeclareStudentSubject::where('id', $values->id)
                    ->update([
                        'online_exam_end'=>true,
                        'online_exam_end_time'=>$current_time->toTimeString(),
                        'obtaine_marks'=>$obtain_final_marks,
                    ]);

            }
        }





        $user_name=Employee::where('id', \Auth::user()->id)->first();
        //=====Log Start
        $issue = new    IssueDetail();
        $issue->issue_type = 'exam:employee-end';
        $issue->issue_details = "Employee End the exam. ". count($student_list_for_end) . "student.";
        $issue->bearer_type = 'site';
        $issue->bearer_id = \Session::get('SITE_ID');
        $issue->username = $user_name->username;
        $issue->ip_address = request()->ip();
        $issue->save();

        //=====Log End




        return Response::json(['message' => 'Exam End Successfully!', 'mode' => 'Create!'], 200);

    }



    //====================Manual Attendance


    public function getExamDateTimeBaseStudentForManualAttendance(Request $request){


        $exam_date= Carbon::parse($request->exam_date)->format('Y-m-d');



        $examDateTime = Carbon::createFromFormat('Y-m-d H:i:s', "$exam_date $request->examination_time");
        $today=Carbon::now();
        $timeDuration = $today->diffInHours($examDateTime);

        if($today>$examDateTime){
            $detail_show=true;
        }
        else{
            if($timeDuration>1){
                $detail_show=false;
            }else{
                $detail_show=true;
            }
        }





        if($today>$examDateTime){
            $timeDuration = $examDateTime ->diffInHours($today);
            if($timeDuration>3){
                $save_button_show_status=false;
            }else{
                $save_button_show_status=true;
            }
        }
        else{
            $save_button_show_status=false;
        }





        if($detail_show){



            $exam_time_base_declare_routine_list=SiteExamRoutine::
                where('exam_start_date', $exam_date)
                ->where('exam_start_time', $request->examination_time)
                ->where('seat_plan_publish_for_employee', true)
                ->get();



            $routine_ids=$exam_time_base_declare_routine_list->pluck('id')->unique()->filter();
            $routine_exam_end_time=$exam_time_base_declare_routine_list->pluck('exam_end_time')->unique()->filter();



            $selected_room_ids=SiteExamInvigilatorRoomSetup::where('user_id', Auth::user()->id)
                ->where('exam_start_date', $exam_date)
                ->where('exam_start_time', $request->examination_time)
                ->where('status', true)
                ->pluck('room_id')->unique();

//            return $selected_room_ids;


            $this->getMachineDataAndUpdate($routine_ids, $selected_room_ids, $exam_date, $routine_exam_end_time);


            $routine_base_student=SiteExamDeclareStudentSubject::with(['academicExamType'])
                ->whereIn('site_exam_routine_id', $routine_ids)
                ->whereIn('room_id', $selected_room_ids)
                ->select('id', 'room_id', 'column_position', 'student_history_id', 'site_exam_routine_id',
                    'seat_number', 'academic_exam_type_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
                    'exam_held_status', 'attendance_submit_by', 'attendance_submit_by_machine')
                ->get();

            $exam_type_ids=$routine_base_student->pluck('academic_exam_type_id')->unique()->values();
            $exam_type_list=AcademicExamType::whereIn('id', $exam_type_ids)->get();




            $room_student_ids=$routine_base_student->pluck('student_history_id')->unique();

            $student_details=StudentHistory::with(['department','stClass', 'shift', 'classGroup', 'section', 'session',
                'siteExamDeclareStudentSubject'=>function($query) use ($routine_ids, $selected_room_ids){
                    $query->with(['academicExamType']);
                    $query->whereIn('site_exam_routine_id', $routine_ids);
                    $query->whereIn('room_id', $selected_room_ids);
                    $query->select('id', 'room_id', 'column_position', 'student_history_id', 'site_exam_routine_id',
                        'seat_number', 'academic_exam_type_id', 'exam_attendance_status', 'site_subject_group_condition_setting_id',
                        'exam_held_status', 'attendance_submit_by', 'attendance_submit_by_machine');
                }])
                ->whereIn('id', $room_student_ids)
                ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                    'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->orderBy('academic_department_id', 'asc')
                ->orderBy('academic_class_id', 'asc')
                ->orderBy('academic_class_group_id', 'asc')
                ->orderBy('academic_section_id', 'asc')
                ->orderBy('student_roll_number', 'asc')
                ->get();


            //=============Invigilarot List====================



            $subject_list=SubjectGroupConditionSetting::with(['academicClass'])
                ->whereIn('id', $routine_base_student->pluck('site_subject_group_condition_setting_id')->unique()->values())
                ->get();



            $invigilator_arr=Array();
            $invigilator_array=[];
            foreach ($selected_room_ids as $keyRoom => $valueRoom) {

                $invigilator_list=SiteExamInvigilatorRoomSetup::with(['activeEmployee'])
                    ->where('room_id', $valueRoom)
                    ->where('exam_start_date', $exam_date)
                    ->where('exam_start_time', $request->examination_time)
                    ->where('status', true)
                    ->select('user_id')
                    ->get();


                $room_base_student_subject=$routine_base_student
                    ->where('room_id', $valueRoom)->values();



                $room_base_student_subject_condition_ids=$routine_base_student
                    ->where('room_id', $valueRoom)
                    ->pluck('site_subject_group_condition_setting_id')
                    ->unique()
                    ->values();

                $subject_arr=Array();
                $subject_array=[];
                foreach ($room_base_student_subject_condition_ids as $keySubject => $valueSubject) {

                    $subject_detail=$subject_list->where('id', $valueSubject)->first();

                    $subject_base_student_count=$room_base_student_subject
                        ->where('site_subject_group_condition_setting_id', $valueSubject)
                        ->pluck('student_history_id')
                        ->unique()
                        ->count();

                    $attend_student_count=$room_base_student_subject
                        ->where('site_subject_group_condition_setting_id', $valueSubject)
                        ->where('exam_attendance_status', true)
                        ->pluck('student_history_id')
                        ->unique()
                        ->count();



                    $subject_arr['subject_condition_id']=$valueSubject;
                    $subject_arr['subject_name']= $subject_detail->subject_name;
                    $subject_arr['class_name']= $subject_detail->academicClass->class_name;
                    $subject_arr['student_count']= $subject_base_student_count;
                    $subject_arr['attend_student_count']= $attend_student_count;

                    $subject_array[$keySubject]=$subject_arr;
                }


                $room_detail=Room::where('id', $valueRoom)->first();

                $invigilator_arr['room_name']= $room_detail['room_name_ex'];
                $invigilator_arr['room_id']= $valueRoom;
                $invigilator_arr['class_subject_list']= collect($subject_array)->values();
                $invigilator_arr['invigilator_list']= $invigilator_list;

                $invigilator_array[$keyRoom]=$invigilator_arr;

            }


        }
        else{

            return Response::json(['message' => 'Exam plan will be visible in you panel before 2 hours of exam.',
                'mode' => 'Error!'], 200);

        }




        return compact('student_details', 'invigilator_array', 'save_button_show_status', 'exam_type_list');





    }




    public function saveInvigilatorBaseManualExamAttendance(Request $request){


        $student_subject_attendance= collect($request->StudentListForAttendance)->pluck('site_exam_declare_student_subject')->collapse();

        $site_exam_routine_ids=$student_subject_attendance->pluck('site_exam_routine_id')->unique()->values();


        $check_exam_held_status_all_student=SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $site_exam_routine_ids)
            ->where('exam_attendance_status', true)
            ->first();

        $check_exam_held=$student_subject_attendance->where('exam_attendance_status', true)->first();

        if($check_exam_held_status_all_student && $check_exam_held){

            foreach ($student_subject_attendance as $key => $value) {
                $check_data=SiteExamDeclareStudentSubject::where('id', $value['id'])->first();
                if($check_data->exam_attendance_status!=$value['exam_attendance_status']){
                    $check_data->update([
                        'exam_attendance_status'=>$value['exam_attendance_status'],
                        'attendance_submit_by'=> Auth::user()->id,
                        'attendance_update_at'=>Carbon::now(),
                    ]);
                }
            }

        }
        else if(!$check_exam_held_status_all_student && $check_exam_held){

            SiteExamDeclareStudentSubject::whereIn('site_exam_routine_id', $site_exam_routine_ids)->update([
                'exam_held_status'=>true,
            ]);


            foreach ($student_subject_attendance as $key => $value) {
                $check_data=SiteExamDeclareStudentSubject::where('id', $value['id'])->first();
                if($check_data->exam_attendance_status!=$value['exam_attendance_status']){
                    $check_data->update([
                        'exam_attendance_status'=>$value['exam_attendance_status'],
                        'attendance_submit_by'=> Auth::user()->id,
                        'attendance_update_at'=>Carbon::now(),
                    ]);
                }
            }

        }


        return Response::json(['message' => 'Attendance Entry Successfully!', 'mode' => 'Create!'], 200);
    }







}
