<?php

namespace App\Http\Controllers\Site;

use App\Models\Employee\SiteCategoryPositionSetting;
use App\Models\Employee\SiteEmployeeCategoryPosition;
use App\Models\EmployeeCategory\EmpCategory;
use App\Models\EmployeePosition\EmpPosition;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class EmployeeCategoryPositionController extends Controller
{

    private $SiteEmployeeCategoryPosition;

    public function __construct(SiteEmployeeCategoryPosition $SiteEmployeeCategoryPosition)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->SiteEmployeeCategoryPosition = $SiteEmployeeCategoryPosition;
    }

    public function index()
    {
        $viewType = 'Site Employee Category Position Setting Page';


        return view('default.admin.site.employee.employee-category-position', compact('viewType'));

    }

    public function getSiteCategoryPositionList(){

        $siteInfolist=SiteInfo::select('emp_categorie_ids','emp_position_ids')
            ->where('id',Session::get('SITE_ID'))->first();


        $categorySplite = explode(',', $siteInfolist->emp_categorie_ids);
        $categoryList = EmpCategory::whereIn('id', $categorySplite)->get();


        $positionSplite = explode(',', $siteInfolist->emp_position_ids);
        $positionList = EmpPosition::whereIn('id', $positionSplite)->get();

        $categoryPositionPresent=SiteCategoryPositionSetting::get();

        if(count($categoryPositionPresent)<=0){
            $categoryPositionArray=[];
            $categoryPositionArr=Array();
            foreach ($categoryList as $key => $value) {

                $categoryPositionArray['select_category_id']=false;

                $positionArr=Array();
                $positionArray=[];
                foreach ($positionList as $keys => $values) {
                    $positionArr['select_position_id']=false;

                    $positionArray[$keys]=array_merge($values->toArray(), $positionArr);
                }

                $categoryPositionArray['position_list']=$positionArray;

                $categoryPositionArr[$key]=array_merge($value->toArray(), $categoryPositionArray);


            }

            return response()->json($categoryPositionArr, 200, [], JSON_NUMERIC_CHECK);
        }
        else{




            $categoryArray=[];
            $categoryArr=Array();
            foreach ($categoryList as $key => $value) {

                $categoryPresent=$categoryPositionPresent->where('emp_category_id',$value['id'])->first();

                if($categoryPresent){
                    $categoryArr['select_category_id']=true;

                }else{
                    $categoryArr['select_category_id']=false;
                }


                $positionArr=Array();
                $posotionArray=[];
                foreach ($positionList as $keys => $values) {
                    $categoryPositionList=$categoryPositionPresent
                        ->where('emp_category_id',$value['id'])
                        ->where('emp_position_id',$values['id'])
                        ->first();

                    if($categoryPositionList){
                        $positionArr['select_position_id']=true;
                    }else{
                        $positionArr['select_position_id']=false;
                    }
                    $posotionArray[$keys]=array_merge($values->toArray(), $positionArr);
                }

                $categoryArr['position_list']=$posotionArray;



                $categoryArray[$key]=array_merge($value->toArray(), $categoryArr);
            }

            return response()->json($categoryArray, 200, [], JSON_NUMERIC_CHECK);

        }


    }




    public function createUpdateSiteCategoryPosition(Request $request){


        $categoryPositionPresent=SiteCategoryPositionSetting::get();

        if(count($categoryPositionPresent)<=0){
            $charges=[];
            foreach ($request->categoryPositionList as $key => $value) {

                if($value['select_category_id']){

                    foreach ($value['position_list'] as $keys => $values) {
                        if($values['select_position_id']){
                            $charges[] = [
                                'emp_category_id'=>$value['id'],
                                'emp_position_id'=>$values['id'],
                                'status'=>true,
                                'site_id'=>Session::get('SITE_ID'),


                            ];

                        }

                    }

                }

            }

            if(count($charges)>0){
                SiteCategoryPositionSetting::insert($charges);
            }
        }
        else{

            $presentIDArray=$categoryPositionPresent->pluck('id');


            $charges=[];
            $presentID=Array();
            $presentTableIDArray=[];
            foreach ($request->categoryPositionList as $key => $value) {

                if($value['select_category_id']){

                    foreach ($value['position_list'] as $keys => $values) {
                        if($values['select_position_id']){

                            $checkPresentDate=$categoryPositionPresent
                                ->where('emp_category_id',$value['id'])
                                ->where('emp_position_id',$values['id'])
                                ->first();

                           // \Log::info($checkPresentDate);

                            if($checkPresentDate){
                                $presentID[$keys]=$checkPresentDate->id;
//                                \Log::info($presentID);
                            }else{
                                $charges[] = [
                                    'emp_category_id'=>$value['id'],
                                    'emp_position_id'=>$values['id'],
                                    'status'=>true,
                                    'site_id'=>Session::get('SITE_ID'),


                                ];
                            }



                        }

                    }

                }

                $presentTableIDArray[$key]=array_merge($presentID);

            }


            if(count($charges)>0){
                SiteCategoryPositionSetting::insert($charges);
            }


            $collection = collect($presentTableIDArray);
            $categoryArrayCollapsed = ($collection->collapse())->unique();



            $categoryAbsentCheck=array_diff($presentIDArray->toArray(), $categoryArrayCollapsed->toArray());


            SiteCategoryPositionSetting::whereIn('id', $categoryAbsentCheck)->delete();

        }




        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
    }











}
