<?php

namespace App\Http\Controllers\Site\Employee\Attendance;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Employee\EmployeeGeolocationSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Response;
use Session;

class EmployeeAttendanceSettingsController extends Controller
{
   

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

    }


    public function index()
    {
        $viewType = 'Employee Attendance Settings';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function updateEmployeeGeolocation(Request $request){
        try{
        $this->validate($request,[
            "latitude"=>"required",
            "longitude"=>"required",
            "radius"=>"required",
        ]);

        $checkSettings=EmployeeGeolocationSetting::where('id',$request->id)->first();
       
        if($checkSettings){
            $checkSettings->latitude=$request->latitude;
            $checkSettings->longitude=$request->longitude;
            $checkSettings->radius=$request->radius;
            $checkSettings->save();
        }else{

            $geoSetting= new EmployeeGeolocationSetting;

            $geoSetting->latitude=$request->latitude;
            $geoSetting->longitude=$request->longitude;
            $geoSetting->radius=$request->radius;
            $geoSetting->save();
        }

        return Response::json(['message'=>'Geolocation Update Successfully'],200);
    }catch (Exception $exception) {
        return Response::json(['message' => $exception->getMessage()], 410);
    }
        
    }

    public function getEmployeeGeolocation(){
        
        $checkSettings=EmployeeGeolocationSetting::first();

        return $checkSettings;

    }

    public function getEmployeeAttendanceSettings()
    {

        $the_setting = SiteInfoSetting::first();
        $data = [
            'emp_in_sms' => $the_setting->emp_in_sms,
            'emp_out_sms' => $the_setting->emp_out_sms,
            'regards_title' => $the_setting->regards_title,
            'sms_lang' => $the_setting->sms_lang,
        ];
       
        return response()->json($data, 200);

    }
    

    public function updateEmployeeAttendanceSettings(Request  $request)
    {

        try {
 
      //   $site_id = Session::get('SITE_ID');
 
         $the_setting = SiteInfoSetting::first();
 
         $the_setting->emp_in_sms = $request->emp_in_sms;
         $the_setting->emp_out_sms = $request->emp_out_sms;
         $the_setting->sms_lang = $request->sms_lang;
         $the_setting->regards_title = $request->regards_title;
         $the_setting->save();
 
        return response()->json(['data' => $the_setting, 'message' => 'Successfully Updated', 'mode' => 'update'], 200, []);
 
 
        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);
 
        } catch (Exception $exception) {
 
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
 
    }

  

}
