<?php

namespace App\Http\Controllers\Site\AssessmentResult;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\AssessmentResult\AssessmentResultPrimarySetting;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentPrimaryResultDetail;
use App\Models\Student\StudentHistory;
use Response;
use Session;

class SiteBaseAssessmentPrimaryResultGenerateController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Assessment Primary Result';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getAssessmentGeneratedList(Request $request){

        $data = $request->all();
       
        $student_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
        //                ->where('status', true)
                ->pluck('id');


           $assessmentResultDetailIds = SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_history_ids)
                ->pluck('assessment_id')
                ->unique()
                ->filter();


          $primary_type_ids =  AssessmentResultPrimarySetting::where('status', true)
                ->whereIn('assessment_id',$assessmentResultDetailIds)
                ->pluck('academic_assessment_result_primary_type_id')
                ->unique();
            $primary_result_type =  AcademicAssessmentPrimaryResultType::whereIn('id',$primary_type_ids)->get();

          
          $test_arr=Array();
          $resultlist=[];
          foreach ($primary_result_type as $key => $value){
  
          
              $check_result_present=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->pluck('id');

  
              if(count($check_result_present)>0){
                  $test_arr['result_generate_status']=true;
              }
              else{
                  $test_arr['result_generate_status']=false;
              }
  
  
              $check_result__publish_emp_panel=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->where('result_employee_publish_status', true)
                  ->first();
  
              $check_result_publish_std_panel=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->where('result_student_publish_status', true)
                  ->first();
  
              $check_result_publish_public=SiteStudentAssessmentPrimaryResultDetail::whereIn('student_history_id', $student_history_ids)
                  ->where('academic_assessment_result_primary_type_id', $value->id)
                  ->where('result_public_publish_status', true)
                  ->first();
  
              if($check_result__publish_emp_panel){
                  $test_arr['result_employee_publish_status']=true;
              }else{
                  $test_arr['result_employee_publish_status']=false;
              }
  
  
              if($check_result_publish_std_panel){
                  $test_arr['result_student_publish_status']=true;
              }else{
                  $test_arr['result_student_publish_status']=false;
              }
  
              if($check_result_publish_public){
                  $test_arr['result_public_publish_status']=true;
              }else{
                  $test_arr['result_public_publish_status']=false;
              }
  
  
  
              $test_arr['loading_result_generate_image']=false;
  
              $resultlist[$key]=array_merge($test_arr, $value->toArray());
          }
          
          return $resultlist;
          

    }


    public function createUpdateAssessmentPrimaryResult(Request $request){

        $data=$request->all();

       
        $resultSettingList = AssessmentResultPrimarySetting::with(['academicAssessmentPrimaryResultType', 'assessment'])
            ->where('academic_assessment_result_primary_type_id', $request->academic_assessment_result_primary_type_id)
            ->get();

        $assessmentIds=$resultSettingList->pluck('assessment_id');
  
        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', true)
                ->pluck('id');

   
        $assessmentResultList=SiteStudentAssessmentResultDetail::whereIn('assessment_id',$assessmentIds)
                ->whereIn('student_history_id',$student_list_ids)
                ->get();

        $assessment_type_ids=$assessmentResultList->pluck('assessment_type_id')->unique()->filter();

        foreach($assessment_type_ids as $assessment_type_id){

            
        $studentIdsList=$assessmentResultList->where('assessment_type_id',$assessment_type_id)
                ->pluck('student_history_id')
                ->unique()
                ->filter();
             
        $generateStudentRest=array_diff($studentIdsList->toArray(), $request->select_student_history_ids);

        if(count($generateStudentRest)>0){
            $tenStudentIDs=collect($generateStudentRest)->take(10);
        }else{
            $tenStudentIDs=[];
        }
       

        $generatedStudentIDs=array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);

        $classAllStudentlist=StudentHistory::whereIn('id', $studentIdsList)->pluck('id');

        foreach($classAllStudentlist as $key=>$student_history_id){

           
           
                $studentResultList = $assessmentResultList->where('student_history_id', $student_history_id)
                    ->where('assessment_type_id',$assessment_type_id);
                   

                $subject_wise_type_no_array=[];
                $subject_group_condition_setting_id_arrays=[];
                $all_type_no_result_array=[];
                $all_type_no_array=[];
                $st_key=0;
                $key=0;

                   
                foreach($studentResultList as $primaryResult){
                    foreach($primaryResult['result_details'] as $result){
                         
                        foreach($result['type_no_list'] as $type_no){
                            $all_type_no_array[$key]=$type_no['type_no_id'];
                            $all_type_no_result_array[$key]=$type_no;
                            $key++;
                        }
                        
                        $subject_wise_type_no_array[$st_key]=$result;
                        $subject_group_condition_setting_id_arrays[$st_key]=$result['site_subject_group_condition_setting_id'];
                        $st_key++;
                    }
                }

                $site_subject_group_condition_setting_ids=collect($subject_group_condition_setting_id_arrays)->unique()->filter();
            ///===== type wise Ressult =====
                 

                $unique_type_no_id_list=collect($all_type_no_array)->unique()->filter();
               
                $type_no_wise_result_details=[];
                $sw_keysss=0;

             

                foreach($unique_type_no_id_list as $type_no_id){
                    
                    $typeNoList=collect($all_type_no_result_array)->where('type_no_id',$type_no_id);
                    
                   $type_no=$typeNoList->first();
                   
                   
                   $triangle_count = count(collect($all_type_no_result_array)->where('type_no_id',$type_no_id)->where('assessment_type_no_total_mark','triangle'));
                   $circle_count = count(collect($all_type_no_result_array)->where('type_no_id',$type_no_id)->where('assessment_type_no_total_mark','circle'));
                   $rectangle_count = count(collect($all_type_no_result_array)->where('type_no_id',$type_no_id)->where('assessment_type_no_total_mark','rectangle'));
                 // dd($triangle_count);
                   $sw_perfomance_count=[
                    'triangle'=>$triangle_count,
                    'circle'=>$circle_count,
                    'rectangle'=>$rectangle_count,
                   ];
                   $maxSWValue = max($sw_perfomance_count);
                  
                   
                    if($maxSWValue){
                      $max_performance_sw_key = array_search($maxSWValue, $sw_perfomance_count);
                   }else{
                       $max_performance_sw_key='';
                   }

               

                if($type_no){

                   $type_no_wise_result_details[$sw_keysss]['expertise_id']=$type_no['expertise_id'];
                   $type_no_wise_result_details[$sw_keysss]['assessment_type_id']=$assessment_type_id;
                   $type_no_wise_result_details[$sw_keysss]['type_no_id']=$type_no['type_no_id'];
                   $type_no_wise_result_details[$sw_keysss]['type_no']=$type_no['type_no_name'];
                   $type_no_wise_result_details[$sw_keysss]['assessment_type_no_total_mark']=$max_performance_sw_key;

                   $sw_keysss++;
                }

                }

             //   return $type_no_wise_result_details;

    
            //==== type wise End ===

            //==== subject wise result start===

           
                $subject_array=[];
                $s_key=0;
                foreach($site_subject_group_condition_setting_ids as $subject_condition_id){
                   
                    $subject_type_no_list=collect($subject_wise_type_no_array)
                            ->where('site_subject_group_condition_setting_id',$subject_condition_id)
                            ->pluck('type_no_list');
                           
                    $type_no_array=[];
                    foreach($subject_type_no_list as $type_no_list){
                        foreach($type_no_list as $type_no){
                            $type_no_array[]=$type_no;
                        }
                                              
                    }
                    
                   

                    $type_no_ids=collect($type_no_array)
                       // ->where('topic_id', '!=', null)
                        ->pluck('type_no_id')
                        ->unique()
                        ->filter();

                    $keysss=0;
                    $type_no_details=[];
                    foreach($type_no_ids as $type_no_id){
                        $typeNoList=collect($type_no_array)
                           ->where('type_no_id',$type_no_id);
                         
                        $typeNo=$typeNoList->first();
                        
                        $triangle_count=count($typeNoList->where('assessment_type_no_total_mark','triangle'));
                           $circle_count=count($typeNoList->where('assessment_type_no_total_mark','circle'));
                           $rectangle_count=count($typeNoList->where('assessment_type_no_total_mark','rectangle'));
                          
                        $perfomance_count=[
                            'triangle'=>$triangle_count,
                            'circle'=>$circle_count,
                            'rectangle'=>$rectangle_count,
                           ];
                           $maxValue = max($perfomance_count);
                           if($maxValue){
                               $max_performance_key = array_search($maxValue, $perfomance_count);
                           }else{
                               $max_performance_key='';
                           }

                           if($typeNo){
                           //  $type_no_details[$keysss]['typeNoList']=$typeNoList;
                            $type_no_details[$keysss]['site_subject_group_condition_setting_id']=$subject_condition_id;
                            $type_no_details[$keysss]['expertise_id']=$typeNo['expertise_id'];
                            $type_no_details[$keysss]['assessment_type_id']=$assessment_type_id;
                            $type_no_details[$keysss]['type_no_id']=$typeNo['type_no_id'];
                            $type_no_details[$keysss]['type_no']=$typeNo['type_no_name'];
                            $type_no_details[$keysss]['assessment_type_no_subject_total_mark']=$max_performance_key;
                      
                            $keysss++;
                           }
                            
                        }
                        $subject_array[$s_key]['site_subject_group_condition_setting_id']=$subject_condition_id;
                        $subject_array[$s_key]['type_no_list']=$type_no_details;

                        $s_key++;

            }

             // ===== subject wise result end===

            
            $primaryResult = SiteStudentAssessmentPrimaryResultDetail::where('student_history_id',$student_history_id)
            ->where('academic_assessment_result_primary_type_id',$request->academic_assessment_result_primary_type_id)
            ->where('assessment_type_id',$assessment_type_id)
            ->first();

            if($assessment_type_id==1){
                $result_type_key='PI';
            }else{
                $result_type_key='BI';
            }

           // dd($type_no_wise_result_details);
            if($primaryResult){

                $primaryResult->result_details=json_encode($subject_array);
                $primaryResult->type_no_wise_result_details=json_encode($type_no_wise_result_details);
                $primaryResult->status=true;
                $primaryResult->save();
            }else{

            SiteStudentAssessmentPrimaryResultDetail::create([
                    'site_id'=>Session::get('SITE_ID'),
                    'student_history_id'=>$student_history_id,
                    'assessment_type_id'=>$assessment_type_id,
                    'academic_assessment_result_primary_type_id'=>$request->academic_assessment_result_primary_type_id,
                    'result_details'=>json_encode($subject_array),
                    'type_no_wise_result_details'=>json_encode($type_no_wise_result_details),
                    'result_type_key'=>$result_type_key,
                    'status'=>true,
                ]);

            }

    
        }
        }


        $count_student=count($classAllStudentlist);
        $completed_percent=ceil(count($generatedStudentIDs)*100/$count_student);


        if(count($tenStudentIDs)>0){

            return response()->json(
                [
                    'generatedStudentIDs'=>$generatedStudentIDs,
                    'count_student'=>$count_student,
                    'completed_percent'=>$completed_percent,
                ]);

        }else{
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }



    }
    


    public function publishPauseAssessmentResultToPanel(Request $request){

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');


        SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('assessment_declare_id', $request->assessment_declare_id)
            ->update([
                'result_employee_publish_status'=>$request->result_employee_publish_status,
                'result_student_publish_status'=>$request->result_student_publish_status,
                'result_public_publish_status'=>$request->result_public_publish_status,
            ]);


        if($request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && $request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Published to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Published to Employee & Pause to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if(!$request->result_employee_publish_status && !$request->result_student_publish_status){
            return Response::json(['message' => 'Result Pause to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        }
        else if($request->result_public_publish_status){
            return Response::json(['message' => 'Result Published to public', 'mode' => 'Saved!'], 200);
        }
        else if(!$$request->result_public_publish_status){
            return Response::json(['message' => 'Result Pause to public', 'mode' => 'Saved!'], 200);
        }


    }


    public function deleteAssessmentResultToPanel(Request $request){
        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
//                ->where('status', true)
            ->pluck('id');

           // dd($request->all());

        // SiteStudentAssessmentResultDetail::whereIn('student_history_id', $student_list_ids)
        //     ->where('assessment_declare_id', $request->assessment_declare_id)
        //     ->update([
        //         'result_employee_publish_status'=>0,
        //         'result_student_publish_status'=>0,
        //         'result_public_publish_status'=>0,
        //     ]);

        return Response::json(['message' => 'Assessment result Delete ', 'mode' => 'Saved!'], 200);

    }

}