<?php

namespace App\Http\Controllers\Site\AssessmentResult\Report;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAssessmentCombineResultType;
use App\Models\Academic\AcademicAssessmentPrimaryResultType;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Assessment\AssessmentResultScaleSystemSetting;
use App\Models\Assessment\AssessmentType;
use App\Models\Assessment\AssessmentTypeNo;
use App\Models\Site\Assessment\SiteAssessmentDeclare;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudent;
use App\Models\Site\Assessment\SiteAssessmentDeclareStudentSubject;
use App\Models\Site\Assessment\SiteIndividualCombineSubjectAssessmentResultStore;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentResultDetail;
use App\Models\Site\AssessmentResult\SiteAssessmentResultPrimarySetting;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentCombineFinalResultDetail;
use App\Models\Site\AssessmentResult\SiteStudentAssessmentPrimaryResultDetail;
use App\Models\Site\SiteInfo;
use App\Models\SiteGroup\Site\Employee\Employee;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Response;
use Session;
use PDF;
use Auth;
use View;
use Carbon\Carbon;
use Intervention\Image\Gd\Decoder;

class SiteBaseAssessmentFinalResultReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Assessment Primary Result Report';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteAssessmentFinalResultSheet(Request $request){

        $data = $request->all();
       
        $student_history_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
            return $query->where('academic_class_id', $data['academic_class_id']);
        })
        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
        })
        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
            return $query->where('academic_session_id', $data['academic_session_id']);
        })
//                ->where('status', true)
        ->pluck('id')
        ->unique()
        ->filter();
      
        $student_ids = SiteStudentAssessmentCombineFinalResultDetail::whereIn('student_history_id', $student_history_ids)
         //   ->where('academic_assessment_result_combine_type_id', $request->academic_assessment_result_combine_type_id)
            ->pluck('student_history_id')
            ->unique()
            ->filter();

        $studentHistories = StudentHistory::whereIn('id', $student_ids)->get();

        return $studentHistories;
        
    }



    public function getSiteStudentAssessmentFinalResultDetails(Request $request){

        $studentList=$this->studentHistoryList($request);
        $student_historys=$studentList->whereIn('id', $request->select_student_user_ids);
        $student_ids=$student_historys->pluck('id')->unique();
        
       
       // $typeNOList=AssessmentTypeNo::whereIn('id', $assessment_type_no_ids)->get();
      
        $assessmentResultDetails=SiteStudentAssessmentCombineFinalResultDetail::with(['studentHistory'=>function ($query) {
            $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                'registration_no');
            $query->with(['student' => function ($q) {
                $q->with('latestPhoto');
                $q->select('id');
                $q->where('user_type', 'student');
            },
                'year', 'shift','department','stClass','classGroup','session','section'
            ]);
        }])
            ->whereIn('student_history_id', $request->select_student_user_ids)
            ->whereIn('student_history_id', $student_ids)
         //   ->where('academic_assessment_result_primary_type_id', $request->academic_assessment_result_primary_type_id)
        //    ->where('assessment_type_id',$request->assessment_type_id)
            ->where('status', true)
            ->get();

        //    dd($assessmentResultDetails);


        /// new result ==========

        
        $site_subject_group_condition_setting_ids=[];
            $key=0;

            foreach($assessmentResultDetails as $primaryResult){
                foreach($primaryResult->result_details as $subject_list){
                    $site_subject_group_condition_setting_ids[$key]=$subject_list['site_subject_group_condition_setting_id'];
                    $key++;
                }
            }

    
            $subjct_condition_ids = collect($site_subject_group_condition_setting_ids)->unique()->filter();
            $subjects=SubjectGroupConditionSetting::whereIn('id', $subjct_condition_ids)->get();
          

        $student_array=[];

        $s_key=0;
        foreach($student_historys as $student_history){
           
           $assessment_type_list=AssessmentType::get();
     
            $type_list=[];
            $type_key=0;


           foreach($assessment_type_list as $assessment_type){
            $studentTypeResult=$assessmentResultDetails->where('student_history_id',$student_history->id)
                    ->where('assessment_type_id',$assessment_type->id)
                    ->first();
                  
            if($studentTypeResult){

           
            $resut=SiteStudentAssessmentCombineFinalResultDetail::where('id',$studentTypeResult->id)->first();
      

               $type_list[$type_key]['assessment_type_id']=$resut->assessmentType->id;
               $type_list[$type_key]['assessment_type_name']=$resut->assessmentType->type_name;
               $type_list[$type_key]['student_history']=$resut->studentHistory;
               $type_list[$type_key]['result_details']=$resut->result_details;
               $type_list[$type_key]['expertise_wise_result_details']=$resut->expertise_wise_result_details;
           
               $type_list[$type_key]['total_subject_count']=$resut->total_subject_count;
               $type_list[$type_key]['result_subject_count']=$resut->result_subject_count;
               $type_list[$type_key]['student_photo']=$resut->studentHistory->student->latestPhoto?$resut->studentHistory->student->latestPhoto->name:'image-not.png';
               
               $type_key++;
           }
           }

           $student_array[$s_key]['student_history']=$student_history;           
           $student_array[$s_key]['student_photo']=$student_history->student->latestPhoto?$student_history->student->latestPhoto->name:'image-not.png';

           $student_array[$s_key]['assessment_type_result']=$type_list;

           $s_key++;
        }

        return [$student_array,$subjects];
    
    }

    
   

    public function getSiteStudentAssessmentFinalResultSheetPdf(Request $request){

        ini_set('memory_limit', '-1');
        $data = $request->all();

    //   $is_qrcode = $data['is_qrcode'];
       $is_stdImage = $data['is_stdImage'];
    //   $is_academic_perform = $data['is_academic_perform'];
       $head_signature_status =$data['head_signature_status'];

        $report_tittle='';
        $report_tittle2='';

       $primaryResultList =  $this->getSiteStudentAssessmentFinalResultDetails($request);
      // return 
      //dd($primaryResultList);

       $result_list_array=$primaryResultList[0];
       $subjects_list=$primaryResultList[1];

       $scale_settings_list=AssessmentResultScaleSystemSetting::with('assessmentScale')
            ->where('status', true)->orderBy('graph_level','DESC')
            ->get();
        $academic_year = AcademicYear::findOrFail($request->academic_year_id);

  //     dd($result_list_array);

     
        //============ domain name =============
        $result_type =  AcademicAssessmentCombineResultType::first();
        $site_info =  SiteInfo::findOrFail(Session::get('SITE_ID'));
        if($site_info->domain_name==null){
             $alias = $site_info->site_alias;
            $url = config('app.url');
            $parsedUrl = parse_url($url);
            $host = $parsedUrl['host'];
            $host_names = explode(".", $host);
            $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

            if ($host_names[count($host_names) - 1] == 'bd') {
                $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
            }
            if (count($host_names) == 2) {
                $bottom_host_name = $host_names[count($host_names) - 1];
            }
            $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
      
        }else{
            $domain = $site_info->domain_name;
        }

        $institute_head = Employee::where('institute_head', 1)->first();
 
        $head_signature = $institute_head->signature ?? '/img/signature/signature.png';
        $head_designation = $institute_head->designation->name ?? 'Institution Head';

         //===========

        $view = View::make('default.admin.site.assessment.site-base-multiple-student-assessment-final-result-detail-report',
                compact('result_list_array','subjects_list', 'site_info','scale_settings_list','result_type', 'report_tittle', 'report_tittle2', 'domain',
                'head_signature','head_designation','is_stdImage','head_signature_status','academic_year'));
              //  ->setWarnings(false);

        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $name = $time . '.pdf';
        
        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);
    }


    private function studentHistoryList(Request $requests){

        $data=$requests->all();
       
        $studentList=StudentHistory::with('year', 'shift','department','stClass','classGroup','session','section')
            ->where('academic_version_id', $requests->academic_version_id)
            ->where('academic_year_id', $requests->academic_year_id)
            ->where('academic_shift_id', $requests->academic_shift_id)
            ->where('academic_class_id', $requests->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_class_id')
            ->get();

      
        return $studentList;

    }



}
