<?php

namespace App\Http\Controllers\Site\Accounts\Report;

use App\Models\Site\Accounts\Accounts;
use App\Models\Site\Accounts\AccountsVoucherDetails;
use App\Models\Site\Accounts\Ledger;
use App\Models\Site\Accounts\SiteAccountsFixedAsset;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use Auth;
use Illuminate\Support\Facades\Log;
use Response;
use Storage;
use Session;
use PDF;
class SiteAccountsReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Accounts report";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getLedgerDetailsList(Request $request)
    {
//        return $request;
        //================validation==================
        if(!$request->from_date || !$request->to_date){
            throw new Error('Please, fill all * mark fields!');
        }
        if(!$request->from_date > $request->to_date){
            throw new Error('Sorry! From date can not be greater than to date!');
        }
        //============================================
        $ledger_id = $request->accounts_ledger_id ? $request->accounts_ledger_id['id'] : '';
        $from_date = date( $request->from_date) ;
        $to_date = date($request->to_date);

        $ledger_list = Ledger::when($ledger_id, function ($q) use($ledger_id){
            $q->where('id', $ledger_id);
        })->get();

//        return $ledger_list;

        $final_ledger_data_list = [];


        $fixed_depriciation_list = [];
        $depriciation_particular = [];
        $fixed_depriciation_srl = 0;
        $total_depriciation_credit_amount = 0;
        $final_data_srl = 0;

        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){

                $data_list = [];

                $total_debit = 0;
                $total_credit = 0;
                $amount = 0;
                $srl = 0;

                $total_debit_for_opening_balance = 0;
                $total_credit_for_opening_balance = 0;

                //=========================for opening balance====================
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                $accounts_list_for_opening_balance = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($upto_date){
                        $q->where('transaction_date', '<=', $upto_date);
                    }) ->get();
                if (count($accounts_list_for_opening_balance)){
                    foreach ($accounts_list_for_opening_balance as $kky => $vvl){

                        if($vvl->entry == 'dr'){
                            $total_debit_for_opening_balance+= $vvl->debit_amount;
                        }
                        if($vvl->entry == 'cr'){
                            $total_credit_for_opening_balance+= $vvl->credit_amount;
                        }

                    }
                }

                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $depriciation_found_status = 0;
                $amortization_found_status = 0;

                $depriciation_amount_for_opening_balance = 0;

                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){

                        //====================fixed asset days for openning balance============
                        $diff_days = 0;
                        $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                        if($upto_date <  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $upto_date;
                            $to = Carbon::parse($end_date);
                            $diff_days = $to->diffInDays($from);
                        }
                        //=========================Depriciation and Amortization===========================
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }

                        $diff_in_days = 0;
                        if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $start_date = $from_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }

                        if($vvv->depriciation_status){
                            $depriciation_found_status = 1;
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                                $depriciation_amount_for_opening_balance = round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            $amortization_found_status = 1;
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;
                                $depriciation_amount_for_opening_balance =  round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;

                            }
                        }
                    }
                }

                //================================================================

                $accounts_voucher_list = AccountsVoucherDetails::whereBetween('transaction_date',
                    [$from_date, $to_date])->get();
                if(count($accounts_voucher_list)>0){
                    foreach ($accounts_voucher_list as $key => $va){
//                        return $va;
                        if($va->voucher_type == 'debitvoucher'){

                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $accounts_list;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){
                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();

//                                        return $opos_ledger_count;
                                        if($opos_ledger_count == 1){
                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            $opos_ledger_account_list_final->credit_amount = $ledger_head_list->debit_amount;
                                            $total_credit+=  0;
                                            $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                            $srl++;

                                        }else if($opos_ledger_count > 1){

                                            $amount = $ledger_head_list->debit_amount / $opos_ledger_count;

                                            foreach ($opos_ledger_account_list as $kkk => $vv){
                                                $vv->credit_amount = $amount;
                                                $total_credit+= 0;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }

                                    }else if ($ledger_head_list->entry == 'cr'){
//                                        return 'ok';
                                        $total_credit+= $ledger_head_list->credit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);

                                        $opoa_ledger_account_count = $accounts_list->where('entry','!=', $ledger_head_list->entry)->count();
                                        $same_ledger_account_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();

                                        if($same_ledger_account_count == 1){
                                            foreach ($opos_ledger_account_list as $kkk => $vv){
                                                $total_debit+= 0;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }else{
                                            $amount = $ledger_head_list->credit_amount / $opoa_ledger_account_count;
                                            foreach ($opos_ledger_account_list as $kkk => $vv){
                                                $total_debit+= 0;
                                                $vv->debit_amount = $amount;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }



                                    }
                                }

                            }

                        }else if($va->voucher_type == 'creditvoucher'){
                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $va;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){

                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_account_count = $opos_ledger_account_list->count();

                                        $same_account_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();
                                        $total_credit+= 0;
                                        if($same_account_count == 1){
                                            foreach ($opos_ledger_account_list as $kkk => $vv){
//                                                $total_credit+= $vv->credit_amount;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }else{

                                            if($opos_account_count > 1){
                                                $amount = $ledger_head_list->debit_amount/$opos_account_count;
                                                foreach ($opos_ledger_account_list as $kkk => $vv){
                                                    $vv->credit_amount = $amount;
                                                    $data_list[$srl]['data'] = $vv;
                                                    $srl++;
                                                }
                                            }

                                        }

                                    }else if ($ledger_head_list->entry == 'cr'){

                                        $total_credit+= $ledger_head_list->credit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();

//                                        return $opos_ledger_count;
                                        if($opos_ledger_count == 1){
                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            $opos_ledger_account_list_final->debit_amount = $ledger_head_list->credit_amount;
                                            $total_debit+=  0;
                                            $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                            $srl++;

                                        }else if($opos_ledger_count > 1){

                                            $amount = $ledger_head_list->credit_amount / $opos_ledger_count;

                                            foreach ($opos_ledger_account_list as $kkk => $vv){
                                                $vv->debit_amount = $amount;
//                                                $total_debit+= $amount;
                                                $total_debit+= 0;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }

                                    }

                                }

                            }
                        }else if($va->voucher_type == 'journalvoucher'){

                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $accounts_list;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){
                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();

//                                        $same_ledger_account_list = $accounts_list->where('entry', $ledger_head_list->entry);
                                        $same_ledger_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();


                                        if($opos_ledger_count == 1){

                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            if($same_ledger_count == 1){
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_credit+=  0;
                                                $srl++;
                                            }else{
                                                $opos_ledger_account_list_final->credit_amount =  $ledger_head_list->debit_amount;
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_credit+=  0;
                                                $srl++;
                                            }

                                        }else if($opos_ledger_count > 1){

                                            if($same_ledger_count == 1){
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_credit+=  0;
                                                    $srl++;
                                                }

                                            }else{
                                                $amount = $ledger_head_list->debit_amount / $opos_ledger_count;
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $vvv->credit_amount = $amount;
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_credit+=  0;
                                                    $srl++;
                                                }
                                            }
                                        }

                                    }else if ($ledger_head_list->entry == 'cr'){

                                        $total_credit+= $ledger_head_list->credit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();
                                        $same_ledger_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();

                                        if($opos_ledger_count == 1){
                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            if($same_ledger_count == 1){
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_debit+=  0;
                                                $srl++;
                                            }else{
                                                $opos_ledger_account_list_final->debit_amount = $ledger_head_list->credit_amount;
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_debit+=  0;
                                                $srl++;
                                            }

                                        }else if($opos_ledger_count > 1){

                                            if($same_ledger_count == 1){
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_debit+=  0;
                                                    $srl++;
                                                }

                                            }else{
                                                $amount = $ledger_head_list->credit_amount / $opos_ledger_count;
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $vvv->debit_amount = $amount;
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_debit+=  0;
                                                    $srl++;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }else{
                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $accounts_list;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){
                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry)->first();
                                        $data_list[$srl]['data'] = $opos_ledger_account_list;
                                        $total_credit+=  0;
                                        $srl++;

                                    }else if ($ledger_head_list->entry == 'cr'){

                                        $total_credit+= $ledger_head_list->credit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry)->first();
                                        $data_list[$srl]['data'] = $opos_ledger_account_list;
                                        $total_debit+=  0;
                                        $srl++;

                                    }

                                }

                            }
                        }

                    }
                    $final_ledger_data_list[$final_data_srl]['data_list'] = $data_list;
                    if($value->root == 'currentasset' || $value->root == 'fixedasset'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';

                    }else if($value->root == 'currentliability' || $value->root == 'longtermliability'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'income'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'expense'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';
                    }
                    $final_ledger_data_list[$final_data_srl]['ledger_account'] = $value;

                    $final_ledger_data_list[$final_data_srl]['total_credit'] = $total_credit + $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit'] = $total_debit + $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_credit_for_opening_balance'] = $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit_for_opening_balance'] = $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['opening_balance'] = $total_debit_for_opening_balance - $total_credit_for_opening_balance;

                    $total_amount = ($total_debit + $total_debit_for_opening_balance) - ($total_credit + $total_credit_for_opening_balance);
                    $final_ledger_data_list[$final_data_srl]['total_amount'] = $total_amount;


                    $final_ledger_data_list[$final_data_srl]['upto_date_for_opening_balance'] = $upto_date;

                    $final_data_srl++;

                }






                if($depriciation_found_status || $amortization_found_status){
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = $value->name;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = "Fixed Asset, Accumulated Depriciation";
                    $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'dr';
                    $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = "";

                    $total_depriciation_credit_amount+=$depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['particular'] = $value->name;
                    $depriciation_particular[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $depriciation_particular[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['amount_for_opening_balance'] = $depriciation_amount_for_opening_balance;

                    $fixed_depriciation_srl++;

                }
            }
            if($total_depriciation_credit_amount > 0){
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = "Fixed Asset, Accumulated Depriciation";
                $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = $value->name;
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = 50001;
                $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $total_depriciation_credit_amount;
                $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'cr';
                $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = $depriciation_particular;
//                $fixed_depriciation_list[$fixed_depriciation_srl]['code'] = $depriciation_particular;
            }
        }

        return [$final_ledger_data_list,$fixed_depriciation_list];
    }

    public function getLedgerDetailsListForTrialBalanceSingleDateWiseReport(Request $request)
    {
//        return $request;
        //================validation==================
        if(!$request->at_date){
            throw new Error('Please, fill all * mark fields!');
        }

        //============================================
        $ledger_id = $request->accounts_ledger_id ? $request->accounts_ledger_id['id'] : '';
        $at_date = date( $request->at_date) ;



        $ledger_list = Ledger::when($ledger_id, function ($q) use($ledger_id){
            $q->where('id', $ledger_id);
        })->get();
        //   $ledger_list = Ledger::where('id', 385)->get();

//        return $ledger_list;

        $final_ledger_data_list = [];


        $fixed_depriciation_list = [];
        $depriciation_particular = [];
        $fixed_depriciation_srl = 0;
        $total_depriciation_credit_amount = 0;
        $final_data_srl = 0;

        $total_d = 0;
        $total_c = 0;

        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){

                $data_list = [];

                $total_debit = 0;
                $total_credit = 0;
                $amount = 0;
                $srl = 0;

                $total_debit_for_opening_balance = 0;
                $total_credit_for_opening_balance = 0;

                //=========================for opening balance====================
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($at_date)));
                 $accounts_list_for_opening_balance = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($upto_date){
                        $q->where('transaction_date', '<=', $upto_date);
                    }) ->get();
                // if (count($accounts_list_for_opening_balance)){
                //     foreach ($accounts_list_for_opening_balance as $kky => $vvl){

                //         if($vvl->entry == 'dr'){
                //             $total_debit_for_opening_balance+= $vvl->debit_amount;
                //         }
                //         if($vvl->entry == 'cr'){
                //             $total_credit_for_opening_balance+= $vvl->credit_amount;
                //         }

                //     }
                // }


                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $depriciation_found_status = 0;
                $amortization_found_status = 0;

                $depriciation_amount_for_opening_balance = 0;

                // $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                // if(count($site_account_fixed_asset)){

                //     foreach ($site_account_fixed_asset as $kkk => $vvv){

                //         //====================fixed asset days for openning balance============
                //         $diff_days = 0;
                //         $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                //         if($upto_date <  date($vvv->active_date)){
                //             $from = Carbon::parse($vvv->active_date);
                //             $end_date = $upto_date;
                //             $to = Carbon::parse($end_date);
                //             $diff_days = $to->diffInDays($from);
                //         }
                //         //=========================Depriciation and Amortization===========================
                //         if($vvv->life_time_calculation_method == 'yearly'){
                //             $total_days = 365 * $vvv->life_time;
                //         }else if($vvv->life_time_calculation_method == 'monthly'){
                //             $total_days = 30 * $vvv->life_time;
                //         }else if($vvv->life_time_calculation_method == 'quarterly'){
                //             $total_days = 120 * $vvv->life_time;
                //         }else if($vvv->life_time_calculation_method == 'halfyearly'){
                //             $total_days = 180 * $vvv->life_time;
                //         }

                //         $diff_in_days = 0;
                //         if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                //             $start_date = $from_date;
                //             $from = Carbon::parse($start_date);
                //             $end_date = $to_date;
                //             $to = Carbon::parse($end_date);
                //             $diff_in_days = $to->diffInDays($from);
                //         }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                //             $from = Carbon::parse($vvv->active_date);
                //             $end_date = $to_date;
                //             $to = Carbon::parse($end_date);
                //             $diff_in_days = $to->diffInDays($from);
                //         }

                //         if($vvv->depriciation_status){
                //             $depriciation_found_status = 1;
                //             if($vvv->depriciation_type == 'sldm'){
                //                 $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                //                 $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                //             }else if($vvv->depriciation_type == 'fixed'){
                //                 $total_depriciation_amount = $vvv->depriciation_amount;
                //                 $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                //             }else if($vvv->depriciation_type == 'percentage'){
                //                 $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                //                 $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                //             }
                //             if($vvv->count_type == 'round'){
                //                 $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                //                 $depriciation_amount = round($depriciation_amount);
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                //                 $depriciation_amount_for_opening_balance = round($depriciation_amount_for_opening_balance);

                //             }else{
                //                 $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                //             }

                //         }else if($vvv->amortization_status){
                //             $amortization_found_status = 1;
                //             if($vvv->depriciation_type == 'fixed'){
                //                 $total_amortazation_amount = $vvv->amortization_amount;
                //                 $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                //             }else if($vvv->amortization_type == 'percentage'){
                //                 $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                //                 $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                //             }
                //             if($vvv->count_type == 'round'){
                //                 $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                //                 $depriciation_amount =  round($depriciation_amount);
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;
                //                 $depriciation_amount_for_opening_balance =  round($depriciation_amount_for_opening_balance);

                //             }else{
                //                 $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;

                //             }
                //         }
                //     }
                // }

                //================================================================

                $accounts_list = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($at_date ){
                        $q->where('transaction_date','<=',$at_date);
                    })
                    ->with('ledger')
                    ->with('accVoucherDetails')
                    ->get();
//                return $accounts_list;

                if(count($accounts_list)>0){
                    foreach ($accounts_list as $kkkk => $vvv){
                        if($vvv->entry == 'dr'){
                            $total_debit+= $vvv->debit_amount;
                            $total_d+= $vvv->debit_amount;
                        }else{
                            $total_credit+= $vvv->credit_amount;
                            $total_c+= $vvv->credit_amount;
                        }
                    }
                    $data_list = [];

                    $final_ledger_data_list[$final_data_srl]['data_list'] = $data_list;
                    if($value->root == 'currentasset' || $value->root == 'fixedasset'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';

                    }else if($value->root == 'currentliability' || $value->root == 'longtermliability'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'income'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'expense'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';
                    }
                    $final_ledger_data_list[$final_data_srl]['ledger_account'] = $value;

                     $final_ledger_data_list[$final_data_srl]['total_credit'] = $total_credit + $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit'] = $total_debit + $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_credit_for_opening_balance'] = $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit_for_opening_balance'] = $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['opening_balance'] = $total_debit_for_opening_balance - $total_credit_for_opening_balance;

                    $total_amount = ($total_debit + $total_debit_for_opening_balance) - ($total_credit + $total_credit_for_opening_balance);
                    $final_ledger_data_list[$final_data_srl]['total_amount'] = $total_amount;


                    $final_ledger_data_list[$final_data_srl]['upto_date_for_opening_balance'] = $upto_date;

                    $final_data_srl++;
                }



                if($depriciation_found_status || $amortization_found_status){
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = $value->name;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = "Fixed Asset, Accumulated Depriciation";
                    $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'dr';
                    $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = "";

                    $total_depriciation_credit_amount+=$depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['particular'] = $value->name;
                    $depriciation_particular[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $depriciation_particular[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['amount_for_opening_balance'] = $depriciation_amount_for_opening_balance;

                    $fixed_depriciation_srl++;

                }
            }
            if($total_depriciation_credit_amount > 0){
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = "Fixed Asset, Accumulated Depriciation";
                $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = $value->name;
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = 50001;
                $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $total_depriciation_credit_amount;
                $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'cr';
                $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = $depriciation_particular;
//                $fixed_depriciation_list[$fixed_depriciation_srl]['code'] = $depriciation_particular;
            }
        }
        // return $total_d .'-'. $total_c;


        return [$final_ledger_data_list,$fixed_depriciation_list];
    }
    public function getLedgerDetailsListForTrialBalanceReport(Request $request)
    {
//        return $request;
        //================validation==================
        if(!$request->from_date || !$request->to_date){
            throw new Error('Please, fill all * mark fields!');
        }
        if(!$request->from_date > $request->to_date){
            throw new Error('Sorry! From date can not be greater than to date!');
        }

        //============================================
        $ledger_id = $request->accounts_ledger_id ? $request->accounts_ledger_id['id'] : '';
        $from_date = date( $request->from_date) ;
        $to_date = date($request->to_date);


        $ledger_list = Ledger::when($ledger_id, function ($q) use($ledger_id){
            $q->where('id', $ledger_id);
        })->get();

//        return $ledger_list;

        $final_ledger_data_list = [];


        $fixed_depriciation_list = [];
        $depriciation_particular = [];
        $fixed_depriciation_srl = 0;
        $total_depriciation_credit_amount = 0;
        $final_data_srl = 0;

        $total_d = 0;
        $total_c = 0;

        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){

                $data_list = [];

                $total_debit = 0;
                $total_credit = 0;
                $amount = 0;
                $srl = 0;

                $total_debit_for_opening_balance = 0;
                $total_credit_for_opening_balance = 0;

                //=========================for opening balance====================
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                $accounts_list_for_opening_balance = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($upto_date){
                        $q->where('transaction_date', '<=', $upto_date);
                    }) ->get();
                if (count($accounts_list_for_opening_balance)){
                    foreach ($accounts_list_for_opening_balance as $kky => $vvl){

                        if($vvl->entry == 'dr'){
                            $total_debit_for_opening_balance+= $vvl->debit_amount;
                        }
                        if($vvl->entry == 'cr'){
                            $total_credit_for_opening_balance+= $vvl->credit_amount;
                        }

                    }
                }

                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $depriciation_found_status = 0;
                $amortization_found_status = 0;

                $depriciation_amount_for_opening_balance = 0;

                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){

                        //====================fixed asset days for openning balance============
                        $diff_days = 0;
                        $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                        if($upto_date <  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $upto_date;
                            $to = Carbon::parse($end_date);
                            $diff_days = $to->diffInDays($from);
                        }
                        //=========================Depriciation and Amortization===========================
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }

                        $diff_in_days = 0;
                        if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $start_date = $from_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }

                        if($vvv->depriciation_status){
                            $depriciation_found_status = 1;
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                                $depriciation_amount_for_opening_balance = round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            $amortization_found_status = 1;
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;
                                $depriciation_amount_for_opening_balance =  round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;

                            }
                        }
                    }
                }

                //================================================================

                $accounts_list = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($from_date, $to_date){
                        $q->whereBetween('transaction_date',[ $from_date,$to_date]);
                    })
                    ->with('ledger')
                    ->with('accVoucherDetails')
                    ->get();
//                return $accounts_list;

                if(count($accounts_list)>0){
                    foreach ($accounts_list as $kkkk => $vvv){
                        if($vvv->entry == 'dr'){
                            $total_debit+= $vvv->debit_amount;
                            $total_d+= $vvv->debit_amount;
                        }else{
                            $total_credit+= $vvv->credit_amount;
                            $total_c+= $vvv->credit_amount;
                        }
                    }
                    $data_list = [];

                    $final_ledger_data_list[$final_data_srl]['data_list'] = $data_list;
                    if($value->root == 'currentasset' || $value->root == 'fixedasset'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';

                    }else if($value->root == 'currentliability' || $value->root == 'longtermliability'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'income'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'expense'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';
                    }
                    $final_ledger_data_list[$final_data_srl]['ledger_account'] = $value;

                    $final_ledger_data_list[$final_data_srl]['total_credit']                     = $total_credit + $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit']                      = $total_debit + $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_credit_for_opening_balance'] = $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit_for_opening_balance']  = $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['opening_balance']                  = $total_debit_for_opening_balance - $total_credit_for_opening_balance;

                    $total_amount = ($total_debit + $total_debit_for_opening_balance) - ($total_credit + $total_credit_for_opening_balance);
                    $final_ledger_data_list[$final_data_srl]['total_amount'] = $total_amount;


                    $final_ledger_data_list[$final_data_srl]['upto_date_for_opening_balance'] = $upto_date;

                    $final_data_srl++;
                }



                if($depriciation_found_status || $amortization_found_status){
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = $value->name;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code']    = $value->ledger_code;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['particular']     = "Fixed Asset, Accumulated Depriciation";
                    $fixed_depriciation_list[$fixed_depriciation_srl]['amount']         = $depriciation_amount;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['entry']          = 'dr';
                    $fixed_depriciation_list[$fixed_depriciation_srl]['data']           = "";

                    $total_depriciation_credit_amount+=$depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['particular']  = $value->name;
                    $depriciation_particular[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $depriciation_particular[$fixed_depriciation_srl]['amount']      = $depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['amount_for_opening_balance'] = $depriciation_amount_for_opening_balance;

                    $fixed_depriciation_srl++;

                }
            }
            if($total_depriciation_credit_amount > 0){
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = "Fixed Asset, Accumulated Depriciation";
                $fixed_depriciation_list[$fixed_depriciation_srl]['particular']     = $value->name;
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code']    = 50001;
                $fixed_depriciation_list[$fixed_depriciation_srl]['amount']         = $total_depriciation_credit_amount;
                $fixed_depriciation_list[$fixed_depriciation_srl]['entry']          = 'cr';
                $fixed_depriciation_list[$fixed_depriciation_srl]['data']           = $depriciation_particular;
//                $fixed_depriciation_list[$fixed_depriciation_srl]['code'] = $depriciation_particular;
            }
        }
        // return $total_d .'-'. $total_c;


        return [$final_ledger_data_list,$fixed_depriciation_list];
    }

    public function getLedgerPDF($from_date, $to_date, $ledger_id = null)
    {
        $view_title = 'Ledger Report PDF';

        $ledger_list = Ledger::when($ledger_id, function ($q) use($ledger_id){
            $q->where('id', $ledger_id);
        })->get();

//        return $ledger_list;

        $final_ledger_data_list = [];


        $fixed_depriciation_list = [];
        $depriciation_particular = [];
        $fixed_depriciation_srl = 0;
        $total_depriciation_credit_amount = 0;
        $final_data_srl = 0;

        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){


                $data_list = [];

                $total_debit = 0;
                $total_credit = 0;
                $amount = 0;
                $srl = 0;

                $total_debit_for_opening_balance = 0;
                $total_credit_for_opening_balance = 0;

                //=========================for opening balance====================
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                $accounts_list_for_opening_balance = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($upto_date){
                        $q->where('transaction_date', '<=', $upto_date);
                    }) ->get();
                if (count($accounts_list_for_opening_balance)){
                    foreach ($accounts_list_for_opening_balance as $kky => $vvl){

                        if($vvl->entry == 'dr'){
                            $total_debit_for_opening_balance+= $vvl->debit_amount;
                        }
                        if($vvl->entry == 'cr'){
                            $total_credit_for_opening_balance+= $vvl->credit_amount;
                        }

                    }
                }

                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $depriciation_found_status = 0;
                $amortization_found_status = 0;

                $depriciation_amount_for_opening_balance = 0;

                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){

                        //====================fixed asset days for openning balance============
                        $diff_days = 0;
                        $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                        if($upto_date <  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $upto_date;
                            $to = Carbon::parse($end_date);
                            $diff_days = $to->diffInDays($from);
                        }
                        //=========================Depriciation and Amortization===========================
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }

                        $diff_in_days = 0;
                        if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $start_date = $from_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }

                        if($vvv->depriciation_status){
                            $depriciation_found_status = 1;
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                                $depriciation_amount_for_opening_balance = round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            $amortization_found_status = 1;
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;
                                $depriciation_amount_for_opening_balance =  round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;

                            }
                        }
                    }
                }

                //================================================================

                $accounts_voucher_list = AccountsVoucherDetails::whereBetween('transaction_date',
                    [$from_date, $to_date])->get();
                if(count($accounts_voucher_list)>0){
                    foreach ($accounts_voucher_list as $key => $va){
//                        return $va;
                        if($va->voucher_type == 'debitvoucher'){

                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $accounts_list;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){
                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();

//                                        return $opos_ledger_count;
                                        if($opos_ledger_count == 1){
                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            $opos_ledger_account_list_final->credit_amount = $ledger_head_list->debit_amount;
                                            $total_credit+=  0;
                                            $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                            $srl++;

                                        }else if($opos_ledger_count > 1){

                                            $amount = $ledger_head_list->debit_amount / $opos_ledger_count;

                                            foreach ($opos_ledger_account_list as $kkk => $vv){
                                                $vv->credit_amount = $amount;
                                                $total_credit+= 0;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }

                                    }else if ($ledger_head_list->entry == 'cr'){
//                                        return 'ok';
                                        $total_credit+= $ledger_head_list->credit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);

                                        foreach ($opos_ledger_account_list as $kkk => $vv){
                                            $total_debit+= 0;
                                            $data_list[$srl]['data'] = $vv;
                                            $srl++;
                                        }

                                    }
                                }

                            }

                        }else if($va->voucher_type == 'creditvoucher'){
                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $va;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){

                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_account_count = $opos_ledger_account_list->count();

                                        $same_account_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();
                                        $total_credit+= 0;
                                        if($same_account_count == 1){
                                            foreach ($opos_ledger_account_list as $kkk => $vv){
//                                                $total_credit+= $vv->credit_amount;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }else{

                                            if($opos_account_count > 1){
                                                $amount = $ledger_head_list->debit_amount/$opos_account_count;
                                                foreach ($opos_ledger_account_list as $kkk => $vv){
                                                    $vv->credit_amount = $amount;
                                                    $data_list[$srl]['data'] = $vv;
                                                    $srl++;
                                                }
                                            }

                                        }

                                    }else if ($ledger_head_list->entry == 'cr'){

                                        $total_credit+= $ledger_head_list->credit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();

//                                        return $opos_ledger_count;
                                        if($opos_ledger_count == 1){
                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            $opos_ledger_account_list_final->debit_amount = $ledger_head_list->credit_amount;
                                            $total_debit+=  0;
                                            $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                            $srl++;

                                        }else if($opos_ledger_count > 1){

                                            $amount = $ledger_head_list->credit_amount / $opos_ledger_count;

                                            foreach ($opos_ledger_account_list as $kkk => $vv){
                                                $vv->debit_amount = $amount;
//                                                $total_debit+= $amount;
                                                $total_debit+= 0;
                                                $data_list[$srl]['data'] = $vv;
                                                $srl++;
                                            }
                                        }

                                    }

                                }

                            }
                        }else if($va->voucher_type == 'journalvoucher'){

                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $accounts_list;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){
                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;

                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();

//                                        $same_ledger_account_list = $accounts_list->where('entry', $ledger_head_list->entry);
                                        $same_ledger_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();


                                        if($opos_ledger_count == 1){

                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            if($same_ledger_count == 1){
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_credit+=  0;
                                                $srl++;
                                            }else{
                                                $opos_ledger_account_list_final->credit_amount =  $ledger_head_list->debit_amount;
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_credit+=  0;
                                                $srl++;
                                            }

                                        }else if($opos_ledger_count > 1){

                                            if($same_ledger_count == 1){
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_credit+=  0;
                                                    $srl++;
                                                }

                                            }else{
                                                $amount = $ledger_head_list->debit_amount / $opos_ledger_count;
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $vvv->credit_amount = $amount;
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_credit+=  0;
                                                    $srl++;
                                                }
                                            }
                                        }

                                    }else if ($ledger_head_list->entry == 'cr'){

                                        $total_credit+= $ledger_head_list->credit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry);
                                        $opos_ledger_count = $opos_ledger_account_list->count();
                                        $same_ledger_count = $accounts_list->where('entry', $ledger_head_list->entry)->count();

                                        if($opos_ledger_count == 1){
                                            $opos_ledger_account_list_final = $opos_ledger_account_list->first();
                                            if($same_ledger_count == 1){
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_debit+=  0;
                                                $srl++;
                                            }else{
                                                $opos_ledger_account_list_final->debit_amount = $ledger_head_list->credit_amount;
                                                $data_list[$srl]['data'] = $opos_ledger_account_list_final;
                                                $total_debit+=  0;
                                                $srl++;
                                            }

                                        }else if($opos_ledger_count > 1){

                                            if($same_ledger_count == 1){
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_debit+=  0;
                                                    $srl++;
                                                }

                                            }else{
                                                $amount = $ledger_head_list->credit_amount / $opos_ledger_count;
                                                foreach ($opos_ledger_account_list as $kkk => $vvv ){
                                                    $vvv->debit_amount = $amount;
                                                    $data_list[$srl]['data'] = $vvv;
                                                    $total_debit+=  0;
                                                    $srl++;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }else{
                            $accounts_list = Accounts::where('site_accounts_voucher_detail_id', $va->id)
                                ->with('ledger')
                                ->with('accVoucherDetails')
                                ->get();
//                            return $accounts_list;
                            if(count($accounts_list)>0){
                                $ledger_head_list = $accounts_list->where('site_accounts_ledger_id', $value->id)->first();
                                if($ledger_head_list){
                                    if($ledger_head_list->entry == 'dr'){

                                        $total_debit+= $ledger_head_list->debit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry)->first();
                                        $data_list[$srl]['data'] = $opos_ledger_account_list;
                                        $total_credit+=  0;
                                        $srl++;

                                    }else if ($ledger_head_list->entry == 'cr'){

                                        $total_credit+= $ledger_head_list->credit_amount;
                                        $opos_ledger_account_list = $accounts_list->where('entry', '!=', $ledger_head_list->entry)->first();
                                        $data_list[$srl]['data'] = $opos_ledger_account_list;
                                        $total_debit+=  0;
                                        $srl++;

                                    }

                                }

                            }
                        }

                    }
                    $final_ledger_data_list[$final_data_srl]['data_list'] = $data_list;
                    if($value->root == 'currentasset' || $value->root == 'fixedasset'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';

                    }else if($value->root == 'currentliability' || $value->root == 'longtermliability'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'income'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'expense'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';
                    }
                    $final_ledger_data_list[$final_data_srl]['ledger_account'] = $value;

                    $final_ledger_data_list[$final_data_srl]['total_credit'] = $total_credit + $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit'] = $total_debit + $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_credit_for_opening_balance'] = $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit_for_opening_balance'] = $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['opening_balance'] = $total_debit_for_opening_balance - $total_credit_for_opening_balance;

                    $total_amount = ($total_debit + $total_debit_for_opening_balance) - ($total_credit + $total_credit_for_opening_balance);
                    $final_ledger_data_list[$final_data_srl]['total_amount'] = $total_amount;


                    $final_ledger_data_list[$final_data_srl]['upto_date_for_opening_balance'] = $upto_date;

                    $final_data_srl++;

                }






                if($depriciation_found_status || $amortization_found_status){
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = $value->name;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = "Fixed Asset, Accumulated Depriciation";
                    $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'dr';
                    $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = "";

                    $total_depriciation_credit_amount+=$depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['particular'] = $value->name;
                    $depriciation_particular[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $depriciation_particular[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['amount_for_opening_balance'] = $depriciation_amount_for_opening_balance;

                    $fixed_depriciation_srl++;

                }
            }
            if($total_depriciation_credit_amount > 0){
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = "Fixed Asset, Accumulated Depriciation";
                $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = $value->name;
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = 50001;
                $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $total_depriciation_credit_amount;
                $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'cr';
                $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = $depriciation_particular;
//                $fixed_depriciation_list[$fixed_depriciation_srl]['code'] = $depriciation_particular;
            }
        }
        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $report_tittle = '<b>Ledger Report</b><br>'.$from_date.' To '.$to_date;
        $report_tittle2  = '';
//        return $fixed_depriciation_list;
        $pdf = PDF::loadView('default.admin.site.accounts.report.ledger-report-pdf',
            compact('view_title','report_tittle','report_tittle2','print_date','from_date','to_date','final_ledger_data_list','fixed_depriciation_list'));
        return $pdf->stream(time() . '-ledger-report.pdf');
    }

    public function getTrialBalanceReportPDF($from_date, $to_date)
    {
//        return [$from_date, $to_date];
        $view_title = 'Trial Balance Report PDF';
        $ledger_list = Ledger::get();

        $final_ledger_data_list = [];
        $final_data_srl = 0;
        $total_debit_amount = 0;
        $total_credit_amount = 0;

        $fixed_depriciation_list = [];
        $depriciation_particular = [];
        $fixed_depriciation_srl = 0;
        $total_depriciation_credit_amount = 0;

        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){

                $data_list = [];

                $total_debit = 0;
                $total_credit = 0;
                $amount = 0;
                $srl = 0;

                $total_debit_for_opening_balance = 0;
                $total_credit_for_opening_balance = 0;

                //=========================for opening balance====================
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                $accounts_list_for_opening_balance = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($upto_date){
                        $q->where('transaction_date', '<=', $upto_date);
                    }) ->get();
                if (count($accounts_list_for_opening_balance)){
                    foreach ($accounts_list_for_opening_balance as $kky => $vvl){

                        if($vvl->entry == 'dr'){
                            $total_debit_for_opening_balance+= $vvl->debit_amount;
                        }
                        if($vvl->entry == 'cr'){
                            $total_credit_for_opening_balance+= $vvl->credit_amount;
                        }

                    }
                }

                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $depriciation_found_status = 0;
                $amortization_found_status = 0;

                $depriciation_amount_for_opening_balance = 0;

                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){

                        //====================fixed asset days for openning balance============
                        $diff_days = 0;
                        $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                        if($upto_date <  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $upto_date;
                            $to = Carbon::parse($end_date);
                            $diff_days = $to->diffInDays($from);
                        }
                        //=========================Depriciation and Amortization===========================
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }

                        $diff_in_days = 0;
                        if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $start_date = $from_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }

                        if($vvv->depriciation_status){
                            $depriciation_found_status = 1;
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                                $depriciation_amount_for_opening_balance = round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            $amortization_found_status = 1;
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;
                                $depriciation_amount_for_opening_balance =  round($depriciation_amount_for_opening_balance);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                //---------------------for opening balance---------------------
                                $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;

                            }
                        }
                    }
                }

                //================================================================

                $accounts_list = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($from_date, $to_date){
                        $q->whereBetween('transaction_date', [$from_date, $to_date]);
                    })
                    ->with('ledger')
                    ->with('accVoucherDetails')
                    ->get();
//                return $accounts_list;

                if(count($accounts_list)>0){
                    foreach ($accounts_list as $kkkk => $vvv){
                        if($vvv->entry == 'dr'){
                            $total_debit+= $vvv->debit_amount;
                        }else{
                            $total_credit+= $vvv->credit_amount;
                        }
                    }
                    $data_list = [];

                    $final_ledger_data_list[$final_data_srl]['data_list'] = $data_list;
                    if($value->root == 'currentasset' || $value->root == 'fixedasset'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';

                    }else if($value->root == 'currentliability' || $value->root == 'longtermliability'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'income'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'expense'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';
                    }
                    $final_ledger_data_list[$final_data_srl]['ledger_account'] = $value;

                    $final_ledger_data_list[$final_data_srl]['total_credit'] = $total_credit + $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit'] = $total_debit + $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_credit_for_opening_balance'] = $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit_for_opening_balance'] = $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['opening_balance'] = $total_debit_for_opening_balance - $total_credit_for_opening_balance;

                    $total_amount = ($total_debit + $total_debit_for_opening_balance) - ($total_credit + $total_credit_for_opening_balance);
                    $final_ledger_data_list[$final_data_srl]['total_amount'] = $total_amount;


                    $final_ledger_data_list[$final_data_srl]['upto_date_for_opening_balance'] = $upto_date;

                    if($total_amount >= 0){
                        $total_debit_amount+=$total_amount;
                    }
                    if($total_amount < 0){
                        $total_credit_amount+=$total_amount * -1;
                    }

                    $final_data_srl++;
                }



                if($depriciation_found_status || $amortization_found_status){
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = $value->name;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = "Fixed Asset, Accumulated Depriciation";
                    $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'dr';
                    $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = "";

                    $total_depriciation_credit_amount+=$depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['particular'] = $value->name;
                    $depriciation_particular[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $depriciation_particular[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['amount_for_opening_balance'] = $depriciation_amount_for_opening_balance;

                    $fixed_depriciation_srl++;

                }
            }
            if($total_depriciation_credit_amount > 0){
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = "Fixed Asset, Accumulated Depriciation";
                $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = $value->name;
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = 50001;
                $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $total_depriciation_credit_amount;
                $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'cr';
                $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = $depriciation_particular;
//                $fixed_depriciation_list[$fixed_depriciation_srl]['code'] = $depriciation_particular;
            }
        }


        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $report_tittle = '<b>Trial Balance Report</b><br>'.$from_date.' To '.$to_date;
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.accounts.report.trial-balance-report-pdf',
            compact('view_title','report_tittle','report_tittle2','print_date','from_date','to_date','final_ledger_data_list','total_debit_amount','total_credit_amount','fixed_depriciation_list'));
        return $pdf->stream(time() . '-trial-balance-report.pdf');
    }
    public function getTrialBalanceReportSingleDateWisePDF($at_date)
    {

        $view_title = 'Trial Balance Report PDF';
        $ledger_list = Ledger::get();

        $final_ledger_data_list = [];
        $final_data_srl = 0;
        $total_debit_amount = 0;
        $total_credit_amount = 0;

        $fixed_depriciation_list = [];
        $depriciation_particular = [];
        $fixed_depriciation_srl = 0;
        $total_depriciation_credit_amount = 0;

        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){

                $data_list = [];

                $total_debit = 0;
                $total_credit = 0;
                $amount = 0;
                $srl = 0;

                $total_debit_for_opening_balance = 0;
                $total_credit_for_opening_balance = 0;

                //=========================for opening balance====================
                $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($at_date)));
                $accounts_list_for_opening_balance = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($upto_date){
                        $q->where('transaction_date', '<=', $upto_date);
                    }) ->get();
                if (count($accounts_list_for_opening_balance)){
                    foreach ($accounts_list_for_opening_balance as $kky => $vvl){

                        if($vvl->entry == 'dr'){
                            $total_debit_for_opening_balance+= $vvl->debit_amount;
                        }
                        if($vvl->entry == 'cr'){
                            $total_credit_for_opening_balance+= $vvl->credit_amount;
                        }

                    }
                }

                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $depriciation_found_status = 0;
                $amortization_found_status = 0;

                $depriciation_amount_for_opening_balance = 0;

                // $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                // if(count($site_account_fixed_asset)){

                //     foreach ($site_account_fixed_asset as $kkk => $vvv){

                //         //====================fixed asset days for openning balance============
                //         $diff_days = 0;
                //         $upto_date =  date('Y-m-d', strtotime('-1 day', strtotime($from_date)));
                //         if($upto_date <  date($vvv->active_date)){
                //             $from = Carbon::parse($vvv->active_date);
                //             $end_date = $upto_date;
                //             $to = Carbon::parse($end_date);
                //             $diff_days = $to->diffInDays($from);
                //         }
                //         //=========================Depriciation and Amortization===========================
                //         if($vvv->life_time_calculation_method == 'yearly'){
                //             $total_days = 365 * $vvv->life_time;
                //         }else if($vvv->life_time_calculation_method == 'monthly'){
                //             $total_days = 30 * $vvv->life_time;
                //         }else if($vvv->life_time_calculation_method == 'quarterly'){
                //             $total_days = 120 * $vvv->life_time;
                //         }else if($vvv->life_time_calculation_method == 'halfyearly'){
                //             $total_days = 180 * $vvv->life_time;
                //         }

                //         $diff_in_days = 0;
                //         if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                //             $start_date = $from_date;
                //             $from = Carbon::parse($start_date);
                //             $end_date = $to_date;
                //             $to = Carbon::parse($end_date);
                //             $diff_in_days = $to->diffInDays($from);
                //         }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                //             $from = Carbon::parse($vvv->active_date);
                //             $end_date = $to_date;
                //             $to = Carbon::parse($end_date);
                //             $diff_in_days = $to->diffInDays($from);
                //         }

                //         if($vvv->depriciation_status){
                //             $depriciation_found_status = 1;
                //             if($vvv->depriciation_type == 'sldm'){
                //                 $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                //                 $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                //             }else if($vvv->depriciation_type == 'fixed'){
                //                 $total_depriciation_amount = $vvv->depriciation_amount;
                //                 $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                //             }else if($vvv->depriciation_type == 'percentage'){
                //                 $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                //                 $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                //             }
                //             if($vvv->count_type == 'round'){
                //                 $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                //                 $depriciation_amount = round($depriciation_amount);
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                //                 $depriciation_amount_for_opening_balance = round($depriciation_amount_for_opening_balance);

                //             }else{
                //                 $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_depriciation_amount;
                //             }

                //         }else if($vvv->amortization_status){
                //             $amortization_found_status = 1;
                //             if($vvv->depriciation_type == 'fixed'){
                //                 $total_amortazation_amount = $vvv->amortization_amount;
                //                 $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                //             }else if($vvv->amortization_type == 'percentage'){
                //                 $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                //                 $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                //             }
                //             if($vvv->count_type == 'round'){
                //                 $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                //                 $depriciation_amount =  round($depriciation_amount);
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;
                //                 $depriciation_amount_for_opening_balance =  round($depriciation_amount_for_opening_balance);

                //             }else{
                //                 $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                //                 //---------------------for opening balance---------------------
                //                 $depriciation_amount_for_opening_balance+= $diff_days * $per_day_amortazation_amount;

                //             }
                //         }
                //     }
                // }

                //================================================================

                $accounts_list = Accounts::where('site_accounts_ledger_id', $value->id)
                    ->whereHas('accVoucherDetails', function($q) use($at_date){
                        $q->where('transaction_date','<=', $at_date);
                    })
                    ->with('ledger')
                    ->with('accVoucherDetails')
                    ->get();
//                return $accounts_list;

                if(count($accounts_list)>0){
                    foreach ($accounts_list as $kkkk => $vvv){
                        if($vvv->entry == 'dr'){
                            $total_debit+= $vvv->debit_amount;
                        }else{
                            $total_credit+= $vvv->credit_amount;
                        }
                    }
                    $data_list = [];

                    $final_ledger_data_list[$final_data_srl]['data_list'] = $data_list;
                    if($value->root == 'currentasset' || $value->root == 'fixedasset'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';

                    }else if($value->root == 'currentliability' || $value->root == 'longtermliability'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'income'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'cr';
                    }else if($value->root == 'expense'){
                        $final_ledger_data_list[$final_data_srl]['entry'] = 'dr';
                    }
                    $final_ledger_data_list[$final_data_srl]['ledger_account'] = $value;

                    $final_ledger_data_list[$final_data_srl]['total_credit'] = $total_credit + $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit'] = $total_debit + $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_credit_for_opening_balance'] = $total_credit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['total_debit_for_opening_balance'] = $total_debit_for_opening_balance;
                    $final_ledger_data_list[$final_data_srl]['opening_balance'] = $total_debit_for_opening_balance - $total_credit_for_opening_balance;

                    $total_amount = ($total_debit + $total_debit_for_opening_balance) - ($total_credit + $total_credit_for_opening_balance);
                    $final_ledger_data_list[$final_data_srl]['total_amount'] = $total_amount;


                    $final_ledger_data_list[$final_data_srl]['upto_date_for_opening_balance'] = $upto_date;

                    if($total_amount >= 0){
                        $total_debit_amount+=$total_amount;
                    }
                    if($total_amount < 0){
                        $total_credit_amount+=$total_amount * -1;
                    }

                    $final_data_srl++;
                }



                if($depriciation_found_status || $amortization_found_status){
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = $value->name;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = "Fixed Asset, Accumulated Depriciation";
                    $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'dr';
                    $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = "";

                    $total_depriciation_credit_amount+=$depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['particular'] = $value->name;
                    $depriciation_particular[$fixed_depriciation_srl]['ledger_code'] = $value->ledger_code;
                    $depriciation_particular[$fixed_depriciation_srl]['amount'] = $depriciation_amount;
                    $depriciation_particular[$fixed_depriciation_srl]['amount_for_opening_balance'] = $depriciation_amount_for_opening_balance;

                    $fixed_depriciation_srl++;

                }
            }
            if($total_depriciation_credit_amount > 0){
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_account'] = "Fixed Asset, Accumulated Depriciation";
                $fixed_depriciation_list[$fixed_depriciation_srl]['particular'] = $value->name;
                $fixed_depriciation_list[$fixed_depriciation_srl]['ledger_code'] = 50001;
                $fixed_depriciation_list[$fixed_depriciation_srl]['amount'] = $total_depriciation_credit_amount;
                $fixed_depriciation_list[$fixed_depriciation_srl]['entry'] = 'cr';
                $fixed_depriciation_list[$fixed_depriciation_srl]['data'] = $depriciation_particular;
//                $fixed_depriciation_list[$fixed_depriciation_srl]['code'] = $depriciation_particular;
            }
        }


        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $report_tittle = '<b>Trial Balance Report</b><br>'.'Till '. Carbon::parse($at_date)->format('d M Y');
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.accounts.report.trial-balance-report-sigle-date-wise-pdf',
            compact('view_title','report_tittle','report_tittle2','print_date','at_date','final_ledger_data_list','total_debit_amount','total_credit_amount','fixed_depriciation_list'));
        return $pdf->stream(time() . '-trial-balance-report.pdf');
    }

    public function getProfitAndLossDetailsList(Request $request)
    {
//        return $request;
        //==================income==================
        $from_date = $request->from_date;
        $to_date = $request->to_date;
        $final_income_data = [];
        $total_income = 0;
        $income_ledger_list = Ledger::where('root', 'income')->get();
        if(count($income_ledger_list)){
            foreach ($income_ledger_list as $key => $value){
                $debit_amount = 0;
                $credit_amount = 0;
                $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($from_date, $to_date){
                    $q->whereBetween('transaction_date', [$from_date, $to_date]);
                })->get();
//                $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->get();
                if(count($accounts)){
                    foreach ($accounts as $k => $v){
                        if($v->entry == 'dr'){
                            $debit_amount+= $v->debit_amount;
                        }
                        if($v->entry == 'cr'){
                            $credit_amount+= $v->credit_amount;
                        }
                    }
                }
                $total_income+= $debit_amount - $credit_amount;
                $final_income_data[$key]['data'] =  $value;
                $final_income_data[$key]['total_amount'] =  $debit_amount - $credit_amount;

            }
        }
        //====================expense=====================
        $final_expense_data = [];
        $total_expense = 0;
        $income_ledger_list = Ledger::where('root', 'expense')->get();
        if(count($income_ledger_list)){
            foreach ($income_ledger_list as $key => $value){
                $debit_amount = 0;
                $credit_amount = 0;
                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }
                        $diff_in_days = 0;
                        if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $start_date = $from_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }else if($from_date <  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }
                        if($vvv->depriciation_status){
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                            }
                        }
                    }
                    $total_expense+= $depriciation_amount;
                    $final_expense_data[$key]['data'] =  $value;
                    $final_expense_data[$key]['total_amount'] =  $depriciation_amount;

                }else{
                    $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($from_date, $to_date){
                        $q->whereBetween('transaction_date', [$from_date, $to_date]);
                    })->get();

//                    $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->get();
                    if(count($accounts)){
                        foreach ($accounts as $k => $v){
                            if($v->entry == 'dr'){
                                $debit_amount+= $v->debit_amount;
                            }
                            if($v->entry == 'cr'){
                                $credit_amount+= $v->credit_amount;
                            }
                        }
                    }
                    $total_expense+= $debit_amount - $credit_amount;
                    $final_expense_data[$key]['data'] =  $value;
                    $final_expense_data[$key]['total_amount'] =  $debit_amount - $credit_amount;
                }

            }
        }
        if($total_income < 0){
            $total_income = $total_income * -1;
        }
        $total_profit_loss = $total_income - $total_expense;
        return [$final_income_data, $final_expense_data, $total_income, $total_expense, $total_profit_loss];
    }

    public function getProfitLossReportPDF($from_date, $to_date)
    {

        $view_title = 'Profit And Loss Report';
        //==================income==================
        $final_income_data = [];
        $total_income = 0;
        $income_ledger_list = Ledger::where('root', 'income')->get();
        if(count($income_ledger_list)){
            foreach ($income_ledger_list as $key => $value){
                $debit_amount = 0;
                $credit_amount = 0;
                $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($from_date, $to_date){
                    $q->whereBetween('transaction_date', [$from_date, $to_date]);
                })->get();

//                $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->get();

                if(count($accounts)){
                    foreach ($accounts as $k => $v){
                        if($v->entry == 'dr'){
                            $debit_amount+= $v->debit_amount;
                        }
                        if($v->entry == 'cr'){
                            $credit_amount+= $v->credit_amount;
                        }
                    }
                }
                
                $total_income+= $debit_amount - $credit_amount;
                $final_income_data[$key]['data'] =  $value;
                $final_income_data[$key]['total_amount'] =  $debit_amount - $credit_amount;


            }
        }
        //====================expense=====================
        $final_expense_data = [];
        $total_expense = 0;
        $income_ledger_list = Ledger::where('root', 'expense')->get();
        if(count($income_ledger_list)){
            foreach ($income_ledger_list as $key => $value){
                $debit_amount = 0;
                $credit_amount = 0;
                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }
                        $diff_in_days = 0;
                        if($from_date >=  date($vvv->active_date) && $to_date >=  date($vvv->active_date)){
                            $start_date = $from_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }else if($from_date <  date($vvv->active_date)){
                            $from = Carbon::parse($vvv->active_date);
                            $end_date = $to_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }
                        if($vvv->depriciation_status){
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                            }
                        }
                    }
                    $total_expense+= $depriciation_amount;
                    $final_expense_data[$key]['data'] =  $value;
                    $final_expense_data[$key]['total_amount'] =  $depriciation_amount;

                }else{
                    $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($from_date, $to_date){
                        $q->whereBetween('transaction_date', [$from_date, $to_date]);
                    })->get();

//                    $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->get();
                    if(count($accounts)){
                        foreach ($accounts as $k => $v){
                            if($v->entry == 'dr'){
                                $debit_amount+= $v->debit_amount;
                            }
                            if($v->entry == 'cr'){
                                $credit_amount+= $v->credit_amount;
                            }
                        }
                    }
                    $total_expense+= $debit_amount - $credit_amount;
                    $final_expense_data[$key]['data'] =  $value;
                    $final_expense_data[$key]['total_amount'] =  $debit_amount - $credit_amount;
                }

            }
        }
        if($total_income < 0){
            $total_income = $total_income * -1;
        }
        $total_profit_loss = $total_income - $total_expense;

        $report_tittle = '<b>Profit And Loss Report</b><br>'.$from_date.' To '.$to_date;
        $report_tittle2  = '';

        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $pdf = PDF::loadView('default.admin.site.accounts.report.profit-loss-report-pdf',
            compact('view_title','print_date','report_tittle','report_tittle2','from_date','to_date','final_income_data','final_expense_data','total_income','total_expense','total_profit_loss'));
        return $pdf->stream(time() . '-profit-loss-report.pdf');
    }

    public function getBalanceSheetDetailsList(Request $request)
    {
//        return $request;
        $at_date =  $request->at_date;
        $current_asset_data_list = [];
        $ca_sr = 0;
        $current_asset_total_amount = 0;
        $fixed_asset_data_list = [];
        $fa_sr = 0;
        $fixed_asset_total_amount = 0;
        $current_liability_data_list = [];
        $cl_sr = 0;
        $current_liability_total_amount = 0;
        $long_term_liability_data_list = [];
        $ltl_sr = 0;
        $long_term_liability_total_amount = 0;
        $depriciation_amount = 0;

        $ledger_list = Ledger::get();
        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){
                $total_debit = 0;
                $total_credit = 0;
                //=========================fixed asset depriciation amount==========================
                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){
                    foreach ($site_account_fixed_asset as $kkk => $vvv){
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }
                        $diff_in_days = 0;
                        if($at_date >=  date($vvv->active_date)){
                            $start_date = $vvv->active_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $at_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }
                        if($vvv->depriciation_status){
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                            }
                        }
                    }

                }
                //====================================================================================
                $accounts_list = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($at_date){
                    $q->where('transaction_date', '<=', $at_date);
                })->get();
                if (count($accounts_list)){
                    if($value->root == 'currentasset') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_debit - $total_credit;
                        $current_asset_data_list[$ca_sr]['ledger'] = $value;
                        $current_asset_data_list[$ca_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $current_asset_total_amount+= $total_ledger_amount;
                        $ca_sr++;
                    }
                    if($value->root == 'fixedasset') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_debit - $total_credit;
                        $fixed_asset_data_list[$fa_sr]['ledger'] = $value;
                        $fixed_asset_data_list[$fa_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $fixed_asset_total_amount+= $total_ledger_amount;
                        $fa_sr++;
                    }
                    if($value->root == 'currentliability') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_credit - $total_debit;
                        $current_liability_data_list[$cl_sr]['ledger'] = $value;
                        $current_liability_data_list[$cl_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $current_liability_total_amount+= $total_ledger_amount;
                        $cl_sr++;
                    }
                    if($value->root == 'longtermliability') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_credit - $total_debit;
                        $long_term_liability_data_list[$ltl_sr]['ledger'] = $value;
                        $long_term_liability_data_list[$ltl_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $long_term_liability_total_amount+= $total_ledger_amount;
                        $ltl_sr++;
                    }
                }
            }
        }
        $total_profit_loss = $this->getProfitAndLoss($at_date);

        return [$current_asset_data_list,
            $fixed_asset_data_list,
            $current_liability_data_list,
            $long_term_liability_data_list,
            $current_asset_total_amount,
            $fixed_asset_total_amount,
            $current_liability_total_amount,
            $long_term_liability_total_amount,
            $depriciation_amount,
            $total_profit_loss];
    }

    public function getProfitAndLoss($at_date)
    {
//        return $request;
        //==================income==================
        $total_income = 0;
        $income_ledger_list = Ledger::where('root', 'income')->get();
        if(count($income_ledger_list)){
            foreach ($income_ledger_list as $key => $value){
                $debit_amount = 0;
                $credit_amount = 0;
                $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($at_date){
                    $q->where('transaction_date','<=', $at_date);
                })->get();
//                $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->get();
                if(count($accounts)){
                    foreach ($accounts as $k => $v){
                        if($v->entry == 'dr'){
                            $debit_amount+= $v->debit_amount;
                        }
                        if($v->entry == 'cr'){
                            $credit_amount+= $v->credit_amount;
                        }
                    }
                }
                $total_income+= $debit_amount - $credit_amount;
            }
        }
        //====================expense=====================
        $total_expense = 0;
        $income_ledger_list = Ledger::where('root', 'expense')->get();
        if(count($income_ledger_list)){
            foreach ($income_ledger_list as $key => $value){
                $debit_amount = 0;
                $credit_amount = 0;
                //=================fixed asset depriciation amount================
                $depriciation_amount = 0;
                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){

                    foreach ($site_account_fixed_asset as $kkk => $vvv){
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }
                        $diff_in_days = 0;
                        if($at_date >=  date($vvv->active_date)){
                            $start_date = $vvv->active_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $at_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }
                        if($vvv->depriciation_status){
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                            }
                        }
                    }
                    $total_expense+= $depriciation_amount;

                }else{
                    $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($at_date){
                        $q->where('transaction_date', '<=', $at_date);
                    })->get();

//                    $accounts = Accounts::where('site_accounts_ledger_id', $value->id)->get();
                    if(count($accounts)){
                        foreach ($accounts as $k => $v){
                            if($v->entry == 'dr'){
                                $debit_amount+= $v->debit_amount;
                            }
                            if($v->entry == 'cr'){
                                $credit_amount+= $v->credit_amount;
                            }
                        }
                    }
                    $total_expense+= $debit_amount - $credit_amount;
                }

            }
        }
        if($total_income < 0){
            $total_income = $total_income * -1;
        }
        $total_profit_loss = $total_income - $total_expense;
        return $total_profit_loss;
    }

    public function getBalanceSheetReportPDF($at_date)
    {
        $view_title = 'Balance Sheet Report PDF';

        $current_asset_data_list = [];
        $ca_sr = 0;
        $current_asset_total_amount = 0;
        $fixed_asset_data_list = [];
        $fa_sr = 0;
        $fixed_asset_total_amount = 0;
        $current_liability_data_list = [];
        $cl_sr = 0;
        $current_liability_total_amount = 0;
        $long_term_liability_data_list = [];
        $ltl_sr = 0;
        $long_term_liability_total_amount = 0;
        $depriciation_amount = 0;

        $ledger_list = Ledger::get();
        if(count($ledger_list)){
            foreach ($ledger_list as $key => $value){
                $total_debit = 0;
                $total_credit = 0;
                //=========================fixed asset depriciation amount==========================
                $site_account_fixed_asset = SiteAccountsFixedAsset::where('expense_ledger_id', $value->id)->get();
                if(count($site_account_fixed_asset)){
                    foreach ($site_account_fixed_asset as $kkk => $vvv){
                        if($vvv->life_time_calculation_method == 'yearly'){
                            $total_days = 365 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'monthly'){
                            $total_days = 30 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'quarterly'){
                            $total_days = 120 * $vvv->life_time;
                        }else if($vvv->life_time_calculation_method == 'halfyearly'){
                            $total_days = 180 * $vvv->life_time;
                        }
                        $diff_in_days = 0;
                        if($at_date >=  date($vvv->active_date)){
                            $start_date = $vvv->active_date;
                            $from = Carbon::parse($start_date);
                            $end_date = $at_date;
                            $to = Carbon::parse($end_date);
                            $diff_in_days = $to->diffInDays($from);
                        }
                        if($vvv->depriciation_status){
                            if($vvv->depriciation_type == 'sldm'){
                                $total_depriciation_amount = $vvv->purchase_cost - $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'fixed'){
                                $total_depriciation_amount = $vvv->depriciation_amount;
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }else if($vvv->depriciation_type == 'percentage'){
                                $total_depriciation_amount = $vvv->purchase_cost * ($vvv->depriciation_amount / 100);
                                $per_day_depriciation_amount = $total_depriciation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                                $depriciation_amount = round($depriciation_amount);

                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_depriciation_amount;
                            }

                        }else if($vvv->amortization_status){
                            if($vvv->depriciation_type == 'fixed'){
                                $total_amortazation_amount = $vvv->amortization_amount;
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }else if($vvv->amortization_type == 'percentage'){
                                $total_amortazation_amount = $vvv->purchase_cost * ($vvv->amortization_amount / 100);
                                $per_day_amortazation_amount = $total_amortazation_amount / $total_days;
                            }
                            if($vvv->count_type == 'round'){
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                                $depriciation_amount =  round($depriciation_amount);
                            }else{
                                $depriciation_amount+= $diff_in_days * $per_day_amortazation_amount;
                            }
                        }
                    }

                }
                //====================================================================================
                $accounts_list = Accounts::where('site_accounts_ledger_id', $value->id)->whereHas('accVoucherDetails', function($q) use($at_date){
                    $q->where('transaction_date', '<=', $at_date);
                })->get();
                if (count($accounts_list)){
                    if($value->root == 'currentasset') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_debit - $total_credit;
                        $current_asset_data_list[$ca_sr]['ledger'] = $value;
                        $current_asset_data_list[$ca_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $current_asset_total_amount+= $total_ledger_amount;
                        $ca_sr++;
                    }
                    if($value->root == 'fixedasset') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_debit - $total_credit;
                        $fixed_asset_data_list[$fa_sr]['ledger'] = $value;
                        $fixed_asset_data_list[$fa_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $fixed_asset_total_amount+= $total_ledger_amount;
                        $fa_sr++;
                    }
                    if($value->root == 'currentliability') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_credit - $total_debit;
                        $current_liability_data_list[$cl_sr]['ledger'] = $value;
                        $current_liability_data_list[$cl_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $current_liability_total_amount+= $total_ledger_amount;
                        $cl_sr++;
                    }
                    if($value->root == 'longtermliability') {
                        foreach ($accounts_list as $k => $v) {
                            if ($v->entry == 'dr') {
                                $total_debit += $v->debit_amount;
                            }
                            if ($v->entry == 'cr') {
                                $total_credit += $v->credit_amount;
                            }
                        }
                        $total_ledger_amount = $total_credit - $total_debit;
                        $long_term_liability_data_list[$ltl_sr]['ledger'] = $value;
                        $long_term_liability_data_list[$ltl_sr]['ledger_tatol_amount'] = $total_ledger_amount;
                        $long_term_liability_total_amount+= $total_ledger_amount;
                        $ltl_sr++;
                    }
                }
            }
        }
        $total_profit_loss = $this->getProfitAndLoss($at_date);

        $report_tittle = '<b>Balance Sheet</b><br>'. '<b>At '.$at_date.'</b>';
        $report_tittle2  = 'Balance Sheet';
//        $print_date = Carbon::today();
//        $print_date = $print_date->toDateString();
        $pdf = PDF::loadView('default.admin.site.accounts.report.balance-sheet-report-pdf',
            compact('view_title','report_tittle','report_tittle2','at_date','current_asset_data_list','fixed_asset_data_list',
                'current_liability_data_list','long_term_liability_data_list','current_asset_total_amount','fixed_asset_total_amount',
                'current_liability_total_amount','long_term_liability_total_amount','depriciation_amount','total_profit_loss'));
        return $pdf->stream(time() . '-balance-sheet-report.pdf');

    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
