<?php

namespace App\Http\Controllers\Site\Accounts\ChequeRegister;

use App\Models\Site\Accounts\Bank;
use App\Models\Site\Accounts\BankAccountDetails;
use App\Models\Site\Accounts\ChequeRegister;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Error;
use Auth;
use Response;
use Storage;
use Session;

class ChequeRegisterController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = "Accounts Cheque Register";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getChequeRegisterList()
    {
        $cheque_register_list = ChequeRegister::where('status', 1)->get();
        return $cheque_register_list;
    }

    public function getChequeRegisterListWithPagination(Request $request)
    {

        $search_cheque_status = $request->search_cheque_status;
        $search_bank_id = $request->search_bank_id;
        $search_bank_account_id = $request->search_bank_account_id;
        $search_cheque_issue_date = $request->search_cheque_issue_date;
        $search_text = $request->search_text;

        $paginate = $request->paginate;
        $txt = '%' . $search_text . '%';

        $cheque_register_list = ChequeRegister::with(['bankAccountDetails'=>function($q){
                            $q->with('bank');
                        }])
                        ->when($search_bank_account_id, function ($q) use($search_bank_account_id){
                            $q->where('site_accounts_bank_account_detail_id', $search_bank_account_id);
                        })
                        ->when($search_cheque_status, function ($qq) use($search_cheque_status){
                            $qq->where('cheque_status', $search_cheque_status);
                        })
                        ->when($search_cheque_issue_date, function ($qrr) use($search_cheque_issue_date){
                            $qrr->where('cheque_issue_date', $search_cheque_issue_date);
                        })
                        ->when($txt, function ($qrrr) use($txt){
                            $qrrr->where('cheque_number', 'LIKE', $txt)
                            ->orWhere('cheque_serial_no', 'LIKE', $txt);
                        })
                        ->when($search_bank_id, function ($qrq) use($search_bank_id){
                            $qrq->whereHas('bankAccountDetails', function ($qrrq) use($search_bank_id){
                                $qrrq->whereHas('bank', function ($qqrq) use($search_bank_id){
                                    $qqrq->where('id', $search_bank_id);
                                });
                            });
                        })
                        ->where('site_id',session()->get('SITE_ID'))
                        ->orderBy('id','ASC')->paginate($paginate);

        //==========bank list=============
        $cheque_register = ChequeRegister::where('status', 1)->with('bankAccountDetails')->get();
        $bank_ids = [];
        $cheque_status = [];
        if(count($cheque_register)){
            foreach ($cheque_register as $ky => $vl){
//                return $vl;
                $bank_ids[]=$vl->bankAccountDetails['site_accounts_bank_id'];
                if($vl->cheque_status == 'active'){
                    $cheque_status[$vl->cheque_status]['head_key'] = $vl->cheque_status;
                    $cheque_status[$vl->cheque_status]['name'] = 'Active';
                }
                if($vl->cheque_status == 'reconcile'){
                    $cheque_status[$vl->cheque_status]['head_key'] = $vl->cheque_status;
                    $cheque_status[$vl->cheque_status]['name'] = 'Reconcile';
                }
                if($vl->cheque_status == 'unreconcile'){
                    $cheque_status[$vl->cheque_status]['head_key'] = $vl->cheque_status;
                    $cheque_status[$vl->cheque_status]['name'] = 'Unreconcile';
                }
                if($vl->cheque_status == 'blank'){
                    $cheque_status[$vl->cheque_status]['head_key'] = $vl->cheque_status;
                    $cheque_status[$vl->cheque_status]['name'] = 'Blank';
                }
                if($vl->cheque_status == 'cancel'){
                    $cheque_status[$vl->cheque_status]['head_key'] = $vl->cheque_status;
                    $cheque_status[$vl->cheque_status]['name'] = 'Cancel';
                }

            }

        }
        $bank_list_for_search = Bank::whereIn('id', $bank_ids)->get();


        //==========bank account list=============
        $bank_account_detail_ids = ChequeRegister::where('status', 1)->pluck('site_accounts_bank_account_detail_id');
        $bank_account_detail_list_for_search = BankAccountDetails::whereIn('id', $bank_account_detail_ids)->get();


        return [$cheque_register_list, $bank_list_for_search, $bank_account_detail_list_for_search,$cheque_status];
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request, ChequeRegister $chequeRegister)
    {
//        return $request;

        //=============validation==========
        if(!$request->bank_id  || !$request->site_accounts_bank_account_detail_id || !$request->cheque_issue_date || !$request->cheque_number || !$request->cheque_status){
            throw new Error('Please, fill the required fields!');
        }
        if($request->bank_id != 'blank' && !$request->cheque_amount ){
            throw new Error('Please, fill the amount field!');
        }
        //==============create=============
        if (count($chequeRegister->ownFields) > 0) {
            foreach ($chequeRegister->ownFields as $field) {
                if ($request->{$field}) {
                    $chequeRegister->{$field} = $request->{$field};
                }
            }
            $latest_data = ChequeRegister::where('status',1)->orderBy('id','DESC')->first();

            if($latest_data){
                $chequeRegister->cheque_serial_no = (int)$latest_data->cheque_serial_no+1;
            }else{
                $chequeRegister->cheque_serial_no = 101;
            }
            $chequeRegister->created_date = Carbon::today();
//            $chequeRegister->site_accounts_bank_account_detail_id = $request->site_accounts_bank_account_detail_id;
//            $accGroup->status = 1;
            $chequeRegister->created_by = Auth::user()->id;

            if($chequeRegister->save()){
                return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
            }
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //=============validation==========
        if(!$request->bank_id  || !$request->site_accounts_bank_account_detail_id || !$request->cheque_issue_date || !$request->cheque_number || !$request->cheque_status){
            throw new Error('Please, fill the required fields!');
        }
        if($request->bank_id != 'blank' && !$request->cheque_amount ){
            throw new Error('Please, fill the amount field!');
        }
        //==============update=============
        $cheque_register = ChequeRegister::findOrFail($request->id);
        if($cheque_register->cheque_status == 'reconcile'){
            throw new Error('Sorry! this cheque has been reconciled!');
        }
        if (count($cheque_register->ownFields) > 0) {
            foreach ($cheque_register->ownFields as $field) {
                if ($request->{$field}) {
                    $cheque_register->{$field} = $request->{$field};
                }
            }
            $cheque_register->created_date = Carbon::today();
//            $accGroup->status = 1;
            $cheque_register->created_by = Auth::user()->id;

            if($cheque_register->save()){
                return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
            }
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        $cheque_register = ChequeRegister::findOrFail($id);
        if($cheque_register->cheque_status == 'reconcile'){
            throw new Error('Sorry! this cheque has been reconciled!');
        }
        $cheque_register->cheque_status = 'cancel';
        $cheque_register->save();
        if($cheque_register->save()){
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }
//        if ($cheque_register->delete()){
//            return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
//        }
    }
}
