<?php

namespace App\Http\Controllers\Permission;

use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Menu\Menu;
use App\Models\Permission\GroupAccess;
use App\Models\Permission\Permission;
use App\Models\Role\Role;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteAccess;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Session;

class PermissionController extends ProjectController
{
    use Lang, FormControll;

    private $request;
    private $permission;

    /**
     * PermissionController constructor
     * @param Permission $permission
     * @param Request $request
     */
    public function __construct(Permission $permission, Request $request)
    {

        $this->middleware('auth');

        $this->request = $request;
        $this->permission = $permission;
    }


    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        $model = $this->permission->paginate(5);
        //dd($model);
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $viewType = 'Permission List';
//        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.permission.index',compact('locale','defaultLocale','viewType','model'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createForm()
    {
        $viewType = 'Create Permission';

        return view('default.admin.permission.create',compact('viewType'));

    }

    /**
     * @param Permission $permission
     * @param Validator $validatedRequest
     */
    public function createPermission( Requests\Validator $validatedRequest)
    {
        $isCreated = $this->permission->create([
            'name'=>ucwords($validatedRequest->get('name')),
            'label'=>$validatedRequest->get('label'),
            'status'=>$validatedRequest->get('status')
        ]);


        return $isCreated?back():null;
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editPermissionForm($id)
    {
        $viewType = 'Edit Permission';

        $permissionToedit = $this->editFormModel($this->permission->findOrFail($id)) ;

        return view('default.admin.permission.edit',compact('permissionToedit','viewType'));
    }

    /**
     * @param $id
     * @param Requests\Validator $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function editPermission($id,Requests\Validator $validatedRequest)
    {
        $permissionToedit = $this->permission->findOrFail($id);
        $isEdited =  $permissionToedit->update([
            'name'=>ucwords($validatedRequest->get('name')),
            'label'=>$validatedRequest->get('label'),
            'status'=>$validatedRequest->get('status')
        ]);

        return $isEdited?back()->withSuccess('Successfully Updated'):null;
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function viewPermission($id)
    {
        $permissionToView = $this->permission->findOrFail($id);

        return view('default.admin.permission.view',compact('permissionToView'));

    }

    /**
     * @param $id
     * @return $this|\Illuminate\Http\RedirectResponse
     */
    public function deletePermission($id)
    {
        $permissionToDelete = $this->permission->findOrFail($id);

        if($permissionToDelete->delete()):
            return back();
        endif;

        return back()->withErrors('Not successfully deleted');
    }

    /**
     * @return $this
     */
    public function permissionAssignForm()
    {
        $viewType = 'Assign Permission';

        return view('default.admin.permission.assign_permission',compact('viewType'));
    }

    /**
     * @param Validator $validatedRequest
     * @param User $user
     * @return \Illuminate\Http\RedirectResponse
     */
    public function assignPermission(Requests\Validator $validatedRequest, Role $role)
    {
        $assignedRole = $role->findOrFail($validatedRequest->role_id);
        $assignedPermission = $this->permission->findOrFail($validatedRequest->permission_id);

        foreach($assignedRole->permissions()->get() as $permission):
            if($permission->id == $assignedPermission->id):
                return back()->withErrors("The $assignedRole->name already holds the $assignedPermission->name permission");
            endif;
        endforeach;

            $assignedRole->permissions()->attach($validatedRequest->permission_id);

        return back();
    }




    public function assignPermissionForm()
    {
        $viewType = 'Assign Permission';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.role.assign-permission',compact('viewType'));
    }

    public function getGroupAccessTable(Menu $menuModel, Request $request, SiteRole $role,SiteAccess $siteAccess, SiteRoleAccess $groupAccess)
    {


        $dirPath=base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS'));


        $groupId = $request->groupId;
        $roleToAssign = $role->findOrFail($groupId);


        $getGroupAccess = $groupAccess->where('role_id',$groupId)->pluck('menu_id')->toArray();


        // dd($getSiteAccess);

        if (\Session::get(SITE_ID)==1){
            $menus = $menuModel->where('is_common_access',false)->where('parent_id', 0)->where('is_displayable', 1)->get();
        }else{
            $s=SiteInfo::find(\Session::get(SITE_ID));
            $menus = $s->menus->where('is_common_access', false)->where('parent_id', 0)->where('is_displayable', 1);
        }


        if(request()->ajax()){

            return view('default.admin.role.group-access',compact('menus','menuModel','groupId','roleToAssign','getGroupAccess'));
        }

        return view('default.admin.role.group-access',compact('menus','menuModel','groupId','roleToAssign','getGroupAccess'));

    }




}
