<?php

namespace App\Http\Controllers\Module;

use App\Models\Menu\Menu;
use App\Models\Modules\SubModule;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use League\Flysystem\Exception;
use Response;

class SubModuleController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }


    public function getSubModuleListWithPaginate()
    {
        return SubModule::with('module')->latest()->paginate(20);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Sub Module';
        return view('default.admin.sub-module.index', compact('viewType'));
    }

    public function getSubModules()
    {
        return SubModule::all();
    }

    public function getSubModulesByModule($id)
    {
        return SubModule::whereModuleId($id)->get();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $id = null;
        $this->validate($request, [
            'module_id' => 'required',
            'name' => 'required|max:200|unique:sub_modules,name,id,' . $id . ',module_id,' . $request->module_id
        ]);

        SubModule::create([
            'module_id' => $request->module_id,
            'name' => $request->name,
        ]);

    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return JsonResponse
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'module_id' => 'required',
            'name' => 'required|max:200|unique:sub_modules,id,' . $id
        ]);

        $theSubModule = SubModule::findOrFail($id);
        $theSubModule->update([
            'module_id' => $request->module_id,
            'name' => $request->name,
        ]);

        return Response::json(['message' => 'Sub Module Successfully Updated!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return JsonResponse
     */
    public function destroy($id)
    {
        $theSubModule = SubModule::findOrFail($id);
        $theSubModule->delete();
        return Response::json(['message' => 'Sub Module Successfully Deleted!']);
    }

    public function attachedList()
    {
        $viewType = 'Sub Module Attached List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.sub-module.attached-list', compact('viewType'));
    }


    public function getMenuListWithAttachedList($type, $id = null)
    {
        try {

            $menu_parent = null;
            $attachedList = [];

            $sub_modules = $id ? SubModule::findOrFail($id) : null;

            $explodedMenuIds = $sub_modules->menu_ids ? array_map('intval', explode(',', implode(',', array_unique(explode(',', $sub_modules->menu_ids ?? null))))) : [];


            if ($type == 1 || $type == 3) {//attached
                $attachedList = Menu::whereIn('id', $explodedMenuIds)
                    ->orderBy('id', 'DESC')
                    ->get();
            }

            if ($type == 2 || $type == 3) {//to be attached
                $menu_parent = Menu::with('childMenu.childMenu.childMenu')
                    ->whereStatus(1)
                    ->whereparentId(0)
                    ->whereIsCommonAccess(0)
                    ->orderBy('position', 'ASC')
                    ->paginate(10000);
            }

            return response()->json([$menu_parent, $explodedMenuIds, $attachedList], 200);


        } catch (Exception $e) {

            if ($e instanceof ModelNotFoundException) {
                return response()->json([
                    'message' => 'Sub Module not found',
                ], 404);
            }
        }
    }


    public function saveMenuIds(Request $req)
    {


        $menu_ids = $req->selectedMenus;
        $sub_module_id = $req->sub_module_id;
        $palette_id = $req->palette_id;
     $menu_ids_exploded = implode(',', $menu_ids);
    // $menu_ids_exploded = implode($menu_ids, ',');


        $total = count($menu_ids);

        SubModule::where('id', $sub_module_id)->update([
            'menu_ids' => $menu_ids_exploded,
            'palette_id' => $palette_id
        ]);

        return Response::json(['message' => $total . ' Routes Attached Done Successfully!']);

        // return [$sub_module_id, $dd];
    }

    public function getAttachedListBySubModule($sub_module_id)
    {
        try {

            $sub_modules = $sub_module_id ? SubModule::findOrFail($sub_module_id) : null;
            $explodedMenuIds = $sub_modules->menu_ids ? explode(',', implode(',', array_unique(explode(',', $sub_modules->menu_ids ?? null)))) : [];
           // $explodedMenuIds = $sub_modules->menu_ids ? explode(',', implode(array_unique(explode(',', $sub_modules->menu_ids ?? null)),',' )) : [];

            $attachedList = Menu::whereIn('id', $explodedMenuIds)
                ->orderBy('position', 'ASC')
                ->get();
            return $attachedList;

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'message' => 'Sub Module not found',
            ], 410);
        } catch (Exception $exception) {
            return response()->json([
                'message' => 'Something Went Wrong!',
            ], 410);
        }
    }

    //===========================Export Import===============================


    public function exportSubModulesToModule(Request $request)
    {
        $this->validate($request, [
            'exportedIds' => 'required',
            'to_module_id' => 'required',
            'replaced' => 'required'
        ]);

        $exportedIds = $request->exportedIds;
        $export_to_module_id = $request->to_module_id;
        $replaced = $request->replaced;

        $exported = [];
        $replaced_or_skipped = [];
        $replaced_or_skipped_status = '';


        foreach ($exportedIds as $k => $v) {
            $subModule = SubModule::findOrFail($v);

            $subModuleCheck = SubModule::whereModuleId($export_to_module_id)->whereName($subModule->name)->first();

            if (!$subModuleCheck) {
                SubModule::create([
                    'module_id' => $export_to_module_id,
                    'name' => $subModule->name,
                    'menu_ids' => $subModule->menu_ids,
                ]);
                $exported[] = $subModule->name;
            } else {
                if ($replaced) {
                    $replaced_or_skipped_status = 'Replaced';
                    $subModuleCheck->update([
                        'module_id' => $export_to_module_id,
                        'name' => $subModule->name,
                        'menu_ids' => $subModule->menu_ids,
                    ]);
                    $replaced_or_skipped[] = $subModule->name;
                } else {
                    $replaced_or_skipped_status = 'Skipped';
                    $replaced_or_skipped[] = $subModule->name;
                }
            }

        }
        $exp = $exported ? implode(',', $exported) : '0';
        $rep_skip = $replaced_or_skipped ? implode(',', $replaced_or_skipped) : '0';

        return JsonResponse::create(['message' => 'Exported=> ' . $exp . $replaced_or_skipped_status . '=> ' . $rep_skip]);
    }


}
