<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 4/24/2016
 * Time: 11:14 AM
 */
namespace App\Http\Controllers\Guardian;

use App\Forms\DataHelper;
use App\Http\Controllers\Controller;
use App\Forms\FormControll;
use App\Forms\GuardianForm;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Email\Email;
use App\Models\Image\Photo;
use App\Models\Media\Media;
use App\Models\AddFieldTable\AddFieldToTable;
use App\Models\Password\Password;
use App\Models\Role\Role;
use App\Models\Religion\Religion;
use App\User;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Session;
use App\Http\Requests\Validator;
use Intervention\Image\Facades\Image as InterImage;

class GuardiansController extends ProjectController
{
    use Lang, FormControll, DataHelper;

    private $guardian;
    private $fileName;
    private $extension;

    /**
     * @param User $guardian
     */
    public function __construct(User $guardian)
    {
        $this->middleware('auth');
        $this->guardian = $guardian;

    }

    public function index(Role $role)
    {
        $viewType = 'Guardian List';

        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $roleId = $this->role('Guardian');
        $roleOfGuardian = $role->findOrFail($roleId);
        $guardianList = $roleOfGuardian->users()->paginate(20);


        return view('default.admin.guardian.index', compact('guardianList', 'locale', 'defaultLocale', 'viewType'));

    }


    public function getGuardianImageByID($guardianId, Photo $potos, Role $role)
    {

        // dd('');
        $roleId = $this->role('Guardian');
        $roleOfGuardian = $role->findOrFail($roleId);
        $guardianList = $roleOfGuardian->users()->whereUserId($guardianId)->paginate(20);
        // dd($guardianList);
        $guardiansWithPhotos = array();
        foreach ($guardianList as $guardian) {

            if (count($guardian->photos) > 0)

                $guardiansWithPhotos[$guardian->photos->last()->name] = $guardian;

        }

        //dd($guardiansWithPhotos);


        $photo = $potos->name->whereUserId($guardianId);

        // $pictueOfGuardian = $this->guardian->whereStudentClassId($guardianId)->get();
        // $subjectOfClass = $subject->whereStudentClassId($classId)->get();
        //dd($guardiansWithPhotos);
        return $guardiansWithPhotos;
        //return json_encode($guardiansWithPhotos);
    }


    public function createGuardianForm()
    {
        $viewType = 'Create Guardian';

        return view('default.admin.guardian.create', compact('viewType'));
    }

    public function createGuardian(Validator $validatedRequest)
    {

        //dd($validatedRequest);
        $allGuardiants = $this->guardian;
        $isOwnFieldsSaved = $this->ownFieldsToSave($allGuardiants, $validatedRequest);
        $isTranslatedFieldsSaved = $this->translatedAttrToSave($allGuardiants, $validatedRequest);

        if ($isOwnFieldsSaved && $isTranslatedFieldsSaved) {

            $newlyCreatedUser = $isOwnFieldsSaved;
            $basicUserInfoArr = [
                'user_id' => $newlyCreatedUser->id,
                'created_at' => date('Y-m-d')
            ];

            $this->setRole(
                $newlyCreatedUser,
                $validatedRequest
            );

            $this->savePhoto(
                $newlyCreatedUser,
                $validatedRequest
            );

            $this->saveDocuments(
                $newlyCreatedUser,
                $validatedRequest
            );

            $this->saveExtraFields(
                $newlyCreatedUser,
                $validatedRequest
            );

            return back()->withSuccess('Successfully Created');
        }
    }

    private function ownFieldsToSave(User $guardian, Validator $validatedRequest)
    {
        if (isset($guardian->gurdianFields)) {
            foreach ($guardian->gurdianFields as $ownField) {
                if ($validatedRequest->{$ownField})
                    $guardian->{$ownField} = $validatedRequest->{$ownField};
            }
        }

        $this->usernameToSave($guardian, $validatedRequest);
        $this->passwordToSave($guardian, $validatedRequest);

        if ($guardian->save()) {

            return $guardian;
        }

        return false;
    }

    private function passwordToSave(User $guardian, Requests\Validator $validatedRequest)
    {
        //dd($validatedRequest->get('username'));
        if ($validatedRequest->password == null) {
            $guardian->password = bcrypt(mt_rand(10000, 99999));
        }
        $guardian->password = bcrypt($validatedRequest->password);
    }


    private function usernameToSave(User $guardian, Requests\Validator $validatedRequest)
    {
        //dd($validatedRequest->get('employee_id'));
        if ($validatedRequest->username == null) {

            $guardian->username = $validatedRequest->get('employee_id') . "@gmail.com";
        }
        //dd($student->username);
    }

    private function translatedAttrToSave(User $guardian, Validator $validatedRequest)
    {
        foreach ($guardian->translatedAttributes as $field) {
            foreach ($this->locales() as $locale => $value) {
                if ($validatedRequest->get($field . '_' . $locale)) {
                    $guardian->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }

        if ($guardian->save()) {

            return true;
        }
        return false;
    }

    /**
     * @param User $user
     * @return mixed
     */
    private function newlyCreatedUser(User $guardian)
    {
        $newlyCreatedUser = $guardian->all()->last();

        return $newlyCreatedUser;
    }


    /**
     * @param User $user
     * @param Validator $validatedRequest
     */
    private function setRole(User $guardian, Requests\Validator $validatedRequest)
    {
        if ($validatedRequest->role) {
            $roleId = $validatedRequest->role;
            $guardian->roles()->attach($roleId);
        }
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     */
    private function savePhoto(User $guardian, Requests\Validator $validatedRequest)
    {
        if ($validatedRequest->photo):
            $image = $validatedRequest->file('photo');
            $this->imageUpload($image, $guardian);
        endif;
    }

    /**
     * @param User $user
     * @param Validator $validatedRequest
     */
    private function saveDocuments(User $guardian, Requests\Validator $validatedRequest)
    {
        if ($validatedRequest->file):
            $filesExceptImage = $validatedRequest->file('file');
            foreach ($filesExceptImage as $file) {
                if ($file):
                    $this->fileUpload($file, $guardian);
                endif;
            }
        endif;
    }

    /**
     * @param $file
     * @param $newlyCreatedUser
     */
    private function fileUpload($file, User $newlyCreatedUser)
    {
        $this->fileName = time() . str_random(3) . $file->getClientOriginalName();
        $this->extension = $file->getClientOriginalExtension();
        $destinationPath = public_path('uploads');
        $file->move($destinationPath, $this->fileName);
        $media = new Media();
        $media->name = $this->fileNameWithoutExtension($this->fileName);
        $media->extension = $this->extension;
        $media->user_id = $newlyCreatedUser->id;
        $newlyCreatedUser->files()->save($media);
    }

    /**
     * Upload Image
     * @param $file
     * @param $newlyCreatedUser
     */
    private function imageUpload($image, User $newlyCreatedUser)
    {

        $this->fileName = time() . str_random(3) . $image->getClientOriginalName();
        InterImage::make($image->getRealPath())->resize(200, 200)->save('uploads/' . $this->fileName);
        $photo = new Photo();
        $photo->name = $this->fileName;
        $photo->user_id = $newlyCreatedUser->id;
        $newlyCreatedUser->photo()->save($photo);
    }

    /**
     * @param User $user
     * @param Requests\Validator $validatedRequest
     */
    private function saveExtraFields(User $user, Requests\Validator $validatedRequest)
    {
        $newFieldsForGuardians = $user->getNewFieldsName('user');
        if (isset($newFieldsForGuardians) && !empty($newFieldsForGuardians)) {
            foreach ($newFieldsForGuardians as $newGuardianField) {
                $addNewFields = new AddFieldToTable();
                if ($validatedRequest->{$newGuardianField})
                    $addNewFields->key = $newGuardianField;
                $addNewFields->value = $validatedRequest->{$newGuardianField};
                $user->addFieldsToTable()->save($addNewFields);
            }

        }

    }

    /**
     * get FileName without Extension
     * @param $fileName
     * @return string
     */
    private function fileNameWithoutExtension($fileName)
    {
        $ext = strtolower(substr($fileName, strrpos($fileName, '.') + 1));
        $fileNameWithoutExt = basename($fileName, '.' . $ext); // output: "youFileName" only

        return $fileNameWithoutExt;
    }

    /**
     * @param $id
     * @param GuardianForm $guardianForm
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function editGuardianForm($id, GuardianForm $guardianForm)
    {

        $viewType = 'Edit Guardian';
        $editGuardian = $guardianForm;
        $guardianProfile = $this->editFormModel($this->guardian->findOrFail($id));

        //   $photo = $guardianProfile->photo->last()->name;


        return view('default.admin.guardian.edit', compact('guardianProfile', 'viewType', 'editGuardian', 'photo'));
    }

    /**
     * @param $id
     * @param Validator $validatedRequest
     * @return mixed
     */
    public function editGuardian($id, Validator $validatedRequest)
    {

        $guardianProfile = $this->guardian->findOrFail($id);
        $isOwnFieldsSaved = $this->ownFieldsToSave($guardianProfile, $validatedRequest);
        $isTranslatedFieldsSaved = $this->translatedAttrToSave($guardianProfile, $validatedRequest);
        $basicUserInfoArr = [
            'user_id' => $guardianProfile->id,
            'updated_at' => date('Y-m-d')
        ];


        if ($isOwnFieldsSaved) {

            if ($isTranslatedFieldsSaved) {

                $this->savePhoto(
                    $guardianProfile,
                    $validatedRequest
                );

                $this->saveDocuments(
                    $guardianProfile,
                    $validatedRequest
                );
//                return back()->withSuccess('Successfully Updated');

//                return view('default.admin.guardian.index');

                return redirect()->route('guardian-list')->withSuccess('Successfully Updated');
            }
        }
    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function viewGuardian($id)
    {
        $viewType = 'Guardian View';

        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $guardianProfile = $this->guardian->with('gender', 'religion', 'photo')->findOrFail($id);


        return view('default.admin.guardian.view', compact('viewType', 'guardianProfile', 'locale', 'defaultLocale'));
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteGuardian($id)
    {
        $guardianToDelete = $this->guardian->findOrFail($id);

        if ($guardianToDelete->delete()) {
            return back()->withSuccess('Successfully Deleted');
        } else {

            return back()->withErrors('Something went wrong');

        }

    }
}