<?php

namespace App\Http\Controllers\Gender;

use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Gender\Gender;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use League\Flysystem\Exception;
use Session;

class GenderController extends ProjectController
{
    use Lang, FormControll;

    private $gender;

    public function __construct(Gender $gender)
    {

        $this->middleware('auth');

        $this->gender = $gender;
    }


    public function index()
    {


        $model = $this->gender->paginate();
//                dd(\Session::get('locale'));



        $viewType = 'Gender List';

        return view('default.admin.gender.index', compact('viewType', 'model'));
    }

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createGenderForm()
    {
        $viewType = 'Create Gender';

        return view('default.admin.gender.create', compact('viewType'));

    }

    /**
     * @param Requests\Validator $validatedRequest
     * @return \Illuminate\Http\RedirectResponse|null
     */
    public function createGender(Requests\Validator $validatedRequest)
    {
        try {


            foreach ($this->gender->translatedAttributes as $field) {
                foreach (config('app.locales') as $locale => $value) {
                    if ($validatedRequest->get($field . '_' . $locale)) {
                        $this->gender->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                    }
                }
            }
            $this->gender->status = $validatedRequest->get('status');
            if ($this->gender->save()){
                return $this->gender->save() ? redirect()->route('gender-list')->with('success','Successfully Created!') : null;
            }else{
                return $this->gender->save() ? back()->with('error','Unknown Error Occurred!') : null;
            }

        } catch (Exception $e){
        return $e->getCode() == 23000 ?
            redirect()->back()->with('warning', 'Duplicate entry') :
            redirect()->back()->with('error', 'Unknown Error Occurred');

    }
    }

    public function editGenderForm($id)
    {
        $viewType = 'Edit Gender';

        $genderToEdit = $this->editFormModel($this->gender->findOrFail($id));

        return view('default.admin.gender.edit', compact('genderToEdit', 'viewType'));

    }

    public function editGender($id, Requests\Validator $validatedRequest)
    {
        $genderToEdit = $this->gender->findOrFail($id);

        foreach ($genderToEdit->translatedAttributes as $field) {
            foreach (config('app.locales') as $locale => $value) {
                if ($validatedRequest->get($field . '_' . $locale)) {
                    $genderToEdit->translateOrNew($locale)->{$field} = $validatedRequest->get($field . '_' . $locale);
                }
            }
        }
        $genderToEdit->status = $validatedRequest->get('status');

        if ($genderToEdit->save()){
            return $genderToEdit->save() ? redirect()->route('gender-list')->with('success','Successfully Updated!') : null;
        }else{
            return $genderToEdit->save() ? back()->with('error','Unknown Error Occurred!') : null;
        }

       // return $genderToEdit->save() ? back() : null;

    }

    public function viewGender($id)
    {
        $viewType = 'Gender';
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $genderToView = $this->gender->findOrFail($id);
        //dd($genderToView);
        return view('default.admin.gender.view', compact('viewType','genderToView', 'locale', 'defaultLocale'));

    }


    public function getGenderList()
    {

            $sitegenderlist=SiteInfoSetting::select('gender_ids')->first();

            $genderlistsplite = explode(',', $sitegenderlist->gender_ids);
            $genderlist = Gender::whereIn('id', $genderlistsplite)->get();



        return $genderlist;

    }


    public function deleteGender($id)
    {
        $genderToDelete = $this->gender->findOrFail($id);

        if ($genderToDelete->delete()) {
                return redirect()->route('gender-list')->with('success','Successfully Deleted!') ;
        }
        return  redirect()->route('gender-list')->withErrors('Not successfully deleted');

    }


}
