<?php

namespace App\Http\Controllers\Edu\Site\Transaction;

use App\Models\Academic\AcademicGroup;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Edu\Item\ItemDetail;
use App\Models\Edu\Transaction\EduStudentInvoice;
use App\Models\Edu\Transaction\EduStudentInvoiceDeclare;
use App\Models\Edu\Transaction\EduStudentInvoiceDeclareItem;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Student\StudentHistory;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class SiteStudentTransactionDeclareController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }


    public function index()
    {

        $viewType = 'Transaction Declare';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function getSiteAcademicGroupList(Request $request){



        $group_list_ids=GlobalSiteInfoSetting::where('site_id', $request->site_id)
            ->pluck('academic_group_id');

        $group_list=AcademicGroup::whereIn('id', $group_list_ids)
            ->get();


        $transaction_item=ItemDetail::where('category_code', 'charge')
            ->select('id', 'category_code', 'item_name')
            ->get();

        $academic_year=AcademicYear::get();


        return response()->json(
            [
                'group_list'=>$group_list,
                'transaction_item'=>$transaction_item,
                'academic_year'=>$academic_year,
            ]);


    }



    public function getAcademicGroupBaseTransactionDeclareList(Request $request){



        $getDeclareList=EduStudentInvoiceDeclare::with(['academicGroup',
            'eduStudentInvoiceDeclareItem'=>function($query){
                $query->with(['eduItemDetail'=>function($querys){
                    $querys->select('id', 'category_code', 'item_name');
                }]);
            }])
            ->where('site_id', $request->site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->get();


        return response()->json(
            [
                'getTransactionDeclareList'=>$getDeclareList,
            ]);
    }








    public function createEduSiteStudentTransactionDeclare(Request $request){

        DB::beginTransaction();


        try {

            $present_transaction_declare= EduStudentInvoiceDeclare::where('site_id', $request->site_id)
                    ->where('academic_group_id', $request->academic_group_id)
                    ->where('status', true)
                    ->first();

            $transaction_declare=new EduStudentInvoiceDeclare();

            $transaction_declare->site_id= $request->site_id;
            $transaction_declare->academic_group_id= $request->academic_group_id;
            $transaction_declare->payment_from_date= $request->payment_from_date;
            $transaction_declare->payment_to_date= $request->payment_to_date;
            $transaction_declare->payment_amount= $request->payment_amount;
            $transaction_declare->student_panel_close_status= $request->student_panel_close_status;
            $transaction_declare->status= true;

            $transaction_declare->save();

            $transaction_declare_id=$transaction_declare->id;

            $selected_items=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);

            if(count($selected_items)>0){

                foreach ($selected_items as $key => $value){

                    $transaction_declare_item=new EduStudentInvoiceDeclareItem();

                    $transaction_declare_item->edu_site_transaction_declare_id= $transaction_declare_id;
                    $transaction_declare_item->edu_item_detail_id= $value['id'];
                    $transaction_declare_item->amount= $value['payment_amount'];
                    $transaction_declare_item->site_id= $request->site_id;
                    $transaction_declare_item->status= true;

                    $transaction_declare_item->save();

                }

            }


            if($present_transaction_declare){
                $present_transaction_declare->status=false;
                $present_transaction_declare->save();

            }





            $selected_items=collect($request->paymentItemList)
                ->where('select_edu_item_detail_id', true)
                ->pluck('id');


            $get_all_student=GlobalStudentHistory::where('site_id', $request->site_id)
                ->where('academic_group_id', $request->academic_group_id)
                ->where('status', true)
                ->pluck('id');

            $created=[];

            if(count($get_all_student)>0){


                //=========Non Paid Student
                $check_unpaid_student_list=EduStudentInvoice::select('id', 'student_history_id',
                    'edu_item_detail_ids', 'payable_amount')
                    ->whereIn('student_history_id', $get_all_student)
                    ->where('online_payment_status', false)
                    ->where('manual_payment_status', false)
                    ->where('status', true)
                    ->get();

                $check_unpaid_student_ids=$check_unpaid_student_list
                    ->pluck('student_history_id')
                    ->unique();


                if(count($check_unpaid_student_ids)>0){
                    $created=[];
                    foreach ($check_unpaid_student_ids as $key => $value){

                        $unpaid_student=$check_unpaid_student_list->where('student_history_id', $value)->first();



                        $created[] = [
                            'payable_site_id'=>null,
                            'student_history_id'=>$value,
                            'edu_item_detail_ids'=> $unpaid_student->edu_item_detail_ids. ','.
                                (count($selected_items)>0?implode(',', $selected_items->toArray()):null),
                            'academic_group_id'=>$request->academic_group_id,
                            'payable_amount'=>$unpaid_student->payable_amount + $request->payment_amount,
                            'online_payment_status'=>false,
                            'manual_payment_status'=>false,
                            'status'=>true,
                            'site_id'=>$request->site_id,
                        ];

                    }
                }

                EduStudentInvoice::whereIn('student_history_id', $check_unpaid_student_ids)
                    ->update([
                        'status'=>false,
                    ]);



                $student_ids=array_diff($get_all_student->toArray(), $check_unpaid_student_ids->toArray());



                foreach ($student_ids as $key => $value){

                    $created[] = [
                        'payable_site_id'=>null,
                        'student_history_id'=>$value,
                        'edu_item_detail_ids'=> count($selected_items)>0?implode(',', $selected_items->toArray()):null,
                        'academic_group_id'=>$request->academic_group_id,
                        'payable_amount'=>$request->payment_amount,
                        'online_payment_status'=>false,
                        'manual_payment_status'=>false,
                        'status'=>true,
                        'site_id'=>$request->site_id,
                    ];

                }

            }

            if(count($created)>0){
                EduStudentInvoice::insert($created);
            }







            DB::commit();
            return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }




    }



    public function updateEduSiteStudentTransactionDeclare(Request $request){


        $transaction_declare= EduStudentInvoiceDeclare::where('id', $request->edu_transaction_declare_id)->first();

        $transaction_declare->site_id= $request->site_id;
        $transaction_declare->academic_group_id= $request->academic_group_id;
        $transaction_declare->payment_from_date= $request->payment_from_date;
        $transaction_declare->payment_to_date= $request->payment_to_date;
        $transaction_declare->payment_amount= $request->payment_amount;
        $transaction_declare->student_panel_close_status= $request->student_panel_close_status;
        $transaction_declare->status= true;

        $transaction_declare->save();

        $transaction_declare_id=$request->edu_transaction_declare_id;

        $selected_items=collect($request->paymentItemList)->where('select_edu_item_detail_id', true);

        $check_transaction_declare_item_list= EduStudentInvoiceDeclareItem::where('edu_site_transaction_declare_id', $request->edu_transaction_declare_id)
            ->get();

        $check_transaction_declare_item_ids=[];
        if(count($check_transaction_declare_item_list)>0){
            $check_transaction_declare_item_ids=$check_transaction_declare_item_list->pluck('id');
        }



        $present_item_id=[];
        if(count($selected_items)>0){

            foreach ($selected_items as $key => $value){

                $check_transaction_declare_item= $check_transaction_declare_item_list->where('edu_transaction_item_id', $value['id'])
                    ->first();

                $transaction_declare_item=new EduStudentInvoiceDeclareItem();

                if($check_transaction_declare_item){

                    $present_item_id[]=$check_transaction_declare_item->id;

                    $check_transaction_declare_item->edu_site_transaction_declare_id= $transaction_declare_id;
                    $check_transaction_declare_item->edu_item_detail_id= $value['id'];
                    $check_transaction_declare_item->amount= $value['payment_amount'];
                    $check_transaction_declare_item->site_id= $request->site_id;
                    $check_transaction_declare_item->status= true;

                    $check_transaction_declare_item->save();
                }
                else{
                    $transaction_declare_item->edu_site_transaction_declare_id= $transaction_declare_id;
                    $transaction_declare_item->edu_item_detail_id= $value['id'];
                    $transaction_declare_item->amount= $value['payment_amount'];
                    $transaction_declare_item->site_id= $request->site_id;
                    $transaction_declare_item->status= true;

                    $transaction_declare_item->save();
                }



            }

        }


        $transactionCheck=array_diff(
            ($check_transaction_declare_item_ids?$check_transaction_declare_item_ids->toArray():null),
            $present_item_id);

        EduStudentInvoiceDeclareItem::whereIn('id', $transactionCheck)->delete();












        $selected_items=collect($request->paymentItemList)
            ->where('select_edu_item_detail_id', true)
            ->pluck('id');


        $get_all_student=GlobalStudentHistory::where('site_id', $request->site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('status', true)
            ->pluck('id');

        $created=[];

        if(count($get_all_student)>0){


            //=========Non Paid Student
            $check_unpaid_student_list=EduStudentInvoice::select('id', 'student_history_id',
                'edu_item_detail_ids', 'payable_amount')
                ->whereIn('student_history_id', $get_all_student)
                ->where('online_payment_status', false)
                ->where('manual_payment_status', false)
                ->where('status', true)
                ->get();


            if(count($check_unpaid_student_list)>0){

                EduStudentInvoice::select('id', 'student_history_id',
                    'edu_item_detail_ids', 'payable_amount')
                    ->whereIn('student_history_id', $get_all_student)
                    ->where('online_payment_status', false)
                    ->where('manual_payment_status', false)
                    ->where('status', true)
                    ->update([
                        'edu_item_detail_ids'=>count($selected_items)>0?implode(',', $selected_items->toArray()):null,
                        'payable_amount'=>$request->payment_amount,
                    ]);

            }

            $check_unpaid_student_ids=$check_unpaid_student_list->pluck('student_history_id');




            //=======Paid Student

            $check_paid_student_list=EduStudentInvoice::select('id', 'student_history_id',
                'edu_item_detail_ids', 'payable_amount')
                ->whereIn('student_history_id', $get_all_student)
                ->where(function ($query) {
                    $query->where('online_payment_status', true)
                        ->orWhere('manual_payment_status', true);
                })
                ->get();


            $check_paid_student_ids=$check_paid_student_list
                ->pluck('student_history_id')
                ->unique();

            foreach ($check_paid_student_ids as $key => $value){

                $check_paid_student=$check_paid_student_list->where('student_history_id', $value)->first();

                $payment_amount=($request->payment_amount - $check_paid_student->payment_amount);
                $present_payment_item_ids=explode(',', $check_paid_student);

                $present_items=collect($request->paymentItemList)
                    ->where('select_edu_item_detail_id', true)
                    ->whereNotIn('id', $present_payment_item_ids)
                    ->pluck('id');


                $created[] = [
                    'payable_site_id'=>null,
                    'student_history_id'=>$value,
                    'edu_item_detail_ids'=> count($present_items)>0?implode(',', $present_items->toArray()):null,
                    'academic_group_id'=>$request->academic_group_id,
                    'payable_amount'=>$payment_amount,
                    'online_payment_status'=>false,
                    'manual_payment_status'=>false,
                    'status'=>true,
                    'site_id'=>$request->site_id,
                ];

            }

            $already_present_student=collect(array_merge($check_paid_student_ids->toArray(), $check_unpaid_student_ids->toArray()))->collapse();

            $rest_student_ids=array_diff($get_all_student->toArray(), $already_present_student->toArray());



            foreach ($rest_student_ids as $key => $value){

                $created[] = [
                    'payable_site_id'=>null,
                    'student_history_id'=>$value,
                    'edu_item_detail_ids'=> count($selected_items)>0?implode(',', $selected_items->toArray()):null,
                    'academic_group_id'=>$request->academic_group_id,
                    'payable_amount'=>$request->payment_amount,
                    'online_payment_status'=>false,
                    'manual_payment_status'=>false,
                    'status'=>true,
                    'site_id'=>$request->site_id,
                ];

            }

        }

        if(count($created)>0){
            EduStudentInvoice::insert($created);
        }









        return Response::json(['message' => 'Successfully Update', 'mode' => 'success'], 200);
    }




    public function pauseEduSiteStudentTransactionDeclare(Request $request){

        EduStudentInvoiceDeclare::where('id', $request->edu_transaction_declare_id)
            ->update([
                'status'=>false,
            ]);

        return Response::json(['message' => 'Pause Successfully!', 'mode' => 'Update!'], 200);
    }


    public function activateEduSiteStudentTransactionDeclare(Request $request){

        $transaction_declare= EduStudentInvoiceDeclare::where('site_id', $request->site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('status', true)
            ->first();

        if($transaction_declare){
            $transaction_declare->status=false;
            $transaction_declare->save();

        }


        EduStudentInvoiceDeclare::where('id', $request->edu_transaction_declare_id)
            ->update([
                'status'=>true,
            ]);

        return Response::json(['message' => 'Pause Successfully!', 'mode' => 'Update!'], 200);
    }






}
