<?php

namespace App\Http\Controllers\Edu\Site;


use App\Http\Controllers\ProjectController;
use App\Mail\SendMailToUserWithQueue;
use App\Mail\Site\SendSiteInfo;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicSession;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Academic\AcademicGroup;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicStudentQuata;
use App\Models\Academic\AcademicTransport;
use App\Models\Company\Company;
use App\Models\Edu\DashboardPalette\DashboardPalette;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Edu\NewSite\Application;
use App\Models\EmployeeGrade\EmpGrade;
use App\Models\Examinations\Examination;
use App\Models\House\House;
use App\Models\Menu\Menu;
use App\Models\Modules\Module;
use App\Models\Permission\UserExtraPermission;
use App\Models\Site\Permission\GlobalSiteRoleAccess;
use App\Models\Site\Permission\SiteRoleAccess;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\SiteGroupSetting;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting as SiteSiteInfoSetting;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Site\SiteInfo\GlobalSiteInfo;

use App\Models\SiteGroup\GlobalSiteGroup;
use App\Models\SiteGroup\GlobalSiteGroupSetting;
use App\Models\User\GlobalUser;
use App\Traits\Site\SiteInfoTrait;
use App\Traits\Site\UserPermission\UserAccessTrait;
use App\User;
use App\Models\Package\EduPackage;
use App\Models\Modules\SubModule;

use Auth;
use DB;
use Error;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;

use Image;
use Mail;
use Response;
use Session;

class SiteController extends ProjectController
{
    use SiteInfoTrait, UserAccessTrait;

    private $site;
    private $siteInfoSetting;
    private $siteRoleAccess;
    private $siteRole;

    public function __construct(SiteInfo $site, GlobalSiteInfoSetting $siteInfoSetting, SiteRole $siteRole, SiteRoleAccess $siteRoleAccess)
    {
        $this->middleware('auth');
     //   $this->middleware('sitepagechecker2');
        $this->site = $site;
        $this->siteInfoSetting = $siteInfoSetting;
        $this->siteRoleAccess = $siteRoleAccess;
        $this->siteRole = $siteRole;
    }


    public function index()
    {

        $viewType = 'Institution List';
        return view('default.admin.layouts.master', compact('viewType'));
    }


    public function applicationList()
    {
        $viewType = 'Institution Application List';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getSiteDetails($id)
    {
        try {
            $the_site = $this->site->findOrFail($id);
            return response()->json($the_site, 200);

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getSites()
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
        try {
            return SiteInfo::all();

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function getAcademicGroupListBySiteGroupId($id)
    {
        try {

            $site_group = GlobalSiteGroup::select('academic_group_ids')
                ->where('id', $id)->first();

            $academic_group_id_array = explode(',', $site_group->academic_group_ids);
            $academic_group_list = AcademicGroup::select('id', 'academic_group_name')
                ->whereIn('id', $academic_group_id_array)->get();

            $transportList = AcademicTransport::select('id', 'transport_name')->get();
            $residenceList = AcademicResidence::select('id', 'residence_name')->get();
            $quataList = AcademicStudentQuata::select('id', 'quata_name')->get();
            $gradeList = EmpGrade::select('id', 'name')->get();
            $examinationList = Examination::select('id', 'examination_name')->get();
            $acc_period_list = AcademicPeriodType::all();
            $house_list = House::where('status', true)->get();


            return response()->json([
                'academic_group_list' => $academic_group_list,
                'emp_transport_list' => $transportList,
                'emp_residence_list' => $residenceList,
                'emp_quata_list' => $quataList,
                'emp_examination_list' => $examinationList,
                'emp_grade_list' => $gradeList,
                'acc_period_list' => $acc_period_list,
                'house_list' => $house_list
            ], 200);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getSiteOrByGroupWithPagination(Request $request)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
        try {
            $site_group_id = $request->site_group_id;
            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';


            $list = $this->site
                ->when($site_group_id, function ($q) use ($site_group_id) {
                    return $q->where('site_group_id', $site_group_id);

                })->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->orWhere('site_alias', 'LIKE', $txt);
                        $query->orWhereTranslationLike('site_name', $txt);
                    });
                })->orderBy('id', 'DESC')
                ->paginate($paginate);

            return response()->json($list, 200);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getSiteInfoForEdit($id)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
        try {
            $the_site = SiteInfo::findOrFail($id);

            $data = [];

            $data['site'] = $the_site ?? [];
            $data['site_group_id'] = $the_site->site_group_id ?? null;

            $data['thana_id'] = $the_site->thana_id ?? 0;
            $data['district_id'] = $the_site->district_id ?? 0;
            $data['division_id'] = $the_site->division_id ?? 0;
            $data['country_id'] = $the_site->country_id ?? 0;

            $data['domain_name'] = $the_site->domain_name ?? null;

            $data['academic_period_type_ids'] = $the_site->academic_period_type_ids ? array_map('intval', explode(',', $the_site->academic_period_type_ids)) : [];
            $data['employee_examination_ids'] = $the_site->employee_examination_ids ? array_map('intval', explode(',', $the_site->employee_examination_ids)) : [];
            $data['emp_grade_ids'] = $the_site->emp_grade_ids ? array_map('intval', explode(',', $the_site->emp_grade_ids)) : [];
            $data['employee_academic_student_quata_ids'] = $the_site->employee_academic_student_quata_ids ? array_map('intval', explode(',', $the_site->employee_academic_student_quata_ids)) : [];
            $data['employee_academic_residence_ids'] = $the_site->employee_academic_residence_ids ? array_map('intval', explode(',', $the_site->employee_academic_residence_ids)) : [];
            $data['employee_academic_transport_ids'] = $the_site->employee_academic_transport_ids ? array_map('intval', explode(',', $the_site->employee_academic_transport_ids)) : [];
            $data['academic_group_ids'] = $the_site->academic_group_ids ? array_map('intval', explode(',', $the_site->academic_group_ids)) : [];
            $data['house_ids'] = $the_site->house_ids ? array_map('intval', explode(',', $the_site->house_ids)) : [];
            //   dd($data);

            return response()->json($data, 200);

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getAcademicGroupBySite($id)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
        try {
            $the_site = $this->site->findOrFail($id);

         //   $academicGroupIds = GlobalSiteGroup::select('academic_group_ids')->where('id', $the_site->site_group_id)->first();
            $academicGroup = explode(',', $the_site->academic_group_ids);
            $academic_groups = AcademicGroup::whereIn('id', $academicGroup)->orderBy('serial')->get();

            return response()->json($academic_groups, 200);

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getSiteGroupSelectedIdsListByAcademicGroupAndSiteGroup($academic_group_id, $site_id)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
        try {
            $the_site = $this->site->findOrFail($site_id);

            $groupSetting = SiteGroupSetting::where([
                ['site_group_id', $the_site->site_group_id],
                ['academic_group_id', $academic_group_id]
            ])->first();


            if (!$groupSetting) {
                return Response::json(['message' => 'No Site Group Setting Found! <a class="btn btn-xs btn-warning" target="_blank" href=" ' . route("site-group-list") . '" >Click<a/>'], 301);
            }
            $data = [];

            $siteInfoSettingList = $this->siteInfoSetting
                ->where([
                    ['site_id', $site_id],
                    ['academic_group_id', $academic_group_id]
                ])->first();

            if ($siteInfoSettingList) {
                foreach ($this->siteInfoSetting->ownfields as $ownField) {
                    $data[$ownField] = array_map('intval', explode(',', $siteInfoSettingList->{$ownField}));
                }
                $data['id'] = $siteInfoSettingList->id;

            } else {
                foreach ($this->siteInfoSetting->ownfields as $ownField) {
                    $data[$ownField] = [];
                }
            }

          //  dd('fsf');
            return response()->json($data);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }


    public function createSite(Request $request)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }

        try {
            if ($request->app_id) {//if new site app approving
                $app = new Application();
                $the_app = $app->findOrFail($request->app_id);
                if ($the_app->status == false) {//if new
                    return Response::json(['message' => 'The application is already approved!'], 410);
                }
            }

            $this->validate($request, [
                "site_group_id" => "required",
                "site_name" => "required",
                "country_id" => "required",
                "division_id" => "required",
                "district_id" => "required",
                "thana_id" => "required",
                "address" => "required",
                "academic_group_ids" => "required",
                "first_name" => "required",
                "site_alias" => 'required|unique:site_infos,site_alias|unique:site_groups,group_alias',
                "site_email" => "required|unique:site_infos",
                "site_phone" => "required",
            ]);
            //image save
            if ($this->is_base64_string($request->site_logo)) {

                $name = time() . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
                $path = '/img/site/' . $name;
                Image::make($request->site_logo)->resize(440, 442)->save(public_path('img/site/') . $name);
                $request->merge(['site_logo' => $name]);
                $this->site->site_logo = $path;


            } else {
                $this->site->site_logo = $request->site_logo;
            }

            $this->site->reason = $request->reason ?? 'No Reason';
            $request->eiin = "0";

            $this->site->updated_by = Auth::user()->id;

            $newlyCreatedSite = $this->ownFieldsToSave($this->site, $request);
            $this->translatedAttrToSave($newlyCreatedSite, $request);


            if ($newlyCreatedSite) {
                //$this->createSubDomain($request->site_alias);

                if ($request->app_id) {//if new site app approving
                    $the_app->status = false;
                    $the_app->save();
                }

                if ($this->createRolesForSite($newlyCreatedSite)) {
                    if ($this->createAdminUser($newlyCreatedSite, $request)) {
                        return Response::json(['message' => 'Site information Save Successfully with all!', 'mode' => 'Saved!'], 200);

                    } else {
                        return Response::json(['message' => 'Site information Save Successfully without creating admin user!', 'mode' => 'Saved!'], 200);
                    }
                } else {
                    return Response::json(['message' => 'Site information Save Successfully Without creating role!', 'mode' => 'Saved!'], 200);
                }
            }
            return Response::json(['message' => 'Site information Save Successfully Without creating role!', 'mode' => 'Saved!'], 200);


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }
    }

    public function updateSite(Request $request)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
       //dd($request->all());
        try {

            $this->validate($request, [
                "site_group_id" => "required",
                "site_name" => "required",
                "country_id" => "required",
                "division_id" => "required",
                "district_id" => "required",
                "thana_id" => "required",
                "address" => "required",
                "academic_group_ids" => "required",

                "site_alias" => 'required|unique:site_infos,site_alias,' . $request->id . ',id|unique:site_groups,group_alias',
                "site_email" => "required|unique:site_infos,site_email," . $request->id . ',id',
                "site_phone" => "required",
            ]);

            //image save

            $the_site = $this->site->findOrFail($request->id);


            if ($this->is_base64_string($request->site_logo)) {

                $del_path = public_path('img/site/' . $the_site->site_logo);
                if (file_exists($del_path) && $the_site->site_logo != "/img/site/demo_logo.jpg") {
                    @unlink($del_path);
                }

                $name = time() . '.' . explode('/', explode(':', substr($request->site_logo, 0, strpos($request->site_logo, ';')))[1])[1];
                $path = '/img/site/' . $name;
                Image::make($request->site_logo)->resize(440, 442)->save(public_path('img/site/') . $name);
                $request->merge(['site_logo' => $name]);
                $the_site->site_logo = $path;

            }

            $the_site->updated_by = Auth::user()->id;
            $saved = $this->ownFieldsToSave($the_site, $request);
            $this->translatedAttrToSave($saved, $request);


            if ($saved) {

                $url = config('app.url');
                $parsedUrl = parse_url($url);
                $sub_domain = $parsedUrl['scheme'] . '://' . $saved->site_alias . '.' . $parsedUrl['host'];
                $data = [
                    'username' => '',
                    'sub_domain' => $sub_domain,
                    'password' => '',
                    'message' => 'Site Successfully Updated!',
                    'user_id' => Auth::user()->username
                ];
                $subject = "Site  Info Updated";
                Mail::to(['eduworlderp@gmail.com'])->send(new SendMailToUserWithQueue($subject, $data));

                return Response::json(['message' => 'Site information Updated Successfully!', 'mode' => 'Update'], 200);

            }


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }
    }


    public function saveAcademicGroupSetting(Request $request)
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
      //  dd($request->all());

        try {

            $site_id = $request->site_id;
            $setting_id = $request->id;

            $the_site = $this->site->findOrFail($site_id);

            $this->validate($request, [
                "academic_group_id" => "required",
                "academic_class_ids" => "required",
                "academic_subject_ids" => "required",
                "academic_subject_condition_ids" => "required",
            ]);

            if ($setting_id) {
                $the_site_setting = $this->siteInfoSetting->findOrFail($setting_id);
            }

            $site_setting = $the_site_setting ?? $this->siteInfoSetting;

            if (isset($site_setting->ownfields)) {
                foreach ($site_setting->ownfields as $ownField) {

                    if (is_array($request->{$ownField})) {
                        $site_setting->{$ownField} = implode(',', $request->{$ownField});
                    } else {
                        $site_setting->{$ownField} = $request->{$ownField};
                    }
                    $site_setting->status = 1;
                    $site_setting->site_id = $site_id;
                }
            }

            $site_setting->save();


            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 500);
        }
    }


    public function getYearShiftClassGroupSectionSessionList($id, $acc_id)
    {
        $SiteInfoTableData = GlobalSiteInfoSetting::where('site_id', $id)->where('academic_group_id', $acc_id)->first();


        //return $SiteInfoTableData;

        $academicYear = explode(',', $SiteInfoTableData->academic_year_ids);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->get();

        $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
        $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();

        $academicShift = explode(',', $SiteInfoTableData->shift_ids);
        $academicShiftList = AcademicShift::whereIn('id', $academicShift)
            ->get();

        $academicclass = explode(',', $SiteInfoTableData->academic_class_ids);
        $academicClassList = AcademicClass::whereIn('id', $academicclass)->get();


        //return $academicShiftList;

        return [$academicYearList, $Sessionlist, $academicShiftList, $academicClassList];

    }

    public function impersonate()
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }
          //echo Auth::id();exit;
        $viewType = 'Site Impersonate Form';
        $user_type = Session::get('USER_TYPE');
        $sites = null;

       // session('key', 'default');

        $site_group_id = Session::get('SITE_ID');



        $user_site_ids = Auth::user()->siteInfoes->pluck('id');

        if ($user_type == 'eduworld') {


            //exit;

            if ($site_group_id) {

                $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('id');

                $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->whereIn('site_group_setting_id', $site_group_ids)
                    ->pluck('site_id')->toArray();

                $all_sites = SiteInfo::
                whereIn('id', $get_site_ids)
                    ->whereIn('id', $user_site_ids)
                    ->get();

            } else {

                $all_sites = SiteInfo::whereIn('id', $user_site_ids)->get();

            }


        } else if ($user_type == 'company') {

            $com = Company::findOrFail(Session::get('COMPANY_ID'));

            //$site_g_ids=explode(',',$com->site_groups_ids);
            $site_ids = explode(',', $com->site_ids) ?? null;


            if (request()->user()->hasCompanyRole('superadmin')) {

                if ($site_group_id) {
                    $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('id');
                    $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->whereIn('site_group_setting_id', $site_group_ids)
                        ->pluck('site_id')->toArray();

                    $all_sites = SiteInfo::whereIn('id', $get_site_ids)
                        ->whereIn('id', $site_ids)
                        ->whereIn('id', $user_site_ids)
                        ->get();

                } else {
                    $all_sites = SiteInfo::whereIn('id', $site_ids)->get();
                }

            } else {

                if ($site_group_id) {

                    $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('id');
                    $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->whereIn('site_group_setting_id', $site_group_ids)
                        ->pluck('site_id')->toArray();

                    $all_sites = SiteInfo::whereIn('id', $get_site_ids)
                        ->whereIn('id', $user_site_ids)
                        ->get();


                } else {
                    $site_group_ids = GlobalSiteGroupSetting::pluck('id');
                    $get_site_ids = GlobalSiteInfoSetting::
                    whereIn('site_group_setting_id', $site_group_ids)
                        ->pluck('site_id')->toArray();

                    $all_sites = SiteInfo::whereIn('id', $get_site_ids)
                        ->whereIn('id', $user_site_ids)
                        ->get();

                }
            }


        } else if ($user_type == 'site_group') {

            $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))->pluck('id');
            /*    $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->whereIn('site_group_setting_id', $site_group_ids)
                    ->pluck('site_id')->toArray();*/
            $all_sites = SiteInfo:://whereIn('id', $get_site_ids)
            whereIn('id', $user_site_ids)
                ->get();

            //  dd($get_site_ids);

        }
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.edu.site.site-impersonate-form', compact('viewType', 'all_sites'));
    }


    public function getSiteToImpersonate()
    {
         // dd(Session::all());
        $user_type = Session::get('USER_TYPE');
        $site_group_id = Session::get('SITE_GROUP_ID');

         if($user_type=='site_group'){

         }else{
            if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
                return redirect()->route('login-form');
            }
         }

        $sites = null;
        $all_sites=[];

        $user_site_ids = Auth::user()->siteInfoes->pluck('id');

        if ($user_type == 'eduworld') {

            if ($site_group_id) {

                // $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('id');

                // $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                //     ->whereIn('site_group_setting_id', $site_group_ids)
                //     ->pluck('site_id')->toArray();
                //    // dd($user_site_ids);
                // $all_sites = SiteInfo::
                // whereIn('id', $get_site_ids)
                //   //  whereIn('id', $user_site_ids)
                //     ->get();

                    ///////////////
                    $siteid=SiteInfo::where('site_group_id',Session::get('SITE_GROUP_ID'))->pluck('id');

                    $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $siteid)
                        ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');
                    $all_sites=GlobalSiteInfo::select('id')
                        ->whereIn('id',$siteIDs)
                        ->get();

                     //   dd($siteList);

                    /////////

            } else {

                $all_sites = SiteInfo::whereIn('id', $user_site_ids)->get();
            }


        } else if ($user_type == 'company') {

            $com = Company::findOrFail(Session::get('COMPANY_ID'));

            //$site_g_ids=explode(',',$com->site_groups_ids);
            $site_ids = explode(',', $com->site_ids) ?? null;

            $all_sites=[];
            if (request()->user()->hasCompanyRole('superadmin')) {

                if ($site_group_id) {
                    $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('id');
                    $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->whereIn('site_group_setting_id', $site_group_ids)
                        ->pluck('site_id')->toArray();

                    $all_sites = SiteInfo::whereIn('id', $get_site_ids)
                        ->whereIn('id', $site_ids)
                        ->whereIn('id', $user_site_ids)
                        ->get();

                } else {

                    $all_sites = SiteInfo::whereIn('id', $site_ids)->get();
                }

            } else {

                if ($site_group_id) {

                    $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', $site_group_id)->pluck('id');
                    $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                        ->whereIn('site_group_setting_id', $site_group_ids)
                        ->pluck('site_id')->toArray();

                    $all_sites = SiteInfo::whereIn('id', $get_site_ids)
                        ->whereIn('id', $user_site_ids)
                        ->get();


                } else {
                    $site_group_ids = GlobalSiteGroupSetting::pluck('id');
                    $get_site_ids = GlobalSiteInfoSetting::
                    whereIn('site_group_setting_id', $site_group_ids)
                        ->pluck('site_id')->toArray();

                    $all_sites = SiteInfo::whereIn('id', $get_site_ids)
                        ->whereIn('id', $user_site_ids)
                        ->get();

                }
            }


        } else if ($user_type == 'site_group') {

            $site_group_ids = GlobalSiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))->pluck('id');
            /*    $get_site_ids = GlobalSiteInfoSetting::where('academic_group_id', Session::get('ACADEMIC_GROUP_ID'))
                    ->whereIn('site_group_setting_id', $site_group_ids)
                    ->pluck('site_id')->toArray();*/

            $siteIDs=GlobalSiteInfoSetting::whereIn('site_id', $user_site_ids)
                    ->where('academic_group_id',Session::get('ACADEMIC_GROUP_ID'))->pluck('site_id');
            $all_sites = SiteInfo::whereIn('id', $siteIDs)->get();


            // $all_sites = SiteInfo:://whereIn('id', $get_site_ids)
            // whereIn('id', $user_site_ids)
            //     ->get();

            //  dd($get_site_ids);

        }

        // $s_setting = $site_info->siteInfoSettings()->first();
        // dd($s_setting);

        return response()->json($all_sites, 200);

    }

    public function getSiteGroupToImpersonate()
    {
        if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
            return redirect()->route('login-form');
        }

        $user_type = Session::get('USER_TYPE');
        $sites = null;
        $site_groups = [];

        if ($user_type == 'eduworld') {
            $site_groups = GlobalSiteGroup::all();


        } else if ($user_type == 'company') {


            $s_g_ids = Auth::user()->siteGroups->pluck('id')->toArray() ?? null;
            $site_groups = GlobalSiteGroup::whereIn('id', $s_g_ids)->get();

        }
        return response()->json($site_groups, 200);

    }


    public function postImpersonate(Request $request)
    {

         $user_type = Session::get('USER_TYPE');
        $site_group_id = Session::get('SITE_GROUP_ID');

         if($user_type=='site_group'){

         }else{
            if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
                return redirect()->route('login-form');
            }
         }

        // if(Auth::user()->user_type=='student' || Auth::user()->user_type=='employee'){
        //     return redirect()->route('login-form');
        // }


        $site_info = SiteInfo::where('id', $request->site_id)->first();
        Session::put('SITE_ID', $site_info->id);
        Session::put('ALIAS1', $site_info->site_alias);
        Session::put('FULL_NAME', $site_info->site_name);


        User::where('id', Auth::id())->update(['site_id' => $site_info->id]);


        if ($user_type == 'eduworld') {

            $s_setting = $site_info->siteInfoSettings()->whereIn('academic_group_id',explode(',',$site_info->academic_group_ids))->first();

            Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
            Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);

            Session::put('ACADEMIC_KEY', $s_setting->academicGroup->academic_key ?? 0);

        } else if ($user_type == 'company') {

            $s_setting = $site_info->siteInfoSettings()->whereIn('academic_group_id',explode(',',$site_info->academic_group_ids))->first();
            Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
            Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);
            Session::put('ACADEMIC_KEY', $s_setting->academicGroup->academic_key ?? 0);

        } else if ($user_type == 'site_group') {

            $s_setting = $site_info->siteInfoSettings()->whereIn('academic_group_id',explode(',',$site_info->academic_group_ids))->first();
            Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
            Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);
            Session::put('ACADEMIC_KEY', $s_setting->academicGroup->academic_key ?? 0);

        }



        if (file_exists(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'))) {
            unlink(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'));

            generateSideBar();
        }

      //  dd(Session::all());

      //  generateSideBar();

        $route = null;// Session::get('redirect_route');
       // dd( generateSideBar());



        return response()->json(['message' => 'Redirecting to the site....', 'mode' => 'Success'], 200);


    }

    public function getImpersonatedSite(){
        $selected_site = Session::get('SITE_ID');
        return response()->json(['selected_site'=>$selected_site], 200);
    }

    public function impersonateSiteGroup()
    {

        $viewType = 'Site Group Impersonate Form';
        $user_type = Session::get('USER_TYPE');
        $sites = null;
        $site_groups = [];

        if ($user_type == 'eduworld') {
            $site_groups = GlobalSiteGroup::all();


        } else if ($user_type == 'company') {


            $s_g_ids = Auth::user()->siteGroups->pluck('id')->toArray() ?? null;
            $site_groups = GlobalSiteGroup::whereIn('id', $s_g_ids)->get();

        }


        return view('default.admin.layouts.master', compact('viewType', 'site_groups'));
        return view('default.admin.edu.site-group.impersonate-form', compact('viewType', 'site_groups'));

    }


    public function postImpersonateSiteGroup(Request $request)
    {

        $user_type = Session::get('USER_TYPE');
        $site_group = GlobalSiteGroup::where('id', $request->site_group_id)->first();
        Session::put('SITE_GROUP_ID', $site_group->id);
        Session::put('ALIAS1', $site_group->group_alias);
        Session::put('FULL_NAME', $site_group->name);
        Session::put('ACADEMIC_KEY', $site_group->academic_key ?? 0);

     //   dd($user_type);

        if ($user_type == 'eduworld') {

            $get_acc_group_ids = $site_group->siteGroupSettings()->orderBy('serial')->pluck('academic_group_id');;

           $academic_group_ids=explode(',',$site_group->academic_group_ids);

             $acc_gr = AcademicGroup::whereIn('id', $get_acc_group_ids)
                ->whereIn('id',$academic_group_ids)
                ->orderBy('serial')
                ->orderBy('id', 'ASC')
                ->first();

           // $sg_setting = $site_group->siteGroupSettings()->whereIn('academic_group_id',explode(',',$site_group->academic_group_ids))->orderBy('serial')->first();

            Session::put('ACADEMIC_GROUP_ID', $acc_gr->id ?? 0);
            Session::put('ACADEMIC_GROUP_NAME', $acc_gr->academic_group_name ?? 0);


        } else if ($user_type == 'company') {

            $sg_setting = $site_group->siteGroupSettings()->whereIn('academic_group_id',explode(',',$site_group->academic_group_ids))->first();

            Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
            Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);
        }


        if (file_exists(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'))) {

            unlink(base_path("resources/views/default/sidebars/" . Session::get('ALIAS') . '/' . request()->user()->id . '.blade.php'));
            generateSideBar();
        }

        $route = null;//Session::get('redirect_route');

        if ($route) {
            return redirect()->route($route);
        }
      //  return redirect()->route('admin');
        return response()->json(['message' => 'Redirecting to the site Group.', 'mode' => 'Success'], 200);



    }


 public function getImpersonateSiteGroup(){
    $selected_site_id = Session::get('SITE_GROUP_ID');
    return response()->json(['selected_site_id'=>$selected_site_id], 200);
}


    public function impersonateAcademicGroup($id)
    {
        $s_setting = AcademicGroup::find($id);
        Session::put('ACADEMIC_GROUP_ID', $s_setting->id ?? 0);
        Session::put('ACADEMIC_GROUP_NAME', $s_setting->academic_group_name ?? 0);

        Session::put('ACADEMIC_KEY', $s_setting->academic_key ?? 0);

        $user = User::find(Auth::user()->id);
        $user->last_academic_group_id = $id;
        $user->save();

        return back();
    }


    private function translatedAttrToSave(SiteInfo $siteInfo, Request $request)
    {
        try {
            foreach ($siteInfo->translatedAttributes as $field) {
                if ($request->{$field}) {
                    $siteInfo->{$field} = $request->{$field};
                }
            }

            if ($siteInfo->save()) {
                return true;
            }
            return false;
        } catch (Exception $exception) {
            return false;
        }
    }

    private function ownFieldsToSave(SiteInfo $siteInfo, Request $request)
    {
        \Log::info($request);
        try {
            if (isset($siteInfo->ownfields)) {
                foreach ($siteInfo->ownfields as $ownField) {
                    if (is_array($request->{$ownField})) {
                        $siteInfo->{$ownField} = implode(',', $request->{$ownField});
                    } else {
                        $siteInfo->{$ownField} = $request->{$ownField};
                    }
                    $siteInfo->status = $request->status;
                    $siteInfo->reason = $request->reason ?? 'No Reason';
                }
            }

            if ($siteInfo->save()) {
                return $siteInfo;
            }

        } catch (Exception $exception) {
            throw new Error($exception);
        }
    }

    /**
     * @param SiteInfo $siteInfo
     * @param Request $validatedRequest
     * @return bool
     */

    public function createRolesForSite($newlyCreatedSite)
    {
        try {


            GlobalSiteRole::insert([
                [
                    'name' => 'admin',
                    'key' => 'admin',
                    'role_description' => 'This is admin..',
                    'status' => 1,
                    'site_id' => $newlyCreatedSite->id,
                ],
                [
                    'name' => 'employee',
                    'key' => 'employee',
                    'role_description' => 'This is employee..',
                    'status' => 1,
                    'site_id' => $newlyCreatedSite->id,
                ],
                [
                    'name' => 'student',
                    'role_description' => 'This is student..',
                    'key' => 'student',
                    'status' => 1,
                    'site_id' => $newlyCreatedSite->id,
                ],
                [
                    'name' => 'guardian',
                    'key' => 'guardian',
                    'role_description' => 'This is guardian..',
                    'status' => 1,
                    'site_id' => $newlyCreatedSite->id,
                ],

            ]);
            return true;
        } catch (Exception $exception) {
            $issue = new    IssueDetail();
            $issue->username = Auth::user()->username;
            $issue->issuer_type = 'edu';
            $issue->issue_type = 's_creation';
            $issue->issue_details = json_encode($exception->getMessage());
            $issue->save();
            return false;
        }
    }


    public function createAdminUser(SiteInfo $newlyCreatedSite, Request $request)
    {
        try {

            $user_name = $this->employeeUserNameCreate($request, $newlyCreatedSite->id);

            $tableUser = DB::table('users');
            $adminPassword = rand(500000, 800000);

            $siteName = $newlyCreatedSite->site_name;
            $siteEmail = $newlyCreatedSite->site_email;
            $siteAlias = $newlyCreatedSite->site_alias;


            $userId = $tableUser->insertGetId(
                [
                    'username' => $user_name,
                    'email' => $siteEmail,
                    'password' => bcrypt($adminPassword),
                    'alias' => $siteAlias,
                    'site_id' => $newlyCreatedSite->id,
                    'user_type' => 'employee',
                    'status' => true,
                ]
            );

            DB::table('user_translations')->insert(
                [
                    'user_id' => $userId,
                    'first_name' => $request->first_name ?? 'Abc',
                    'last_name' => $request->last_name ?? '',
                    'locale' => 'en'
                ]
            );

            DB::table('employee_histories')->insert(
                [
                    'user_id' => $userId,
                    'site_id' => $newlyCreatedSite->id,
                    'status' => true
                ]
            );

            DB::table('photos')->insert(
                [
                    'name' => 'image-not.png',
                    'path' => $request->head_picture ?? 'uploads/image-not.png',
                    'user_id' => $userId,
                    'imageable_id' => $userId,
                    'imageable_type' => 'App\User'
                ]
            );
            $this->setAdminRole($userId, $newlyCreatedSite);

            $sub_domain = $this->getDomain($newlyCreatedSite->site_alias);
            $data = [
                'name' => $request->first_name . ' ' . $request->last_name,
                'username' => $user_name,
                'sub_domain' => $sub_domain,
                'password' => $adminPassword,
                'message' => 'Site Successfully Created!',
                'user_id' => Auth::user()->username
            ];

            $subject = "Site Creation";
            Mail::to([$newlyCreatedSite->site_email, 'eduworlderp@gmail.com'])->send(new SendSiteInfo($subject, $data));

            return true;
        } catch (Exception $exception) {
            $issue = new    IssueDetail();
            $issue->username = Auth::user()->username;
            $issue->issuer_type = 'edu';
            $issue->issue_type = 's_creation';
            $issue->issue_details = json_encode($exception->getMessage());
            $issue->save();

            return false;
        }

    }


    private function setAdminRole($userId, SiteInfo $newlyCreatedSite)
    {
        try {
            $role = GlobalSiteRole::select('id')->where(['key' => 'admin', 'site_id' => $newlyCreatedSite->id])->first();
            if (!is_null($role)) {
                $roleId = $role->id;
                DB::table('site_role_user')->insert(
                    [
                        'user_id' => $userId,
                        'role_id' => $roleId
                    ]
                );
            }

            $the_user = (new User())->find($userId);
            $this->setTheUserPermission($the_user);


            return true;
        } catch (Exception $exception) {
            return false;
        }
    }


    //===========================Site USer role ===============================
    public function getSiteUserList(Request $request)
    {


        $search_txt = $request->search_txt;
        $alias = $request->alias ?? null;

        $txt = '%' . $search_txt . '%';

        $students = (new GlobalUser())
            ->where('status', 1)
            ->when($alias, function ($q) use ($alias) {
                $q->where('alias', $alias);

            })->when($search_txt, function ($q) use ($txt) {
                $q->where(function ($query) use ($txt) {
                    $query->where('username', 'LIKE', $txt)
                        ->orWhere('email', 'LIKE', $txt)
                        ->orWhere('contact_number', 'LIKE', $txt)
                        ->orWhereTranslationLike('first_name', $txt)
                        ->orWhereTranslationLike('last_name', $txt);
                })->orderByTranslation('first_name', 'ASC');

            })
            ->limit(20)
            ->get()->map(function ($val) {
                return [
                    'id' => $val->id,
                    'full_name' => $val->full_name ?? '',
                    'username' => $val->username ?? '',
                    'img' => $val->latestPhoto->path ?? ''
                ];
            });


        return response()->json($students, 200);

    }

    public function getDashboardPalette()
    {
        try {
            $dashboard_palettes = DashboardPalette::where('status', 1)->orderBy('key_id','ASC')->get();

            $siteRole = $this->siteRole->where('key','admin')->first();

            $roleAccess = $this->siteRoleAccess->where('site_role_id', $siteRole->id)->first();
        //    dd($siteRole->id);
            if($roleAccess->dashboard_palettes??null){
                $availablePalette = explode(',', $roleAccess->dashboard_palettes) ;
            }else{
                $availablePalette=[];
            }


            // academic classes
            $site_id = Session::get('SITE_ID');

            $SiteInfoTableData = $this->siteInfoSetting->select('id','academic_class_ids','device_using_class_ids')->where('site_id',$site_id)->first();

            $academicclass = explode(',', $SiteInfoTableData->academic_class_ids);
            $academicClassList = AcademicClass::whereIn('id', $academicclass)->get();

            if($SiteInfoTableData->device_using_class_ids){
                $availableClass = explode(',', $SiteInfoTableData->device_using_class_ids);
            }else{
                $availableClass=[];
            }


          return  response()->json(['dashboard_palettes'=>$dashboard_palettes, 'availablePalette'=>$availablePalette,'academicClassList'=>$academicClassList,'availableClass'=>$availableClass],200);

        } catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => 'Site Info Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getDashboardPaletteUpdate(Request $request){
        try {
        $site_id = Session::get('SITE_ID');

            $requestRoleId =  implode(',', $request->palette_list);

            $siteRole = $this->siteRole->where('key','admin')->first();

            $roleAccess = $this->siteRoleAccess->where('site_role_id', $siteRole->id)->first();
         //   dd($roleAccess);



            if(is_null($roleAccess)){
             //   $site_role_access = new SiteRoleAccess();

                // sub-modiul ids ====
                $theSite = SiteInfo::findOrFail($site_id);
                $package = EduPackage::findOrFail($theSite->siteMembership->edu_package_id);
                $module_ids = $package->modules->pluck('id')->toArray();

                $unique_module_ids = array_unique($module_ids);
                $sub_module_ids = [];

                foreach ($unique_module_ids as $k => $v) {
                    $sub_module_ids = array_merge($sub_module_ids, SubModule::where('module_id', $v)->pluck('id')->toArray());
                }
                $unique_sub_module_ids = array_unique($sub_module_ids);
                $imploded_sub_module_ids = implode(',', $unique_sub_module_ids) ?? null;
                ///=====
                SiteRoleAccess::create([
                    'site_id' => $site_id,
                    'site_role_id' => $siteRole->id,
                    'sub_module_ids' => $imploded_sub_module_ids,
                    'dashboard_palettes' => $requestRoleId,
                ]);
            }else{
                $roleAccess->dashboard_palettes = $requestRoleId;
                $roleAccess->save();
            }

            // device using class update
            $requestClassIds =  implode(',',$request->class_list);

            $SiteInfoTableData = $this->siteInfoSetting->where('site_id',$site_id)->first();
            $SiteInfoTableData->device_using_class_ids = $requestClassIds;
            $SiteInfoTableData->save();


            return Response::json(['message' => 'Dashboard Palettes Update Succesfully', 'mode' => 'success'], 200);

        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }



    public function getAssignedListForUser($user_id)
    {
        try {

            if ($user_id == 'null') {
                return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
            }

            $the_user = GlobalUser::find($user_id);
            // $role_ids = $the_user->siteGlobalRoles()->pluck('site_roles.id');

            $exploded_menu_ids = explode(',', $the_user->permission->menu_ids);
            // dd($exploded_menu_ids);

            $menu_assigned = (new Menu())->where(function ($q) use ($exploded_menu_ids) {
                $q->whereIn('id', $exploded_menu_ids);
            })->orderBy('id', 'ASC')->get();


            $menu_list = (new Menu())
                ->with(['child' => function ($q) use ($exploded_menu_ids) {
                    $q->whereIn('id', $exploded_menu_ids)
                        ->orWhere('is_logged_common_access', true)
                        ->with(['child' => function ($q) use ($exploded_menu_ids) {
                            $q->whereIn('id', $exploded_menu_ids)
                                ->orWhere('is_logged_common_access', true);
                        }]);
                }])
                ->where(function ($q) use ($exploded_menu_ids) {
                    $q->whereIn('id', $exploded_menu_ids)
                        ->orWhere('is_logged_common_access', true);
                })
                ->orderBy('id', 'ASC')
                ->where('is_displayable', true)
                ->get();

            $get_user_access = explode(',', UserExtraPermission::where('user_id', $user_id)->first()->sub_module_ids ?? null) ?? [];
            $updated_at = date('d M Y h:i:s A',strtotime( $the_user->permission->updated_at));

            return response()->json([$menu_list, $menu_assigned, $get_user_access, $updated_at], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


        /* try {

            if ($user_id == 'null') {
                return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
            }
            $module_list = Module::with('subModule')
                ->orderBy('id', 'DESC')
                ->get();;

            $the_user = User::find($user_id);
            $role_ids = $the_user->siteGlobalRoles()->pluck('site_roles.id');


            \Log::info($role_ids);


            foreach ($the_user->siteGlobalRoles as $ke => $role) {


            }


            $get_user_role_access = GlobalSiteRoleAccess::whereIn('site_role_id', $role_ids)->pluck('sub_module_ids');
            $role_access_arr = [];

            foreach ($get_user_role_access as $acces) {
                $exploded = explode(',', $acces) ?? [];
                $role_access_arr = array_unique(array_merge($role_access_arr, $exploded));
            }

            $get_user_access = explode(',', UserExtraPermission::where('user_id', $user_id)->first()->sub_module_ids ?? null) ?? [];


            return response()->json([$module_list, $role_access_arr, $get_user_access], 200);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }*/
    }

}

