<?php

namespace App\Http\Controllers\Edu\Site;

use App\Models\Modules\SubModule;
use App\Models\Package\EduPackage;
use App\Models\Site\Permission\GlobalSiteRoleAccess;
use App\Models\Site\Role\GlobalSiteRole;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SiteAccessController extends Controller
{


    private $eduPackage;

    public function __construct(EduPackage $eduPackage)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->eduPackage = $eduPackage;
    }


    public function assignPackageToSite($site_id)
    {


        $theSite = SiteInfo::findOrFail($site_id);
        $package = $this->eduPackage->findOrFail($theSite->siteMembership->edu_package_id);
        $module_ids = $package->modules->pluck('id')->toArray();

        $unique_module_ids = array_unique($module_ids);
        $sub_module_ids = [];

        foreach ($unique_module_ids as $k => $v) {
            $sub_module_ids = array_merge($sub_module_ids, SubModule::where('module_id', $v)->pluck('id')->toArray());
        }
        $unique_sub_module_ids = array_unique($sub_module_ids);

        $total = count($unique_sub_module_ids);
        $theSite->subModules()->sync($unique_sub_module_ids);

        return $total;
    }
}
