<?php

namespace App\Http\Controllers\Edu\Permission;

use App\Models\Edu\EduRole;
use App\Models\Edu\EduRoleAccess;
use App\Models\Modules\Module;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class PermissionController extends Controller
{


    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

    }


    public function assignPermissionForm()
    {
        $viewType = 'Assign Permission For Edu User';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.edu.permission.assign-permission', compact('viewType'));
    }

    public function getAssignedListForSite($role_id)
    {
        try {

            $module_list = Module::with(['subModule' => function ($q) {
            }])->orderBy('id', 'DESC')
                ->get();
            $get_role_access = explode(',', EduRoleAccess::whereEduRoleId($role_id)->first()->sub_module_ids ?? null) ?? null;


            return [$module_list, $get_role_access];
        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function assignSubModuleToUser(Request $req)
    {
        try {



            $this->validate($req, [
                'role_id' => 'required',
            ]);

            $sub_module_ids = $req->sub_module_ids;
            $role_id = $req->role_id;

//            if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS') . '/' . $role_id . '.blade.php'))) {
//                unlink(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS') . '/' . $role_id . '.blade.php'));
//            }

            $get_all_users_with_role = EduRole::findOrFail($role_id)->users()->get();

            foreach ($get_all_users_with_role as $k => $value) {
                $user_id = $value->id;
                if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS') . '/' . $user_id . '.blade.php'))) {
                    unlink(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS') . '/' . $user_id . '.blade.php'));
                }
            }




            $sub_module_ids_exploded = implode($sub_module_ids, ',');
            $total = count($sub_module_ids);

            $userAlreadyAssigned = EduRoleAccess::whereEduRoleId($role_id)->first();

            if ($userAlreadyAssigned) {

                $userAlreadyAssigned->update([
                    'sub_module_ids' => $sub_module_ids_exploded
                ]);
            } else {
                EduRoleAccess::create([
                    'sub_module_ids' => $sub_module_ids_exploded,
                    'edu_role_id' => $role_id,
                    'status' => true,
                ]);
            }


            return Response::json(['message' => $total . ' Sub Module Attached Done Successfully!']);


        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

}
