<?php

namespace App\Http\Controllers\Edu\Holiday;

use App\Models\AcademicYear\AcademicYear;
use App\Models\Country\Country;
use App\Models\Edu\Holiday\HolidayForSite;
use App\Models\Holydays\Holyday;
use App\Models\Holydays\HolyDayType;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Response;

class HolidaysController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    private $holidayForSite;


    public function __construct(HolidayForSite $holidayForSite)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->holidayForSite = $holidayForSite;

    }

    public function index()
    {
        $viewType = 'Holidays';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.edu.holiday.holidays-view',compact('viewType'));
    }

    public function getFormData()
    {
//        return 'ok';
        $country_data = Country::all();
//        $academic_year = AcademicYear::all();
        $dateComponents = getdate();
        $year = $dateComponents['year'];
        $yr = $year;
        $year_arr = [];
        for($i=1; $i<=10; $i++){
            $year_arr[] = $yr;
            $yr-=1;
        }
        $holidays_data = HolyDayType::all();

        $holiday = Holyday::all();

        return [$country_data, $year_arr, $holidays_data, $holiday];

    }

    public function getHolidayList($holiday_type_id)
    {

        $holidays_data = Holyday::where('holy_day_type_id', $holiday_type_id)->get();

        return $holidays_data;

    }


    public function getGovernmentHolidayList(Request $request)
    {
//        return $request;
        $country_id = $request->search_country_id;
        $date = $request->date;
        $search_year = $request->search_year;
        $search_holiday_id = $request->search_holiday_id;
        $search_holiday_type_id = $request->search_holiday_type_id;
        $paginate = $request->paginate ?? 20;



        $holiday_data_list = HolidayForSite::with(['holyday' => function ($query) {
            $query->with('holyDayType');
        }])->with('country')
            ->when($country_id, function ($query) use($country_id){
                return $query->where('country_id', $country_id);
            })
            ->when($date, function ($query) use($date){
                return $query->where('activate_date', $date);
            })
            ->when($search_year, function ($query) use($search_year){
                return $query->where('year', $search_year);
            })
            ->when($search_holiday_id, function ($query) use($search_holiday_id){
                return $query->where('holyday_id', $search_holiday_id);
            })
            ->when($search_holiday_type_id, function ($query) use($search_holiday_type_id){
                return $query->with(['holyday' => function ($query) use($search_holiday_type_id) {
                    $query->with(['holyDayType'  => function ($q) use($search_holiday_type_id){
                       return $q->where('id', $search_holiday_type_id);
                    }]);
                }]);
            })
            ->get();

//        return $holiday_data_list;


        if(count($holiday_data_list)>0){



            $holiday = $holiday_data_list->pluck('identification_number');
            $holiday_unique = $holiday->unique();
            $sl = 0;

            foreach ($holiday_unique as $key => $value){

                $holidayList[$sl] = HolidayForSite::with(['holyday' => function ($query) {
                    $query->with('holyDayType');
                }])
                    ->with('country')
                    ->first();
                $sl+=1;
            }

            $holidayListPage = new Paginator($holidayList, $paginate);

            return $holidayListPage;

        }else{

            throw new Error('Holiday not found');

        }
//        return $holiday_data_list->holyday->holyDayType->name;


    }

    public function createHoliday(Request $request)
    {
//        return $request;
            $request->validate([
                'countryId' => 'required',
                'year' => 'required',
                'holidayTypeId' => 'required',
                'start_date' => 'required',
                'end_date' => 'required',
                'holidayId' => 'required',

            ]);

            $start_date = $request->get('start_date');//start date
            $end_date = $request->get('end_date');//end date
            $dates = array();
            while (strtotime($start_date) <= strtotime($end_date)) {
                $dates[] = $start_date;
                $start_date = date ("Y-m-d", strtotime("+1 day", strtotime($start_date)));
            }

            $holidayList = HolidayForSite::orderBy('id', 'DESC')->first();

            if($holidayList){
                $id_number = $holidayList->identification_number + 1;
            }else{
                $id_number = 101;
            }

            if($request->dataExist){

//            return 'false';
                foreach ($dates as $key => $value){

                    $this->holidayForSite->create([
                        'activate_date'=>$value,
                        'start_date'=>$request->start_date,
                        'end_date'=>$request->end_date,
                        'country_id'=>$request->get('countryId'),
                        'holyday_id'=>$request->get('holidayId'),
                        'identification_number'=>$id_number,
                        'year'=>$request->get('year'),
                        'description'=>$request->get('description'),
                        'status'=>$request->get('status'),

                    ]);

                }

            }else if(!$request->dataExist){

//            return 'true';
                foreach ($dates as $key => $value){

                    $data = HolidayForSite::where('activate_date', $value)->first();

                    if($data){
                        $data_found = 'data_found';
                        return $data_found;
                    }

                }
                foreach ($dates as $key => $value){


                    $this->holidayForSite->create([
                        'activate_date'=>$value,
                        'start_date'=>$request->start_date,
                        'end_date'=>$request->end_date,
                        'country_id'=>$request->get('countryId'),
                        'holyday_id'=>$request->get('holidayId'),
                        'identification_number'=>$id_number,
                        'year'=>$request->get('year'),
                        'description'=>$request->get('description'),
                        'status'=>$request->get('status'),

                    ]);


                }
            }

            return Response::json(['message' => 'Holiday Successfully Created!']);






    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
