<?php

namespace App\Http\Controllers\Edu\Fetch;

use App\Forms\DataHelper;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Site\Log\AuditLog;
use App\Models\Site\Student\Attendance\GlobalStudentAbsent;
use App\Traits\DB\DatabaseBackupTrait;
use File;
use Illuminate\Http\Request;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Edu\Device\DeviceLog;
use App\Models\Edu\SMS\SmsFollowUp;
use App\Models\Site\Employee\GlobalEmployeeAttendance;
use App\Traits\CheckConnection;
use App\Traits\RequestHandlingWithMachine;
use App\Traits\Device\OrganizeSavedDeviceLogTrait;
use App\Http\Controllers\Controller;
use Carbon\Carbon;
use DateTime;
use Error;
use Response;
use SplFileInfo;
use Storage;

class FetchLogController extends Controller
{
    use RequestHandlingWithMachine, CheckConnection, DataHelper, DatabaseBackupTrait, OrganizeSavedDeviceLogTrait;

    private $deviceLog;
    private $smsFollowUp;

    public function __construct(DeviceLog $deviceLog, SmsFollowUp $smsFollowUp)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->deviceLog = $deviceLog;
        $this->smsFollowUp = $smsFollowUp;

    }

    public function studentAttendanceLog()
    {


        $viewType = 'Log Details';

        $auditLogs = [];

        if (isset($_GET['log'])) {


            $auditLogs = AuditLog::orderBy('id', 'DESC')->paginate(50);
            return view('default.admin.edu.site.audit-log', compact('viewType', 'auditLogs'));

        }
        if (isset($_GET['task'])) {

            //dd($_GET['task']);

            if ($_GET['task'] == 's') {
                \Artisan::call('schedule:run');
            }
            if ($_GET['task'] == 'f') {
                \Artisan::call('fetch:log-datetime');
            }

            if ($_GET['task'] == 'o') {
                \Artisan::call('organize:log');
            }
            if ($_GET['task'] == 'q') {
                \Artisan::call('queue:work');
            }
            if ($_GET['task'] == 'm') {
                \Artisan::call('migrate');
            }

            if ($_GET['task'] == 'db') {
                \Artisan::call('db:backup');
            }
        }

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.edu.fetch-log.attendance-log', compact('viewType'));
    }


    public function showSmsLogData($date = null)//routed moved
    {
        $viewType = 'Show Device Log';
        $time_now = Carbon::now();
        $get_date = $_GET['date'] ?? $date ?? $time_now->toDateString();
        $data = SmsFollowUp::whereDate('created_at', $get_date)->orderBy('id', 'DESC')->paginate(50);
        return view('default.admin.edu.fetch-log.device-log', compact('viewType', 'data', 'get_date'));
    }

    public function getEduSmsFollowUpData(Request $request)
    {

        $s_date = $request->s_date;
        $e_date = $request->e_date;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $site_id = $request->site_id;
        $txt =  $search_txt . '%';

        $data = $this->smsFollowUp
            ->with('site')
            ->when($search_txt, function ($q) use ($txt) {
                $q->where('msg_numbers', 'LIKE', $txt);
                $q->orWhere('res_msg_id', 'LIKE', $txt);
            })->when($site_id, function ($q) use ($site_id) {
                $q->where('institution_id', $site_id);
            })->whereDate('created_at', '>=', $s_date)
            ->whereDate('created_at', '<=', $e_date)
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        $edu_cost = number_format($data->sum('company_charged_from_edu'), 2);
        $site_cost = number_format($data->sum('edu_charged_from_client'), 2);
        $edu_return = number_format($data->sum('returned_charges'), 2);

        // dd($rr);

        if (count($data) < 1) {
            throw new Error('No SMS Log Data Found');
        }
        return response()->json([$data, $edu_cost, $site_cost, $edu_return], 200, []);

    }

    public function getIssueLog(Request $request)
    {

        $date = $request->date;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $issue_types = $request->issue_types;
        $site_id = $request->site_id;
        $txt = '%' . $search_txt . '%';

        $data = IssueDetail::when($search_txt, function ($q) use ($txt) {
            $q->where('username', 'LIKE', $txt);
        })
        ->when($date, function ($q) use ($date) {
            $q->whereDate('created_at', $date);
        })
        ->when($issue_types, function ($q) use ($issue_types) {
            $q->whereIn('issue_type', $issue_types);
        })
        ->when($site_id, function ($q) use ($site_id) {
            $q->where('site_id', $site_id);
        })
        ->orderBy('id', 'DESC')
        ->paginate($paginate);

        if (count($data) < 1) {
            throw new Error('No Data Found');
        }

        return response()->json($data, 200, []);

    }

    public function getStudentAbsentLog(Request $request)
    {

        //dd('dd');

        $date = $request->date;
        $paginate = $request->paginate;
        $search_txt = $request->search_txt;
        $site_id = $request->site_id;


        $data = GlobalStudentAbsent::
        when($date, function ($q) use ($date) {
            $q->whereDate('created_at', $date);
        })->when($site_id, function ($q) use ($site_id) {
            $q->where('site_id', $site_id);
        })->orderBy('id', 'DESC')
            ->paginate($paginate);



        if (count($data) < 1) {
            throw new Error('No Data Found');
        }

        return response()->json($data, 200);

    }

    public function getSmsStatusById(Request $request)
    {

        $m_id = $request->res_msg_id;
        $company = $request->company;
        $data = $this->checkSmsStatus($m_id, $company);

        //dd($data);
        return response()->json($data, 200);

    }

    public function returnSmsBalance(Request $request)
    {

        $id = $request->id;
        $the_sms = $this->smsFollowUp->find($id);


        if ($the_sms->returned_charges > 0) {
            return response()->json(['message' => 'Already returned: '.$the_sms->returned_charges], 410);
        }
        if ($request->returned_charges > $the_sms->edu_charged_from_client) {
            return response()->json(['message' => 'Cant"t return more than cut!'], 410);
        }

        $the_sms->returned_charges = $request->returned_charges;
        $the_sms->save();

        $this->returnSmsCutBalance($request->returned_charges, 'site', $the_sms->institution_id);

        return response()->json(['message' => 'Successfully returned the balance'], 200);

    }

    public function newDbBackup()
    {

        try {
             \Artisan::call('db:backup');
            $data = $this->dbBackupList();


            $message = '';

            /*  if ($this->sendDbFileThroughEmail()) {
                  $message = ' And Mail the file';
              }*/


            return response()->json(['data' => $data, 'mode' => 'success', 'message' => 'Backup Taken ' . $message . ' Successfully']);
        } catch (\Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function getBackupList(Request $request)
    {

        $date_range = $request->date_range ? json_decode($request->date_range) : null;
        $start = $date_range->start;
        $end = $date_range->end;


        $data = $this->dbBackupList($start, $end);


        return response()->json($data, 200, []);

    }


    function zipFilesAndDownload($file_names, $archive_file_name, $file_path)
    {
        //echo $file_path;die;
        $zip = new ZipArchive();
        //create the file and throw the error if unsuccessful
        if ($zip->open($archive_file_name, ZIPARCHIVE::CREATE) !== TRUE) {
            exit("cannot open <$archive_file_name>\n");
        }
        //add each files of $file_name array to archive
        foreach ($file_names as $files) {
            $zip->addFile($file_path . $files, $files);
            //echo $file_path.$files,$files."

        }
        $zip->close();
        //then send the headers to force download the zip file
        header("Content-type: application/zip");
        header("Content-Disposition: attachment; filename=$archive_file_name");
        header("Pragma: no-cache");
        header("Expires: 0");
        readfile("$archive_file_name");
        exit;
    }

    public function dbBackupList($start_date = null, $end_date = null)
    {
        $date = Carbon::now()->toDateString();
        $start_date = $start_date ?? $date;
        $end_date = $end_date ?? $date;

        //   dd($start_date)

        $path = storage_path('backups/');

        $files = File::files($path);

        if (count($files) < 1) {
            throw new Error('No Back up file found!');
        }

        $data = [];

        $ar_rev = array_reverse($files);


        $sl = 0;
        foreach ($ar_rev as $k => $file) {

            $info = new SplFileInfo($file);

            if ($info->isFile()) {

                $file_date = date('Y-m-d', $info->getCTime());

                // $this->makeZip($info->getBasename());


                //dd(date('Y-m-d h:i:s A', $info->getCTime()));

                if (($file_date >= $start_date) && ($file_date <= $end_date)) {
                    $data[$sl]['id'] = $sl;
                    $data[$sl]['name'] = $info->getBasename();
                    $data[$sl]['extension'] = $info->getExtension();
                    $data[$sl]['path'] = $info->getPath();
                    $data[$sl]['size'] = number_format($info->getSize() / 1024 / 1024, 2) . ' MB';
                    $data[$sl]['created_at'] = date('d M Y h:i:s A', $info->getCTime());

                    $sl++;
                } else {
                    continue;
                }
            }
        }

        if (count($data) < 1) {
            throw new Error('No Back up file found!');
        }

        // dd($data);

        return $data;

    }


    private function makeZip($file)
    {


        $file_info = new SplFileInfo($file);


        $zipFileName = 'AllDocuments.zip';
        // Create ZipArchive Obj
        $zip = new ZipArchive;
        if ($zip->open(storage_path() . '/backups/' . $zipFileName, ZipArchive::CREATE) === TRUE) {
            // Add File in ZipArchive
            $zip->addFile(storage_path() . '/backups', $file);
            // Close ZipArchive
            $zip->close();
        }

    }

    public function download(Request $request)
    {
        $file_name = $request->name;
        $path = storage_path('backups/' . $file_name);
        return response()->download($path);


        //return response()->download('G:\Current\EduWorld\eduworld\storage\backups\1570540521-backup.sql');

    }


    public function deleteBackupFile(Request $request)
    {

        $file_name = $request->file_name;
        $path = storage_path('backups/' . $file_name);

        if (!File::exists($path)) {
            throw new Error($file_name . ' Does not exist!');
        }

        Storage::delete('backups/' . $file_name);

        unlink($path);

        return response()->json(['mode' => 'Deleted', 'message' => 'Successfully Deleted!']);
    }


    public function getIssueTypes(Request $request)
    {
        return $this->issueTypes();
    }


    public function fetchedDeviceLogDetails(Request $request)
    {

        //
        
     // $this->saveDeviceLogToEduDb($data = null, $company='stellar');
        ///


        $now = Carbon::now();
        $today_date = $now->toDateString();

        $search_txt = $request->search_txt;
        $paginate = $request->paginate ?? 50;
        $status = $request->status;


        if (!$request->att_date) {
            throw new Error('Date Must Be Selected!');
        }
        $txt = '%' . $search_txt . '%';


        $att_date = $request->att_date ?? $today_date;
        $device_ids = $request->device_ids ? explode(',', $request->device_ids) : [];


        $data = $this->deviceLog
            ->where('access_date', $att_date)
            ->when(count($device_ids) > 0, function ($query) use ($device_ids) {
                return $query->whereIn('device_id', $device_ids);
            })
            ->when($search_txt, function ($q) use ($txt) {
                return $q->where(function ($query) use ($txt) {
                    $query->where('user_biometric_id', 'LIKE', $txt);
                });
            })
            ->orderBy('id', 'DESC')
            ->paginate($paginate);

        if (count($data) < 1) {

            throw new Error('No Fetched Data Found For The Criteria!');
        }


        return $data;
    }


    public function fetchStudentAttendanceLog($s_date_time, $e_date_time, $ids = null)
    {
      

        if ($s_date_time == 'null' || $e_date_time == 'null') {
            return Response::json(['message' => 'Please Select Both Date'], 410);
        }

        $connected = $this->is_connected();

        if (!$connected) {
            return Response::json(['message' => 'Please Check Your Internet Connection'], 410);
        }

        $id_array = $ids ? explode(',', $ids) : [];

        $s_dt = new DateTime($s_date_time);
      //  $e_dt = new DateTime($s_date_time);
        $e_dt = new DateTime($e_date_time);

        if ($s_dt > $e_dt) {
            return Response::json(['message' => 'End Date Can"t Earlier Than Start Date'], 410);
        }

        $s_date = $s_dt->format('Y-m-d');
      //  $e_date = $s_dt->format('Y-m-d');
        $e_date = $e_dt->format('Y-m-d');
        $s_time = $s_dt->format('H:i:s');
        $e_time = $e_dt->format('H:i:s');
        // $s_time = '00:00:00';
        // $e_time = '23:58:12';
       // dd($id_array);

        if (count($id_array)) {
            $fetchedData = $this->fetchLogByDevice($s_date, $s_time, $e_date, $e_time, $ids);
        } else {
            $fetchedData = $this->fetchLog($s_date, $s_time, $e_date, $e_time);
        }

       
        // inovace

       $inovace_data = $this->fetchInovaceLog($s_date, $s_time, $e_date, $e_time);

        if (count($fetchedData) < 1 && count($inovace_data) < 1) {
            return Response::json(['message' => 'No Data Fetched!'], 410);
        }

        $st_total = $this->saveDeviceLogToEduDb($fetchedData, 'stellar');
        $in_total = $this->saveDeviceLogToEduDb($inovace_data, 'inovace');

        $get_device_log = $this->deviceLog
            ->whereBetween('access_date_time', [$s_dt, $e_dt])
       //     ->orderBy('access_date_time', 'ASC')
            ->orderBy('access_time', 'ASC')
            ->where('executed_status', 0)
            ->get();


        if (count($get_device_log) > 0) {
            $saved_updated_date = $this->organizeSavedDeviceLog($get_device_log);
        } else {
            return Response::json(['message' => 'No deviceLog Found For the Start Date:' . $s_dt->format('d F Y g:i A') . ' End Date:' . $e_dt->format('d F Y g:i A')], 410);
        }

        $data_saved = $saved_updated_date[0];
        $data_updated = $saved_updated_date[1];
        $emp_saved = $saved_updated_date[2];
        $emp_updated = $saved_updated_date[3];

        $modified_students = null;
        $unique_student_att_ids = array_unique(array_merge($data_saved, $data_updated));
        if (count($unique_student_att_ids) > 0) {
            $modified_students = GlobalStudentAttendance::
            whereIn('id', $unique_student_att_ids)
                ->with(['studentHistory.student' => function ($q) {
                    $q->select(['id', 'username', 'site_id']);
                }])
                ->orderBy('student_history_id', 'ASC')
                ->get();
        }


        $modified_employees = null;
        $unique_emp_att_ids = array_unique(array_merge($emp_saved, $emp_updated));


        if (count($unique_emp_att_ids) > 0) {
            $modified_employees = GlobalEmployeeAttendance::
            whereIn('id', $unique_emp_att_ids)
                ->with(['employee' => function ($q) {
                    $q->select('id');
                }])
                ->get();
        }

        $message = '<b>Employee: </b>{Saved:- ' . count($emp_saved) . '; Updated: ' . count($emp_updated) . '} </br> <b> Student: </b> {Saved: ' . count($data_saved) . '; Updated: ' . count($data_updated) . '}';
        return response()->json(['data' => [$modified_students, $modified_employees], 'message' => $message], 200, [], JSON_NUMERIC_CHECK);

    }


}