<?php

namespace App\Http\Controllers\Edu\EduUser;


use App\Models\Edu\EduRole;
use App\Models\Role\Role;
use App\Models\Site\SiteInfo;
use App\Models\User\User;
use DB;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Language\Lang;
use Illuminate\Validation\ValidationException;
use Response;
use Exception;

class EduUserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     *
     *
     */
    use Lang;

    private $user;

    public function __construct(User $user)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->user = $user;

    }

    public function index()
    {
        $viewType = 'Edu User List';

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.edu.user.edu-user-list', compact('viewType'));
    }


    public function eduUserList()
    {
        try {
            $user = User::select('id', 'username', 'email', 'phone', 'status')->get();
            return $user;
        } catch (ModelNotFoundException $exception) {

            return JsonResponse::create(['message' => 'User Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }

    public function getSiteListDependsOnSiteGroup($id)
    {

        $siteList = SiteInfo::where('site_group_id', '=', $id)->get();
        return [$siteList];

    }


    //get edu user list with pagination
    public function eduUserListWithPagination()
    {

        try {

            $userWithPagination = User::select('id', 'username', 'email', 'phone', 'status')->paginate(10);

            return $userWithPagination;

        } catch (ModelNotFoundException $exception) {

            return JsonResponse::create(['message' => 'User Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }

    //get edu user list with pagination
    public function getEduUserListAndRoleList(Request $request)
    {
       // dd(\Session::all());

        try {


            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $status = $request->status;
            $txt = '%' . $search_txt . '%';

            $userWithPagination = $this->user
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('username', 'LIKE', $txt)
                            ->orWhere('email', 'LIKE', $txt)
                            ->orWhere('contact_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('first_name', $txt)
                            ->orWhereTranslationLike('last_name', $txt);
                    });
                })
                ->where('status', $status)
                ->with(['eduRoles', 'siteInfoes'])
                ->select('id', 'username', 'email', 'phone', 'contact_number', 'status', 'contact_number')
                ->paginate($paginate);
            $eduRole = EduRole::all();

            return response()->json([$userWithPagination, $eduRole], 200);

        } catch (ModelNotFoundException $exception) {

            return JsonResponse::create(['message' => 'User Or Role Not Found'], 410);

        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage(), 410]);
        }
    }


    public function eduUserAddForm()
    {
        //
    }


    public function eduUserStore(Request $request)
    {

        try {
            $this->validate($request, [
                'username' => 'required|unique:users',  //unique:table name
                'password' => 'required',  //unique:table name
                'email' => 'required|unique:users',  //unique:table name
                'phone' => 'required',  //unique:table name


            ]);

            $this->user->username = $request->get('username');
            $this->user->password = $request->get('password');
            $this->user->email = $request->get('email');
            $this->user->phone = $request->get('phone');
            $this->user->status = $request->get('status');
            $this->user->alias = session()->get('ALIAS1');
            // $this->user->save();


            if ($this->user->save()) {
                $role_ids = $request->eduRolecheckbox;
                $this->user->eduRoles()->sync($role_ids);

                $site_id = $request->siteListcheckbox;
                $this->user->siteInfoes()->sync($site_id);

                DB::table('photos')->insert(
                    [
                        'name' => 'image-not.png',
                        'user_id' => $this->user->id,
                        'imageable_id' => $this->user->id,
                        'imageable_type' => 'App\User'
                    ]
                );
                return Response::json(['message' => 'User Saved Successfully!'], 200);
            }


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function update(Request $request, $id)
    {
        try {

            $this->validate($request, [

                'username' => 'required|unique:users,username,' . $id . ',id',
                'email' => 'required|unique:users,email,' . $id . ',id',
                'phone' => 'required',

            ]);

            $eduUserToEdit = $this->user->findOrFail($id);

            $eduUserToEdit->username = $request->get('username');
            $eduUserToEdit->email = $request->get('email');
            $eduUserToEdit->phone = $request->get('phone');
            $eduUserToEdit->status = $request->get('status');

            $role_ids = $request->eduRolecheckbox;
            $eduUserToEdit->eduRoles()->sync($role_ids);

            $site_id = $request->siteListcheckbox;
            $eduUserToEdit->siteInfoes()->sync($site_id);

            if ($eduUserToEdit->save()) {

                return Response::json(['message' => 'Successfully Updated!'], 200);
            }
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }

    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
