<?php

namespace App\Http\Controllers\Edu\Device;

use App\Models\Edu\Device\DeviceDetail;
use App\Models\Edu\Device\DeviceLog;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;

class DeviceController extends Controller
{

    private $deviceDetails;
    private $deviceLog;


    public function __construct(DeviceDetail $detail, DeviceLog $deviceLog)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->deviceDetails = $detail;
        $this->deviceLog = $deviceLog;
    }

    public function getDeviceDetails()
    {
        $data = DeviceDetail::with('site')->paginate(10);
        return response()->json($data, 200, [], JSON_NUMERIC_CHECK);

    }


    public function add(Request $validatedRequest)
    {


        $this->validate($validatedRequest, [
            'device_id' => 'required',
            'status' => 'required',
        ]);


        if (count($this->deviceDetails->ownFields) > 0) {
            foreach ($this->deviceDetails->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $this->deviceDetails->{$ownField} = $validatedRequest->{$ownField};
                }
            }
            $this->deviceDetails->status = $validatedRequest->status;
        }

        if ($this->deviceDetails->save()) {

            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);

        }

    }

    public function update(Request $validatedRequest, $id)
    {
        $this->validate($validatedRequest, [
            'device_id' => 'required',
            'status' => 'required',
        ]);

        $toEdit = $this->deviceDetails->findOrFail($id);


        if (count($toEdit->ownFields) > 0) {
            foreach ($toEdit->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $toEdit->{$ownField} = $validatedRequest->{$ownField};
                }
            }
            $toEdit->status = $validatedRequest->status;

        }

        if ($toEdit->save()) {
            return Response::json(['message' => 'Updated Successfully', 'mode' => 'Updated!'], 200);
        }
    }


    public function delete($id)
    {
        $the_role = $this->role->findOrFail($id);
        $the_role->delete();

        return Response::json(['message' => 'Deleted Successfully', 'mode' => 'Updated!'], 200);


    }


    //API---------=========================API--------------------


    public function getLogByDateAndUsername(Request $request)
    {
        try {

            $username = $request->username;
            $date = $request->attendace_date;


            $device_logs = $this->deviceLog
                ->where('user_biometric_id', $username)
                ->where('access_date', $date)
                ->orderBy('access_time', 'ASC')
                ->get();

           // throw new \Error($date);

            return Response::json([$device_logs], 200);


        } catch (Exception $exception) {

            return Response::json($exception->getMessage());

        }
    }


}
