<?php

namespace App\Http\Controllers\Edu\DashboardPalette;

use App\Mail\Site\SendSiteInfo;
use App\Models\Edu\DashboardPalette\DashboardPalette;
use Artisan;
use Auth;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\ValidationException;
use Mail;

class DashboardPaletteController extends Controller
{

    private $dashboardPalette;

    public function __construct(DashboardPalette $dashboardPalette)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
        $this->dashboardPalette = $dashboardPalette;
    }

    public function index()
    {
        $viewType = "Edu Dashboard Palette List";
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function getDashboardPaletteList()
    {
        $list = $this->dashboardPalette->get();

        return response()->json($list, 200);
    }

    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required|unique:edu_dashboard_palettes',
                'key_id' => 'required|unique:edu_dashboard_palettes',
                'palette_for' => 'required',
            ]);

            if (count($this->dashboardPalette->ownFields)) {
                foreach ($this->dashboardPalette->ownFields as $field => $ownField) {
                    if ($request->{$ownField} || $request->status) {
                        $this->dashboardPalette->{$ownField} = $request->{$ownField};
                    }
                }
            }
            $this->dashboardPalette->save();
            return JsonResponse::create(['message' => 'Role Created Successfully!'], 200);

        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function update(Request $request, $id)
    {

        try {
            $this->validate($request, [
                'name' => 'required|unique:edu_roles,name,' . $id . ',id',
                'key_id' => 'required|unique:edu_dashboard_palettes,key_id,'. $id . ',id',

                'description' => 'max:120'

            ]);
            $palette = $this->dashboardPalette->findOrFail($id);

            $palette->name = $request->name;
            $palette->key_id = $request->key_id;
            $palette->key = $request->key;
            $palette->menu_id = $request->menu_id;
            $palette->palette_for = $request->palette_for;
            $palette->status = $request->status;
            $palette->save();

            //$to_edit = $this->dashboardPalette->findOrFail($id);
            // if (count($to_edit->ownFields)) {
            //     foreach ($to_edit->ownFields as $field => $ownField) {
            //         if ($request->{$ownField} || $request->status) {
            //             $to_edit->{$ownField} = $request->{$ownField};
            //         }
            //     }
            // }
            //$to_edit->save();
            return JsonResponse::create(['message' => 'Updated Successfully!'], 200);

        } catch (ModelNotFoundException $y) {
            return JsonResponse::create(['message' => 'Model Value Not Found'], 410);
        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }


    }
}
