<?php

/**
 * Created by PhpStorm.
 * User: Abdul Aziz
 * Date: 5/7/2016
 * Time: 11:26 AM
 */
namespace App\Http\Controllers\Country;

use App\Forms\CountryForm;
use App\Http\Controllers\Controller;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Models\Country\Country;
use App\Models\Division\Division;
use App\Models\Site\SiteInfo;
use Illuminate\Http\Request;
use PhpParser\Error;
use Session;
use Exception;
use Response;
//use App\Http\Requests;
//use Request;

class CountryController extends ProjectController
{
    use Lang,FormControll;

    private $country;

    /**
     * @param Country $country
     */
    public function __construct(Country $country)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker',['except' => ['SiteBaseCountryList', 'getCountryList']]);

        $this->country = $country;
    }

    /**
     * @param Country $country
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Country $country)
    {
        $viewType = 'Country List';
//        $locale = $this->chosenLanguage();
//        $defaultLocale = $this->defaultLocale();
//        $countryList = $country->paginate(50);

        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.country.index',compact('viewType', 'countryList', 'locale', 'defaultLocale'));
    }

    public function getCountryListPagination(Request $request)
    {
//        return $request;
        $paginate = $request->paginate;
        $country_id = $request->country_id;
        $country_list = Country::when($country_id, function ($q) use($country_id){
            $q->where('id', $country_id);
        })->paginate($paginate);
        return $country_list;
    }


    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function createCountryForm()
    {
        $viewType = 'Create Country';

        return view('default.admin.country.create',compact('viewType'));

    }


    public function createCountry(Request $request, Country $country)
    {
        $country->country_name = $request->country_name;
        $country->govt_code = $request->govt_code;
        $country->status = $request->status;

        if($country->save()){
            return Response::json(['message' => 'Successfully Saved!', 'mode' => 'Save'], 200);
        }
//        return $this->country->save()?back()->withSuccess('Successfully Created'):null;
    }

    /**
     * @param $id
     * @param CountryForm $countryForm
     */
    public function getCountryEditForm($id, CountryForm $countryForm)
    {
        $viewType = 'Edit Country';
        $editCountry = $countryForm;
        $countryData = $this->editFormModel($this->country->findOrFail($id));

        return view('default.admin.country.edit', compact('viewType', 'editCountry', 'countryData'));
    }

    public function editCountry($id, Request $request)
    {
        $countryToEdit = $this->country->findOrFail($id);


        $countryToEdit->country_name = $request->country_name;
        $countryToEdit->govt_code = $request->govt_code;
        $countryToEdit->status = $request->status;

        if($countryToEdit->save()){
            return Response::json(['message' => 'Successfully Updated!', 'mode' => 'Update'], 200);
        }

    }

    /**
     * @param $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function viewCountry($id)
    {
        $locale = $this->chosenLanguage();
        $defaultLocale = $this->defaultLocale();
        $countryData = $this->country->findOrFail($id);
        //dd($countryData);

        return view('default.admin.country.view',compact('countryData','locale','defaultLocale'));
    }

    /**
     * @param $id
     * @return $this
     */
    public function deleteCountry($id)
    {
        $countryToDelete = $this->country->findOrFail($id);
        if ($countryToDelete->division_check == 0) {
            if ($countryToDelete->delete()) {
                return Response::json(['message' => 'Successfully Deleted!', 'mode' => 'Delete'], 200);
            }
        }else{
           throw new Error('There is a dependecy');

        }

    }



    public function SiteBaseCountryList($id)
    {


            $site_country_id=SiteInfo::select('country_id')->where('id', $id)->first();
            $CountryList = Country::where('status', 1)
                ->where('id', $site_country_id->country_id)
                ->get();

        return $CountryList;
    }

    public function getCountryList()
    {

        $CountryList = Country::get();

        return response()->json($CountryList,200);
    }
}