<?php

namespace App\Http\Controllers\Company\Role;

use App\Models\Company\Company;
use App\Models\Company\Role\CompanyRole;
use App\Models\Package\EduPackage;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;
use Validator;

class RoleController extends Controller
{
    private $role;

    public function __construct(CompanyRole $role)
    {
        $this->middleware('auth');
        $this->role = $role;
    }


    public function index()
    {
        $viewType = 'Role List';
        return view('default.admin.company.role.index', compact('viewType'));
    }

    public function create(Request $validatedRequest)
    {


        $this->validate($validatedRequest, [
            'name' => 'required|unique:company_roles,name,'.Session::get('COMPANY_ID').',company_id',
            'key' => 'unique:company_roles,key',
            'selectedSubModule' => 'required',
        ]);


        $this->role = new CompanyRole();
        $sub_module_ids = implode(',', $validatedRequest->selectedSubModule) ?? null;


        if (count($this->role->ownFields) > 0) {
            foreach ($this->role->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $this->role->{$ownField} = $validatedRequest->{$ownField};
                }
            }

            $this->role->key = 'general';

        }

        if ($this->role->save()) {


            $this->role->roleAccess()->create([
                'company_role_id' => $this->role->id,
                'company_id' => $this->role->company_id,
                'sub_module_ids' => $sub_module_ids,
            ]);
            return Response::json(['message' => 'Saved Successfully!', 'mode' => 'Saved!'], 200);

        }
    }

    public function update(Request $validatedRequest, $id)
    {
        $this->validate($validatedRequest, [
            'name' => 'required|unique:company_roles,name,'.$id.',id,company_id,'.Session::get('COMPANY_ID'),
            'key' => 'unique:company_roles,key,' . $id,
            'selectedSubModule' => 'required',
        ]);

        $sub_module_ids = implode(',', $validatedRequest->selectedSubModule) ?? null;


        $toEdit = $this->role->findOrFail($id);
        if (count($toEdit->ownFields) > 0) {
            foreach ($toEdit->ownFields as $ownField) {
                if ($validatedRequest->{$ownField}) {
                    $toEdit->{$ownField} = $validatedRequest->{$ownField};
                }
            }
        }

        if ($toEdit->roleAccess == null) {
            $toEdit->roleAccess()->create([
                'company_role_id' => $toEdit->id,
                'company_id' => $toEdit->company_id,
                'sub_module_ids' => $sub_module_ids,
            ]);
        } else {
            $toEdit->roleAccess->update([
                'sub_module_ids' => $sub_module_ids
            ]);
        }

        $this->rearrangeSidebar($id);


        if ($toEdit->save()) {
            return Response::json(['message' => 'Updated Successfully', 'mode' => 'Updated!'], 200);
        }
    }


    public function delete($id)
    {
        $the_role = $this->role->findOrFail($id);
        $the_role->delete();

        return Response::json(['message' => 'Deleted Successfully', 'mode' => 'Updated!'], 200);


    }

    //Api================================Api======

    public function  getRoleList()
    {
        $list = $this->role->with('roleAccess')->get();
        return response()->json($list, 200, [], JSON_NUMERIC_CHECK);

    }

    public function rearrangeSidebar($role_id)
    {
        $get_all_users_with_role = CompanyRole::findOrFail($role_id)->users()->get() ?? null;

        foreach ($get_all_users_with_role as $k => $value) {
            $user_id = $value->id;
            if (file_exists(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS1') . '/' . $user_id . '.blade.php'))) {
                unlink(base_path("resources/views/default/admin/layouts/sidebars/" . Session::get('ALIAS1') . '/' . $user_id . '.blade.php'));
            }
        }
    }


}
