<?php

namespace App\Http\Controllers\Assessment\Setting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Assessment\AssessmentExpertise;
use App\Models\Assessment\AssessmentTypeNo;

class AcademicAssessmentExpertiseController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
     //   $this->middleware('eduworlduserchecker');
    }

    public function index()
    {
        $viewType = 'Assessment Expertise List';
       
        return view('default.admin.layouts.master', compact('viewType'));
    }

    // public function assessmentExpertiseAdd(Request $request)
    // {
    
    //     $request->validate([
    //         'academic_class_id'=> 'required',
    //         'academic_subject_id'=> 'required',
    //         'type_id'=> 'required',
    //         'name'=> 'required',
    //     ]);

    //     $existExpertise = AssessmentExpertise::where('academic_class_id',$request->academic_class_id)
    //         ->where('academic_subject_id',$request->academic_subject_id)
    //         ->where('type_id',$request->assessment_type_id)
    //         ->where('name',$request->name)
    //         ->first();

    //     if($existExpertise){
    //         return response()->json(['message'=>'This Expertise already added'],422);
    //     }

    //     $assessmentExpertise = new AssessmentExpertise();

    //     $assessmentExpertise->academic_class_id     = $request->academic_class_id;
    //     $assessmentExpertise->academic_subject_id     = $request->academic_subject_id;
    //     $assessmentExpertise->assessment_type_id     = $request->assessment_type_id;
    //     $assessmentExpertise->name     = $request->name;
    //     $assessmentExpertise->serial      = $request->serial;
    //     $assessmentExpertise->description      = $request->description;
    //     $assessmentExpertise->status      = $request->status;
    //     $assessmentExpertise->save();
    //     return response()->json(['message'=>'Created Successfully!']);
    // }
    public function assessmentExpertiseAdd(Request $request)
    {
    
        $request->validate([
            'assessment_type_id'=> 'required',
            'name'=> 'required',
        ]);

        $existExpertise = AssessmentExpertise::where('assessment_type_id',$request->assessment_type_id)
            ->where('name',$request->name)
            ->first();

        if($existExpertise){
            return response()->json(['message'=>'This Expertise already added'],422);
        }

        $assessmentExpertise = new AssessmentExpertise();

        $assessmentExpertise->assessment_type_id     = $request->assessment_type_id;
        $assessmentExpertise->name     = $request->name;
        $assessmentExpertise->english_name     = $request->english_name;
        $assessmentExpertise->serial      = $request->serial;
        $assessmentExpertise->description      = $request->description;
        $assessmentExpertise->status      = $request->status;
        $assessmentExpertise->save();
        return response()->json(['message'=>'Created Successfully!']);
    }

    public function assessmentExpertiseList (Request $request){

        $assessmentTypeList=AssessmentExpertise::with('assessmentType')
            ->when($request->assessment_type_id!='null',function($q) use ($request){
                $q->where('assessment_type_id',$request->assessment_type_id);
            })
            ->orderBy('assessment_type_id')
            ->orderBy('serial')
            ->paginate(20);
        
        return response()->json($assessmentTypeList);
    }

    public function assessmentExpertiseUpdate(Request $request , $id){
        $request->validate([
            'assessment_type_id'=> 'required',
            'name'=> 'required',
        ]);

        $existExpertise = AssessmentExpertise::where('assessment_type_id',$request->assessment_type_id)
            ->where('name',$request->name)
            ->where('id','!=', $id)
            ->first();

        if($existExpertise){
            return response()->json(['message'=>'This Expertise already added'],422);
        }

        $assessmentExpertise = AssessmentExpertise::findOrFail($id);
        $assessmentExpertise->assessment_type_id     = $request->assessment_type_id;
        $assessmentExpertise->name     = $request->name;
        $assessmentExpertise->english_name     = $request->english_name;
        $assessmentExpertise->serial      = $request->serial;
        $assessmentExpertise->description      = $request->description;
        $assessmentExpertise->status      = $request->status;
        $assessmentExpertise->save();
        return response()->json(['message'=>'Updated Successfully!']);
    }
}
