<?php

namespace App\Http\Controllers\Api;


use App\Forms\DataHelper;
use App\Models\JobApplication\GlobalJobCircular;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicDepartment;
use App\Models\Academic\AcademicSubject;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Academic\AcademicStudentCategory;
use App\Models\Academic\AcademicVersion;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Edu\ClassRoom\EduClassRoom;
use App\Models\Academic\AcademicAdmissionType;
use App\Models\Academic\AcademicStudentType;
use App\Models\Academic\AcademicSession;
use App\Models\Relation\Relation;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Menu\Menu;
use App\Models\ProjectModel;
use App\Models\Site\Employee\Employee;

use App\Models\Academic\AcademicGroup;
use App\Models\Company\GlobalCompany;
use App\Models\Site\GlobalSiteClassSessionSerialSetting;

use App\Models\Site\Notice\Notice;

use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\SiteInfoSetting;
use App\Models\Site\Web\AboutUs\AboutUs;
use App\Models\Site\Web\Calendar\CalenderEvent;
use App\Models\Site\Web\ClassRoom\ClassRoom;
use App\Models\Site\Web\DesingSetting\SiteWebsiteHeaderDesign;
use App\Models\Site\Web\Event\Event;
//use App\Models\Event\Event;
use App\Models\Site\Web\Message\Message;

use App\Models\Site\Web\SiteWebSiteVisitorDetail;
use App\Models\SiteGroup\GlobalSiteGroup;

use App\Models\SiteGroup\GlobalSiteGroupSetting;
use App\Models\WebSite\WebsiteMenu;
use App\User;
use Carbon\Carbon;
use Error;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\JsonResponse;
use Response;
use Auth;
use Image;
use App\Models\Site\Web\Video\Video;
use Illuminate\Foundation\Application;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\SiteInfoSetting\GlobalSiteInfoSetting;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\JobApplication\GlobalJobApplication;
use App\Models\Site\Batch\GlobalBatchDetail;
use App\Models\Site\Employee\GlobalEmployee;
use App\Models\Site\Student\Manual\GlobalStudentManualCount;

class WebSiteController extends Controller
{

    private $app;
    private $studentHistory;
    private $localeCode;

    public function __construct(Application $app, GlobalStudentHistory $studentHistory)
    {
        $this->middleware('guest:api');
        $this->middleware('api.access');
        // $this->middleware('sitepagechecker');

        $this->app = $app;
        $this->studentHistory = $studentHistory;

        $this->middleware(function ($request, $next) {
            $this->localeCode = $this->getLocalize();
            return $next($request);
        });
    }




    private function getLocalize()
    {



        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {

            $getHost = explode(".", $_SERVER['HTTP_HOST']);

            $domain = array_shift($getHost);
        }


        $url = $domain;
        $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
        if ($site_info) {
            $desing_setting = SiteWebsiteHeaderDesign::where('site_id', $site_info->id)->first();
            //  return $desing_setting->theme_language;
            Session::put('locale', $desing_setting->theme_language);
            $this->app->setLocale($desing_setting->theme_language);
        } else {
            Session::put('locale', 'en');
            $this->app->setLocale('en');
        }

        // $sitGroupToEdit = $this->siteGroup->findOrFail($id);


        // return $next($request);

    }




    public function commonData()
    {
        //   dd('$domain');
        if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
            $getHost = explode(".", $_SERVER['HTTP_HOST']);
            $domain = array_shift($getHost);


            // $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            // $site_id = $site_info->id;
            // Session::put('SITE_ID', $site_id);
        }

        $url = $domain;

        $data = $this->getData($url);
        // dd($data);
        return response()->json($data, 200);
    }

    public function StoreJobApplocation(GlobalJobApplication $newlyCreated, Request $request)
    {
        $request->validate([
            'position' => 'required|string|max:255',
            'fullName' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|max:20',
            'address' => 'required|string|max:255',
            'experience' => 'required|string|max:1000',
            'education' => 'required|string|max:1000',
            'imageFile' => 'required',


        ]);

        if ($request->imageFile) {
            $name = time() . '.' . explode('/', explode(':', substr($request->imageFile, 0, strpos($request->imageFile, ';')))[1])[1];
            $fileName = $name;
            Image::make($request->imageFile)->resize(440, 442)->save(public_path('uploads/') . $name);
        } else {
            $fileName = 'image-not.png';
        }




        $newlyCreated->position = $request->position;
        $newlyCreated->fullName = $request->fullName;
        $newlyCreated->email = $request->email;
        $newlyCreated->phone = $request->phone;
        $newlyCreated->address = $request->address;
        $newlyCreated->experience = $request->experience;
        $newlyCreated->education = $request->education;
        $newlyCreated->coverLetter = $request->coverLetter;
        // $newlyCreated->resumeFileName = $request->resumeFileName;
        // $newlyCreated->resumeFile = $request->resumeFile;
        $newlyCreated->site_id = $request->site_id;

        $newlyCreated->save();

        $newlyCreated->photos()->create([
            'path' => '/uploads/' . $fileName,
            'name' => $fileName
        ]);
        return response()->json([
            'success' => true,

            'message' => 'Job Application submitted successfully.'
        ], 200);
    }
    public function getJobCircular(Request $request)
    {
        $site_id = $this->getSiteId($request);
        return GlobalJobCircular::where('site_id', $site_id)

            ->orderBy('id', 'DESC')
            ->get();
    }


    public function getAboutUs(Request $request)
    {
        $site_id = $this->getSiteId($request);

        $site_settings = SiteWebsiteHeaderDesign::where('site_id', $site_id)->select(
            'site_id',
            'aboutus_show_status',
            'theme_background_color',
            'theme_text_color',
            'theme_language'
        )->first();

        $latest_about_data = AboutUs::where('status', 1)
            ->where('type', 'aboutus')
            ->with('files')
            ->orderBy('id', 'DESC')
            ->first();

        $latest_about_data_list = [
            'id' => $latest_about_data->id,
            'description' => $latest_about_data->description,
            'title' => $latest_about_data->title,
            'aboutus_show_status' => $site_settings ? $site_settings->aboutus_show_status : true,
            'theme_background_color' => $site_settings ? $site_settings->theme_background_color : true,
            'theme_text_color' => $site_settings ? $site_settings->theme_text_color : true,
            'theme_language' => $site_settings ? $site_settings->theme_language : true,
        ];


        $image_src = "https://" . request()->getHost() . "/image/demo_image.jpg";

        if (!$latest_about_data) {
            $latest_about_data_list = [
                'id' => 0,
                'description' => "<p><img alt=\"\" src=\"$image_src\" style=\"height:60%; width:100%\" /></p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc,</p>",
                'title' => 'Sample History',
                'aboutus_show_status' => true,
            ];
        }

        return response()->json($latest_about_data_list, 200);
    }

    public function getLatestAboutUs(Request $request)
    {
        // return $request->site_id;
        Session::put('SITE_ID', $request->site_id);
        $type = $request->type;
        $site_id = Session::get('SITE_ID');
        $latest_about_data = AboutUs::where('status', 1)
            ->where('type', $type)
            ->orderBy('id', 'DESC')
            ->first();
        // dd($latest_about_data);


        $image_src = "https://" . request()->getHost() . "/image/demo_image.jpg";

        if ($latest_about_data) {
            $latest_about_data_list = $latest_about_data;
        } else {
            $latest_about_data_list = [

                'id' => 0,
                'description' => "<p><img alt=\"\" src=\"$image_src\" style=\"height:70%; width:100%\" /></p><p>&nbsp;</p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc,</p>",
                'title' => 'Sample History',

            ];
        }


        return response()->json($latest_about_data_list, 200);
    }



    public function getLatestNotice(Request $request)
    {
        $site_id = $this->getSiteId($request);

        $site_id = Session::get('SITE_ID');
        $notices = Notice::whereNotNull('web_publish_time')
            ->where('web_publish_time', '<=', Carbon::now())
            ->orderBy('web_publish_time', 'DESC')
            ->limit(5)
            ->with('files')
            ->get();

        return response()->json($notices, 200);
    }

    public function getLatestNoticeForSiteber(Request $request)
    {
        $site_id = $this->getSiteId($request);

        $notices = Notice::whereNotNull('web_publish_time')
            ->where('web_publish_time', '<=', Carbon::now())
            ->orderBy('pin_status', 'DESC')
            ->orderBy('web_publish_time', 'DESC')
            ->orderBy('id', 'DESC')
            ->limit(4)
            ->with('files')
            ->get();

        return response()->json($notices, 200);
    }


    public function getNoticeListWithPagination(Request $request)
    {

        try {
            //   $site_id=$this->getSiteId($request);

            Session::put('SITE_ID', $request->site_id);
            $site_id = Session::get('SITE_ID');

            $status = $request->status;
            $search_txt = $request->search_txt;
            $date_range = $request->date_range ? json_decode($request->date_range) : null;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';

            if (!$date_range) {
                throw new Error('Please select Date');
            }


            $date_start = $date_range->start; //.' 00:00:00';
            $date_end = $date_range->end ?? $date_start;

            $noticeList = (new Notice())
                ->where('status', $status)
                ->where('type', 'notice')
                ->whereNotNull('web_publish_time')
                ->where('web_publish_time', '<=', Carbon::now())
               
                //  ->whereDate('created_at', '>=', $date_start)
                //   ->whereDate('created_at', '<=', $date_end)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->where('doc_number', 'LIKE', $txt)
                            ->orWhereTranslationLike('notice_name', $txt);
                    });
                })->with('files')
               
                ->orderBy('pin_status', 'DESC')
                ->orderBy('web_publish_time', 'DESC')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);
            //  ->toSql();
           

            return $noticeList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getEmployeeListWithPagination(Request $request)
    {;

        try {

            $user_type = 'employee';

            $paginate = (int)$request->paginate;
            //            return $paginate;

            $employees = User::with('siteRoles')
                ->with(['latestPhoto'])
                ->with(['designation'])
                ->select('id', 'username', 'user_type', 'email', 'contact_number', 'designation_id', 'signature', 'institute_head')
                ->where('user_type', $user_type)
                ->where('status', 1)
                ->where('site_id', $request->site_id)
                ->orderBy('employee_serial', 'ASC')
                ->paginate($paginate);
            //            dd($employees);

            if (count($employees) < 1) {
                throw new Exception('No Data Found!');
            }
            //            if (count($employees) < 1) {
            //                for ($i = 1; $i <=8; $i++){
            //                    $data['data'][$i]=[
            //                        'id'=>0,
            //                        'files'=>[[
            //                            'id'=>0,
            //                            'path'=>'/image/demo_image.jpg'
            //                        ]]
            //                    ];
            //
            //                }
            //                $events = $data;
            //            }

            return response()->json($employees, 200, []);
        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }


    public function getEventListWithPagination(Request $request)
    {
        $paginate = 8;

        Session::put('SITE_ID', $request->site_id);

        try {
            $events = Event::where('status', 1)
                ->where('type', 'event')
                ->with('files')
                ->orderBy('id', 'ASC')
                ->paginate($paginate);

            if (count($events) < 1) {
                for ($i = 1; $i <= 8; $i++) {
                    $data['data'][$i] = [
                        'id' => 0,
                        'files' => [[
                            'id' => 0,
                            'path' => '/image/demo_image.jpg'
                        ]]
                    ];
                }
                $events = $data;
            }
            //    if(count($events->data)<=0){

            //        $events=[
            //            [
            //                'id'=>0,
            //                'files'=>[[
            //                    'id'=>0,
            //                    'path'=>'/image/demo_image.jpg'
            //                ]]
            //            ],
            //            [
            //                'id'=>0,
            //                'files'=>[[
            //                    'id'=>0,
            //                    'path'=>'/image/demo_image.jpg'
            //                ]]
            //            ],
            //            [
            //                'id'=>0,
            //                'files'=>[[
            //                    'id'=>0,
            //                    'path'=>'/image/demo_image.jpg'
            //                ]]
            //            ],

            //        ];



            //    }

            return response()->json($events, 200, []);
        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getVideoListWithPagination(Request $request)
    {
        $site_id = $this->getSiteId($request);

        $video_list = Video::where('status', 1)
            //  ->where('home_page_show_status', 1)
            ->orderBy('id', 'DESC')
            ->take(3)
            ->get();

        //  dd($video_list);


        $video_list->transform(function ($value) {

            //  dd($value->user->latestPhoto->name);
            //    dd($value);
            return [
                'id' => $value->id ?? null,
                'video_link' => $value->video_link ?? null,
                'description' => $value->description ?? null,
                'home_page_show_status' => $value->home_page_show_status ?? null,
                'home_page_show_main_status' => $value->home_page_show_main_status ?? null,
                'serial' => $value->serial ?? null,

            ];
        });

        if (count($video_list) > 0) {
            $video_list = $video_list;
        } else {
            $video_list = [
                [
                    'id' => null,
                    'video_link' => 'https://www.youtube.com/embed/X-TBRtlyTcU',
                    'description' => 'default',
                    'home_page_show_status' => 1,
                    'home_page_show_main_status' => 1,
                    'serial' => null,
                ],
                [
                    'id' => null,
                    'video_link' => 'https://www.youtube.com/embed/sLLwc7hYqHI',
                    'description' => 'default',
                    'home_page_show_main_status' => 1,
                    'serial' => null,
                ],

            ];
        }

        return response()->json($video_list, 200);
    }

    public function getProspectusListWithPagination(Request $request)
    {
        Session::put('SITE_ID', $request->site_id);
        try {

            $paginate = $request->paginate;
            $prospectusList = Event::where('status', 1)
                ->where('type', $request->evant_type)
                ->with('files')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $prospectusList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getSyllabusListWithPagination(Request $request)
    {
        Session::put('SITE_ID', $request->site_id);
        try {

            $paginate = $request->paginate;
            $prospectusList = Event::where('status', 1)
                ->where('type', 'syllabus')
                ->with('files')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $prospectusList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }
    public function getInstititeDocumentListWithPagination(Request $request)
    {
        Session::put('SITE_ID', $request->site_id);
        try {

            $paginate = $request->paginate;
            $prospectusList = Event::where('status', 1)
                ->where('type', 'institute-document')
                ->with('files')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $prospectusList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }


    public function getSlideItem(Request $request)
    {

        try {
            $site_id = $this->getSiteId($request);

            $site_settings = SiteWebsiteHeaderDesign::where('site_id', $site_id)->select('site_id', 'slider_limit', 'slider_show_status')->first();
            $slider_limit = $site_settings->slider_limit;


            //   $slides = [];

            $slides = (new Event())
                ->where('status', 1)
                ->where('type', 'slide')
                ->where('site_id', $site_id)
                ->with('files')
                ->limit($slider_limit)
                ->latest()
                ->get();

            $event_array = [];
            $key = 0;
            foreach ($slides as $slid) {
                $event_array[$key] = $slid;
                $event_array[$key]['slider_show_status'] = $site_settings->slider_show_status;
                $key++;
            }


            if (count($event_array) <= 0) {

                $event_array = [[
                    'id' => 0,
                    'files' => [[
                        'id' => 0,
                        'path' => '/image/demo_image.jpg'
                    ]]
                ]];
            }

            return response()->json($event_array, 200);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getEventItem(Request $request)
    {

        try {

            $site_id = $this->getSiteId($request);

            $events = [];

            $events = (new Event())
                ->where('status', 1)
                ->where('type', 'event')
                ->where('site_id', $site_id)
                ->with('files')
                ->limit(3)
                ->latest()
                ->get();

            if (count($events) <= 0) {

                $events = [
                    [
                        'id' => 0,
                        'files' => [[
                            'id' => 0,
                            'path' => '/image/demo_image.jpg'
                        ]]
                    ],
                    [
                        'id' => 0,
                        'files' => [[
                            'id' => 0,
                            'path' => '/image/demo_image.jpg'
                        ]]
                    ],
                    [
                        'id' => 0,
                        'files' => [[
                            'id' => 0,
                            'path' => '/image/demo_image.jpg'
                        ]]
                    ]

                ];
            }

            return response()->json($events, 200);
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getHeadOfAuthorityMessageList(Message $message, Request $request)
    {
        $site_id = $this->getSiteId($request);

        $message_data = $message
            ->where('status', 1)
            ->orderBy('serial', 'ASC')
            ->get();


        $message_data->transform(function ($value) {
            return [
                'id' => $value->id ?? null,
                'picture' => $value->user->latestPhoto->path ?? $value->files[0]->path ?? null,
                'full_name' => $value->user->full_name ??   $value->name ??  null,
                'designation' => $value->user->designation->name ??  $value->designation ?? null,
                'message' => $value->message  ?? null,
                'message_from' => $value->message_from  ?? null,
            ];
        });

        if (count($message_data) > 0) {
            $message_data_list = $message_data;
        } else {
            $message_data_list = [
                [
                    'id' => 0,
                    'picture' => '/images/image-not.png',
                    'full_name' => 'Sample Name',
                    'designation' => 'Sample Designation',
                    'message' => 'Sample Message',
                    'message_from' => null,
                ],
                [
                    'id' => 0,
                    'picture' => '/images/image-not.png',
                    'full_name' => 'Sample Name',
                    'designation' => 'Sample Designation',
                    'message' => 'Sample Message',
                    'message_from' => null,
                ],
                [
                    'id' => 0,
                    'picture' => '/images/image-not.png',
                    'full_name' => 'Sample Name',
                    'designation' => 'Sample Designation',
                    'message' => 'Sample Message',
                    'message_from' => null,
                ],
                [
                    'id' => 0,
                    'picture' => '/images/image-not.png',
                    'full_name' => 'Sample Name',
                    'designation' => 'Sample Designation',
                    'message' => 'Sample Message',
                    'message_from' => null,
                ],

            ];
        }

        //   dd($message_data);


        return response()->json($message_data_list, 200);
    }

    public function getVideoListForHome(Message $message, Request $request)
    {

        $site_id = $this->getSiteId($request);

        $video_list = Video::where('status', 1)
            //  ->where('home_page_show_status', 1)
            ->orderBy('id', 'DESC')
            ->take(3)
            ->get();

        //  dd($video_list);


        $video_list->transform(function ($value) {

            //  dd($value->user->latestPhoto->name);
            //    dd($value);
            return [
                'id' => $value->id ?? null,
                'video_link' => $value->video_link ?? null,
                'description' => $value->description ?? null,
                'home_page_show_status' => $value->home_page_show_status ?? null,
                'home_page_show_main_status' => $value->home_page_show_main_status ?? null,
                'serial' => $value->serial ?? null,

            ];
        });

        if (count($video_list) > 0) {
            $video_list = $video_list;
        } else {
            $video_list = [
                [
                    'id' => null,
                    'video_link' => 'https://www.youtube.com/embed/X-TBRtlyTcU',
                    'description' => 'default',
                    'home_page_show_status' => 1,
                    'home_page_show_main_status' => 1,
                    'serial' => null,
                ],
                [
                    'id' => null,
                    'video_link' => 'https://www.youtube.com/embed/sLLwc7hYqHI',
                    'description' => 'default',
                    'home_page_show_main_status' => 1,
                    'serial' => null,
                ],

            ];
        }

        return response()->json($video_list, 200);
    }


    private function getData($host)
    {

        $domain = "";
        if (isset($host) && !empty($host)) {
            $getHost = explode(".", $host);
            $domain = array_shift($getHost);
        }

        $response = [];
        $edu = ['eduworld', 'eduworlderp', 'localhost', 'artshop'];

        // in_array($domain, $number_list)

        if (in_array($domain, $edu)) {

            $response['USER_TYPE'] = 'eduworld';
            $response['ALIAS'] = 'eduworld';
            $response['ALIAS1'] = 'eduworld';
            //  $response['LOGO'] = 'edu.png';
            $response['LOGO_PATH'] = '/image/edu.png';
            $response['SITE_NAME'] = 'Edu world';

            Session::put('USER_TYPE', 'eduworld');
            Session::put('ALIAS', 'eduworld');
            Session::put('ALIAS1', 'eduworld');
            //  Session::put('LOGO', 'edu.png');
            Session::put('LOGO_PATH', '/image/edu.png');
            Session::forget('FULL_NAME');

            return $response;
        } else { //site_group or site


            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();

            // dd($site_info);
            if ($site_info) { //site
                $s_setting = $site_info->siteInfoSettings()->first();

                //video load


                //  $video_list=[
                // ['video_link'=>'https://www.youtube.com/embed/IUN664s7N-c'],
                //     ['video_link'=>'https://www.youtube.com/embed/IUN664s7N-c'],
                // ['video_link'=>'https://www.youtube.com/embed/IUN664s7N-c']
                //   ];
                // $response['home_page_video'] = $home_page_video->video_link;

                //$video_list = response()->json($video_list2, 200);

                // $lead_video_link='https://www.youtube.com/embed/IUN664s7N-c';
                // $lead_video_title='OUR CAMPUS';


                $desing_setting = SiteWebsiteHeaderDesign::where('site_id', $site_info->id)->first();
                // dd($desing_setting);


                if ($desing_setting) {
                    $design_list = $this->DesignList($desing_setting, $site_info->site_alias);
                } else {
                    $design_list = $this->AbsentDesignList($site_info->site_alias);
                }

                $response['design_list'] = $design_list;

                $response['USER_TYPE'] = 'site';
                $response['ALIAS'] = $site_info->site_alias;
                $response['ALIAS1'] = $site_info->site_alias;
                $response['LOGO_PATH'] = $site_info->site_logo;
                $response['SITE_NAME'] = $site_info->site_name;
                $response['SITE_ADDRESS'] = $site_info->address;
                $response['GOOGLE_MAP_ADDRESS'] = $site_info->google_map_address;
                $response['SITE_EMAIL'] = $site_info->site_email;
                $response['SITE_PHONE'] = $site_info->site_phone;
                $response['EIIN'] = $site_info->eiin;
                $response['COLLEGE_CODE'] = $site_info->college_code;
                $response['NU_CODE'] = $site_info->nu_code;
                $response['SITE_ID'] = $site_info->id;
                $response['ADDRESS'] = $site_info->address;
                $response['SITE_NAME_NATIVE_LANGUAGE'] = $site_info->site_name_native_language;

                $response['SITE_PHONE_ACTION'] = 'tel:' . $site_info->site_phone;
                $response['WEB_MAIL'] = '/webmail';
                $response['website_result_show_by_username'] = $site_info->website_result_show_by_username ?? false;

                $response['facebook_link'] = $site_info->facebook_link ?? false;
                $response['twitter_link'] = $site_info->twitter_link ?? false;
                $response['google_link'] = $site_info->google_link ?? false;
                $response['youtube_link'] = $site_info->youtube_link ?? false;
                $response['whatsapp_link'] = $site_info->whatsapp_link ?? false;
                $response['linkedin_link'] = $site_info->linkedin_link ?? false;


                $menus = WebsiteMenu::where('type', 'site')
                    ->where('parent_id', false)
                    ->where('type_id', $site_info->id)
                    ->where('status', true)
                    ->with('menu')
                    ->with(['children.menu' => function ($q) {
                        $q->where('is_displayable', true);
                    }])->whereHas('menu', function ($q) use ($site_info) {
                        $q->where('menu_for', 'website')
                            ->where('is_displayable', true);
                    })
                    ->orderBy('serial', 'ASC')
                    ->get();

                //  return $menus;
                //  dd($menus[0]->children);


                Session::put('SITE_ID', $site_info->id);
                $latest_about_data = AboutUs::where('status', 1)
                    ->where('type', 'aboutus')
                    ->with('files')
                    ->orderBy('id', 'DESC')
                    ->first();

                $latest_shuborno_joyonti = AboutUs::where('status', 1)
                    ->where('type', 'shuborno-joyonti')
                    ->with('files')
                    ->orderBy('id', 'DESC')
                    ->first();


                $image_src = "https://" . request()->getHost() . "/image/demo_image.jpg";

                if ($latest_about_data) {
                    $latest_about_data_list = $latest_about_data;
                } else {
                    $latest_about_data_list = [

                        'id' => 0,
                        'description' => "<p><img alt=\"\" src=\"$image_src\" style=\"height:60%; width:100%\" /></p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc,</p>",
                        'title' => 'Sample History',

                    ];
                }
                if ($latest_shuborno_joyonti) {
                    $latest_shuborno_joyonti_list = $latest_shuborno_joyonti;
                } else {
                    $latest_shuborno_joyonti_list = [

                        'id' => 0,
                        'description' => "<p><img alt=\"\" src=\"$image_src\" style=\"height:60%; width:100%\" /></p><p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem. Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc,</p>",
                        'title' => 'Sample History',

                    ];
                }

                $video_list = Video::where('status', 1)
                    ->where('home_page_show_main_status', 1)
                    ->orderBy('id', 'DESC')
                    ->take(3)
                    ->get();

                if (count($video_list) <= 0) {
                    $video_list = [
                        ['video_link' => 'https://www.youtube.com/embed/IUN664s7N-c'],
                        ['video_link' => 'https://www.youtube.com/embed/IUN664s7N-c'],
                        ['video_link' => 'https://www.youtube.com/embed/IUN664s7N-c']
                    ];
                }

                // dd($video_list);



                $lead_video = Video::where('status', 1)
                    ->where('home_page_show_status', 1)
                    ->orderBy('id', 'DESC')
                    ->first();

                $specailimage = (new Event())
                    ->where('status', 1)
                    ->where('type', 'specailimage')
                    //  ->where('site_id', $site_id)
                    ->with('files')
                    ->orderBy('id', 'DESC')
                    ->first();

                $modalscreen = (new Event())
                    ->where('status', 1)
                    ->where('type', 'modalscreen')
                    // ->where('site_id', $site_id)
                    ->with('files')
                    ->orderBy('id', 'DESC')
                    ->first();


                if ($specailimage) {
                    $response['specailimage'] = $specailimage->files[0]->path;
                } else {
                    $response['specailimage'] = "/images/image-not.png";
                }


                if ($modalscreen) {
                    $response['modalscreen'] = $modalscreen->files[0]->path;
                } else {
                    $response['modalscreen'] = "/images/image-not.png";
                }

                $response['lead_video'] = $lead_video;

                $response['video_list'] = $video_list;
                $response['webMenus'] = $menus;
                $response['about_us'] = $latest_about_data_list;
                $response['shuborno_joyonti'] = $latest_shuborno_joyonti_list;

               $visitor_count = $this->visitorCount($site_info->id);

                $response['today_visitor'] = $visitor_count[0];
                $response['weekly_visitor'] = $visitor_count[1];
                $response['monthly_visitor'] = $visitor_count[2];
                $response['total_visitor'] = $visitor_count[3];

                // $response['today_visitor'] = 0;
                // $response['weekly_visitor'] = 0;
                // $response['monthly_visitor'] = 0;
                // $response['total_visitor'] = 0;


                Session::put('SITE_ID', $site_info->id);
                Session::put('ACADEMIC_GROUP_ID', $s_setting->academic_group_id ?? 0);
                Session::put('ACADEMIC_GROUP_NAME', $s_setting->academicGroup->academic_group_name ?? 0);
                Session::put('ACADEMIC_KEY', $s_setting->academicGroup->academic_key ?? 0);

                Session::put('ALIAS', $site_info->site_alias);
                Session::put('ALIAS1', $site_info->site_alias);
                Session::put('USER_TYPE', 'site');
                Session::put('FULL_NAME', $site_info->site_name);
                // Session::put('LOGO', $site_info->site_logo);
                Session::put('LOGO_PATH', $site_info->site_logo);
            } else if ($site_group = GlobalSiteGroup::where('group_alias', $domain)->first()) { //site_group

                Session::put('SITE_GROUP_ID', $site_group->id);
                Session::put('ALIAS', $site_group->group_alias);
                Session::put('ALIAS1', $site_group->group_alias);
                Session::put('USER_TYPE', 'site_group');
                Session::put('FULL_NAME', $site_group->name);
                // Session::put('LOGO', $site_group->group_logo);
                Session::put('LOGO_PATH', 'img/site_group/logo/' . $site_group->group_logo);




                $get_acc_group = GlobalSiteGroupSetting::where('site_group_id', Session::get('SITE_GROUP_ID'))->first();
                if ($get_acc_group) {
                    $acc_gr = AcademicGroup::where('id', $get_acc_group->academic_group_id)->first();

                    Session::put('ACADEMIC_GROUP_ID', $acc_gr->id ?? 0);
                    Session::put('ACADEMIC_GROUP_NAME', $acc_gr->academic_group_name ?? 0);

                    $response['ACADEMIC_GROUP_ID'] = $acc_gr->id ?? 0;
                    $response['ACADEMIC_GROUP_NAME'] = $acc_gr->academic_group_name ?? 0;
                }


                $response['USER_TYPE'] = 'site_group';
                $response['ALIAS'] = $site_group->group_alias;
                $response['ALIAS1'] = $site_group->group_alias;
                //  $response['LOGO'] = 'edu.png';
                $response['LOGO_PATH'] = '/img/site_group/logo/' . $site_group->group_logo;
                $response['SITE_NAME'] = $site_group->name;
                $response['SITE_ADDRESS'] = $site_group->group_address;
                $response['SITE_PHONE'] = $site_group->group_phone;
                $response['SITE_EMAIL'] = $site_group->group_email;


                //// website menu
                
                    $webMenus = [
                        [
                            "id" => 5376,
                            "parent_id" => 0,
                            "menu_id" => 1346,
                            "serial" => 1,
                            "show_icon" => 0,
                            "status" => 1,
                            "type" => "site_group",
                            "type_id" => 20,
                            "user_id" => 0,
                            "created_at" => "2025-07-12 09:12:00",
                            "updated_at" => "2025-07-12 09:12:00",
                            "menu" => [
                                "id" => 1346,
                                "route_name" => "site-web-student-remote-registration-form",
                                "menu_fors" => [],
                                "menu_for" => "website",
                                "note" => null,
                                "parent_id" => 0,
                                "position" => 2019,
                                "is_displayable" => 1,
                                "is_common_access" => 0,
                                "is_logged_common_access" => 0,
                                "icon_name" => "fa fa-keyboard-o",
                                "status" => 1,
                                "created_at" => null,
                                "deleted_at" => null,
                                "menu_name" => "Reg. Form",
                                "translations" => [
                                    [
                                        "id" => 1486,
                                        "menu_id" => 1346,
                                        "menu_name" => "Reg. Form",
                                        "locale" => "en",
                                    ],
                                ],
                            ],
                            "children" => [],
                        ],
                    ];

                $response['webMenus'] = $webMenus;

                return $response;
                
            } else if ($company = GlobalCompany::where('alias', $domain)->first()) { //company

                Session::put('COMPANY_ID', $company->id);
                Session::put('ALIAS', $company->alias);
                Session::put('ALIAS1', $company->alias);
                Session::put('USER_TYPE', 'company');
                Session::put('FULL_NAME', $company->name);
                // Session::put('LOGO', $company->logo);
                Session::put('LOGO_PATH', 'img/company/' . $company->logo);

                //return true;

            }
        }

        $data =  array_merge($design_list, $response);

        return $data;
    }


    private function DesignList($desing_setting, $site_alias)
    {

        $special_image = 'mojib-sroddanjoli.jpg';

        $response['header_top_background_color_change'] = $desing_setting->header_top_background_color_change;
        $response['header_top_phone_number_show_status'] = $desing_setting->header_top_phone_number_show_status;
        $response['header_top_web_mail_show_status'] = $desing_setting->header_top_web_mail_show_status;
        $response['header_top_social_icon_show_status'] = $desing_setting->header_top_social_icon_show_status;

        $response['bangabandhu_pic_show'] = $desing_setting->bangabandhu_pic_show;
        $response['prime_minister_pic_show'] = $desing_setting->prime_minister_pic_show;
        $response['site_name_native_language_show'] = $desing_setting->site_name_native_language_show;
        $response['site_address_show'] = $desing_setting->site_address_show;
        $response['header_text_color'] = $desing_setting->header_text_color;
        $response['header_background_color'] = $desing_setting->header_background_color;
        $response['menu_text_color'] = $desing_setting->menu_text_color;
        $response['menu_background_color'] = $desing_setting->menu_background_color;
        $response['dropdown_menu_background_color'] = $desing_setting->dropdown_menu_background_color;
        $response['institute_logo_position'] = $desing_setting->institute_logo_position;
        $response['full_page_status'] = $desing_setting->full_page_status ? 'container-fluid' : 'container';



        $response['shuborno_joyonti_show_status'] = $desing_setting->shuborno_joyonti_show_status;
        $response['slider_show_status'] = $desing_setting->slider_show_status;
        $response['special_image_show_status'] = $desing_setting->special_image_show_status;
        $response['screen_modal_show_status'] = $desing_setting->screen_modal_show_status;
        $response['special_image'] = $desing_setting->special_image_show_status ? $special_image : '';


        $response['institute_template'] = $desing_setting->institute_template;
        $response['home_page_background_color'] = $desing_setting->home_page_background_color;



        $response['message_show_status'] = $desing_setting->message_show_status;
        $response['message_header_background_color'] = $desing_setting->message_header_background_color;
        $response['message_header_text_color'] = $desing_setting->message_header_text_color;
        $response['message_sub_header_text_color'] = $desing_setting->message_sub_header_text_color;

        $response['aboutus_show_status'] = $desing_setting->aboutus_show_status;
        $response['aboutus_header_background_color'] = $desing_setting->aboutus_header_background_color;
        $response['aboutus_header_text_color'] = $desing_setting->aboutus_header_text_color;
        $response['aboutus_sub_header_text_color'] = $desing_setting->aboutus_sub_header_text_color;

        $response['notice_show_status'] = $desing_setting->notice_show_status;
        $response['notice_header_background_color'] = $desing_setting->notice_header_background_color;
        $response['notice_subbox_background_color'] = $desing_setting->notice_subbox_background_color;
        $response['notice_header_text_color'] = $desing_setting->notice_header_text_color;
        $response['notice_text_color'] = $desing_setting->notice_text_color;

        $response['event_show_status'] = $desing_setting->event_show_status;
        $response['event_header_background_color'] = $desing_setting->event_header_background_color;
        $response['event_header_text_color'] = $desing_setting->event_header_text_color;
        $response['event_subheader_text_color'] = $desing_setting->event_subheader_text_color;
        $response['event_text_color'] = $desing_setting->event_text_color;

        $response['visitor_count_show_status'] = $desing_setting->visitor_count_show_status;
        $response['visitor_count_background_color'] = $desing_setting->visitor_count_background_color;
        $response['visitor_count_text_color'] = $desing_setting->visitor_count_text_color;
        $response['visitor_count_icon_color'] = $desing_setting->visitor_count_icon_color;

        $response['video_show_status'] = $desing_setting->video_show_status;


        $response['leading_video_show'] = $desing_setting->leading_video_show;
        $response['leading_video_header_background_color'] = $desing_setting->leading_video_header_background_color;
        $response['leading_video_header_text_color'] = $desing_setting->leading_video_header_text_color;

        $response['theme_background_color'] = $desing_setting->theme_background_color;
        $response['theme_text_color'] = $desing_setting->theme_text_color;
        $response['admission_button_show'] = $desing_setting->admission_button_show ?? false;
        $response['login_button_show'] = $desing_setting->login_button_show ?? false;
        $response['google_map_show'] = $desing_setting->google_map_show ?? false;
        $response['manual_student_list_show'] = $desing_setting->manual_student_list_show ?? false;

        $response['theme_language'] = $desing_setting->theme_language;
        $response['eiin_show_status'] = $desing_setting->eiin_show_status;
        $response['college_code_show_status'] = $desing_setting->college_code_show_status;
        $response['nu_code_show_status'] = $desing_setting->nu_code_show_status;

        $response['custom_button_show_status'] = $desing_setting->custom_button_show_status;
        $response['custom_button_title'] = $desing_setting->custom_button_title;
        $response['custom_button_link'] = $desing_setting->custom_button_link;

        $response['custom_button_link'] = $desing_setting->custom_button_link;

        $response['bongobondhu_corner_show_staus'] = $desing_setting->bongobondhu_corner_show_staus;
        $response['institute_info_show_status'] = $desing_setting->institute_info_show_status;
        $response['academic_info_show_status'] = $desing_setting->academic_info_show_status;
        $response['download_show_status'] = $desing_setting->download_show_status;
        $response['institute_corner_show_status'] = $desing_setting->institute_corner_show_status;
        $response['employee_message_show_status'] = $desing_setting->employee_message_show_status;
        $response['management_message_show_status'] = $desing_setting->management_message_show_status;
        $response['e_sheba_show_status'] = $desing_setting->e_sheba_show_status;
        $response['official_link_show_status'] = $desing_setting->official_link_show_status;
        $response['important_info_show_status'] = $desing_setting->important_info_show_status;
        $response['education_board_show_status'] = $desing_setting->education_board_show_status;
        $response['emergency_hotline_show_status'] = $desing_setting->emergency_hotline_show_status;


        $valu = $response;

        return $valu;
    }


    private function AbsentDesignList($site_alias)
    {
        $special_image = 'mojib-sroddanjoli.jpg';


        $response['header_top_phone_number_show_status'] = true;
        $response['header_top_web_mail_show_status'] = true;
        $response['header_top_social_icon_show_status'] = true;

        $response['full_page_status'] = 'container';
        $response['bangabandhu_pic_show'] = true;
        $response['prime_minister_pic_show'] = true;
        $response['site_name_native_language_show'] = true;
        $response['site_address_show'] = true;
        $response['header_text_color'] = '#004884';
        $response['header_background_color'] = '#ffffff';
        $response['menu_text_color'] = '#ffffff';
        $response['menu_background_color'] = '#004884';
        $response['dropdown_menu_background_color'] = '#004884';
        $response['institute_logo_position'] = 'center';


        $response['shuborno_joyonti_show_status'] = false;
        $response['slider_show_status'] = false;
        $response['special_image_show_status'] = false;
        $response['screen_modal_show_status'] = false;
        $response['institute_template'] = 'templateone';

        $response['home_page_background_color'] = '#F3F3DC';

        $response['message_show_status'] = true;
        $response['message_header_background_color'] = '#66CC9A';
        $response['message_header_text_color'] = '#FFFFFF';
        $response['message_sub_header_text_color'] = '#808080';

        $response['aboutus_show_status'] = true;
        $response['aboutus_header_background_color'] = '#B9E5F7';
        $response['aboutus_header_text_color'] = '#333333';
        $response['aboutus_sub_header_text_color'] = '#808080';

        $response['notice_show_status'] = true;
        $response['notice_header_background_color'] = '#66CC9A';
        $response['notice_subbox_background_color'] = '#97E1B5';
        $response['notice_header_text_color'] = '#FFFFFF';
        $response['notice_text_color'] = '#333333';

        $response['event_show_status'] = true;
        $response['event_header_background_color'] = '#FFFFFF';
        $response['event_header_text_color'] = '#333333';
        $response['event_subheader_text_color'] = '#808080';
        $response['event_text_color'] = '#333333';

        $response['visitor_count_show_status'] = true;
        $response['visitor_count_background_color'] = '#62A39F';
        $response['visitor_count_text_color'] = '#FFFFFF';
        $response['visitor_count_icon_color'] = '#FFFFFF';

        $response['video_show_status'] = false;


        $response['leading_video_show'] = false;
        $response['leading_video_header_background_color'] = '#62A39F';
        $response['leading_video_header_text_color'] = '#FFFFFF';

        $response['theme_background_color'] = '#4DBBDB';
        $response['theme_text_color'] = '#1E1E1E';
        $response['admission_button_show'] = false;
        $response['login_button_show'] = false;
        $response['google_map_show'] = false;
        $response['manual_student_list_show'] = false;

        $response['theme_language'] = 'en';
        $response['eiin_show_status'] = false;
        $response['college_code_show_status'] = false;
        $response['nu_code_show_status'] = false;

        $response['custom_button_show_status'] = false;
        $response['custom_button_title'] = 'Button Title';
        $response['custom_button_link'] = '#';

        $response['bongobondhu_corner_show_staus'] = true;
        $response['institute_info_show_status'] = true;
        $response['academic_info_show_status'] = true;
        $response['download_show_status'] = true;
        $response['institute_corner_show_status'] = true;
        $response['employee_message_show_status'] = true;
        $response['management_message_show_status'] = true;
        $response['e_sheba_show_status'] = true;
        $response['official_link_show_status'] = true;
        $response['important_info_show_status'] = true;
        $response['education_board_show_status'] = true;
        $response['emergency_hotline_show_status'] = true;



        return $response;
    }


    public function visitorCount($site_id)
    {


        $clientIP = request()->ip();
        $today_find = Carbon::now();
        $today = $today_find->format('Y-m-d');

        $visitor = new SiteWebSiteVisitorDetail();

        $check_today_visitor = $visitor->where('ip_address', $clientIP)
            ->where('site_id', $site_id)
            ->where('visite_date', $today)
            ->first();

        if (!$check_today_visitor) {
            $visitor->ip_address = $clientIP;
            $visitor->site_id = $site_id;
            $visitor->visite_date = $today;
            $visitor->save();
        }


        $today_visitor = $visitor->where('site_id', $site_id)
            ->where('visite_date', $today)
            ->count();

        $total_visitor = $visitor->where('site_id', $site_id)
            ->count();


        $week_first_day = $today_find->subDays($today_find->dayOfWeek + 1);

        $weekly_visitor = $visitor->where('site_id', $site_id)
            ->where('visite_date', '<=', $today)
            ->where('visite_date', '>=', $week_first_day)
            ->count();


        $month_start_date = new Carbon('first day of this month');
        $month_start_day = $month_start_date->format('Y-m-d');

        $monthly_visitor = $visitor->where('site_id', $site_id)
            ->where('visite_date', '<=', $today)
            ->where('visite_date', '>=', $month_start_day)
            ->count();


        return [$today_visitor, $weekly_visitor, $monthly_visitor, $total_visitor];
    }

    public function getClassRoomDetails(ClassRoom $classRoom, Request $request)
    {

        Session::put('SITE_ID', $request->site_id);
        Session::put('ACADEMIC_GROUP_ID', $request->acc_group_id);

        //==========department===============
        $academic_department_list = [];
        $academic_department_ids = $classRoom->where('entry_type', 'site')->pluck('academic_department_id');
        if ($academic_department_ids) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academic_department_ids)->get();
        }
        //==========class===============
        $academic_class_list = [];
        if ($request->academic_department_id) {
            $academic_class_ids = $classRoom->where('entry_type', 'site')->where('academic_department_id', $request->academic_department_id)->pluck('academic_class_id');
        } else {
            $academic_class_ids = $classRoom->where('entry_type', 'site')->pluck('academic_class_id');
        }
        //        return $academic_class_ids;

        if ($academic_class_ids) {
            $academic_class_list = AcademicClass::whereIn('id', $academic_class_ids)->get();
        }
        //=============subject===========
        $subject_list = [];
        if ($request->academic_class_id) {
            $academic_subject_ids = $classRoom->where('entry_type', 'site')->where('academic_class_id', $request->academic_class_id)->pluck('academic_subject_id');
            $subject_list = AcademicSubject::whereIn('id', $academic_subject_ids)->get();
        }
        //=============topic===========
        $topic_list = [];
        if ($request->academic_subject_id) {
            $topic_list = $classRoom->where('entry_type', 'site')->where('academic_subject_id', $request->academic_subject_id)->get();
        }

        //===========topic data list=========
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_subject_id = $request->academic_subject_id;
        $live_type_status = $request->live_type_status;
        $topic_id = $request->topic_id;
        $paginate = $request->paginate;

        $class_room = new ClassRoom();
        $class_room_list = $class_room->where('publish_date', '<=', Carbon::now())
            ->where('pause_status', 0)
            ->where('approve_status', 1)
            ->where('entry_type', 'site')
            ->when($academic_department_id, function ($q) use ($academic_department_id) {
                return $q->where('academic_department_id', $academic_department_id);
            })
            ->when($academic_class_id, function ($q) use ($academic_class_id) {
                return $q->where('academic_class_id', $academic_class_id);
            })
            ->when($academic_subject_id, function ($q) use ($academic_subject_id) {
                return $q->where('academic_subject_id', $academic_subject_id);
            })
            ->when($topic_id, function ($q) use ($topic_id) {
                return $q->where('id', $topic_id);
            })
            ->when($live_type_status, function ($q) use ($live_type_status) {
                return $q->whereHas('websiteClassRoomLink', function ($qr) use ($live_type_status) {
                    if ($live_type_status == 1) {
                        $qr->where('live_status', $live_type_status);
                    } else if ($live_type_status == 2) {
                        $qr->where('live_status', 0);
                    }
                });
            })
            ->with('academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'websiteClassRoomLink')
            ->with(['user' => function ($q) {
                $q->with('latestPhoto', 'designation');
            }])
            ->orderBy('serial_no', 'ASC')
            ->get();
        $class_room_list_final = [];
        if (count($class_room_list)) {
            $srl = 1;
            foreach ($class_room_list as $kk => $vv) {

                if ($vv->publish_to) {
                    $publish_to_ids = explode(',', $vv->publish_to);
                    foreach ($publish_to_ids as $kkk => $vvv) {
                        if ($vvv == 1) {
                            $class_room_list_final[$kk]['data'] = $vv;
                            $class_room_list_final[$kk]['srl'] = $srl;
                            $class_room_list_final[$kk]['live_video_link'] = false;
                            $srl++;
                        }
                    }
                }
            }
        }
        $classRoomListPage = new Paginator($class_room_list_final, $paginate);

        return [$academic_department_list, $academic_class_list, $subject_list, $topic_list, $classRoomListPage];
    }

    public function getEduClassRoomDetails(EduClassRoom $classRoom, Request $request)
    {
        //        return $request->acc_group_id;

        Session::put('SITE_ID', $request->site_id);
        Session::put('ACADEMIC_GROUP_ID', $request->acc_group_id);

        $site_info_setting_details = SiteInfoSetting::where('site_id', $request->site_id)->where('academic_group_id', $request->acc_group_id)->first();

        //==========department===============
        $academic_department_ids = $site_info_setting_details ? $site_info_setting_details->academic_department_ids : '';
        $academic_department_ids_array = explode(',', $academic_department_ids);
        $final_academic_department_ids = $classRoom->where('academic_group_id', $request->acc_group_id)->whereIn('academic_department_id', $academic_department_ids_array)->where('entry_type', 'edu')->pluck('academic_department_id');
        $academic_department_list = [];
        if ($final_academic_department_ids) {
            $academic_department_list = AcademicDepartment::whereIn('id', $final_academic_department_ids)->get();
        }
        //==========class===============
        $academic_class_ids = $site_info_setting_details ? $site_info_setting_details->academic_class_ids : '';
        $academic_class_ids_array = explode(',', $academic_class_ids);
        $academic_class_list = [];
        if ($request->academic_department_id) {
            $final_academic_department_ids = $classRoom->where('academic_group_id', $request->acc_group_id)->where('entry_type', 'edu')->where('academic_department_id', $request->academic_department_id)->whereIn('academic_class_id', $academic_class_ids_array)->pluck('academic_class_id');
        } else {
            $final_academic_department_ids = $classRoom->where('academic_group_id', $request->acc_group_id)->where('entry_type', 'edu')->whereIn('academic_class_id', $academic_class_ids_array)->pluck('academic_class_id');
        }
        if ($final_academic_department_ids) {
            $academic_class_list = AcademicClass::whereIn('id', $final_academic_department_ids)->get();
        }
        //=============subject===========
        $academic_subject_ids = $site_info_setting_details ? $site_info_setting_details->academic_subject_ids : '';
        $academic_subject_ids_array = explode(',', $academic_subject_ids);
        $subject_list = [];
        if ($request->academic_class_id) {
            $final_academic_subject_ids = $classRoom->where('academic_group_id', $request->acc_group_id)->where('entry_type', 'edu')->whereIn('academic_subject_id', $academic_subject_ids_array)->pluck('academic_subject_id');
            $subject_list = AcademicSubject::whereIn('id', $final_academic_subject_ids)->get();
        }
        //=============topic===========
        $topic_list = [];
        if ($request->academic_subject_id) {
            $topic_list = $classRoom->where('academic_group_id', $request->acc_group_id)->where('entry_type', 'edu')->where('academic_subject_id', $request->academic_subject_id)->get();
        }

        //===========topic data list=========
        $academic_department_id = $request->academic_department_id;
        $academic_class_id = $request->academic_class_id;
        $academic_subject_id = $request->academic_subject_id;
        $topic_id = $request->topic_id;
        $paginate = $request->paginate;

        $class_room = new EduClassRoom();
        $class_room_list = $class_room->where('academic_group_id', $request->acc_group_id)->where('publish_date', '<=', Carbon::now())
            ->where('pause_status', 0)
            ->where('approve_status', 1)
            ->where('entry_type', 'edu')
            ->when($academic_department_id, function ($q) use ($academic_department_id) {
                return $q->where('academic_department_id', $academic_department_id);
            })
            ->when($academic_class_id, function ($q) use ($academic_class_id) {
                return $q->where('academic_class_id', $academic_class_id);
            })
            ->when($academic_subject_id, function ($q) use ($academic_subject_id) {
                return $q->where('academic_subject_id', $academic_subject_id);
            })
            ->when($topic_id, function ($q) use ($topic_id) {
                return $q->where('id', $topic_id);
            })
            ->with('academicClass', 'academicSubject', 'academicDepartment', 'academicYear', 'files', 'websiteClassRoomLink')
            ->with(['user' => function ($q) {
                $q->with('latestPhoto', 'designation');
            }])
            ->orderBy('serial_no', 'ASC')
            ->get();
        $class_room_list_final = [];
        if (count($class_room_list)) {
            $srl = 1;
            foreach ($class_room_list as $kk => $vv) {

                if ($vv->publish_to) {
                    $publish_to_ids = explode(',', $vv->publish_to);
                    foreach ($publish_to_ids as $kkk => $vvv) {
                        if ($vvv == 1) {

                            $class_room_list_final[$kk]['data'] = $vv;
                            $class_room_list_final[$kk]['srl'] = $srl;
                            $srl++;
                        }
                    }
                }
            }
        }
        $classRoomListPage = new Paginator($class_room_list_final, $paginate);

        return [$academic_department_list, $academic_class_list, $subject_list, $topic_list, $classRoomListPage];
    }


    public function getCalendarList(Request $request)
    {
        //        return $request;
        $site_id = $this->getSiteId($request);

        Session::put('ACADEMIC_GROUP_ID', $request->acc_group_id);
        $monthIncrement = $request->monthIncrement;

        $eventModel = new CalenderEvent();


        $dateComponents = getdate(mktime(null, null, null, date('m') + $monthIncrement, 1, date('Y')));
        //        return $dateComponents;

        $month = $dateComponents['mon'];
        $year = $dateComponents['year'];
        $daysOfWeek = array('Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat');
        //  $daysOfWeek = array('Saturday', 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday');

        // What is the first day of the month in question?
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);

        // How many days does this month contain?
        $numberDays = date('t', $firstDayOfMonth);


        // Retrieve some information about the first day of the
        // month in question.
        $dateComponents = getdate($firstDayOfMonth);

        // What is the name of the month in question?
        $monthName = $dateComponents['month'];
        $dayOfWeek = $dateComponents['wday'];
        $currentDay = 1;

        //   dd($dayOfWeek);

        //      =====================empty column check=====================

        $totalNumberDays = $numberDays + $dayOfWeek;
        //        return $totalNumberDays;

        $dateColumnsNumbers = $totalNumberDays / 7;


        if (is_float($dateColumnsNumbers)) {

            $roundNumber = round($dateColumnsNumbers);
            $multipliedNumber = $roundNumber * 7;

            if ($multipliedNumber < $totalNumberDays) {

                $increseased_number = $roundNumber + 1;
                $undateColumnsNumbers = $increseased_number * 7 - $totalNumberDays;
            } else if ($multipliedNumber > $totalNumberDays) {

                $undateColumnsNumbers = $multipliedNumber - $totalNumberDays;
            }
        } else {
            $undateColumnsNumbers = 0;
        }


        //      ========================empty column check end===========================

        $arrayData = array();
        for ($b = 1; $b <= $dayOfWeek; $b++) {
            $arrayData[] = "";
        }

        for ($i = 1; $i <= $numberDays; $i++) {

            $currentDayRel = str_pad($i, 2, "0", STR_PAD_LEFT);
            $date = $year . '-' . $month . '-' . $currentDayRel;

            $arrayData[][$i] = CalenderEvent::where('activate_date', $date)
                ->with('academicCalendarHead')->get();
        }

        for ($c = 1; $c <= $undateColumnsNumbers; $c++) {

            $arrayData[] = "";
        }
        //  dd($arrayData);


        $finalArrayData = array();

        foreach ($arrayData as $key => $value) {
            if ($key < 7) {
                $finalArrayData['first_row'][$key] = $value;
            } elseif ($key > 6 && $key < 14) {
                $finalArrayData['second_row'][$key] = $value;
            } elseif ($key > 13 && $key < 21) {
                $finalArrayData['third_row'][$key] = $value;
            } elseif ($key > 20 && $key < 28) {
                $finalArrayData['fourth_row'][$key] = $value;
            } elseif ($key > 27 && $key < 35) {
                $finalArrayData['fifth_row'][$key] = $value;
            } elseif ($key > 34 && $key < 42) {
                $finalArrayData['sixth_row'][$key] = $value;
            }
        }

        $ac_calendar_head = AcademicCalendarHead::get();

        //        dd($finalArrayData);
        return response()->json([
            $monthIncrement,
            $year,
            $daysOfWeek,
            $eventModel,
            $dayOfWeek,
            $finalArrayData,
            $numberDays,
            $month,
            $monthName,
            $undateColumnsNumbers,
            $ac_calendar_head
        ], 200);
    }

    public function getAcademicGroupList(Request $request)
    {
        $site_id = $this->getSiteId($request);

        $acc_group_id = SiteInfoSetting::where('site_id', $site_id)->pluck('academic_group_id');
        $the_site = GlobalSiteInfo::findOrFail($site_id);
        $site_academic_group_ids = explode(',', $the_site->academic_group_ids);

        $acc_group_list = AcademicGroup::whereIn('id', $acc_group_id)->where('id',$site_academic_group_ids)->get();
        return $acc_group_list;
    }

    private function getSiteId($request)
    {

        if (empty($request->site_id)) {
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
        } else {
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }

    public function getYearlyCalendarList(Request $request)
    {
        Session::put('SITE_ID', $request->site_id);
        Session::put('ACADEMIC_GROUP_ID', $request->acc_group_id);
        $academic_year = $request->academicYear ?? null;

        $daysOfMonth = array('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31');
        $ac_calendar_head = AcademicCalendarHead::get();
        if ($academic_year == null) {
            $dateComponents = getdate();
            $year = $dateComponents['year'];
            $yr = $year;
            $year_arr = [];
            for ($i = 1; $i <= 10; $i++) {
                $year_arr[] = $yr;
                $yr -= 1;
            }
        } else {
            $year = $academic_year;

            $dateComponents = getdate();
            $yer = $dateComponents['year'];
            $yr = $yer;
            $year_arr = [];
            for ($i = 1; $i <= 10; $i++) {
                $year_arr[] = $yr;
                $yr -= 1;
            }
        }


        $data = [];

        for ($m = 1; $m <= 12; ++$m) {
            $month_name = date('F', mktime(0, 0, 0, $m, 1)); //mktime(hour,minute,second,month,day,year,is_dst)

            if ($month_name == 'January') {
                $data[0][] = 'Jan';

                $nmonth_id = date('m', strtotime('January'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));

                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[0][1] = $day_name;
            } else if ($month_name == 'February') {
                $data[1][] = 'Feb';

                $nmonth_id = date('m', strtotime('February'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 1;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[1][1] = $day_name;
            } else if ($month_name == 'March') {
                //                $data[] = 'Mar';
                $data[2][] = 'Mar';

                $nmonth_id = date('m', strtotime('March'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[2][1] = $day_name;
            } else if ($month_name == 'April') {
                //                $data[] = 'Apr';

                $data[3][] = 'Apr';

                $nmonth_id = date('m', strtotime('Apr'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[3][1] = $day_name;
            } else if ($month_name == 'May') {
                //                $data[] = 'May';

                $data[4][] = 'May';

                $nmonth_id = date('m', strtotime('May'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[4][1] = $day_name;
            } else if ($month_name == 'June') {
                //                $data[] = 'Jun';

                $data[5][] = 'Jun';

                $nmonth_id = date('m', strtotime('Jun'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[5][1] = $day_name;
            } else if ($month_name == 'July') {
                //                $data[] = 'Jul';

                $data[6][] = 'Jul';

                $nmonth_id = date('m', strtotime('Jul'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[6][1] = $day_name;
            } else if ($month_name == 'August') {
                //                $data[] = 'Aug';

                $data[7][] = 'Aug';

                $nmonth_id = date('m', strtotime('Aug'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        //                        return $day_name;
                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[7][1] = $day_name;
            } else if ($month_name == 'September') {
                //                $data[] = 'Sep';

                $data[8][] = 'Sep';

                $nmonth_id = date('m', strtotime('Sep'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[8][1] = $day_name;
            } else if ($month_name == 'October') {
                //                $data[] = 'Oct';

                $data[9][] = 'Oct';

                $nmonth_id = date('m', strtotime('Oct'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[9][1] = $day_name;
            } else if ($month_name == 'November') {
                //                $data[] = 'Nov';

                $data[10][] = 'Nov';

                $nmonth_id = date('m', strtotime('Nov'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = "";
                        $day_name[$i][2] = "";
                        $day_name[$i][3] = "";
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = "";
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[10][1] = $day_name;
            } else if ($month_name == 'December') {
                //                $data[] = 'Dec';

                $data[11][] = 'Dec';

                $nmonth_id = date('m', strtotime('Dec'));
                $date = $year . '-' . $nmonth_id . '-' . '01';

                $end = $year . '-' . $nmonth_id . '-' . date('t', strtotime($date));
                $day_name = [];
                $i = 0;
                while (strtotime($date) <= strtotime($end)) {
                    $day_num = date('d', strtotime($date));
                    $day_name[$i][] = date('D', strtotime($date));

                    $event = CalenderEvent::where('activate_date', $date)->with('academicCalendarHead')->get();

                    if (count($event) > 0) {
                        $ev = [];
                        foreach ($event as $k => $v) {
                            $ev['title'][] = $v->title;
                            $ev['title_color_id'][] = $v->subhead_color_id;
                            $ev['head_color_id'][] = $v->academicCalendarHead->color_id;
                            $ev['activate_date'][] = $v->activate_date;
                            $ev['head_name'][] = $v->academicCalendarHead->name;
                        }

                        //                        $event_details = $v;
                        $day_name[$i][1] = $ev['title'];
                        $day_name[$i][2] = $ev['title_color_id'];
                        $day_name[$i][3] = $ev['head_color_id'];
                        $day_name[$i][4] = $ev['activate_date'];
                        $day_name[$i][5] = $ev['head_name'];

                        $i += 1;
                    } else {
                        //                        $event_details = "";
                        $day_name[$i][1] = [];
                        $day_name[$i][2] = [];
                        $day_name[$i][3] = [];
                        $day_name[$i][4] = $date;
                        $day_name[$i][5] = [];
                        $i += 1;
                    }

                    $date = date("Y-m-d", strtotime("+1 day", strtotime($date)));
                }
                $data[11][1] = $day_name;
            }
        }

        return response()->json([$daysOfMonth, $ac_calendar_head, $data, $year, $year_arr], 200, [], JSON_NUMERIC_CHECK);
    }

    public function getStudentStatisticsDetails(Request $request)
    {
        $site_id = $this->getSiteId($request);

        $desing_setting = SiteWebsiteHeaderDesign::where('site_id', $site_id)->select('manual_student_list_show')->first();

        if ($desing_setting->manual_student_list_show) {
            return  $this->getManualStudentStatisticsDetails($request, $site_id);
        } else {
            return $this->getDynamicStudentStatisticsDetails($request, $site_id);
        }
    }

    private function getDynamicStudentStatisticsDetails($request, $site_id)
    {

        $data = $request->all();

        $getStudentList = $this->studentHistory->select(
            'id',
            'academic_year_id',
            'academic_version_id',
            'academic_shift_id',
            'academic_class_id',
            'academic_department_id',
            'academic_section_id',
            'academic_class_group_id',
            'academic_student_category_id',
            'academic_student_admission_type_id'
        )

            ->when(!empty('academic_version_id'), function ($query) use ($data) {
                return $query->where('academic_version_id', $data['academic_version_id']);
            })
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_group_id']), function ($query) use ($data) {
                return $query->where('academic_group_id', $data['academic_group_id']);
            })

            ->where('site_id', $site_id)
            ->where('status', 1)
            ->where('transfer_status', 0)
            ->whereHas('student')
            ->get();


        $totalStudent = count($getStudentList);

        $version_ids = $getStudentList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getStudentList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getStudentList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getStudentList->pluck('academic_section_id')->unique()->filter();



        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }



        $version_arr = array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getStudentList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = count($filtered_version_list);

            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();

            $shift_arr = array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {

                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);

                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = count($filtered_shift_list);


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();

                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);

                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = count($filtered_department_list);


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCount($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;
                    }
                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();
                    $class_array = $this->getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present);
                }

                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);
                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;
            }


            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;
        }

        return [$student_count_array, $department_present, $class_group_present, $section_present, $totalStudent];
    }
    private function getManualStudentStatisticsDetails($request, $site_id)
    {

        $data = $request->all();

        $getCounttList = GlobalStudentManualCount::when(!empty('academic_version_id'), function ($query) use ($data) {
            return $query->where('academic_version_id', $data['academic_version_id']);
        })
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_group_id']), function ($query) use ($data) {
                return $query->where('academic_group_id', $data['academic_group_id']);
            })
            ->where('site_id', $site_id)
            ->get();



        $totalStudent = $getCounttList->sum('total_number_of_studnet');

        $version_ids = $getCounttList->pluck('academic_version_id')->unique()->filter();

        $version_list = AcademicVersion::whereIn('id', $version_ids)->get();


        $check_department_ids = $getCounttList->pluck('academic_department_id')->unique()->filter();
        $check_class_group_ids = $getCounttList->pluck('academic_class_group_id')->unique()->filter();
        $check_section_ids = $getCounttList->pluck('academic_section_id')->unique()->filter();



        if (count($check_department_ids) > 0) {
            $department_present = true;
        } else {
            $department_present = false;
        }

        if (count($check_class_group_ids) > 0) {
            $class_group_present = true;
        } else {
            $class_group_present = false;
        }

        if (count($check_section_ids) > 0) {
            $section_present = true;
        } else {
            $section_present = false;
        }



        $version_arr = array();
        $student_count_array = [];
        foreach ($version_list as $keyVersion => $valueVersion) {

            $filtered_version_list = $getCounttList
                ->where('academic_version_id', $valueVersion->id);

            $version_arr['version_name'] = $valueVersion->version_name;
            $version_arr['version_student_count'] = $filtered_version_list->sum('total_number_of_studnet');

            $shift_ids = $filtered_version_list->pluck('academic_shift_id')
                ->unique()
                ->filter();

            $shiftList = AcademicShift::whereIn('id', $shift_ids)
                ->get();

            $shift_arr = array();
            $shift_array = [];
            foreach ($shiftList as $keyShift => $valueShift) {

                $filtered_shift_list = $filtered_version_list
                    ->where('academic_shift_id', $valueShift->id);

                $shift_arr['shift_name'] = $valueShift->shift_name;
                $shift_arr['shift_student_count'] = $filtered_shift_list->sum('total_number_of_studnet');


                $department_ids = $filtered_shift_list->pluck('academic_department_id')
                    ->unique()
                    ->filter();

                if (count($department_ids) > 0) {
                    $departmentList = AcademicDepartment::whereIn('id', $department_ids)->get();

                    $department_arr = array();
                    $department_array = [];
                    foreach ($departmentList as $keyDepartment => $valueDepartment) {

                        $filtered_department_list = $filtered_shift_list
                            ->where('academic_department_id', $valueDepartment->id);

                        $department_arr['department_name'] = $valueDepartment->name;
                        $department_arr['department_student_count'] = $filtered_department_list->sum('total_number_of_studnet');


                        $class_ids = $filtered_department_list->pluck('academic_class_id')
                            ->unique()
                            ->filter();

                        $classList = AcademicClass::whereIn('id', $class_ids)->get();

                        $class_array = $this->getClassGroupSectionCountForManualList($classList, $filtered_department_list, $class_group_present);

                        $department_arr['class_array'] = $class_array;

                        $department_arr['count_class_row'] = collect($class_array)->sum('count_class_row') + count($class_array);

                        $department_array[$keyDepartment] = $department_arr;
                    }
                } else {

                    $class_ids = $filtered_shift_list->pluck('academic_class_id')
                        ->unique()
                        ->filter();

                    $classList = AcademicClass::whereIn('id', $class_ids)->get();
                    $class_array = $this->getClassGroupSectionCountForManualList($classList, $filtered_shift_list, $class_group_present);
                }

                if (count($department_ids) > 0) {

                    $shift_arr['class_array'] = [];
                    $shift_arr['department_array'] = $department_array;

                    $shift_arr['shift_array_row'] = (collect($department_array)->sum('count_class_row')) + count($department_array);
                } else {
                    $shift_arr['class_array'] = $class_array;
                    $shift_arr['department_array'] = [];

                    $shift_arr['shift_array_row'] = (collect($class_array)->sum('count_class_row')) + count($class_array);
                }


                $shift_array[$keyShift] = $shift_arr;
            }


            $version_arr['version_array_row'] = (collect($shift_array)->sum('shift_array_row')) + count($shift_array);

            $version_arr['shift_array'] = $shift_array;
            $version_arr['shift_array'] = $shift_array;

            $student_count_array[$keyVersion] = $version_arr;
        }

        return [$student_count_array, $department_present, $class_group_present, $section_present, $totalStudent];
    }


    private function getClassGroupSectionCount($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = count($filtered_class_list);


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = count($filtered_class_group_list);


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = count($filtered_section_list);


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;
                }
            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = count($filtered_section_list);

                    $section_array[$keySection] = $section_arr;
                }

                //                            $class_group_arr['section_array']=$section_array;
                //                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

                //                if($class_group_present){
                //                    $class_arr['count_class_row']=count($section_array)*2;
                //                }else{
                $class_arr['count_class_row'] = count($section_array);
                //                }

            }

            $class_array[$keyClass] = $class_arr;
        }

        return $class_array;
    }

    private function getClassGroupSectionCountForManualList($classList, $filtered_shift_list, $class_group_present)
    {
        $class_arr = array();
        $class_array = [];
        foreach ($classList as $keyClass => $valueClass) {

            $filtered_class_list = $filtered_shift_list
                ->where('academic_class_id', $valueClass->id);


            $class_arr['class_name'] = $valueClass->class_name;
            $class_arr['class_student_count'] = $filtered_class_list->sum('total_number_of_studnet');


            $class_group_ids = $filtered_class_list->pluck('academic_class_group_id')
                ->unique()
                ->filter();


            if (count($class_group_ids) > 0) {

                $classGroupList = AcademicClassGroup::whereIn('id', $class_group_ids)->get();


                $class_group_arr = array();
                $class_group_array = [];
                foreach ($classGroupList as $keyClassGroup => $valueClassGroup) {

                    $filtered_class_group_list = $filtered_class_list
                        ->where('academic_class_group_id', $valueClassGroup->id);


                    $class_group_arr['group_name'] = $valueClassGroup->group_name;
                    $class_group_arr['class_group_student_count'] = $filtered_class_group_list->sum('total_number_of_studnet');


                    $section_ids = $filtered_class_group_list->pluck('academic_section_id')
                        ->unique()
                        ->filter();

                    $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                    $class_group_arr['count_class_group_row'] = count($sectionList);


                    $section_arr = array();
                    $section_array = [];
                    foreach ($sectionList as $keySection => $valueSection) {

                        $filtered_section_list = $filtered_class_group_list
                            ->where('academic_section_id', $valueSection->id);


                        $section_arr['section_name'] = $valueSection->section_name;
                        $section_arr['class_section_count'] = $filtered_section_list->sum('total_number_of_studnet');


                        $section_array[$keySection] = $section_arr;
                    }

                    $class_group_arr['section_array'] = $section_array;

                    $class_group_array[$keyClassGroup] = $class_group_arr;
                }
            } else {

                $section_ids = $filtered_class_list->pluck('academic_section_id')
                    ->unique()
                    ->filter();

                $sectionList = AcademicSection::whereIn('id', $section_ids)->get();

                $section_arr = array();
                $section_array = [];
                foreach ($sectionList as $keySection => $valueSection) {

                    $filtered_section_list = $filtered_class_list
                        ->where('academic_section_id', $valueSection->id);


                    $section_arr['section_name'] = $valueSection->section_name;
                    $section_arr['class_section_count'] = $filtered_section_list->sum('total_number_of_studnet');

                    $section_array[$keySection] = $section_arr;
                }

                //                            $class_group_arr['section_array']=$section_array;
                //                            $class_group_array[]=$class_group_arr;


            }


            if (count($class_group_ids) > 0) {
                $class_arr['class_group_array'] = $class_group_array;
                $class_arr['section_array'] = [];

                $class_arr['count_class_row'] = (collect($class_group_array)->sum('count_class_group_row')) + count($class_group_array);
            } else {
                $class_arr['section_array'] = $section_array;
                $class_arr['class_group_array'] = [];

                //                if($class_group_present){
                //                    $class_arr['count_class_row']=count($section_array)*2;
                //                }else{
                $class_arr['count_class_row'] = count($section_array);
                //                }

            }

            $class_array[$keyClass] = $class_arr;
        }

        return $class_array;
    }


    public function getStudentListWithPagination(Request $request)
    {
        //        return $request->site_id;
        //
        //        $user = User::where('site_id', $request->site_id)->get();
        //        return $user;

        try {
            $site_id = $this->getSiteId($request);

            $user_type = 'employee';

            $paginate = (int)$request->paginate ?? 20;
            //            return $paginate;

            $data = $request->all();

            // 'student.religion',
            $studentList = $this->studentHistory
                ->select(
                    'id',
                    'user_id',
                    'academic_class_id',
                    'academic_section_id',
                    'academic_department_id',
                    'academic_class_group_id',
                    'academic_session_id',
                    'compulsory_subject_ids',
                    'student_roll_number',
                    'student_roll_number_prefix',
                    'academic_shift_id',
                    'optional_subject_ids',
                    'selective_markingless_subject_ids',
                    'site_batch_detail_id'
                )
                ->with([
                    'shift',
                    'section',
                    'stClass',
                    'student.gender',
                    'student.latestPhoto',
                    'student.religion',
                    'student' => function ($query) {
                        $query->select('id', 'religion_id', 'gender_id', 'biometric_id', 'username', 'present_id_card_code');
                    }
                ])

                ->when($data['academic_version_id'], function ($query) use ($data) {
                    return $query->where('academic_version_id', $data['academic_version_id']);
                })->when($data['academic_year_id'], function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->when($data['site_batch_detail_id'], function ($query) use ($data) {
                    return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
                })
                ->when($data['academic_admission_type_id'], function ($query) use ($data) {
                    return $query->where('academic_student_admission_type_id', $data['academic_admission_type_id']);
                })
                ->when($data['academic_student_category_id'], function ($query) use ($data) {
                    return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                })
                ->where('status', $data['status'])
                ->where('site_id', $site_id)
                ->orderBy('student_roll_number', 'ASC')
                ->paginate($paginate);


            if (count($studentList) < 1) {
                throw new Error("No Student Found!");
            }



            return response()->json($studentList, 200, []);
        } catch (Exception $exception) {

            return JsonResponse::create(['message' => $exception->getMessage()], 410);
        }
    }

    public function getVersionYearShiftForWebsite(Request $request)
    {
        try {

            $site_id = $this->getSiteId($request);

            $the_site_info_setting = SiteInfoSetting::where('site_id', $site_id)->get();
            $the_site_info = GlobalSiteInfo::findOrFail($site_id);

            if (!$the_site_info_setting) {
                return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
            }

            $shift_ids = implode(',', $the_site_info_setting->pluck('shift_ids')->toArray());
            $academicShift = array_unique(explode(',', $shift_ids ?? null));
            $academicShiftList = AcademicShift::whereIn('id', $academicShift)->get();

            $academic_year_id = implode(',', $the_site_info_setting->pluck('academic_year_ids')->toArray());
            $academicYear =  array_unique(explode(',', $academic_year_id ?? null));
            $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('serial_no', 'desc')->get();

            //   dd($academicYearList);
            $academic_student_category_ids = implode(',', $the_site_info_setting->pluck('academic_student_category_ids')->toArray());
            $academicStudentCategory = array_unique(explode(',', $academic_student_category_ids ?? null));
            $academicStudentCategoryList = AcademicStudentCategory::whereIn('id', $academicStudentCategory)->get();

            $academic_admission_type_ids = implode(',', $the_site_info_setting->pluck('academic_admission_type_ids')->toArray());
            $admissionlist = array_unique(explode(',', $academic_admission_type_ids ?? null));
            $admissionlistdata = AcademicAdmissionType::whereIn('id', $admissionlist)->get();

            $academic_version_ids = implode(',', $the_site_info_setting->pluck('academic_version_ids')->toArray());
            $academicVersionIDs = array_unique(explode(',', $academic_version_ids ?? null));
            $academicVersionList = AcademicVersion::whereIn('id', $academicVersionIDs)->get();

            $academic_student_type_ids = implode(',', $the_site_info_setting->pluck('academic_student_type_ids')->toArray());
            $academicStudentTypeIDs = array_unique(explode(',', $academic_student_type_ids ?? null));
            $academicStudentTypeList = AcademicStudentType::whereIn('id', $academicStudentTypeIDs)->get();

            $academic_session_ids = implode(',', $the_site_info_setting->pluck('academic_session_ids')->toArray());
            $Sessionlistsplite = array_unique(explode(',', $academic_session_ids ?? null));
            $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            $relationList = Relation::all();

            //         return $academicVersionList;


            return [
                $academicVersionList,
                $academicYearList,
                $academicShiftList,
                $admissionlistdata,
                $academicStudentCategoryList,

            ];
        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function getVersionYearShiftBaseDepartmentClassForWebsite(Request $request)
    {

        $site_id = $this->getSiteId($request);

        $data = [];
        $data['academic_version_id'] = $request->academic_version_id == 'null' ? null : $request->academic_version_id;
        $data['academic_year_id'] = $request->academic_year_id == 'null' ? null : $request->academic_year_id;
        $data['academic_shift_id'] = $request->academic_shift_id == 'null' ? null : $request->academic_shift_id;


        if (!$data['academic_version_id'] || !$data['academic_year_id']) {
            return Response::json(['message' => 'Select Version, Year And Shift For Class List'], 411);
        }

        $academic_class_list = [];
        $academic_department_list = [];


        $SiteInfoTableData = SiteInfoSetting::where('site_id', $site_id)->select('academic_class_ids')->first();


        $academicClassIds = explode(',', $SiteInfoTableData->academic_class_ids);

        $academicDepartment = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->when($data['academic_shift_id'], function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->whereNotNull('academic_department_id')
            //            ->groupBy('academic_department_id', 'academic_class_id')
            //   ->get()
            ->pluck('academic_department_id')
            ->unique()
            ->filter()
            ->toArray();

        // dd($academicDepartment);


        if (count($academicDepartment) > 0) {
            $academic_department_list = AcademicDepartment::whereIn('id', $academicDepartment)
                ->get();
        } else {

            //test
            $plucked_class_ids = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->when($data['academic_shift_id'], function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->whereIn('academic_class_id', $academicClassIds)
                //                ->groupBy('academic_class_id')
                ->pluck('academic_class_id')
                ->unique()
                ->filter()
                ->toArray();

            if (count($plucked_class_ids) == 0) {
                return Response::json(['message' => 'No Class Found For The Year! Go: <a target="_blank" href="' . route('site-shift-class-group-section-setting-opening-page') . '">Click</a>'], 411);
            }


            $academic_class_list = AcademicClass::whereIn('id', $plucked_class_ids)
                ->orderBy('serial_no', 'ASC')
                ->get();
        }


        $countDepartment = count($academic_department_list);

        return [$academic_class_list, $academic_department_list, $countDepartment];
    }


    public function getClassGroupsSessionsByClassForWebsite(Request $request)
    {

        $site_id = $this->getSiteId($request);

        $data = $request->all();
        //  dd($data);

        $version_id  =   $data['academic_version_id'];
        $year_id     =   $data['academic_year_id'];
        $shift_id    =   $data['academic_shift_id'];
        $class_id    =   $data['academic_class_id'];
        //   $academic_department_id    =   $data['academic_department_id'];

        //  dd($data);

        if (!$data['academic_version_id'] || !$data['academic_year_id'] || !$data['academic_shift_id'] || !$data['academic_class_id']) {
            return Response::json(['message' => 'Select * Marked Field!'], 411);
        }


        $SiteInfoTableData = SiteInfoSetting::where('site_id', $site_id)
            ->select('id', 'batch_present_status')
            ->first();

        if ($SiteInfoTableData->batch_present_status) {
            $batch_list = GlobalBatchDetail::where('site_id', $site_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_year_id', $year_id)
                ->select('id', 'batch_name', 'batch_code')
                ->get();

            //   dd($class_id,$version_id,$shift_id,$year_id);


        } else {
            $batch_list = [];
        }


        $group_list = [];
        $section_list = [];

        $group_present = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_year_id', $year_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_class_id', $class_id)
            ->whereNotNull('academic_class_group_id')
            ->get();
        //        return $group_present;


        if (count($group_present) > 0) {
            $group_ids = $group_present->pluck('academic_class_group_id')->toArray();
            $group_list = AcademicClassGroup::whereIn('id', $group_ids)
                ->get();
        } else {

            $section_present = GlobalSiteShiftClassGroupSectionSetting::where('site_id', $site_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_year_id', $year_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_class_id', $class_id)
                ->first();

            $exploded_section_ids = explode(',', $section_present->academic_section_ids ?? null);

            $section_list = AcademicSection::select('id', 'section_name')
                ->whereIn('id', $exploded_section_ids)
                ->get();
        }

        $session_exist = GlobalSiteClassSessionSerialSetting::where('site_id', $site_id)->where('academic_class_id', $data['academic_class_id'])
            ->where('academic_version_id', $data['academic_version_id'])
            ->where('academic_year_id', $data['academic_year_id'])
            ->where('academic_shift_id', $data['academic_shift_id'])
            // ->when($data['academic_department_id'],function($q) use ($data){
            //      $q->where('academic_department_id', $data['academic_department_id']);
            // })
            ->first();

        if ($session_exist && $session_exist->session_present) {
            $exploded_session_list = explode(',', $session_exist->session_ids);
            $session_list = AcademicSession::whereIn('id', $exploded_session_list)->get();
        } else {
            $session_list = [];
        }

        return Response::json([$group_list, $section_list, $session_list, $batch_list]);

        //   return [$group_list, $section_list, $session_list, $batch_list];

    }

    public function getClassGroupsBaseSectionForWebsite(Request $request)
    {

        $data = $request->all();

        $version_id  =   $data['academic_version_id'];
        $year_id     =   $data['academic_year_id'];
        $shift_id    =   $data['academic_shift_id'];
        $class_id    =   $data['academic_class_id'];
        $class_group_id  =   $data['academic_class_group_id'];

        $site_id = $this->getSiteId($request);

        $groupPresentCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
            ->where('site_id', $site_id)
            //  ->where('academic_group_id', $group_id)
            ->where('academic_class_id', $class_id)
            ->where('academic_version_id', $version_id)
            ->where('academic_shift_id', $shift_id)
            ->where('academic_year_id', $year_id)
            ->whereNotNull('academic_class_group_id')
            //            ->get()
            ->count();


        $sessionPresentCheck = GlobalSiteClassSessionSerialSetting::where('academic_class_id', $class_id)
            ->where('site_id', $site_id)
            //  ->where('academic_group_id', $group_id)
            ->first();



        if ($sessionPresentCheck) {
            if ($sessionPresentCheck->session_present) {
                $SiteInfoTableData = GlobalSiteInfoSetting::select('id', 'academic_session_ids', 'batch_present_status')
                    ->where('site_id', $site_id)
                    //    ->where('academic_group_id', $group_id)
                    ->first();

                $Sessionlistsplite = explode(',', $SiteInfoTableData->academic_session_ids);
                $Sessionlist = AcademicSession::whereIn('id', $Sessionlistsplite)->get();
            } else {
                $Sessionlist = [];
            }
        } else {
            $Sessionlist = [];
        }


        if (!$groupPresentCount) {

            $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                ->where('site_id', $site_id)
                //     ->where('academic_group_id', $group_id)
                ->where('academic_class_id', $class_id)
                ->where('academic_version_id', $version_id)
                ->where('academic_shift_id', $shift_id)
                ->where('academic_year_id', $year_id)
                //                ->get()
                ->count();


            if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                return 4001;
            } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    //       ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_version_id', $version_id)
                    //                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_year_id', $year_id)
                    ->first();
            } else if ($shift_id && $class_id) {
                $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                    ->where('site_id', $site_id)
                    //      ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_year_id', $year_id)
                    ->first();
            }
        } else {
            if (!$shift_id && !$class_group_id) {
                return 4001;
            } else if ($shift_id && !$class_group_id) {
                $SiteGroup = GlobalSiteShiftClassGroupSectionSetting::select('academic_class_group_id')
                    ->where('site_id', $site_id)
                    //   ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_version_id', $version_id)
                    ->where('academic_shift_id', $shift_id)
                    ->where('academic_year_id', $year_id)
                    ->get();


                $sectionDataList = AcademicClassGroup::select('id', 'group_name')
                    ->whereIn('id', $SiteGroup)
                    ->get();


                return [2001, $sectionDataList, $Sessionlist];
            } else {
                $SiteClassBaseSectionCount = GlobalSiteShiftClassGroupSectionSetting::select('academic_shift_id')
                    ->where('site_id', $site_id)
                    //   ->where('academic_group_id', $group_id)
                    ->where('academic_class_id', $class_id)
                    ->where('academic_class_group_id', $class_group_id)
                    ->get()
                    ->count();


                if (!$shift_id && $SiteClassBaseSectionCount > 1) {
                    return 4001;
                } else if (!$shift_id && $SiteClassBaseSectionCount == 1) {
                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('site_id', $site_id)
                        //   ->where('academic_group_id', $group_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->where('academic_version_id', $version_id)
                        //                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_year_id', $year_id)
                        ->first();
                } else if ($shift_id && $class_id) {
                    $SiteClassBaseSection = GlobalSiteShiftClassGroupSectionSetting::select('academic_section_ids')
                        ->where('site_id', $site_id)
                        //      ->where('academic_group_id', $group_id)
                        ->where('academic_class_id', $class_id)
                        ->where('academic_version_id', $version_id)
                        ->where('academic_shift_id', $shift_id)
                        ->where('academic_year_id', $year_id)
                        ->where('academic_class_group_id', $class_group_id)
                        ->first();
                }
            }
        }


        $SectionData = explode(',', $SiteClassBaseSection->academic_section_ids ?? null);

        $SectionDataList = AcademicSection::select('id', 'section_name')
            ->whereIn('id', $SectionData)
            ->get();

        return Response::json([$SectionDataList, $Sessionlist]);
    }
    //


    public function getOfficeComplaint(Request $request){

        $officeComplaint=GlobalEmployee::where('site_id',$request->site_id)->where('institute_head',true)->where('status',true)->first();
       
        $data=[
            'full_name'=>$officeComplaint->full_name,
            'contact_number'=>$officeComplaint->contact_number,
            'designation'=>$officeComplaint->designation->name,
            'site_name'=>$officeComplaint->site->site_name,
            'site_address'=>$officeComplaint->site->address,
        ];

        return Response::json($data);

     
    }



}
