<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Edu\GlobalAcademicCalendar\GlobalAcademicCalendarEvent;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\Examinations\Examination;
use App\Models\Session\PaymentSession;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\GlobalSiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Payment\SitePaymentGateway;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Traits\Site\Fee\SonaliPayStudentFeeTrait;
use App\Traits\Site\Fee\StudentFeeTrait;
use App\Traits\Site\Payment\PaymentGatewayTrait;
use App\Traits\Site\Payment\StudentBkashTransactionTrait;
use App\Traits\Site\Payment\StudentNagadTransactionTrait;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use PDF;
use Session;
Use Error;




class StudentPaymentController extends ApiProjectController
{
    use StudentNagadTransactionTrait, PaymentGatewayTrait, StudentBkashTransactionTrait, SonaliPayStudentFeeTrait, StudentFeeTrait;

    private $studentHistory;
    public function __construct(GlobalStudentHistory $studentHistory)
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

        $this->studentHistory = $studentHistory;
    }


    
    public function paymentDemandSlipDetails()
    {
        try{

        $auth= Auth::user();
        $student_id = $auth->id;
        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',1)->pluck('id');
       
        $demanSlipDetails = SiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
            $query->whereIn('student_history_id', $studentHistoryIDList)
                ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
            })
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->first();

        if(!$demanSlipDetails){
            return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }
        
        $data = $this->getDemandSlipDetails($demanSlipDetails);

        if ($data){
            return $data;
        }else{
            throw new Error('There is no payable amount!');
        }
    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }
    }

    public function getStudentBankSlipPdfForApi(Request $request)
    {

        try{
      //  dd($request->all());
        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $this->authInfoSessionPut();

        $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

        $student_id = $auth->id;

        $student=Student::where('id', $student_id)->where('site_id',$site_id)->first();
        if(!$student){
            return response()->json(['message'=>'Data not found!','mode'=>'error','status'=>'410'],410);
        }

        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',1)->pluck('id');
        $demand_slip=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
            ->where('status',1)
            ->orderBy('id', 'desc')
            ->first();

        if(!$demand_slip){
            return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }

           
        $studentSlip=$this->studentSlipDetails($demand_slip->id);
       
    
        $student_info = $studentSlip['student_info'];
        $fee_data = $studentSlip['fee_data'];

      
        $title_view = 'Demand Slip';
        $slip_quantity = [1,2];

       $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf',
                compact('title_view','slip_quantity','fee_data','student_info','siteInfo'));
      
       
//            return $final_data;
        return $pdf->stream(time() . '-student-payment-bank-slip.pdf');
    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }

    private function getDemadSlipData($slipNo)
    {

        $demandSlip = $this->getDemandSlipDetails($slipNo);

        $slipNo=$demandSlip['slip_no']-100000;

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slipNo)->first();
     
        $student_details = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])->where('id', $demand_slip_details->student_history_id)->first();
        $slip_no = $slipNo;

        $user_details = GlobalUser::where('id',$demand_slip_details->created_by)->first();


        $user_name = $user_details->first_name;

         //==================Fee List=========
         $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
         $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();
         $fee_allocation_details = [];
 
         foreach ($fee_generate_list as $key => $value) {
 
             $fee_allocation_details[$key] = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])->where('id', $value->site_student_fee_fine_allocation_id)->first();
             foreach ($fee_allocation_details as $k => $v) {
 
                 if ($v->academicFeeHead->name == 'Admission') {
                     $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                     $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;
 
                 } elseif ($v->academicFeeHead->name == 'Monthly') {
                     $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                     $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;
 
                 } elseif ($v->academicFeeHead->name == 'Examination') {
                     $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                     $fee_allocation_details[$key]['fee_type_name'] = $fee_type->examination_name;
                 }
             }
 
         }

 
         $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArrayTwo(collect($fee_allocation_details));

           //==================Waiver List =========

           //$demand_slip_no = $demandSlip['slip_no'] - 100000;
     
           $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_no)->first();
         
           $student_details = StudentHistory::with(['student','stClass','accGroup','section', 'department'])
               ->where('id',$demand_slip_details->student_history_id)
               ->first();
             
           $user_details = User::where('id',$demand_slip_details->created_by)->first();
           $user_name = $user_details?$user_details->first_name:'';
   
           $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
           $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();
   
           $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
           $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();


        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){


            if($value->site_student_fee_fine_allocation_id){


                $waiver_allocation_detail= SiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }
      
        $waiver_allocation=collect($waiver_allocation_details_array);
        $waiver_allocation_details=[];
        if(count($waiver_allocation)){
            $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArrayTwo($waiver_allocation);
        }
        ///
           //================due fine=======================


           $check_paymnet_happend = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)->first();
           if($check_paymnet_happend){
               $due_fine = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
                   ->where('fee_type', 'duefine')
                   ->where('status', 1)
                   ->get();
               if(count($due_fine)>0){
                   $due_fine_check = $due_fine;
               }else{
                   $due_fine_check = SiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip_details->student_history_id)->get();
               }
           }else{
               $due_fine_check = SiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip_details->student_history_id)->get();
   
           }
   

        $site_std_fee_fine_id=[];
        $fee_due_fine=0;
        if(count($due_fine_check)){
            foreach ($due_fine_check as $key => $value){
                $fee_due_fine+= $value->fine_amount;
                $site_std_fee_fine_id[$key] = $value->id;
            }

        }else{
            $fee_due_fine = 0;
        }

        $fee_delay_fine=0;
        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();
        if($demand_slip_details->payment_from_date){
            $start_date = $demand_slip_details->payment_from_date;
            $end_date = $demand_slip_details->payment_to_date;

            $period = CarbonPeriod::create($start_date, $end_date);

            $delay_fine_test = 1;
            $delay_fine = 0;

            foreach ($period as $date) {
                $formated_date =  $date->format('Y-m-d');
                if($formated_date == $today_date){
                    $delay_fine_test = 0;
                }
            }

            if($delay_fine_test==1){
                $delay_fine = $demand_slip_details->delay_fine;
            }else{
                $delay_fine = 0;
            }

            $fee_delay_fine = $delay_fine;
        }
        $extra_fine = 0;
        $check_extra_fine = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$demand_slip_details->id)->where('fee_type', 'extrafine')->get();
        if(count($check_extra_fine)>0){
            foreach ($check_extra_fine as $kk => $vl){
                $extra_fine+=$vl->fine_amount;
            }
        }

        $total_fee_fine = $fee_delay_fine + $fee_due_fine + $extra_fine;
        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');

        $previous_paid_amount = 0;
        $payment_list_by_demand_slip = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)->get();
        if(count($payment_list_by_demand_slip)){
            foreach ($payment_list_by_demand_slip as $kk => $vv){
                $previous_paid_amount+= $vv->paid_amount;
            }
        }

        $previous_paid_amount = number_format((float)$previous_paid_amount, 2, '.', '');;
        $tot_amount =  $demand_slip_details->total_amount;


        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');
        $total_amount = $tot_amount + $total_fee_fine; //+ $demand_slip_details->previous_due-$previous_paid_amount;
        ///
      
       // $total = $demand_slip_details->total_amount;
        $total_in_word = $this->convertNumberToWord($total_amount);
        $total_with_due = $total_amount;
        
       
        return [$demand_slip_details, $student_details, $slip_no, $fee_allocation_details, $total_with_due, $user_name, 
        $total_in_word,$total_amount,$fee_allocation_details_list,$waiver_allocation_details,$demandSlip,$previous_paid_amount,$fee_delay_fine,
    $fee_due_fine,$total_fee_fine];

    }


    public function getDemadSlipForApi($slipNo = null)
    {
        try{
            
        $auth= Auth::user();
        $this->authInfoSessionPut();
        $student_id = $auth->id;
        $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',1)->pluck('id');
        // $demand_slip=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
        //     ->where('status',1)
        //     ->orderBy('id','DESC')
        //     ->first();
        $demand_slip = SiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
        $query->whereIn('student_history_id', $studentHistoryIDList)
            ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
        })
        ->where('status', 1)
        ->orderBy('id', 'desc')
        ->first();

        if(!$demand_slip){
          return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
        }
        
        $studentSlip=$this->studentSlipDetails($demand_slip->id);


        $data=[
            'fee_data'=>$studentSlip['fee_data'],
            'payment_method_list'=> $studentSlip['payment_method_list'],
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

            // $data = $this->getDemadSlipData($demand_slip);

            // $demand_slip_details=$data[0];
            // $student_details=$data[1];
            // $slip_no=$data[2];
            // $fee_allocation_details=$data[3];
            // $total_with_due=$data[4];
            // $user_name=$data[5];
            // $total_in_word=$data[6];
            // $previous_paid_amount=$data[11];
            // $total=$total_with_due;

            // $fee_delay_fine=$data[12];
            // $fee_due_fine=$data[13];
            // $total_fee_fine=$data[14];
        

            // $data=[
            //     'demand_slip_details'=>$demand_slip_details,
            //     'student_details'=>$student_details,
            //     'slip_no'=>$slip_no,
            //     'fee_allocation_details'=>$fee_allocation_details,
            //     'total_with_due'=>$total_with_due,
            //     'user_name'=>$user_name,
            //     'total'=>$total,
            //     'total_in_word'=>$total_in_word,
            //     'previous_paid_amount'=>$previous_paid_amount,
            //     'fee_delay_fine'=>$fee_delay_fine,
            //     'fee_due_fine'=>$fee_due_fine,
            //     'total_fee_fine'=>$total_fee_fine,
            //     'mode'=>'success',
            //     'status'=>'200',
            // ];

            // return response()->json($data,200);



    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }


    }

    public function getDemadSlipPdfForApi($slipNo = null)
    {
        try{
           
            $auth= Auth::user();
            $this->authInfoSessionPut();
            $student_id = $auth->id;
            $site_id = $auth->site_id;
            $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

            $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',1)->pluck('id');
            // $slipNo=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
            //     ->where('status',1)
            //     ->orderBy('id', 'desc')
            //     ->first();

             $slipNo = SiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
                $query->whereIn('student_history_id', $studentHistoryIDList)
                    ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
                })
                ->where('status', 1)
                ->orderBy('id', 'desc')
                ->first();

            if(!$slipNo){
              return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
            }


            ///////////
        $studentSlip=$this->studentSlipDetails($slipNo->id);
   
        $student_info = $studentSlip['student_info'];
        $fee_data = $studentSlip['fee_data'];
        $title_view = 'Demand Slip';
        $slip_quantity = [1,2];

        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf',
            compact('title_view','slip_quantity','fee_data','student_info','siteInfo'));
        return $pdf->stream(time() . '-demand-slip.pdf');
            ///////////
    

        //     $data = $this->getDemadSlipData($slipNo);
         
        //     $demand_slip_details=$data[0];
        //     $student_details=$data[1];
        //     $slip_no=$data[2];
        //     $fee_allocation_details=$data[3];
        //     $total_with_due=$data[4];
        //     $user_name=$data[5];
        //     $total=$data[6];
        //   //  $fee_due_fine='0.00';
        //     $title_view = 'Demand Slip';
        //     $slip_quantity = [1,2];

                
        // $pdf = PDF::loadView('default.admin.site.student-fee.report.demand-slip-pdf',
        //     compact('title_view','slip_quantity','demand_slip_details', 'student_details', 'slip_no', 'fee_allocation_details', 
        //     'total_with_due','user_name', 'total','siteInfo'));
        // return $pdf->stream(time() . '-demand-slip.pdf', 'fee_allocation_details');

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }


    }

    public function getBankSlipPdfForApi($slipNo = null)
    {
        try{

            $auth= Auth::user();
            $this->authInfoSessionPut();
            $student_id = $auth->id;

            $siteInfo= GlobalSiteInfo::where('id',$site_id)->first();

           
            $studentHistoryIDList=StudentHistory::where('user_id',$student_id)->where('status',1)->pluck('id');
            // $demand_slip=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
            //     ->where('status',1)
            //     ->orderBy('id', 'desc')
            //     ->first();

            $demand_slip = SiteStudentFeeDemandSlipDetails::where(function ($query) use ($studentHistoryIDList) {
                $query->whereIn('student_history_id', $studentHistoryIDList)
                    ->orWhereIn('due_transfer_to_promoted_student_history_id', $studentHistoryIDList);
                })
                ->where('status', 1)
                ->orderBy('id', 'desc')
                ->first();

              //  dd($demanSlipDetails);
            if(!$demand_slip){
              return response()->json(['message'=>'Slip Not found', 'status'=>'404', 'mode'=>'errors'],404); 
            }
    
            $studentSlip=$this->studentSlipDetails($demand_slip->id);
       
    
            $student_info = $studentSlip['student_info'];
            $fee_data = $studentSlip['fee_data'];
    
            $title_view = 'Demand Slip';
            $slip_quantity = [1,2];
    
           $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-bank-slip-pdf',
                    compact('title_view','slip_quantity','fee_data','student_info'));


        return $pdf->stream(time() . '-demand-slip.pdf', 'fee_allocation_details');

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }


    }

    private function feeHeadSubHeadTypeMultiStemArrayTwo($fee_allocation_details){
      //  dd($fee_allocation_details);

        //        return $fee_allocation_details;
                $head_Id=$fee_allocation_details->pluck('academic_fee_head_id')->unique();
                $fee_head_list=AcademicFeeHead::get();
          //  dd($head_Id);
                if(count($head_Id)){
                $fee_head_arr=Array();
                $fee_head_array=[];
                foreach ($head_Id as $key => $value){
        
                    $head_list=$fee_head_list->where('id',$value)->first();
                  //  dd($head_list);
        
                    $fee_head_arr['id']=$value;
                    $fee_head_arr['name']=$head_list->name;
        
        
                    $fee_head_pre_array=[];
                    foreach ($fee_allocation_details as $keys => $values){
                        if($value==$values['academic_fee_head_id']){
        
                            $fee_head_pre_array[$keys]=$values;
                        }
                    }
        
                    $fee_head_pre_array_collect=collect($fee_head_pre_array);
                    $fee_head_pre_array_collect_id= $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();
        
        
                    $fee_head_type_arr=Array();
                    $fee_head_type_array=[];
                    $sub_head_full_count=[];
                    foreach ($fee_head_pre_array_collect_id as $keyt => $valuet){
        
                        $fee_head_type_listt=$fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();
        //                return $fee_head_type_listt;
        
                        $fee_head_type_arr['fee_type_id']=$valuet;
                        $fee_head_type_arr['fee_type_name']=$fee_head_type_listt['fee_type_name'];
        
        
                        $fee_head_type_pre_array=[];
                        foreach ($fee_head_pre_array_collect as $keytt => $valuett){
        
                            if($valuet==$valuett['fee_head_type_id']){
                                $fee_head_type_pre_array[$keytt]=$valuett;
                            }
                        }
        
                        $fee_head_type_arr['fee_sub_head_count']=count($fee_head_type_pre_array);
                        $fee_head_type_arr['fee_sub_head']=$fee_head_type_pre_array;
        
                        $sub_head_full_count[$keyt]=count($fee_head_type_pre_array);
        
                        $fee_head_type_array[$keyt]=array_merge($fee_head_type_arr);
        
                    }
        
                    $fee_head_arr['head_type_base_sub_head_count']=array_sum($sub_head_full_count);
                    $fee_head_arr['head_type']=$fee_head_type_array;
        
                    $fee_head_array[$key]=array_merge($fee_head_arr);
                }
               
            }
                $fee_allocation_details_list=collect($fee_head_array);
        
                return $fee_allocation_details_list;
            }


        
    public function paymentMethodListForApi()
    {
        try{
            $auth= Auth::user();

            $this->authInfoSessionPut();

            $payment_method_keys = SitePaymentGateway::where('status',true)->pluck('academic_payment_method_key');
            $payment_method_list = AcademicOnlinePaymentMethod::whereIn('name_key', $payment_method_keys)
                ->select('id','name','name_key')
                ->get();

            $data=[
                'payment_method_list'=>$payment_method_list,
                'mode'=>'success',
                'status'=>'200',
            ];

            return response()->json($data,200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    }

    public function createOnlinePaymentRequest(Request $request){
      
        try{
                 $this->authInfoSessionPut();

                $auth= Auth::user();
                $username = Auth::user()->username;
                $user_id = Auth::user()->id;
                $site_id=Session::get('SITE_ID');
                $academic_group_id=Session::get('ACADEMIC_GROUP_ID');

                if($request->gateway_name_key == 'nagad'){
                    $this->paymentTakeByNagadTransactionID($request);
                }else if($request->name_key == 'bkash'){
                    return response()->json(['message'=>'Developing This System ', 'status'=>'403', 'mode'=>'success']); 
                }else if($request->gateway_name_key == 'surecash'){
                    return response()->json(['message'=>'Developing This System ', 'status'=>'403', 'mode'=>'success']);    
                
                }else if($request->gateway_name_key=='sonali_pay'){

                    $redirect_path="/api/student/sonali-pay-transaction-message";
                    
                    $request_data=[
                        'site_id'=>$site_id,
                        'user_id'=>$user_id,
                        'username'=>$username,
                        'request_amount'=>$request->payable_amount,
                        'redirect_path'=>$redirect_path
                    ];
            
                    $api_response = $this->studentFeeInfoForSonaliPay($request_data);

               
                    $data=[
                        'gateway_link'=>isset($api_response['RedirectToGateway'])?$api_response['RedirectToGateway']:null,
                        'message'=>$api_response['Message'],
                        'status'=>$api_response['Status'],
                        'callback_url'=>$redirect_path
                    ];

                    return response()->json($data);
                                       
                  
                }

            } catch (ValidationException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
            }catch (ModelNotFoundException $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
            } catch (Exception $exception) {
                return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
            }
        }

        public function verifyPaymentTransaction(Request $request){

          //  dd('sf');

            $this->authInfoSessionPut();

            $data=$request->all();
    
              //session check
            $currentTime = Carbon::now('Asia/Dhaka');
            $session=PaymentSession::where('user_id',auth()->id())
                ->where('end_date_time','>',$currentTime)
                ->where('token',$data['Token'])
                ->where('ip_address',request()->ip())
                ->where('status',1)
                ->orderBy('id','DESC')
                ->first();
            
            if(!$session){      
                $response=[
                    'status'=>'403',
                    'message'=>'Payment Session expired!',
                ];

                return response()->json($response,403);
            }
           
            $site_id=Session::get('SITE_ID');
            $academic_group_id=Session::get('ACADEMIC_GROUP_ID');
            $username = Auth::user()->username;
            $user_id = Auth::user()->id;
           
           $req_data=[
                'site_id'=>$site_id,
                'academic_group_id'=>$academic_group_id,
                'username'=>$username,
                'user_id'=>$user_id,
            ];
    
            if($data['Mode']=='success'){ 
                
              $res_data=$this->feePaymentAndSonaliPayTokenVerify($data,$req_data);

              $host = request()->getSchemeAndHttpHost();
              $site_voucher_link=$host.'/api/student/get-site-payment-slip/'.$res_data['InvoiceNo'];

              if($res_data['Status']=='200'){
                $response=$res_data;

                $response=[
                    'message'=>$res_data['Message'],
                    'status'=>$res_data['Status'],
                    'transaction_id'=>$res_data['TransactionId'],
                    'token'=>$res_data['Token'],
                    'invoice_no'=>$res_data['InvoiceNo'],
                    'paid_amount'=>$res_data['CustomerPaidAmount'],
                    'gateway_voucher_link'=>$res_data['SonaliVoucherLink'],
                    'site_voucher_link'=>$site_voucher_link,
                ];
                
              }else{

                $response=[
                    'message'=>$res_data['Message'],
                    'status'=>$res_data['Status'],
                ];
                $response_test=json_encode($res_data);
    
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$response_test;
                $issue->site_id=$req_data['site_id'];
                $issue->username=$req_data['username'];
                $issue->ip_address=request()->ip();
                $issue->save();
    
              }
    
            }else{
                $response=[
                    'status'=>'400',
                    'message'=>'Your transaction was unsuccessful. Please check and retry!'
                ];
    
                $response_test=json_encode($response);
    
                $issue = new IssueDetail();
                $issue->issue_type='online-transaction-failed:site-student';
                $issue->issuer_type='site';
                $issue->issue_details=$response_test;
                $issue->site_id=$req_data['site_id'];
                $issue->username=$req_data['username'];
                $issue->ip_address=request()->ip();
                $issue->save();
    
            }

             // session clear
            $session->status=0;
            $session->save();

            return response()->json($response,$response['status']);

        }


        public function getPaymentList(){

            try{

        //    dd('sfsf');
            $this->authInfoSessionPut();
            // $user=Auth::user();
            // $site_id=Session::get('SITE_ID');
            // $student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->where('site_id',$site_id)->pluck('id');
            // $slipList=GlobalSiteStudentFeeDemandSlipDetails::with('studentHistory')->whereIn('student_history_id',$student_history_ids)
            //     ->where('site_id',$site_id)
            //     ->orderBy('id','DESC')
            //     ->get();


            /////////////
            $user=Auth::user();
            $site_id=Session::get('SITE_ID');
            $pres_student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->where('site_id',$site_id)->where('status',true)->pluck('id');
            $prev_student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->where('site_id',$site_id)->where('status',false)->pluck('id');
        
            $prev_class_slip_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$prev_student_history_ids)->where('status',false)->pluck('id');

            $prev_class_slip_due_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$prev_student_history_ids)
                ->where('previous_academic_class_due_status',true)
                ->whereIn('due_transfer_to_promoted_student_history_id',$pres_student_history_ids)
                ->where('status',false)
                ->pluck('id');
        
            $class_slip_ids=GlobalSiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$pres_student_history_ids)->pluck('id');
            $all_slip_ids = $prev_class_slip_ids
                ->merge($class_slip_ids)
                ->merge($prev_class_slip_due_ids)
                ->unique()
                ->values();

            $slipList = GlobalSiteStudentFeeDemandSlipDetails::whereIn('id', $all_slip_ids)
                    ->orderBy('id', 'desc')
                    ->get();
            $student_history_ids=$pres_student_history_ids
                ->merge($class_slip_ids)
                ->merge($prev_class_slip_ids)
                ->unique()
                ->values();

            ////////
    
            $payment_list_array=[];
            $key=0;
            foreach($slipList as $slip){
                if($slip->status){
                   $slip_details=$this->getStudentFeeDetails($slip,$student_history_ids);
    
                    $payment_list_array[$key]['slip_id']=$slip->id;
                    $payment_list_array[$key]['class_name']=$slip->studentHistory->stClass->class_name;
                    $payment_list_array[$key]['payment_status']='due';
                    $payment_list_array[$key]['voucher_no']='';
                    $payment_list_array[$key]['amount']=$slip_details['total_due_amount'];
                    $payment_list_array[$key]['created_date']=$slip->created_date;
                    $payment_list_array[$key]['payment_date']='';
                    $payment_list_array[$key]['payment_time']='';
                    $payment_list_array[$key]['payment_by']='';
                    $payment_list_array[$key]['transaction_id']='';
              //      $payment_list_array[$key]['fee_details']=$slip_details;
                    $payment_list_array[$key]['payment_history_id']='';
                    $payment_list_array[$key]['bank_voucher_link']=null;
                    $payment_list_array[$key]['site_voucher_link']=null;
    
                    $key++;
                }


              
    
                $checkPaymentList=GlobalSiteStudentFeePaymentHistory::with('paymentGateway')->where('site_student_fee_demand_slip_details_id',$slip->id)->get();
                foreach($checkPaymentList as $payment){

                    $host = request()->getSchemeAndHttpHost();
                    $site_voucher_link=$host.'/api/student/get-site-payment-slip/'.$payment->voucher_no;
    
                    $api_response=json_decode($payment->sonali_pay_api_response_details,true);
    
                  
    
                //    $payment_details=$this->getStudentFeeDetails($slip);
    
                    $payment_by=$payment->paid_by?$payment->paid_by:$payment->created_by;
    
                    $payment_list_array[$key]['payment_status']='paid';
                    $payment_list_array[$key]['class_name']=$slip->studentHistory->stClass->class_name;
    
                    $payment_list_array[$key]['voucher_no']=$payment->voucher_no;
                    $payment_list_array[$key]['slip_id']=$slip->id;
                    $payment_list_array[$key]['amount']=$payment->paid_amount;
                    $payment_list_array[$key]['created_date']=$slip->created_date;
                    $payment_list_array[$key]['payment_date']=$payment->payment_date;
                    $payment_list_array[$key]['payment_time']=$payment->payment_time;
                    $payment_list_array[$key]['payment_by']=$payment_by;
                    $payment_list_array[$key]['transaction_id']=$payment->transaction_id;
                //    $payment_list_array[$key]['fee_details']=$payment_details;
                    $payment_list_array[$key]['payment_history_id']=$payment->id;
                    $payment_list_array[$key]['bank_voucher_link']=$api_response?$api_response['SonaliVoucherLink']:null;
                    $payment_list_array[$key]['site_voucher_link']=$site_voucher_link;
    
                    $key++;
                }
                    
                
            }

            $data=[
                'data'=>$payment_list_array,
                'status'=>200,
                'message'=>'success'
            ];

            return response()->json($data);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }
    
        }
    

       public function getSitePaymentSlip($voucher_no){

        try{

            $this->authInfoSessionPut();
            $slip_id=$voucher_no-100000;

        //  $site_id=Session::get('SITE_ID');
            $user=Auth::user();
            $site_id=Session::get('SITE_ID');
            $student_history_ids=GlobalStudentHistory::where('user_id',$user->id)->where('site_id',$site_id)->pluck('id');

            $demanSlipDetails=GlobalSiteStudentFeeDemandSlipDetails::with('studentHistory')->whereIn('student_history_id',$student_history_ids)
                ->where('id',$slip_id)
                ->first();

            if(!$demanSlipDetails){
                return response()->json(['message'=>'Data not found!','mode'=>'error','status'=>'410'],410);
            }

            $payment_details = $this->paymentSlipData($voucher_no);

            if($payment_details['status']!=200){
                return $payment_details['message'];
            }
    
            $payment_data=$payment_details['payment_data'];
            $student_info=$payment_details['student_info'];
    
            $report_tittle ='Student Fee Voucher';
            $report_tittle2  ='';
            $title_view='Student Fee Voucher';

            $siteInfo= GlobalSiteInfo::where('id',$site_id)
                ->select('id','web_student_fee_collection_status','show_subhead_in_payment_slip')
                ->first();
                
                $slip_key='student';
    
            $pdf = PDF::loadView('default.admin.site.student-fee.report.student-payment-voucher-pdf',
                compact('title_view','report_tittle','report_tittle2','payment_data','student_info'));
    
            return $pdf->stream(time() . '-student-payment-slip.pdf');

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

       }




    
   
}
