<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Http\Controllers\Api\ApiProjectController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicCalendarHead;
use App\Models\Edu\GlobalAcademicCalendar\GlobalAcademicCalendarEvent;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskMenu;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSetting;
use App\Models\Edu\HelpDesk\EduSiteHelpDeskSettingDetail;
use App\Models\Site\Role\SiteRole;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Session;


class StudentHelpDeskController extends ApiProjectController
{
    private $studentHistory;
    public function __construct(GlobalStudentHistory $studentHistory)
    {
        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');
        $this->studentHistory = $studentHistory;

    }

    

    public function getStudentHelpDeskList(){

        try{

        $this->authInfoSessionPut();

        $auth=Auth::user();
        $user_id=$auth->id;
      
        $roles=SiteRole::with(['users'=>function($query) use ($user_id){
            $query->where('user_id', $user_id);
        }])
        ->where('key', 'student')
        ->first();


       if(count($roles->users)>=1){
            $setting_detail_ids=EduSiteHelpDeskSettingDetail::where('menu_for', 'site')
                ->where('menu_role', 'student')
                ->pluck('edu_site_help_desk_setting_id')
                ->unique()
                ->values();
        }
       

        $setting_list=EduSiteHelpDeskSetting::whereIn('id', $setting_detail_ids)
            ->get();

        $setting_list_ids=$setting_list
            ->pluck('edu_site_help_desk_menu_id')
            ->unique();

        $menu_list=EduSiteHelpDeskMenu::with(['eduSiteHelpDeskSetting'=>function($query) use ($setting_detail_ids){
            $query->whereIn('id', $setting_detail_ids);
            $query->orderBy('serial');
        }])
            ->whereIn('id', $setting_list_ids)
            ->orderBy('menu_serial')
            ->get();

        $data=[
            'help_desk_list'=>$menu_list,
            'mode'=>'success',
            'status'=>'200',
        ];

        return response()->json($data,200);

    } catch (ValidationException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
    }catch (ModelNotFoundException $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
    } catch (Exception $exception) {
        return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
    }

    }

   
}
