<?php

namespace App\Http\Controllers\Api\StudentPanel;

use App\Forms\DataHelper;
use App\Http\Controllers\ProjectController;
use App\Models\Attendance\GlobalStudentAttendance;
use App\Models\Site\Academic\GlobalSitePeriodTypeDuration;
use App\Models\Site\Live\MeetingInvitation;
use App\Models\Site\Routine\RoutineAllocation;
use App\Models\Site\Routine\GlobalRoutineDetail;
use App\Models\Site\SiteShiftDetails;
use App\Models\Site\Student\Attendance\PeriodicAttendance;
use App\Models\Site\Student\GlobalStudentHistory;

use App\Traits\Site\EventTrait;
use App\Traits\Site\GlobalFunctionsTrait;
use App\Traits\Site\Routine\RoutineFunction;
use Carbon\Carbon;
use DateTime;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicPeriodType;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\SubjectCondition;
use App\Models\Site\SiteInfo;
use App\Models\SubjectGroupConditionSetting\GlobalSubjectGroupConditionSetting;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use PDF;
use Exception;
use Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;

class AttendanceApiController extends ProjectController
{
    use DataHelper, RoutineFunction, EventTrait;
    //RoutineFunction
    private $studentAttendance;
    private $periodTypeDuration;
    private $routineAllocation;
    private $studentHistory;
    private $routineDetail;
    private $meetingInvitation;
    private $periodicAttendance;
    private $siteShiftDetails;
    private $auth;


    public function __construct(GlobalStudentHistory $studentHistory, MeetingInvitation $meetingInvitation, GlobalStudentAttendance $studentAttendance, GlobalSitePeriodTypeDuration $periodTypeDuration,
    GlobalRoutineDetail $routineDetail, RoutineAllocation $routineAllocation, PeriodicAttendance $periodicAttendance, SiteShiftDetails $siteShiftDetails)
    {

        $this->middleware('auth:apps-api');
        $this->middleware('api.app.access');

        //$this->middleware('sitepagechecker');
        $this->periodicAttendance = $periodicAttendance;

        $this->meetingInvitation = $meetingInvitation;
        $this->studentAttendance = $studentAttendance;
        $this->periodTypeDuration = $periodTypeDuration;
        $this->routineAllocation = $routineAllocation;
        $this->studentHistory = $studentHistory;
        $this->routineDetail = $routineDetail;
        $this->siteShiftDetails = $siteShiftDetails;
        $this->auth = Auth::user();

    }



    public function getDataWiseAttendanceListForApi(Request $request)
    {
        try{

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $id = $auth->id;
           
   
           
        $date_range = json_decode($request->date_range);

        $start_date = $date_range->start ?? null;
        $end_date = $date_range->end ?? null;


        if ($date_range) {
            if (!$start_date || !$end_date) {
                throw new Error('Please Select Both Date');
            }
        }


        $paginate = $request->paginate ?? 20;

        $att_list = $this->studentAttendance
            ->whereHas('userHistory', function ($q) use ($id) {
                $q->where('user_id', $id);
            })
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->orderBy('id', 'DESC')
            ->when($date_range, function ($query) use ($start_date, $end_date) {
                return $query->whereBetween('present_date', [$start_date, $end_date]);
            })
            ->paginate($paginate);


        $att_list->getCollection()->transform(function ($value) {

            return [

                'user_id' => $value->user_id ?? 0,
                'full_name' => $value->user->full_name ?? 'n/a',
                'contact_number' => $value->user->contact_number ?? 'n/a',
                'date' => $value->present_date ?? 'n/a',
                'in_time' => $value->in_time ?? null,
                'out_time' => $value->out_time ?? null,
                'status' => $value->late_status ? 'Late' : 'Intime',
            ];
        });

       
        $data=[
            'attendance_list'=>$att_list,
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 422);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }
    }

    public function getPeriodTypeForApi()
    {
        try{
        $auth= Auth::user();
        $site_id=$auth->site_id;

        $the_site_info = SiteInfo::findOrFail($site_id);
        $academic_period_type_ids = explode(',', $the_site_info->academic_period_type_ids ?? null);
        $academicPeriodTypeList = AcademicPeriodType::whereIn('id', $academic_period_type_ids)
            ->select('id','type_name')
            ->get();

      //  return response()->json($academicPeriodTypeList, 200);
        $data=[
            'academic_period_type_list'=>$academicPeriodTypeList,
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);

        }

    }


    public function getRoutinePeriodListForApi(Request $request)
    {
        try{

        $auth= Auth::user();
        $academic_group_id=$auth->academic_group_id;
        $site_id=$auth->site_id;
        $id = $auth->id;

        Session::put('SITE_ID',$site_id);

        $student_history=GlobalStudentHistory::where('user_id', $id)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->where('status', true)
            ->orderBy('id', 'DESC')
            ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
            ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                'academic_class_group_id', 'academic_section_id', 'academic_session_id')
            ->first();

            if(!$student_history){
                return JsonResponse::create(['message' => 'Student Not Found', 'status'=>'422', 'mode'=>'errors',], 422);

            }
    

        $attDate = $request->att_date;//'2020-01-09';//;
        $history_id = $student_history->id;//'2020-01-09';//;

       // dd('$is_day_open');
        $is_day_open = $this->isTheDateOpen($attDate, $academic_group_id, $site_id);
       
        if (!$is_day_open) {
            return response()->json(['message' => date('d M Y', strtotime($attDate)) . ' is holiday!'], 422);
        }


        $date = $attDate ? $attDate : date('Y-m-d', time());//'2019-05-09';
        $day = date('l', strtotime($date));

        $get_period_type_duration = $this->periodTypeDuration
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->where('start_date', '<=', $date)
            ->where('end_date', '>=', $date)
            ->first();
        

        $period_id = ($get_period_type_duration->academic_period_type_id ?? null);
        if (!$period_id) {
            return response()->json(['message' => 'No Period Type Duration Found','status'=>'422', 'mode'=>'errors',], 422);
        }

        $history = $this->studentHistory
            ->with('subjects')
            ->find($history_id);

        $all_sub_ids = $history->subjects()->pluck('academic_subject_id');

        $route_details = $this->routineDetail
            /* ->whereHas('allocation', function ($q) use ($all_sub_ids, $date) {
                 $q->whereIn('subject_id', $all_sub_ids)
                     ->where('status', true)
                     ->orWhere(function ($q1) use ($date, $all_sub_ids) {
                         $q1->orWhereHas('swapCancel', function ($q) use ($date, $all_sub_ids) {
                             $q->where('swap_cancel_date', $date)
                                 ->whereIn('subject_id', $all_sub_ids);
                         });
                     });
             })*/
            ->where(function ($q1) use ($all_sub_ids, $date) {
                $q1->whereHas('allocation', function ($q) use ($all_sub_ids, $date) {
                    $q->whereIn('subject_id', $all_sub_ids)
                        ->where('status', true);
                });

            })
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->where('weekday', $day)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->where('status', true)
            ->with(['allocation' => function ($q) use ($all_sub_ids, $date) {
                $q->where('status', true)
                    ->with(['liveMeeting' => function ($q) use ($date) {
                        $q->where('join_date', $date);
                    }]);
            }, 'allocation.swapCancel' => function ($q) use ($date) {
                $q->where('swap_cancel_date', $date);
            }/*,
                 'allocation.liveMeeting' => function ($q) use ($date) {
                     $q->where('join_date', $date);
                 }*/, 'allocation.liveMeeting.meeting', 'class', 'section'])
            ->where('academic_period_type_id', $period_id)
            ->where('academic_version_id', $history->academic_version_id)
            ->where('academic_year_id', $history->academic_year_id)
            ->where('academic_shift_id', $history->academic_shift_id)
            ->where('academic_class_id', $history->academic_class_id)
            ->when($history->academic_department_id, function ($query) use ($history) {
                return $query->where('academic_department_id', $history->academic_department_id);
            })->when($history->academic_section_id, function ($query) use ($history) {
                return $query->where('academic_section_id', $history->academic_section_id);
            })->when($history->academic_class_group_id, function ($query) use ($history) {
                return $query->where('academic_class_group_id', $history->academic_class_group_id);
            })->when($history->academic_session_id, function ($query) use ($history) {
                return $query->where('academic_session_id', $history->academic_session_id);
            })->orderBy('start_time', 'ASC')
            ->get();


        $allocation_lists = [];

        foreach ($route_details as $k => $detail) {

            $last_ind = (count($route_details) - 1);

            $allocation_lists[$k]['id'] = $detail->allocation->id ?? '';
            $allocation_lists[$k]['first_last'] = ($k == 0 ? 'first' : null) ?? ($k == $last_ind ? 'last' : null);
            $allocation_lists[$k]['details'] = (addOrdinalNumberSuffix($k + 1)) . ' (' . ($detail->class->class_name ?? '') . ' ' . ($detail->section->section_name ?? '') . ')';
            $allocation_lists[$k]['start_time'] = $detail->start_time ?? '';
            $allocation_lists[$k]['end_time'] = $detail->end_time ?? '';
            $allocation_lists[$k]['swapCancel'] = $detail->allocation->swapCancel ?? null;
            $allocation_lists[$k]['subject_name'] = $detail->allocation->swapCancel->subject_name_ex ??  $detail->allocation->subject_name_ex ?? '';
            $allocation_lists[$k]['employee_name'] = $detail->allocation->swapCancel->employee_name_ex  ?? $detail->allocation->employee_name_ex  ?? '';

            $allocation_lists[$k]['invitation_id'] = $detail->allocation->liveMeeting->id ?? 0;
            $allocation_lists[$k]['live_join_link'] = ($detail->allocation->liveMeeting->status ?? null) ? ($detail->allocation->liveMeeting->meeting->join_url ?? null) : null;

        }



        if (count($allocation_lists) < 1) {
            return response()->json(['message' => 'No Routine Is Assigned For You on ' . $day, 'status'=>'422', 'mode'=>'errors',], 422);
        }

        $data=[
            'allocation_lists'=>$allocation_lists,
            'mode'=>'success',
            'status'=>'200',
        ];
        
        return response()->json($data, 200);

        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }



    public function getRoutinePdfApi(Request $request)
    {
         
        try {

            $auth= Auth::user();
            $academic_group_id=$auth->academic_group_id;
            $site_id=$auth->site_id;
            $id = $auth->id;
            Session::put('SITE_ID',$site_id);

            $student_history=GlobalStudentHistory::where('user_id', $id)
            ->where('academic_group_id', $academic_group_id)
            ->where('site_id', $site_id)
            ->where('status', true)
            ->orderBy('id', 'DESC')
            ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
            // ->select('id', 'user_id', 'student_roll_number', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
            //     'academic_class_group_id', 'academic_section_id', 'academic_session_id')
            ->first();
            
           

            if(!$student_history){
                return JsonResponse::create(['message' => 'Student Not Found', 'status'=>'411', 'mode'=>'errors',], 411);

            }
          //  dd($student_history);

          //  $his_id = $request->history_id;
            $academic_period_type_id = $request->academic_period_type_id;


            if (!$academic_period_type_id) {
                return " Period type not found!";
            }
           // $student_history = $this->studentHistory->find($his_id);

            if (!$student_history) {
                return "The Student History Not Found!";
            }

            $data = [];
            $data['academic_version_id'] = $student_history->academic_version_id == 'null' ? null : $student_history->academic_version_id;
            $data['academic_year_id'] = $student_history->academic_year_id == 'null' ? null : $student_history->academic_year_id;
            $data['academic_shift_id'] = $student_history->academic_shift_id == 'null' ? null : $student_history->academic_shift_id;
            $data['academic_department_id'] = $student_history->academic_department_id == 'null' ? null : $student_history->academic_department_id;
            $data['academic_class_id'] = $student_history->academic_class_id == 'null' ? null : $student_history->academic_class_id;
            $data['academic_section_id'] = $student_history->academic_section_id == 'null' ? null : $student_history->academic_section_id;
            $data['academic_class_group_id'] = $student_history->academic_class_group_id == 'null' ? null : $student_history->academic_class_group_id;
            $data['academic_session_id'] = $student_history->academic_session_id == 'null' ? null : $student_history->academic_session_id;
            $data['academic_period_type_id'] = $academic_period_type_id ?? 0;
   
            $all_sub_ids = $this->studentSubjectIds($student_history);
            
           

            $getRoutineDetails = $this->routineDetail
                ->with(['routineAllocations' => function ($q) use ($all_sub_ids) {
                    $q->whereIn('subject_id', $all_sub_ids)
                        ->where('status', true);
                }])->whereHas('routineAllocations', function ($q) use ($all_sub_ids) {
                    $q->whereIn('subject_id', $all_sub_ids)
                        ->where('status', true);
                })
                ->where('academic_group_id', $academic_group_id)
                ->where('site_id', $site_id)
                ->where('academic_version_id', $data['academic_version_id'])
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_shift_id', $data['academic_shift_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('site_id', $site_id)
                ->where('academic_group_id', $academic_group_id)
                ->where('academic_period_type_id', $data['academic_period_type_id'])
                ->when($data['academic_department_id'], function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })->when($data['academic_section_id'], function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })->when($data['academic_class_group_id'], function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })->when($data['academic_session_id'], function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->orderBy('start_time', 'ASC')
                ->where('status', true)
                ->get();
                
              

            if (count($getRoutineDetails) < 1) {
                return "No Routine Found!";
            }

            $week_array = array();
            $max_col_count = 0;

            foreach ($this->getWeekDay() as $k => $weekDay) {

                $week_array[$weekDay->weekday_name] = $getRoutineDetails->where('weekday', $weekDay->weekday_key) ?? [];
                if (count($week_array[$weekDay->weekday_name]) > $max_col_count) {
                    $max_col_count = count($week_array[$weekDay->weekday_name]);
                }
            }

            $headingList = $getRoutineDetails->where('weekday', $getRoutineDetails[0]->weekday) ?? [];//$weekDays[0] ->0 index means first day of the week
            $report_tittle2 = "<b>Routine For:</b>" . $student_history->student->full_name;
            $report_tittle = $this->reportTitle($getRoutineDetails[0]);

            $br_col[] = -1;
   
           
            $pdf = PDF::loadView('default.student.routine.routine-report', compact('week_array', 'headingList', 'max_col_count', 'report_tittle', 'br_col', 'report_tittle2'));
        
            return $pdf->stream(time() . '-routine.pdf');


        } catch (ValidationException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors','errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (ModelNotFoundException $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'422', 'mode'=>'errors',], 410);
        } catch (Exception $exception) {
            return JsonResponse::create(['message' => $exception->getMessage(), 'status'=>'500','mode'=>'errors'],500);
        }

    }


    public function studentSubjectIds($student_his)
    {

        $site_id = $student_his->site_id;

        $academic_exam_condition_ids = AcademicSubjectClassExamCondition::whereIn('name_key', ['onlyforexam', 'forclassandexam'])
            ->pluck('id');


        $subjectList = GlobalSubjectGroupConditionSetting::where('academic_class_id', $student_his->academic_class_id)
            ->where('academic_year_id', $student_his->academic_year_id)
            ->where('site_id', $site_id)
            ->where('academic_group_id', $student_his->academic_group_id)
            ->when(!empty($student_his->academic_department_id), function ($query) use ($student_his) {
                return $query->where('academic_department_id', $student_his->academic_department_id);
            })
            ->whereIn('academic_subject_class_exam_condition_id', $academic_exam_condition_ids)
            ->where('status', true)
            ->orderBy('subject_position')
            ->get();
            
          

        //====Religion Subject
        $religion_subject_list = $subjectList->where('academic_subject_id', $student_his->religion_subject_id)
            ->values();



      //====General Subject
        $general_subject_ids = [];
        $subjectCondition = SubjectCondition::where('condition_key', 'general')->first();

        foreach ($subjectList as $key => $value) {
            $academicSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectCondition->id, $academicSubjectConditionIds)) {
                $general_subject_ids[$key] = $value->academic_subject_id;
            }
        }




        $general_subject_list = $subjectList->whereIn('academic_subject_id', $general_subject_ids)
            ->values();

        //====Compulsory Subject
        $subjectCompulsoryCondition = SubjectCondition::where('condition_key', 'compulsory')->first();
        $compulsory_subject_ids = [];
        foreach ($subjectList as $key => $value) {

            $academicCompulsorySubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectCompulsoryCondition->id, $academicCompulsorySubjectConditionIds)) {
                $compulsory_subject_ids[$key] = $value->academic_subject_id;
            }
        }
        
       // dd($student_his->compulsory_subject_ids);
        


        $student_selective_compulsory_subject_ids = $student_his->compulsory_subject_ids[1] !=null ? $student_his->compulsory_subject_ids[1] : [];
     //   dd($student_selective_compulsory_subject_ids);

        if (count($student_selective_compulsory_subject_ids) > 0) {
            $compulsory_subject_final_ids = collect(array_merge($compulsory_subject_ids,
                $student_selective_compulsory_subject_ids))->unique();
        } else {
            $compulsory_subject_final_ids = $compulsory_subject_ids;
        }
        $compulsory_subject_list = $subjectList->whereIn('academic_subject_id', $compulsory_subject_final_ids)
            ->values();


  

        //====Optional Subject
        $optional_subject_ids = [];
        $subjectOptionalCondition = SubjectCondition::where('condition_key', 'optional')->first();

        foreach ($subjectList as $key => $value) {
            $academicOptionalSubjectConditionIds = explode(',', $value->academic_subject_condition_ids);
            if (in_array($subjectOptionalCondition->id, $academicOptionalSubjectConditionIds)) {
                $optional_subject_ids[$key] = $value->academic_subject_id;
            }
        }

        $student_selective_optional_subject_ids = ($student_his->optional_subject_ids)[1];
        $optional_subject_list = $subjectList->whereIn('academic_subject_id', $student_selective_optional_subject_ids)
            ->whereIn('academic_subject_id', $optional_subject_ids)
            ->values();
            
            


        $gen = $general_subject_list->pluck('academic_subject_id')->toArray();
        $rel = $religion_subject_list->pluck('academic_subject_id')->toArray();
        $com = $compulsory_subject_list->pluck('academic_subject_id')->toArray();
        $opt = $optional_subject_list->pluck('academic_subject_id')->toArray();

        $gen_com = array_merge($gen, $rel);
        $rel_com = array_merge($gen_com, $com);
        $final_ids = array_merge($rel_com, $opt);




        return $final_ids;
    }

    public function reportTitle($data)
    {

        $report_tittle = "<b>Year: </b>" . ($data->academicYear->year_name ?? '');
        $report_tittle .= " <b>Shift: </b>" . ($data->academicShift->shift_name ?? '');
        $report_tittle .= "  <b> Period Type: </b>" . ($data->academicPeriodType->type_name ?? '');

        $report_tittle .= "<br>";
        if ($data->dept) {
            $report_tittle .= "<b> Dept: </b>" . $data->dept->name;
        }

        if ($data->academicClass) {
            $report_tittle .= "  <b> Class: </b>" . ($data->academicClass->class_name ?? '');
        }

        if ($data->classGroup) {
            $report_tittle .= "<b> Group: </b>" . ($data->classGroup->group_name ?? '');
        }

        if ($data->academicSection) {
            $report_tittle .= "<b> Section: </b>" . ($data->academicSection->section_name ?? '');
        }

        if ($data->academicSession) {
            $report_tittle .= "<b> Session: </b>" . ($data->academicSession->session_name ?? '');
        }

        return $report_tittle;
    }

}
