<?php

namespace App\Http\Controllers\Api\Site\Web\Setting;

use App\Models\Image\Photo;
use App\Models\Site\Web\AboutUs\AboutUs;

use App\Models\Site\Web\Video\Video;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use Illuminate\Support\Facades\Input;
use Image;
use Response;
use Storage;
use File;
use Exception;

class AboutUsController extends Controller
{
    private $aboutUs;

    public function __construct(AboutUs $aboutUs)
    {
        $this->middleware('auth:api');
        $this->middleware('api.access');
        $this->middleware('sitepagechecker2');

        // $this->middleware('auth');
       //  $this->middleware('sitepagechecker');
        $this->aboutUs = $aboutUs;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }


    public function getAboutListWithPagination(Request $request)
    {

        try {
            $status = $request->status;
            $search_txt = $request->search_txt;
            $paginate = $request->paginate ?? 20;
            $txt = '%' . $search_txt . '%';


//\Log::info($this->aboutUs->toSql());


            $aboutList = $this->aboutUs
                ->where('status', $status)
                ->when($search_txt, function ($q) use ($txt) {
                    return $q->where(function ($query) use ($txt) {
                        $query->whereTranslationLike('title', $txt)
                            ->orWhereTranslationLike('description', $txt);
                    });
                })->with('files')
                ->orderBy('id', 'DESC')
                ->paginate($paginate);

            return $aboutList;
        } catch (Exception $exception) {
            throw new Error($exception->getMessage());
        }
    }

    public function getAboutDetails($id)
    {
        try {
            $about = $this->aboutUs
                ->with('files')
                ->findOrFail($id);

            return response()->json($about, 200);

        } catch (Exception $ex) {
            return Response::json([$ex->getMessage()], 405);
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(AboutUs $aboutUs, Request $request)
    {
      //  return $request;

        $this->validate($request, [
            'type' => 'required',
            'title' => 'required',
            'description' => 'required'
        ]);

        $files = range(1, $request->length);
        $file_path = null;

        $user_id = Auth::user()->id;


        $aboutUs->type = $request->type;
        $aboutUs->title = $request->title;
        $aboutUs->description = $request->description;
        $aboutUs->created_by = request()->user()->id;
        $aboutUs->status = $request->status;
        $aboutUs->site_id = Auth::user()->site_id;
        $aboutUs->save();


        if ($request->length) {
            foreach ($files as $k => $val) {
                $file = Input::file('files' . $k);
                $file_name = $aboutUs->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                Storage::disk('uploads')->put($file_name, File::get($file));
                $file_path = '/uploads/files/' . $file_name;
                $file = Input::file('files' . $k);
                $file_type = $file->getClientMimeType();

                if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                    Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                        $constraint->aspectRatio();
                    })->save('uploads/files/' . $file_name);

                } else {
                    Storage::disk('uploads')->put($file_name, File::get($file));
                }

                $aboutUs->files()->create([
                    'user_id' => $user_id,
                    'path' => $file_path,
                    'name' => $file->getClientOriginalName(),
                ]);
            }
        }


        return response()->json(['message' => 'Successfully Saved!', 'mode' => 'save'], 200);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }


    public function update(Request $request)
    {
        //return $request;

//        \Log::info($request);

        // try {
        $this->validate($request, [
            'type' => 'required',
            'title' => 'required',
            'description' => 'required'
        ]);



        $files = range(1, $request->length);
        $file_path = null;
        $deletes = $request->deletes ? explode(',', $request->deletes) : [];
        $user_id = Auth::user()->id;


        $about = $this->aboutUs->findOrFail($request->id);

        foreach ($about->ownFields as $k => $ownField) {
            if ($request->{$ownField}) {
                $about->{$ownField} = $request->{$ownField};
            }
        }
        $about->status = $request->status;
        $about->save();


        if ($request->length) {
            foreach ($files as $k => $val) {

                $file = Input::file('files' . $k);
                $file_type = $file->getClientMimeType();

                $file_name = $about->site_id . '/' . uniqid() . '.' . $file->getClientOriginalExtension();
                $file_path = '/uploads/files/' . $file_name;

                if (in_array($file_type, ['image/png', 'image/gif', 'image/jpeg', 'image/png'])) {
                    Image::make($file->getRealPath())->resize(700, null, function ($constraint) {
                        $constraint->aspectRatio();
                    })->save('uploads/files/' . $file_name);

                } else {
                    Storage::disk('uploads')->put($file_name, File::get($file));
                }

                $this->deleteFiles($about);


                $about->files()->create([
                    'user_id' => Auth::user()->id,
                    'path' => $file_path,
                    'name' => $file->getClientOriginalName(),
                ]);
            }
        }

        if (count($deletes)) {
            foreach ($deletes as $k => $id) {
                $the_photo = Photo::where('id', $id)->first();
                $fssf[$k] = $the_photo;
                if ($the_photo) {
                    $image_path = public_path($the_photo->path);
                    if (File::exists($image_path)) {
                        unlink($image_path);
                    }
                }
            }
        }
        return response()->json(['message' => ' Successfully Updated!'], 200);

    }

    private function deleteFiles($about)
    {


        foreach ($about->files as $k => $file) {
            $the_photo = Photo::where('id', $file->id)->first();
            $image_path = public_path($the_photo->path);
            if (File::exists($image_path)) {
                unlink($image_path);
            }
            $the_photo->delete();
        }
    }

    public function delete($id)
    {
        try {

            $about = $this->aboutUs->findOrFail($id);
            $about->delete();
            $about->deleteTranslations();
            $this->deleteFiles($about);

            return Response::json(['message' => 'Successfully Deleted!'], 200);


        } catch (ModelNotFoundException $ex) {
            return Response::json(['message' => 'The Notice Not Found!'], 405);

        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }



}
