<?php

namespace App\Http\Controllers\Api\Payment;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Payment\GlobalSitePaymentGateway;
use App\Traits\Site\Fee\StudentNCCBankTransactionTrait;
use Response;
use Auth;
use DB;
use Exception;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;


class NCCBankStudentPaymentApiController extends Controller
{

    use StudentNCCBankTransactionTrait;


    public function acceptPaymentInfoInNccBank(Request $request){

        $userId     =   $request->userId;
        $password   =   $request->password;
        $siteId        =  $request->iid;
        $invoiceNo  =   $request->invoiceNo;
        $trId       =   $request->trId;
        $status     =   $request->status;
       // $date_time  =   $request->date_time;
        $tr_amount  =   $request->tr_amount;
        $cr_amount  =   $request->cr_amount;
        $source_of_fund = $request->source_of_fund;
        $operation = $request->operation;
   
         $date_time = Carbon::createFromFormat('d/m/Y H:i A', $request['date_time'])->format('Y-m-d H:i:s');

      
        // $payment_time = Carbon::createFromFormat('d/m/Y H:i A', $request['date_time'])->format('H:i');
       
       // dd($date_time);

       $n_request=[
         'userId'=>$userId,
         'password'=>$password,
         'siteId'=>$siteId,
         'invoiceNo'=>$invoiceNo,
         'trId'=>$trId,
         'status'=>$status,
         'date_time'=>$date_time,
         'tr_amount'=>$tr_amount,
         'cr_amount'=>$cr_amount,
         'source_of_fund'=>$source_of_fund,
       ];

     

        DB::beginTransaction();
       try {

          if($source_of_fund != 'NCC_ALWAYS'){
            return Response::json(['responseCode'=>'90','responseMsg'=>'Source of fund not match'],401);
          }

          if($tr_amount < $cr_amount){
            return Response::json(['responseCode'=>'90','responseMsg'=>'Transection amount not valid!'],401);
          }
            if($userId && $password && $invoiceNo && $trId && $status && $date_time && $tr_amount
            && $cr_amount){

                $response_message= $this->postingPaymentInfoForStudent($n_request);
          // dd($response_message['status']);
              return $response_message;
              // return Response::json(['responseCode'=>$response_message['status'],'responseMsg'=>$response_message['message']],401);


            }else{
              
              return Response::json(['responseCode'=>'90','responseMsg'=>'Field Missing'],401);
            }

         } catch (Exception $exception) {
               DB::rollBack();
               return Response::json(['responseCode'=>'90', 'responseMsg' => $exception->getMessage()], 410);
         }
      }
    
    
    public function getFeeInfoForNccBank(Request $request){

        $now = Carbon::now();
        $dateTime=$now->format('d/m/Y h:i A');

         try {
             $userId = $request->userId;
             $password = $request->password;
             $operation = $request->operation;
             $referenceId = $request->referenceId;
             $random = $request->random;
             $siteId = $request->iid;

            $cellfinRequest=[
               'userId'=>$userId,
               'password'=>$password,
               'siteId'=>$siteId,
               'operation'=>$operation,
               'referenceId'=>$referenceId,
               'random'=>$random,
            ];

           
            
     //   if($userId && $password && $operation && $referenceId && $random && $iid){
           // dd($siteId);
                $payment_gateway=GlobalSitePaymentGateway::where('site_id',$siteId)->first();
                if($payment_gateway){
                  $response_message= $this->getStudentFeeInfo($cellfinRequest,$payment_gateway->id);
               
                   return $response_message;

                  }else{
                    return $this->failResponseForGetStudentInfo($dateTime,'Payment Gateway Not Found');
                  }
            
            }catch (Exception $exception) {
               DB::rollBack();
               return $this->failResponseForGetStudentInfo($dateTime, $exception->getMessage());

            }    
               
      }


        
    }

