<?php

namespace App\Http\Controllers\Api;

use App\Forms\DataHelper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Site\Employee\Employee;
use App\Models\Site\GlobalSiteShiftClassGroupSectionSetting;
use App\Models\Site\Result\GlobalSiteResultSystemSetting;
use App\Models\Site\Result\GlobalSiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\SiteInfo\GlobalSiteInfo;
use App\Models\Site\Student\GlobalStudentHistory;
use App\Models\SiteGroup\ExamResult\GlobalSiteGroupResultPermission;
use App\Models\User\GlobalUser;
use App\Traits\Site\Result\ExamResultTrait;
use Carbon\Carbon;
use Exception;
use Response;
use Session;
use PDF;

class AcademicResultApiController extends Controller
{
    use DataHelper, ExamResultTrait;
    private $division;

    
    private $SiteShiftClassGroupSectionSetting;

    public function __construct(GlobalSiteShiftClassGroupSectionSetting $SiteShiftClassGroupSectionSetting)
    {
        $this->SiteShiftClassGroupSectionSetting = $SiteShiftClassGroupSectionSetting;
        $this->middleware('api.access');
      //  $this->middleware('api.app.access');
      //  $this->middleware('site_id.check');
    }

    
    private function getSiteId($request){
         
        if(empty($request->site_id)){
            $domain = "";
            if (isset($_SERVER['HTTP_HOST']) && !empty($_SERVER['HTTP_HOST'])) {
                $getHost = explode(".", $_SERVER['HTTP_HOST']);
                $domain = array_shift($getHost);
            }
            $site_info = GlobalSiteInfo::where('site_alias', $domain)->first();
            $site_id = $site_info->id;
            Session::put('SITE_ID', $site_id);
        }else{
            Session::put('SITE_ID', $request->site_id);
            $site_id = $request->site_id;
        }
        return $site_id;
    }


 

   public function getSiteStudentExamResult(Request $request){

    try{

    $site_id = $this->getSiteId($request);
    $data = $request->all();
    $data['site_id']=$site_id;
   // dd($site_id);

        $this->validate($request, [
            "academic_group_id" => "required",
            "academic_version_id" => "required",
            "academic_year_id" => "required",
            "academic_shift_id" => "required",
            "academic_class_id" => "required",
            "academic_result_primary_type_id" => "required",
            "student_roll_number" => "required",
        ]);

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->when($data['academic_class_group_id'], function($q) use ($request){
                $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when($data['academic_section_id'], function($q) use ($request){
                $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when($data['site_batch_detail_id'], function($q) use ($request){
                $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
            ->select('id','academic_version_id','academic_year_id','academic_shift_id','academic_class_id','academic_section_id','academic_class_group_id',
            'academic_session_id','site_batch_detail_id','academic_group_id')
            ->orderBy('id','DESC')
            ->first();

          

        $student_ids=[$studentHistory->id];

        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;
    
        $resultPdf=$this->primaryResultTypeBaseResultDetails($data,$student_ids,'site_public');

         if($resultPdf['status']==200){
            $data=[
                'student_exam_result'=>$resultPdf['result_array'],
                'mode'=>'success',
                'status'=>'200',
            ];

    
        }else{
            $data=['message' => $resultPdf['message'], 'status' => $resultPdf['status']];
        }

        return response()->json($data, 200);
        
    }catch (Exception $exception) {
        return Response::json(['message' => $exception->getMessage()], 410);
    }

   }

    

    public function getStudentExamResulDetailsPdf(Request $request){

        try{

        $this->validate($request, [
        "academic_group_id" => "required",
        "academic_version_id" => "required",
        "academic_year_id" => "required",
        "academic_shift_id" => "required",
        "academic_class_id" => "required",
        "academic_result_primary_type_id" => "required",
        "student_roll_number" => "required",
    ]);

        $site_id = $this->getSiteId($request);
        $data=[];
        $data = $request->all();
        $data['site_batch_detail_id']='';
        $data['site_id']=$site_id;

         $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->when($data['academic_class_group_id'], function($q) use ($request){
            $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when($data['academic_section_id'], function($q) use ($request){
            $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when($data['site_batch_detail_id'], function($q) use ($request){
            $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
             ->select('id','site_id','student_roll_number')
            ->orderBy('id','DESC')
            ->first();



        if(!$studentHistory){
           return Response::json(['message' => 'Student not found','status'=> 410]);
        }
        $data['academic_group_id']=$request->academic_group_id;

        $student_ids=[$studentHistory->id];

        $resultPdf=$this->studentResulDetailsPdf($data,$student_ids,'site_public');

        if($resultPdf['status']==200){

          //  return $resultPdf['stream_pdf'];
            return Response::json([
                'link' => route('open-pdf-file-storage-for-public', [$resultPdf['file_name']]),
                'message' => 'Successfully Created Card Report',
              //  'status'=> $resultPdf['status']
            ]);
        }else{
            return Response::json(['message' => 'Failed to Create Card Report','status'=> $resultPdf['status']]);
        }



        
    //     $primaryResultList =  $this->getSiteStudentAndPrimaryResultTypeBaseResultDetail($request);
    //     $result_list_array=$primaryResultList[0];
    //     $result_system_list=$primaryResultList[1];


    //     //============ domain name =============
    //     $site_info =  GlobalSiteInfo::find(Session::get('SITE_ID'));
        
    //     $domain = $site_info->site_alias;

    //     if($site_info->domain_name==null){
    //         $alias = $site_info->site_alias;
    //         $url = config('app.url');
    //         $parsedUrl = parse_url($url);
    //         $host = $parsedUrl['host'];
    //         $host_names = explode(".", $host);
    //         $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];

    //         if ($host_names[count($host_names) - 1] == 'bd') {
    //             $bottom_host_name = $host_names[count($host_names) - 2] . "." . $host_names[count($host_names) - 1];
    //         }
    //         if (count($host_names) == 2) {
    //             $bottom_host_name = $host_names[count($host_names) - 1];
    //         }
    //         $domain = $parsedUrl['scheme'] . '://' . $alias . '.' . $bottom_host_name;
        
    //     }else{
    //         $domain = $site_info->domain_name;
    //     }
        
    //     // result settings 
    //     $site_id = $this->getSiteId($request);

    //     $resultSetting=GlobalSiteExamResultReportSetting::where('site_id', $site_id)->first();
    //     if(!$resultSetting){
    //         $resultSetting=[
    //         'sheet_no'=>'one',
    //         'site_address_show_status'=>true,
    //         'exam_type_show_status'=>true,
    //         'std_image_show_status'=>true,
    //         'qrcode_show_status'=>true,
    //         'countable_mark_show_status'=>false,
    //         'row_mark_show_status'=>false,
    //         'mark_percentage_show_status'=>true,
    //         'academic_perform_show_status'=>true,
    //         'behaviour_show_status'=>true,
    //         'curriculam_activities_show_status'=>true,
    //         'merit_list_show_status'=>true,
    //         'head_signature_show_status'=>'',
    //         'left_designation'=>null,
    //         'center_designation'=>null,
    //         'right_designation'=>'Institute Head',
    //     ];
    //     }
    //     //===========
    //         ////////////////
    //         if ($resultSetting['sheet_no'] == 'two') {

    //             if ($request->page_orientaion == 'portrate') {
    //                 $pdf = PDF::loadView(
    //                     'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-two',
    //                     compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
    //                 )
    //                     ->setWarnings(false);
    //             } else if ($request->page_orientaion == 'landscape') {
    //                 $pdf = PDF::loadView(
    //                     'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
    //                     compact(
    //                         'result_list_array',
    //                         'report_tittle',
    //                         'report_tittle2',
    //                         'result_system_list',
    //                         'domain',
    //                         'resultSetting',
    //                         'site_info'
    //                     )
    //                 )
    //                     ->setPaper('a4', 'landscape')->setWarnings(false);
    //             }
    //         } elseif ($resultSetting['sheet_no'] == 'three') {
    //             // if($request->page_orientaion=='portrate'){
    //             $pdf = PDF::loadView(
    //                 'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-three',
    //                 compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
    //             )
    //                 ->setWarnings(false);
    //             // }
    //             // else if($request->page_orientaion=='landscape'){
    //             //     $pdf = PDF::loadView('default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report-two',
    //             //         compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain',
    //             //          'resultSetting','site_info'))
    //             //         ->setPaper('a4', 'landscape')->setWarnings(false);
    //             // }

    //         }elseif ($resultSetting['sheet_no'] == 'four'){
    //             if ($request->page_orientaion == 'portrate') {
    //                 $pdf = PDF::loadView(
    //                     'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report-four',
    //                     compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
    //                 )
    //                     ->setWarnings(false);
    //             } else if ($request->page_orientaion == 'landscape') {
    //                 $pdf = PDF::loadView(
    //                     'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
    //                     compact(
    //                         'result_list_array',
    //                         'report_tittle',
    //                         'report_tittle2',
    //                         'result_system_list',
    //                         'domain',
    //                         'resultSetting',
    //                         'site_info'
    //                     )
    //                 )
    //                     ->setPaper('a4', 'landscape')->setWarnings(false);
    //             }
    //         } else {

    //             if ($request->page_orientaion == 'portrate') {
    //                 $pdf = PDF::loadView(
    //                     'default.admin.site.result.result_report.site-base-multiple-student-result-detail-report',
    //                     compact('result_list_array', 'report_tittle', 'report_tittle2', 'result_system_list', 'domain', 'resultSetting', 'site_info')
    //                 )
    //                     ->setWarnings(false);
    //             } else if ($request->page_orientaion == 'landscape') {
    //                 $pdf = PDF::loadView(
    //                     'default.admin.site.result.result_report.site-base-landscape-multiple-student-result-detail-report',
    //                     compact(
    //                         'result_list_array',
    //                         'report_tittle',
    //                         'report_tittle2',
    //                         'result_system_list',
    //                         'domain',
    //                         'resultSetting',
    //                         'site_info'
    //                     )
    //                 )
    //                     ->setPaper('a4', 'landscape')->setWarnings(false);
    //             }
    //         }
    //         ////////////////
        
        
        
    //     $path = storage_path() . '/pdf';

    // //   dd($path);
    //     // $time = \Auth::user()->id . '-' . Carbon::now()->unix();
    //     $random=rand(0,100000);
    //     $time = $random. '-' . Carbon::now()->unix();
    //     $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
    //     $name = $time . '.pdf';


    //     return Response::json(['link' => route('open-pdf-file-storage-for-public', [$name]),
    //         'message' => 'Successfully Created Card Report'], 200);

            
        }catch (Exception $exception) {
        return Response::json(['message' => $exception->getMessage()], 410);
     }
    }

    
    private function getSiteStudentAndPrimaryResultTypeBaseResultDetail($request){

    
        $data = $request->all();
        //dd($data);
    

        $site_id = $this->getSiteId($request);
        //$site_id = $site_list->id;
    
        $student_ids=[$request->student_history_id];
        $studentHistoryIds=GlobalStudentHistory::with('site')
        ->where('site_id', $site_id)
        ->where('academic_group_id', $request->academic_group_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_shift_id', $request->academic_shift_id)
        ->where('academic_class_id', $request->academic_class_id)
        //   ->where('student_roll_number', $request->student_roll_number)
        ->when($data['academic_class_group_id'], function($q) use ($request){
            $q->where('academic_class_group_id', $request->academic_class_group_id);
        })
        //  ->when($data['academic_section_id'], function($q) use ($request){
        //     $q->where('academic_section_id', $request->academic_section_id);
        //  })
        ->when($data['site_batch_detail_id'], function($q) use ($request){
            $q->where('site_batch_detail_id', $request->site_batch_detail_id);
        })
        ->where('status', true)
        ->select('id','site_id','student_roll_number')
        ->pluck('id')
        ->unique()
        ->filter();
        //  $studentHistoryIds=$studentHistoryList->pluck('id')->unique()->filter();
        //   $studentHistory=$studentHistoryList->where('student_roll_number', $request->student_roll_number)->first();
    
        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('academic_group_id', $request->academic_group_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('student_roll_number', $request->student_roll_number)
            ->when($data['academic_class_group_id'], function($q) use ($request){
                $q->where('academic_class_group_id', $request->academic_class_group_id);
            })
            ->when($data['academic_section_id'], function($q) use ($request){
                $q->where('academic_section_id', $request->academic_section_id);
            })
            ->when($data['site_batch_detail_id'], function($q) use ($request){
                $q->where('site_batch_detail_id', $request->site_batch_detail_id);
            })
            ->select('id','site_id','student_roll_number')
            ->first();
        if($studentHistory){
            $dataaa=SiteStudentPrimaryResultDetail::with(['studentHistory'=>function ($query) {
                $query->select('id', 'user_id', 'academic_shift_id', 'academic_class_id', 'academic_department_id',
                    'academic_session_id', 'academic_student_category_id', 'board_registration_number',
                    'academic_class_group_id', 'academic_section_id', 'academic_year_id', 'student_roll_number',
                    'registration_no');
                $query->with(['student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id','date_of_birth');
                    $q->where('user_type', 'student');
                },
                'site','year', 'shift','department','stClass','classGroup','session','section'
                ]);
            }, 'academicResultPrimaryType'])
            ->where('student_history_id', $studentHistory->id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('result_public_publish_status', true)
            ->where('result_public_full_publish_status', true)
            ->where('status', true)
            ->get();

        //   dd(count($dataaa));
            
            
                if(count($dataaa)<=0){
                    return response()->json(['message'=>'Result Not Found','status'=>false],422);
                }

        }else{
        return response()->json(['message'=>'Student Not Found','status'=>false],422);
        }

            // Employee
            $institute_head = Employee::where('institute_head', 1)->first();
            $site_info =  GlobalSiteInfo::find(Session::get('SITE_ID'));
    
            $get_signature = $institute_head->signature ?? '/img/signature/signature.png';
            $get_designation = $institute_head->designation->name ?? 'Institution Head';

        $hight_marks_ids=SiteIndividualCombineSubjectResultStore::
        where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id',$studentHistoryIds)
            ->where('status', true)
            ->pluck('exam_dependent_academic_subject_id')->unique()->filter();
    
        $hight_marks_list=[];
        foreach ($hight_marks_ids as $key => $value){
            $hight_marks_subject=SiteIndividualCombineSubjectResultStore::
            where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $studentHistoryIds)
                ->where('exam_dependent_academic_subject_id', $value)
                ->where('status', true)
                ->orderBy('obtain_raw_total_marks', 'desc')
                ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks','obtain_total_marks_for_show')
                ->first();

            if($hight_marks_subject){
                $hight_marks_list[]=$hight_marks_subject;
            }

        }
    
        $a_arr=Array();
        $a_array=[];
    // dd($dataaa);
        foreach ($dataaa as $key => $value){
        
            $b_array=[];
            foreach ($value->site_individual_combine_subject_result_store_ids as $keyt => $valuet){
                $b_array[]=$valuet->subject_detail;
            }

            $subject_ids=collect($b_array)->pluck('exam_dependent_academic_subject_id')->unique();
            $result_show_in_table_bellow_status_present=collect($b_array)->pluck('result_show_in_table_bellow_status')->unique()->filter();
        
            $highest_marks_list=collect($hight_marks_list)->whereIn('exam_dependent_academic_subject_id', $subject_ids);
        // dd($highest_marks_list);
        //  $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
        //  $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
        $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
            $a_arr['student_history_id']=$value->student_history_id;
            $a_arr['fail_subject_count']=$value->fail_subject_count;
            $a_arr['gpa']=$value->gpa;
            $a_arr['grade']=$value->grade;
            $a_arr['student_rank']=$value->student_rank;
            $a_arr['site_result_primary_setting_id']=$value->site_result_primary_setting_id;
            $a_arr['academic_result_primary_type_id']=$value->academic_result_primary_type_id;
            $a_arr['subject_list']=$b_array;
        //   dd($b_array);
            $a_arr['table_header']=$value->table_header;
            $a_arr['highest_marks']=$highest_marks_list;
            $a_arr['student_history']=$value->studentHistory;
            
            $a_arr['total_student']=count($studentHistoryIds);

            $a_arr['student_photo']=$value->studentHistory->student->latestPhoto?
                $value->studentHistory->student->latestPhoto->name:'image-not.png';

            $a_arr['result_show_in_table_bellow_status_present']=count($result_show_in_table_bellow_status_present)>0?1:0;
    
            $a_arr['result_type_name']=$value->academicResultPrimaryType->name;
            $a_arr['result_type_id']=$value->academicResultPrimaryType->id;

            $a_arr['classtest_is_present']=$value->classtest_is_present;
            $a_arr['combine_subject_present']=$value->combine_subject_present;
            $a_arr['final_grade_without_optional']=$value->final_grade_without_optional;
            $a_arr['final_point_without_optional']=$value->final_point_without_optional;
            $a_arr['id']=$value->id;
            $a_arr['raw_obtain_marks_percentage']=number_format((float)$value->raw_obtain_marks_percentage, 2, '.', '');
            $a_arr['sum_of_obtain_percent_total_marks']=$value->sum_of_obtain_percent_total_marks;
            $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_raw_total_marks']=$value->sum_of_raw_total_marks;
            $a_arr['sum_of_obtain_total_marks_for_show']=$value->sum_of_obtain_total_marks_for_show;
            //  $a_arr['sum_of_obtain_raw_total_marks']=$value->sum_of_obtain_raw_total_marks;
            $a_arr['sum_of_obtain_total_percent_for_show']=$value->sum_of_obtain_total_percent_for_show;
            //$a_arr['obtain_total_marks_for_show']=$value->obtain_total_marks_for_show;

            $a_arr['institute_head_teacher_signature']=$get_signature;
            $a_arr['institute_head_teacher_designation']=$get_designation;
            $a_arr['address']=$site_info->site_name;

            $a_arr['academic_days']=$value->academic_days;
            $a_arr['present_days']=$value->present_days;
            $a_arr['absent_days']=$value->absent_days;
            $a_arr['behaviour']=$value->behaviour;
            $a_arr['cultural_activities']=$value->cultural_activities;
            $a_arr['bncc']=$value->bncc;
            $a_arr['debate']=$value->bncc;
            $a_arr['scout']=$value->scout;
            $a_arr['sports']=$value->sports;
            $a_arr['others']=$value->others;

            $a_array[$key]=array_merge($a_arr);
        //   $final_array[$key]=array_merge($a_arr);
        }

    
    $siteResultSystemSettingPresent=GlobalSiteResultSystemSetting::with(['academicResultSystem'])
        ->where('site_id', $site_id)
        ->where('academic_group_id', $request->academic_group_id)
        ->where('academic_year_id', $request->academic_year_id)
        ->where('academic_version_id', $request->academic_version_id)
        ->where('academic_class_id', $request->academic_class_id)
        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
            return $query->where('academic_department_id', $data['academic_department_id']);
        })
        ->where('status',true)
        ->get()
        ->sortBy(function ($item) {
            return $item->academicResultSystem->serial ?? 0;
        });

    return [$a_array, $siteResultSystemSettingPresent];

    }


    public function getStudentAllHistoryListForApi(Request $request){
         
        if($request->student_username){
            $site_id=$this->getSiteId($request);
            $user=GlobalUser::where('username',$request->student_username)->where('site_id',$site_id)->where('status',true)->select('id')->first();

            if (!$user) {
                return Response::json(['message' => 'Student Not Found!'], 411);
            }

            $student_histories=GlobalStudentHistory::where('user_id',$user->id)
                ->with(['department','stClass', 'shift', 'classGroup', 'section', 'session'])
                 ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix', 'academic_department_id', 'academic_class_id', 'academic_shift_id',
                     'academic_class_group_id', 'academic_section_id', 'academic_session_id')
                ->get();

            $student_history_array=[];
            foreach($student_histories as $key=>$history){
                $student_history_array[$key]['id']=$history->id;
                $student_history_array[$key]['class_id']=$history->stClass?$history->stClass->id:null;
                $student_history_array[$key]['class_name']=$history->stClass?$history->stClass->class_name:'';
                $student_history_array[$key]['group_id']=$history->classGroup?$history->classGroup->id:null;
                $student_history_array[$key]['group_name']=$history->classGroup?$history->classGroup->group_name:'';
                $student_history_array[$key]['session_id']=$history->session?$history->session->id:null;
                $student_history_array[$key]['session_name']=$history->session?$history->session->session_name:'';
                $student_history_array[$key]['section_id']=$history->section?$history->section->id:null;
                $student_history_array[$key]['section_name']=$history->section?$history->section->section_name:'';
                $student_history_array[$key]['roll']=$history->student_full_roll_number;
            }

        $data=['student_history_list'=>$student_history_array,'mode'=>'success','status'=>'200'];

        return response()->json($data,200);


        }
    
    }


    public function getStudentPrimaryResultListByStudentHistory(Request $request){
         $site_id = $this->getSiteId($request);

        $data = $request->all();

        $studentHistory=GlobalStudentHistory::where('id', $data['student_history_id'])
            ->select('academic_version_id', 'academic_year_id', 'academic_shift_id', 'academic_class_id',
                'academic_section_id', 'academic_class_group_id', 'academic_session_id', 'site_batch_detail_id',
                'academic_group_id')
            ->first();

        $data['site_id']=$site_id;
        $data['academic_group_id']=$studentHistory->academic_group_id;


        $checkGroupPermission=GlobalSiteGroupResultPermission::where('academic_year_id',$studentHistory->academic_year_id)
            ->where('academic_class_id',$studentHistory->academic_class_id)
            ->where('site_id',$data['site_id'])
            ->where('academic_group_id',$data['academic_group_id'])
            ->where('public_result_permission_status', true)
            ->pluck('academic_result_primary_type_id');

        $primary_exam_type_ids = GlobalSiteStudentPrimaryResultDetail::where('student_history_id', $request->student_history_id)
            ->where(function ($query) use ($checkGroupPermission) {
                $query->where(function ($q) {
                    $q->where('result_generated_by', 'site')
                    ->where('result_student_publish_status', true);
                })->orWhere(function ($q) use ($checkGroupPermission) {
                    $q->where('result_generated_by', 'site_group')
                    ->whereIn('academic_result_primary_type_id', $checkGroupPermission);
                });
            })
            ->where('site_id', $site_id)
            ->pluck('academic_result_primary_type_id')
            ->unique()
            ->filter();

        $result_primary_type_list=AcademicResultPrimaryType::whereIn('id', $primary_exam_type_ids)->where('use_key','site')->get();

        $modifiedList = $result_primary_type_list->map(function ($item) {
            if ($item->use_key === 'site_group') {
                $item->examination_name = $item->examination_name. '(Central Result)';
            }

            return $item;
        });



        $data=['result_primary_type_list'=>$modifiedList,'mode'=>'success','status'=>'200'];

        return $data;

    }


    public function getStudentPrimaryResultByStudentHistory(Request $request){
        
        $site_id = $this->getSiteId($request);

        $data=[];
        $data = $request->all();
        $data['site_id']=$site_id;

        $this->validate($request, [
           // "student_username" => "required",
            "student_history_id" => "required",
            "academic_result_primary_type_id" => "required",
           
        ]);

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('id', $request->student_history_id)
         //   ->select('id','site_id',)
            ->orderBy('id','DESC')
            ->first();
        $student_ids=[$studentHistory->id];
  
        $data['academic_group_id']=$studentHistory->academic_group_id;
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;


        $resultDetails=$this->primaryResultTypeBaseResultDetails($data,$student_ids,'site_public');

        
        if($resultDetails['status']==200){
            return $resultDetails['result_array'];
        }else{
            return response()->json(['message' => $resultDetails['message'], 'status' => $resultDetails['status']], 200);
        }
  
    }

    
   public function getStudentPrimaryResultPDFByStudentHistory(Request $request){

        $site_id = $this->getSiteId($request);

        $data=[];
        $data = $request->all();
        $data['site_id']=$site_id;

        $this->validate($request, [
           // "student_username" => "required",
            "student_history_id" => "required",
            "academic_result_primary_type_id" => "required",
           
        ]);

        $studentHistory=GlobalStudentHistory::with('site')
            ->where('site_id', $site_id)
            ->where('id', $request->student_history_id)
            ->orderBy('id','DESC')
            ->first();
        $student_ids=[$studentHistory->id];
  
        $data['academic_group_id']=$studentHistory->academic_group_id;
        $data['academic_version_id']=$studentHistory->academic_version_id;
        $data['academic_year_id']=$studentHistory->academic_year_id;
        $data['academic_shift_id']=$studentHistory->academic_shift_id;
        $data['academic_class_id']=$studentHistory->academic_class_id;
        $data['academic_section_id']=$studentHistory->academic_section_id;
        $data['academic_class_group_id']=$studentHistory->academic_class_group_id;
        $data['academic_session_id']=$studentHistory->academic_session_id;
        $data['site_batch_detail_id']=$studentHistory->site_batch_detail_id;
    
        $resultPdf=$this->studentResulDetailsPdf($data,$student_ids,'site_public');

        if($resultPdf['status']==200){

        return  Response::json([
            'link' => route('open-pdf-file-storage-for-public', [$resultPdf['file_name']]),
            'message' => 'Successfully Created Card Report',
            'status'=> $resultPdf['status']
            ]);

           

        //     $data=[
        //         'link' => route('open-pdf-file-storage-for-public', [$resultPdf['file_name']]),
        //         'stream_pdf' => base64_encode($resultPdf['stream_pdf']),
        //         'message' => 'Successfully Created Card Report',
        //         'status'=> $resultPdf['status']
        //     ];
        // return response()->json($data, 200, [], JSON_PARTIAL_OUTPUT_ON_ERROR);

        }else{
            return Response::json([
                'message' => 'Failed to Create Card Report',
                'status'=> $resultPdf['status']
            ]);
        }
      
        
   }




}
