<?php

namespace App\Http\Controllers\AcademicAll;

use App\Forms\AcademicClassForm;
use App\Http\Controllers\Controller;
use App\Forms\DataHelper;
use App\Forms\FormControll;
use App\Http\Controllers\Language\Lang;
use App\Http\Controllers\ProjectController;
use App\Http\Requests\Validator;
use App\Models\Academic\AcademicSessionType;
use App\Models\User\User;
use DB;
use Illuminate\Http\Request;
use App\Http\Requests;
use Response;

class AcademicSessionTypeController extends Controller
{

    use Lang, FormControll, DataHelper;


    private $academicsessiontype;

    /**
     * @param Subject $subject
     */
    public function __construct(AcademicSessionType $academicsessiontype)
    {

        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');

        $this->academicsessiontype = $academicsessiontype;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Academic Session Type List';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.academic-session-type.sessio-type-list', compact('viewType'));

    }


    public function getAcademicSessionTypeList()
    {
        $list = $this->academicsessiontype->paginate(20);
        return $list;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'session_name'=>'required|unique:academic_session_types'

        ]);

        $this->academicsessiontype->create([
            'session_name'=>$request->get('session_name'),
            'status'=>$request->get('status'),
        ]);

        return Response::json(['message' => 'Session Type Successfully Created!']);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'session_name' => 'required|unique:academic_session_types,id,' . $id,
            'status' => 'required|in:0,1'
        ]);

        $academicSessionType = $this->academicsessiontype->findOrFail($id);

        $academicSessionType->update([
            'session_name' => $request->get('session_name'),
            'status' => $request->get('status'),
        ]);

        return Response::json(['message' => 'Academic Session Type Successfully Updated!']);
        //return Response::json(['message' => 'Session Type Successfully Created!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
