<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicSection;
use App\Models\Site\SiteShiftClassGroupSectionSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Response;
use Session;

class AcademicSectionController extends Controller
{
    private $academicSection, $classGroupSectionSetting;

    public function __construct(AcademicSection $academicSection, SiteShiftClassGroupSectionSetting $classGroupSectionSetting)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicSection = $academicSection;
        $this->classGroupSectionSetting = $classGroupSectionSetting;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType ='Academic Section List';
        return view('default.admin.academic-section.section-list',compact('viewType'));
    }

//    public function getAcademicClassSectionList($id){
//
//        $accSection = $this->academicSection->where('id', $id);
//        return $accSection;
//
//    }

    public function getAcademicClassSectionList($id){

        $classGroupSectionSettingList = $this->classGroupSectionSetting->where('academic_shift_id', 1)->where('academic_class_id', $id)->first();

        $sectionList = $classGroupSectionSettingList->academic_section_ids;

        //return $sectionList;
        $sectionArrayList = explode(',', $sectionList);

        $academic_sectionList = new AcademicSection();
        //return $academic_sectionList;

        $dfd = $academic_sectionList->whereIn('id', $sectionArrayList)->get();

        return $dfd;


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'section_name'=>'required|unique:academic_sections'
        ]);



        AcademicSection::create([
            'section_name' => $request->section_name
        ]);


        return Response::json(['message' => 'Section Successfully Created!']);


    }






    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function getAcademicSubjectList(){
        $list=AcademicSection::paginate();

        return $list;
    }

}
