<?php

namespace App\Http\Controllers\AcademicAll;

use App\Models\Academic\AcademicFee;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicResidence;
use App\Models\Academic\AcademicTransport;
use App\Models\Gender\Gender;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\SiteInfo;
use Session;
use Response;


class AcademicFeeSubHeadController extends Controller
{
    private $academicFeeSubHead;
    private $feeSubHeadAllocation;

    public function __construct(AcademicFeeSubHead $academicFeeSubHead, SiteStudentFeeSubHeadAllocation $feeSubHeadAllocation)
    {
        $this->middleware('auth');
        $this->middleware('eduworlduserchecker');
        $this->academicFeeSubHead = $academicFeeSubHead;
        $this->feeSubHeadAllocation = $feeSubHeadAllocation;

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $viewType = 'Fee Head List';
        return view('default.admin.layouts.master', compact('viewType'));
        return view('default.admin.academic-fee-sub-head.view', compact('viewType'));
    }



    public function getFeeSubHeadList()
    {
        $feeSubHeads = new AcademicFeeSubHead();
        $feeSubHeadList = $feeSubHeads->get();

        return $feeSubHeadList;
    }

    public function getTransportList()
    {
        $accTransport = new AcademicTransport();
        $accTransportList = $accTransport->get();

        return $accTransportList;
    }

    public function getResidenceList()
    {
        $acadResidance = new AcademicResidence();
        $acadResidanceList = $acadResidance->get();

        return $acadResidanceList;
    }

    public function getGenderList()
    {
        $gender = new Gender();
        $genderList = $gender->get();

        return $genderList;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate([
            'name' => 'required|unique:academic_fee_sub_heads',
        ]);
        if ($request->subHeadType == null ){
            return Response::json(['message' => 'Select Sub Head Type Field!'], 411);
        }
        if ($request->subHeadType != null && $request->name != null || $request->academicTransportData != null ||  $request->academicResidanceData != null || $request->genderData != null  ){
            $feeSubHeads= new AcademicFeeSubHead();
            $feeSubHeads->name = $request->name;
            $feeSubHeads->status = $request->status;
            $feeSubHeads->head_key = $request->subHeadType;

            if ($request->academicTransportData != null){
                $feeSubHeads->head_key_base_id = $request->academicTransportData;
            }elseif ($request->academicResidanceData != null){
                $feeSubHeads->head_key_base_id = $request->academicResidanceData;
            }elseif ($request->genderData != null){
                $feeSubHeads->head_key_base_id = $request->genderData;
            }else{

                $accFeeSubHead = AcademicFeeSubHead::where('head_key', 'general')->orderBy('id','desc')->first();
                $feeSubHeads->head_key_base_id = $accFeeSubHead->head_key_base_id + 1;
            }
         //   $feeSubHeads->save();
       if ($feeSubHeads->save()){
           return ['message' => 'Successfully Saved!'];

       }
         //   return ['message' => 'Successfully Saved!'];
        }else{
            return Response::json(['message' => 'Select * Marked Field!'], 411);

        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name'=>'required|unique:academic_fee_sub_heads,name,'.$id,
        ]);
        $feeSubHeadsUpdate = $this->academicFeeSubHead->findOrFail($id);
        $feeSubHeadsUpdate->update([
            'name'=>$request->get('name'),
            'status'=>$request->get('status'),
            'head_key'=>$request->get('subHeadType'),
        ]);

        return ['message' => 'Successfully Updated!'];
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $feeSubHeadsDelete = $this->academicFeeSubHead->findOrFail($id);

        $feeSubHeadsDelete->delete();
        return ['message' => 'Successfully Deleted!'];
    }
}
